<?php
/**
 * Class TransStrings
 *
 * This class is used to manage translation strings for the application.
 *
 * @package Mint\MRM\Utilities\Helper\TranslationString
 * @namespace Mint\MRM\Utilities\Helper\TranslationString
 * @author [WPFunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2024-03-11 11:03:17
 * @modify date 2024-03-11 11:03:17
 */

namespace Mint\MRM\Utilities\Helper\TranslationString;

/**
 * Class TransStrings
 * This class is used to manage translation strings for the application.
 * It provides a method to get all the translation strings used in the application.
 *
 * @since 1.9.0
 */
class TransStrings
{
	public static function getStrings()
	{
		return array(
			'Dashboard' => __('Dashboard', 'mrm'),
			'All'       => __('All', 'mrm'),
			'Weekly'    => __('Weekly', 'mrm'),
			'Monthly'   => __('Monthly', 'mrm'),
			'Yearly'    => __('Yearly', 'mrm'),
			'Contacts' => __('Contacts', 'mrm'),
			'Campaigns' => __('Campaigns', 'mrm'),
			'Automations' => __('Automations', 'mrm'),
			'Forms' => __('Forms', 'mrm'),
			'AddContact' => __('Add contacts', 'mrm'),
			'AddCampaign' => __('Add campaign', 'mrm'),
			'AddForm' => __('Add form', 'mrm'),
			'AddAutomation' => __('Add automation', 'mrm'),
			'Subscriber' => __('Subscriber', 'mrm'),
			'Revenue' => __('Revenue', 'mrm'),
			'Campaign' => __('Campaign', 'mrm'),
			'Automation' => __('Automation', 'mrm'),
			'Existing' => __('Existing', 'mrm'),
			'New' => __('New', 'mrm'),
			'Running' => __('Running', 'mrm'),
			'Completed' => __('Completed', 'mrm'),
			'ViewMore' => __('View More', 'mrm'),
			'Name' => __('Name', 'mrm'),
			'Recipients' => __('Recipients', 'mrm'),
			'Unsubscribed' => __('Unsubscribed', 'mrm'),
			'Subscribed' => __('Subscribed', 'mrm'),
			'Pending' => __('Pending', 'mrm'),
			'Bounced' => __('Bounced', 'mrm'),
			'Complained' => __('Complained', 'mrm'),
			'ClickRate' => __('Click rate', 'mrm'),
			'OpenRate' => __('Open rate', 'mrm'),
			'NoDataFound' => __('No data Found', 'mrm'),
			'EmailCampaigns' => __('Email campaigns', 'mrm'),
			'NoContactAdded' => __('No contact added', 'mrm'),
			'PreviousCampaignsPerformance' => __('Previous campaigns performance', 'mrm'),
			'SubscribersGrowthRate' => __('Subscribers growth rate', 'mrm'),
			'Admin'       => __('Admin', 'mrm'),
			'SuperAdmin'  => __('Super Admin', 'mrm'),
			'Subscriber'  => __('Subscriber', 'mrm'),
			'Editor'      => __('Editor', 'mrm'),
			'Author'      => __('Author', 'mrm'),

			// Contact Module
			'Export' => __('Export', 'mrm'),
			'Import' => __('Import', 'mrm'),
			'NewContact' => __('New contact', 'mrm'),
			'TotalContacts' => __('Total Contacts', 'mrm'),
			'pro' => __('pro', 'mrm'),
			'Lists' => __('Lists', 'mrm'),
			'Tags' => __('Tags', 'mrm'),
			'UpdateFields' => __('Update Fields', 'mrm'),
			'Status' => __('Status', 'mrm'),
			'Segments' => __('Segments', 'mrm'),
			'EmailTemplates' => __('Email Templates', 'mrm'),
			'Recoverable' => __('Recoverable', 'mrm'),
			'Recovered' => __('Recovered', 'mrm'),
			'Lost' => __('Lost', 'mrm'),
			'CHOOSELIST' => __('CHOOSE LIST', 'mrm'),
			'ChooseAutomation' => __('Choose Automation', 'mrm'),
			'EndAutomation' => __('End Automation', 'mrm'),
			'CHOOSETAG' => __('CHOOSE TAG', 'mrm'),
			'CHOOSEStatus' => __('CHOOSE Status', 'mrm'),
			'NoDataFound' => __('No Data Found', 'mrm'),
			'Search' => __('Search...', 'mrm'),
			'AddToListS' => __('Add to list(s)', 'mrm'),
			'AssignTagS' => __('Assign tag(s)', 'mrm'),
			'RemoveFromListS' => __('Remove from list(s)', 'mrm'),
			'RemoveTagS' => __('Remove tag(s)', 'mrm'),
			'TriggerAutomation' => __('Trigger Automation', 'mrm'),
			'AssignToStatus' => __('Assign to status', 'mrm'),
			'SendDoubleOptin' => __('Send double optin', 'mrm'),
			'ExportContact' => __('Export contact', 'mrm'),
			'DeleteSelected' => __('Delete selected', 'mrm'),
			'ClearAll' => __('Clear All', 'mrm'),
			'AddColumn' => __('Add Column', 'mrm'),
			'NoColumnFound' => __('No Column Found', 'mrm'),
			'Cancel' => __('Cancel', 'mrm'),
			'Save' => __('Save', 'mrm'),
			'Refresh' => __('Refresh', 'mrm'),
			'NoItemFound' => __('No item found', 'mrm'),
			'NoContactDataFound' => __('No contact data found', 'mrm'),
			'ConfirmProceedingWithDoubleOptin' => __('Confirm proceeding with double optin?', 'mrm'),
			'CreateOrFind' => __('Create or find', 'mrm'),
			'Add' => __('Add', 'mrm'),
			'Remove' => __('Remove', 'mrm'),
			'UnlockWithPremium' => __('Unlock With Premium', 'mrm'),
			'UpgradeToPRONow' => __('Upgrade To PRO Now', 'mrm'),
			'FileNameIsRequiredForExportingData' => __('File name is required for exporting data.', 'mrm'),
			'ExportContacts' => __('Export Contacts', 'mrm'),
			'Name' => __('Name', 'mrm'),
			'EnterFileName"' => __('Enter file name', 'mrm'),
			'PleaseSelectFieldsThatYouWantToExport' => __('Please select fields that you want to export', 'mrm'),
			'SelectAllFields' => __('Select All Fields', 'mrm'),
			'Video' => __('Video', 'mrm'),
			'Documentation' => __('Documentation', 'mrm'),
			'SocialGroup' => __('Social Group', 'mrm'),
			'VideoTutorials' => __('Video Tutorials', 'mrm'),
			'YouTubeVideoPlayer' => __('YouTube video player', 'mrm'),
			'Yes' => __('Yes', 'mrm'),
			'No' => __('No', 'mrm'),
			'Ok' => __('Ok', 'mrm'),
			'Delete' => __('Delete', 'mrm'),
			'selected' => __('selected', 'mrm'),
			'items' => __('Items', 'mrm'),
			'View' => __('View', 'mrm'),
			'ChooseColumns' => __('Choose columns', 'mrm'),

			// Import Contacts Page
			'ImportContactPageTitle' => __('Import Contacts - Mail Mint', 'mrm'),
			'commaSeparated' => __('Comma Separated (,)', 'mrm'),
			'semicolonSeparated' => __('Semicolon Separated (;)', 'mrm'),
			'fileSelected' => __('File Selected.', 'mrm'),
			'fileFormateNotSupported' => __('File Format Not Supported.', 'mrm'),
			'uploadCSVFile' => __('Upload CSV File', 'mrm'),
			'csvDelimiter' => __('Choose Your CSV Delimiter', 'mrm'),
			'chooseCommaSeparator' => __('Choose Comma Separated Value or Semicolon Separated Value for your CSV Files', 'mrm'),
			'choose' => __('Choose', 'mrm'),
			'Uploaded' => __('Uploaded', 'mrm'),
			'changeCSV' => __('Change CSV', 'mrm'),
			'clickToUpload' => __('Click to upload', 'mrm'),
			'dragAndDropFile' => __(' or drag and drop your file', 'mrm'),
			'Next' => __('Next', 'mrm'),
			'Back' => __('Back', 'mrm'),
			'ImportContacts' => __('Import Contacts', 'mrm'),
			'PasteContactInfo' => __('Paste Contact Info', 'mrm'),
			'WordPressUsers' => __('WordPress users', 'mrm'),
			'importMailChimp' => __('Import from MailChimp', 'mrm'),
			'wooCommerceCustomers' => __('WooCommerce customers', 'mrm'),
			'fluentBooking' => __('Fluent Booking', 'mrm'),
			'mailPoet' => __('MailPoet', 'mrm'),
			'eddCustomers' => __('EDD customers', 'mrm'),
			'LearnDash' => __('LearnDash', 'mrm'),
			'TutorLMS' => __('Tutor LMS', 'mrm'),
			'MemberPress' => __('MemberPress', 'mrm'),
			'Imported' => __('Imported', 'mrm'),
			'Importing' => __('Importing', 'mrm'),
			'MemberPressUsersAsContacts' => __('MemberPress Users As Contacts', 'mrm'),
			'memberPressCSVTitle' => __('The following table is just a preview of how all of your MemberPress users will be mapped into Mail Mint Contacts.', 'mrm'),
			'NoUserFound' => __('No User Found', 'mrm'),
			'OtherContactSettings' => __('Other Contact Settings', 'mrm'),
			'SubscriptionStatus'   => __('Subscription Status', 'mrm'),
			'SelectUserRole'       => __('Select User Role', 'mrm'),
			'SelectStatus'         => __('Select Status', 'mrm'),
			'SelectLists'          => __('Select Lists', 'mrm'),
			'SelectTags' => __('Select Tags', 'mrm'),
			'SelectSegment' => __('Select Segment', 'mrm'),
			'checkboxLabelTextForStatus' => __('If the contact already exists and is in Pending status, send an opt-in confirmation email.', 'mrm'),
			'checkboxLabelTextForAutomationControl' => __('Do not trigger any Automation for these contacts.', 'mrm'),
			'checkboxLabelTextForUpdateExistingContact' => __('Do not update data for existing contacts.', 'mrm'),
			'SomethingWentWrong' => __('Something went wrong', 'mrm'),
			'ImportFromMemberpress' => __('Import from Memberpress', 'mrm'),
			'importMemberPressDescription' => __('Import your MemberPress members: selected membership levels or all members', 'mrm'),
			'ImportBy' => __('Import By', 'mrm'),
			'memberPressImportTooltip' => __('Choose whether to import contacts by membership levels or import all contacts..', 'mrm'),
			'ImportByMembershipLevels' => __('Import by Membership Levels', 'mrm'),
			'ImportAll' => __('Import All', 'mrm'),
			'selectMembershipLevels' => __('Select Membership Level(s)', 'mrm'),
			'importTutorLMSHeading' => __('Tutor LMS Users As Contacts', 'mrm'),
			'importTutorLMSCSVTitle' => __('The following table is just a preview of how all of your Tutor LMS users will be mapped into Mail Mint Contacts.', 'mrm'),
			'ImportFromTutorLMS' => __('Import from Tutor LMS', 'mrm'),
			'importTutorLMSTitle' => __('Import your Tutor LMS users: selected course or all users', 'mrm'),
			'importTutorLMSTooltip' => __('Choose whether to import users by course or import all users.', 'mrm'),
			'ImportByCourse' => __('Import by Course', 'mrm'),
			'SelectCourse' => __('Select Your Course(s)', 'mrm'),
			'importLearnDashHeading' => __('LearnDash Users As Contacts', 'mrm'),
			'importLearnDashDescription' => __('The following table is just a preview of how all of your LearnDash users will be mapped into Mail Mint Contacts.', 'mrm'),
			'ImportFromLearnDash' => __('Import from LearnDash', 'mrm'),
			'importLearnDashCSVTitle' => __('Import your LearnDash users: selected course or all users', 'mrm'),
			'ImportWordPress' => __('Import WordPress Users As Contacts', 'mrm'),
			'ImportWordpressCSVTitle' => __('Add users with specific roles from your site to the contacts list.', 'mrm'),
			'SelectUserRoles' => __('Select User Roles', 'mrm'),
			'SelectAllUserRoles' => __('Select all user roles', 'mrm'),
			'importEdd' => __('Import All EDD Customers As Contacts', 'mrm'),
			'importEddCSVTitle' => __('Map out your EDD customer data to contact fields and import them to your contacts list.', 'mrm'),
			'CustomerDataToImport' => __('Customer Data To Import', 'mrm'),
			'importEddTooltip' => __('These are your EDD customer data that will be imported.', 'mrm'),
			'MapTo' => __('Map to', 'mrm'),
			'MapToTooltipTitle'           => __('Choose from the existing fields you have for your contacts to map the customer data to.', 'mrm'),
			'noCustomerText'              => __('There are no customers available to import at the moment.', 'mrm'),
			'FBNoBookingUserText'         => __('There are no users available to import at the moment.', 'mrm'),
			'importWooCommerce'           => __('Import All WooCommerce Customers As Contacts', 'mrm'),
			'importFluentBooking'         => __('Import All Fluent Booking Users As Contacts', 'mrm'),
			'importWooCommerceCSVTitle'   => __('Map out your WooCommerce customer data to contact fields and import them to your contacts list.', 'mrm'),
			'importFluentBookingCSVTitle' => __('Map out your Fluent Booking user data to contact fields and import them to your contacts list.', 'mrm'),
			'importFluentBookingTooltip'  => __('These are your Fluent Booking customer data that will be imported.', 'mrm'),
			'importWooCommerceTooltip'    => __('These are your WooCommerce customer data that will be imported.', 'mrm'),
			'importWordPressTooltip'      => __('These are your WordPress user data that will be imported.', 'mrm'),
			'NoListIsSelected'            => __('No list is selected', 'mrm'),
			'ImportFromMailChimp'         => __('Import from MailChimp', 'mrm'),
			'importMailChimpTooltip'      => __('Please configure MailChimp with API key', 'mrm'),
			'importMailPoet'              => __('Import All MailPoet Subscribers As Contacts', 'mrm'),
			'importMailPoetCSVTitle'      => __('Map out your MailPoet subscribers data to contact fields and import them to your contacts list.', 'mrm'),
			'importMailPoetTooltip'       => __('These are your MailPoet subscribers data that will be imported.', 'mrm'),
			'MailChimpAPIKey'             => __('MailChimp API Key', 'mrm'),
			'Connect'                     => __('Connect', 'mrm'),
			'ChooseMailChimpList'         => __('Choose MailChimp List', 'mrm'),
			'PleaseIncludeAHeaderRowForThePastedData' => __('Please include a header row for the pasted data.', 'mrm'),
			'pastContactInfo' => __('Paste Contact Info To Import Contact', 'mrm'),
			'chooseDelimiter' => __('Choose Your Delimiter', 'mrm'),
			'delimiterTooltip' => __('Choose Comma Separated Value or Semicolon Separated Value on your paste data', 'mrm'),
			'exampleFormat' => __('Example Format:', 'mrm'),
			'FirstLineWillBeConsideredAsHeaders.' => __('First line will be considered as headers.', 'mrm'),
			'pastYourData' => __('Type or paste your data', 'mrm'),

			// Contact Details
			'EmailMandatoryMsg' => __('Email address is mandatory', 'mrm'),
			'EmailValidationMsg' => __('Enter a valid email address', 'mrm'),
			'LimitReached' => __('First name character limit exceeded 35 characters', 'mrm'),
			'LastNameLimitReached' => __('Last name character limit exceeded 35 characters', 'mrm'),
			'invalidData' => __('Some fields contain invalid data. The changes were not saved.', 'mrm'),
			'DeleteContact' => __('Delete Contact?', 'mrm'),
			'DeleteContactMsg' => __('Are you sure you want to delete this contact?', 'mrm'),
			'TagRemovedMsg' => __('The tag has been removed successfully.', 'mrm'),
			'ListRemovedMsg' => __('The list has been removed successfully.', 'mrm'),
			'Male' => __('Male', 'mrm'),
			'Female' => __('Female', 'mrm'),
			'Others' => __('Others', 'mrm'),
			'UploadMediaTitle' => __('Select or Upload Media', 'mrm'),
			'AddThisPhoto' => __('Add This Photo', 'mrm'),
			'Profile' => __('Profile', 'mrm'),
			'Emails' => __('Emails', 'mrm'),
			'PurchaseHistory' => __('Purchase History', 'mrm'),
			'FormSubmissions' => __('Form Submissions', 'mrm'),
			'Notes' => __('Notes', 'mrm'),
			'BasicInformation' => __('Basic Information', 'mrm'),
			'Address' => __('Address', 'mrm'),
			'Other' => __('Other', 'mrm'),
			'SelectGender' => __('Select Gender', 'mrm'),
			'SelectCountry' => __('Select Country', 'mrm'),
			'SelectState' => __('Select State', 'mrm'),
			'SelectTimezone' => __('Select Timezone', 'mrm'),
			'WooCommercePurchaseHistory' => __('WooCommerce Purchase History', 'mrm'),
			'EDDPurchaseHistory' => __('EDD Purchase History', 'mrm'),
			'Overview' => __('Overview', 'mrm'),
			'TotalOrders' => __('Total Orders (paid)', 'mrm'),
			'TotalSpent' => __('Total Spent', 'mrm'),
			'EmailOpenRate' => __('Email Open Rate', 'mrm'),
			'EmailClickRate' => __('Email Click Rate', 'mrm'),
			'TotalEmailSent' => __('Total Email Sent', 'mrm'),
			'TotalEmailOpened' => __('Total Email Opened', 'mrm'),
			'TotalEmailClicked' => __('Total Email Clicked', 'mrm'),
			'LastEmailOpened' => __('Last Email Opened', 'mrm'),
			'AddList' => __('Add List', 'mrm'),
			'List' => __('List', 'mrm'),
			'AddTag' => __('Add Tag', 'mrm'),
			'CustomerSummary' => __('Customer Summary', 'mrm'),
			'JoinedOn' => __('Joined on', 'mrm'),
			'LastOrder' => __('Last Order', 'mrm'),
			'Engagement' => __('Engagement', 'mrm'),
			'LastEmailSent' => __('Last Email Sent', 'mrm'),
			'LastOpened' => __('Last Opened', 'mrm'),
			'LastClicked' => __('Last Clicked', 'mrm'),
			'Purchases' => __('Purchases', 'mrm'),
			'OrderCount' => __('Order Count (paid)', 'mrm'),
			'LifetimeValue' => __('Lifetime Value', 'mrm'),
			'AOV' => __('AOV', 'mrm'),
			'Score' => __('Score', 'mrm'),
			'Untitled' => __('Untitled', 'mrm'),
			'SendDoubleOptinEmail' => __('Send Double Opt-in Email', 'mrm'),

			// Note Section of Contact Details
			'WriteANote' => __('Write a note', 'mrm'),
			'AddNote' => __('Add Note', 'mrm'),
			'UpdateNote' => __('Update Note', 'mrm'),
			'History' => __('History', 'mrm'),
			'NothingFound' => __('Nothing Found', 'mrm'),
			'DeleteNoteTitle' => __('Delete the Note?', 'mrm'),
			'DeleteNoteMsg' => __('Are you sure you want to delete the note?', 'mrm'),
			'wroteANote' => __('wrote a note', 'mrm'),
			'Edit' => __('Edit', 'mrm'),

			// Form Submission Tab of Contact Details
			'ID' => __('ID', 'mrm'),
			'FormTitle' => __('Form Title', 'mrm'),
			'SubmittedOn' => __('Submitted on', 'mrm'),
			'Action' => __('Action', 'mrm'),
			'NoSubmittedFormFound' => __('No Submitted Form Found', 'mrm'),
			'DeleteFormTitle' => __('Delete the Form?', 'mrm'),
			'DeleteFormMsg' => __('Are you sure you want to delete this form?', 'mrm'),

			// Purchase History Tab of Contact Details
			'OrderID' => __('Order ID', 'mrm'),
			'Date' => __('Date', 'mrm'),
			'Total' => __('Total', 'mrm'),
			'Products' => __('Products', 'mrm'),
			'NoPurchaseHistoryFound' => __('No Purchase History Found', 'mrm'),
			'ViewOrder' => __('View Order', 'mrm'),

			// Email Section Tab of Contact Details
			'DeleteMultiple' => __('Delete Multiple', 'mrm'),
			'DeleteEmailMsg' => __('Are you sure you want to delete these selected emails?', 'mrm'),
			'DeleteEmailTitle' => __('Delete Email?', 'mrm'),
			'DeleteEmailMsg2' => __('Are you sure you want to delete the selected email?', 'mrm'),
			'EmailSubMandatory' => __('Email Subject is Mandatory', 'mrm'),
			'EmailBodyMandatory' => __('Email Body is Mandatory', 'mrm'),
			'SendEmail' => __('Send Email', 'mrm'),
			'Subject' => __('Subject', 'mrm'),
			'NoEmailFound' => __('No email found', 'mrm'),
			'Send' => __('Send', 'mrm'),
			'Preview' => __('Preview', 'mrm'),

			// Segment
			'NewSegments' => __('New Segments', 'mrm'),
			'Description' => __('Description', 'mrm'),
			'ContactsInSegment' => __('Contacts in segment', 'mrm'),
			'DateCreated' => __('Created On', 'mrm'),
			'Contains' => __('Contains', 'mrm'),
			'DoesNotContain' => __('Does not contain', 'mrm'),
			'StartsWith' => __('Starts with', 'mrm'),
			'EndsWith' => __('Ends with', 'mrm'),
			'DoesNotStartWith' => __('Does not start with', 'mrm'),
			'DoesNotEndWith' => __('Does not end with', 'mrm'),
			'IsEqualTo' => __('Is equal to', 'mrm'),
			'IsNotEqualTo' => __('Is not equal to', 'mrm'),
			'Before' => __('Before', 'mrm'),
			'After' => __('After', 'mrm'),
			'InTheDate' => __('In the date', 'mrm'),
			'Between' => __('Between', 'mrm'),
			'GreaterThan' => __('Greater than', 'mrm'),
			'LessThan' => __('Less than', 'mrm'),
			'Equal' => __('Equal', 'mrm'),
			'DoesNotEqual' => __('Does not equal', 'mrm'),
			'IncludedIn' => __('Included in', 'mrm'),
			'NotIncludedIn' => __('Not included in', 'mrm'),
			'DoesNotEqualTo' => __('Does not equal to', 'mrm'),
			'SelectFieldType' => __('Select Field Type', 'mrm'),
			'SelectCondition' => __('Select Condition', 'mrm'),
			'SelectAction' => __('Select Action', 'mrm'),
			'ConditionWarningMsg' => __('Please fill all the conditions properly.', 'mrm'),
			'EditSegment' => __('Edit Segment', 'mrm'),
			'AddSegment' => __('Add Segment', 'mrm'),
			'SegmentName' => __('Segment Name', 'mrm'), // 'Name'
			'EnterName' => __('Enter name', 'mrm'),
			'EnterDescription' => __('Enter description', 'mrm'),
			'PreviewSegment' => __('Preview Segment', 'mrm'),
			'NoContactMsg' => __('No contact matches your condition(s)', 'mrm'),

			// Add New Contact Page
			'AddNewContact' => __('Add New Contact', 'mrm'),
			'SearchOrCreate' => __('Search or create', 'mrm'),
			'SelectAllItems' => __('Select All Items', 'mrm'),

			// List Page
			'NewList' => __('New List', 'mrm'),
			'CreateANewList' => __('Create A New List', 'mrm'),
			'UpdateList' => __('Update List', 'mrm'),
			'ListName' => __('List Name', 'mrm'),
			'Update' => __('Update', 'mrm'),
			'SortBy' => __('Sort By', 'mrm'),
			'ContactsInList' => __('Contacts In List', 'mrm'),
			'NoListFound' => __('No List Found ', 'mrm'),

			// Tag Page
			'NewTag' => __('New Tag', 'mrm'),
			'CreateANewTag' => __('Create A New Tag', 'mrm'),
			'UpdateTag' => __('Update Tag', 'mrm'),
			'TagName' => __('Tag Name', 'mrm'),
			'ContactsWithTag' => __('Contact With Tag', 'mrm'), // 'Contacts With Tag'

			// Campaign Listing Page
			'NewCampaign' => __('New Campaign', 'mrm'),
			'DuplicateCampaignUpdateMsg' => __('The campaign has been successfully duplicated.', 'mrm'),
			'CampaignModalTitle' => __('Create Your Next Email Marketing Campaign', 'mrm'),
			'RegularEmailCampaign' => __('Regular Email Campaign', 'mrm'),
			'CreateCampaign' => __('Create Campaign', 'mrm'),
			'EmailSequenceCampaign' => __('Email Sequence Campaign', 'mrm'),
			'CreateSequence' => __('Create Sequence', 'mrm'),
			'SequenceForAutomation' => __('Sequence for automation', 'mrm'),
			'PrepareSequence' => __('Prepare Sequence', 'mrm'),
			'AllTypes' => __('All Types', 'mrm'), // 'Types'
			'Regular' => __('Regular', 'mrm'),
			'Sequence' => __('Sequence', 'mrm'),
			'Recurring' => __('Recurring', 'mrm'),
			'AllStatus' => __('All Status', 'mrm'),
			'Draft' => __('Draft', 'mrm'),
			'Scheduled' => __('Scheduled', 'mrm'),
			'Suspended' => __('Suspended', 'mrm'),
			'Type' => __('Type', 'mrm'),
			'Unsubscribes' => __('Unsubscribes', 'mrm'),
			'CampaignDuplicating' => __('Campaign Duplicating...', 'mrm'),
			'ConfirmationOfSuspension' => __('Confirmation Of Suspension', 'mrm'),
			'ConfirmationSuspensionMsg' => __('Are you sure you want to suspend the campaign?', 'mrm'),
			'Confirm' => __('Confirm', 'mrm'),
			'Suspend' => __('Suspend', 'mrm'),
			'Duplicate' => __('Duplicate', 'mrm'),
			'Analytics' => __('Analytics', 'mrm'),
			'CampaignUrl' => __('Campaign Links', 'mrm'),

			// Add Campaign Page
			'CampaignTitleStringLimit' => __('Campaign title character limit reached 150 characters', 'mrm'),
			'DeleteEmailSequence' => __('Delete Email Sequence', 'mrm'),
			'DeleteEmailSequenceMsg' => __('Are you sure you want to delete the email?', 'mrm'),
			'EmailSubStringLimit' => __('Email subject character limit reached 190 characters.', 'mrm'),
			'EmailPreviewStringLimit' => __('Email preview text character limit reached 190 characters.', 'mrm'),
			'CloseCampaign' => __('Close Campaign Settings?', 'mrm'),
			'CloseCampaignLabel' => __('You have unsaved changes that may not be saved if you exit now. Are you sure you want to close campaign settings?', 'mrm'),
			'CreateNewCampaign' => __('Create New Campaign', 'mrm'),
			'Email' => __('Email', 'mrm'),
			'EmailTitle' => __('Title:', 'mrm'),
			'EmailSubTitlePlaceHolder' => __('Enter a suitable campaign title', 'mrm'),
			'SelectRecipients' => __('Select Recipients', 'mrm'),
			'and' => __('and', 'mrm'),
			'delay' => __('Delay:', 'mrm'),
			'chooseDelay' => __('--Choose delay--', 'mrm'),
			'SubjectLine' => __('Subject Line:', 'mrm'),
			'SubjectLinePlaceHolder' => __('Use a compelling subject line that sparks interest', 'mrm'),
			'personalizeTooltip' => __('Use dynamic, personalized data of recipients to make it more engaging.', 'mrm'),
			'Contact' => __('Contact', 'mrm'),
			'Custom' => __('Custom', 'mrm'),
			'PreviewText' => __('Preview Text:', 'mrm'),
			'PreviewPlaceholder' => __('Give a quick summary of what your email includes', 'mrm'),
			'FromName' => __('From Name', 'mrm'),
			'FromEmail' => __('From Email', 'mrm'),
			'ReplyTo' => __('Reply To:', 'mrm'),
			'ReplyName' => __('Reply Name', 'mrm'),
			'ReplyEmail' => __('Reply Email', 'mrm'),
			'Recipients' => __('Recipients', 'mrm'),
			'EmailDesign' => __('Email Design:', 'mrm'),
			'DesignYourEmail' => __('Design Your Email', 'mrm'),
			'SaveDraft' => __('Save draft', 'mrm'),
			'Publish' => __('Publish', 'mrm'),
			'RegularCampaignTooltip' => __('Please complete all required steps to create the campaign.', 'mrm'),
			'RegularCampaignButtonTooltip' => __('By adding this class you can provide almost any element with a tool tip.', 'mrm'),
			'Send' => __('Send', 'mrm'),
			'Schedule' => __('Schedule', 'mrm'),
			'RecurringCampaign' => __('Recurring Campaign', 'mrm'),
			'upgradeText' => __('Get Instant Access To This Exclusive Feature With The Pro Version', 'mrm'),
			'Tag' => __('Tag', 'mrm'),
			'Clear' => __('Clear', 'mrm'),
			'SearchTag' => __('Search Tag', 'mrm'),
			'AllTags' => __('All Tags', 'mrm'),
			'SearchList' => __('Search List', 'mrm'),
			'AllLists' => __('All Lists', 'mrm'),
			'SearchSegment' => __('Search Segment', 'mrm'),
			'EditCampaign' => __('Edit Campaign', 'mrm'),
			'TotalOpen' => __('Total Open', 'mrm'),
			'TotalClick' => __('Total Click', 'mrm'),
			'TotalBounce' => __('Total Bounce', 'mrm'),
			'TotalUnsubscribe' => __('Total Unsubscribe', 'mrm'),
			'RecipientAlertMsg' => __('Please select any list/tag/segment that has active subscribers!', 'mrm'),
			'EmailSubjectRequired' => __('Email subject is required!', 'mrm'),
			'Personalization' => __('Personalization', 'mrm'),
			'SenderNameRequired' => __('Sender name is required!', 'mrm'),
			'SenderEmail' => __('Sender email', 'mrm'),
			'FromName' => __('From Name', 'mrm'),
			'SenderEmailRequired' => __('Sender email is required!', 'mrm'),
			'ReplayNameRequired' => __('Reply name is required!', 'mrm'),
			'ReplayEmailRequired' => __('Reply email is required!', 'mrm'),
			'PreviewTest' => __('Preview & Test', 'mrm'),
			'EditYourTemplate' => __('Edit Your Template', 'mrm'),
			'EmailContentRequired' => __('Email content is required!', 'mrm'),
			'Archived' => __('Archived', 'mrm'),
			'EditTemplate' => __('Edit template', 'mrm'),
			'ExportTemplate' => __('Export template', 'mrm'),
			'SendTestEmailTo' => __('Send a test email to', 'mrm'),
			'EnterEmailAddress' => __('Enter email address', 'mrm'),
			'CampaignModalDescription' => __('Start designing your email with a pre-built template, select from your saved templates, or create a custom design from scratch.', 'mrm'),
			'EmailCategories' => __('Email Categories', 'mrm'),
			'Industry' => __('Industry', 'mrm'),
			'Plan' => __('Plan', 'mrm'),
			'StartFromScratch' => __('Start from scratch', 'mrm'),
			'NoTemplatesFound' => __('No templates found', 'mrm'),
			'UpgradeToPRO' => __('Upgrade To PRO', 'mrm'),
			'Applying' => __('Applying...', 'mrm'),
			'Apply' => __('Apply', 'mrm'),
			'Filter' => __('Filter', 'mrm'),
			'BrandedTemplates' => __('Branded templates', 'mrm'),
			'MyTemplates' => __('My templates', 'mrm'),
			'To' => __('To', 'mrm'),

			// Campaign Analytics
			'ViewEmail' => __('View Email', 'mrm'),
			'Activity' => __('Activity', 'mrm'),
			'SentTo' => __('Sent To', 'mrm'),
			'Opened' => __('Opened', 'mrm'),
			'Clicked' => __('Clicked', 'mrm'),
			'Bounced' => __('Bounced', 'mrm'),
			'ClickPerformance' => __('Click Performance', 'mrm'),
			'CampaignSent' => __('Campaign Sent', 'mrm'),
			'EmailPreview' => __('Email Preview', 'mrm'),
			'Sender' => __('Sender', 'mrm'),
			'ExportAsCSV' => __('Export as CSV', 'mrm'),
			'EmailAddress' => __('Email Address', 'mrm'),
			'URL' => __('URL', 'mrm'),
			'TotalClicks' => __('Total Clicks', 'mrm'),
			'SendingTime' => __('Sending Time', 'mrm'),
			'Delivered' => __('Delivered', 'mrm'),
			'CampaignDeliveryTooltip' => __('This is the count of individual email (For regular and sequence campaigns) that were successfully delivered to recipients.', 'mrm'),
			'CampaignOpenTooltip' => __('The number of emails that recipients have opened and viewed.', 'mrm'),
			'CampaignClickedTooltip' => __('The number of emails that recipients interacted with by clicking on links or buttons.', 'mrm'),
			'CampaignUnsubscribeTooltip' => __('The number of contacts who have opted out or unsubscribed from receiving further emails.', 'mrm'),
			'CampaignRevenueTooltip' => __('The total revenue generated from this email. Shown when someone purchased from the shop link or the product link from this email.', 'mrm'),
			'CampaignCtorTooltip' => __('The percentage of recipients who opened the email and then clicked on any link within the email.', 'mrm'),
			'CampaignSummary' => __('Campaign Summary', 'mrm'),
			'EmailSent' => __('Emails Processed', 'mrm'),
			'SuccessfulDeliveries' => __('Successful Deliveries', 'mrm'),
			'Unsubscribe' => __('Unsubscribe', 'mrm'),
			'TotalOpens' => __('Total Opens', 'mrm'),
			'ClickToOpenRate' => __('Click To Open Rate', 'mrm'),
			'TotalRevenue' => __('Total Revenue', 'mrm'),
			'From' => __('From', 'mrm'),

			// Email Builder Editor
			'ExitEmailBuilder' => __('Exit Email Builder?', 'mrm'),
			'ExitBuilderMsg' => __('You have unsaved changes that may not be saved if you exit now. Are you sure you want to exit the email builder now?', 'mrm'),
			'ResetEmailBuilderHeader' => __('Are you sure you want to reset?', 'mrm'),
			'ResetEmailBuilderMsg' => __('Reset will append the default template to your email builder.', 'mrm'),


			// OpenAI prompt and settings.
			'WhatIsThisEmailAbout' => __('What is this email about?', 'mrm'),
			'GenerateEmailSubjectLinesUsingAI' => __('Generate Email Subject Lines Using AI', 'mrm'),
			'GenerateEmailPreviewTextUsingAI' => __('Generate Email Preview Text Using AI', 'mrm'),
			'GenerateCompellingEmailCopiesUsingAI' => __('Generate Compelling Email Copies Using AI', 'mrm'),

			// Business Settings
			'BusinessSettings' => __('Business Settings', 'mrm'),
			'BasicSettings' => __('Basic Settings', 'mrm'),
			'SocialMedia' => __('Social Media', 'mrm'),
			'BusinessName' => __('Business Name', 'mrm'),
			'PhoneNumber' => __('Phone Number', 'mrm'),
			'EnterBusinessName' => __('Enter Business Name', 'mrm'),
			'EnterPhoneNumber' => __('Enter Phone Number', 'mrm'),
			'BusinessAddress' => __('Business Address', 'mrm'),
			'AddressLine1' => __('Address Line 1', 'mrm'),
			'AddressLine2' => __('Address Line 2', 'mrm'),
			'City' => __('City', 'mrm'),
			'SelectCountry' => __('Select Country', 'mrm'),
			'WriteState' => __('Write state', 'mrm'),
			'ZIP' => __('ZIP', 'mrm'),
			'CompanyLogo' => __('Company logo', 'mrm'),
			'ClickToUpload' => __('Click to upload', 'mrm'),
			'SocialMedia' => __('Social Media', 'mrm'),
			'AddASocialMedia' => __('Add a social media', 'mrm'),
			'AddYourBusinessSocialProfile' => __('Add your business social profile.', 'mrm'),
			'SaveSettings' => __('Save Settings', 'mrm'),

			// Email Settings
			'EmailSettings' => __('Email Settings', 'mrm'),
			'FromName' => __('From Name', 'mrm'),
			'EmailSettingsFromNameToolTip' => __('This will be the Name that your recipients will see as the person who sent the emails.', 'mrm'),
			'EnterFromName' => __('Enter From Name', 'mrm'),
			'FromEmail' => __('From Email', 'mrm'),
			'EmailSettingsFromEmailToolTip' => __('This will be the noted email address from where the emails will be sent.', 'mrm'),
			'EnterFromEmail' => __('Enter From Email', 'mrm'),
			'EnterAValidEmail' => __('Enter a valid email', 'mrm'),
			'ReplyToName' => __('Reply-to Name', 'mrm'),
			'EmailSettingsReplyToNameToolTip' => __('This will be the Name that your recipients will see as the person they will be able to reply to.', 'mrm'),
			'EnterReplyToName' => __('Enter Reply-to Name', 'mrm'),
			'ReplyToEmail' => __('Reply-to Email', 'mrm'),
			'EmailSettingsReplyToEmailToolTip' => __('When a recipient may reply to your emails, the replies will be received in this email.', 'mrm'),
			'EnterReplyToEmail' => __('Enter Reply-to Email', 'mrm'),
			'SendingFrequency' => __('Sending Frequency', 'mrm'),
			'EmailSettingsSendingFrequencyToolTip' => __('Set up maximum number of emails to be sent within a specific time limit, usually set by your email service provider.', 'mrm'),
			'FrequencyMethod' => __('Frequency Method', 'mrm'),
			'Recommended' => __('Recommended', 'mrm'),
			'Manual' => __('Manual', 'mrm'),

			// Double Opt-In Settings
			'DoubleOptInSettings' => __('Double Opt-In', 'mrm'),
			'EnableDoubleOptIn' => __('Enable Double Opt-In', 'mrm'),
			'DoubleOptInSettingsToolTip' => __('Enable double Opt-in email to pending contacts.', 'mrm'),
			'EmailSubject' => __('Email Subject', 'mrm'),
			'OptInEmailSubjectToolTip' => __('Add a subject line for the double opt-in email.', 'mrm'),
			'EnterEmailSubject' => __('Enter Email Subject', 'mrm'),
			'PreviewText' => __('Preview Text', 'mrm'),
			'OptInPreviewTextToolTip' => __('Add a preview text for the double opt-in email.', 'mrm'),
			'EnterPreviewText' => __('Enter Preview Text', 'mrm'),
			'EmailBody' => __('Email Body', 'mrm'),
			'OptInEmailBodyToolTip' => __('Design the email copy for your double opt-in email.', 'mrm'),
			'ActionAfterConfirmation' => __('Action After Confirmation', 'mrm'),
			'ActionAfterConfirmationToolTip' => __('Choose what will happen after a person confirms subscription.', 'mrm'),
			'RedirectToAPage' => __('Redirect to a page', 'mrm'),
			'RedirectToAnExternalURL' => __('Redirect to an external URL', 'mrm'),
			'EnterRedirectURL' => __('Enter Redirect URL', 'mrm'),

			// General Settings
			'General' => __('General', 'mrm'),
			'PoweredByMailMintOnEmailFooter' => __('"Powered by Mail Mint" on Email Footer', 'mrm'),
			'PoweredByMailMintOnEmailFooterToolTip' => __('Uncheck to remove "Powered by Mail Mint" from email footer.', 'mrm'),
			'UnsubscribePageSettings' => __('Unsubscribe Page Settings', 'mrm'),
			'UnsubscribePageSettingsToolTip' => __('Set up the pages involved in allowing a contact to unsubscribe.', 'mrm'),
			'ConfirmationPage' => __('Confirmation Page', 'mrm'),
			'ConfirmationPageToolTip' => __('Select the page where the contact will be able to confirm unsubscription.', 'mrm'),
			'AfterUnsubscription' => __('After Unsubscription', 'mrm'),
			'AfterUnsubscriptionToolTip' => __('Choose what will happen after a person unsubscribes successfully.', 'mrm'),
			'PreferencePageSettings' => __('Preference Page Settings', 'mrm'),
			'PreferencePageSettingsToolTip' => __('Set up the options involved in allowing a contact to change email preferences.', 'mrm'),
			'SelectPreferencePage' => __('Select Preference Page', 'mrm'),
			'SelectPreferencePageToolTip' => __('Choose the "Email Preference" page for your contacts.', 'mrm'),
			'PreferencePermissions' => __('Preference Permissions', 'mrm'),
			'PreferencePermissionsToolTip' => __('Choose what data you will allow your contacts to update.', 'mrm'),
			'NoContactCanNotManageListSubscriptions' => __('No, Contact can not manage list subscriptions', 'mrm'),
			'SelectListsToShowOnThePreferencePage' => __('Select lists to show on the preference page', 'mrm'),
			'EditablePrimaryFields' => __('Editable Primary Fields', 'mrm'),
			'EditablePrimaryFieldsToolTip' => __('Choose which primary fields you will allow your contacts to edit.', 'mrm'),
			'PromptNewWPUsersToJoinMailMintLists' => __('Prompt New WP Users To Join Mail Mint Lists', 'mrm'),
			'UserRole' => __('User Role', 'mrm'),
			'PromptCheckboxLabel' => __('Prompt Checkbox Label', 'mrm'),
			'PromptCheckboxLabelToolTip' => __('Write a message to ask the user to join your mailing list.', 'mrm'),
			'EnterCheckboxLabelText' => __('Enter checkbox label text', 'mrm'),
			'PromptCommentersToJoinMailMintLists' => __('Prompt Commenters To Join Mail Mint Lists', 'mrm'),
			'AddCommentersToSpecificLists.' => __('Add commenters to specific lists.', 'mrm'),
			'AssignSpecificTagsToCommenters.' => __('Assign specific tags to commenters.', 'mrm'),
			'DeleteAllDataOnPluginDeletion' => __('Delete All Data on Plugin Deletion', 'mrm'),
			'DeleteAllDataOnPluginDeletionToolTip' => __('Check this option to delete all the data from Mail Mint while deleting the plugin.', 'mrm'),

			// Advanced Settings
			'Advanced' => __('Advanced', 'mrm'),
			'ThirdPartyLibraries' => __('Load 3rd-Party Libraries', 'mrm'),
			'ThirdPartyLibraryTooltip' => __('E.g. Google Fonts for email templates and forms. When disabled, fonts will not load from external sources.', 'mrm'),
			'EnableThirdPartyLibrary' => __('Yes', 'mrm'),
			'DisabledPartyLibrary' => __('No', 'mrm'),
			'RemoveMailMintTransientCache' => __('Remove Mail Mint Transient Cache', 'mrm'),
			'RemoveMailMintTransientCacheTooltip' => __('If you are facing issues such as not getting plugin updates or license not working, clear the transient cache and try again.', 'mrm'),
			'DeleteTransients' => __('Delete Transients', 'mrm'),

			// Roles and Permissions Settings
			'RolesAndPermissions' => __('Roles & Capabilities', 'mrm'),
			'AddRolesAndPermissions' => __('Manage What Users Can Edit In Mail Mint', 'mrm'),
			'Role' => __('Role', 'mrm'),
			'NumberOfUsers' => __('Number Of Users', 'mrm'),
			'EditRolesAndPermissions' => __('Edit Roles & Permissions', 'mrm'),
			'RoleEmails' => __('Emails Under This Role', 'mrm'),
			'RolePermissions' => __('Permissions', 'mrm'),
			'CheckAll' => __('Check All', 'mrm'),
			'DashboardPermissions' => __('Dashboard Permissions', 'mrm'),
			'Granted' => __('Granted', 'mrm'),
			'Assign' => __('Assign', 'mrm'),
			

			// WooCommerce Settings
			'Settings' => __('Settings', 'mrm'),
			'OptinOnCheckout' => __('Opt-in on Checkout', 'mrm'),
			'WCOptinMsg' => __('Add a confirmation check box to join your mailing list on the WooCommerce checkout page.', 'mrm'),
			'CheckboxLabel' => __('Checkbox Label', 'mrm'),
			'CheckboxMsg' => __('Define the Subscription Confirmation message.', 'mrm'),
			'WCAddListTooltip' => __('Add users that opts in during checkout to selected list(s).', 'mrm'),
			'WCAddTagTooltip' => __('Assign tag(s) to users that opts in during checkout.', 'mrm'),

			// Abandoned Cart Settings
			'AbandonedCart' => __(' Abandoned Cart', 'mrm'),
			'EnableCartTracking' => __('Enable Cart Tracking', 'mrm'),
			'EnableCartTrackingToolTip' => __('Enable this to track if your customer is adding any item to their cart.', 'mrm'),
			'WaitPeriod'             => __('Wait Period (minutes)', 'mrm'),
			'WaitPeriodToolTip'      => __('After how many minutes, the cart will be marked as Abandoned from Pending.', 'mrm'),
			'ExcludePeriod'          => __('Mark as Lost after (days)', 'mrm'),
			'ExcludePeriodToolTip'   => __('Mark the cart as Lost if the order is not made within the given days.', 'mrm'),
			'DisableTracking'        => __('Disable Tracking', 'mrm'),
			'DisableTrackingToolTip' => __('Choose the user roles for which you want to disable cart tracking.', 'mrm'),
			'GDPRConsent'          => __('GDPR Consent', 'mrm'),
			'GDPRConsentToolTip'   => __("Ask for your customer's consent to send emails", 'mrm'),
			'RequireConsent' => __('Require consent', 'mrm'),
			'DoNotRequireConsent' => __('Do not require consent', 'mrm'),
			'EnterTheConsentMessage' => __('Enter the consent message', 'mrm'),
			'UseMergeTag' => __('Use merge tag', 'mrm'),
			'toLetUsersOptOutOfCartTracking' => __('to let users opt out of cart tracking.', 'mrm'),
			'WhenCartIsAbandoned' => __('When Cart is Abandoned', 'mrm'),
			'AbandonedListToolTip' => __('Add your customers to a list after they have abandoned their cart', 'mrm'),
			'AbandonedTagToolTip' => __('Assign a tag to your customers after they have abandoned their cart', 'mrm'),

			// Contact Fields Settings
			'DeleteCustomField' => __('Delete Custom Field', 'mrm'),
			'AreYouSureYouWantToDeleteIt' => __('Are you sure you want to delete it?', 'mrm'),
			'ContactFields' => __('Contact Fields', 'mrm'),
			'Label' => __('Label', 'mrm'),
			'Slug' => __('Slug', 'mrm'),
			'NoGeneralFieldFound' => __('No general field found.', 'mrm'),
			'AddCustomField' => __('Add Custom Field', 'mrm'),
			'AddField' => __('Add Field', 'mrm'),
			'NoCustomFieldFound' => __('No custom field found.', 'mrm'),
			'UpdateGeneralField' => __('Update General Field', 'mrm'),
			'FieldName' => __('Field Name', 'mrm'),
			'EnterFieldName' => __('Enter field name', 'mrm'),
			'SinglelineText' => __('Singleline text', 'mrm'),
			'MultilineText' => __('Multiline text', 'mrm'),
			'Number' => __('Number', 'mrm'),
			'Dropdown' => __('Dropdown', 'mrm'),
			'Radio' => __('Radio', 'mrm'),
			'Checkbox' => __('Checkbox', 'mrm'),
			'SlugOptional' => __('Slug (Optional)', 'mrm'),
			'AddAnUniqueSlugForTheCustomField' => __('Add an unique slug for the custom field.', 'mrm'),
			'TheSlugForGeneralFieldsCannotBeModified' => __('The slug for general fields cannot be modified.', 'mrm'),
			'EnterCustomFieldSlug' => __('Enter custom field slug', 'mrm'),
			'PlaceholderText' => __('Placeholder Text', 'mrm'),
			'EnterPlaceholderText' => __('Enter placeholder text', 'mrm'),
			'EnterFieldLabel' => __('Enter field label', 'mrm'),
			'AddNewOption' => __('Add New Option', 'mrm'),
			'NewOption' => __('New Option', 'mrm'),

			// Compliance Settings
			'Setting' => __('Setting', 'mrm'),
			'Compliance' => __('Compliance', 'mrm'),
			'ComplianceLabel' => __('Anonymize IP addresses for contact analytics data', 'mrm'),
			'ComplianceTooltip' => __('Enable this to stop tracking IP addresses of contacts when retrieving analytics data.', 'mrm'),
			'ComplianceGeneralSettingsLabel' => __('Remove user from Mail Mint contact list upon WP user deletion', 'mrm'),
			'ComplianceGeneralSettingsTooltip' => __('Enable this to remove the user from Mail Mint contact list upon WP user deletion.', 'mrm'),
			'EnableOneClickUnsubscribe' => __('Enable one-click unsubscribe', 'mrm'),
			'EnableOneClickUnsubscribeToolTip' => __("Enabling this option means that whenever a contact clicks the 'Unsubscribe' link, the contact will be immediately unsubscribed.", 'mrm'),

			// Webhook Settings
			'DeleteWebhook' => __('Delete Webhook?', 'mrm'),
			'AreYouSureDeleteWebhook' => __('Are you sure you want to delete the webhook', 'mrm'),
			'Webhook' => __('Webhook', 'mrm'),
			'AddWebhook' => __('Add Webhook', 'mrm'),
			'Title' => __('Title', 'mrm'),
			'AssignedTags' => __('Assigned Tags', 'mrm'),
			'AssignedLists' => __('Assigned Lists', 'mrm'),
			'NoWebhookFound' => __('No webhook found.', 'mrm'),

			// Email Builder Custom Block
			'Recent_posts' => __('Recent posts', 'mrm'),
			'Read_more' => __('Read more', 'mrm'),
			'Title_only' => __('Title only', 'mrm'),
			'Display_post' => __('Display post', 'mrm'),
			'Content' => __('Content', 'mrm'),
			'Posts' => __('Posts', 'mrm'),
			'Source_code' => __('Source code', 'mrm'),
			'attributes' => __('Attributes', 'mrm'),
			'Text' => __('Text', 'mrm'),
			'text_block_content' => __('Make it easy for everyone to compose emails!', 'mrm'),
			'Basic_Settings' => __('Basic Settings', 'mrm'),
			'Button_Text' => __('Button Text', 'mrm'),
			'Button_Block_Help_Text' => __('Use dynamic, personalized data of recipients to make it more engaging.', 'mrm'),
			'Dimensions' => __('Dimensions', 'mrm'),
			'width_help_text' => __('Column inside a group must have a width in percentage, not in pixel', 'mrm'),
			'Padding' => __('Padding', 'mrm'),
			'Top' => __('Top', 'mrm'),
			'Right' => __('Right', 'mrm'),
			'Bottom' => __('Bottom', 'mrm'),
			'Left' => __('Left', 'mrm'),
			'Inner_padding' => __('Inner padding', 'mrm'),
			'Color' => __('Color', 'mrm'),
			'Background' => __('Background', 'mrm'),
			'Row_background' => __('Row background', 'mrm'),
			'Background_color' => __('Background color', 'mrm'),
			'Container_background_color' => __('Container background color', 'mrm'),
			'Typography' => __('Typography', 'mrm'),
			'Font_family' => __('Font family', 'mrm'),
			'Font_size' => __('Font size', 'mrm'),
			'Font_weight' => __('Font weight', 'mrm'),
			'Line_height' => __('Line height', 'mrm'),
			'Text_decoration' => __('Text decoration', 'mrm'),
			'Letter_spacing' => __('Letter spacing', 'mrm'),
			'Alignment' => __('Alignment', 'mrm'),
			'Font_style' => __('Font style', 'mrm'),
			'Border' => __('Border', 'mrm'),
			'Border_radius' => __('Border radius', 'mrm'),
			'Extra' => __('Extra', 'mrm'),
			'Class_name' => __('Class name', 'mrm'),
			'Invalid_content' => __('Invalid content', 'mrm'),
			'Json_source' => __('Json source', 'mrm'),
			'Layout' => __('Layout', 'mrm'),
			'Move_up' => __('Move up', 'mrm'),
			'Move_down' => __('Move down', 'mrm'),
			'Copy' => __('Copy', 'mrm'),
			'Add_to_collection' => __('Add to collection', 'mrm'),
			'Delete' => __('Delete', 'mrm'),
			'Configuration' => __('Configuration', 'mrm'),
			'Blocks' => __('Blocks', 'mrm'),
			'WC' => __('WC', 'mrm'),
			'Styles' => __('Styles', 'mrm'),
			'Quantity' => __('Quantity', 'mrm'),
			'Title_color' => __('Title color', 'mrm'),
			'Product_name_color' => __('Product name color', 'mrm'),
			'Product_price_color' => __('Product price color', 'mrm'),
			'Button_color' => __('Button color', 'mrm'),
			'Button_text_color' => __('Button text color', 'mrm'),
			'Button' => __('Button', 'mrm'),
			'Wrapper' => __('Wrapper', 'mrm'),
			'Template' => __('Template', 'mrm'),
			'Table' => __('Table', 'mrm'),
			'Spacer' => __('Spacer', 'mrm'),
			'Social' => __('Social', 'mrm'),
			'Section' => __('Section', 'mrm'),
			'Raw' => __('Raw', 'mrm'),
			'Navbar' => __('Navbar', 'mrm'),
			'Image' => __('Image', 'mrm'),
			'Hero' => __('Hero', 'mrm'),
			'Group' => __('Group', 'mrm'),
			'Divider' => __('Divider', 'mrm'),
			'Column' => __('Column', 'mrm'),
			'Drop_a_Wrapper_block_here' => __('Drop a Wrapper block here', 'mrm'),
			'Drop_a_Section_block_here' => __('Drop a Section block here', 'mrm'),
			'Drop_a_Column_block_here' => __('Drop a Column block here', 'mrm'),
			'Drop_a_content_block_here' => __('Drop a content block here', 'mrm'),
			'Generate_With_AI' => __('Generate With AI', 'mrm'),
			'Background_repeat' => __('Background repeat', 'mrm'),
			'Background_size' => __('Background size', 'mrm'),
			'Background_Settings' => __('Background Settings', 'mrm'),
			'Background_Image' => __('Background Image', 'mrm'),
			'bg_help_text' => __('Supported image types: jpg, jpeg, png, and gif. Other image types may not be displayed properly.', 'mrm'),
			'Background_width' => __('Background width', 'mrm'),
			'Background_height' => __('Background height', 'mrm'),
			'Background_position' => __('Background position', 'mrm'),
			'Upload_Image' => __('Upload Image', 'mrm'),
			'src' => __('src', 'mrm'),
			'Insert_Link' => __('Insert Link', 'mrm'),
			'Image_Details' => __('Image Details', 'mrm'),
			'Image_Title' => __('Image Title', 'mrm'),
			'Alt_Text' => __('Alt Text', 'mrm'),
			'Manage_Social_Icons' => __('Manage Social Icons', 'mrm'),
			'Distribution' => __('Distribution', 'mrm'),
			'Type' => __('Type', 'mrm'),
			'Icon_width' => __('Icon width', 'mrm'),
			'Icon_padding' => __('Icon padding', 'mrm'),
			'Title_padding' => __('Title padding', 'mrm'),
			'Channel_Name' => __('Channel Name', 'mrm'),
			'Profile_Link' => __('Profile Link', 'mrm'),
			'social_help_text' => __('Include a full link, including https, for example, "https://www.facebook.com/your-profile" for the link to work.', 'mrm'),

			// Create Webhook
			'NameIsMandatory'        => __('Name is mandatory', 'mrm'),
			'PleaseSelectATagOrList' => __('Please select a tag or list', 'mrm'),
			'CopyURL'                => __('Copy URL', 'mrm'),
			'CopyURLToolTip'         => __('You can copy to share or embed this URL to trigger the specified action.', 'mrm'),
			'ContactField'           => __('Contact Field', 'mrm'),
			'MapIntoField'           => __('Map Into Field', 'mrm'),
			'FirstName'              => __('First Name', 'mrm'),
			'LastName' => __('Last Name', 'mrm'),
			'Source' => __('Source', 'mrm'),
			'Stage' => __('Stage', 'mrm'),
			'StatusChanged' => __('Status Changed', 'mrm'),
			'DateOfBirth' => __('Date Of Birth', 'mrm'),
			'Gender' => __('Gender', 'mrm'),
			'Country' => __('Country', 'mrm'),
			'State' => __('State', 'mrm'),
			'Timezone' => __('Timezone', 'mrm'),
			'Address1' => __('Address 1', 'mrm'),
			'Address2' => __('Address 2', 'mrm'),
			'City' => __('City', 'mrm'),
			'Postal' => __('Postal/Zip', 'mrm'),
			'Company' => __('Company', 'mrm'),
			'Designation' => __('Designation', 'mrm'),
			'CustomContactFields' => __('Custom Contact Fields', 'mrm'),
			'CustomContactFieldsDescription' => __('You may also use these custom contact fields. Copy the keys in the right column and paste them into the app just like other contact fields.', 'mrm'),
			'CustomContactField' => __('Custom Contact Field', 'mrm'),
			'Key' => __('Key', 'mrm'),

			// Open AI Settings
			'PleaseEnterApiToken' => __('Please enter API token', 'mrm'),
			'connected' => __('connected', 'mrm'),
			'systemMessage' => __('Write a email subject line to explain that we have a new offer and it is only available for one week. Use a exciting tone.', 'mrm'),
			'InvalidApiKey' => __('Invalid API Key', 'mrm'),
			'OpenAIApi' => __('OpenAI API', 'mrm'),
			'ConnectOpenAIMsg' => __('Visit the documentation page for details on connecting Mail Mint with ChatGPT – OpenAI.', 'mrm'),
			'FindYourSecretApiKeyInYour' => __('Find your secret key in your ', 'mrm'),
			'OpenAPIUserAccount' => __('OpenAI account', 'mrm'),

			// Recaptcha Settings
			'EnterYouSiteKey' => __('Enter your site key', 'mrm'),
			'EnterYourSecretKey' => __('Enter your secret key', 'mrm'),
			'Enable' => __('Enable', 'mrm'),
			'EnableTooltip' => __('Enable reCAPTCHA to protect your website from spam', 'mrm'),
			'SelectAVersion' => __('Select a version', 'mrm'),
			'ValidateRequestsWithAScore' => __('(Validate requests with a score)', 'mrm'),
			'ValidateRequestsWithTheImNotARobotCheckbox' => __('(Validate requests with the I\'m not a robot checkbox)', 'mrm'),
			'SiteKey' => __('Site key', 'mrm'),
			'SiteKeyTooltip' => __('Enter the site key to activate the reCAPTCHA service on your website', 'mrm'),
			'SecretKey' => __('Secret key', 'mrm'),
			'SecretKeyTooltip' => __('Enter the site key to activate the reCAPTCHA service on your website', 'mrm'),
			'RecaptchaHints' => __('Generate your site key and secret key in your', 'mrm'),

			// Abandoned Cart Module
			// Abandoned Cart index page
			'NoRecoverableCartFound' => __('No Recoverable Cart Found', 'mrm'),
			'RecoverableCart' => __('Recoverable Cart', 'mrm'),
			'abandoned' => __('abandoned', 'mrm'),
			'ViewDetails' => __('View Details', 'mrm'),
			'ViewAutomation' => __('View Automation', 'mrm'),
			'RunAutomation' => __('Run Automation', 'mrm'),
			'RunAutomationManually' => __('Run Automation Manually', 'mrm'),
			'AutomationName' => __('Automation Name', 'mrm'),
			'AlreadyTriggered' => __('Already Triggered', 'mrm'),
			'TriggerNow' => __('Trigger Now', 'mrm'),
			'NoRecoveredCartFound' => __('No Recovered Cart Found', 'mrm'),
			'RecoveredCart' => __('Recovered Cart', 'mrm'),
			'NoLostCartFound' => __('No Lost Cart Found', 'mrm'),
			'LostCart' => __('Lost Cart', 'mrm'),
			'Order' => __('Order', 'mrm'),
			'StartedOn' => __('Started On', 'mrm'),
			'LastRun' => __('Last Run', 'mrm'),
			'NoAutomationsFound' => __('No Automations Found', 'mrm'),

			// Cart Analytics
			'CartsAnalytics' => __('Carts Analytics', 'mrm'),
			'TotalCustomers' => __('Total Customers', 'mrm'),
			'PotentialRevenue' => __('Potential Revenue', 'mrm'),
			'RecoveredRevenue' => __('Recovered Revenue', 'mrm'),
			'RecoveredCarts' => __('Recovered Carts', 'mrm'),
			'LostCarts' => __('Lost Carts', 'mrm'),
			'Potential' => __('Potential', 'mrm'),
			'RecoveryRate' => __('Recovery Rate', 'mrm'),
			'RecoverableCarts' => __('Recoverable Carts', 'mrm'),

			// Automation Module
			'NewAutomation' => __('New Automation', 'mrm'),
			'Active' => __('Active', 'mrm'),
			'Pause' => __('Pause', 'mrm'),
			'Entered' => __('Entered', 'mrm'),
			'Processing' => __('Processing', 'mrm'),
			'PauseOrRun' => __('Pause/Run', 'mrm'),
			'AutomationDuplicating' => __('Automation Duplicating...', 'mrm'),
			'NoAutomationFound' => __('No Automation found', 'mrm'),
			'ImportAutomation' => __('Import Automation', 'mrm'),
			'ImportForm' => __('Import Form', 'mrm'),
			'ChangeJSON' => __('Change JSON', 'mrm'),
			'SupportedFormatJSON' => __('Supported formats: JSON file', 'mrm'),
			'ago' => __('ago', 'mrm'),
			'ViewReport' => __('Analytics', 'mrm'),
			'AutomationImportHeader' => __('Accelerate Your Business With Meaningful Automation Flows', 'mrm'),
			'PopularPrebuiltJourneys' => __('Popular pre-built journeys', 'mrm'),
			'NoPrebuildAutomationFound' => __('No pre-build automation found', 'mrm'),
			'Select' => __('Select', 'mrm'),
			'Report' => __('Report', 'mrm'),
			'OverallReport' => __('Overall Report', 'mrm'),
			'Entrance' => __('Entrance', 'mrm'),
			'SubscribersCompleted' => __('Subscribers Completed', 'mrm'),
			'Performance' => __('Performance', 'mrm'),
			'Open' => __('Open', 'mrm'),
			'Click' => __('Click', 'mrm'),
			'Exit' => __('Exit', 'mrm'),
			'AutomationSavedMsg' => __('Changes saved and will apply to new entrances.', 'mrm'),
			'AutomationStatusUpdateMsg' => __('Automation status has been updated', 'mrm'),
			'AutomationStartingMsg' => __('Please select a Starting Point to Start Workflow', 'mrm'),
			'Paused' => __('Paused', 'mrm'),
			'Stats' => __('Stats', 'mrm'),
			'StartWorkflow' => __('Start Workflow', 'mrm'),
			'UpdateWorkflow' => __('Update Workflow', 'mrm'),
			'SavingAsDraft' => __('Saving as Draft...', 'mrm'),
			'SaveAsDraft' => __('Save as Draft', 'mrm'),
			'NoStepSelected' => __('No step selected.', 'mrm'),
			'UnknownStepType' => __('Unknown step type.', 'mrm'),
			'MoveStepDirectionMsg' => __('Use left and right arrow keys to move through steps', 'mrm'),
			'SelectAStartingPoint' => __('Select A Starting Point', 'mrm'),
			'ConnectOpenAI' => __('Connect OpenAI', 'mrm'),
			'Regenerate' => __('Regenerate', 'mrm'),
			'RegenerateTooltip' => __('Regenerate the following suggestions and update the results', 'mrm'),
			'GenerateMoreTooltip' => __('Generate more results & add below the existing ones', 'mrm'),
			'Generating' => __('Generating...', 'mrm'),
			'GenerateMore' => __('Generate More', 'mrm'),
			'ClearPromptTooltip' => __('Clear all results and write the instructions again', 'mrm'),

			// Contact Forms - After Submit Trigger for Automation
			'FormSubmitted' => __('Form Submitted', 'mrm'),
			'FormSubmittedDescription' => __('This automation will trigger when someone submits form selected from below.', 'mrm'),
			'SelectAForm' => __('Select Form to Trigger Automation', 'mrm'),
			'MapEmailTooltip' => __('Select a form field to map with the contact email.', 'mrm'),
			'MapFirstNameTooltip' => __('Select a form field to map with the contact first name.', 'mrm'),
			'NotSetUpYet' => __('Not set up yet.', 'mrm'),
			'AddedToList' => __('Added To List', 'mrm'),
			'AddedToListDescription' => __('Define list(s). Whenever a contact is added to the list(s) you defined, this automation will be triggered.', 'mrm'),
			'ChooseListS' => __('Choose List(s)', 'mrm'),
			'ChooseSegment' => __('Choose Segment', 'mrm'),
			'TagApplied' => __('Tag Applied', 'mrm'),
			'TagAppliedDescription' => __('Define tags(s). Whenever the tag(s) you defined is applied to a contact, this automation will be triggered.', 'mrm'),
			'ChooseTagS' => __('Choose Tag(s)', 'mrm'),
			'RemovedFromList' => __('Removed From List', 'mrm'),
			'RemovedFromListDescription' => __('This automation will run when any of the selected list(s) have been removed from a contact.', 'mrm'),
			'TagRemoved' => __('Tag Removed', 'mrm'),
			'TagRemovedDescription' => __('This automation will run when any of the selected tag(s) have been removed from a contact.', 'mrm'),
			'AllProducts' => __('All Products', 'mrm'),
			'ChooseProducts' => __('Choose Products', 'mrm'),
			'ChooseProductCategories' => __('Choose Product Categories', 'mrm'),
			'ChooseProductCategoriesDescription' => __('This Automation will be Triggered when the customer abandons a cart containing any product.', 'mrm'),
			'AbandonedCartLost' => __('Abandoned Cart Lost', 'mrm'),
			'CartLost' => __('Cart Lost', 'mrm'),
			'TriggerRunWhenCartIsLost' => __('Trigger run when cart is Lost.', 'mrm'),
			'CartLostDescription' => __('Starts the automation when the abandoned cart recovery period is over and the cart is lost.', 'mrm'),
			'CartRecovered' => __('Cart Recovered', 'mrm'),
			'AbandonedCartRecovered' => __('Abandoned Cart Recovered', 'mrm'),
			'AbandonedCartRecoveredDescription' => __('Starts the automation when the person has returned and completed the purchase of his/her abandoned cart products.', 'mrm'),
			'FirstOrderInStore' => __('First Order In Store', 'mrm'),
			'FirstOrderInStoreDescription' => __('This automation will be triggered if a customer places an order for the first time in your WooCommerce store.', 'mrm'),
			'ProductOrdered' => __('Product Ordered', 'mrm'),
			'ProductOrderedDescription' => __('This Automation will be Triggered when the customer orders any product.', 'mrm'),
			'NewOrderPlaced' => __('New Order Placed', 'mrm'),
			'NewOrderPlacedDescription' => __('This automation is triggered whenever a new order is placed in your WooCommerce store.', 'mrm'),
			'OrderCompleted' => __('Order Completed', 'mrm'),
			'OrderCompletedDescription' => __('This Automation will be Triggered when the an order has been completed any product.', 'mrm'),
			'TargetOrderStatus' => __('Target Order Status', 'mrm'),
			'TargetOrderStatusDescription' => __('Choose an order status so that this automation will be triggered whenever any order status in WooCommerce changes to the one you select.', 'mrm'),
			'ChooseOrderStatus' => __('Choose Order Status', 'mrm'),
			'OrderFailed' => __('Order Failed', 'mrm'),
			'OrderFailedDescription' => __('If an order is failed in Woocommerce, this automation will be triggered.', 'mrm'),
			'ReviewReceived' => __('Review Received', 'mrm'),
			'ReviewReceivedDescription' => __('This automation will be triggered when a review is added to any product.', 'mrm'),
			'ReviewReceivedDescForProduct' => __('This automation will be triggered when a review is added to specific products.', 'mrm'),
			'ReviewedReceivedDescForCategory' => __('This automation will be triggered when a review is added to products in specific categories.', 'mrm'),
			'ChooseProduct' => __('Choose Product(s)', 'mrm'),
			'ProductSelectHelpText' => __('Leave it blank to trigger the automation for any product.', 'mrm'),
			'ChooseCategoryS' => __('Choose Category(s)', 'mrm'),
			'CategorySelectHelpText' => __('Leave it blank to trigger the automation for any product category.', 'mrm'),
			'PriceDropped' => __('Price Drop / On Sale', 'mrm'),
			'PricedDroppedDescription' => __('This automation will be triggered when the price of any product drops.', 'mrm'),
			'ChooseRecipientS' => __('Choose Recipient(s)', 'mrm'),
			'ChooseRecipientTooltip' => __('Choose your automation recipients by tags, lists or segments. If nothing selected then it will not run for any contact.', 'mrm'),
			'EDDCompletePurchase' => __('EDD complete purchase', 'mrm'),
			'CompletePurchase' => __('Complete purchase', 'mrm'),
			'EDDStatusChanged' => __('EDD status changed', 'mrm'),
			'EddStatusChangedDescription' => __('Define an order status as control. Whenever the status is changed from this defined status, this automation will be triggered.', 'mrm'),
			'UpdatePaymentStatus' => __('Update payment status', 'mrm'),
			'UpdatePaymentStatus' => __('Update payment status', 'mrm'),
			'UpdateSubscriptionStatus' => __('Update subscription status', 'mrm'),
			'StudentRegistration' => __('Student registration', 'mrm'),
			'StudentRegistrationDes' => __('When a student registers to your site, this automation will be triggered.', 'mrm'),
			'AfterCourseEnrollment' => __('After course enrollment', 'mrm'),
			'SelectCourseS' => __('Select course(s)', 'mrm'),
			'ChooseBooking' => __('Choose Booking  Calenders(s)', 'mrm'),
			'SelectCourseTooltip' => __('Leave it blank to trigger the automation for any course.', 'mrm'),
			'InstructorApproved' => __('Instructor approved', 'mrm'),
			'InstructorApprovedToolTip' => __('Create a workflow for a newly approved instructor.', 'mrm'),
			'EnrollmentRemoved' => __('Enrollment removed', 'mrm'),
			'EnrollmentRemovedTooltip' => __('Trigger an automation flow when you manually delete the enrollment of a student for a particular course.', 'mrm'),
			'CompletesACourse' => __('Completes a course', 'mrm'),
			'NewBooking' => __('New Booking', 'mrm'),
			'CancelledBooking' => __('Booking Cancelled', 'mrm'),
			'CompletedBooking' => __('Booking Completed', 'mrm'),
			'RescheduledBooking' => __('Booking Rescheduled', 'mrm'),
			'SelectNewBookingTooltip' => __('Select Calender(s) To Automate ', 'mrm'),
			'SelectCancelledBookingTooltip' => __('Select Calender(s) To Automate ', 'mrm'),
			'SelectcomletedBookingTooltip' => __('Select Calender(s) To Automate ', 'mrm'),
			'SelectNewBookingMessage' => __('Leave it blank will not trigger the automation.', 'mrm'),
			'SelectRescheduledBookingTooltip' => __('Leave it blank will not trigger the automation.', 'mrm'),
			'CompletedFluentFormBooking' => __('This automation will be triggered when a booking has been marked as completed (manually or automatically).', 'mrm'),
			'CompleteACourseDescription' => __('This automation will start when a student completes a course.', 'mrm'),
			'CompletesALesson' => __('Completes a lesson', 'mrm'),
			'CompletesALessonDescription' => __('This automation will start when a student completes a lesson.', 'mrm'),
			'SelectLessonS' => __('Select lesson(s)', 'mrm'),
			'SelectLessonTooltip' => __('Leave it blank to trigger the automation for any lesson.', 'mrm'),
			'LastNameMapTooltip' => __('Select a form field to map with the contact last name.', 'mrm'),
			'EnrollsInACourse' => __('Enrolls in a course', 'mrm'),
			'EnrollsInACourseDescription' => __('This automation will start when a student is enrolled in a course.', 'mrm'),
			'CompletesAQuiz' => __('Completes a quiz', 'mrm'),
			'CompletesAQuizDescription' => __('This automation will start when a student completes a quiz.', 'mrm'),
			'SelectQuizS' => __('Select quiz(s)', 'mrm'),
			'SelectQuizTooltip' => __('Leave it blank to trigger the automation for any quiz.', 'mrm'),
			'SendAnEmail' => __('Send an email', 'mrm'),
			'SendAnEmailNotification' => __('Send Notification Email', 'mrm'),
			'SendAnEmailDescription' => __('Create a custom email to send to the contacts at this point of your automation flow.', 'mrm'),
			'CreateWPUserDes' => __('Create WP User with a role if user is not already registered with contact email.', 'mrm'),
			'SendEmailNotificationDescription' => __('Send a notification to admin(s) when a contact reaches a specific point in automation.', 'mrm'),
			'SenderName' => __('Sender name', 'mrm'),
			'FromEmail' => __('From Email', 'mrm'),
			'EmailSubjectLine' => __('Email Subject Line', 'mrm'),
			'SubjectLineTooltip' => __('Use a compelling subject line for your email', 'mrm'),
			'EmailPreviewText' => __('Email Preview Text', 'mrm'),
			'EmailPreviewTooltip' => __('Use a compelling preview text for your email', 'mrm'),
			'UnlockWithPremium' => __('Unlock With Premium', 'mrm'),
			'GetProVersionMsg' => __('Get Instant Access To This Exclusive Feature With The Pro Version.', 'mrm'),
			'EnterSenderEmail' => __('Enter Sender Email', 'mrm'),
			'EnterSenderName' => __('Enter Sender Name', 'mrm'),
			'EnterReplyEmail' => __('Enter Reply Email', 'mrm'),
			'EnterRecipientsEmail' => __('Enter Recipients Email', 'mrm'),
			'EnterReplyName' => __('Enter Reply Name', 'mrm'),
			'EmailPreviewTextDemo' => __('Be specific and concise to spark interest', 'mrm'),
			'Design' => __('Design', 'mrm'),
			'ActionDescription' => __('Wait some time before proceeding with the steps below', 'mrm'),
			'AddContactNote' => __('Add Contact Note', 'mrm'),
			'EnterEmailTitle' => __('Enter Email title', 'mrm'),
			'ChooseListToAddContact' => __('Choose List(s) to add contacts on.', 'mrm'),
			'ChooseTagToAddContact' => __('Choose Tag(s) to assign to contacts.', 'mrm'),
			'Condition' => __('Condition', 'mrm'),
			'CreateUser' => __('Create User', 'mrm'),
			'CreateUserDescription' => __('If the contact is not on the contacts list already, a new contact will be created.', 'mrm'),
			'ContactStatus' => __('Contact Status', 'mrm'),
			'CreateUserMeta' => __('Create User Meta', 'mrm'),
			'AddNoteAndActivity' => __('Add Note & Activity', 'mrm'),
			'SelectNoteType' => __('Select Note Type', 'mrm'),
			'NoteTitle' => __('Note Title', 'mrm'),
			'NoteType' => __('Note Type', 'mrm'),
			'Note' => __('Note', 'mrm'),
			'Call' => __('Call', 'mrm'),
			'Email' => __('Email', 'mrm'),
			'Meeting' => __('Meeting', 'mrm'),
			'QuoteSent' => __('Quote Sent', 'mrm'),
			'QuoteAccepted' => __('Quote Accepted', 'mrm'),
			'QuoteRefused' => __('Quote Refused', 'mrm'),
			'InvoiceSent' => __('Invoice Sent', 'mrm'),
			'InvoicePartPaid' => __('Invoice Part Paid', 'mrm'),
			'InvoicePaid' => __('Invoice Paid', 'mrm'),
			'InvoiceRefunded' => __('Invoice Refunded', 'mrm'),
			'Transaction' => __('Transaction', 'mrm'),
			'Feedback' => __('Feedback', 'mrm'),
			'ChangeContactStatus' => __('Change Contact Status', 'mrm'),
			'ChangeContactStatusDescription' => __('Update the contacts status to reflect their current stage in the automation flow.', 'mrm'),
			'TimeDelay' => __('Time Delay', 'mrm'),
			'TimeDelayDescription' => __('Set a time duration to wait before the next action is triggered.', 'mrm'),
			'TimeDelayTooltip' => __('Define a time to delay between the previous step and the next step in this automation flow.', 'mrm'),
			'SetWaitingTime' => __('Set waiting time', 'mrm'),
			'SpecificTimeDelay' => __('Specific Time Delay', 'mrm'),
			'Seconds' => __('Seconds', 'mrm'),
			'Minutes' => __('Minutes', 'mrm'),
			'Hours' => __('Hours', 'mrm'),
			'Days' => __('Days', 'mrm'),
			'Weeks' => __('Weeks', 'mrm'),
			'Months' => __('Months', 'mrm'),
			'Years' => __('Years', 'mrm'),
			'RemoveContactFromList' => __('Remove contacts from selected lists(s).', 'mrm'),
			'RemoveContactFromTag' => __('Choose certain tag(s) to remove from your contacts.', 'mrm'),
			'EmailSequenceDescription' => __('Choose an email sequence to send at this point of your automation flow.', 'mrm'),
			'EmailSequenceHits' => __('When creating a campaign, choose the option “Sequence For Automation” and prepare an email sequence. All the sequences you prepare for automation will be listed here.', 'mrm'),
			'StopTheAutomation' => __('Stop the automation', 'mrm'),
			'StopTheAutomationDescription' => __('Use this action to stop your automation workflow at this point.', 'mrm'),
			'UpdateStatus' => __('Update Status', 'mrm'),
			'CreateWordpressUser' => __('Create WordPress User', 'mrm'),
			'UpdateWPUserMeta' => __('Update WP User Meta', 'mrm'),
			'UpdateContactFields' => __('Update Contact Fields', 'mrm'),
			'UpdateContactFieldDes' => __('Add / Update custom fields or a few main fields of contact after the automation starts.', 'mrm'),
			'UpdateWPUserMetaDes' => __('Update WordPress user meta data.', 'mrm'),
			'ChangeUserRoleDes' => __('Change connected user role', 'mrm'),
			'ChangeUserRoleDes' => __('If user exist with the contact email then you can change user role.', 'mrm'),
			'ChangeUserRole' => __('Change User Role', 'mrm'),
			'ReplaceUserRole' => __('Replace Existing Role', 'mrm'),
			'ReplaceUserRoleCheckboxDes' => __('Replace user role', 'mrm'),
			'OutgoingWebhook' => __('Outgoing Webhook', 'mrm'),
			'OutgoingWebhookDescription' => __('Send data to external server via GET or POST method.', 'mrm'),
			'DataSendMethod' => __('Data send method', 'mrm'),
			'RemoteURL' => __('Remote URL', 'mrm'),
			'RemoteURLTooltip' => __('Please provide valid URL in where you want to send the data.', 'mrm'),
			'EnterRemoteURL' => __('Enter Remote URL', 'mrm'),
			'RequestFormat' => __('Request Format', 'mrm'),
			'RequestBodyData' => __('Request Body Data', 'mrm'),
			'RequestBodyDataTooltip' => __('Please map the data for custom sending data type.', 'mrm'),
			'AddNew' => __('Add new', 'mrm'),
			'RequestHeader' => __('Request Header', 'mrm'),
			'RequestHeaderTooltip' => __('Please map the data for request headers.', 'mrm'),
			'NewRule' => __('New Rule', 'mrm'),
			'ContactMeetsIfElseConditions' => __('Contact Meets If/Else Conditions', 'mrm'),
			'CreateACoupon' => __('Create A Coupon', 'mrm'),
			'UsageLimitPerCoupon' => __('Usage Limit Per Coupon', 'mrm'),
			'UsageLimitPerCouponTooltip' => __('How many times this coupon can be used before it is void.', 'mrm'),
			'UnlimitedUsage' => __('Unlimited usage', 'mrm'),
			'UsageLimitPerUser' => __('Usage Limit Per User', 'mrm'),
			'UsageLimitPerUserTooltip' => __('How many times this coupon can be used by an individual user. Uses billing email for guests, and user ID for logged in users.', 'mrm'),
			'MinimumSpend' => __('Minimum Spend', 'mrm'),
			'MinimumSpendTooltip' => __('This field allows you to set the minimum spend (subtotal) allowed to use the coupon.', 'mrm'),
			'NoMinimum' => __('No minimum', 'mrm'),
			'MaximumSpend' => __('Maximum Spend', 'mrm'),
			'MaximumSpendTooltip' => __('This field allows you to set the maximum spend (subtotal) allowed when using the coupon.', 'mrm'),
			'NoMaximum' => __('No maximum', 'mrm'),
			'ProductTooltip' => __('Products that the coupon will be applied to, or that need to be in the cart in order for the "Fixed cart discount" to be applied.', 'mrm'),
			'SearchForProduct' => __('Search For a Product', 'mrm'),
			'NoProductFound' => __('No product found.', 'mrm'),
			'NoCategoryFound' => __('No category found.', 'mrm'),
			'ExcludeProducts' => __('Exclude Products', 'mrm'),
			'ExcludeProductsTooltip' => __('Products that the coupon will not be applied to, or that cannot be in the cart in order for the "Fixed cart discount" to be applied.', 'mrm'),
			'ExcludeCategories' => __('Exclude Categories', 'mrm'),
			'ExcludeCategoriesTooltip' => __('Product categories that the coupon will not be applied to, or that cannot be in the cart in order for the "Fixed cart discount" to be applied.', 'mrm'),
			'NoCategories' => __('No Categories', 'mrm'),
			'ProductCategories' => __('Product Categories', 'mrm'),
			'ProductCategoriesTooltip' => __('Product categories that the coupon will be applied to, or that need to be in the cart in order for the &quot;Fixed cart discount&quot; to be applied.', 'mrm'),
			'AnyCategory' => __('Any Category', 'mrm'),
			'AllowedEmails' => __('Allowed Emails', 'mrm'),
			'AllowedEmailsTooltip' => __('List of allowed billing emails to check against when an order is placed. Separate email addresses with commas. You can also use an asterisk (*) to match parts of an email. For example "*@gmail.com" would match all gmail addresses.', 'mrm'),
			'NoRestrictions' => __('No restrictions', 'mrm'),
			'IndividualUseOnly' => __('Individual Use Only', 'mrm'),
			'IndividualUseOnlyMsg' => __('Check this box if the coupon cannot be used in conjunction with other coupons.', 'mrm'),
			'ExcludeSaleItems' => __('Exclude Sale Items', 'mrm'),
			'ExcludeSaleItemsMsg' => __('Check this box if the coupon should not apply to items on sale. Per-item coupons will only work if the item is not on sale. Per-cart coupons will only work if there are items in the cart that are not on sale.', 'mrm'),
			'RestrictToContactEmail' => __('Restrict to Contact Email', 'mrm'),
			'RestrictToContactEmailMsg' => __('Check this box to apply the coupon exclusively to this contact email.', 'mrm'),
			'UseThisCouponOnEmail' => __('Use this dynamic coupon in emails:', 'mrm'),
			'CouponTitle' => __('Coupon Title', 'mrm'),
			'CouponTitleTooltip' => __('Add coupon title for internal usage only', 'mrm'),
			'CouponCodePrefix' => __('Coupon Code Prefix', 'mrm'),
			'CouponCodePrefixTooltip' => __("Mail Mint generates unique coupon codes for each contact by adding a custom prefix. For example,  'SPECIALOFFER92D3AI'.", 'mrm'),
			'DiscountType' => __('Discount Type', 'mrm'),
			'DiscountTypeTooltip' => __("If no discount type is selected, the default will be a 'percentage discount'.", 'mrm'),
			'CouponAmount' => __('Coupon Amount', 'mrm'),
			'CouponAmountTooltip' => __('Value of the coupon.', 'mrm'),
			'AllowFreeShipping' => __('Allow Free Shipping', 'mrm'),
			'AllowFreeShippingMsg' => __('Check this box if the coupon grants free shipping. A free shipping method must be enabled in your shipping zone and be set to require "a valid free shipping coupon" (see the "Free Shipping Requires" setting).', 'mrm'),
			'CouponExpiryDate' => __('Coupon Expiry Date', 'mrm'),
			'CouponExpiryDateTooltip' => __('Set whether the coupon expires. Choose a fixed date or a duration (e.g., 10 days after creation).', 'mrm'),
			'NeverExpires' => __('Never expires','mrm'),
			'FixedDate' => __('Fixed date','mrm'),
			'ExpireAfterXDaysOfCreation' => __('Expire after X days of creation','mrm'),
			'CouponExpiryDateMsg' => __('Check this box if the coupon has no expiry date', 'mrm'),
			'CreateCoupon' => __('Create Coupon', 'mrm'),
			'CreateANewCoupon' => __('Create a new coupon', 'mrm'),
			'UsageRestriction' => __('Usage Restriction', 'mrm'),
			'UsageLimits' => __('Usage Limits', 'mrm'),
			'DeleteCoupon' => __('Delete Coupon', 'mrm'),
			'DeleteACoupon' => __('Delete a coupon', 'mrm'),
			'SelectCouponS' => __('Select coupon(s)', 'mrm'),
			'SelectCouponTooltip' => __('Select the coupon(s) you want to delete', 'mrm'),

			// Form Module
			'NewForm' => __('New Form', 'mrm'),
			'Entries' => __('Entries', 'mrm'),
			'Shortcode' => __('Shortcode', 'mrm'),
			'FormDuplicating' => __('Form Duplicating...', 'mrm'),
			'NoFormSFound' => __('No Form(s) Found', 'mrm'),
			'DesignYourForm' => __('Design Your Form', 'mrm'),
			'FormModalDescription' => __('Start designing your form with a pre-built template', 'mrm'),
			'FormCategories' => __('Form Categories', 'mrm'),
			'ShortcodeCopied' => __('Shortcode copied ! ', 'mrm'),
			'NoTagListAssigned' => __('Neither lists nor tags are assigned to be published.', 'mrm'),
			'FormDuplicatedSuccessfully' => __('Form has been duplicated successfully.', 'mrm'),
			'FormTitleLimitMsg' => __('Form title character limit reached 150 characters', 'mrm'),
			'ExitFormBuilder' => __('Exit Form Builder?', 'mrm'),
			'ExitFormBuilderLabel' => __('You have unsaved changes that may not be saved if you exit now. Are you sure you want to exit the form builder now?', 'mrm'),
			'NewFluentFormBooking' =>__('This automation will be triggered when a new booking has been confirmed.','mrm'),
			'CancelledFluentFormBooking' =>__('This automation will be triggered when a booking is cancelled.','mrm'),
			'RescheduledFluentFormBooking' =>__('This automation will be triggered when a booking has been rescheduled.','mrm'),
			// Form Builder
			'NewMessageFromMailMint'     => __('New message from Mail Mint', 'mrm'),
			'SearchPlaceholder'          => __('Please enter 3 or more characters', 'mrm'),
			'FormSubmittedSuccessfully'  => __('Form submitted successfully.', 'mrm'),
			'FormRedirectMsg'            => __('Welcome to this page. Form Submitted Successfully!', 'mrm'),
			'RedirectedToNewURL'         => __('You are redirected to a new url.', 'mrm'),
			'ClickHere'                  => __('Click Here', 'mrm'),
			'NoPostFound'                => __('No post found', 'mrm'),
			'NoPageFound'                => __('No page found', 'mrm'),
			'NoTagFound'                 => __('No tag found', 'mrm'),
			'ConfirmationType'           => __('Confirmation Type', 'mrm'),
			'ConfirmationTypeTooltip'    => __('Choose the type of action after form submission.', 'mrm'),
			'SamePage'                   => __('Same Page', 'mrm'),
			'ToAPage'                    => __('To a Page', 'mrm'),
			'ToACustomURL'               => __('To A Custom URL', 'mrm'),
			'MessageToShow'              => __('Message to show', 'mrm'),
			'MessageToShowTooltip'       => __('Enter the text you would like the user to see on the confirmation page of this form.', 'mrm'),
			'AfterFormSubmission'        => __('After Form Submission', 'mrm'),
			'AfterFormSubmissionTooltip' => __('Define behaviour of the form after submission', 'mrm'),
			'None'                       => __('None', 'mrm'),
			'HideForm'                   => __('Hide Form', 'mrm'),
			'ResetForm'                  => __('Reset Form', 'mrm'),
			'SelectAPage'                => __('Select a page', 'mrm'),
			'SelectAPageTooltip'         => __('Select the page you would like the user to be redirected to after they have submitted the form.', 'mrm'),
			'RedirectionMessage'         => __('Redirection Message', 'mrm'),
			'RedirectionMessageTooltip'  => __('Enter the text you would like the user to see on the confirmation page when redirecting.', 'mrm'),
			'CustomURL'                  => __('Custom URL', 'mrm'),
			'EnterACustomURLToRedirect'  => __('Enter the URL of the webpage you would like the user to be redirected to after they have submitted the form.', 'mrm'),
			'URLValidationMsg' => __('**Warning : Your URL is not in a valid format**', 'mrm'),
			'RunAutomationMultipleTime' => __('Run Automation For a User Multiple Times', 'mrm'),
			'RunAutomationMultipleTimeTooltip' => __('If a user submits this form multiple times, then an existing automation created for this form will be triggered every time.', 'mrm'),
			'DisplayOption' => __('Display Option', 'mrm'),
			'DisplayOptionTooltip' => __('Choose what type of form you are creating.', 'mrm'),
			'HideFormFor' => __('Hide Form For', 'mrm'),
			'HideFormForTooltip' => __('The form will reappeared to the user after the expired days of the cookies', 'mrm'),
			'GetNotificationEveryTime' => __('Do you want an Admin notification for new form submissions?', 'mrm'),
			'GetNotificationEveryTimeTooltip' => __('Enabling this option will let the admin get a notification everytime a new form gets submitted', 'mrm'),
			'AdminEmailAddress' => __('Admin Email Address', 'mrm'),
			'AdminEmailAddressTooltip' => __('Enter the email address where you want the form submission notifications to be sent to', 'mrm'),
			'EnterASubjectLine' => __('Enter A Subject Line', 'mrm'),
			'EnterASubjectLineTooltip' => __('Write a subject line for the email that you want the admin to receive', 'mrm'),
			'Message' => __('Message', 'mrm'),
			'MessageTooltip' => __('Write your message and keep the [all-fields] tag to send the email to the admin with all the submission details', 'mrm'),
			'Layout' => __('Layout', 'mrm'),
			'LayoutTooltip' => __('Choose what type of form you are creating.', 'mrm'),
			'InitiateOnButtonClick' => __('Initiate On Button Click', 'mrm'),
			'InitiateOnButtonClickTooltip' => __('If this is enabled, then rather than being a direct pop-up, you will get a button. When someone clicks on the button, the pop-up will appear.', 'mrm'),
			'ButtonText' => __('Button Text', 'mrm'),
			'PopUpTimeDelay' => __('Pop-up Time Delay', 'mrm'),
			'PopUpTimeDelayTooltip' => __('Set a time after which the pop-up will appear on a page.', 'mrm'),
			'FlyInsTimeDelay' => __('Fly-ins Time Delay', 'mrm'),
			'FlyInsTimeDelayTooltip' => __('Set a time after which the Fly-ins will appear on a page.', 'mrm'),
			'AnimationType' => __('Animation Type', 'mrm'),
			'AnimationTypeTooltip' => __('Type of animation to show your form', 'mrm'),
			'DisplayOnTheHomepage' => __('Display on the homepage', 'mrm'),
			'DisplayOnAllPages' => __('Display on all pages', 'mrm'),
			'SelectPages' => __('Select pages', 'mrm'),
			'SelectPagesTooltip' => __('Form will appear on selected page(s).', 'mrm'),
			'DisplayOnAllPosts' => __('Display on all posts', 'mrm'),
			'SelectPosts' => __('Select posts', 'mrm'),
			'SelectPostsTooltip' => __('Form will appear on selected post(s).', 'mrm'),
			'DisplayOnAllProducts' => __('Display on all products', 'mrm'),
			'SelectProducts' => __('Select products', 'mrm'),
			'SelectProductsTooltip' => __('Form will appear on selected product(s).', 'mrm'),
			'DisplayPostProductWithCategory' => __('Display on posts/products with these categories', 'mrm'),
			'DisplayPostProductWithCategoryTooltip' => __('Form will appear on selected categories.', 'mrm'),
			'DisplayPostProductWithTag' => __('Display on posts/products with these tags', 'mrm'),
			'DisplayPostProductWithTagTooltip' => __('Form will appear on selected tag(s).', 'mrm'),
			'DisplayProductPostArchive' => __('Display on all post/product category archives', 'mrm'),
			'SelectCategory' => __('Select category', 'mrm'),
			'SelectCategoryTooltip' => __('Form will appear on selected category(s).', 'mrm'),
			'DisplayPostProductTagArchive' => __('Display on all post/product tag archives', 'mrm'),
			'SelectTagTooltip' => __('Form will appear on selected tag(s).', 'mrm'),
			'IconColor' => __('Icon Color', 'mrm'),
			'BackgroundColor' => __('Background Color', 'mrm'),
			'SelectWooCommerceEvent' => __('Select WooCommerce Event', 'mrm'),
			'SaveAsTemplate' => __('Save As Template', 'mrm'),
			'SwitchTemplate' => __('Switch Template', 'mrm'),
			'ReplaceWooCommerceEmail' => __('Replace WooCommerce Email', 'mrm'),
			'TemplateName' => __('Template Name', 'mrm'),
			'SendTestEmail' => __('Send A Test Email', 'mrm'),
			'ChooseYourTemplateName' => __('Choose Your Template Name', 'mrm'),

			'SelectTheContactDataFieldsThatYouWantToExport' => __('Select the contact data fields that you want to export.', 'mrm'),
			'NoFieldsSelectedPleaseChooseOneOrMoreFieldsToGenerateTheCSVFile' => __('No fields selected. Please choose one or more fields to generate the CSV file.', 'mrm'),
			'GetInstantAccessToExclusiveFeaturesWithTheProVersion' => __('Get Instant Access To Exclusive Features With The Pro Version.', 'mrm'),
			'PleaseNoteThatAllAssociatedDataOfTheChosenContactsWillReceiveADoubleOptinEmail' => __('Please note that all associated data of the chosen contacts will receive a double optin email.', 'mrm'),
			'PromptNewWPUsersToJoinMailMintListsToolTip' => __('Add a checkbox during user registration in your WordPress site to join your mailing lists.', 'mrm'),
			'PromptCommentersToJoinMailMintListsToolTip' => __('Add a checkbox when a user comments on your WordPress posts to join your mailing lists.', 'mrm'),
			'ContactCanSeeAllListsAndManageSubscriptions' => __('Contact can see all lists and manage subscriptions', 'mrm'),
			'ContactOnlySeeAndManageTheFollowingListSubscriptions' => __('Contact only see and manage the following list subscriptions', 'mrm'),

			'zohoBounceIntegrationDesc'   => __('Integrate ZeroBounce with Mail Mint for cleaner, more effective campaigns. Verify email addresses seamlessly and reduce bounce rates instantly.', 'mrm'),
			'IntegrationPageHeader'       => __('Bring your tools together to make the most of your data', 'mrm'),
			'ValidateWithZeroBounce'      => __('Apply ZeroBounce', 'mrm'),
			'ValidateWithZeroBounceTitle' => __('Apply Validation with ZeroBounce', 'mrm'),
			'ValidateWithZeroBounceDes'   => __('Instantly verify email addresses and minimize bounce rates by seamlessly validating your contact list.', 'mrm'),
			'zeroBounceListTooltip'       => __('After you connect ZeroBounce, you will get the option to verify your existing contact lists. At that time, all invalid emails will be added to this list.', 'mrm'),
			'VerifyEmails'                => __('Verify Emails', 'mrm'),

			'OpenBuilder' => __('Open Template Editor', 'mrm'),
			'NoTemplatesCreated' => __('No Templates Created', 'mrm'),
			'CustomizeEmails' => __('Customize Emails', 'mrm'),
			'CustomizeEmailsTooltip' => __('You can use the Mail Mint editor to customize the template used to send WooCommerce emails.', 'mrm'),

			'SendMessage' => __('Send Message', 'mrm'),
			'SendMessageDescription' => __('Send a message to the contact.', 'mrm'),
			'SendMessageSubTitle' => __('Dispatch text message through Twilio SMS marketing.', 'mrm'),
			'PhoneNumber' => __('Phone Number', 'mrm'),
			'PhoneNumberTooltip' => __('Use {{contact.phone_number}} or similar merge tag to auto-fill the phone number associated with the contact.', 'mrm'),
			'MessageBodyTooltip' => __('Use a compelling text for your message.', 'mrm'),
			'EnableDisable' => __('Enable/Disable', 'mrm'),
			'Actions' => __('Actions', 'mrm'),
			'Customize' => __('Customize', 'mrm'),

			// Lead magnets.
			'LeadMagnets' => __('Lead Magnets', 'mrm'),
			'AddLeadMagnet' => __('Add Lead Magnet', 'mrm'),
			'NoLeadMagnetsFound' => __('No Lead Magnets Found', 'mrm'),
			'UploadMediaFile' => __('Upload Media File', 'mrm'),
			'TitleIsRequired' => __('Title is required.', 'mrm'),
			'MediaFileIsRequired' => __('Media file is required.', 'mrm'),
			'MediaUrl' => __('Media URL', 'mrm'),
			'CopyMediaURLToolTip' => __('Copy the generated URL and paste it into your email message.', 'mrm'),
			'DeleteLeadMagnet' => __('Delete Lead Magnet', 'mrm'),
			'AreYouSureDeleteLeadMagnet' => __('Are you sure you want to delete this lead magnet', 'mrm'),

			// Anniversary reminder trigger.
			'Anniversary' => __('Anniversary', 'mrm'),
			'AnniversaryDescription' => __('This automation will be triggered for contacts based on a special event or birthday.', 'mrm'),
			'SelectAnAttribute' => __('Select an attribute', 'mrm'),
			'WhenToCheck' => __('At what time dates should be checked?', 'mrm'),
			'WhenToCheckDescription' => __('Enter the time of the day you want Mail Mint to check the anniversary attribute of your contacts.', 'mrm'),
			'ChooseWhoCanEnterThisAutomation' => __('Filter who can enter this automation', 'mrm'),
			'AnniversaryAttributeTooltip' => __('Select the attribute that contains the anniversary date of the contact.', 'mrm'),

			// LearnDash Trigger
			'EnrollsInAGroup' => __('Enrolls in a Group', 'mrm'),
			'EnrollsInAGroupDescription' => __('This automation will start when a user is enrolled in a group.', 'mrm'),
			'SelectGroupsS' => __('Select group(s)', 'mrm'),
			'SelectGroupTooltip' => __('Keep it blank to run to any group enrollment.', 'mrm'),
			'CompletesATopic' => __('Completes a Topic', 'mrm'),
			'CompletesATopicDescription' => __('This automation will start when a student completes a topic.', 'mrm'),

			// LifterLMS
			'importLifterLMSHeading' => __('LifterLMS Users As Contacts', 'mrm'),
			'importLifterLMSCSVTitle' => __('The following table is just a preview of how all of your LifterLMS users will be mapped into Mail Mint Contacts.', 'mrm'),
			'ImportFromLifterLMS' => __('Import from LifterLMS', 'mrm'),
			'importLifterLMSTitle' => __('Import your LifterLMS users: selected course or membership or all users', 'mrm'),
			'importLifterLMSTooltip' => __('Choose whether to import users by course or mebership or import all users.', 'mrm'),
			'EnrollsInAMembershipDescription' => __('This automation will start when a student has been enrolled in a membership level.', 'mrm'),
			'SelectMembershipTooltip' => __('Leave it blank to trigger the automation for any membership level.', 'mrm'),

			// Post publish automation trigger.
			'PostPublish'                                 => __( 'Post Publish', 'mrm' ),
			'PostPublishDescription'                      => __( 'This automation will be triggered when a new blog post is published.', 'mrm' ),
			'PostPublishAttributeTooltip'                 => __( 'Leave it blank to trigger the automation for any post.', 'mrm' ),
			'AllPosts'                                    => __( 'All Posts', 'mrm' ),
			'Categories'                                  => __( 'Categories', 'mrm' ),
			'Tags'                                        => __( 'Tags', 'mrm' ),
			'Authors'                                     => __( 'Authors', 'mrm' ),
			'ChoosePostCriteria'                          => __( 'Choose Post Criteria', 'mrm' ),
			'SelectACriteria'                             => __( 'Any Criteria', 'mrm' ),
			'PostCategorySelectTooltip'                   => __( 'Leave it blank to trigger the automation for any post category.', 'mrm' ),
			'PostTagSelectTooltip'                        => __( 'Leave it blank to trigger the automation for any post tag.', 'mrm' ),
			'ChooseAuthorS'                               => __( 'Choose Author(s)', 'mrm' ),
			'ChooseAuthorTooltip'                         => __( 'Leave it blank to trigger the automation for any author.', 'mrm' ),
			'ChoosePostType'                              => __( 'Choose Post Type', 'mrm' ),
			'ChoosePostTypeTooltip'                       => __( 'Select post type for which you want to trigger this automation.', 'mrm' ),

			//Welcome - step one
			'welcomeStepText' => __('Welcome', 'mrm'),
			'welcomeHeading' => __('Welcome to ', 'mrm'),
			'welcomeDescription' => __("Hey there! Let's get you started with Mail Mint - a super easy email marketing automation tool to manage leads, run email campaigns, and set up automation workflows.", 'mrm'),
			'welcomeBannerImgAlt' => __("Banner image", 'mrm'),
			'welcomeButtonTextNext' => __("Let's Start", 'mrm'),
			'welcomeButtonTextSkip' => __('Skip Setup Wizard', 'mrm'),

			//Business Info - step two
			'businessInfoStepText'      => __('Business Info', 'mrm'),
			'businessInfoHeadingStrong' => __('Business ', 'mrm'),
			'businessInfoHeading'       => __('Info ', 'mrm'),
			'businessInfoDescription'   => __("These will be used as your company information in your email campaign (if needed).", 'mrm'),
			'businessNameLabel'         => __('Business Name', 'mrm'),
			'businessAddressLabel'      => __('Business Full Address', 'mrm'),
			'businessInfoButtonText'    => __("Continue", 'mrm'),

			//Mail setup - step three
			'emailSetupStepText'       => __('Email Setup', 'mrm'),
			'emailSetupHeadingStrong'  => __('Email Setup ', 'mrm'),
			'emailSetupHeading'        => __('Frequency ', 'mrm'),
			'emailSetupDescription'    => __("Set up maximum number of emails to be sent within a specific time limit, usually set by your web host.", 'mrm'),
			'emailSetupFrequencyLabel' => __('Frequency Method', 'mrm'),
			'emailSetupFrequencyValue' =>[
               __('Recommended','mrm'),
			   __('Manual','mrm'),
			],
			'emailSetupWebHostLabel'   => __('Web Host', 'mrm'),
			'emailSetupAmountLabel'    => __('Email Amount', 'mrm'),
			'emailSetupTimeLabel'      => __('Time', 'mrm'), 
			'emailSetupFormWarning'    => __("You may break the terms of your web host or provider by sending more than the recommended emails per day. Contact your host if you want to send more.", "mrm"),
			'emailSetupButtonText'     => __("Continue", 'mrm'),
			'emailSetupButtonTextPrev' => __('Previous Step', 'mrm'),

			// Subscribe - step five.
			'subscribeStepText'                           => __( 'Subscribe', 'mrm' ),
			'subscribeHeadingStrong'                      => __( 'Join The List ', 'mrm' ),
			'subscribeHeading'                            => __( 'to Stay Updated With Mail Mint', 'mrm' ),
			'subscribeDescription'                        => __( 'Get exclusive offers, deals, news, and updates emailed to you directly by joining our exclusive email list.', 'mrm'),
			'subscribeButtonText'                         => __( 'Continue', 'mrm'),
			'subscribeButtonTextSkip'                     => __( 'Skip This Step', 'mrm' ),

			// Done - step six.
			'doneStepText'                                => __( 'Done', 'mrm' ),
			'doneHeading'                                 => __( 'You Are', 'mrm' ),
			'doneHeadingStrong'                           => __( 'Done', 'mrm' ),
			'donePosterImgAlt'                            => __( 'Poster image', 'mrm' ),
			'doneButtonText'                              => __( 'Go To Dashboard', 'mrm' ),

			// Double Optin Setup.
			'Double'                                      => __( 'Double', 'mrm' ),
			'OptIn'                                       => __( 'Opt-in', 'mrm' ),
			'OptInDescription'                            => __( 'Use double opt-in emails to verify pending contacts to confirm their email subscriptions.', 'mrm' ),
			'previousStep'                                => __( 'Previous Step', 'mrm' ),

			// Tools Module
			'linkTriggers'                                => __( 'Link Triggers', 'mrm' ),
			'newLinkTrigger'							  => __( 'New Link Trigger', 'mrm' ),
			'SortBy'									  => __( 'Sort by', 'mrm' ),
			'DeleteSelected'							  => __('Delete Selected', 'mrm'),
			'DeleteMultipleLinks'						  => __('Delete Multiple Links', 'mrm'),
			'DeleteMultipleLinksConfirm'				  => __('Are you sure you want to delete these selected items?', 'mrm'),
			'LinkCopied'								  => __('Link Copied', 'mrm'),
			'CreateNewLinkTrigger'						  => __('Create A New Link Trigger', 'mrm'),
			'EditLinkTrigger'							  => __('Edit Link Trigger', 'mrm'),
			'AddAction'								  	  => __('Add Action', 'mrm'),
			'RunMultipleTimes'							  => __('If enable then link will run multiple times', 'mrm'),
			'MultipleTimes'								  => __('Run multiple times', 'mrm'),
			'LogActionsAsContactNote'					  => __('Log Actions as Contact Note', 'mrm'),
			'EnableAutoLogin'							  => __('Enable Auto Login', 'mrm'),
			'AutoLoginTooltip'							  => __('Auto Login will work for all user roles except for Administrator and Editor.', 'mrm'),
			'RedirectURL'                                 => __('Redirect URL', 'mrm'),
			'TriggerURL'                                  => __( 'Trigger URL', 'mrm' ),
			// WooCommerce Subscriptions.
			'SubscriptionCreated'                         => __( 'Subscription Created', 'mrm' ),
			'SubscriptionCreatedDescription'              => __( 'This automation will trigger after a subscription is created, which happens before payment is confirmed.', 'mrm' ),
			'SubscriptionPaymentFailedDescription'        => __( 'This automation will trigger when a payment fails for a subscription.', 'mrm'),
			'SubscriptionContains'                        => __( 'Subscription Contains', 'mrm' ),
			'AnyProduct'                                  => __( 'Any product', 'mrm' ),
			'SpecificProducts'                            => __( 'Specific products', 'mrm'),
			'SpecificCategories'                          => __( 'Specific categories', 'mrm'),
			'SubscriptionStatusChanged'                   => __( 'Subscription Status Changed', 'mrm'),
			'SubscriptionStatusChangedDescription'        => __( 'This automation will trigger when the status of a subscription changes.', 'mrm'),
			'ImportRecipe'                                => __( 'Import Recipe', 'mrm' ),
			'CustomFields'								  => __( 'Custom Fields', 'mrm' ),
			'Business'									  => __( 'Business', 'mrm' ),
			'Post'										  => __( 'Post', 'mrm' ),
			'Links'									  	  => __( 'Links', 'mrm' ),
			'Website'									  => __( 'Website', 'mrm' ),
			'PostalZip'									  => __('Postal / Zip', 'mrm'),
			'StateProvince'								  => __('State / Province', 'mrm'),
			'LogoURL'									  => __('Logo URL', 'mrm'),
			'Author'									  => __('Author', 'mrm'),
			'Excerpt'									  => __('Excerpt', 'mrm'),
			'SubscribeLink'							  	  => __('Subscribe Link', 'mrm'),
			'SubscribeHTML'								  => __('Subscribe HTML', 'mrm'),
			'UnsubscribeLink'							  => __('Unsubscribe Link', 'mrm'),
			'UnsubscribeHTML'							  => __('Unsubscribe HTML', 'mrm'),
			'PreferenceLink'							  => __('Preference Link', 'mrm'),
			'PreferenceHTML'							  => __('Preference HTML', 'mrm'),
			'HomeURL'									  => __('Home URL', 'mrm'),
			'ShopURL'									  => __('Shop URL', 'mrm'),
			'MyAccountURL'								  => __('My Account URL', 'mrm'),
			'CheckoutURL'								  => __('Checkout URL', 'mrm'),
			'ResetPassword'								  => __('Reset Password', 'mrm'),
			'PaymentURL'								  => __('Payment URL', 'mrm'),
			'BounceTracking'						      => __('Bounce Tracking', 'mrm'),
			'BounceTrackingEnableTooltip'				  => __('Enable to capture bounced emails from the email service and mark Contact as Bounced.', 'mrm'),
			'MarkThisEmailAsTransactional'			      => __('Mark this email as Transactional', 'mrm'),
			'MarkThisEmailAsTransactionalTooltip'		  => __('Unsubscribed contacts will still receive transactional emails like Order Summaries, Renewal Reminders, and Admin notifications.', 'mrm'),
			'DeleteContacts'		   					  => __('Delete Contact', 'mrm'),
			'SubscribeContacts'		   					  => __('Subscribe Contact', 'mrm'),
			'UnSubscribeContacts'		   				  => __('Unsubscribe Contact', 'mrm'),
			'CustomUserPassTooltip'		   			      => __('If you leave blank, an auto-generated password will be set.', 'mrm'),

			// Order Details Custom Block
			'OrderDetails'   => __('Order Details', 'mrm'),
			'Product'        => __('Product', 'mrm'),
			'Price'          => __('Price', 'mrm'),
			'Subtotal'       => __('Subtotal', 'mrm'),
			'Shipping'       => __('Shipping', 'mrm'),
			'Tax'            => __('Tax', 'mrm'),
			'PaymentMethod' => __('Payment Method', 'mrm'),
			'Total'          => __('Total', 'mrm'),
			'Downloads'      => __('Downloads', 'mrm'),
			'Expires'         => __('Expires', 'mrm'),
			'Download' 	  => __('Download', 'mrm'),
			'SMTPWarningMessage' => __('You do not have any SMTP setup on your website. Please note that your website is using the default WP sending service, which is not recommended for sending promotional emails.', 'mrm'),
		);
	}
}
