<?php
/**
 * Mail Mint
 *
 * @author [MRM Team]
 * @email [support@getwpfunnels.com]
 * @create date 2022-08-09 11:03:17
 * @modify date 2022-08-09 11:03:17
 * @package /app
 */

namespace Mint\MRM\Internal;

use DateTime;
use DateTimeZone;
use Mint\Mrm\Internal\Traits\Singleton;

/**
 * [Manage Constant data in mrm  ]
 *
 * @desc Manage Constant data in mrm
 * @package /app/Internal/Ajax
 * @since 1.0.0
 */
class Constants {

	use Singleton;
	/**
	 * Contact attrs available for mapping
	 *
	 * @var string[]
	 */
	public static $contacts_attrs = array(
		'first_name',
		'last_name',
		'email',
		'date_of_birth',
		'company_name',
		'address_line_1',
		'address_line_2',
		'postal_code',
		'city',
		'state',
		'country',
		'phone',
	);

	/**
	 * Define plugin constants
	 *
	 * @since 1.0.0
	 */
	public function define_constants() {
		$this->define( 'MRM_ADMIN_ASSETS_FOLDER', MRM_DIR_PATH . 'assets/admin/' );
		$this->define( 'MRM_ADMIN_DIST_JS_FOLDER', 'assets/admin/dist/' );
		$this->define( 'MRM_ADMIN_DIST_CSS_FOLDER', 'assets/admin/dist/css/' );
		$this->define( 'MRM_ADMIN_EXTERNAL_JS_FOLDER', 'assets/admin/js/' );
		$this->define( 'MRM_ADMIN_EXTERNAL_CSS_FOLDER', 'assets/admin/css/' );
	}
	/**
	 * Define constant variable if not define .
	 *
	 * @param string $name path name .
	 * @param string $value path value .
	 * @since 1.0.0
	 */
	protected function define( $name, $value ) {
		if ( ! defined( $name ) ) {
			define( $name, $value );
		}
	}


	/**
	 * Return timezone list
	 *
	 * @return array
	 * @since 1.0.0
	 */
	public static function get_timezone_list() {
		static $regions = array(
			DateTimeZone::AFRICA,
			DateTimeZone::AMERICA,
			DateTimeZone::ANTARCTICA,
			DateTimeZone::ASIA,
			DateTimeZone::ATLANTIC,
			DateTimeZone::AUSTRALIA,
			DateTimeZone::EUROPE,
			DateTimeZone::INDIAN,
			DateTimeZone::PACIFIC,
		);

		$timezones = array();
		foreach ( $regions as $region ) {
			$timezones = array_merge( $timezones, DateTimeZone::listIdentifiers( $region ) );
		}

		$timezone_offsets = array();
		foreach ( $timezones as $timezone ) {
			try {
				$tz                            = new DateTimeZone( $timezone );
				$timezone_offsets[ $timezone ] = $tz->getOffset( new DateTime() );
			} catch ( \Exception $e ) {
				// Skip invalid timezone identifiers
				continue;
			}
		}

		asort( $timezone_offsets );

		$timezone_list = array();
		foreach ( $timezone_offsets as $timezone => $offset ) {
			$offset_prefix    = $offset < 0 ? '-' : '+';
			$offset_formatted = gmdate( 'H:i', abs( $offset ) );

			$pretty_offset = "UTC{$offset_prefix}{$offset_formatted}"; //phpcs:ignore

			$timezone_list[] = array(
				'value' => $timezone,
				'label' => "({$pretty_offset}) $timezone", //phpcs:ignore
			);
		}
		return $timezone_list;
	}
	/**
	 * Get Country name
	 *
	 * @return array[]
	 */
	public static function get_country_name() {
		return array(
			array(
				'code'  => 'AF',
				'title' => __( 'Afghanistan', 'mrm' ),
			),
			array(
				'code'  => 'AX',
				'title' => __( 'Åland Islands', 'mrm' ),
			),
			array(
				'code'  => 'AL',
				'title' => __( 'Albania', 'mrm' ),
			),
			array(
				'code'  => 'DZ',
				'title' => __( 'Algeria', 'mrm' ),
			),
			array(
				'code'  => 'AS',
				'title' => __( 'American Samoa', 'mrm' ),
			),
			array(
				'code'  => 'AD',
				'title' => __( 'Andorra', 'mrm' ),
			),
			array(
				'code'  => 'AO',
				'title' => __( 'Angola', 'mrm' ),
			),
			array(
				'code'  => 'AI',
				'title' => __( 'Anguilla', 'mrm' ),
			),
			array(
				'code'  => 'AQ',
				'title' => __( 'Antarctica', 'mrm' ),
			),
			array(
				'code'  => 'AG',
				'title' => __( 'Antigua and Barbuda', 'mrm' ),
			),
			array(
				'code'  => 'AR',
				'title' => __( 'Argentina', 'mrm' ),
			),
			array(
				'code'  => 'AM',
				'title' => __( 'Armenia', 'mrm' ),
			),
			array(
				'code'  => 'AW',
				'title' => __( 'Aruba', 'mrm' ),
			),
			array(
				'code'  => 'AU',
				'title' => __( 'Australia', 'mrm' ),
			),
			array(
				'code'  => 'AT',
				'title' => __( 'Austria', 'mrm' ),
			),
			array(
				'code'  => 'AZ',
				'title' => __( 'Azerbaijan', 'mrm' ),
			),
			array(
				'code'  => 'BS',
				'title' => __( 'Bahamas', 'mrm' ),
			),
			array(
				'code'  => 'BH',
				'title' => __( 'Bahrain', 'mrm' ),
			),
			array(
				'code'  => 'BD',
				'title' => __( 'Bangladesh', 'mrm' ),
			),
			array(
				'code'  => 'BB',
				'title' => __( 'Barbados', 'mrm' ),
			),
			array(
				'code'  => 'BY',
				'title' => __( 'Belarus', 'mrm' ),
			),
			array(
				'code'  => 'BE',
				'title' => __( 'Belgium', 'mrm' ),
			),
			array(
				'code'  => 'PW',
				'title' => __( 'Belau', 'mrm' ),
			),
			array(
				'code'  => 'BZ',
				'title' => __( 'Belize', 'mrm' ),
			),
			array(
				'code'  => 'BJ',
				'title' => __( 'Benin', 'mrm' ),
			),
			array(
				'code'  => 'BM',
				'title' => __( 'Bermuda', 'mrm' ),
			),
			array(
				'code'  => 'BT',
				'title' => __( 'Bhutan', 'mrm' ),
			),
			array(
				'code'  => 'BO',
				'title' => __( 'Bolivia', 'mrm' ),
			),
			array(
				'code'  => 'BQ',
				'title' => __( 'Bonaire, Saint Eustatius and Saba', 'mrm' ),
			),
			array(
				'code'  => 'BA',
				'title' => __( 'Bosnia and Herzegovina', 'mrm' ),
			),
			array(
				'code'  => 'BW',
				'title' => __( 'Botswana', 'mrm' ),
			),
			array(
				'code'  => 'BV',
				'title' => __( 'Bouvet Island', 'mrm' ),
			),
			array(
				'code'  => 'BR',
				'title' => __( 'Brazil', 'mrm' ),
			),
			array(
				'code'  => 'IO',
				'title' => __( 'British Indian Ocean Territory', 'mrm' ),
			),
			array(
				'code'  => 'BN',
				'title' => __( 'Brunei', 'mrm' ),
			),
			array(
				'code'  => 'BG',
				'title' => __( 'Bulgaria', 'mrm' ),
			),
			array(
				'code'  => 'BF',
				'title' => __( 'Burkina Faso', 'mrm' ),
			),
			array(
				'code'  => 'BI',
				'title' => __( 'Burundi', 'mrm' ),
			),
			array(
				'code'  => 'KH',
				'title' => __( 'Cambodia', 'mrm' ),
			),
			array(
				'code'  => 'CM',
				'title' => __( 'Cameroon', 'mrm' ),
			),
			array(
				'code'  => 'CA',
				'title' => __( 'Canada', 'mrm' ),
			),
			array(
				'code'  => 'CV',
				'title' => __( 'Cape Verde', 'mrm' ),
			),
			array(
				'code'  => 'KY',
				'title' => __( 'Cayman Islands', 'mrm' ),
			),
			array(
				'code'  => 'CF',
				'title' => __( 'Central African Republic', 'mrm' ),
			),
			array(
				'code'  => 'TD',
				'title' => __( 'Chad', 'mrm' ),
			),
			array(
				'code'  => 'CL',
				'title' => __( 'Chile', 'mrm' ),
			),
			array(
				'code'  => 'CN',
				'title' => __( 'China', 'mrm' ),
			),
			array(
				'code'  => 'CX',
				'title' => __( 'Christmas Island', 'mrm' ),
			),
			array(
				'code'  => 'CC',
				'title' => __( 'Cocos (Keeling) Islands', 'mrm' ),
			),
			array(
				'code'  => 'CO',
				'title' => __( 'Colombia', 'mrm' ),
			),
			array(
				'code'  => 'KM',
				'title' => __( 'Comoros', 'mrm' ),
			),
			array(
				'code'  => 'CG',
				'title' => __( 'Congo (Brazzaville)', 'mrm' ),
			),
			array(
				'code'  => 'CD',
				'title' => __( 'Congo (Kinshasa)', 'mrm' ),
			),
			array(
				'code'  => 'CK',
				'title' => __( 'Cook Islands', 'mrm' ),
			),
			array(
				'code'  => 'CR',
				'title' => __( 'Costa Rica', 'mrm' ),
			),
			array(
				'code'  => 'HR',
				'title' => __( 'Croatia', 'mrm' ),
			),
			array(
				'code'  => 'CU',
				'title' => __( 'Cuba', 'mrm' ),
			),
			array(
				'code'  => 'CW',
				'title' => __( 'Cura&ccedil;ao', 'mrm' ),
			),
			array(
				'code'  => 'CY',
				'title' => __( 'Cyprus', 'mrm' ),
			),
			array(
				'code'  => 'CZ',
				'title' => __( 'Czechia (Czech Republic)', 'mrm' ),
			),
			array(
				'code'  => 'DK',
				'title' => __( 'Denmark', 'mrm' ),
			),
			array(
				'code'  => 'DJ',
				'title' => __( 'Djibouti', 'mrm' ),
			),
			array(
				'code'  => 'DM',
				'title' => __( 'Dominica', 'mrm' ),
			),
			array(
				'code'  => 'DO',
				'title' => __( 'Dominican Republic', 'mrm' ),
			),
			array(
				'code'  => 'EC',
				'title' => __( 'Ecuador', 'mrm' ),
			),
			array(
				'code'  => 'EG',
				'title' => __( 'Egypt', 'mrm' ),
			),
			array(
				'code'  => 'SV',
				'title' => __( 'El Salvador', 'mrm' ),
			),
			array(
				'code'  => 'GQ',
				'title' => __( 'Equatorial Guinea', 'mrm' ),
			),
			array(
				'code'  => 'ER',
				'title' => __( 'Eritrea', 'mrm' ),
			),
			array(
				'code'  => 'EE',
				'title' => __( 'Estonia', 'mrm' ),
			),
			array(
				'code'  => 'ET',
				'title' => __( 'Ethiopia', 'mrm' ),
			),
			array(
				'code'  => 'FK',
				'title' => __( 'Falkland Islands', 'mrm' ),
			),
			array(
				'code'  => 'FO',
				'title' => __( 'Faroe Islands', 'mrm' ),
			),
			array(
				'code'  => 'FJ',
				'title' => __( 'Fiji', 'mrm' ),
			),
			array(
				'code'  => 'FI',
				'title' => __( 'Finland', 'mrm' ),
			),
			array(
				'code'  => 'FR',
				'title' => __( 'France', 'mrm' ),
			),
			array(
				'code'  => 'GF',
				'title' => __( 'French Guiana', 'mrm' ),
			),
			array(
				'code'  => 'PF',
				'title' => __( 'French Polynesia', 'mrm' ),
			),
			array(
				'code'  => 'TF',
				'title' => __( 'French Southern Territories', 'mrm' ),
			),
			array(
				'code'  => 'GA',
				'title' => __( 'Gabon', 'mrm' ),
			),
			array(
				'code'  => 'GM',
				'title' => __( 'Gambia', 'mrm' ),
			),
			array(
				'code'  => 'GE',
				'title' => __( 'Georgia', 'mrm' ),
			),
			array(
				'code'  => 'DE',
				'title' => __( 'Germany', 'mrm' ),
			),
			array(
				'code'  => 'GH',
				'title' => __( 'Ghana', 'mrm' ),
			),
			array(
				'code'  => 'GI',
				'title' => __( 'Gibraltar', 'mrm' ),
			),
			array(
				'code'  => 'GR',
				'title' => __( 'Greece', 'mrm' ),
			),
			array(
				'code'  => 'GL',
				'title' => __( 'Greenland', 'mrm' ),
			),
			array(
				'code'  => 'GD',
				'title' => __( 'Grenada', 'mrm' ),
			),
			array(
				'code'  => 'GP',
				'title' => __( 'Guadeloupe', 'mrm' ),
			),
			array(
				'code'  => 'GU',
				'title' => __( 'Guam', 'mrm' ),
			),
			array(
				'code'  => 'GT',
				'title' => __( 'Guatemala', 'mrm' ),
			),
			array(
				'code'  => 'GG',
				'title' => __( 'Guernsey', 'mrm' ),
			),
			array(
				'code'  => 'GN',
				'title' => __( 'Guinea', 'mrm' ),
			),
			array(
				'code'  => 'GW',
				'title' => __( 'Guinea-Bissau', 'mrm' ),
			),
			array(
				'code'  => 'GY',
				'title' => __( 'Guyana', 'mrm' ),
			),
			array(
				'code'  => 'HT',
				'title' => __( 'Haiti', 'mrm' ),
			),
			array(
				'code'  => 'HM',
				'title' => __( 'Heard Island and McDonald Islands', 'mrm' ),
			),
			array(
				'code'  => 'HN',
				'title' => __( 'Honduras', 'mrm' ),
			),
			array(
				'code'  => 'HK',
				'title' => __( 'Hong Kong', 'mrm' ),
			),
			array(
				'code'  => 'HU',
				'title' => __( 'Hungary', 'mrm' ),
			),
			array(
				'code'  => 'IS',
				'title' => __( 'Iceland', 'mrm' ),
			),
			array(
				'code'  => 'IN',
				'title' => __( 'India', 'mrm' ),
			),
			array(
				'code'  => 'ID',
				'title' => __( 'Indonesia', 'mrm' ),
			),
			array(
				'code'  => 'IR',
				'title' => __( 'Iran', 'mrm' ),
			),
			array(
				'code'  => 'IQ',
				'title' => __( 'Iraq', 'mrm' ),
			),
			array(
				'code'  => 'IE',
				'title' => __( 'Ireland', 'mrm' ),
			),
			array(
				'code'  => 'IM',
				'title' => __( 'Isle of Man', 'mrm' ),
			),
			array(
				'code'  => 'IL',
				'title' => __( 'Israel', 'mrm' ),
			),
			array(
				'code'  => 'IT',
				'title' => __( 'Italy', 'mrm' ),
			),
			array(
				'code'  => 'CI',
				'title' => __( 'Ivory Coast', 'mrm' ),
			),
			array(
				'code'  => 'JM',
				'title' => __( 'Jamaica', 'mrm' ),
			),
			array(
				'code'  => 'JP',
				'title' => __( 'Japan', 'mrm' ),
			),
			array(
				'code'  => 'JE',
				'title' => __( 'Jersey', 'mrm' ),
			),
			array(
				'code'  => 'JO',
				'title' => __( 'Jordan', 'mrm' ),
			),
			array(
				'code'  => 'KZ',
				'title' => __( 'Kazakhstan', 'mrm' ),
			),
			array(
				'code'  => 'KE',
				'title' => __( 'Kenya', 'mrm' ),
			),
			array(
				'code'  => 'KI',
				'title' => __( 'Kiribati', 'mrm' ),
			),
			array(
				'code'  => 'KW',
				'title' => __( 'Kuwait', 'mrm' ),
			),
			array(
				'code'  => 'XK',
				'title' => __( 'Kosovo', 'mrm' ),
			),
			array(
				'code'  => 'KG',
				'title' => __( 'Kyrgyzstan', 'mrm' ),
			),
			array(
				'code'  => 'LA',
				'title' => __( 'Laos', 'mrm' ),
			),
			array(
				'code'  => 'LV',
				'title' => __( 'Latvia', 'mrm' ),
			),
			array(
				'code'  => 'LB',
				'title' => __( 'Lebanon', 'mrm' ),
			),
			array(
				'code'  => 'LS',
				'title' => __( 'Lesotho', 'mrm' ),
			),
			array(
				'code'  => 'LR',
				'title' => __( 'Liberia', 'mrm' ),
			),
			array(
				'code'  => 'LY',
				'title' => __( 'Libya', 'mrm' ),
			),
			array(
				'code'  => 'LI',
				'title' => __( 'Liechtenstein', 'mrm' ),
			),
			array(
				'code'  => 'LT',
				'title' => __( 'Lithuania', 'mrm' ),
			),
			array(
				'code'  => 'LU',
				'title' => __( 'Luxembourg', 'mrm' ),
			),
			array(
				'code'  => 'MO',
				'title' => __( 'Macao', 'mrm' ),
			),
			array(
				'code'  => 'MK',
				'title' => __( 'North Macedonia', 'mrm' ),
			),
			array(
				'code'  => 'MG',
				'title' => __( 'Madagascar', 'mrm' ),
			),
			array(
				'code'  => 'MW',
				'title' => __( 'Malawi', 'mrm' ),
			),
			array(
				'code'  => 'MY',
				'title' => __( 'Malaysia', 'mrm' ),
			),
			array(
				'code'  => 'MV',
				'title' => __( 'Maldives', 'mrm' ),
			),
			array(
				'code'  => 'ML',
				'title' => __( 'Mali', 'mrm' ),
			),
			array(
				'code'  => 'MT',
				'title' => __( 'Malta', 'mrm' ),
			),
			array(
				'code'  => 'MH',
				'title' => __( 'Marshall Islands', 'mrm' ),
			),
			array(
				'code'  => 'MQ',
				'title' => __( 'Martinique', 'mrm' ),
			),
			array(
				'code'  => 'MR',
				'title' => __( 'Mauritania', 'mrm' ),
			),
			array(
				'code'  => 'MU',
				'title' => __( 'Mauritius', 'mrm' ),
			),
			array(
				'code'  => 'YT',
				'title' => __( 'Mayotte', 'mrm' ),
			),
			array(
				'code'  => 'MX',
				'title' => __( 'Mexico', 'mrm' ),
			),
			array(
				'code'  => 'FM',
				'title' => __( 'Micronesia', 'mrm' ),
			),
			array(
				'code'  => 'MD',
				'title' => __( 'Moldova', 'mrm' ),
			),
			array(
				'code'  => 'MC',
				'title' => __( 'Monaco', 'mrm' ),
			),
			array(
				'code'  => 'MN',
				'title' => __( 'Mongolia', 'mrm' ),
			),
			array(
				'code'  => 'ME',
				'title' => __( 'Montenegro', 'mrm' ),
			),
			array(
				'code'  => 'MS',
				'title' => __( 'Montserrat', 'mrm' ),
			),
			array(
				'code'  => 'MA',
				'title' => __( 'Morocco', 'mrm' ),
			),
			array(
				'code'  => 'MZ',
				'title' => __( 'Mozambique', 'mrm' ),
			),
			array(
				'code'  => 'MM',
				'title' => __( 'Myanmar', 'mrm' ),
			),
			array(
				'code'  => 'NA',
				'title' => __( 'Namibia', 'mrm' ),
			),
			array(
				'code'  => 'NR',
				'title' => __( 'Nauru', 'mrm' ),
			),
			array(
				'code'  => 'NP',
				'title' => __( 'Nepal', 'mrm' ),
			),
			array(
				'code'  => 'NL',
				'title' => __( 'Netherlands', 'mrm' ),
			),
			array(
				'code'  => 'NC',
				'title' => __( 'New Caledonia', 'mrm' ),
			),
			array(
				'code'  => 'NZ',
				'title' => __( 'New Zealand', 'mrm' ),
			),
			array(
				'code'  => 'NI',
				'title' => __( 'Nicaragua', 'mrm' ),
			),
			array(
				'code'  => 'NE',
				'title' => __( 'Niger', 'mrm' ),
			),
			array(
				'code'  => 'NG',
				'title' => __( 'Nigeria', 'mrm' ),
			),
			array(
				'code'  => 'NU',
				'title' => __( 'Niue', 'mrm' ),
			),
			array(
				'code'  => 'NF',
				'title' => __( 'Norfolk Island', 'mrm' ),
			),
			array(
				'code'  => 'MP',
				'title' => __( 'Northern Mariana Islands', 'mrm' ),
			),
			array(
				'code'  => 'KP',
				'title' => __( 'North Korea', 'mrm' ),
			),
			array(
				'code'  => 'NO',
				'title' => __( 'Norway', 'mrm' ),
			),
			array(
				'code'  => 'OM',
				'title' => __( 'Oman', 'mrm' ),
			),
			array(
				'code'  => 'PK',
				'title' => __( 'Pakistan', 'mrm' ),
			),
			array(
				'code'  => 'PS',
				'title' => __( 'Palestinian Territory', 'mrm' ),
			),
			array(
				'code'  => 'PA',
				'title' => __( 'Panama', 'mrm' ),
			),
			array(
				'code'  => 'PG',
				'title' => __( 'Papua New Guinea', 'mrm' ),
			),
			array(
				'code'  => 'PY',
				'title' => __( 'Paraguay', 'mrm' ),
			),
			array(
				'code'  => 'PE',
				'title' => __( 'Peru', 'mrm' ),
			),
			array(
				'code'  => 'PH',
				'title' => __( 'Philippines', 'mrm' ),
			),
			array(
				'code'  => 'PN',
				'title' => __( 'Pitcairn', 'mrm' ),
			),
			array(
				'code'  => 'PL',
				'title' => __( 'Poland', 'mrm' ),
			),
			array(
				'code'  => 'PT',
				'title' => __( 'Portugal', 'mrm' ),
			),
			array(
				'code'  => 'PR',
				'title' => __( 'Puerto Rico', 'mrm' ),
			),
			array(
				'code'  => 'QA',
				'title' => __( 'Qatar', 'mrm' ),
			),
			array(
				'code'  => 'RE',
				'title' => __( 'Reunion', 'mrm' ),
			),
			array(
				'code'  => 'RO',
				'title' => __( 'Romania', 'mrm' ),
			),
			array(
				'code'  => 'RU',
				'title' => __( 'Russia', 'mrm' ),
			),
			array(
				'code'  => 'RW',
				'title' => __( 'Rwanda', 'mrm' ),
			),
			array(
				'code'  => 'BL',
				'title' => __( 'Saint Barth&eacute;lemy', 'mrm' ),
			),
			array(
				'code'  => 'SH',
				'title' => __( 'Saint Helena', 'mrm' ),
			),
			array(
				'code'  => 'KN',
				'title' => __( 'Saint Kitts and Nevis', 'mrm' ),
			),
			array(
				'code'  => 'LC',
				'title' => __( 'Saint Lucia', 'mrm' ),
			),
			array(
				'code'  => 'MF',
				'title' => __( 'Saint Martin (French part)', 'mrm' ),
			),
			array(
				'code'  => 'SX',
				'title' => __( 'Saint Martin (Dutch part)', 'mrm' ),
			),
			array(
				'code'  => 'PM',
				'title' => __( 'Saint Pierre and Miquelon', 'mrm' ),
			),
			array(
				'code'  => 'VC',
				'title' => __( 'Saint Vincent and the Grenadines', 'mrm' ),
			),
			array(
				'code'  => 'SM',
				'title' => __( 'San Marino', 'mrm' ),
			),
			array(
				'code'  => 'ST',
				'title' => __( 'S&atilde;o Tom&eacute; and Pr&iacute;ncipe', 'mrm' ),
			),
			array(
				'code'  => 'SA',
				'title' => __( 'Saudi Arabia', 'mrm' ),
			),
			array(
				'code'  => 'SN',
				'title' => __( 'Senegal', 'mrm' ),
			),
			array(
				'code'  => 'RS',
				'title' => __( 'Serbia', 'mrm' ),
			),
			array(
				'code'  => 'SC',
				'title' => __( 'Seychelles', 'mrm' ),
			),
			array(
				'code'  => 'SL',
				'title' => __( 'Sierra Leone', 'mrm' ),
			),
			array(
				'code'  => 'SG',
				'title' => __( 'Singapore', 'mrm' ),
			),
			array(
				'code'  => 'SK',
				'title' => __( 'Slovakia', 'mrm' ),
			),
			array(
				'code'  => 'SI',
				'title' => __( 'Slovenia', 'mrm' ),
			),
			array(
				'code'  => 'SB',
				'title' => __( 'Solomon Islands', 'mrm' ),
			),
			array(
				'code'  => 'SO',
				'title' => __( 'Somalia', 'mrm' ),
			),
			array(
				'code'  => 'ZA',
				'title' => __( 'South Africa', 'mrm' ),
			),
			array(
				'code'  => 'GS',
				'title' => __( 'South Georgia/Sandwich Islands', 'mrm' ),
			),
			array(
				'code'  => 'KR',
				'title' => __( 'South Korea', 'mrm' ),
			),
			array(
				'code'  => 'SS',
				'title' => __( 'South Sudan', 'mrm' ),
			),
			array(
				'code'  => 'ES',
				'title' => __( 'Spain', 'mrm' ),
			),
			array(
				'code'  => 'LK',
				'title' => __( 'Sri Lanka', 'mrm' ),
			),
			array(
				'code'  => 'SD',
				'title' => __( 'Sudan', 'mrm' ),
			),
			array(
				'code'  => 'SR',
				'title' => __( 'Suriname', 'mrm' ),
			),
			array(
				'code'  => 'SJ',
				'title' => __( 'Svalbard and Jan Mayen', 'mrm' ),
			),
			array(
				'code'  => 'SZ',
				'title' => __( 'Swaziland', 'mrm' ),
			),
			array(
				'code'  => 'SE',
				'title' => __( 'Sweden', 'mrm' ),
			),
			array(
				'code'  => 'CH',
				'title' => __( 'Switzerland', 'mrm' ),
			),
			array(
				'code'  => 'SY',
				'title' => __( 'Syria', 'mrm' ),
			),
			array(
				'code'  => 'TW',
				'title' => __( 'Taiwan', 'mrm' ),
			),
			array(
				'code'  => 'TJ',
				'title' => __( 'Tajikistan', 'mrm' ),
			),
			array(
				'code'  => 'TZ',
				'title' => __( 'Tanzania', 'mrm' ),
			),
			array(
				'code'  => 'TH',
				'title' => __( 'Thailand', 'mrm' ),
			),
			array(
				'code'  => 'TL',
				'title' => __( 'Timor-Leste', 'mrm' ),
			),
			array(
				'code'  => 'TG',
				'title' => __( 'Togo', 'mrm' ),
			),
			array(
				'code'  => 'TK',
				'title' => __( 'Tokelau', 'mrm' ),
			),
			array(
				'code'  => 'TO',
				'title' => __( 'Tonga', 'mrm' ),
			),
			array(
				'code'  => 'TT',
				'title' => __( 'Trinidad and Tobago', 'mrm' ),
			),
			array(
				'code'  => 'TN',
				'title' => __( 'Tunisia', 'mrm' ),
			),
			array(
				'code'  => 'TR',
				'title' => __( 'Turkey', 'mrm' ),
			),
			array(
				'code'  => 'TM',
				'title' => __( 'Turkmenistan', 'mrm' ),
			),
			array(
				'code'  => 'TC',
				'title' => __( 'Turks and Caicos Islands', 'mrm' ),
			),
			array(
				'code'  => 'TV',
				'title' => __( 'Tuvalu', 'mrm' ),
			),
			array(
				'code'  => 'UG',
				'title' => __( 'Uganda', 'mrm' ),
			),
			array(
				'code'  => 'UA',
				'title' => __( 'Ukraine', 'mrm' ),
			),
			array(
				'code'  => 'AE',
				'title' => __( 'United Arab Emirates', 'mrm' ),
			),
			array(
				'code'  => 'GB',
				'title' => __( 'United Kingdom (UK)', 'mrm' ),
			),
			array(
				'code'  => 'US',
				'title' => __( 'United States (US)', 'mrm' ),
			),
			array(
				'code'  => 'UM',
				'title' => __( 'United States (US) Minor Outlying Islands', 'mrm' ),
			),
			array(
				'code'  => 'UY',
				'title' => __( 'Uruguay', 'mrm' ),
			),
			array(
				'code'  => 'UZ',
				'title' => __( 'Uzbekistan', 'mrm' ),
			),
			array(
				'code'  => 'VU',
				'title' => __( 'Vanuatu', 'mrm' ),
			),
			array(
				'code'  => 'VA',
				'title' => __( 'Vatican', 'mrm' ),
			),
			array(
				'code'  => 'VE',
				'title' => __( 'Venezuela', 'mrm' ),
			),
			array(
				'code'  => 'VN',
				'title' => __( 'Vietnam', 'mrm' ),
			),
			array(
				'code'  => 'VG',
				'title' => __( 'Virgin Islands (British)', 'mrm' ),
			),
			array(
				'code'  => 'VI',
				'title' => __( 'Virgin Islands (US)', 'mrm' ),
			),
			array(
				'code'  => 'WF',
				'title' => __( 'Wallis and Futuna', 'mrm' ),
			),
			array(
				'code'  => 'EH',
				'title' => __( 'Western Sahara', 'mrm' ),
			),
			array(
				'code'  => 'WS',
				'title' => __( 'Samoa', 'mrm' ),
			),
			array(
				'code'  => 'YE',
				'title' => __( 'Yemen', 'mrm' ),
			),
			array(
				'code'  => 'ZM',
				'title' => __( 'Zambia', 'mrm' ),
			),
			array(
				'code'  => 'ZW',
				'title' => __( 'Zimbabwe', 'mrm' ),
			),
		);
	}


	/**
	 * Return state list
	 *
	 * @return array
	 * @since 1.0.0
	 */
	public static function get_country_state() {
		return array(
			'AF' => array(),
			'AL' => array( // Albanian states.
				'AL-01' => __( 'Berat', 'mrm' ),
				'AL-09' => __( 'Dibër', 'mrm' ),
				'AL-02' => __( 'Durrës', 'mrm' ),
				'AL-03' => __( 'Elbasan', 'mrm' ),
				'AL-04' => __( 'Fier', 'mrm' ),
				'AL-05' => __( 'Gjirokastër', 'mrm' ),
				'AL-06' => __( 'Korçë', 'mrm' ),
				'AL-07' => __( 'Kukës', 'mrm' ),
				'AL-08' => __( 'Lezhë', 'mrm' ),
				'AL-10' => __( 'Shkodër', 'mrm' ),
				'AL-11' => __( 'Tirana', 'mrm' ),
				'AL-12' => __( 'Vlorë', 'mrm' ),
			),
			'AO' => array( // Angolan states.
				'BGO' => __( 'Bengo', 'mrm' ),
				'BLU' => __( 'Benguela', 'mrm' ),
				'BIE' => __( 'Bié', 'mrm' ),
				'CAB' => __( 'Cabinda', 'mrm' ),
				'CNN' => __( 'Cunene', 'mrm' ),
				'HUA' => __( 'Huambo', 'mrm' ),
				'HUI' => __( 'Huíla', 'mrm' ),
				'CCU' => __( 'Kuando Kubango', 'mrm' ),
				'CNO' => __( 'Kwanza-Norte', 'mrm' ),
				'CUS' => __( 'Kwanza-Sul', 'mrm' ),
				'LUA' => __( 'Luanda', 'mrm' ),
				'LNO' => __( 'Lunda-Norte', 'mrm' ),
				'LSU' => __( 'Lunda-Sul', 'mrm' ),
				'MAL' => __( 'Malanje', 'mrm' ),
				'MOX' => __( 'Moxico', 'mrm' ),
				'NAM' => __( 'Namibe', 'mrm' ),
				'UIG' => __( 'Uíge', 'mrm' ),
				'ZAI' => __( 'Zaire', 'mrm' ),
			),
			'AR' => array( // Argentinian provinces.
				'C' => __( 'Ciudad Autónoma de Buenos Aires', 'mrm' ),
				'B' => __( 'Buenos Aires', 'mrm' ),
				'K' => __( 'Catamarca', 'mrm' ),
				'H' => __( 'Chaco', 'mrm' ),
				'U' => __( 'Chubut', 'mrm' ),
				'X' => __( 'Córdoba', 'mrm' ),
				'W' => __( 'Corrientes', 'mrm' ),
				'E' => __( 'Entre Ríos', 'mrm' ),
				'P' => __( 'Formosa', 'mrm' ),
				'Y' => __( 'Jujuy', 'mrm' ),
				'L' => __( 'La Pampa', 'mrm' ),
				'F' => __( 'La Rioja', 'mrm' ),
				'M' => __( 'Mendoza', 'mrm' ),
				'N' => __( 'Misiones', 'mrm' ),
				'Q' => __( 'Neuquén', 'mrm' ),
				'R' => __( 'Río Negro', 'mrm' ),
				'A' => __( 'Salta', 'mrm' ),
				'J' => __( 'San Juan', 'mrm' ),
				'D' => __( 'San Luis', 'mrm' ),
				'Z' => __( 'Santa Cruz', 'mrm' ),
				'S' => __( 'Santa Fe', 'mrm' ),
				'G' => __( 'Santiago del Estero', 'mrm' ),
				'V' => __( 'Tierra del Fuego', 'mrm' ),
				'T' => __( 'Tucumán', 'mrm' ),
			),
			'AT' => array(),
			'AU' => array( // Australian states.
				'ACT' => __( 'Australian Capital Territory', 'mrm' ),
				'NSW' => __( 'New South Wales', 'mrm' ),
				'NT'  => __( 'Northern Territory', 'mrm' ),
				'QLD' => __( 'Queensland', 'mrm' ),
				'SA'  => __( 'South Australia', 'mrm' ),
				'TAS' => __( 'Tasmania', 'mrm' ),
				'VIC' => __( 'Victoria', 'mrm' ),
				'WA'  => __( 'Western Australia', 'mrm' ),
			),
			'AX' => array(),
			'BD' => array( // Bangladeshi districts.
				'BD-05' => __( 'Bagerhat', 'mrm' ),
				'BD-01' => __( 'Bandarban', 'mrm' ),
				'BD-02' => __( 'Barguna', 'mrm' ),
				'BD-06' => __( 'Barishal', 'mrm' ),
				'BD-07' => __( 'Bhola', 'mrm' ),
				'BD-03' => __( 'Bogura', 'mrm' ),
				'BD-04' => __( 'Brahmanbaria', 'mrm' ),
				'BD-09' => __( 'Chandpur', 'mrm' ),
				'BD-10' => __( 'Chattogram', 'mrm' ),
				'BD-12' => __( 'Chuadanga', 'mrm' ),
				'BD-11' => __( "Cox's Bazar", 'mrm' ),
				'BD-08' => __( 'Cumilla', 'mrm' ),
				'BD-13' => __( 'Dhaka', 'mrm' ),
				'BD-14' => __( 'Dinajpur', 'mrm' ),
				'BD-15' => __( 'Faridpur ', 'mrm' ),
				'BD-16' => __( 'Feni', 'mrm' ),
				'BD-19' => __( 'Gaibandha', 'mrm' ),
				'BD-18' => __( 'Gazipur', 'mrm' ),
				'BD-17' => __( 'Gopalganj', 'mrm' ),
				'BD-20' => __( 'Habiganj', 'mrm' ),
				'BD-21' => __( 'Jamalpur', 'mrm' ),
				'BD-22' => __( 'Jashore', 'mrm' ),
				'BD-25' => __( 'Jhalokati', 'mrm' ),
				'BD-23' => __( 'Jhenaidah', 'mrm' ),
				'BD-24' => __( 'Joypurhat', 'mrm' ),
				'BD-29' => __( 'Khagrachhari', 'mrm' ),
				'BD-27' => __( 'Khulna', 'mrm' ),
				'BD-26' => __( 'Kishoreganj', 'mrm' ),
				'BD-28' => __( 'Kurigram', 'mrm' ),
				'BD-30' => __( 'Kushtia', 'mrm' ),
				'BD-31' => __( 'Lakshmipur', 'mrm' ),
				'BD-32' => __( 'Lalmonirhat', 'mrm' ),
				'BD-36' => __( 'Madaripur', 'mrm' ),
				'BD-37' => __( 'Magura', 'mrm' ),
				'BD-33' => __( 'Manikganj ', 'mrm' ),
				'BD-39' => __( 'Meherpur', 'mrm' ),
				'BD-38' => __( 'Moulvibazar', 'mrm' ),
				'BD-35' => __( 'Munshiganj', 'mrm' ),
				'BD-34' => __( 'Mymensingh', 'mrm' ),
				'BD-48' => __( 'Naogaon', 'mrm' ),
				'BD-43' => __( 'Narail', 'mrm' ),
				'BD-40' => __( 'Narayanganj', 'mrm' ),
				'BD-42' => __( 'Narsingdi', 'mrm' ),
				'BD-44' => __( 'Natore', 'mrm' ),
				'BD-45' => __( 'Nawabganj', 'mrm' ),
				'BD-41' => __( 'Netrakona', 'mrm' ),
				'BD-46' => __( 'Nilphamari', 'mrm' ),
				'BD-47' => __( 'Noakhali', 'mrm' ),
				'BD-49' => __( 'Pabna', 'mrm' ),
				'BD-52' => __( 'Panchagarh', 'mrm' ),
				'BD-51' => __( 'Patuakhali', 'mrm' ),
				'BD-50' => __( 'Pirojpur', 'mrm' ),
				'BD-53' => __( 'Rajbari', 'mrm' ),
				'BD-54' => __( 'Rajshahi', 'mrm' ),
				'BD-56' => __( 'Rangamati', 'mrm' ),
				'BD-55' => __( 'Rangpur', 'mrm' ),
				'BD-58' => __( 'Satkhira', 'mrm' ),
				'BD-62' => __( 'Shariatpur', 'mrm' ),
				'BD-57' => __( 'Sherpur', 'mrm' ),
				'BD-59' => __( 'Sirajganj', 'mrm' ),
				'BD-61' => __( 'Sunamganj', 'mrm' ),
				'BD-60' => __( 'Sylhet', 'mrm' ),
				'BD-63' => __( 'Tangail', 'mrm' ),
				'BD-64' => __( 'Thakurgaon', 'mrm' ),
			),
			'BE' => array(),
			'BG' => array( // Bulgarian states.
				'BG-01' => __( 'Blagoevgrad', 'mrm' ),
				'BG-02' => __( 'Burgas', 'mrm' ),
				'BG-08' => __( 'Dobrich', 'mrm' ),
				'BG-07' => __( 'Gabrovo', 'mrm' ),
				'BG-26' => __( 'Haskovo', 'mrm' ),
				'BG-09' => __( 'Kardzhali', 'mrm' ),
				'BG-10' => __( 'Kyustendil', 'mrm' ),
				'BG-11' => __( 'Lovech', 'mrm' ),
				'BG-12' => __( 'Montana', 'mrm' ),
				'BG-13' => __( 'Pazardzhik', 'mrm' ),
				'BG-14' => __( 'Pernik', 'mrm' ),
				'BG-15' => __( 'Pleven', 'mrm' ),
				'BG-16' => __( 'Plovdiv', 'mrm' ),
				'BG-17' => __( 'Razgrad', 'mrm' ),
				'BG-18' => __( 'Ruse', 'mrm' ),
				'BG-27' => __( 'Shumen', 'mrm' ),
				'BG-19' => __( 'Silistra', 'mrm' ),
				'BG-20' => __( 'Sliven', 'mrm' ),
				'BG-21' => __( 'Smolyan', 'mrm' ),
				'BG-23' => __( 'Sofia District', 'mrm' ),
				'BG-22' => __( 'Sofia', 'mrm' ),
				'BG-24' => __( 'Stara Zagora', 'mrm' ),
				'BG-25' => __( 'Targovishte', 'mrm' ),
				'BG-03' => __( 'Varna', 'mrm' ),
				'BG-04' => __( 'Veliko Tarnovo', 'mrm' ),
				'BG-05' => __( 'Vidin', 'mrm' ),
				'BG-06' => __( 'Vratsa', 'mrm' ),
				'BG-28' => __( 'Yambol', 'mrm' ),
			),
			'BH' => array(),
			'BI' => array(),
			'BJ' => array( // Beninese states.
				'AL' => __( 'Alibori', 'mrm' ),
				'AK' => __( 'Atakora', 'mrm' ),
				'AQ' => __( 'Atlantique', 'mrm' ),
				'BO' => __( 'Borgou', 'mrm' ),
				'CO' => __( 'Collines', 'mrm' ),
				'KO' => __( 'Kouffo', 'mrm' ),
				'DO' => __( 'Donga', 'mrm' ),
				'LI' => __( 'Littoral', 'mrm' ),
				'MO' => __( 'Mono', 'mrm' ),
				'OU' => __( 'Ouémé', 'mrm' ),
				'PL' => __( 'Plateau', 'mrm' ),
				'ZO' => __( 'Zou', 'mrm' ),
			),
			'BO' => array( // Bolivian states.
				'BO-B' => __( 'Beni', 'mrm' ),
				'BO-H' => __( 'Chuquisaca', 'mrm' ),
				'BO-C' => __( 'Cochabamba', 'mrm' ),
				'BO-L' => __( 'La Paz', 'mrm' ),
				'BO-O' => __( 'Oruro', 'mrm' ),
				'BO-N' => __( 'Pando', 'mrm' ),
				'BO-P' => __( 'Potosí', 'mrm' ),
				'BO-S' => __( 'Santa Cruz', 'mrm' ),
				'BO-T' => __( 'Tarija', 'mrm' ),
			),
			'BR' => array( // Brazilian states.
				'AC' => __( 'Acre', 'mrm' ),
				'AL' => __( 'Alagoas', 'mrm' ),
				'AP' => __( 'Amapá', 'mrm' ),
				'AM' => __( 'Amazonas', 'mrm' ),
				'BA' => __( 'Bahia', 'mrm' ),
				'CE' => __( 'Ceará', 'mrm' ),
				'DF' => __( 'Distrito Federal', 'mrm' ),
				'ES' => __( 'Espírito Santo', 'mrm' ),
				'GO' => __( 'Goiás', 'mrm' ),
				'MA' => __( 'Maranhão', 'mrm' ),
				'MT' => __( 'Mato Grosso', 'mrm' ),
				'MS' => __( 'Mato Grosso do Sul', 'mrm' ),
				'MG' => __( 'Minas Gerais', 'mrm' ),
				'PA' => __( 'Pará', 'mrm' ),
				'PB' => __( 'Paraíba', 'mrm' ),
				'PR' => __( 'Paraná', 'mrm' ),
				'PE' => __( 'Pernambuco', 'mrm' ),
				'PI' => __( 'Piauí', 'mrm' ),
				'RJ' => __( 'Rio de Janeiro', 'mrm' ),
				'RN' => __( 'Rio Grande do Norte', 'mrm' ),
				'RS' => __( 'Rio Grande do Sul', 'mrm' ),
				'RO' => __( 'Rondônia', 'mrm' ),
				'RR' => __( 'Roraima', 'mrm' ),
				'SC' => __( 'Santa Catarina', 'mrm' ),
				'SP' => __( 'São Paulo', 'mrm' ),
				'SE' => __( 'Sergipe', 'mrm' ),
				'TO' => __( 'Tocantins', 'mrm' ),
			),
			'CA' => array( // Canadian states.
				'AB' => __( 'Alberta', 'mrm' ),
				'BC' => __( 'British Columbia', 'mrm' ),
				'MB' => __( 'Manitoba', 'mrm' ),
				'NB' => __( 'New Brunswick', 'mrm' ),
				'NL' => __( 'Newfoundland and Labrador', 'mrm' ),
				'NT' => __( 'Northwest Territories', 'mrm' ),
				'NS' => __( 'Nova Scotia', 'mrm' ),
				'NU' => __( 'Nunavut', 'mrm' ),
				'ON' => __( 'Ontario', 'mrm' ),
				'PE' => __( 'Prince Edward Island', 'mrm' ),
				'QC' => __( 'Quebec', 'mrm' ),
				'SK' => __( 'Saskatchewan', 'mrm' ),
				'YT' => __( 'Yukon Territory', 'mrm' ),
			),
			'CH' => array( // Swiss cantons.
				'AG' => __( 'Aargau', 'mrm' ),
				'AR' => __( 'Appenzell Ausserrhoden', 'mrm' ),
				'AI' => __( 'Appenzell Innerrhoden', 'mrm' ),
				'BL' => __( 'Basel-Landschaft', 'mrm' ),
				'BS' => __( 'Basel-Stadt', 'mrm' ),
				'BE' => __( 'Bern', 'mrm' ),
				'FR' => __( 'Fribourg', 'mrm' ),
				'GE' => __( 'Geneva', 'mrm' ),
				'GL' => __( 'Glarus', 'mrm' ),
				'GR' => __( 'Graubünden', 'mrm' ),
				'JU' => __( 'Jura', 'mrm' ),
				'LU' => __( 'Luzern', 'mrm' ),
				'NE' => __( 'Neuchâtel', 'mrm' ),
				'NW' => __( 'Nidwalden', 'mrm' ),
				'OW' => __( 'Obwalden', 'mrm' ),
				'SH' => __( 'Schaffhausen', 'mrm' ),
				'SZ' => __( 'Schwyz', 'mrm' ),
				'SO' => __( 'Solothurn', 'mrm' ),
				'SG' => __( 'St. Gallen', 'mrm' ),
				'TG' => __( 'Thurgau', 'mrm' ),
				'TI' => __( 'Ticino', 'mrm' ),
				'UR' => __( 'Uri', 'mrm' ),
				'VS' => __( 'Valais', 'mrm' ),
				'VD' => __( 'Vaud', 'mrm' ),
				'ZG' => __( 'Zug', 'mrm' ),
				'ZH' => __( 'Zürich', 'mrm' ),
			),
			'CL' => array( // Chilean states.
				'CL-AI' => __( 'Aisén del General Carlos Ibañez del Campo', 'mrm' ),
				'CL-AN' => __( 'Antofagasta', 'mrm' ),
				'CL-AP' => __( 'Arica y Parinacota', 'mrm' ),
				'CL-AR' => __( 'La Araucanía', 'mrm' ),
				'CL-AT' => __( 'Atacama', 'mrm' ),
				'CL-BI' => __( 'Biobío', 'mrm' ),
				'CL-CO' => __( 'Coquimbo', 'mrm' ),
				'CL-LI' => __( 'Libertador General Bernardo O\'Higgins', 'mrm' ),
				'CL-LL' => __( 'Los Lagos', 'mrm' ),
				'CL-LR' => __( 'Los Ríos', 'mrm' ),
				'CL-MA' => __( 'Magallanes', 'mrm' ),
				'CL-ML' => __( 'Maule', 'mrm' ),
				'CL-NB' => __( 'Ñuble', 'mrm' ),
				'CL-RM' => __( 'Región Metropolitana de Santiago', 'mrm' ),
				'CL-TA' => __( 'Tarapacá', 'mrm' ),
				'CL-VS' => __( 'Valparaíso', 'mrm' ),
			),
			'CN' => array( // Chinese states.
				'CN1'  => __( 'Yunnan / 云南', 'mrm' ),
				'CN2'  => __( 'Beijing / 北京', 'mrm' ),
				'CN3'  => __( 'Tianjin / 天津', 'mrm' ),
				'CN4'  => __( 'Hebei / 河北', 'mrm' ),
				'CN5'  => __( 'Shanxi / 山西', 'mrm' ),
				'CN6'  => __( 'Inner Mongolia / 內蒙古', 'mrm' ),
				'CN7'  => __( 'Liaoning / 辽宁', 'mrm' ),
				'CN8'  => __( 'Jilin / 吉林', 'mrm' ),
				'CN9'  => __( 'Heilongjiang / 黑龙江', 'mrm' ),
				'CN10' => __( 'Shanghai / 上海', 'mrm' ),
				'CN11' => __( 'Jiangsu / 江苏', 'mrm' ),
				'CN12' => __( 'Zhejiang / 浙江', 'mrm' ),
				'CN13' => __( 'Anhui / 安徽', 'mrm' ),
				'CN14' => __( 'Fujian / 福建', 'mrm' ),
				'CN15' => __( 'Jiangxi / 江西', 'mrm' ),
				'CN16' => __( 'Shandong / 山东', 'mrm' ),
				'CN17' => __( 'Henan / 河南', 'mrm' ),
				'CN18' => __( 'Hubei / 湖北', 'mrm' ),
				'CN19' => __( 'Hunan / 湖南', 'mrm' ),
				'CN20' => __( 'Guangdong / 广东', 'mrm' ),
				'CN21' => __( 'Guangxi Zhuang / 广西壮族', 'mrm' ),
				'CN22' => __( 'Hainan / 海南', 'mrm' ),
				'CN23' => __( 'Chongqing / 重庆', 'mrm' ),
				'CN24' => __( 'Sichuan / 四川', 'mrm' ),
				'CN25' => __( 'Guizhou / 贵州', 'mrm' ),
				'CN26' => __( 'Shaanxi / 陕西', 'mrm' ),
				'CN27' => __( 'Gansu / 甘肃', 'mrm' ),
				'CN28' => __( 'Qinghai / 青海', 'mrm' ),
				'CN29' => __( 'Ningxia Hui / 宁夏', 'mrm' ),
				'CN30' => __( 'Macao / 澳门', 'mrm' ),
				'CN31' => __( 'Tibet / 西藏', 'mrm' ),
				'CN32' => __( 'Xinjiang / 新疆', 'mrm' ),
			),
			'CO' => array( // Colombian states.
				'CO-AMA' => __( 'Amazonas', 'mrm' ),
				'CO-ANT' => __( 'Antioquia', 'mrm' ),
				'CO-ARA' => __( 'Arauca', 'mrm' ),
				'CO-ATL' => __( 'Atlántico', 'mrm' ),
				'CO-BOL' => __( 'Bolívar', 'mrm' ),
				'CO-BOY' => __( 'Boyacá', 'mrm' ),
				'CO-CAL' => __( 'Caldas', 'mrm' ),
				'CO-CAQ' => __( 'Caquetá', 'mrm' ),
				'CO-CAS' => __( 'Casanare', 'mrm' ),
				'CO-CAU' => __( 'Cauca', 'mrm' ),
				'CO-CES' => __( 'Cesar', 'mrm' ),
				'CO-CHO' => __( 'Chocó', 'mrm' ),
				'CO-COR' => __( 'Córdoba', 'mrm' ),
				'CO-CUN' => __( 'Cundinamarca', 'mrm' ),
				'CO-DC'  => __( 'Capital District', 'mrm' ),
				'CO-GUA' => __( 'Guainía', 'mrm' ),
				'CO-GUV' => __( 'Guaviare', 'mrm' ),
				'CO-HUI' => __( 'Huila', 'mrm' ),
				'CO-LAG' => __( 'La Guajira', 'mrm' ),
				'CO-MAG' => __( 'Magdalena', 'mrm' ),
				'CO-MET' => __( 'Meta', 'mrm' ),
				'CO-NAR' => __( 'Nariño', 'mrm' ),
				'CO-NSA' => __( 'Norte de Santander', 'mrm' ),
				'CO-PUT' => __( 'Putumayo', 'mrm' ),
				'CO-QUI' => __( 'Quindío', 'mrm' ),
				'CO-RIS' => __( 'Risaralda', 'mrm' ),
				'CO-SAN' => __( 'Santander', 'mrm' ),
				'CO-SAP' => __( 'San Andrés & Providencia', 'mrm' ),
				'CO-SUC' => __( 'Sucre', 'mrm' ),
				'CO-TOL' => __( 'Tolima', 'mrm' ),
				'CO-VAC' => __( 'Valle del Cauca', 'mrm' ),
				'CO-VAU' => __( 'Vaupés', 'mrm' ),
				'CO-VID' => __( 'Vichada', 'mrm' ),
			),
			'CR' => array( // Costa Rican states.
				'CR-A'  => __( 'Alajuela', 'mrm' ),
				'CR-C'  => __( 'Cartago', 'mrm' ),
				'CR-G'  => __( 'Guanacaste', 'mrm' ),
				'CR-H'  => __( 'Heredia', 'mrm' ),
				'CR-L'  => __( 'Limón', 'mrm' ),
				'CR-P'  => __( 'Puntarenas', 'mrm' ),
				'CR-SJ' => __( 'San José', 'mrm' ),
			),
			'CZ' => array(),
			'DE' => array( // German states.
				'DE-BW' => __( 'Baden-Württemberg', 'mrm' ),
				'DE-BY' => __( 'Bavaria', 'mrm' ),
				'DE-BE' => __( 'Berlin', 'mrm' ),
				'DE-BB' => __( 'Brandenburg', 'mrm' ),
				'DE-HB' => __( 'Bremen', 'mrm' ),
				'DE-HH' => __( 'Hamburg', 'mrm' ),
				'DE-HE' => __( 'Hesse', 'mrm' ),
				'DE-MV' => __( 'Mecklenburg-Vorpommern', 'mrm' ),
				'DE-NI' => __( 'Lower Saxony', 'mrm' ),
				'DE-NW' => __( 'North Rhine-Westphalia', 'mrm' ),
				'DE-RP' => __( 'Rhineland-Palatinate', 'mrm' ),
				'DE-SL' => __( 'Saarland', 'mrm' ),
				'DE-SN' => __( 'Saxony', 'mrm' ),
				'DE-ST' => __( 'Saxony-Anhalt', 'mrm' ),
				'DE-SH' => __( 'Schleswig-Holstein', 'mrm' ),
				'DE-TH' => __( 'Thuringia', 'mrm' ),
			),
			'DK' => array(),
			'DO' => array( // Dominican states.
				'DO-01' => __( 'Distrito Nacional', 'mrm' ),
				'DO-02' => __( 'Azua', 'mrm' ),
				'DO-03' => __( 'Baoruco', 'mrm' ),
				'DO-04' => __( 'Barahona', 'mrm' ),
				'DO-33' => __( 'Cibao Nordeste', 'mrm' ),
				'DO-34' => __( 'Cibao Noroeste', 'mrm' ),
				'DO-35' => __( 'Cibao Norte', 'mrm' ),
				'DO-36' => __( 'Cibao Sur', 'mrm' ),
				'DO-05' => __( 'Dajabón', 'mrm' ),
				'DO-06' => __( 'Duarte', 'mrm' ),
				'DO-08' => __( 'El Seibo', 'mrm' ),
				'DO-37' => __( 'El Valle', 'mrm' ),
				'DO-07' => __( 'Elías Piña', 'mrm' ),
				'DO-38' => __( 'Enriquillo', 'mrm' ),
				'DO-09' => __( 'Espaillat', 'mrm' ),
				'DO-30' => __( 'Hato Mayor', 'mrm' ),
				'DO-19' => __( 'Hermanas Mirabal', 'mrm' ),
				'DO-39' => __( 'Higüamo', 'mrm' ),
				'DO-10' => __( 'Independencia', 'mrm' ),
				'DO-11' => __( 'La Altagracia', 'mrm' ),
				'DO-12' => __( 'La Romana', 'mrm' ),
				'DO-13' => __( 'La Vega', 'mrm' ),
				'DO-14' => __( 'María Trinidad Sánchez', 'mrm' ),
				'DO-28' => __( 'Monseñor Nouel', 'mrm' ),
				'DO-15' => __( 'Monte Cristi', 'mrm' ),
				'DO-29' => __( 'Monte Plata', 'mrm' ),
				'DO-40' => __( 'Ozama', 'mrm' ),
				'DO-16' => __( 'Pedernales', 'mrm' ),
				'DO-17' => __( 'Peravia', 'mrm' ),
				'DO-18' => __( 'Puerto Plata', 'mrm' ),
				'DO-20' => __( 'Samaná', 'mrm' ),
				'DO-21' => __( 'San Cristóbal', 'mrm' ),
				'DO-31' => __( 'San José de Ocoa', 'mrm' ),
				'DO-22' => __( 'San Juan', 'mrm' ),
				'DO-23' => __( 'San Pedro de Macorís', 'mrm' ),
				'DO-24' => __( 'Sánchez Ramírez', 'mrm' ),
				'DO-25' => __( 'Santiago', 'mrm' ),
				'DO-26' => __( 'Santiago Rodríguez', 'mrm' ),
				'DO-32' => __( 'Santo Domingo', 'mrm' ),
				'DO-41' => __( 'Valdesia', 'mrm' ),
				'DO-27' => __( 'Valverde', 'mrm' ),
				'DO-42' => __( 'Yuma', 'mrm' ),
			),
			'DZ' => array( // Algerian states.
				'DZ-01' => __( 'Adrar', 'mrm' ),
				'DZ-02' => __( 'Chlef', 'mrm' ),
				'DZ-03' => __( 'Laghouat', 'mrm' ),
				'DZ-04' => __( 'Oum El Bouaghi', 'mrm' ),
				'DZ-05' => __( 'Batna', 'mrm' ),
				'DZ-06' => __( 'Béjaïa', 'mrm' ),
				'DZ-07' => __( 'Biskra', 'mrm' ),
				'DZ-08' => __( 'Béchar', 'mrm' ),
				'DZ-09' => __( 'Blida', 'mrm' ),
				'DZ-10' => __( 'Bouira', 'mrm' ),
				'DZ-11' => __( 'Tamanghasset', 'mrm' ),
				'DZ-12' => __( 'Tébessa', 'mrm' ),
				'DZ-13' => __( 'Tlemcen', 'mrm' ),
				'DZ-14' => __( 'Tiaret', 'mrm' ),
				'DZ-15' => __( 'Tizi Ouzou', 'mrm' ),
				'DZ-16' => __( 'Algiers', 'mrm' ),
				'DZ-17' => __( 'Djelfa', 'mrm' ),
				'DZ-18' => __( 'Jijel', 'mrm' ),
				'DZ-19' => __( 'Sétif', 'mrm' ),
				'DZ-20' => __( 'Saïda', 'mrm' ),
				'DZ-21' => __( 'Skikda', 'mrm' ),
				'DZ-22' => __( 'Sidi Bel Abbès', 'mrm' ),
				'DZ-23' => __( 'Annaba', 'mrm' ),
				'DZ-24' => __( 'Guelma', 'mrm' ),
				'DZ-25' => __( 'Constantine', 'mrm' ),
				'DZ-26' => __( 'Médéa', 'mrm' ),
				'DZ-27' => __( 'Mostaganem', 'mrm' ),
				'DZ-28' => __( 'M’Sila', 'mrm' ),
				'DZ-29' => __( 'Mascara', 'mrm' ),
				'DZ-30' => __( 'Ouargla', 'mrm' ),
				'DZ-31' => __( 'Oran', 'mrm' ),
				'DZ-32' => __( 'El Bayadh', 'mrm' ),
				'DZ-33' => __( 'Illizi', 'mrm' ),
				'DZ-34' => __( 'Bordj Bou Arréridj', 'mrm' ),
				'DZ-35' => __( 'Boumerdès', 'mrm' ),
				'DZ-36' => __( 'El Tarf', 'mrm' ),
				'DZ-37' => __( 'Tindouf', 'mrm' ),
				'DZ-38' => __( 'Tissemsilt', 'mrm' ),
				'DZ-39' => __( 'El Oued', 'mrm' ),
				'DZ-40' => __( 'Khenchela', 'mrm' ),
				'DZ-41' => __( 'Souk Ahras', 'mrm' ),
				'DZ-42' => __( 'Tipasa', 'mrm' ),
				'DZ-43' => __( 'Mila', 'mrm' ),
				'DZ-44' => __( 'Aïn Defla', 'mrm' ),
				'DZ-45' => __( 'Naama', 'mrm' ),
				'DZ-46' => __( 'Aïn Témouchent', 'mrm' ),
				'DZ-47' => __( 'Ghardaïa', 'mrm' ),
				'DZ-48' => __( 'Relizane', 'mrm' ),
			),
			'EE' => array(),
			'EC' => array( // Ecuadorian states.
				'EC-A'  => __( 'Azuay', 'mrm' ),
				'EC-B'  => __( 'Bolívar', 'mrm' ),
				'EC-F'  => __( 'Cañar', 'mrm' ),
				'EC-C'  => __( 'Carchi', 'mrm' ),
				'EC-H'  => __( 'Chimborazo', 'mrm' ),
				'EC-X'  => __( 'Cotopaxi', 'mrm' ),
				'EC-O'  => __( 'El Oro', 'mrm' ),
				'EC-E'  => __( 'Esmeraldas', 'mrm' ),
				'EC-W'  => __( 'Galápagos', 'mrm' ),
				'EC-G'  => __( 'Guayas', 'mrm' ),
				'EC-I'  => __( 'Imbabura', 'mrm' ),
				'EC-L'  => __( 'Loja', 'mrm' ),
				'EC-R'  => __( 'Los Ríos', 'mrm' ),
				'EC-M'  => __( 'Manabí', 'mrm' ),
				'EC-S'  => __( 'Morona-Santiago', 'mrm' ),
				'EC-N'  => __( 'Napo', 'mrm' ),
				'EC-D'  => __( 'Orellana', 'mrm' ),
				'EC-Y'  => __( 'Pastaza', 'mrm' ),
				'EC-P'  => __( 'Pichincha', 'mrm' ),
				'EC-SE' => __( 'Santa Elena', 'mrm' ),
				'EC-SD' => __( 'Santo Domingo de los Tsáchilas', 'mrm' ),
				'EC-U'  => __( 'Sucumbíos', 'mrm' ),
				'EC-T'  => __( 'Tungurahua', 'mrm' ),
				'EC-Z'  => __( 'Zamora-Chinchipe', 'mrm' ),
			),
			'EG' => array( // Egyptian states.
				'EGALX' => __( 'Alexandria', 'mrm' ),
				'EGASN' => __( 'Aswan', 'mrm' ),
				'EGAST' => __( 'Asyut', 'mrm' ),
				'EGBA'  => __( 'Red Sea', 'mrm' ),
				'EGBH'  => __( 'Beheira', 'mrm' ),
				'EGBNS' => __( 'Beni Suef', 'mrm' ),
				'EGC'   => __( 'Cairo', 'mrm' ),
				'EGDK'  => __( 'Dakahlia', 'mrm' ),
				'EGDT'  => __( 'Damietta', 'mrm' ),
				'EGFYM' => __( 'Faiyum', 'mrm' ),
				'EGGH'  => __( 'Gharbia', 'mrm' ),
				'EGGZ'  => __( 'Giza', 'mrm' ),
				'EGIS'  => __( 'Ismailia', 'mrm' ),
				'EGJS'  => __( 'South Sinai', 'mrm' ),
				'EGKB'  => __( 'Qalyubia', 'mrm' ),
				'EGKFS' => __( 'Kafr el-Sheikh', 'mrm' ),
				'EGKN'  => __( 'Qena', 'mrm' ),
				'EGLX'  => __( 'Luxor', 'mrm' ),
				'EGMN'  => __( 'Minya', 'mrm' ),
				'EGMNF' => __( 'Monufia', 'mrm' ),
				'EGMT'  => __( 'Matrouh', 'mrm' ),
				'EGPTS' => __( 'Port Said', 'mrm' ),
				'EGSHG' => __( 'Sohag', 'mrm' ),
				'EGSHR' => __( 'Al Sharqia', 'mrm' ),
				'EGSIN' => __( 'North Sinai', 'mrm' ),
				'EGSUZ' => __( 'Suez', 'mrm' ),
				'EGWAD' => __( 'New Valley', 'mrm' ),
			),
			'ES' => array( // Spanish states.
				'C'  => __( 'A Coruña', 'mrm' ),
				'VI' => __( 'Araba/Álava', 'mrm' ),
				'AB' => __( 'Albacete', 'mrm' ),
				'A'  => __( 'Alicante', 'mrm' ),
				'AL' => __( 'Almería', 'mrm' ),
				'O'  => __( 'Asturias', 'mrm' ),
				'AV' => __( 'Ávila', 'mrm' ),
				'BA' => __( 'Badajoz', 'mrm' ),
				'PM' => __( 'Baleares', 'mrm' ),
				'B'  => __( 'Barcelona', 'mrm' ),
				'BU' => __( 'Burgos', 'mrm' ),
				'CC' => __( 'Cáceres', 'mrm' ),
				'CA' => __( 'Cádiz', 'mrm' ),
				'S'  => __( 'Cantabria', 'mrm' ),
				'CS' => __( 'Castellón', 'mrm' ),
				'CE' => __( 'Ceuta', 'mrm' ),
				'CR' => __( 'Ciudad Real', 'mrm' ),
				'CO' => __( 'Córdoba', 'mrm' ),
				'CU' => __( 'Cuenca', 'mrm' ),
				'GI' => __( 'Girona', 'mrm' ),
				'GR' => __( 'Granada', 'mrm' ),
				'GU' => __( 'Guadalajara', 'mrm' ),
				'SS' => __( 'Gipuzkoa', 'mrm' ),
				'H'  => __( 'Huelva', 'mrm' ),
				'HU' => __( 'Huesca', 'mrm' ),
				'J'  => __( 'Jaén', 'mrm' ),
				'LO' => __( 'La Rioja', 'mrm' ),
				'GC' => __( 'Las Palmas', 'mrm' ),
				'LE' => __( 'León', 'mrm' ),
				'L'  => __( 'Lleida', 'mrm' ),
				'LU' => __( 'Lugo', 'mrm' ),
				'M'  => __( 'Madrid', 'mrm' ),
				'MA' => __( 'Málaga', 'mrm' ),
				'ML' => __( 'Melilla', 'mrm' ),
				'MU' => __( 'Murcia', 'mrm' ),
				'NA' => __( 'Navarra', 'mrm' ),
				'OR' => __( 'Ourense', 'mrm' ),
				'P'  => __( 'Palencia', 'mrm' ),
				'PO' => __( 'Pontevedra', 'mrm' ),
				'SA' => __( 'Salamanca', 'mrm' ),
				'TF' => __( 'Santa Cruz de Tenerife', 'mrm' ),
				'SG' => __( 'Segovia', 'mrm' ),
				'SE' => __( 'Sevilla', 'mrm' ),
				'SO' => __( 'Soria', 'mrm' ),
				'T'  => __( 'Tarragona', 'mrm' ),
				'TE' => __( 'Teruel', 'mrm' ),
				'TO' => __( 'Toledo', 'mrm' ),
				'V'  => __( 'Valencia', 'mrm' ),
				'VA' => __( 'Valladolid', 'mrm' ),
				'BI' => __( 'Biscay', 'mrm' ),
				'ZA' => __( 'Zamora', 'mrm' ),
				'Z'  => __( 'Zaragoza', 'mrm' ),
			),
			'FI' => array(),
			'FR' => array(),
			'GF' => array(),
			'GH' => array( // Ghanaian regions.
				'AF' => __( 'Ahafo', 'mrm' ),
				'AH' => __( 'Ashanti', 'mrm' ),
				'BA' => __( 'Brong-Ahafo', 'mrm' ),
				'BO' => __( 'Bono', 'mrm' ),
				'BE' => __( 'Bono East', 'mrm' ),
				'CP' => __( 'Central', 'mrm' ),
				'EP' => __( 'Eastern', 'mrm' ),
				'AA' => __( 'Greater Accra', 'mrm' ),
				'NE' => __( 'North East', 'mrm' ),
				'NP' => __( 'Northern', 'mrm' ),
				'OT' => __( 'Oti', 'mrm' ),
				'SV' => __( 'Savannah', 'mrm' ),
				'UE' => __( 'Upper East', 'mrm' ),
				'UW' => __( 'Upper West', 'mrm' ),
				'TV' => __( 'Volta', 'mrm' ),
				'WP' => __( 'Western', 'mrm' ),
				'WN' => __( 'Western North', 'mrm' ),
			),
			'GP' => array(),
			'GR' => array( // Greek regions.
				'I' => __( 'Attica', 'mrm' ),
				'A' => __( 'East Macedonia and Thrace', 'mrm' ),
				'B' => __( 'Central Macedonia', 'mrm' ),
				'C' => __( 'West Macedonia', 'mrm' ),
				'D' => __( 'Epirus', 'mrm' ),
				'E' => __( 'Thessaly', 'mrm' ),
				'F' => __( 'Ionian Islands', 'mrm' ),
				'G' => __( 'West Greece', 'mrm' ),
				'H' => __( 'Central Greece', 'mrm' ),
				'J' => __( 'Peloponnese', 'mrm' ),
				'K' => __( 'North Aegean', 'mrm' ),
				'L' => __( 'South Aegean', 'mrm' ),
				'M' => __( 'Crete', 'mrm' ),
			),
			'GT' => array( // Guatemalan states.
				'GT-AV' => __( 'Alta Verapaz', 'mrm' ),
				'GT-BV' => __( 'Baja Verapaz', 'mrm' ),
				'GT-CM' => __( 'Chimaltenango', 'mrm' ),
				'GT-CQ' => __( 'Chiquimula', 'mrm' ),
				'GT-PR' => __( 'El Progreso', 'mrm' ),
				'GT-ES' => __( 'Escuintla', 'mrm' ),
				'GT-GU' => __( 'Guatemala', 'mrm' ),
				'GT-HU' => __( 'Huehuetenango', 'mrm' ),
				'GT-IZ' => __( 'Izabal', 'mrm' ),
				'GT-JA' => __( 'Jalapa', 'mrm' ),
				'GT-JU' => __( 'Jutiapa', 'mrm' ),
				'GT-PE' => __( 'Petén', 'mrm' ),
				'GT-QZ' => __( 'Quetzaltenango', 'mrm' ),
				'GT-QC' => __( 'Quiché', 'mrm' ),
				'GT-RE' => __( 'Retalhuleu', 'mrm' ),
				'GT-SA' => __( 'Sacatepéquez', 'mrm' ),
				'GT-SM' => __( 'San Marcos', 'mrm' ),
				'GT-SR' => __( 'Santa Rosa', 'mrm' ),
				'GT-SO' => __( 'Sololá', 'mrm' ),
				'GT-SU' => __( 'Suchitepéquez', 'mrm' ),
				'GT-TO' => __( 'Totonicapán', 'mrm' ),
				'GT-ZA' => __( 'Zacapa', 'mrm' ),
			),
			'HK' => array( // Hong Kong states.
				'HONG KONG'       => __( 'Hong Kong Island', 'mrm' ),
				'KOWLOON'         => __( 'Kowloon', 'mrm' ),
				'NEW TERRITORIES' => __( 'New Territories', 'mrm' ),
			),
			'HN' => array( // Honduran states.
				'HN-AT' => __( 'Atlántida', 'mrm' ),
				'HN-IB' => __( 'Bay Islands', 'mrm' ),
				'HN-CH' => __( 'Choluteca', 'mrm' ),
				'HN-CL' => __( 'Colón', 'mrm' ),
				'HN-CM' => __( 'Comayagua', 'mrm' ),
				'HN-CP' => __( 'Copán', 'mrm' ),
				'HN-CR' => __( 'Cortés', 'mrm' ),
				'HN-EP' => __( 'El Paraíso', 'mrm' ),
				'HN-FM' => __( 'Francisco Morazán', 'mrm' ),
				'HN-GD' => __( 'Gracias a Dios', 'mrm' ),
				'HN-IN' => __( 'Intibucá', 'mrm' ),
				'HN-LE' => __( 'Lempira', 'mrm' ),
				'HN-LP' => __( 'La Paz', 'mrm' ),
				'HN-OC' => __( 'Ocotepeque', 'mrm' ),
				'HN-OL' => __( 'Olancho', 'mrm' ),
				'HN-SB' => __( 'Santa Bárbara', 'mrm' ),
				'HN-VA' => __( 'Valle', 'mrm' ),
				'HN-YO' => __( 'Yoro', 'mrm' ),
			),
			'HU' => array( // Hungarian states.
				'BK' => __( 'Bács-Kiskun', 'mrm' ),
				'BE' => __( 'Békés', 'mrm' ),
				'BA' => __( 'Baranya', 'mrm' ),
				'BZ' => __( 'Borsod-Abaúj-Zemplén', 'mrm' ),
				'BU' => __( 'Budapest', 'mrm' ),
				'CS' => __( 'Csongrád-Csanád', 'mrm' ),
				'FE' => __( 'Fejér', 'mrm' ),
				'GS' => __( 'Győr-Moson-Sopron', 'mrm' ),
				'HB' => __( 'Hajdú-Bihar', 'mrm' ),
				'HE' => __( 'Heves', 'mrm' ),
				'JN' => __( 'Jász-Nagykun-Szolnok', 'mrm' ),
				'KE' => __( 'Komárom-Esztergom', 'mrm' ),
				'NO' => __( 'Nógrád', 'mrm' ),
				'PE' => __( 'Pest', 'mrm' ),
				'SO' => __( 'Somogy', 'mrm' ),
				'SZ' => __( 'Szabolcs-Szatmár-Bereg', 'mrm' ),
				'TO' => __( 'Tolna', 'mrm' ),
				'VA' => __( 'Vas', 'mrm' ),
				'VE' => __( 'Veszprém', 'mrm' ),
				'ZA' => __( 'Zala', 'mrm' ),
			),
			'ID' => array( // Indonesian provinces.
				'AC' => __( 'Daerah Istimewa Aceh', 'mrm' ),
				'SU' => __( 'Sumatera Utara', 'mrm' ),
				'SB' => __( 'Sumatera Barat', 'mrm' ),
				'RI' => __( 'Riau', 'mrm' ),
				'KR' => __( 'Kepulauan Riau', 'mrm' ),
				'JA' => __( 'Jambi', 'mrm' ),
				'SS' => __( 'Sumatera Selatan', 'mrm' ),
				'BB' => __( 'Bangka Belitung', 'mrm' ),
				'BE' => __( 'Bengkulu', 'mrm' ),
				'LA' => __( 'Lampung', 'mrm' ),
				'JK' => __( 'DKI Jakarta', 'mrm' ),
				'JB' => __( 'Jawa Barat', 'mrm' ),
				'BT' => __( 'Banten', 'mrm' ),
				'JT' => __( 'Jawa Tengah', 'mrm' ),
				'JI' => __( 'Jawa Timur', 'mrm' ),
				'YO' => __( 'Daerah Istimewa Yogyakarta', 'mrm' ),
				'BA' => __( 'Bali', 'mrm' ),
				'NB' => __( 'Nusa Tenggara Barat', 'mrm' ),
				'NT' => __( 'Nusa Tenggara Timur', 'mrm' ),
				'KB' => __( 'Kalimantan Barat', 'mrm' ),
				'KT' => __( 'Kalimantan Tengah', 'mrm' ),
				'KI' => __( 'Kalimantan Timur', 'mrm' ),
				'KS' => __( 'Kalimantan Selatan', 'mrm' ),
				'KU' => __( 'Kalimantan Utara', 'mrm' ),
				'SA' => __( 'Sulawesi Utara', 'mrm' ),
				'ST' => __( 'Sulawesi Tengah', 'mrm' ),
				'SG' => __( 'Sulawesi Tenggara', 'mrm' ),
				'SR' => __( 'Sulawesi Barat', 'mrm' ),
				'SN' => __( 'Sulawesi Selatan', 'mrm' ),
				'GO' => __( 'Gorontalo', 'mrm' ),
				'MA' => __( 'Maluku', 'mrm' ),
				'MU' => __( 'Maluku Utara', 'mrm' ),
				'PA' => __( 'Papua', 'mrm' ),
				'PB' => __( 'Papua Barat', 'mrm' ),
			),
			'IE' => array( // Irish states.
				'CW' => __( 'Carlow', 'mrm' ),
				'CN' => __( 'Cavan', 'mrm' ),
				'CE' => __( 'Clare', 'mrm' ),
				'CO' => __( 'Cork', 'mrm' ),
				'DL' => __( 'Donegal', 'mrm' ),
				'D'  => __( 'Dublin', 'mrm' ),
				'G'  => __( 'Galway', 'mrm' ),
				'KY' => __( 'Kerry', 'mrm' ),
				'KE' => __( 'Kildare', 'mrm' ),
				'KK' => __( 'Kilkenny', 'mrm' ),
				'LS' => __( 'Laois', 'mrm' ),
				'LM' => __( 'Leitrim', 'mrm' ),
				'LK' => __( 'Limerick', 'mrm' ),
				'LD' => __( 'Longford', 'mrm' ),
				'LH' => __( 'Louth', 'mrm' ),
				'MO' => __( 'Mayo', 'mrm' ),
				'MH' => __( 'Meath', 'mrm' ),
				'MN' => __( 'Monaghan', 'mrm' ),
				'OY' => __( 'Offaly', 'mrm' ),
				'RN' => __( 'Roscommon', 'mrm' ),
				'SO' => __( 'Sligo', 'mrm' ),
				'TA' => __( 'Tipperary', 'mrm' ),
				'WD' => __( 'Waterford', 'mrm' ),
				'WH' => __( 'Westmeath', 'mrm' ),
				'WX' => __( 'Wexford', 'mrm' ),
				'WW' => __( 'Wicklow', 'mrm' ),
			),
			'IN' => array( // Indian states.
				'AP' => __( 'Andhra Pradesh', 'mrm' ),
				'AR' => __( 'Arunachal Pradesh', 'mrm' ),
				'AS' => __( 'Assam', 'mrm' ),
				'BR' => __( 'Bihar', 'mrm' ),
				'CT' => __( 'Chhattisgarh', 'mrm' ),
				'GA' => __( 'Goa', 'mrm' ),
				'GJ' => __( 'Gujarat', 'mrm' ),
				'HR' => __( 'Haryana', 'mrm' ),
				'HP' => __( 'Himachal Pradesh', 'mrm' ),
				'JK' => __( 'Jammu and Kashmir', 'mrm' ),
				'JH' => __( 'Jharkhand', 'mrm' ),
				'KA' => __( 'Karnataka', 'mrm' ),
				'KL' => __( 'Kerala', 'mrm' ),
				'LA' => __( 'Ladakh', 'mrm' ),
				'MP' => __( 'Madhya Pradesh', 'mrm' ),
				'MH' => __( 'Maharashtra', 'mrm' ),
				'MN' => __( 'Manipur', 'mrm' ),
				'ML' => __( 'Meghalaya', 'mrm' ),
				'MZ' => __( 'Mizoram', 'mrm' ),
				'NL' => __( 'Nagaland', 'mrm' ),
				'OR' => __( 'Odisha', 'mrm' ),
				'PB' => __( 'Punjab', 'mrm' ),
				'RJ' => __( 'Rajasthan', 'mrm' ),
				'SK' => __( 'Sikkim', 'mrm' ),
				'TN' => __( 'Tamil Nadu', 'mrm' ),
				'TS' => __( 'Telangana', 'mrm' ),
				'TR' => __( 'Tripura', 'mrm' ),
				'UK' => __( 'Uttarakhand', 'mrm' ),
				'UP' => __( 'Uttar Pradesh', 'mrm' ),
				'WB' => __( 'West Bengal', 'mrm' ),
				'AN' => __( 'Andaman and Nicobar Islands', 'mrm' ),
				'CH' => __( 'Chandigarh', 'mrm' ),
				'DN' => __( 'Dadra and Nagar Haveli', 'mrm' ),
				'DD' => __( 'Daman and Diu', 'mrm' ),
				'DL' => __( 'Delhi', 'mrm' ),
				'LD' => __( 'Lakshadeep', 'mrm' ),
				'PY' => __( 'Pondicherry (Puducherry)', 'mrm' ),
			),
			'IR' => array( // Irania states.
				'KHZ' => __( 'Khuzestan (خوزستان)', 'mrm' ),
				'THR' => __( 'Tehran (تهران)', 'mrm' ),
				'ILM' => __( 'Ilaam (ایلام)', 'mrm' ),
				'BHR' => __( 'Bushehr (بوشهر)', 'mrm' ),
				'ADL' => __( 'Ardabil (اردبیل)', 'mrm' ),
				'ESF' => __( 'Isfahan (اصفهان)', 'mrm' ),
				'YZD' => __( 'Yazd (یزد)', 'mrm' ),
				'KRH' => __( 'Kermanshah (کرمانشاه)', 'mrm' ),
				'KRN' => __( 'Kerman (کرمان)', 'mrm' ),
				'HDN' => __( 'Hamadan (همدان)', 'mrm' ),
				'GZN' => __( 'Ghazvin (قزوین)', 'mrm' ),
				'ZJN' => __( 'Zanjan (زنجان)', 'mrm' ),
				'LRS' => __( 'Luristan (لرستان)', 'mrm' ),
				'ABZ' => __( 'Alborz (البرز)', 'mrm' ),
				'EAZ' => __( 'East Azarbaijan (آذربایجان شرقی)', 'mrm' ),
				'WAZ' => __( 'West Azarbaijan (آذربایجان غربی)', 'mrm' ),
				'CHB' => __( 'Chaharmahal and Bakhtiari (چهارمحال و بختیاری)', 'mrm' ),
				'SKH' => __( 'South Khorasan (خراسان جنوبی)', 'mrm' ),
				'RKH' => __( 'Razavi Khorasan (خراسان رضوی)', 'mrm' ),
				'NKH' => __( 'North Khorasan (خراسان شمالی)', 'mrm' ),
				'SMN' => __( 'Semnan (سمنان)', 'mrm' ),
				'FRS' => __( 'Fars (فارس)', 'mrm' ),
				'QHM' => __( 'Qom (قم)', 'mrm' ),
				'KRD' => __( 'Kurdistan / کردستان)', 'mrm' ),
				'KBD' => __( 'Kohgiluyeh and BoyerAhmad (کهگیلوییه و بویراحمد)', 'mrm' ),
				'GLS' => __( 'Golestan (گلستان)', 'mrm' ),
				'GIL' => __( 'Gilan (گیلان)', 'mrm' ),
				'MZN' => __( 'Mazandaran (مازندران)', 'mrm' ),
				'MKZ' => __( 'Markazi (مرکزی)', 'mrm' ),
				'HRZ' => __( 'Hormozgan (هرمزگان)', 'mrm' ),
				'SBN' => __( 'Sistan and Baluchestan (سیستان و بلوچستان)', 'mrm' ),
			),
			'IS' => array(),
			'IT' => array( // Italian provinces.
				'AG' => __( 'Agrigento', 'mrm' ),
				'AL' => __( 'Alessandria', 'mrm' ),
				'AN' => __( 'Ancona', 'mrm' ),
				'AO' => __( 'Aosta', 'mrm' ),
				'AR' => __( 'Arezzo', 'mrm' ),
				'AP' => __( 'Ascoli Piceno', 'mrm' ),
				'AT' => __( 'Asti', 'mrm' ),
				'AV' => __( 'Avellino', 'mrm' ),
				'BA' => __( 'Bari', 'mrm' ),
				'BT' => __( 'Barletta-Andria-Trani', 'mrm' ),
				'BL' => __( 'Belluno', 'mrm' ),
				'BN' => __( 'Benevento', 'mrm' ),
				'BG' => __( 'Bergamo', 'mrm' ),
				'BI' => __( 'Biella', 'mrm' ),
				'BO' => __( 'Bologna', 'mrm' ),
				'BZ' => __( 'Bolzano', 'mrm' ),
				'BS' => __( 'Brescia', 'mrm' ),
				'BR' => __( 'Brindisi', 'mrm' ),
				'CA' => __( 'Cagliari', 'mrm' ),
				'CL' => __( 'Caltanissetta', 'mrm' ),
				'CB' => __( 'Campobasso', 'mrm' ),
				'CE' => __( 'Caserta', 'mrm' ),
				'CT' => __( 'Catania', 'mrm' ),
				'CZ' => __( 'Catanzaro', 'mrm' ),
				'CH' => __( 'Chieti', 'mrm' ),
				'CO' => __( 'Como', 'mrm' ),
				'CS' => __( 'Cosenza', 'mrm' ),
				'CR' => __( 'Cremona', 'mrm' ),
				'KR' => __( 'Crotone', 'mrm' ),
				'CN' => __( 'Cuneo', 'mrm' ),
				'EN' => __( 'Enna', 'mrm' ),
				'FM' => __( 'Fermo', 'mrm' ),
				'FE' => __( 'Ferrara', 'mrm' ),
				'FI' => __( 'Firenze', 'mrm' ),
				'FG' => __( 'Foggia', 'mrm' ),
				'FC' => __( 'Forlì-Cesena', 'mrm' ),
				'FR' => __( 'Frosinone', 'mrm' ),
				'GE' => __( 'Genova', 'mrm' ),
				'GO' => __( 'Gorizia', 'mrm' ),
				'GR' => __( 'Grosseto', 'mrm' ),
				'IM' => __( 'Imperia', 'mrm' ),
				'IS' => __( 'Isernia', 'mrm' ),
				'SP' => __( 'La Spezia', 'mrm' ),
				'AQ' => __( "L'Aquila", 'mrm' ),
				'LT' => __( 'Latina', 'mrm' ),
				'LE' => __( 'Lecce', 'mrm' ),
				'LC' => __( 'Lecco', 'mrm' ),
				'LI' => __( 'Livorno', 'mrm' ),
				'LO' => __( 'Lodi', 'mrm' ),
				'LU' => __( 'Lucca', 'mrm' ),
				'MC' => __( 'Macerata', 'mrm' ),
				'MN' => __( 'Mantova', 'mrm' ),
				'MS' => __( 'Massa-Carrara', 'mrm' ),
				'MT' => __( 'Matera', 'mrm' ),
				'ME' => __( 'Messina', 'mrm' ),
				'MI' => __( 'Milano', 'mrm' ),
				'MO' => __( 'Modena', 'mrm' ),
				'MB' => __( 'Monza e della Brianza', 'mrm' ),
				'NA' => __( 'Napoli', 'mrm' ),
				'NO' => __( 'Novara', 'mrm' ),
				'NU' => __( 'Nuoro', 'mrm' ),
				'OR' => __( 'Oristano', 'mrm' ),
				'PD' => __( 'Padova', 'mrm' ),
				'PA' => __( 'Palermo', 'mrm' ),
				'PR' => __( 'Parma', 'mrm' ),
				'PV' => __( 'Pavia', 'mrm' ),
				'PG' => __( 'Perugia', 'mrm' ),
				'PU' => __( 'Pesaro e Urbino', 'mrm' ),
				'PE' => __( 'Pescara', 'mrm' ),
				'PC' => __( 'Piacenza', 'mrm' ),
				'PI' => __( 'Pisa', 'mrm' ),
				'PT' => __( 'Pistoia', 'mrm' ),
				'PN' => __( 'Pordenone', 'mrm' ),
				'PZ' => __( 'Potenza', 'mrm' ),
				'PO' => __( 'Prato', 'mrm' ),
				'RG' => __( 'Ragusa', 'mrm' ),
				'RA' => __( 'Ravenna', 'mrm' ),
				'RC' => __( 'Reggio Calabria', 'mrm' ),
				'RE' => __( 'Reggio Emilia', 'mrm' ),
				'RI' => __( 'Rieti', 'mrm' ),
				'RN' => __( 'Rimini', 'mrm' ),
				'RM' => __( 'Roma', 'mrm' ),
				'RO' => __( 'Rovigo', 'mrm' ),
				'SA' => __( 'Salerno', 'mrm' ),
				'SS' => __( 'Sassari', 'mrm' ),
				'SV' => __( 'Savona', 'mrm' ),
				'SI' => __( 'Siena', 'mrm' ),
				'SR' => __( 'Siracusa', 'mrm' ),
				'SO' => __( 'Sondrio', 'mrm' ),
				'SU' => __( 'Sud Sardegna', 'mrm' ),
				'TA' => __( 'Taranto', 'mrm' ),
				'TE' => __( 'Teramo', 'mrm' ),
				'TR' => __( 'Terni', 'mrm' ),
				'TO' => __( 'Torino', 'mrm' ),
				'TP' => __( 'Trapani', 'mrm' ),
				'TN' => __( 'Trento', 'mrm' ),
				'TV' => __( 'Treviso', 'mrm' ),
				'TS' => __( 'Trieste', 'mrm' ),
				'UD' => __( 'Udine', 'mrm' ),
				'VA' => __( 'Varese', 'mrm' ),
				'VE' => __( 'Venezia', 'mrm' ),
				'VB' => __( 'Verbano-Cusio-Ossola', 'mrm' ),
				'VC' => __( 'Vercelli', 'mrm' ),
				'VR' => __( 'Verona', 'mrm' ),
				'VV' => __( 'Vibo Valentia', 'mrm' ),
				'VI' => __( 'Vicenza', 'mrm' ),
				'VT' => __( 'Viterbo', 'mrm' ),
			),
			'IL' => array(),
			'IM' => array(),
			'JM' => array( // Jamaican parishes.
				'JM-01' => __( 'Kingston', 'mrm' ),
				'JM-02' => __( 'Saint Andrew', 'mrm' ),
				'JM-03' => __( 'Saint Thomas', 'mrm' ),
				'JM-04' => __( 'Portland', 'mrm' ),
				'JM-05' => __( 'Saint Mary', 'mrm' ),
				'JM-06' => __( 'Saint Ann', 'mrm' ),
				'JM-07' => __( 'Trelawny', 'mrm' ),
				'JM-08' => __( 'Saint James', 'mrm' ),
				'JM-09' => __( 'Hanover', 'mrm' ),
				'JM-10' => __( 'Westmoreland', 'mrm' ),
				'JM-11' => __( 'Saint Elizabeth', 'mrm' ),
				'JM-12' => __( 'Manchester', 'mrm' ),
				'JM-13' => __( 'Clarendon', 'mrm' ),
				'JM-14' => __( 'Saint Catherine', 'mrm' ),
			),

			/**
			 * Japanese states.
			 *
			 * English notation of prefectures conform to the notation of Japan Post.
			 * The suffix corresponds with the Japanese translation file.
			 */
			'JP' => array(
				'JP01' => __( 'Hokkaido', 'mrm' ),
				'JP02' => __( 'Aomori', 'mrm' ),
				'JP03' => __( 'Iwate', 'mrm' ),
				'JP04' => __( 'Miyagi', 'mrm' ),
				'JP05' => __( 'Akita', 'mrm' ),
				'JP06' => __( 'Yamagata', 'mrm' ),
				'JP07' => __( 'Fukushima', 'mrm' ),
				'JP08' => __( 'Ibaraki', 'mrm' ),
				'JP09' => __( 'Tochigi', 'mrm' ),
				'JP10' => __( 'Gunma', 'mrm' ),
				'JP11' => __( 'Saitama', 'mrm' ),
				'JP12' => __( 'Chiba', 'mrm' ),
				'JP13' => __( 'Tokyo', 'mrm' ),
				'JP14' => __( 'Kanagawa', 'mrm' ),
				'JP15' => __( 'Niigata', 'mrm' ),
				'JP16' => __( 'Toyama', 'mrm' ),
				'JP17' => __( 'Ishikawa', 'mrm' ),
				'JP18' => __( 'Fukui', 'mrm' ),
				'JP19' => __( 'Yamanashi', 'mrm' ),
				'JP20' => __( 'Nagano', 'mrm' ),
				'JP21' => __( 'Gifu', 'mrm' ),
				'JP22' => __( 'Shizuoka', 'mrm' ),
				'JP23' => __( 'Aichi', 'mrm' ),
				'JP24' => __( 'Mie', 'mrm' ),
				'JP25' => __( 'Shiga', 'mrm' ),
				'JP26' => __( 'Kyoto', 'mrm' ),
				'JP27' => __( 'Osaka', 'mrm' ),
				'JP28' => __( 'Hyogo', 'mrm' ),
				'JP29' => __( 'Nara', 'mrm' ),
				'JP30' => __( 'Wakayama', 'mrm' ),
				'JP31' => __( 'Tottori', 'mrm' ),
				'JP32' => __( 'Shimane', 'mrm' ),
				'JP33' => __( 'Okayama', 'mrm' ),
				'JP34' => __( 'Hiroshima', 'mrm' ),
				'JP35' => __( 'Yamaguchi', 'mrm' ),
				'JP36' => __( 'Tokushima', 'mrm' ),
				'JP37' => __( 'Kagawa', 'mrm' ),
				'JP38' => __( 'Ehime', 'mrm' ),
				'JP39' => __( 'Kochi', 'mrm' ),
				'JP40' => __( 'Fukuoka', 'mrm' ),
				'JP41' => __( 'Saga', 'mrm' ),
				'JP42' => __( 'Nagasaki', 'mrm' ),
				'JP43' => __( 'Kumamoto', 'mrm' ),
				'JP44' => __( 'Oita', 'mrm' ),
				'JP45' => __( 'Miyazaki', 'mrm' ),
				'JP46' => __( 'Kagoshima', 'mrm' ),
				'JP47' => __( 'Okinawa', 'mrm' ),
			),
			'KE' => array( // Kenyan counties.
				'KE01' => __( 'Baringo', 'mrm' ),
				'KE02' => __( 'Bomet', 'mrm' ),
				'KE03' => __( 'Bungoma', 'mrm' ),
				'KE04' => __( 'Busia', 'mrm' ),
				'KE05' => __( 'Elgeyo-Marakwet', 'mrm' ),
				'KE06' => __( 'Embu', 'mrm' ),
				'KE07' => __( 'Garissa', 'mrm' ),
				'KE08' => __( 'Homa Bay', 'mrm' ),
				'KE09' => __( 'Isiolo', 'mrm' ),
				'KE10' => __( 'Kajiado', 'mrm' ),
				'KE11' => __( 'Kakamega', 'mrm' ),
				'KE12' => __( 'Kericho', 'mrm' ),
				'KE13' => __( 'Kiambu', 'mrm' ),
				'KE14' => __( 'Kilifi', 'mrm' ),
				'KE15' => __( 'Kirinyaga', 'mrm' ),
				'KE16' => __( 'Kisii', 'mrm' ),
				'KE17' => __( 'Kisumu', 'mrm' ),
				'KE18' => __( 'Kitui', 'mrm' ),
				'KE19' => __( 'Kwale', 'mrm' ),
				'KE20' => __( 'Laikipia', 'mrm' ),
				'KE21' => __( 'Lamu', 'mrm' ),
				'KE22' => __( 'Machakos', 'mrm' ),
				'KE23' => __( 'Makueni', 'mrm' ),
				'KE24' => __( 'Mandera', 'mrm' ),
				'KE25' => __( 'Marsabit', 'mrm' ),
				'KE26' => __( 'Meru', 'mrm' ),
				'KE27' => __( 'Migori', 'mrm' ),
				'KE28' => __( 'Mombasa', 'mrm' ),
				'KE29' => __( 'Murang’a', 'mrm' ),
				'KE30' => __( 'Nairobi County', 'mrm' ),
				'KE31' => __( 'Nakuru', 'mrm' ),
				'KE32' => __( 'Nandi', 'mrm' ),
				'KE33' => __( 'Narok', 'mrm' ),
				'KE34' => __( 'Nyamira', 'mrm' ),
				'KE35' => __( 'Nyandarua', 'mrm' ),
				'KE36' => __( 'Nyeri', 'mrm' ),
				'KE37' => __( 'Samburu', 'mrm' ),
				'KE38' => __( 'Siaya', 'mrm' ),
				'KE39' => __( 'Taita-Taveta', 'mrm' ),
				'KE40' => __( 'Tana River', 'mrm' ),
				'KE41' => __( 'Tharaka-Nithi', 'mrm' ),
				'KE42' => __( 'Trans Nzoia', 'mrm' ),
				'KE43' => __( 'Turkana', 'mrm' ),
				'KE44' => __( 'Uasin Gishu', 'mrm' ),
				'KE45' => __( 'Vihiga', 'mrm' ),
				'KE46' => __( 'Wajir', 'mrm' ),
				'KE47' => __( 'West Pokot', 'mrm' ),
			),
			'KR' => array(),
			'KW' => array(),
			'LA' => array( // Laotian provinces.
				'AT' => __( 'Attapeu', 'mrm' ),
				'BK' => __( 'Bokeo', 'mrm' ),
				'BL' => __( 'Bolikhamsai', 'mrm' ),
				'CH' => __( 'Champasak', 'mrm' ),
				'HO' => __( 'Houaphanh', 'mrm' ),
				'KH' => __( 'Khammouane', 'mrm' ),
				'LM' => __( 'Luang Namtha', 'mrm' ),
				'LP' => __( 'Luang Prabang', 'mrm' ),
				'OU' => __( 'Oudomxay', 'mrm' ),
				'PH' => __( 'Phongsaly', 'mrm' ),
				'SL' => __( 'Salavan', 'mrm' ),
				'SV' => __( 'Savannakhet', 'mrm' ),
				'VI' => __( 'Vientiane Province', 'mrm' ),
				'VT' => __( 'Vientiane', 'mrm' ),
				'XA' => __( 'Sainyabuli', 'mrm' ),
				'XE' => __( 'Sekong', 'mrm' ),
				'XI' => __( 'Xiangkhouang', 'mrm' ),
				'XS' => __( 'Xaisomboun', 'mrm' ),
			),
			'LB' => array(),
			'LI' => array(),
			'LR' => array( // Liberian provinces.
				'BM' => __( 'Bomi', 'mrm' ),
				'BN' => __( 'Bong', 'mrm' ),
				'GA' => __( 'Gbarpolu', 'mrm' ),
				'GB' => __( 'Grand Bassa', 'mrm' ),
				'GC' => __( 'Grand Cape Mount', 'mrm' ),
				'GG' => __( 'Grand Gedeh', 'mrm' ),
				'GK' => __( 'Grand Kru', 'mrm' ),
				'LO' => __( 'Lofa', 'mrm' ),
				'MA' => __( 'Margibi', 'mrm' ),
				'MY' => __( 'Maryland', 'mrm' ),
				'MO' => __( 'Montserrado', 'mrm' ),
				'NM' => __( 'Nimba', 'mrm' ),
				'RV' => __( 'Rivercess', 'mrm' ),
				'RG' => __( 'River Gee', 'mrm' ),
				'SN' => __( 'Sinoe', 'mrm' ),
			),
			'LU' => array(),
			'MD' => array( // Moldovan states.
				'C'  => __( 'Chișinău', 'mrm' ),
				'BL' => __( 'Bălți', 'mrm' ),
				'AN' => __( 'Anenii Noi', 'mrm' ),
				'BS' => __( 'Basarabeasca', 'mrm' ),
				'BR' => __( 'Briceni', 'mrm' ),
				'CH' => __( 'Cahul', 'mrm' ),
				'CT' => __( 'Cantemir', 'mrm' ),
				'CL' => __( 'Călărași', 'mrm' ),
				'CS' => __( 'Căușeni', 'mrm' ),
				'CM' => __( 'Cimișlia', 'mrm' ),
				'CR' => __( 'Criuleni', 'mrm' ),
				'DN' => __( 'Dondușeni', 'mrm' ),
				'DR' => __( 'Drochia', 'mrm' ),
				'DB' => __( 'Dubăsari', 'mrm' ),
				'ED' => __( 'Edineț', 'mrm' ),
				'FL' => __( 'Fălești', 'mrm' ),
				'FR' => __( 'Florești', 'mrm' ),
				'GE' => __( 'UTA Găgăuzia', 'mrm' ),
				'GL' => __( 'Glodeni', 'mrm' ),
				'HN' => __( 'Hîncești', 'mrm' ),
				'IL' => __( 'Ialoveni', 'mrm' ),
				'LV' => __( 'Leova', 'mrm' ),
				'NS' => __( 'Nisporeni', 'mrm' ),
				'OC' => __( 'Ocnița', 'mrm' ),
				'OR' => __( 'Orhei', 'mrm' ),
				'RZ' => __( 'Rezina', 'mrm' ),
				'RS' => __( 'Rîșcani', 'mrm' ),
				'SG' => __( 'Sîngerei', 'mrm' ),
				'SR' => __( 'Soroca', 'mrm' ),
				'ST' => __( 'Strășeni', 'mrm' ),
				'SD' => __( 'Șoldănești', 'mrm' ),
				'SV' => __( 'Ștefan Vodă', 'mrm' ),
				'TR' => __( 'Taraclia', 'mrm' ),
				'TL' => __( 'Telenești', 'mrm' ),
				'UN' => __( 'Ungheni', 'mrm' ),
			),
			'MF' => array(),
			'MQ' => array(),
			'MT' => array(),
			'MX' => array( // Mexican states.
				'DF' => __( 'Ciudad de México', 'mrm' ),
				'JA' => __( 'Jalisco', 'mrm' ),
				'NL' => __( 'Nuevo León', 'mrm' ),
				'AG' => __( 'Aguascalientes', 'mrm' ),
				'BC' => __( 'Baja California', 'mrm' ),
				'BS' => __( 'Baja California Sur', 'mrm' ),
				'CM' => __( 'Campeche', 'mrm' ),
				'CS' => __( 'Chiapas', 'mrm' ),
				'CH' => __( 'Chihuahua', 'mrm' ),
				'CO' => __( 'Coahuila', 'mrm' ),
				'CL' => __( 'Colima', 'mrm' ),
				'DG' => __( 'Durango', 'mrm' ),
				'GT' => __( 'Guanajuato', 'mrm' ),
				'GR' => __( 'Guerrero', 'mrm' ),
				'HG' => __( 'Hidalgo', 'mrm' ),
				'MX' => __( 'Estado de México', 'mrm' ),
				'MI' => __( 'Michoacán', 'mrm' ),
				'MO' => __( 'Morelos', 'mrm' ),
				'NA' => __( 'Nayarit', 'mrm' ),
				'OA' => __( 'Oaxaca', 'mrm' ),
				'PU' => __( 'Puebla', 'mrm' ),
				'QT' => __( 'Querétaro', 'mrm' ),
				'QR' => __( 'Quintana Roo', 'mrm' ),
				'SL' => __( 'San Luis Potosí', 'mrm' ),
				'SI' => __( 'Sinaloa', 'mrm' ),
				'SO' => __( 'Sonora', 'mrm' ),
				'TB' => __( 'Tabasco', 'mrm' ),
				'TM' => __( 'Tamaulipas', 'mrm' ),
				'TL' => __( 'Tlaxcala', 'mrm' ),
				'VE' => __( 'Veracruz', 'mrm' ),
				'YU' => __( 'Yucatán', 'mrm' ),
				'ZA' => __( 'Zacatecas', 'mrm' ),
			),
			'MY' => array( // Malaysian states.
				'JHR' => __( 'Johor', 'mrm' ),
				'KDH' => __( 'Kedah', 'mrm' ),
				'KTN' => __( 'Kelantan', 'mrm' ),
				'LBN' => __( 'Labuan', 'mrm' ),
				'MLK' => __( 'Malacca (Melaka)', 'mrm' ),
				'NSN' => __( 'Negeri Sembilan', 'mrm' ),
				'PHG' => __( 'Pahang', 'mrm' ),
				'PNG' => __( 'Penang (Pulau Pinang)', 'mrm' ),
				'PRK' => __( 'Perak', 'mrm' ),
				'PLS' => __( 'Perlis', 'mrm' ),
				'SBH' => __( 'Sabah', 'mrm' ),
				'SWK' => __( 'Sarawak', 'mrm' ),
				'SGR' => __( 'Selangor', 'mrm' ),
				'TRG' => __( 'Terengganu', 'mrm' ),
				'PJY' => __( 'Putrajaya', 'mrm' ),
				'KUL' => __( 'Kuala Lumpur', 'mrm' ),
			),
			'MZ' => array( // Mozambican provinces.
				'MZP'   => __( 'Cabo Delgado', 'mrm' ),
				'MZG'   => __( 'Gaza', 'mrm' ),
				'MZI'   => __( 'Inhambane', 'mrm' ),
				'MZB'   => __( 'Manica', 'mrm' ),
				'MZL'   => __( 'Maputo Province', 'mrm' ),
				'MZMPM' => __( 'Maputo', 'mrm' ),
				'MZN'   => __( 'Nampula', 'mrm' ),
				'MZA'   => __( 'Niassa', 'mrm' ),
				'MZS'   => __( 'Sofala', 'mrm' ),
				'MZT'   => __( 'Tete', 'mrm' ),
				'MZQ'   => __( 'Zambézia', 'mrm' ),
			),
			'NA' => array( // Namibian regions.
				'ER' => __( 'Erongo', 'mrm' ),
				'HA' => __( 'Hardap', 'mrm' ),
				'KA' => __( 'Karas', 'mrm' ),
				'KE' => __( 'Kavango East', 'mrm' ),
				'KW' => __( 'Kavango West', 'mrm' ),
				'KH' => __( 'Khomas', 'mrm' ),
				'KU' => __( 'Kunene', 'mrm' ),
				'OW' => __( 'Ohangwena', 'mrm' ),
				'OH' => __( 'Omaheke', 'mrm' ),
				'OS' => __( 'Omusati', 'mrm' ),
				'ON' => __( 'Oshana', 'mrm' ),
				'OT' => __( 'Oshikoto', 'mrm' ),
				'OD' => __( 'Otjozondjupa', 'mrm' ),
				'CA' => __( 'Zambezi', 'mrm' ),
			),
			'NG' => array( // Nigerian provinces.
				'AB' => __( 'Abia', 'mrm' ),
				'FC' => __( 'Abuja', 'mrm' ),
				'AD' => __( 'Adamawa', 'mrm' ),
				'AK' => __( 'Akwa Ibom', 'mrm' ),
				'AN' => __( 'Anambra', 'mrm' ),
				'BA' => __( 'Bauchi', 'mrm' ),
				'BY' => __( 'Bayelsa', 'mrm' ),
				'BE' => __( 'Benue', 'mrm' ),
				'BO' => __( 'Borno', 'mrm' ),
				'CR' => __( 'Cross River', 'mrm' ),
				'DE' => __( 'Delta', 'mrm' ),
				'EB' => __( 'Ebonyi', 'mrm' ),
				'ED' => __( 'Edo', 'mrm' ),
				'EK' => __( 'Ekiti', 'mrm' ),
				'EN' => __( 'Enugu', 'mrm' ),
				'GO' => __( 'Gombe', 'mrm' ),
				'IM' => __( 'Imo', 'mrm' ),
				'JI' => __( 'Jigawa', 'mrm' ),
				'KD' => __( 'Kaduna', 'mrm' ),
				'KN' => __( 'Kano', 'mrm' ),
				'KT' => __( 'Katsina', 'mrm' ),
				'KE' => __( 'Kebbi', 'mrm' ),
				'KO' => __( 'Kogi', 'mrm' ),
				'KW' => __( 'Kwara', 'mrm' ),
				'LA' => __( 'Lagos', 'mrm' ),
				'NA' => __( 'Nasarawa', 'mrm' ),
				'NI' => __( 'Niger', 'mrm' ),
				'OG' => __( 'Ogun', 'mrm' ),
				'ON' => __( 'Ondo', 'mrm' ),
				'OS' => __( 'Osun', 'mrm' ),
				'OY' => __( 'Oyo', 'mrm' ),
				'PL' => __( 'Plateau', 'mrm' ),
				'RI' => __( 'Rivers', 'mrm' ),
				'SO' => __( 'Sokoto', 'mrm' ),
				'TA' => __( 'Taraba', 'mrm' ),
				'YO' => __( 'Yobe', 'mrm' ),
				'ZA' => __( 'Zamfara', 'mrm' ),
			),
			'NL' => array(),
			'NO' => array(),
			'NP' => array( // Nepalese zones.
				'BAG' => __( 'Bagmati', 'mrm' ),
				'BHE' => __( 'Bheri', 'mrm' ),
				'DHA' => __( 'Dhaulagiri', 'mrm' ),
				'GAN' => __( 'Gandaki', 'mrm' ),
				'JAN' => __( 'Janakpur', 'mrm' ),
				'KAR' => __( 'Karnali', 'mrm' ),
				'KOS' => __( 'Koshi', 'mrm' ),
				'LUM' => __( 'Lumbini', 'mrm' ),
				'MAH' => __( 'Mahakali', 'mrm' ),
				'MEC' => __( 'Mechi', 'mrm' ),
				'NAR' => __( 'Narayani', 'mrm' ),
				'RAP' => __( 'Rapti', 'mrm' ),
				'SAG' => __( 'Sagarmatha', 'mrm' ),
				'SET' => __( 'Seti', 'mrm' ),
			),
			'NI' => array( // Nicaraguan states.
				'NI-AN' => __( 'Atlántico Norte', 'mrm' ),
				'NI-AS' => __( 'Atlántico Sur', 'mrm' ),
				'NI-BO' => __( 'Boaco', 'mrm' ),
				'NI-CA' => __( 'Carazo', 'mrm' ),
				'NI-CI' => __( 'Chinandega', 'mrm' ),
				'NI-CO' => __( 'Chontales', 'mrm' ),
				'NI-ES' => __( 'Estelí', 'mrm' ),
				'NI-GR' => __( 'Granada', 'mrm' ),
				'NI-JI' => __( 'Jinotega', 'mrm' ),
				'NI-LE' => __( 'León', 'mrm' ),
				'NI-MD' => __( 'Madriz', 'mrm' ),
				'NI-MN' => __( 'Managua', 'mrm' ),
				'NI-MS' => __( 'Masaya', 'mrm' ),
				'NI-MT' => __( 'Matagalpa', 'mrm' ),
				'NI-NS' => __( 'Nueva Segovia', 'mrm' ),
				'NI-RI' => __( 'Rivas', 'mrm' ),
				'NI-SJ' => __( 'Río San Juan', 'mrm' ),
			),
			'NZ' => array( // New Zealand states.
				'NTL' => __( 'Northland', 'mrm' ),
				'AUK' => __( 'Auckland', 'mrm' ),
				'WKO' => __( 'Waikato', 'mrm' ),
				'BOP' => __( 'Bay of Plenty', 'mrm' ),
				'TKI' => __( 'Taranaki', 'mrm' ),
				'GIS' => __( 'Gisborne', 'mrm' ),
				'HKB' => __( 'Hawke’s Bay', 'mrm' ),
				'MWT' => __( 'Manawatu-Wanganui', 'mrm' ),
				'WGN' => __( 'Wellington', 'mrm' ),
				'NSN' => __( 'Nelson', 'mrm' ),
				'MBH' => __( 'Marlborough', 'mrm' ),
				'TAS' => __( 'Tasman', 'mrm' ),
				'WTC' => __( 'West Coast', 'mrm' ),
				'CAN' => __( 'Canterbury', 'mrm' ),
				'OTA' => __( 'Otago', 'mrm' ),
				'STL' => __( 'Southland', 'mrm' ),
			),
			'PA' => array( // Panamanian states.
				'PA-1'  => __( 'Bocas del Toro', 'mrm' ),
				'PA-2'  => __( 'Coclé', 'mrm' ),
				'PA-3'  => __( 'Colón', 'mrm' ),
				'PA-4'  => __( 'Chiriquí', 'mrm' ),
				'PA-5'  => __( 'Darién', 'mrm' ),
				'PA-6'  => __( 'Herrera', 'mrm' ),
				'PA-7'  => __( 'Los Santos', 'mrm' ),
				'PA-8'  => __( 'Panamá', 'mrm' ),
				'PA-9'  => __( 'Veraguas', 'mrm' ),
				'PA-10' => __( 'West Panamá', 'mrm' ),
				'PA-EM' => __( 'Emberá', 'mrm' ),
				'PA-KY' => __( 'Guna Yala', 'mrm' ),
				'PA-NB' => __( 'Ngöbe-Buglé', 'mrm' ),
			),
			'PE' => array( // Peruvian states.
				'CAL' => __( 'El Callao', 'mrm' ),
				'LMA' => __( 'Municipalidad Metropolitana de Lima', 'mrm' ),
				'AMA' => __( 'Amazonas', 'mrm' ),
				'ANC' => __( 'Ancash', 'mrm' ),
				'APU' => __( 'Apurímac', 'mrm' ),
				'ARE' => __( 'Arequipa', 'mrm' ),
				'AYA' => __( 'Ayacucho', 'mrm' ),
				'CAJ' => __( 'Cajamarca', 'mrm' ),
				'CUS' => __( 'Cusco', 'mrm' ),
				'HUV' => __( 'Huancavelica', 'mrm' ),
				'HUC' => __( 'Huánuco', 'mrm' ),
				'ICA' => __( 'Ica', 'mrm' ),
				'JUN' => __( 'Junín', 'mrm' ),
				'LAL' => __( 'La Libertad', 'mrm' ),
				'LAM' => __( 'Lambayeque', 'mrm' ),
				'LIM' => __( 'Lima', 'mrm' ),
				'LOR' => __( 'Loreto', 'mrm' ),
				'MDD' => __( 'Madre de Dios', 'mrm' ),
				'MOQ' => __( 'Moquegua', 'mrm' ),
				'PAS' => __( 'Pasco', 'mrm' ),
				'PIU' => __( 'Piura', 'mrm' ),
				'PUN' => __( 'Puno', 'mrm' ),
				'SAM' => __( 'San Martín', 'mrm' ),
				'TAC' => __( 'Tacna', 'mrm' ),
				'TUM' => __( 'Tumbes', 'mrm' ),
				'UCA' => __( 'Ucayali', 'mrm' ),
			),
			'PH' => array( // Philippine provinces.
				'ABR' => __( 'Abra', 'mrm' ),
				'AGN' => __( 'Agusan del Norte', 'mrm' ),
				'AGS' => __( 'Agusan del Sur', 'mrm' ),
				'AKL' => __( 'Aklan', 'mrm' ),
				'ALB' => __( 'Albay', 'mrm' ),
				'ANT' => __( 'Antique', 'mrm' ),
				'APA' => __( 'Apayao', 'mrm' ),
				'AUR' => __( 'Aurora', 'mrm' ),
				'BAS' => __( 'Basilan', 'mrm' ),
				'BAN' => __( 'Bataan', 'mrm' ),
				'BTN' => __( 'Batanes', 'mrm' ),
				'BTG' => __( 'Batangas', 'mrm' ),
				'BEN' => __( 'Benguet', 'mrm' ),
				'BIL' => __( 'Biliran', 'mrm' ),
				'BOH' => __( 'Bohol', 'mrm' ),
				'BUK' => __( 'Bukidnon', 'mrm' ),
				'BUL' => __( 'Bulacan', 'mrm' ),
				'CAG' => __( 'Cagayan', 'mrm' ),
				'CAN' => __( 'Camarines Norte', 'mrm' ),
				'CAS' => __( 'Camarines Sur', 'mrm' ),
				'CAM' => __( 'Camiguin', 'mrm' ),
				'CAP' => __( 'Capiz', 'mrm' ),
				'CAT' => __( 'Catanduanes', 'mrm' ),
				'CAV' => __( 'Cavite', 'mrm' ),
				'CEB' => __( 'Cebu', 'mrm' ),
				'COM' => __( 'Compostela Valley', 'mrm' ),
				'NCO' => __( 'Cotabato', 'mrm' ),
				'DAV' => __( 'Davao del Norte', 'mrm' ),
				'DAS' => __( 'Davao del Sur', 'mrm' ),
				'DAC' => __( 'Davao Occidental', 'mrm' ),
				'DAO' => __( 'Davao Oriental', 'mrm' ),
				'DIN' => __( 'Dinagat Islands', 'mrm' ),
				'EAS' => __( 'Eastern Samar', 'mrm' ),
				'GUI' => __( 'Guimaras', 'mrm' ),
				'IFU' => __( 'Ifugao', 'mrm' ),
				'ILN' => __( 'Ilocos Norte', 'mrm' ),
				'ILS' => __( 'Ilocos Sur', 'mrm' ),
				'ILI' => __( 'Iloilo', 'mrm' ),
				'ISA' => __( 'Isabela', 'mrm' ),
				'KAL' => __( 'Kalinga', 'mrm' ),
				'LUN' => __( 'La Union', 'mrm' ),
				'LAG' => __( 'Laguna', 'mrm' ),
				'LAN' => __( 'Lanao del Norte', 'mrm' ),
				'LAS' => __( 'Lanao del Sur', 'mrm' ),
				'LEY' => __( 'Leyte', 'mrm' ),
				'MAG' => __( 'Maguindanao', 'mrm' ),
				'MAD' => __( 'Marinduque', 'mrm' ),
				'MAS' => __( 'Masbate', 'mrm' ),
				'MSC' => __( 'Misamis Occidental', 'mrm' ),
				'MSR' => __( 'Misamis Oriental', 'mrm' ),
				'MOU' => __( 'Mountain Province', 'mrm' ),
				'NEC' => __( 'Negros Occidental', 'mrm' ),
				'NER' => __( 'Negros Oriental', 'mrm' ),
				'NSA' => __( 'Northern Samar', 'mrm' ),
				'NUE' => __( 'Nueva Ecija', 'mrm' ),
				'NUV' => __( 'Nueva Vizcaya', 'mrm' ),
				'MDC' => __( 'Occidental Mindoro', 'mrm' ),
				'MDR' => __( 'Oriental Mindoro', 'mrm' ),
				'PLW' => __( 'Palawan', 'mrm' ),
				'PAM' => __( 'Pampanga', 'mrm' ),
				'PAN' => __( 'Pangasinan', 'mrm' ),
				'QUE' => __( 'Quezon', 'mrm' ),
				'QUI' => __( 'Quirino', 'mrm' ),
				'RIZ' => __( 'Rizal', 'mrm' ),
				'ROM' => __( 'Romblon', 'mrm' ),
				'WSA' => __( 'Samar', 'mrm' ),
				'SAR' => __( 'Sarangani', 'mrm' ),
				'SIQ' => __( 'Siquijor', 'mrm' ),
				'SOR' => __( 'Sorsogon', 'mrm' ),
				'SCO' => __( 'South Cotabato', 'mrm' ),
				'SLE' => __( 'Southern Leyte', 'mrm' ),
				'SUK' => __( 'Sultan Kudarat', 'mrm' ),
				'SLU' => __( 'Sulu', 'mrm' ),
				'SUN' => __( 'Surigao del Norte', 'mrm' ),
				'SUR' => __( 'Surigao del Sur', 'mrm' ),
				'TAR' => __( 'Tarlac', 'mrm' ),
				'TAW' => __( 'Tawi-Tawi', 'mrm' ),
				'ZMB' => __( 'Zambales', 'mrm' ),
				'ZAN' => __( 'Zamboanga del Norte', 'mrm' ),
				'ZAS' => __( 'Zamboanga del Sur', 'mrm' ),
				'ZSI' => __( 'Zamboanga Sibugay', 'mrm' ),
				'00'  => __( 'Metro Manila', 'mrm' ),
			),
			'PK' => array( // Pakistani states.
				'JK' => __( 'Azad Kashmir', 'mrm' ),
				'BA' => __( 'Balochistan', 'mrm' ),
				'TA' => __( 'FATA', 'mrm' ),
				'GB' => __( 'Gilgit Baltistan', 'mrm' ),
				'IS' => __( 'Islamabad Capital Territory', 'mrm' ),
				'KP' => __( 'Khyber Pakhtunkhwa', 'mrm' ),
				'PB' => __( 'Punjab', 'mrm' ),
				'SD' => __( 'Sindh', 'mrm' ),
			),
			'PL' => array(),
			'PR' => array(),
			'PT' => array(),
			'PY' => array( // Paraguayan states.
				'PY-ASU' => __( 'Asunción', 'mrm' ),
				'PY-1'   => __( 'Concepción', 'mrm' ),
				'PY-2'   => __( 'San Pedro', 'mrm' ),
				'PY-3'   => __( 'Cordillera', 'mrm' ),
				'PY-4'   => __( 'Guairá', 'mrm' ),
				'PY-5'   => __( 'Caaguazú', 'mrm' ),
				'PY-6'   => __( 'Caazapá', 'mrm' ),
				'PY-7'   => __( 'Itapúa', 'mrm' ),
				'PY-8'   => __( 'Misiones', 'mrm' ),
				'PY-9'   => __( 'Paraguarí', 'mrm' ),
				'PY-10'  => __( 'Alto Paraná', 'mrm' ),
				'PY-11'  => __( 'Central', 'mrm' ),
				'PY-12'  => __( 'Ñeembucú', 'mrm' ),
				'PY-13'  => __( 'Amambay', 'mrm' ),
				'PY-14'  => __( 'Canindeyú', 'mrm' ),
				'PY-15'  => __( 'Presidente Hayes', 'mrm' ),
				'PY-16'  => __( 'Alto Paraguay', 'mrm' ),
				'PY-17'  => __( 'Boquerón', 'mrm' ),
			),
			'RE' => array(),
			'RO' => array( // Romanian states.
				'AB' => __( 'Alba', 'mrm' ),
				'AR' => __( 'Arad', 'mrm' ),
				'AG' => __( 'Argeș', 'mrm' ),
				'BC' => __( 'Bacău', 'mrm' ),
				'BH' => __( 'Bihor', 'mrm' ),
				'BN' => __( 'Bistrița-Năsăud', 'mrm' ),
				'BT' => __( 'Botoșani', 'mrm' ),
				'BR' => __( 'Brăila', 'mrm' ),
				'BV' => __( 'Brașov', 'mrm' ),
				'B'  => __( 'București', 'mrm' ),
				'BZ' => __( 'Buzău', 'mrm' ),
				'CL' => __( 'Călărași', 'mrm' ),
				'CS' => __( 'Caraș-Severin', 'mrm' ),
				'CJ' => __( 'Cluj', 'mrm' ),
				'CT' => __( 'Constanța', 'mrm' ),
				'CV' => __( 'Covasna', 'mrm' ),
				'DB' => __( 'Dâmbovița', 'mrm' ),
				'DJ' => __( 'Dolj', 'mrm' ),
				'GL' => __( 'Galați', 'mrm' ),
				'GR' => __( 'Giurgiu', 'mrm' ),
				'GJ' => __( 'Gorj', 'mrm' ),
				'HR' => __( 'Harghita', 'mrm' ),
				'HD' => __( 'Hunedoara', 'mrm' ),
				'IL' => __( 'Ialomița', 'mrm' ),
				'IS' => __( 'Iași', 'mrm' ),
				'IF' => __( 'Ilfov', 'mrm' ),
				'MM' => __( 'Maramureș', 'mrm' ),
				'MH' => __( 'Mehedinți', 'mrm' ),
				'MS' => __( 'Mureș', 'mrm' ),
				'NT' => __( 'Neamț', 'mrm' ),
				'OT' => __( 'Olt', 'mrm' ),
				'PH' => __( 'Prahova', 'mrm' ),
				'SJ' => __( 'Sălaj', 'mrm' ),
				'SM' => __( 'Satu Mare', 'mrm' ),
				'SB' => __( 'Sibiu', 'mrm' ),
				'SV' => __( 'Suceava', 'mrm' ),
				'TR' => __( 'Teleorman', 'mrm' ),
				'TM' => __( 'Timiș', 'mrm' ),
				'TL' => __( 'Tulcea', 'mrm' ),
				'VL' => __( 'Vâlcea', 'mrm' ),
				'VS' => __( 'Vaslui', 'mrm' ),
				'VN' => __( 'Vrancea', 'mrm' ),
			),
			'SG' => array(),
			'SK' => array(),
			'SI' => array(),
			'SV' => array( // Salvadoran states.
				'SV-AH' => __( 'Ahuachapán', 'mrm' ),
				'SV-CA' => __( 'Cabañas', 'mrm' ),
				'SV-CH' => __( 'Chalatenango', 'mrm' ),
				'SV-CU' => __( 'Cuscatlán', 'mrm' ),
				'SV-LI' => __( 'La Libertad', 'mrm' ),
				'SV-MO' => __( 'Morazán', 'mrm' ),
				'SV-PA' => __( 'La Paz', 'mrm' ),
				'SV-SA' => __( 'Santa Ana', 'mrm' ),
				'SV-SM' => __( 'San Miguel', 'mrm' ),
				'SV-SO' => __( 'Sonsonate', 'mrm' ),
				'SV-SS' => __( 'San Salvador', 'mrm' ),
				'SV-SV' => __( 'San Vicente', 'mrm' ),
				'SV-UN' => __( 'La Unión', 'mrm' ),
				'SV-US' => __( 'Usulután', 'mrm' ),
			),
			'TH' => array( // Thai states.
				'TH-37' => __( 'Amnat Charoen', 'mrm' ),
				'TH-15' => __( 'Ang Thong', 'mrm' ),
				'TH-14' => __( 'Ayutthaya', 'mrm' ),
				'TH-10' => __( 'Bangkok', 'mrm' ),
				'TH-38' => __( 'Bueng Kan', 'mrm' ),
				'TH-31' => __( 'Buri Ram', 'mrm' ),
				'TH-24' => __( 'Chachoengsao', 'mrm' ),
				'TH-18' => __( 'Chai Nat', 'mrm' ),
				'TH-36' => __( 'Chaiyaphum', 'mrm' ),
				'TH-22' => __( 'Chanthaburi', 'mrm' ),
				'TH-50' => __( 'Chiang Mai', 'mrm' ),
				'TH-57' => __( 'Chiang Rai', 'mrm' ),
				'TH-20' => __( 'Chonburi', 'mrm' ),
				'TH-86' => __( 'Chumphon', 'mrm' ),
				'TH-46' => __( 'Kalasin', 'mrm' ),
				'TH-62' => __( 'Kamphaeng Phet', 'mrm' ),
				'TH-71' => __( 'Kanchanaburi', 'mrm' ),
				'TH-40' => __( 'Khon Kaen', 'mrm' ),
				'TH-81' => __( 'Krabi', 'mrm' ),
				'TH-52' => __( 'Lampang', 'mrm' ),
				'TH-51' => __( 'Lamphun', 'mrm' ),
				'TH-42' => __( 'Loei', 'mrm' ),
				'TH-16' => __( 'Lopburi', 'mrm' ),
				'TH-58' => __( 'Mae Hong Son', 'mrm' ),
				'TH-44' => __( 'Maha Sarakham', 'mrm' ),
				'TH-49' => __( 'Mukdahan', 'mrm' ),
				'TH-26' => __( 'Nakhon Nayok', 'mrm' ),
				'TH-73' => __( 'Nakhon Pathom', 'mrm' ),
				'TH-48' => __( 'Nakhon Phanom', 'mrm' ),
				'TH-30' => __( 'Nakhon Ratchasima', 'mrm' ),
				'TH-60' => __( 'Nakhon Sawan', 'mrm' ),
				'TH-80' => __( 'Nakhon Si Thammarat', 'mrm' ),
				'TH-55' => __( 'Nan', 'mrm' ),
				'TH-96' => __( 'Narathiwat', 'mrm' ),
				'TH-39' => __( 'Nong Bua Lam Phu', 'mrm' ),
				'TH-43' => __( 'Nong Khai', 'mrm' ),
				'TH-12' => __( 'Nonthaburi', 'mrm' ),
				'TH-13' => __( 'Pathum Thani', 'mrm' ),
				'TH-94' => __( 'Pattani', 'mrm' ),
				'TH-82' => __( 'Phang Nga', 'mrm' ),
				'TH-93' => __( 'Phatthalung', 'mrm' ),
				'TH-56' => __( 'Phayao', 'mrm' ),
				'TH-67' => __( 'Phetchabun', 'mrm' ),
				'TH-76' => __( 'Phetchaburi', 'mrm' ),
				'TH-66' => __( 'Phichit', 'mrm' ),
				'TH-65' => __( 'Phitsanulok', 'mrm' ),
				'TH-54' => __( 'Phrae', 'mrm' ),
				'TH-83' => __( 'Phuket', 'mrm' ),
				'TH-25' => __( 'Prachin Buri', 'mrm' ),
				'TH-77' => __( 'Prachuap Khiri Khan', 'mrm' ),
				'TH-85' => __( 'Ranong', 'mrm' ),
				'TH-70' => __( 'Ratchaburi', 'mrm' ),
				'TH-21' => __( 'Rayong', 'mrm' ),
				'TH-45' => __( 'Roi Et', 'mrm' ),
				'TH-27' => __( 'Sa Kaeo', 'mrm' ),
				'TH-47' => __( 'Sakon Nakhon', 'mrm' ),
				'TH-11' => __( 'Samut Prakan', 'mrm' ),
				'TH-74' => __( 'Samut Sakhon', 'mrm' ),
				'TH-75' => __( 'Samut Songkhram', 'mrm' ),
				'TH-19' => __( 'Saraburi', 'mrm' ),
				'TH-91' => __( 'Satun', 'mrm' ),
				'TH-17' => __( 'Sing Buri', 'mrm' ),
				'TH-33' => __( 'Sisaket', 'mrm' ),
				'TH-90' => __( 'Songkhla', 'mrm' ),
				'TH-64' => __( 'Sukhothai', 'mrm' ),
				'TH-72' => __( 'Suphan Buri', 'mrm' ),
				'TH-84' => __( 'Surat Thani', 'mrm' ),
				'TH-32' => __( 'Surin', 'mrm' ),
				'TH-63' => __( 'Tak', 'mrm' ),
				'TH-92' => __( 'Trang', 'mrm' ),
				'TH-23' => __( 'Trat', 'mrm' ),
				'TH-34' => __( 'Ubon Ratchathani', 'mrm' ),
				'TH-41' => __( 'Udon Thani', 'mrm' ),
				'TH-61' => __( 'Uthai Thani', 'mrm' ),
				'TH-53' => __( 'Uttaradit', 'mrm' ),
				'TH-95' => __( 'Yala', 'mrm' ),
				'TH-35' => __( 'Yasothon', 'mrm' ),
			),
			'TR' => array( // Turkish states.
				'TR01' => __( 'Adana', 'mrm' ),
				'TR02' => __( 'Adıyaman', 'mrm' ),
				'TR03' => __( 'Afyon', 'mrm' ),
				'TR04' => __( 'Ağrı', 'mrm' ),
				'TR05' => __( 'Amasya', 'mrm' ),
				'TR06' => __( 'Ankara', 'mrm' ),
				'TR07' => __( 'Antalya', 'mrm' ),
				'TR08' => __( 'Artvin', 'mrm' ),
				'TR09' => __( 'Aydın', 'mrm' ),
				'TR10' => __( 'Balıkesir', 'mrm' ),
				'TR11' => __( 'Bilecik', 'mrm' ),
				'TR12' => __( 'Bingöl', 'mrm' ),
				'TR13' => __( 'Bitlis', 'mrm' ),
				'TR14' => __( 'Bolu', 'mrm' ),
				'TR15' => __( 'Burdur', 'mrm' ),
				'TR16' => __( 'Bursa', 'mrm' ),
				'TR17' => __( 'Çanakkale', 'mrm' ),
				'TR18' => __( 'Çankırı', 'mrm' ),
				'TR19' => __( 'Çorum', 'mrm' ),
				'TR20' => __( 'Denizli', 'mrm' ),
				'TR21' => __( 'Diyarbakır', 'mrm' ),
				'TR22' => __( 'Edirne', 'mrm' ),
				'TR23' => __( 'Elazığ', 'mrm' ),
				'TR24' => __( 'Erzincan', 'mrm' ),
				'TR25' => __( 'Erzurum', 'mrm' ),
				'TR26' => __( 'Eskişehir', 'mrm' ),
				'TR27' => __( 'Gaziantep', 'mrm' ),
				'TR28' => __( 'Giresun', 'mrm' ),
				'TR29' => __( 'Gümüşhane', 'mrm' ),
				'TR30' => __( 'Hakkari', 'mrm' ),
				'TR31' => __( 'Hatay', 'mrm' ),
				'TR32' => __( 'Isparta', 'mrm' ),
				'TR33' => __( 'İçel', 'mrm' ),
				'TR34' => __( 'İstanbul', 'mrm' ),
				'TR35' => __( 'İzmir', 'mrm' ),
				'TR36' => __( 'Kars', 'mrm' ),
				'TR37' => __( 'Kastamonu', 'mrm' ),
				'TR38' => __( 'Kayseri', 'mrm' ),
				'TR39' => __( 'Kırklareli', 'mrm' ),
				'TR40' => __( 'Kırşehir', 'mrm' ),
				'TR41' => __( 'Kocaeli', 'mrm' ),
				'TR42' => __( 'Konya', 'mrm' ),
				'TR43' => __( 'Kütahya', 'mrm' ),
				'TR44' => __( 'Malatya', 'mrm' ),
				'TR45' => __( 'Manisa', 'mrm' ),
				'TR46' => __( 'Kahramanmaraş', 'mrm' ),
				'TR47' => __( 'Mardin', 'mrm' ),
				'TR48' => __( 'Muğla', 'mrm' ),
				'TR49' => __( 'Muş', 'mrm' ),
				'TR50' => __( 'Nevşehir', 'mrm' ),
				'TR51' => __( 'Niğde', 'mrm' ),
				'TR52' => __( 'Ordu', 'mrm' ),
				'TR53' => __( 'Rize', 'mrm' ),
				'TR54' => __( 'Sakarya', 'mrm' ),
				'TR55' => __( 'Samsun', 'mrm' ),
				'TR56' => __( 'Siirt', 'mrm' ),
				'TR57' => __( 'Sinop', 'mrm' ),
				'TR58' => __( 'Sivas', 'mrm' ),
				'TR59' => __( 'Tekirdağ', 'mrm' ),
				'TR60' => __( 'Tokat', 'mrm' ),
				'TR61' => __( 'Trabzon', 'mrm' ),
				'TR62' => __( 'Tunceli', 'mrm' ),
				'TR63' => __( 'Şanlıurfa', 'mrm' ),
				'TR64' => __( 'Uşak', 'mrm' ),
				'TR65' => __( 'Van', 'mrm' ),
				'TR66' => __( 'Yozgat', 'mrm' ),
				'TR67' => __( 'Zonguldak', 'mrm' ),
				'TR68' => __( 'Aksaray', 'mrm' ),
				'TR69' => __( 'Bayburt', 'mrm' ),
				'TR70' => __( 'Karaman', 'mrm' ),
				'TR71' => __( 'Kırıkkale', 'mrm' ),
				'TR72' => __( 'Batman', 'mrm' ),
				'TR73' => __( 'Şırnak', 'mrm' ),
				'TR74' => __( 'Bartın', 'mrm' ),
				'TR75' => __( 'Ardahan', 'mrm' ),
				'TR76' => __( 'Iğdır', 'mrm' ),
				'TR77' => __( 'Yalova', 'mrm' ),
				'TR78' => __( 'Karabük', 'mrm' ),
				'TR79' => __( 'Kilis', 'mrm' ),
				'TR80' => __( 'Osmaniye', 'mrm' ),
				'TR81' => __( 'Düzce', 'mrm' ),
			),
			'TZ' => array( // Tanzanian states.
				'TZ01' => __( 'Arusha', 'mrm' ),
				'TZ02' => __( 'Dar es Salaam', 'mrm' ),
				'TZ03' => __( 'Dodoma', 'mrm' ),
				'TZ04' => __( 'Iringa', 'mrm' ),
				'TZ05' => __( 'Kagera', 'mrm' ),
				'TZ06' => __( 'Pemba North', 'mrm' ),
				'TZ07' => __( 'Zanzibar North', 'mrm' ),
				'TZ08' => __( 'Kigoma', 'mrm' ),
				'TZ09' => __( 'Kilimanjaro', 'mrm' ),
				'TZ10' => __( 'Pemba South', 'mrm' ),
				'TZ11' => __( 'Zanzibar South', 'mrm' ),
				'TZ12' => __( 'Lindi', 'mrm' ),
				'TZ13' => __( 'Mara', 'mrm' ),
				'TZ14' => __( 'Mbeya', 'mrm' ),
				'TZ15' => __( 'Zanzibar West', 'mrm' ),
				'TZ16' => __( 'Morogoro', 'mrm' ),
				'TZ17' => __( 'Mtwara', 'mrm' ),
				'TZ18' => __( 'Mwanza', 'mrm' ),
				'TZ19' => __( 'Coast', 'mrm' ),
				'TZ20' => __( 'Rukwa', 'mrm' ),
				'TZ21' => __( 'Ruvuma', 'mrm' ),
				'TZ22' => __( 'Shinyanga', 'mrm' ),
				'TZ23' => __( 'Singida', 'mrm' ),
				'TZ24' => __( 'Tabora', 'mrm' ),
				'TZ25' => __( 'Tanga', 'mrm' ),
				'TZ26' => __( 'Manyara', 'mrm' ),
				'TZ27' => __( 'Geita', 'mrm' ),
				'TZ28' => __( 'Katavi', 'mrm' ),
				'TZ29' => __( 'Njombe', 'mrm' ),
				'TZ30' => __( 'Simiyu', 'mrm' ),
			),
			'LK' => array(),
			'RS' => array( // Serbian districts.
				'RS00' => _x( 'Belgrade', 'district', 'mrm' ),
				'RS14' => _x( 'Bor', 'district', 'mrm' ),
				'RS11' => _x( 'Braničevo', 'district', 'mrm' ),
				'RS02' => _x( 'Central Banat', 'district', 'mrm' ),
				'RS10' => _x( 'Danube', 'district', 'mrm' ),
				'RS23' => _x( 'Jablanica', 'district', 'mrm' ),
				'RS09' => _x( 'Kolubara', 'district', 'mrm' ),
				'RS08' => _x( 'Mačva', 'district', 'mrm' ),
				'RS17' => _x( 'Morava', 'district', 'mrm' ),
				'RS20' => _x( 'Nišava', 'district', 'mrm' ),
				'RS01' => _x( 'North Bačka', 'district', 'mrm' ),
				'RS03' => _x( 'North Banat', 'district', 'mrm' ),
				'RS24' => _x( 'Pčinja', 'district', 'mrm' ),
				'RS22' => _x( 'Pirot', 'district', 'mrm' ),
				'RS13' => _x( 'Pomoravlje', 'district', 'mrm' ),
				'RS19' => _x( 'Rasina', 'district', 'mrm' ),
				'RS18' => _x( 'Raška', 'district', 'mrm' ),
				'RS06' => _x( 'South Bačka', 'district', 'mrm' ),
				'RS04' => _x( 'South Banat', 'district', 'mrm' ),
				'RS07' => _x( 'Srem', 'district', 'mrm' ),
				'RS12' => _x( 'Šumadija', 'district', 'mrm' ),
				'RS21' => _x( 'Toplica', 'district', 'mrm' ),
				'RS05' => _x( 'West Bačka', 'district', 'mrm' ),
				'RS15' => _x( 'Zaječar', 'district', 'mrm' ),
				'RS16' => _x( 'Zlatibor', 'district', 'mrm' ),
				'RS25' => _x( 'Kosovo', 'district', 'mrm' ),
				'RS26' => _x( 'Peć', 'district', 'mrm' ),
				'RS27' => _x( 'Prizren', 'district', 'mrm' ),
				'RS28' => _x( 'Kosovska Mitrovica', 'district', 'mrm' ),
				'RS29' => _x( 'Kosovo-Pomoravlje', 'district', 'mrm' ),
				'RSKM' => _x( 'Kosovo-Metohija', 'district', 'mrm' ),
				'RSVO' => _x( 'Vojvodina', 'district', 'mrm' ),
			),
			'SE' => array(),
			'UA' => array( // Ukrainian oblasts.
				'VN' => __( 'Vinnytsia Oblast', 'mrm' ),
				'VL' => __( 'Volyn Oblast', 'mrm' ),
				'DP' => __( 'Dnipropetrovsk Oblast', 'mrm' ),
				'DT' => __( 'Donetsk Oblast', 'mrm' ),
				'ZT' => __( 'Zhytomyr Oblast', 'mrm' ),
				'ZK' => __( 'Zakarpattia Oblast', 'mrm' ),
				'ZP' => __( 'Zaporizhzhia Oblast', 'mrm' ),
				'IF' => __( 'Ivano-Frankivsk Oblast', 'mrm' ),
				'KV' => __( 'Kyiv Oblast', 'mrm' ),
				'KH' => __( 'Kirovohrad Oblast', 'mrm' ),
				'LH' => __( 'Luhansk Oblast', 'mrm' ),
				'LV' => __( 'Lviv Oblast', 'mrm' ),
				'MY' => __( 'Mykolaiv Oblast', 'mrm' ),
				'OD' => __( 'Odessa Oblast', 'mrm' ),
				'PL' => __( 'Poltava Oblast', 'mrm' ),
				'RV' => __( 'Rivne Oblast', 'mrm' ),
				'SM' => __( 'Sumy Oblast', 'mrm' ),
				'TP' => __( 'Ternopil Oblast', 'mrm' ),
				'KK' => __( 'Kharkiv Oblast', 'mrm' ),
				'KS' => __( 'Kherson Oblast', 'mrm' ),
				'KM' => __( 'Khmelnytskyi Oblast', 'mrm' ),
				'CK' => __( 'Cherkasy Oblast', 'mrm' ),
				'CH' => __( 'Chernihiv Oblast', 'mrm' ),
				'CV' => __( 'Chernivtsi Oblast', 'mrm' ),
			),
			'UG' => array( // Ugandan districts.
				'UG314' => __( 'Abim', 'mrm' ),
				'UG301' => __( 'Adjumani', 'mrm' ),
				'UG322' => __( 'Agago', 'mrm' ),
				'UG323' => __( 'Alebtong', 'mrm' ),
				'UG315' => __( 'Amolatar', 'mrm' ),
				'UG324' => __( 'Amudat', 'mrm' ),
				'UG216' => __( 'Amuria', 'mrm' ),
				'UG316' => __( 'Amuru', 'mrm' ),
				'UG302' => __( 'Apac', 'mrm' ),
				'UG303' => __( 'Arua', 'mrm' ),
				'UG217' => __( 'Budaka', 'mrm' ),
				'UG218' => __( 'Bududa', 'mrm' ),
				'UG201' => __( 'Bugiri', 'mrm' ),
				'UG235' => __( 'Bugweri', 'mrm' ),
				'UG420' => __( 'Buhweju', 'mrm' ),
				'UG117' => __( 'Buikwe', 'mrm' ),
				'UG219' => __( 'Bukedea', 'mrm' ),
				'UG118' => __( 'Bukomansimbi', 'mrm' ),
				'UG220' => __( 'Bukwa', 'mrm' ),
				'UG225' => __( 'Bulambuli', 'mrm' ),
				'UG416' => __( 'Buliisa', 'mrm' ),
				'UG401' => __( 'Bundibugyo', 'mrm' ),
				'UG430' => __( 'Bunyangabu', 'mrm' ),
				'UG402' => __( 'Bushenyi', 'mrm' ),
				'UG202' => __( 'Busia', 'mrm' ),
				'UG221' => __( 'Butaleja', 'mrm' ),
				'UG119' => __( 'Butambala', 'mrm' ),
				'UG233' => __( 'Butebo', 'mrm' ),
				'UG120' => __( 'Buvuma', 'mrm' ),
				'UG226' => __( 'Buyende', 'mrm' ),
				'UG317' => __( 'Dokolo', 'mrm' ),
				'UG121' => __( 'Gomba', 'mrm' ),
				'UG304' => __( 'Gulu', 'mrm' ),
				'UG403' => __( 'Hoima', 'mrm' ),
				'UG417' => __( 'Ibanda', 'mrm' ),
				'UG203' => __( 'Iganga', 'mrm' ),
				'UG418' => __( 'Isingiro', 'mrm' ),
				'UG204' => __( 'Jinja', 'mrm' ),
				'UG318' => __( 'Kaabong', 'mrm' ),
				'UG404' => __( 'Kabale', 'mrm' ),
				'UG405' => __( 'Kabarole', 'mrm' ),
				'UG213' => __( 'Kaberamaido', 'mrm' ),
				'UG427' => __( 'Kagadi', 'mrm' ),
				'UG428' => __( 'Kakumiro', 'mrm' ),
				'UG101' => __( 'Kalangala', 'mrm' ),
				'UG222' => __( 'Kaliro', 'mrm' ),
				'UG122' => __( 'Kalungu', 'mrm' ),
				'UG102' => __( 'Kampala', 'mrm' ),
				'UG205' => __( 'Kamuli', 'mrm' ),
				'UG413' => __( 'Kamwenge', 'mrm' ),
				'UG414' => __( 'Kanungu', 'mrm' ),
				'UG206' => __( 'Kapchorwa', 'mrm' ),
				'UG236' => __( 'Kapelebyong', 'mrm' ),
				'UG126' => __( 'Kasanda', 'mrm' ),
				'UG406' => __( 'Kasese', 'mrm' ),
				'UG207' => __( 'Katakwi', 'mrm' ),
				'UG112' => __( 'Kayunga', 'mrm' ),
				'UG407' => __( 'Kibaale', 'mrm' ),
				'UG103' => __( 'Kiboga', 'mrm' ),
				'UG227' => __( 'Kibuku', 'mrm' ),
				'UG432' => __( 'Kikuube', 'mrm' ),
				'UG419' => __( 'Kiruhura', 'mrm' ),
				'UG421' => __( 'Kiryandongo', 'mrm' ),
				'UG408' => __( 'Kisoro', 'mrm' ),
				'UG305' => __( 'Kitgum', 'mrm' ),
				'UG319' => __( 'Koboko', 'mrm' ),
				'UG325' => __( 'Kole', 'mrm' ),
				'UG306' => __( 'Kotido', 'mrm' ),
				'UG208' => __( 'Kumi', 'mrm' ),
				'UG333' => __( 'Kwania', 'mrm' ),
				'UG228' => __( 'Kween', 'mrm' ),
				'UG123' => __( 'Kyankwanzi', 'mrm' ),
				'UG422' => __( 'Kyegegwa', 'mrm' ),
				'UG415' => __( 'Kyenjojo', 'mrm' ),
				'UG125' => __( 'Kyotera', 'mrm' ),
				'UG326' => __( 'Lamwo', 'mrm' ),
				'UG307' => __( 'Lira', 'mrm' ),
				'UG229' => __( 'Luuka', 'mrm' ),
				'UG104' => __( 'Luwero', 'mrm' ),
				'UG124' => __( 'Lwengo', 'mrm' ),
				'UG114' => __( 'Lyantonde', 'mrm' ),
				'UG223' => __( 'Manafwa', 'mrm' ),
				'UG320' => __( 'Maracha', 'mrm' ),
				'UG105' => __( 'Masaka', 'mrm' ),
				'UG409' => __( 'Masindi', 'mrm' ),
				'UG214' => __( 'Mayuge', 'mrm' ),
				'UG209' => __( 'Mbale', 'mrm' ),
				'UG410' => __( 'Mbarara', 'mrm' ),
				'UG423' => __( 'Mitooma', 'mrm' ),
				'UG115' => __( 'Mityana', 'mrm' ),
				'UG308' => __( 'Moroto', 'mrm' ),
				'UG309' => __( 'Moyo', 'mrm' ),
				'UG106' => __( 'Mpigi', 'mrm' ),
				'UG107' => __( 'Mubende', 'mrm' ),
				'UG108' => __( 'Mukono', 'mrm' ),
				'UG334' => __( 'Nabilatuk', 'mrm' ),
				'UG311' => __( 'Nakapiripirit', 'mrm' ),
				'UG116' => __( 'Nakaseke', 'mrm' ),
				'UG109' => __( 'Nakasongola', 'mrm' ),
				'UG230' => __( 'Namayingo', 'mrm' ),
				'UG234' => __( 'Namisindwa', 'mrm' ),
				'UG224' => __( 'Namutumba', 'mrm' ),
				'UG327' => __( 'Napak', 'mrm' ),
				'UG310' => __( 'Nebbi', 'mrm' ),
				'UG231' => __( 'Ngora', 'mrm' ),
				'UG424' => __( 'Ntoroko', 'mrm' ),
				'UG411' => __( 'Ntungamo', 'mrm' ),
				'UG328' => __( 'Nwoya', 'mrm' ),
				'UG331' => __( 'Omoro', 'mrm' ),
				'UG329' => __( 'Otuke', 'mrm' ),
				'UG321' => __( 'Oyam', 'mrm' ),
				'UG312' => __( 'Pader', 'mrm' ),
				'UG332' => __( 'Pakwach', 'mrm' ),
				'UG210' => __( 'Pallisa', 'mrm' ),
				'UG110' => __( 'Rakai', 'mrm' ),
				'UG429' => __( 'Rubanda', 'mrm' ),
				'UG425' => __( 'Rubirizi', 'mrm' ),
				'UG431' => __( 'Rukiga', 'mrm' ),
				'UG412' => __( 'Rukungiri', 'mrm' ),
				'UG111' => __( 'Sembabule', 'mrm' ),
				'UG232' => __( 'Serere', 'mrm' ),
				'UG426' => __( 'Sheema', 'mrm' ),
				'UG215' => __( 'Sironko', 'mrm' ),
				'UG211' => __( 'Soroti', 'mrm' ),
				'UG212' => __( 'Tororo', 'mrm' ),
				'UG113' => __( 'Wakiso', 'mrm' ),
				'UG313' => __( 'Yumbe', 'mrm' ),
				'UG330' => __( 'Zombo', 'mrm' ),
			),
			'UM' => array(
				'81' => __( 'Baker Island', 'mrm' ),
				'84' => __( 'Howland Island', 'mrm' ),
				'86' => __( 'Jarvis Island', 'mrm' ),
				'67' => __( 'Johnston Atoll', 'mrm' ),
				'89' => __( 'Kingman Reef', 'mrm' ),
				'71' => __( 'Midway Atoll', 'mrm' ),
				'76' => __( 'Navassa Island', 'mrm' ),
				'95' => __( 'Palmyra Atoll', 'mrm' ),
				'79' => __( 'Wake Island', 'mrm' ),
			),
			'US' => array( // U.S. states.
				'AL' => __( 'Alabama', 'mrm' ),
				'AK' => __( 'Alaska', 'mrm' ),
				'AZ' => __( 'Arizona', 'mrm' ),
				'AR' => __( 'Arkansas', 'mrm' ),
				'CA' => __( 'California', 'mrm' ),
				'CO' => __( 'Colorado', 'mrm' ),
				'CT' => __( 'Connecticut', 'mrm' ),
				'DE' => __( 'Delaware', 'mrm' ),
				'DC' => __( 'District Of Columbia', 'mrm' ),
				'FL' => __( 'Florida', 'mrm' ),
				'GA' => _x( 'Georgia', 'US state of Georgia', 'mrm' ),
				'HI' => __( 'Hawaii', 'mrm' ),
				'ID' => __( 'Idaho', 'mrm' ),
				'IL' => __( 'Illinois', 'mrm' ),
				'IN' => __( 'Indiana', 'mrm' ),
				'IA' => __( 'Iowa', 'mrm' ),
				'KS' => __( 'Kansas', 'mrm' ),
				'KY' => __( 'Kentucky', 'mrm' ),
				'LA' => __( 'Louisiana', 'mrm' ),
				'ME' => __( 'Maine', 'mrm' ),
				'MD' => __( 'Maryland', 'mrm' ),
				'MA' => __( 'Massachusetts', 'mrm' ),
				'MI' => __( 'Michigan', 'mrm' ),
				'MN' => __( 'Minnesota', 'mrm' ),
				'MS' => __( 'Mississippi', 'mrm' ),
				'MO' => __( 'Missouri', 'mrm' ),
				'MT' => __( 'Montana', 'mrm' ),
				'NE' => __( 'Nebraska', 'mrm' ),
				'NV' => __( 'Nevada', 'mrm' ),
				'NH' => __( 'New Hampshire', 'mrm' ),
				'NJ' => __( 'New Jersey', 'mrm' ),
				'NM' => __( 'New Mexico', 'mrm' ),
				'NY' => __( 'New York', 'mrm' ),
				'NC' => __( 'North Carolina', 'mrm' ),
				'ND' => __( 'North Dakota', 'mrm' ),
				'OH' => __( 'Ohio', 'mrm' ),
				'OK' => __( 'Oklahoma', 'mrm' ),
				'OR' => __( 'Oregon', 'mrm' ),
				'PA' => __( 'Pennsylvania', 'mrm' ),
				'RI' => __( 'Rhode Island', 'mrm' ),
				'SC' => __( 'South Carolina', 'mrm' ),
				'SD' => __( 'South Dakota', 'mrm' ),
				'TN' => __( 'Tennessee', 'mrm' ),
				'TX' => __( 'Texas', 'mrm' ),
				'UT' => __( 'Utah', 'mrm' ),
				'VT' => __( 'Vermont', 'mrm' ),
				'VA' => __( 'Virginia', 'mrm' ),
				'WA' => __( 'Washington', 'mrm' ),
				'WV' => __( 'West Virginia', 'mrm' ),
				'WI' => __( 'Wisconsin', 'mrm' ),
				'WY' => __( 'Wyoming', 'mrm' ),
				'AA' => __( 'Armed Forces (AA)', 'mrm' ),
				'AE' => __( 'Armed Forces (AE)', 'mrm' ),
				'AP' => __( 'Armed Forces (AP)', 'mrm' ),
			),
			'UY' => array( // Uruguayan states.
				'UY-AR' => __( 'Artigas', 'mrm' ),
				'UY-CA' => __( 'Canelones', 'mrm' ),
				'UY-CL' => __( 'Cerro Largo', 'mrm' ),
				'UY-CO' => __( 'Colonia', 'mrm' ),
				'UY-DU' => __( 'Durazno', 'mrm' ),
				'UY-FS' => __( 'Flores', 'mrm' ),
				'UY-FD' => __( 'Florida', 'mrm' ),
				'UY-LA' => __( 'Lavalleja', 'mrm' ),
				'UY-MA' => __( 'Maldonado', 'mrm' ),
				'UY-MO' => __( 'Montevideo', 'mrm' ),
				'UY-PA' => __( 'Paysandú', 'mrm' ),
				'UY-RN' => __( 'Río Negro', 'mrm' ),
				'UY-RV' => __( 'Rivera', 'mrm' ),
				'UY-RO' => __( 'Rocha', 'mrm' ),
				'UY-SA' => __( 'Salto', 'mrm' ),
				'UY-SJ' => __( 'San José', 'mrm' ),
				'UY-SO' => __( 'Soriano', 'mrm' ),
				'UY-TA' => __( 'Tacuarembó', 'mrm' ),
				'UY-TT' => __( 'Treinta y Tres', 'mrm' ),
			),
			'VE' => array( // Venezuelan states.
				'VE-A' => __( 'Capital', 'mrm' ),
				'VE-B' => __( 'Anzoátegui', 'mrm' ),
				'VE-C' => __( 'Apure', 'mrm' ),
				'VE-D' => __( 'Aragua', 'mrm' ),
				'VE-E' => __( 'Barinas', 'mrm' ),
				'VE-F' => __( 'Bolívar', 'mrm' ),
				'VE-G' => __( 'Carabobo', 'mrm' ),
				'VE-H' => __( 'Cojedes', 'mrm' ),
				'VE-I' => __( 'Falcón', 'mrm' ),
				'VE-J' => __( 'Guárico', 'mrm' ),
				'VE-K' => __( 'Lara', 'mrm' ),
				'VE-L' => __( 'Mérida', 'mrm' ),
				'VE-M' => __( 'Miranda', 'mrm' ),
				'VE-N' => __( 'Monagas', 'mrm' ),
				'VE-O' => __( 'Nueva Esparta', 'mrm' ),
				'VE-P' => __( 'Portuguesa', 'mrm' ),
				'VE-R' => __( 'Sucre', 'mrm' ),
				'VE-S' => __( 'Táchira', 'mrm' ),
				'VE-T' => __( 'Trujillo', 'mrm' ),
				'VE-U' => __( 'Yaracuy', 'mrm' ),
				'VE-V' => __( 'Zulia', 'mrm' ),
				'VE-W' => __( 'Federal Dependencies', 'mrm' ),
				'VE-X' => __( 'La Guaira (Vargas)', 'mrm' ),
				'VE-Y' => __( 'Delta Amacuro', 'mrm' ),
				'VE-Z' => __( 'Amazonas', 'mrm' ),
			),
			'VN' => array(),
			'YT' => array(),
			'ZA' => array( // South African states.
				'EC'  => __( 'Eastern Cape', 'mrm' ),
				'FS'  => __( 'Free State', 'mrm' ),
				'GP'  => __( 'Gauteng', 'mrm' ),
				'KZN' => __( 'KwaZulu-Natal', 'mrm' ),
				'LP'  => __( 'Limpopo', 'mrm' ),
				'MP'  => __( 'Mpumalanga', 'mrm' ),
				'NC'  => __( 'Northern Cape', 'mrm' ),
				'NW'  => __( 'North West', 'mrm' ),
				'WC'  => __( 'Western Cape', 'mrm' ),
			),
			'ZM' => array( // Zambian provinces.
				'ZM-01' => __( 'Western', 'mrm' ),
				'ZM-02' => __( 'Central', 'mrm' ),
				'ZM-03' => __( 'Eastern', 'mrm' ),
				'ZM-04' => __( 'Luapula', 'mrm' ),
				'ZM-05' => __( 'Northern', 'mrm' ),
				'ZM-06' => __( 'North-Western', 'mrm' ),
				'ZM-07' => __( 'Southern', 'mrm' ),
				'ZM-08' => __( 'Copperbelt', 'mrm' ),
				'ZM-09' => __( 'Lusaka', 'mrm' ),
				'ZM-10' => __( 'Muchinga', 'mrm' ),
			),
		);
	}

	/**
	 * Get the Contact data array.
	 *
	 * @return array The form data array.
	 * @since 1.4.3
	 */
	public static function get_exsiting_fields_array(): array {
		$exsiting_fields = array(
			array(
				'label'     => 'Gender',
				'value'      => 'gender',
				'type'      => 'selectField',
				'meta'      => array(
					'placeholder' => '',
					'label'       => 'Gender',
					'options'     => array('Male', 'Female', 'Others'),
				),
				'edit_mode' => true,
				'group_id'  => 2,
			),
			array(
				'label'     => 'Phone number',
				'value'      => 'phone_number',
				'type'      => 'number',
				'meta'      => array(
					'placeholder' => '',
					'label'       => 'Phone number',
				),
				'edit_mode' => true,
				'group_id'  => 2,
			),
			array(
				'label'     => 'Date of Birth',
				'value'      => 'date_of_birth',
				'type'      => 'date',
				'meta'      => array(
					'placeholder' => '',
					'label'       => 'Date of Birth',
				),
				'edit_mode' => true,
				'group_id'  => 2,
			),
			array(
				'label'     => 'Address Line 1',
				'value'      => 'address_line_1',
				'type'      => 'text',
				'meta'      => array(
					'placeholder' => '',
					'label'       => 'Address Line 1',
				),
				'edit_mode' => true,
				'group_id'  => 2,
			),
			array(
				'label'     => 'Address Line 2',
				'value'      => 'address_line_2',
				'type'      => 'text',
				'meta'      => array(
					'placeholder' => '',
					'label'       => 'Address Line 2',
				),
				'edit_mode' => true,
				'group_id'  => 2,
			),
			array(
				'label'     => 'City',
				'value'      => 'city',
				'type'      => 'text',
				'meta'      => array(
					'placeholder' => '',
					'label'       => 'City',
				),
				'edit_mode' => true,
				'group_id'  => 2,
				'segment'   => 'address',
			),
			array(
				'label'     => 'Postal / Zip',
				'value'      => 'postal',
				'type'      => 'text',
				'meta'      => array(
					'placeholder' => '',
					'label'       => 'Postal / Zip',
				),
				'edit_mode' => true,
				'group_id'  => 2,
				'segment'   => 'address',
			),
			array(
				'label'     => 'Country',
				'value'      => 'country',
				'type'      => 'selectField',
				'meta'      => array(
					'placeholder' => '',
					'label'       => 'Country',
					'options'     => array(),
				),
				'edit_mode' => true,
				'group_id'  => 2,
				'segment'   => 'address',
			),
			array(
				'label'     => 'State / Province',
				'value'      => 'state',
				'type'      => 'selectField',
				'meta'      => array(
					'placeholder' => '',
					'label'       => 'State / Province',
					'options'     => array(),
				),
				'edit_mode' => true,
				'group_id'  => 2,
				'segment'   => 'address',
			),
			array(
				'label'     => 'Timezone',
				'value'      => 'timezone',
				'type'      => 'text',
				'meta'      => array(
					'placeholder' => '',
					'label'       => 'Timezone',
					'options'     => array(),
				),
				'edit_mode' => true,
				'group_id'  => 2,
			),
			array(
				'label'     => 'Company',
				'value'     => 'company',
				'type'      => 'text',
				'meta'      => array(
					'placeholder' => '',
					'label'       => 'Company',
				),
				'edit_mode' => true,
				'group_id'  => 2,
			),
			array(
				'label'     => 'Designation',
				'value'     => 'designation',
				'type'      => 'text',
				'meta'      => array(
					'placeholder' => '',
					'label'       => 'Designation',
				),
				'edit_mode' => true,
				'group_id'  => 2,
			),
		);
		/**
		 * Apply filters to an existing field.
		 *
		 * Applies filters hooked into the 'mailmint_existing_field' hook to the provided $existing_fields value.
		 *
		 * @param array $existing_fields The value or variable to be filtered.
		 * @return array The filtered value after all filters have been applied.
		 * @
		 */
		return apply_filters( 'mailmint_existing_field', $exsiting_fields );
	}

}
