<?php
/**
 * WooCommerce Helper.
 *
 * @package MailMintPro\App\Utilities\Helper
 * @namespace MailMintPro\App\Utilities\Helper
 * @author [WPFunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2024-01-18 11:03:17
 * @modify date 2024-01-18 11:03:17
 */

namespace MailMintPro\App\Utilities\Helper;

use Mint\MRM\DataBase\Models\ContactGroupPivotModel;
use Mint\MRM\DataBase\Models\ContactModel;

/**
 * MintWC class
 *
 * MintWC helper class.
 *
 * @package MailMintPro\App\Utilities\Helper
 * @namespace MailMintPro\App\Utilities\Helper
 *
 * @version 1.8.0
 */
class MintWC {

	/**
	 * Retrieve contacts by group.
	 *
	 * Retrieves contacts associated with the given groups in batches and merges them into a contacts array.
	 *
	 * @param array $groups An array of group data.
	 * @param int   $offset The offset for pagination.
	 * @param int   $per_batch The number of contacts to retrieve per batch.
	 * @param array $contacts An array of contacts to merge with.
	 * @return array The updated array of contacts.
	 *
	 * @since 1.8.0
	 */
	public static function retrieve_contacts_by_group( $groups, $offset, $per_batch, $contacts ) {
		if ( !empty( $groups ) ) {
			$group_ids = array_column( $groups, 'id' );

			// Get contacts in batches based on group IDs.
			$recipients_ids = ContactGroupPivotModel::get_contacts_to_group($group_ids, $offset, $per_batch);
			$recipients_ids = array_column($recipients_ids, 'contact_id');
			$batch_contacts = ContactModel::get_single_email($recipients_ids);

			// Merge the batch contacts into the main contacts array.
			$contacts = array_merge($contacts, $batch_contacts);
		}

		return $contacts;
	}
}
