<?php
/**
 * Easy Digital Downloads Helper.
 *
 * @package MailMintPro\App\Utilities\Helper
 * @namespace MailMintPro\App\Utilities\Helper
 * @author [getwpfunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2023-12-08 11:03:17
 * @modify date 2023-12-08 11:03:17
 */

namespace MailMintPro\App\Utilities\Helper;

/**
 * MintEDD class
 *
 * MintEDD helper class.
 *
 * @package MailMintPro\App\Utilities\Helper
 * @namespace MailMintPro\App\Utilities\Helper
 *
 * @version 1.6.1
 */
class MintEDD {

	/**
	 * Get the total order count for a specific customer.
	 *
	 * @param int $customer_id The ID of the customer.
	 *
	 * @return int The total number of orders placed by the customer.
	 * @since 1.6.1
	 */
	public static function customer_total_order_count( $customer_id ) {
		global $wpdb;
		$query = "SELECT COUNT(*) FROM {$wpdb->prefix}edd_orders WHERE customer_id = %d";
		return $wpdb->get_var( $wpdb->prepare( $query, $customer_id ) ); //phpcs:ignore
	}

	/**
	 * Get a list of customer orders based on customer ID, offset, and per-page limit.
	 *
	 * @param int $customer_id The ID of the customer.
	 * @param int $offset      The offset for paginating through the results.
	 * @param int $per_page    The number of orders to retrieve per page.
	 *
	 * @return array|null An array of customer orders or null if no orders are found.
	 * @since 1.6.1
	 */
	public static function get_customer_orders( $customer_id, $offset, $per_page ) {
		global $wpdb;
		$query = $wpdb->prepare(
			"SELECT * FROM {$wpdb->prefix}edd_orders WHERE customer_id = %d ORDER BY id DESC LIMIT %d, %d",
			$customer_id,
			$offset,
			$per_page
		);

		return $wpdb->get_results( $query ); //phpcs:ignore
	}
}
