<?php

namespace MailMintPro\App\Utilities\Helper;

class Integration {

    public static function handle_zero_bounce_request( $api_key, $email, $ip_address = null ) {
        $endpoint = 'https://api.zerobounce.net/v2/validate';
        $params   = array(
            'api_key'    => $api_key,
            'email'      => $email,
            'ip_address' => $ip_address,
        );
        return MM()->wp_remote_request_handler->make_wp_requests( $endpoint, $params, array(), 2 );
    }

    public static function get_open_ai_secret_key() {
        $settings = get_option('_mint_integration_settings', array(
            'zero_bounce' => array(
                'api_key'       => '',
                'email_address' => '',
                'is_integrated' => false,
                'lists'         => array(),
            ),
            'twilio' => array(
                'account_sid'   => '',
                'auth_token'    => '',
                'from_number'   => '',
                'is_integrated' => false,
            ),
            'open_ai' => array(
                'secret_key'    => '',
                'is_integrated' => false,
            ),
        ));

        $secret_key    = isset( $settings['open_ai']['secret_key'] ) ? $settings['open_ai']['secret_key'] : get_option('_mint_open_ai_key', '');
        $is_integrated = isset( $settings['open_ai']['is_integrated'] ) ? $settings['open_ai']['is_integrated'] : false;
        return array(
            'secret_key'    => $secret_key,
            'is_integrated' => $is_integrated,
        );
    }
}