<?php

namespace MailMintPro\App\Utilities\Helper;

class FieldConditions {

    /**
     * Get conditions based on the field type
     *
     * @param string $field_type
     * @return array
     */
    public static function get_conditions_by_field_type($field_type){
        switch ($field_type) {
            case 'text':
            case 'textArea':
                return self::get_text_conditions();

            case 'date':
                return self::get_date_conditions();

            case 'selectField':
            case 'checkboxField':
            case 'radioField':
                return self::get_select_field_conditions();

            case 'number':
                return self::get_number_conditions();

            default:
                return [];  // Empty array if field type is not supported
        }
    }

    /**
     * Conditions for 'text' and 'textArea' fields
     *
     * @return array
     */
    private static function get_text_conditions(){
        return [
            [
                'condition_label' => 'equal',
                'condition_value' => 'equal',
                'actionType' => 'input_text',
            ],
            [
                'condition_label' => 'does not equal',
                'condition_value' => 'does_not_equal',
                'actionType' => 'input_text',
            ],
            [
                'condition_label' => 'includes',
                'condition_value' => 'includes',
                'actionType' => 'input_text',
            ],
            [
                'condition_label' => 'does not includes',
                'condition_value' => 'does_not_includes',
                'actionType' => 'input_text',
            ],
        ];
    }

    /**
     * Conditions for 'date' fields
     *
     * @return array
     */
    private static function get_date_conditions()
    {
        return [
            [
                'condition_label' => 'before',
                'condition_value' => 'before',
                'actionType' => 'date_time',
            ],
            [
                'condition_label' => 'after',
                'condition_value' => 'after',
                'actionType' => 'date_time',
            ],
            [
                'condition_label' => 'in the date',
                'condition_value' => 'in_the_date',
                'actionType' => 'date_time',
            ],
        ];
    }

    /**
     * Conditions for 'selectField' fields
     *
     * @return array
     */
    private static function get_select_field_conditions(){
        return [
            [
                'condition_label' => 'includes',
                'condition_value' => 'includes',
                'actionType'      => 'custom_field_select',
            ],
            [
                'condition_label' => 'does not includes (in any)',
                'condition_value' => 'does_not_includes',
                'actionType'      => 'custom_field_select',
            ],
            [
                'condition_label' => 'includes all of',
                'condition_value' => 'includes_all_of',
                'actionType'      => 'custom_field_select',
            ],
            [
                'condition_label' => 'includes none of (match all)',
                'condition_value' => 'includes_none_of',
                'actionType'      => 'custom_field_select',
            ],
        ];
    }

    /**
     * Conditions for 'number' fields
     *
     * @return array
     */
    private static function get_number_conditions(){
        return [
            [
                'condition_label' => 'equal',
                'condition_value' => 'equal',
                'actionType' => 'input_number',
            ],
            [
                'condition_label' => 'does not equal',
                'condition_value' => 'does_not_equal',
                'actionType' => 'input_number',
            ],
            [
                'condition_label' => 'greater than',
                'condition_value' => 'greater_than',
                'actionType' => 'input_number',
            ],
            [
                'condition_label' => 'less than',
                'condition_value' => 'less_than',
                'actionType' => 'input_number',
            ],
        ];
    }
}
