@charset "UTF-8";
.mintmrm * {
  margin: 0px;
  padding: 0px;
  box-sizing: border-box;
}
.mintmrm *:focus {
  box-shadow: none;
  outline: none;
}
.mintmrm p {
  -webkit-font-smoothing: antialiased;
  -moz-osx-font-smoothing: grayscale;
}
.mintmrm a,
.mintmrm p,
.mintmrm span,
.mintmrm section,
.mintmrm label,
.mintmrm div {
  font-style: normal;
}
.mintmrm a {
  text-decoration: none;
  color: #573bff;
}
.mintmrm a:hover {
  color: #4c25a5;
}
.mintmrm h1,
.mintmrm h2,
.mintmrm h3,
.mintmrm h4,
.mintmrm h5,
.mintmrm h6,
.mintmrm p,
.mintmrm figur,
.mintmrm a {
  margin: 0px;
}
.mintmrm h1,
.mintmrm h2,
.mintmrm h3,
.mintmrm h4,
.mintmrm h5,
.mintmrm h6 {
  font-weight: normal;
  -webkit-font-variant-ligatures: common-ligatures;
  font-variant-ligatures: common-ligatures;
}
.mintmrm a:hover,
.mintmrm a:focus,
.mintmrm input:focus,
.mintmrm button:focus,
.mintmrm a:active {
  text-decoration: none;
  outline: none;
  outline-offset: 0px;
  box-shadow: none;
}
.mintmrm ul {
  list-style: none;
  margin: 0;
  padding: 0;
}
.mintmrm img {
  display: block;
  max-width: 100%;
}

.crm-app-wrapper {
  display: block;
  margin-left: -20px;
}

.mintmrm {
  position: relative;
  min-height: 100vh;
  /* clears the ‘X’ from Internet Explorer */
  /* clears the ‘X’ from Chrome */
}
.mintmrm input[type=date],
.mintmrm input[type=search],
.mintmrm input[type=url],
.mintmrm input[type=tel],
.mintmrm input[type=number],
.mintmrm input[type=password],
.mintmrm input[type=email],
.mintmrm input[type=text],
.mintmrm textarea,
.mintmrm select {
  line-height: 1.3;
  color: #2D3149;
  padding: 9px 15px;
  width: 100%;
  border-radius: 6px;
  display: block;
  border: 1px solid #ebedf0;
  font-weight: 400;
}
.mintmrm input[type=date]::placeholder,
.mintmrm input[type=search]::placeholder,
.mintmrm input[type=url]::placeholder,
.mintmrm input[type=tel]::placeholder,
.mintmrm input[type=number]::placeholder,
.mintmrm input[type=password]::placeholder,
.mintmrm input[type=email]::placeholder,
.mintmrm input[type=text]::placeholder,
.mintmrm textarea::placeholder,
.mintmrm select::placeholder {
  color: #a4a8b5;
  font-weight: 400;
}
.mintmrm input[type=date]::-webkit-input-placeholder, .mintmrm input[type=date]::-moz-placeholder, .mintmrm input[type=date]:-ms-input-placeholder,
.mintmrm input[type=search]::-webkit-input-placeholder,
.mintmrm input[type=search]::-moz-placeholder,
.mintmrm input[type=search]:-ms-input-placeholder,
.mintmrm input[type=url]::-webkit-input-placeholder,
.mintmrm input[type=url]::-moz-placeholder,
.mintmrm input[type=url]:-ms-input-placeholder,
.mintmrm input[type=tel]::-webkit-input-placeholder,
.mintmrm input[type=tel]::-moz-placeholder,
.mintmrm input[type=tel]:-ms-input-placeholder,
.mintmrm input[type=number]::-webkit-input-placeholder,
.mintmrm input[type=number]::-moz-placeholder,
.mintmrm input[type=number]:-ms-input-placeholder,
.mintmrm input[type=password]::-webkit-input-placeholder,
.mintmrm input[type=password]::-moz-placeholder,
.mintmrm input[type=password]:-ms-input-placeholder,
.mintmrm input[type=email]::-webkit-input-placeholder,
.mintmrm input[type=email]::-moz-placeholder,
.mintmrm input[type=email]:-ms-input-placeholder,
.mintmrm input[type=text]::-webkit-input-placeholder,
.mintmrm input[type=text]::-moz-placeholder,
.mintmrm input[type=text]:-ms-input-placeholder,
.mintmrm textarea::-webkit-input-placeholder,
.mintmrm textarea::-moz-placeholder,
.mintmrm textarea:-ms-input-placeholder,
.mintmrm select::-webkit-input-placeholder,
.mintmrm select::-moz-placeholder,
.mintmrm select:-ms-input-placeholder {
  color: #a4a8b5;
  font-weight: 400;
}
.mintmrm input[type=date]:focus,
.mintmrm input[type=search]:focus,
.mintmrm input[type=url]:focus,
.mintmrm input[type=tel]:focus,
.mintmrm input[type=number]:focus,
.mintmrm input[type=password]:focus,
.mintmrm input[type=email]:focus,
.mintmrm input[type=text]:focus,
.mintmrm textarea:focus,
.mintmrm select:focus {
  outline: none;
  box-shadow: none;
  border-color: #e5e8f3;
  color: #2D3149;
}
.mintmrm input[type=date]:hover,
.mintmrm input[type=search]:hover,
.mintmrm input[type=url]:hover,
.mintmrm input[type=tel]:hover,
.mintmrm input[type=number]:hover,
.mintmrm input[type=password]:hover,
.mintmrm input[type=email]:hover,
.mintmrm input[type=text]:hover,
.mintmrm textarea:hover,
.mintmrm select:hover {
  color: #2D3149;
}
.mintmrm input[type=date][readonly],
.mintmrm input[type=search][readonly],
.mintmrm input[type=url][readonly],
.mintmrm input[type=tel][readonly],
.mintmrm input[type=number][readonly],
.mintmrm input[type=password][readonly],
.mintmrm input[type=email][readonly],
.mintmrm input[type=text][readonly],
.mintmrm textarea[readonly],
.mintmrm select[readonly] {
  cursor: not-allowed;
  background-color: #eee;
}
.mintmrm input[type=search]::-ms-clear {
  display: none;
  width: 0;
  height: 0;
}
.mintmrm input[type=search]::-ms-reveal {
  display: none;
  width: 0;
  height: 0;
}
.mintmrm input[type=search]::-webkit-search-decoration,
.mintmrm input[type=search]::-webkit-search-cancel-button,
.mintmrm input[type=search]::-webkit-search-results-button,
.mintmrm input[type=search]::-webkit-search-results-decoration {
  display: none;
}
.mintmrm textarea {
  resize: none;
  padding: 11px 15px;
}
.mintmrm select {
  max-width: inherit;
}
@media screen and (max-width: 782px) {
  .mintmrm textarea,
  .mintmrm input {
    font-size: 14px;
  }
}
.mintmrm .form-group {
  position: relative;
}
.mintmrm .form-group .drop-down-button {
  position: relative;
  width: 100%;
  border: 1px solid #ebedf0;
  border-radius: 6px;
  padding: 13px 33px 13px 12px;
  background-color: transparent;
  text-align: left;
  font-weight: 400;
  font-size: 14px;
  line-height: 1.21;
  color: #6a707c;
}
.mintmrm .form-group .drop-down-button:before {
  content: url(data:image/svg+xml,%3Csvg%20fill%3D%22none%22%20viewBox%3D%220%200%2012%207%22%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%3E%3Cpath%20stroke%3D%22%23A7A8B3%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%20stroke-width%3D%221.8%22%20d%3D%22M11%201L6%206%201%201%22%2F%3E%3C%2Fsvg%3E);
  width: 12px;
  display: block;
  position: absolute;
  right: 15px;
  top: 50%;
  margin-top: -9px;
  transition: all 0.3s ease;
}
.mintmrm .form-group .drop-down-button.show::before {
  transform: rotate(180deg);
}
.mintmrm a,
.mintmrm button[type=submit],
.mintmrm input[type=button],
.mintmrm input[type=submit],
.mintmrm .mintmrm-btn,
.mintmrm .transition-3ms {
  transition: all 0.3s ease;
}
.mintmrm .transition-5ms {
  transition: all 0.5s ease;
}
.mintmrm button {
  border: none;
  outline: none;
  box-shadow: none;
  cursor: pointer;
}
.mintmrm input[type=submit],
.mintmrm button[type=submit],
.mintmrm .mintmrm-btn {
  display: inline-block;
  border: 1px solid transparent;
  color: #fff;
  font-style: normal;
  font-weight: 600;
  font-size: 14px;
  line-height: 17px;
  letter-spacing: -0.01em;
  padding: 11px 18px;
  cursor: pointer;
  text-align: center;
  border-radius: 6px;
  text-transform: capitalize;
  background-color: #573bff;
}
.mintmrm input[type=submit]:hover,
.mintmrm button[type=submit]:hover,
.mintmrm .mintmrm-btn:hover {
  background-color: #4c25a5;
  color: #fff;
}
.mintmrm input[type=submit].outline,
.mintmrm button[type=submit].outline,
.mintmrm .mintmrm-btn.outline {
  background-color: transparent;
  color: #3c3f47;
  border-color: #dee1e8;
}
.mintmrm input[type=submit].outline:hover,
.mintmrm button[type=submit].outline:hover,
.mintmrm .mintmrm-btn.outline:hover {
  background-color: #573bff;
  border-color: #573bff;
  color: #fff;
}
.mintmrm input[type=submit]:disabled,
.mintmrm button[type=submit]:disabled,
.mintmrm .mintmrm-btn:disabled {
  opacity: 0.7;
  background: #BEBFCB;
  cursor: not-allowed;
  color: #EAEEF1;
}
.mintmrm input[type=submit].show-loader .mintmrm-loader,
.mintmrm button[type=submit].show-loader .mintmrm-loader,
.mintmrm .mintmrm-btn.show-loader .mintmrm-loader {
  display: inline-block;
}
.mintmrm label,
.mintmrm .label {
  font-style: normal;
  font-weight: 500;
  line-height: 1.2;
  color: #344054;
  display: block;
}
.mintmrm .fw-400 {
  font-weight: 400;
}
.mintmrm .fw-500 {
  font-weight: 500;
}
.mintmrm .pos-relative {
  position: relative;
  cursor: pointer;
}
.mintmrm .inter {
  font-family: "Inter";
}
.mintmrm .overlay {
  position: absolute;
  left: 0;
  top: 0;
  width: 100%;
  height: 100%;
}
.mintmrm .pro-tag {
  background: #6e42d3;
  box-shadow: 0px 3px 3px rgba(175, 175, 206, 0.3);
  border-radius: 3px;
  font-weight: 400;
  font-size: 13px;
  line-height: 15px;
  color: #fff;
  display: inline-block;
  text-transform: capitalize;
  padding: 2px 4px 3px;
}
.mintmrm .pro-tag a {
  color: #fff;
  line-height: 1;
  font-size: 13px;
}
.mintmrm .mintmrm-mb-16 {
  margin-bottom: 16px;
}
.mintmrm .label-block {
  display: block;
}
.mintmrm .label-block > label {
  width: 100%;
  padding: 0;
  margin-bottom: 5px;
}
.mintmrm .label-block .input-custom-wrapper {
  width: 100%;
}
.mintmrm .mintmrm-container {
  width: 100%;
  max-width: 1190px;
  padding: 0 15px;
  margin: 0 auto;
}
.mintmrm .mintmrm-container.import-cotainer {
  padding-bottom: 85px;
}
.mintmrm .no-product-notice {
  font-size: 11px;
  font-style: italic;
  font-weight: 500;
  text-transform: none;
  display: block;
  color: #f34252;
}
@media screen and (max-width: 782px) {
  .mintmrm input[type=text],
  .mintmrm input[type=password],
  .mintmrm input[type=date],
  .mintmrm input[type=datetime],
  .mintmrm input[type=datetime-local],
  .mintmrm input[type=email],
  .mintmrm input[type=month],
  .mintmrm input[type=number],
  .mintmrm input[type=search],
  .mintmrm input[type=tel],
  .mintmrm input[type=time],
  .mintmrm input[type=url],
  .mintmrm input[type=week] {
    min-height: auto;
  }
}
.mintmrm .hints {
  font-size: 13px;
  font-style: italic;
  color: #7a8b9a;
  margin-top: 4px;
  display: inline-block;
  word-break: break-all;
}
.mintmrm .error-message {
  font-size: 13px;
  font-weight: 500;
  margin-top: 4px;
  display: inline-block;
  word-break: break-all;
  color: #e03535;
  display: none;
  padding: 10px;
}
.mintmrm .error-message.show {
  display: flex;
}
.mintmrm .inactive {
  display: none;
}
.mintmrm .top-align {
  align-items: flex-start;
}
.mintmrm .top-align > label {
  padding-top: 10px;
}
.mintmrm .not-clickable-overlay {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: rgba(255, 255, 255, 0);
  z-index: 999;
  display: none;
  flex-flow: column;
  align-items: center;
  justify-content: center;
}
.mintmrm .not-clickable-overlay .import-message {
  color: #ffffff;
  font-size: 24px;
  font-weight: 500;
  display: none;
}
.mintmrm .mrm-submit-button {
  position: relative;
}
.mintmrm .mrm-submit-button::after {
  content: "";
  border: 2px solid #8265c5;
  border-radius: 50%;
  border-top: 2px solid #fff;
  width: 13px;
  height: 13px;
  animation: spin 0.7s linear infinite;
  margin-left: 7px;
  position: relative;
  top: 2px;
  display: none;
  box-sizing: border-box;
}
.mintmrm .mrm-submit-button.show-loader::after {
  display: inline-block;
}
@-webkit-keyframes spin {
  0% {
    -webkit-transform: rotate(0deg);
  }
  100% {
    -webkit-transform: rotate(360deg);
  }
}
@keyframes spin {
  0% {
    transform: rotate(0deg);
  }
  100% {
    transform: rotate(360deg);
  }
}
.mintmrm .mintmrm-tag-list {
  border: 1px solid #e4e6eb;
  border-radius: 4px;
  font-size: 13px;
  line-height: 1;
  letter-spacing: -0.01em;
  color: #667085;
  display: inline-block;
  padding: 3px 25px 5px 6px;
  margin: 3px;
  position: relative;
  vertical-align: middle;
}
.mintmrm .mintmrm-tag-list .close-list {
  background: transparent;
  padding: 2px 6px 2px;
  border-radius: 2px;
  font-size: 10px;
  cursor: pointer;
  position: absolute;
  top: 0;
  right: 0;
  height: 100%;
  border: none;
  border-left: 1px solid #e4e6eb;
  display: flex;
  align-items: center;
  justify-content: center;
}
.mintmrm .mintmrm-tag-list .close-list svg {
  width: 7px;
  height: 7px;
  display: block;
}
.mintmrm .mintmrm-tag-list .close-list svg path {
  fill: #a7a8b3;
}
.mintmrm .wp-editor-tools .wp-media-buttons .add_media {
  color: #573bff;
  border-color: #573bff;
}
.mintmrm .data-status {
  font-size: 12px;
  line-height: 1.25;
  font-weight: 600;
  color: #121212;
  padding: 5px 9px;
  border-radius: 6px;
  display: inline-block;
  text-transform: capitalize;
  background: #f4f4f4;
}
.mintmrm .data-status.publish {
  color: #239654;
  background: rgba(35, 150, 84, 0.1);
}
.mintmrm .recipient-dropdown .checkbox-options {
  max-height: 284px;
  overflow: auto;
  overflow-x: hidden;
  margin-top: 10px;
  padding-bottom: 10px;
}
.mintmrm .recipient-dropdown .checkbox-options::-webkit-scrollbar {
  width: 5px;
}
.mintmrm .recipient-dropdown .checkbox-options::-webkit-scrollbar-track {
  background: #f2f5f8;
}
.mintmrm .recipient-dropdown .checkbox-options::-webkit-scrollbar-thumb {
  background-color: #c1c1c1;
  border-radius: 20px;
}
.mintmrm .mrm-form-group.alignment-center {
  margin-left: auto;
  margin-right: auto;
}
.mintmrm .mrm-form-group.alignment-right {
  margin-left: auto;
  margin-right: 0;
}

.mintmrm-license-page {
  background: transparent;
}

.cl-doc-row .single-col, .mintmrm-license-wrapper .promo-text-area .manage-license-area {
  background: #fff;
  padding: 30px;
  margin-right: 24px;
  width: 33.3333333333%;
  border-radius: 10px;
  display: flex;
  flex-flow: row wrap;
  position: relative;
  box-shadow: 0px 1px 1px rgba(182, 185, 191, 0.3019607843);
}
.cl-doc-row .single-col:last-child, .mintmrm-license-wrapper .promo-text-area .manage-license-area:last-child {
  margin-right: 0;
}
.cl-doc-row .single-col .icon, .mintmrm-license-wrapper .promo-text-area .manage-license-area .icon {
  width: 60px;
  height: 60px;
  display: flex;
  flex-flow: column;
  align-items: center;
  justify-content: center;
  border-radius: 100%;
  border: 1px solid #EBEDF0;
  position: static;
}
.cl-doc-row .single-col .col-info, .mintmrm-license-wrapper .promo-text-area .manage-license-area .col-info {
  width: calc(100% - 60px);
  padding-left: 22px;
}
.cl-doc-row .single-col .title, .mintmrm-license-wrapper .promo-text-area .manage-license-area .title {
  font-size: 15px;
  line-height: 1.2;
  font-weight: 700;
  margin-bottom: 6px;
  color: #2D3149;
  padding-left: 0px;
}
.cl-doc-row .single-col p, .mintmrm-license-wrapper .promo-text-area .manage-license-area p {
  font-size: 14px;
  line-height: 1.5;
  font-weight: 400;
  margin-bottom: 20px;
  color: #6A707C;
}
.cl-doc-row .single-col .mintmrm-btn, .mintmrm-license-wrapper .promo-text-area .manage-license-area .mintmrm-btn {
  margin-top: auto;
  border: 1px solid #ebedf0;
  background: transparent;
  color: #2d3149;
  padding: 9px 18px;
}
.cl-doc-row .single-col .mintmrm-btn:hover, .mintmrm-license-wrapper .promo-text-area .manage-license-area .mintmrm-btn:hover {
  background-color: #573bff;
  color: #fff;
  border-color: #573bff;
}

.mintmrm-license-wrapper {
  display: flex;
  flex-flow: row wrap;
  margin-top: 24px;
  padding-right: 24px;
}
.mintmrm-license-wrapper .mintmrm-license-filed {
  background: #FFFFFF;
  box-shadow: 0px 1px 1px rgba(182, 185, 191, 0.3019607843);
  border-radius: 10px;
  width: calc(66.6666666667% - 9px);
  margin-right: 24px;
  padding: 15px 20px 20px;
}
.mintmrm-license-wrapper .mintmrm-license-filed .field-header .product-title,
.mintmrm-license-wrapper .mintmrm-license-filed .input-field-area .product-title {
  width: 220px;
  position: relative;
}
.mintmrm-license-wrapper .mintmrm-license-filed .field-header .input-field,
.mintmrm-license-wrapper .mintmrm-license-filed .input-field-area .input-field {
  width: calc(100% - 400px);
  max-width: 660px;
  padding: 0 16px;
  position: relative;
  margin-left: auto;
}
.mintmrm-license-wrapper .mintmrm-license-filed .field-header .btn-area,
.mintmrm-license-wrapper .mintmrm-license-filed .input-field-area .btn-area {
  width: 170px;
}
.mintmrm-license-wrapper .mintmrm-license-filed .field-header {
  display: flex;
  flex-flow: row wrap;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 30px;
  position: relative;
  padding-bottom: 15px;
}
.mintmrm-license-wrapper .mintmrm-license-filed .field-header:before {
  content: "";
  position: absolute;
  left: -20px;
  bottom: 0;
  width: calc(100% + 40px);
  height: 1px;
  background: #E5E8F3;
}
.mintmrm-license-wrapper .mintmrm-license-filed .field-header .single-field {
  color: #9398a5;
}
.mintmrm-license-wrapper .mintmrm-license-filed .input-field-area {
  display: flex;
  flex-flow: row wrap;
  justify-content: space-between;
  align-items: center;
  width: 100%;
}
.mintmrm-license-wrapper .mintmrm-license-filed .input-field-area .product-title {
  display: flex;
  align-items: center;
}
.mintmrm-license-wrapper .mintmrm-license-filed .input-field-area .product-title .icon-info {
  width: calc(100% - 50px);
  padding-left: 15px;
}
.mintmrm-license-wrapper .mintmrm-license-filed .input-field-area .product-title h3 {
  font-weight: 500;
  font-size: 20px;
  line-height: 23px;
  color: #363B4E;
}
.mintmrm-license-wrapper .mintmrm-license-filed .input-field-area .license-status {
  font-size: 14px;
  line-height: 16px;
  color: #7A8B9A;
  display: block;
  position: absolute;
  bottom: -20px;
}
.mintmrm-license-wrapper .mintmrm-license-filed .input-field-area .addon-icon {
  display: flex;
  align-items: center;
  justify-content: center;
}
.mintmrm-license-wrapper .mintmrm-license-filed .input-field-area .input-field input {
  height: 46px;
  padding: 6px 15px 5px;
  border: 1px solid #E4E6EB;
}
.mintmrm-license-wrapper .mintmrm-license-filed .input-field-area .btn-area {
  position: relative;
}
.mintmrm-license-wrapper .mintmrm-license-filed .input-field-area .btn-area .mintmrm-btn {
  padding: 0 22px;
  height: 46px;
  min-width: 162px;
  border-radius: 6px;
}
.mintmrm-license-wrapper .mintmrm-license-filed .input-field-area .btn-area .lnc-notice {
  color: green;
  font-size: 15px;
  text-transform: capitalize;
  margin-left: 8px;
  position: absolute;
  bottom: -24px;
  left: -4px;
}
.mintmrm-license-wrapper .mintmrm-license-filed .addons-license {
  padding: 15px;
  background: #F7F7FA;
  margin-top: 30px;
  border-radius: 0 8px 8px 0;
  border-left: 2px solid #573bff;
}
.mintmrm-license-wrapper .mintmrm-license-filed .addons-license .single-addons {
  margin-bottom: 15px;
}
.mintmrm-license-wrapper .mintmrm-license-filed .addons-license .single-addons:last-child {
  margin-bottom: 0;
}
.mintmrm-license-wrapper .mintmrm-license-filed .addons-license .input-field-area {
  padding: 12px 15px;
  background-color: #fff;
  box-shadow: 0px 1px 2px rgba(190, 190, 215, 0.2);
  border-radius: 6px;
}
.mintmrm-license-wrapper .mintmrm-license-filed .addons-license .input-field-area .product-title {
  width: 362px;
}
.mintmrm-license-wrapper .mintmrm-license-filed .addons-license .input-field-area .addon-icon {
  background: #F7F7FA;
}
.mintmrm-license-wrapper .mintmrm-license-filed .addons-license .input-field-area h3 {
  font-weight: 500;
  font-size: 14px;
  line-height: 1.1;
  color: #363B4E;
}
.mintmrm-license-wrapper .mintmrm-license-filed .addons-license .input-field-area .input-field input {
  height: 38px;
}
.mintmrm-license-wrapper .mintmrm-license-filed .addons-license .input-field-area .btn-area {
  width: 145px;
}
.mintmrm-license-wrapper .mintmrm-license-filed .addons-license .input-field-area .btn-area .mintmrm-btn {
  padding: 0 18px;
  font-size: 13px;
  height: 38px;
  min-width: auto;
  margin-left: auto;
  display: block;
  border-radius: 6px;
  width: 100%;
}
.mintmrm-license-wrapper .mintmrm-license-filed .addons-license .not-get-addons .input-field-area .product-title {
  width: calc(100% - 200px);
}
.mintmrm-license-wrapper .promo-text-area {
  width: calc(33.3333333333% - 15px);
  background: #FFF;
  border-radius: 10px;
  box-shadow: 0px 1px 2px rgba(190, 190, 215, 0.2);
}
.mintmrm-license-wrapper .promo-text-area .manage-license-area {
  margin-right: 0;
  width: 100%;
  height: 100%;
  box-shadow: none;
}
.mintmrm-license-wrapper .promo-text-area .manage-license-area p {
  max-width: 340px;
}

.cl-doc-row {
  display: flex;
  margin-top: 24px;
  padding-right: 24px;
  gap: 0px;
  flex-flow: nowrap;
}
@media only screen and (max-width: 1399px) {
  .mintmrm-license-wrapper .mintmrm-license-filed .input-field-area .addon-icon svg {
    width: 129px;
  }
  .mintmrm-license-wrapper .mintmrm-license-filed .field-header .product-title,
  .mintmrm-license-wrapper .mintmrm-license-filed .input-field-area .product-title {
    width: 140px;
  }
  .mintmrm-license-wrapper .mintmrm-license-filed .field-header .input-field,
  .mintmrm-license-wrapper .mintmrm-license-filed .input-field-area .input-field {
    width: calc(100% - 311px);
  }
  .mintmrm-license-wrapper .mintmrm-license-filed .input-field-area .btn-area .mintmrm-btn {
    min-width: 152px;
  }
  .mintmrm-license-wrapper .mintmrm-license-filed .field-header .btn-area,
  .mintmrm-license-wrapper .mintmrm-license-filed .input-field-area .btn-area {
    width: 162px;
  }
  .cl-doc-row .single-col,
  .mintmrm-license-wrapper .promo-text-area .manage-license-area {
    padding: 15px;
  }
}
@media only screen and (max-width: 1199px) {
  .cl-doc-row .single-col,
  .mintmrm-license-wrapper .promo-text-area .manage-license-area {
    display: block;
  }
  .cl-doc-row .single-col .icon,
  .mintmrm-license-wrapper .promo-text-area .manage-license-area .icon {
    width: 50px;
    height: 50px;
  }
  .cl-doc-row .single-col .col-info,
  .mintmrm-license-wrapper .promo-text-area .manage-license-area .col-info {
    width: 100%;
    padding-left: 0;
    margin-top: 13px;
  }
  .cl-doc-row {
    margin-top: 20px;
  }
  .cl-doc-row .single-col {
    padding: 20px;
    margin-right: 20px;
  }
}
@media only screen and (max-width: 991px) {
  .mintmrm-license-wrapper .mintmrm-license-filed .field-header {
    display: none;
  }
  .mintmrm-license-wrapper .mintmrm-license-filed {
    width: 100%;
    margin-right: 0;
  }
  .mintmrm-license-wrapper .mintmrm-license-filed {
    width: 100%;
    margin-right: 0;
    margin-bottom: 20px;
  }
  .mintmrm-license-wrapper .promo-text-area {
    width: 100%;
  }
  .mintmrm-license-wrapper .mintmrm-license-filed .field-header .btn-area,
  .mintmrm-license-wrapper .mintmrm-license-filed .input-field-area .btn-area {
    width: auto;
  }
  .cl-doc-row {
    display: block;
  }
  .cl-doc-row .single-col {
    width: 100%;
    margin-bottom: 20px;
    margin-right: 0;
  }
}
body.rtl.mail-mint_page_mail-mint-licence .mintmrm-license-wrapper {
  padding-left: 24px;
  padding-right: 0;
}
body.rtl.mail-mint_page_mail-mint-licence .mintmrm-license-wrapper .mintmrm-license-filed {
  margin-left: 24px;
  margin-right: 0;
}
body.rtl.mail-mint_page_mail-mint-licence .cl-doc-row {
  padding-left: 24px;
  padding-right: 0px;
}
body.rtl.mail-mint_page_mail-mint-licence .cl-doc-row .single-col, body.rtl.mail-mint_page_mail-mint-licence .mintmrm-license-wrapper .promo-text-area .manage-license-area {
  margin-left: 24px;
  margin-right: 0px;
}
body.rtl.mail-mint_page_mail-mint-licence .cl-doc-row .single-col:last-child,
body.rtl.mail-mint_page_mail-mint-licence .mintmrm-license-wrapper .promo-text-area .manage-license-area:last-child {
  margin-left: 0;
}
body.rtl.mail-mint_page_mail-mint-licence .cl-doc-row .single-col .col-info,
body.rtl.mail-mint_page_mail-mint-licence .mintmrm-license-wrapper .promo-text-area .manage-license-area .col-info {
  padding-right: 22px;
  padding-left: 0px;
}
body.rtl.mail-mint_page_mail-mint-licence .mintmrm-license-wrapper .mintmrm-license-filed .field-header .input-field,
body.rtl.mail-mint_page_mail-mint-licence .mintmrm-license-wrapper .mintmrm-license-filed .input-field-area .input-field {
  margin-right: auto;
  margin-left: 0;
}

/*# sourceMappingURL=mail-mint-pro.cs.map */
