<?php
/**
 * ElementorMintIntegration Class.
 *
 * @author [MRM Team]
 * @email [support@rextheme.com]
 * @create date 2022-08-09 11:03:17
 * @modify date 2022-08-09 11:03:17
 * @package /app
 */

namespace MailMintPro\Mint\Internal\Integration\Elementor;

use ElementorFormAction;

/**
 * Integrate Elementor Form with Automation.
 */
class ElementorMintIntegration {

	/**
	 * Init the construct
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		if ( apply_filters( 'mintmail_disable_elementor_form', false ) ) {
			return;
		}
		$this->register_elementor_mailmint_form_action();
	}

	/**
	 * Register Elementor for mailmint action.
	 *
	 * @return void
	 */
	public function register_elementor_mailmint_form_action() {
		add_action( 'elementor_pro/forms/actions/register', array( $this, 'add_new_mailmint_form_action' ) );
	}

	/**
	 * Added new mail mint action Registration
	 *
	 * @param object $form_actions_registrar Register object.
	 * @return void
	 */
	public function add_new_mailmint_form_action( $form_actions_registrar ) {
		$form_actions_registrar->register( new ElementorFormAction() );
	}
}
