<?php
/**
 * Elementor Form  Integration
 *
 * @package  MailMintPro\Mint\Internal\Integration
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
use ElementorPro\Modules\Forms\Classes\Action_Base;
use \Elementor\Controls_Manager;
use Elementor\Repeater;
use ElementorPro\Modules\Forms\Controls\Fields_Map;
use Mint\MRM\Constants;
use Mint\MRM\DataBase\Models\ContactGroupModel;
use ElementorPro\Modules\Forms\Widgets\Form;
use Mint\MRM\DataBase\Models\ContactModel;
use Mint\MRM\DataBase\Models\CustomFieldModel;
use MRM\Common\MrmCommon;
/**
 * Elementor Form  Integration
 *
 * @package  MailMintPro\Mint\Internal\Integration\ElementorFormAction
 */
class ElementorFormAction extends Action_Base {

	/**
	 * Integration name
	 *
	 * @return string
	 */
	public function get_name() {
		return 'mailmint_integration';
	}

	/**
	 * Integration label for dropdown
	 *
	 * @return string
	 */
	public function get_label() {
		return esc_html__( 'Mail Mint', 'mailmint-pro' );
	}

	/**
	 * Register setting for widget.
	 *
	 * @param string $widget Elementor Widget.
	 * @return false|void
	 */
	public function register_settings_section( $widget ) {
		if ( !method_exists( $this, 'mint_register_fields_map_control' ) ) {
			return false;
		}
		$widget->start_controls_section(
			'_ei_section_mailmint',
			array(
				'label'     => __( 'Mail Mint', 'mailmint-pro' ),
				'condition' => array(
					'submit_actions' => $this->get_name(),
				),
			)
		);

		$list_ids = array();

		$lists = ContactGroupModel::get_all_to_custom_select( 'lists' );
		if ( isset( $lists['data'] ) ) {
			foreach ( $lists['data'] as $list ) {
				$list_ids[ $list['id'] ] = $list['title'];
			}
		}

		$widget->add_control(
			'mailmint_lists',
			array(
				'label'       => __( 'Select Lists', 'mailmint-pro' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT2,
				'multiple'    => true,
				'options'     => $list_ids,
			)
		);

		$tag_ids = array();
		$tags    = ContactGroupModel::get_all_to_custom_select( 'tags' );
		if ( isset( $tags['data'] ) ) {
			foreach ( $tags['data'] as $tag ) {
				$tag_ids[ $tag['id'] ] = $tag['title'];
			}
		}

		$widget->add_control(
			'mailmint_tags',
			array(
				'label'       => __( 'Select tags', 'mailmint-pro' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT2,
				'multiple'    => true,
				'options'     => $tag_ids,
			)
		);
		$this->mint_register_fields_map_control( $widget );

		$widget->end_controls_section();
	}

	/**
	 * Get All fields in Widget.
	 *
	 * @return array
	 */
	private function get_fields() {
		$main_fields        = Constants::$contacts_attrs;
		$custom_fields      = CustomFieldModel::get_all();
		$custom_fields_data = isset( $custom_fields['data'] ) ? $custom_fields['data'] : array();
		$custom_fields_map  = array();
		foreach ( $custom_fields_data as $key => $value ) {
			$custom_fields_map[] = array(
				'name' => $value['title'],
				'slug' => $value['slug'],
			);
		}
		$main_fields    = array_merge( $main_fields, $custom_fields_map );
		$fields         = array();
		$contact_fields = array();
		foreach ( $main_fields as $key => $value ) {
			$contact_fields[ $value['slug'] ] = $value['name'];
		}
		foreach ( $contact_fields as $field_key => $field_label ) {
			$fields[] = array(
				'remote_label'    => $field_label,
				'remote_type'     => 'text',
				'remote_id'       => $field_key,
				'remote_required' => 'email' === $field_key,
			);
		}
		return $fields;
	}

	/**
	 * Trigger when elementor form is submitted.
	 *
	 * @param object $record Submitted data.
	 * @param object $ajax_handler Submission ajax.
	 * @return true|void
	 */
	public function run( $record, $ajax_handler ) {
		$settings  = $record->get( 'form_settings' );
		$sent_data = $record->get( 'sent_data' );

		$fields = $settings['mailmint_integration_fields_map'];
		if ( !$fields ) {
			$fields = $settings['mailmint_fields_map'];
		}

		$contact_data = array();
		foreach ( $fields as $map_field ) {
			if ( !empty( $map_field['local_id'] ) && !empty( $sent_data[ $map_field['local_id'] ] ) ) {
				if ( 'email' === $map_field['remote_id'] ) {
					$contact_data[ $map_field['remote_id'] ] = $sent_data[ $map_field['local_id'] ];
				} elseif ( 'first_name' === $map_field['remote_id'] ) {
					$contact_data[ $map_field['remote_id'] ] = $sent_data[ $map_field['local_id'] ];
				} elseif ( 'last_name' === $map_field['remote_id'] ) {
					$contact_data[ $map_field['remote_id'] ] = $sent_data[ $map_field['local_id'] ];
				} else {
					$contact_data['meta_fields'][ $map_field['remote_id'] ] = $sent_data[ $map_field['local_id'] ];
				}
			}
		}
		if ( empty( $contact_data['email'] ) || !is_email( $contact_data['email'] ) ) {
			return;
		}
		$exist_contact = ContactModel::get_contact_by_email( $contact_data['email'] );
		if ( !empty( $exist_contact ) && is_array( $exist_contact ) ) {
			$exist_status = !empty( $exist_contact['status'] ) ? $exist_contact['status'] : 'pending';
			if ( 'unsubscribed' === $exist_status ) {
				$contact_data['status'] = MrmCommon::is_double_optin_enable() ? 'pending' : 'subscribed';
			} else {
				$contact_data['status'] = $exist_status;
			}
		} else {
			$contact_data['status'] = MrmCommon::is_double_optin_enable() ? 'pending' : 'subscribed';
		}
		$contact_data['source'] = 'Elementor Form';

		if ( $added_lists = $settings['mailmint_lists'] ) { //phpcs:ignore
			$contact_data['lists'] = $added_lists;
		}

		if ( $added_tags = $settings['mailmint_tags'] ) { //phpcs:ignore
			$contact_data['tags'] = $added_tags;
		}
		mailmint_create_single_contact( $contact_data );

		return true;
	}

	/**
	 * Get Setting elementor for widget setting.
	 *
	 * @param string $element Get Setting elementor for widget setting.
	 * @return void
	 */
	public function on_export( $element ) {
		unset(
			$element['settings']['mailmint_fields_map'],
			$element['settings']['mailmint_integration_fields_map'],
			$element['settings']['mailmint_tags'],
			$element['settings']['mailmint_lists']
		);
	}

	/**
	 * Ger Handle Request.
	 *
	 * @param array $data Get handle data for setting.
	 *
	 * @return void
	 */
	public function handle_panel_request( array $data ) {
	}

	/**
	 * Mapping fields data in custom fields.
	 *
	 * @return array
	 */
	protected function get_mint_fields_map_control_options() {
		return array(
			'default'   => $this->get_fields(),
			'condition' => array(),
		);
	}

	/**
	 * Added Custom fields control in elementor form widget.
	 *
	 * @param Form $form Elementor form data.
	 * @return void
	 */
	protected function mint_register_fields_map_control( Form $form ) {
		$repeater = new Repeater();

		$repeater->add_control( 'remote_id', array( 'type' => Controls_Manager::HIDDEN ) );

		$repeater->add_control( 'local_id', array( 'type' => Controls_Manager::SELECT ) );

		$fields_map_control_options = array(
			'label'     => esc_html__( 'Field Mapping', 'mailmint-pro' ),
			'type'      => Fields_Map::CONTROL_TYPE,
			'separator' => 'before',
			'fields'    => $repeater->get_controls(),
		);

		$fields_map_control_options = array_merge( $fields_map_control_options, $this->get_mint_fields_map_control_options() );

		$form->add_control( $this->get_name() . '_fields_map', $fields_map_control_options );
	}
}
