<?php
/**
 * Mail Mint
 *
 * @author [MailMint Team]
 * @email [support@rextheme.com]
 * @create date 2022-08-09 11:03:17
 * @modify date 2022-08-09 11:03:17
 * @package /app/Internal/Frontend
 */

namespace MailMintPro\Mint\Internal\Frontend;

use MailMintPro\Mint\Internal\AbandonedCart\Helper\Common;
use MRM\Common\MrmCommon;

/**
 * [Manages plugin's frontend assets]
 *
 * @desc Manages plugin's frontend assets
 * @package /app/Internal/Frontend
 * @since 1.5.0
 */
class FrontendAssets {

	/**
	 * Initializes class functionalities
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
	}


	/**
	 * Load plugin main js file
	 *
	 * @param string $hook Hook suffix of current admin page.
	 *
	 * @since 1.5.0
	 * @since 1.15.4 Add is_checkout_block variable.
	 */
	public function enqueue_scripts( $hook ) {
		if (isset($_COOKIE['mint_ab_cart_skip_track']) && $_COOKIE['mint_ab_cart_skip_track'] == 'yes') {
			return false;
		}
		wp_enqueue_script(
			MAIL_MINT_PLUGIN_NAME,
			MAIL_MINT_DIR_URL . 'assets/frontend/js/abandoned-cart.js',
			array( 'jquery' ),
			MAIL_MINT_PRO_VERSION,
			true
		);
		wp_localize_script(
			MAIL_MINT_PLUGIN_NAME,
			'MintProFrontendVars',
			array(
				'ajaxurl'           => admin_url( 'admin-ajax.php' ),
				'nonce'             => wp_create_nonce( 'wp_rest' ),
				'abandoned_setting' => Common::get_abandoned_cart_settings(),
				'is_checkout_block' => MrmCommon::is_wc_active() ? Common::is_checkout_block() : false,
			)
		);
	}
}
