<?php
/**
 * FormBuilder Class.
 *
 * @author [MRM Team]
 * @email [support@rextheme.com]
 * @create date 2022-08-09 11:03:17
 * @modify date 2022-08-09 11:03:17
 * @package MailMintPro\Mint\Internal;
 */

namespace MailMintPro\Mint\Internal;

use MailMintPro\Mint\Internal\Traits\Singleton;
/**
 * FormBuilder Class.
 *
 * @package MailMintPro\Mint\Internal\FormBuilderHook;
 */
class FormBuilderHook {
	use Singleton;

	/**
	 * Run Mailmint Filter hook.
	 *
	 * @return void
	 */
	public function init() {
		add_filter( 'mailmint_add_form_builder_blocks_support', array( $this, 'mintform_custom_block_add' ), 10, 1 );
		add_filter( 'mailmint_form_template', array( $this, 'mint_form_pro_templates' ), 10, 1 );
	}

	/**
	 * Mint Custom field block add.
	 *
	 * @param array $blocks Mint form block.
	 * @return mixed
	 */
	public function mintform_custom_block_add( $blocks ) {
		$blocks [] = 'mrmformfield/mrm-custom-field';
		return $blocks;
	}


	/**
	 * Mint form Pro template part.
	 *
	 * @param array $form get all form.
	 * @return array
	 */
	public function mint_form_pro_templates( $form ) {
		$image_path = plugins_url( 'img', __FILE__ );
		if ( isset( $form[5] ) ) {
			$form[5]['content']  = '<!-- wp:columns {"verticalAlignment":"center","backgroundColor":"white"} -->
                <div class="wp-block-columns are-vertically-aligned-center has-white-background-color has-background"><!-- wp:column {"verticalAlignment":"center"} -->
                <div class="wp-block-column is-vertically-aligned-center"><!-- wp:image {"id":19,"width":433,"height":581,"sizeSlug":"full","linkDestination":"none"} -->
                <figure class="wp-block-image size-full is-resized"><img src="' . $image_path . '/black-friday.png" alt="Black Friday" class="wp-image-19" width="433" height="581"/></figure>
                <!-- /wp:image --></div>
                <!-- /wp:column -->

                <!-- wp:column {"verticalAlignment":"center"} -->
                <div class="wp-block-column is-vertically-aligned-center"><!-- wp:image {"align":"center","id":58,"style":{"color":{}}} -->
                <figure class="wp-block-image aligncenter"><img src="' . $image_path . '/libon-f-7.png" alt="libon" class="wp-image-58"/></figure>
                <!-- /wp:image -->

                <!-- wp:heading {"textAlign":"center","level":1,"style":{"color":{"text":"#333333"},"typography":{"fontSize":48,"fontStyle":"normal","fontWeight":"600"},"spacing":{"margin":{"top":"0px"}}}} -->
                <h1 class="has-text-align-center has-text-color" style="color:#333333;margin-top:0px;font-size:48px;font-style:normal;font-weight:600">' . __( 'Black Friday', 'mailmint-pro' ) . ' <br><span style="color:#CFAE42; font-weight: 600;">' . __( 'Sale', 'mailmint-pro' ) . '</span></h1>
                <!-- /wp:heading -->

                <!-- wp:paragraph {"align":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"400","fontSize":16},"color":{"text":"#848484"},"spacing":{"margin":{"bottom":"25px","right":"30px","left":"30px"}}}} -->
                <p class="has-text-align-center has-text-color" style="color:#848484;margin-right:30px;margin-bottom:25px;margin-left:30px;font-size:16px;font-style:normal;font-weight:400">' . __( 'We don’t want you to miss a thing - sign up to get our discounts', 'mailmint-pro' ) . '.</p>
                <!-- /wp:paragraph -->

				<!-- wp:mrmformfield/email-field-block {"emailPlaceholder":"Enter Email*","rowSpacing":14,"labelTypography":{"openTypography":false},"inputTypography":{"openTypography":false},"inputTextColor":"#a4a4a4","inputBorderRadius":6,"inputBorderColor":"#e9e9e9"} -->
				<div class="mrm-form-group mrm-input-group alignment-left email" style="margin-bottom:14px ;width:100% ;max-width:px "><label for="mrm-email" style="color:#363B4E;margin-bottom:7px"></label><div class="input-wrapper"><input type="email" name="email" id="mrm-email" placeholder="' . __( 'Enter Email*', 'mailmint-pro' ) . '" required style="background-color:#ffffff;color:#a4a4a4;font-size:14px;border-radius:6px;padding-top:11px;padding-right:14px;padding-bottom:11px;padding-left:14px;border-style:solid;border-width:1px;border-color:#e9e9e9" pattern="[^@\s]+@[^@\s]+\.[^@\s]+"/></div></div>
				<!-- /wp:mrmformfield/email-field-block -->

				<!-- wp:mrmformfield/first-name-block {"firstNamePlaceholder":"Enter First Name ","rowSpacing":20,"labelTypography":{},"inputTypography":{},"inputTextColor":"#a4a4a4","inputBorderRadius":6,"inputBorderColor":"#e9e9e9"} -->
				<div class="mrm-form-group mrm-input-group alignment-left first-name" style="margin-bottom:20px;width:% ;max-width:px "><label for="mrm-first-name" style="color:#363B4E;margin-bottom:7px"></label><div class="input-wrapper"><input type="text" name="first_name" id="mrm-first-name" placeholder="' . __( 'Enter First Name', 'mailmint-pro' ) . ' " style="background-color:#ffffff;color:#a4a4a4;font-size:14px;border-radius:6px;padding-top:11px;padding-right:14px;padding-bottom:11px;padding-left:14px;border-style:solid;border-width:1px;border-color:#e9e9e9"/></div></div>
				<!-- /wp:mrmformfield/first-name-block -->

                <!-- wp:mrmformfield/mrm-button-block {"buttonBgColor":"#cfae42","buttonBorderRadius":6,"buttonText":"Subscribe","buttonWidth":100,"typography":{"openTypography":false},"buttonFontSize":18,"paddingTopBottom":20} -->
                <div class="mrm-form-group submit" style="margin-bottom:12px;text-align:left"><button class="mrm-submit-button mintmrm-btn" type="submit" aria-label="Submit" style="background-color:#cfae42;color:;border-radius:6px;padding:20px 20px;line-height:1;letter-spacing:0;border-style:none;font-size:18px;border-width:0;border-color:;width:100%">' . __( 'Subscribe', 'mailmint-pro' ) . '</button><div id="mint-google-recaptcha" style="padding-top:10px;"></div><div class="response"></div></div>
                <!-- /wp:mrmformfield/mrm-button-block -->

                <!-- wp:paragraph {"align":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"400","fontSize":15},"color":{"text":"#848484"}}} -->
                <p class="has-text-align-center has-text-color" style="color:#848484;font-size:15px;font-style:normal;font-weight:400">' . __( 'We don’t spam! Read more in our ', 'mailmint-pro' ) . '<a href="#" style="color:#848484;">' . __( 'privacy policy', 'mailmint-pro' ) . '</a></p>
                <!-- /wp:paragraph --></div>
                <!-- /wp:column --></div>
                <!-- /wp:columns -->';
			$form[5]['settings'] = '{"settings":{"confirmation_type":{"selected_confirmation_type":"same-page","same_page":{"message_to_show":"Form submitted successfully.","after_form_submission":"none"}},"form_layout":{"form_position":"popup","form_animation":"fade-in","close_button_color":"#000","close_background_color":"#fff"},"schedule":{"form_scheduling":false,"submission_start":{"date":"2023-02-13","time":"11:21:55"}},"restriction":{"max_entries":false,"max_number":0,"max_type":""},"extras":{"cookies_timer":7,"show_always":true}}}';
		}if ( isset( $form[6] ) ) {
			$form[6]['content']  = '<!-- wp:columns {"backgroundColor":"white"} -->
                <div class="wp-block-columns has-white-background-color has-background"><!-- wp:column {"verticalAlignment":"top","width":""} -->
                <div class="wp-block-column is-vertically-aligned-top"><!-- wp:image {"align":"center","id":35,"sizeSlug":"full","style":{"color":{}}} -->
                <figure class="wp-block-image aligncenter size-full"><img src="' . $image_path . '/join-now.png" alt="Join now" class="wp-image-35"/></figure>
                <!-- /wp:image -->

                <!-- wp:columns -->
                <div class="wp-block-columns"><!-- wp:column -->
                <div class="wp-block-column"><!-- wp:heading {"textAlign":"center","level":1,"style":{"typography":{"fontStyle":"normal","fontWeight":"700","fontSize":60},"color":{"text":"#333333"},"spacing":{"margin":{"top":"20px"}}}} -->
                <h1 class="has-text-align-center has-text-color" style="color:#333333;margin-top:20px;font-size:60px;font-style:normal;font-weight:700">' . __( 'Dive In', '' ) . '!</h1>
                <!-- /wp:heading -->

                <!-- wp:paragraph {"align":"center","style":{"color":{"text":"#9398a5"},"spacing":{"margin":{"bottom":"30px","top":"0px","right":"0px","left":"0px"}},"typography":{"fontSize":16,"fontStyle":"normal","fontWeight":"400"}}} -->
                <p class="has-text-align-center has-text-color" style="color:#9398a5;margin-top:0px;margin-right:0px;margin-bottom:30px;margin-left:0px;font-size:16px;font-style:normal;font-weight:400">' . __( 'Join 2 others, and start your fitness', 'mailmint-pro' ) . '<br> ' . __( 'journey with us today', 'mailmint-pro' ) . '.</p>
                <!-- /wp:paragraph -->

				<!-- wp:mrmformfield/email-field-block {"emailPlaceholder":"Enter Email*","rowSpacing":20,"inputTextColor":"#a4a4a4","inputBorderRadius":8,"inputPaddingTop":15,"inputPaddingRight":20,"inputPaddingBottom":15,"inputPaddingLeft":20,"inputBorderColor":"#e9e9e9"} -->
				<div class="mrm-form-group mrm-input-group alignment-left email" style="margin-bottom:20px ;width:100% ;max-width:px "><label for="mrm-email" style="color:#363B4E;margin-bottom:7px"></label><div class="input-wrapper"><input type="email" name="email" id="mrm-email" placeholder="' . __( 'Enter Email*', 'mailmint-pro' ) . '" required style="background-color:#ffffff;color:#a4a4a4;font-size:14px;border-radius:8px;padding-top:15px;padding-right:20px;padding-bottom:15px;padding-left:20px;border-style:solid;border-width:1px;border-color:#e9e9e9" pattern="[^@\s]+@[^@\s]+\.[^@\s]+"/></div></div>
				<!-- /wp:mrmformfield/email-field-block -->

                <!-- wp:mrmformfield/mrm-button-block {"buttonBgColor":"#e15421","buttonBorderRadius":8,"buttonText":"Join Now","buttonWidth":100} -->
                <div class="mrm-form-group submit" style="margin-bottom:12px;text-align:left"><button class="mrm-submit-button mintmrm-btn" type="submit" aria-label="Submit" style="background-color:#e15421;color:;border-radius:8px;padding:15px 20px;line-height:1;letter-spacing:0;border-style:none;font-size:15px;border-width:0;border-color:;width:100%">' . __( 'Join Now', 'mailmint-pro' ) . '</button><div id="mint-google-recaptcha" style="padding-top:10px;"></div><div class="response"></div></div>
                <!-- /wp:mrmformfield/mrm-button-block --></div>
                <!-- /wp:column --></div>
                <!-- /wp:columns -->

                <!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":16},"color":{"text":"#9398a5"}}} -->
                <p class="has-text-align-center has-text-color" style="color:#9398a5;font-size:16px">' . __( 'We don’t spam! Read more in our', 'mailmint-pro' ) . '<a href="#" style="color:#323232cc;"> ' . __( 'privacy policy', 'mailmint-pro' ) . '</a></p>
                <!-- /wp:paragraph --></div>
                <!-- /wp:column --></div>
                <!-- /wp:columns -->';
			$form[6]['settings'] = '{"settings":{"confirmation_type":{"selected_confirmation_type":"same-page","same_page":{"message_to_show":"Form submitted successfully.","after_form_submission":"none"}},"form_layout":{"form_position":"popup","form_animation":"fade-in","close_button_color":"#000","close_background_color":"#fff"},"schedule":{"form_scheduling":false,"submission_start":{"date":"2023-02-13","time":"09:28:37"}},"restriction":{"max_entries":false,"max_number":0,"max_type":""},"extras":{"cookies_timer":7,"show_always":true}}}';
		}if ( isset( $form[7] ) ) {
			$form[7]['content']  = '<!-- wp:columns {"backgroundColor":"black"} -->
                <div class="wp-block-columns has-black-background-color has-background"><!-- wp:column {"verticalAlignment":"top","width":""} -->
                <div class="wp-block-column is-vertically-aligned-top"><!-- wp:cover {"url":"' . $image_path . '/Scared-1.png","id":60,"dimRatio":0,"isDark":false,"style":{"color":{}}} -->
                <div class="wp-block-cover is-light"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim"></span><img class="wp-block-cover__image-background wp-image-60" alt="Dive In" src="' . $image_path . '/Scared-1.png" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:paragraph {"align":"center","fontSize":"large"} -->
                <p class="has-text-align-center has-large-font-size"></p>
                <!-- /wp:paragraph --></div></div>
                <!-- /wp:cover -->


                <!-- wp:columns -->
                <div class="wp-block-columns"><!-- wp:column -->
                <div class="wp-block-column"><!-- wp:heading {"textAlign":"center","level":1,"style":{"typography":{"fontSize":50,"fontStyle":"normal","fontWeight":"400"},"spacing":{"margin":{"top":"20px","bottom":"10px","right":"10px"}}},"textColor":"white"} -->
                <h1 class="wp-block-heading has-text-align-center has-white-color has-text-color" style="margin-top:20px;margin-right:10px;margin-bottom:10px;font-size:50px;font-style:normal;font-weight:400"><span style="color:#F9B333;">' . __( 'Boo!', 'mailmint-pro' ) . '</span> ' . __( 'Don\'t Be Scared', 'mailmint-pro' ) . '!</h1>
                <!-- /wp:heading -->

                <!-- wp:paragraph {"align":"center","style":{"color":{"text":"#969696"},"spacing":{"margin":{"top":"0px","right":"0px","bottom":"30px","left":"0px"}},"typography":{"fontSize":16}}} -->
                <p class="has-text-align-center has-text-color" style="color:#969696;margin-top:0px;margin-right:0px;margin-bottom:30px;margin-left:0px;font-size:16px">Claim your spooky treat! <span style="color:#F9B333;"><strong>' . __( '20%', 'mailmint-pro' ) . '</strong></span> ' . __( 'off on all Halloween products', 'mailmint-pro' ) . '!</p>
                <!-- /wp:paragraph -->

                <!-- wp:mrmformfield/email-field-block {"emailPlaceholder":"Enter your email","rowSpacing":15,"inputFontSize":16,"inputTextColor":"#7a7a7a","inputBgColor":"#0e0e0e","inputBorderRadius":6,"inputPaddingTop":15,"inputPaddingRight":20,"inputPaddingBottom":15,"inputPaddingLeft":20,"inputBorderColor":"#2a2a2a"} -->
                <div class="mrm-form-group mrm-input-group alignment-left email" style="margin-bottom:15px ;width:100% ;max-width:px "><label for="mrm-email" style="color:#363B4E;margin-bottom:7px"></label><div class="input-wrapper"><input type="email" name="email" id="mrm-email" placeholder="' . __( 'Enter your email', 'mailmint-pro' ) . '" required style="background-color:#0e0e0e;color:#7a7a7a;font-size:16px;border-radius:6px;padding-top:15px;padding-right:20px;padding-bottom:15px;padding-left:20px;border-style:solid;border-width:1px;border-color:#2a2a2a" pattern="[^@\s]+@[^@\s]+\.[^@\s]+"/></div></div>
                <!-- /wp:mrmformfield/email-field-block -->

                <!-- wp:mrmformfield/mrm-button-block {"buttonBgColor":"#186670","buttonBorderRadius":6,"buttonText":"Dare To Subscribe","buttonWidth":100,"typography":{"openTypography":true,"weight":500},"buttonFontSize":20} -->
                <div class="mrm-form-group submit" style="margin-bottom:12px;text-align:left"><button class="mrm-submit-button mintmrm-btn" type="submit" aria-label="Submit" style="background-color:#186670;color:;border-radius:6px;padding:15px 20px;line-height:1;letter-spacing:0;border-style:none;font-weight:500;font-size:20px;border-width:0;border-color:;width:100%">' . __( 'Dare To Subscribe', 'mailmint-pro' ) . '</button><div id="mint-google-recaptcha" style="padding-top:10px;"></div><div class="response"></div></div>
                <!-- /wp:mrmformfield/mrm-button-block --></div>
                <!-- /wp:column --></div>
                <!-- /wp:columns -->

                <!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":16},"color":{"text":"#969696"}}} -->
                <p class="has-text-align-center has-text-color" style="color:#969696;font-size:16px">' . __( 'We don’t spam! Read more in our', 'mailmint-pro' ) . '<a href="#" style="color:#969696;"> ' . __( 'privacy policy', 'mailmint-pro' ) . '</a></p>
                <!-- /wp:paragraph --></div>
                <!-- /wp:column --></div>
                <!-- /wp:columns -->';
			$form[7]['settings'] = '{"settings":{"confirmation_type":{"selected_confirmation_type":"same-page","same_page":{"message_to_show":"Form submitted successfully.","after_form_submission":"none"}},"form_layout":{"form_position":"popup","form_animation":"fade-in","close_button_color":"#000","close_background_color":"#f9b333"},"schedule":{"form_scheduling":false,"submission_start":{"date":"2023-02-13","time":"11:25:35"}},"restriction":{"max_entries":false,"max_number":0,"max_type":""},"extras":{"cookies_timer":7,"show_always":true}}}';
		}if ( isset( $form[13] ) ) {
			$form[13]['content']  = '<!-- wp:columns {"verticalAlignment":"center","style":{"color":{"background":"#40768b"}}} -->
                <div class="wp-block-columns are-vertically-aligned-center has-background" style="background-color:#40768b"><!-- wp:column {"verticalAlignment":"center","width":"30%"} -->
                <div class="wp-block-column is-vertically-aligned-center" style="flex-basis:30%"><!-- wp:image {"align":"center","id":123,"sizeSlug":"full","linkDestination":"none"} -->
                <figure class="wp-block-image aligncenter size-full"><img src="' . $image_path . '/hooked-book.png" alt="Free Shipping" class="wp-image-123"/></figure>
                <!-- /wp:image --></div>
                <!-- /wp:column -->
                
                <!-- wp:column {"verticalAlignment":"center","width":"70%"} -->
                <div class="wp-block-column is-vertically-aligned-center" style="flex-basis:70%"><!-- wp:heading {"style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"typography":{"fontSize":24}},"textColor":"white"} -->
                <h2 class="wp-block-heading has-white-color has-text-color has-link-color" style="font-size:24px">Grab your free eBook to discover proven real-life storytelling methods.</h2>
                <!-- /wp:heading -->
                
                <!-- wp:paragraph {"style":{"color":{"text":"#ffffffb3"},"spacing":{"margin":{"bottom":"10px"}}}} -->
                <p class="has-text-color" style="color:#ffffffb3;margin-bottom:10px">' . __( 'Learn how top influencers gained recognition and created a global impact', 'mailmint-pro' ) . '.</p>
                <!-- /wp:paragraph -->
                
                <!-- wp:columns {"verticalAlignment":null} -->
                <div class="wp-block-columns"><!-- wp:column {"verticalAlignment":"center","width":"33%"} -->
                <div class="wp-block-column is-vertically-aligned-center" style="flex-basis:33%"><!-- wp:mrmformfield/first-name-block {"rowSpacing":0,"labelSpacing":0,"inputPaddingTop":15,"inputPaddingBottom":15,"align":"left"} -->
                <div class="mrm-form-group mrm-input-group alignment-left first-name" style="margin-bottom:0px;width:% ;max-width:px "><label for="mrm-first-name" style="color:#363B4E;margin-bottom:0px"></label><div class="input-wrapper"><input type="text" name="first_name" id="mrm-first-name" placeholder="' . __( 'First Name', 'mailmint-pro' ) . '" style="background-color:#ffffff;color:#7A8B9A;font-size:14px;border-radius:5px;padding-top:15px;padding-right:14px;padding-bottom:15px;padding-left:14px;border-style:solid;border-width:1px;border-color:#DFE1E8"/></div></div>
                <!-- /wp:mrmformfield/first-name-block --></div>
                <!-- /wp:column -->
                
                <!-- wp:column {"verticalAlignment":"center","width":"33%"} -->
                <div class="wp-block-column is-vertically-aligned-center" style="flex-basis:33%"><!-- wp:mrmformfield/email-field-block {"rowSpacing":0,"labelSpacing":0,"inputPaddingTop":15,"inputPaddingBottom":15,"align":"left"} -->
                <div class="mrm-form-group mrm-input-group alignment-left email" style="margin-bottom:0px ;width:100% ;max-width:px "><label for="mrm-email" style="color:#363B4E;margin-bottom:0px"></label><div class="input-wrapper"><input type="email" name="email" id="mrm-email" placeholder="' . __( 'Email', 'mailmint-pro' ) . '" required style="background-color:#ffffff;color:#7A8B9A;font-size:14px;border-radius:5px;padding-top:15px;padding-right:14px;padding-bottom:15px;padding-left:14px;border-style:solid;border-width:1px;border-color:#DFE1E8" pattern="[^@\s]+@[^@\s]+\.[^@\s]+"/></div></div>
                <!-- /wp:mrmformfield/email-field-block --></div>
                <!-- /wp:column -->
                
                <!-- wp:column {"width":"33%"} -->
                <div class="wp-block-column" style="flex-basis:33%"><!-- wp:mrmformfield/mrm-button-block {"rowSpacing":0,"buttonTextColor":"#2d2c2b","buttonBgColor":"#ebba67","buttonText":"Get The Book Now","paddingTopBottom":17} -->
                <div class="mrm-form-group submit" style="margin-bottom:0px;text-align:left"><button class="mrm-submit-button mintmrm-btn" type="submit" aria-label="Submit" style="background-color:#ebba67;color:#2d2c2b;border-radius:5px;padding:17px 20px;line-height:1;letter-spacing:0;border-style:none;font-size:15px;border-width:0;border-color:;width:%">' . __( 'Get The Book Now', 'mailmint-pro' ) . '</button><div id="mint-google-recaptcha" style="padding-top:10px"></div><div class="response"></div></div>
                <!-- /wp:mrmformfield/mrm-button-block --></div>
                <!-- /wp:column --></div>
                <!-- /wp:columns --></div>
                <!-- /wp:column --></div>
                <!-- /wp:columns -->';
			$form[13]['settings'] = '{"settings":{"confirmation_type":{"selected_confirmation_type":"same-page","same_page":{"message_to_show":"Form submitted successfully.","after_form_submission":"none"}},"form_layout":{"form_position":"fixed-on-bottom","form_animation":"fade-in","close_button_color":"#333333","close_background_color":"#40768b"},"schedule":{"form_scheduling":false,"submission_start":{"date":"2023-08-31","time":"07:10:01"}},"restriction":{"max_entries":false,"max_number":0,"max_type":""},"extras":{"cookies_timer":7,"show_always":true,"allow_automation_multiple":true},"button_render":{"enable":false,"button_text":"Click Here"},"admin_notification":{"enable":false,"admin_email":"dev-email@flywheel.local"}}}';
		}if ( isset( $form[14] ) ) {
			$form[14]['content']  = '<!-- wp:group {"layout":{"type":"constrained","wideSize":"436px"}} -->
                <div class="wp-block-group"><!-- wp:columns -->
                <div class="wp-block-columns"><!-- wp:column {"width":"100%"} -->
                <div class="wp-block-column" style="flex-basis:100%"><!-- wp:group {"layout":{"type":"constrained"}} -->
                <div class="wp-block-group"><!-- wp:group {"layout":{"type":"constrained"}} -->
                <div class="wp-block-group"><!-- wp:columns {"style":{"color":{"background":"#7a5045"}}} -->
                <div class="wp-block-columns has-background" style="background-color:#7a5045"><!-- wp:column {"verticalAlignment":"top"} -->
                <div class="wp-block-column is-vertically-aligned-top"><!-- wp:image {"align":"center","id":129,"sizeSlug":"full","linkDestination":"none"} -->
                <figure class="wp-block-image aligncenter size-full"><img src="' . $image_path . '/bunch-image.png" alt="eBook Lead Magnet" class="wp-image-129"/></figure>
                <!-- /wp:image -->

                <!-- wp:heading {"textAlign":"center","style":{"typography":{"fontWeight":800,"fontSize":28},"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white"} -->
                <h2 class="wp-block-heading has-text-align-center has-white-color has-text-color has-link-color" style="font-size:28px;font-weight:800">Join The Bunch</h2>
                <!-- /wp:heading -->

                <!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":16},"color":{"text":"#e5cbc4"}}} -->
                <p class="has-text-align-center has-text-color" style="color:#e5cbc4;font-size:16px">' . __( 'Be a part of meaningful connections, exclusive updates, and engaging discussions with our community', 'mailmint-pro' ) . '</p>
                <!-- /wp:paragraph -->

                <!-- wp:mrmformfield/email-field-block {"emailLabel":"Email","labelColor":"#ffffff","inputBorderRadius":8,"inputPaddingTop":16,"inputPaddingBottom":16,"inputBorderColor":"#e2e2e2"} -->
                <div class="mrm-form-group mrm-input-group alignment-left email" style="margin-bottom:12px ;width:100% ;max-width:px "><label for="mrm-email" style="color:#ffffff;margin-bottom:7px">' . __( 'Email', 'mailmint-pro' ) . '<span class="required-mark">*</span></label><div class="input-wrapper"><input type="email" name="email" id="mrm-email" placeholder="' . __( 'Email', 'mailmint-pro' ) . '" required style="background-color:#ffffff;color:#7A8B9A;font-size:14px;border-radius:8px;padding-top:16px;padding-right:14px;padding-bottom:16px;padding-left:14px;border-style:solid;border-width:1px;border-color:#e2e2e2" pattern="[^@\s]+@[^@\s]+\.[^@\s]+"/></div></div>
                <!-- /wp:mrmformfield/email-field-block -->

                <!-- wp:mrmformfield/mrm-button-block {"buttonTextColor":"#ffffff","buttonBgColor":"#e86138","buttonBorderRadius":8,"buttonText":"Join Now","buttonAlign":"center","buttonWidth":100,"buttonFontSize":20,"paddingTopBottom":16} -->
                <div class="mrm-form-group submit" style="margin-bottom:12px;text-align:center"><button class="mrm-submit-button mintmrm-btn" aria-label="Submit" type="submit" style="background-color:#e86138;color:#ffffff;border-radius:8px;padding:16px 20px;line-height:1;letter-spacing:0;border-style:none;font-size:20px;border-width:0;border-color:;width:100%">' . __( 'Join Now', 'mailmint-pro' ) . '</button><div id="mint-google-recaptcha" style="padding-top:10px;"></div><div class="response"></div></div>
                <!-- /wp:mrmformfield/mrm-button-block --></div>
                <!-- /wp:column --></div>
                <!-- /wp:columns --></div>
                <!-- /wp:group --></div>
                <!-- /wp:group --></div>
                <!-- /wp:column --></div>
                <!-- /wp:columns --></div>
                <!-- /wp:group -->';
			$form[14]['settings'] = '{"settings":{"confirmation_type":{"selected_confirmation_type":"same-page","same_page":{"message_to_show":"Form submitted successfully.","after_form_submission":"none"}},"form_layout":{"form_position":"flyins","form_animation":"slide-in-up","close_button_color":"#a7a8b3","close_background_color":"#ffffff"},"schedule":{"form_scheduling":false,"submission_start":{"date":"2023-08-28","time":"05:59:59"}},"restriction":{"max_entries":false,"max_number":0,"max_type":""},"extras":{"cookies_timer":7,"show_always":true,"allow_automation_multiple":true},"button_render":{"enable":false,"button_text":"Click Here"},"admin_notification":{"enable":false,"admin_email":"dev-email@flywheel.local"}}}';
		}if ( isset( $form[15] ) ) {
			$form[15]['content']  = '<!-- wp:columns {"style":{"color":{"background":"#020b97"},"border":{"radius":"16px"}}} -->
                <div class="wp-block-columns has-background" style="border-radius:16px;background-color:#020b97"><!-- wp:column {"verticalAlignment":"top","width":""} -->
                <div class="wp-block-column is-vertically-aligned-top"><!-- wp:columns -->
                <div class="wp-block-columns"><!-- wp:column -->
                <div class="wp-block-column"><!-- wp:heading {"textAlign":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"typography":{"fontSize":30,"fontWeight":700}},"textColor":"white"} -->
                <h2 class="wp-block-heading has-text-align-center has-white-color has-text-color has-link-color" style="font-size:30px;font-weight:700">Hey There!</h2>
                <!-- /wp:heading -->

                <!-- wp:paragraph {"align":"center","style":{"color":{"text":"#9398a5"},"elements":{"link":{"color":{"text":"#9398a5"}}},"typography":{"fontSize":14,"lineHeight":1.5}}} -->
                <p class="has-text-align-center has-text-color has-link-color" style="color:#9398a5;font-size:14px;line-height:1.5">Receive In-depth Articles, Event Highlights, <br> and Exclusive Offers We Share Frequently</p>
                <!-- /wp:paragraph -->

                <!-- wp:mrmformfield/first-name-block {"inputTextColor":"#000000","inputPaddingTop":15,"inputPaddingRight":20,"inputPaddingBottom":12,"inputPaddingLeft":20} -->
                <div class="mrm-form-group mrm-input-group alignment-left first-name" style="margin-bottom:12px;width:% ;max-width:px "><label for="mrm-first-name" style="color:#363B4E;margin-bottom:7px"></label><div class="input-wrapper"><input type="text" name="first_name" id="mrm-first-name" placeholder="' . __( 'First Name', 'mailmint-pro' ) . '" style="background-color:#ffffff;color:#000000;font-size:14px;border-radius:5px;padding-top:15px;padding-right:20px;padding-bottom:12px;padding-left:20px;border-style:solid;border-width:1px;border-color:#DFE1E8"/></div></div>
                <!-- /wp:mrmformfield/first-name-block -->

                <!-- wp:mrmformfield/last-name-block {"inputTextColor":"#000000","inputPaddingTop":15,"inputPaddingRight":20,"inputPaddingBottom":15,"inputPaddingLeft":20} -->
                <div class="mrm-form-group mrm-input-group alignment-left last-name" style="margin-bottom:12px;width:% ;max-width:px "><label for="wpfnl-last-name" style="color:#363B4E;margin-bottom:7px"></label><div class="input-wrapper"><input type="text" name="last_name" id="wpfnl-last-name" placeholder="' . __( 'Last Name', 'mailmint-pro' ) . '" style="background-color:#ffffff;color:#000000;font-size:14px;border-radius:5px;padding-top:15px;padding-right:20px;padding-bottom:15px;padding-left:20px;border-style:solid;border-width:1px;border-color:#DFE1E8"/></div></div>
                <!-- /wp:mrmformfield/last-name-block -->

                <!-- wp:mrmformfield/email-field-block {"rowSpacing":10,"inputTextColor":"#000000","inputBorderRadius":8,"inputPaddingTop":15,"inputPaddingRight":20,"inputPaddingBottom":15,"inputPaddingLeft":20,"inputBorderColor":"#e9e9e9"} -->
                <div class="mrm-form-group mrm-input-group alignment-left email" style="margin-bottom:10px ;width:100% ;max-width:px "><label for="mrm-email" style="color:#363B4E;margin-bottom:7px"></label><div class="input-wrapper"><input type="email" name="email" id="mrm-email" placeholder="' . __( 'Email', 'mailmint-pro' ) . '" required style="background-color:#ffffff;color:#000000;font-size:14px;border-radius:8px;padding-top:15px;padding-right:20px;padding-bottom:15px;padding-left:20px;border-style:solid;border-width:1px;border-color:#e9e9e9" pattern="[^@\s]+@[^@\s]+\.[^@\s]+"/></div></div>
                <!-- /wp:mrmformfield/email-field-block -->

                <!-- wp:mrmformfield/mrm-button-block {"buttonTextColor":"#020b97","buttonBgColor":"#fadc4a","buttonBorderRadius":8,"buttonText":"Stay In Touch","buttonWidth":100} -->
                <div class="mrm-form-group submit" style="margin-bottom:12px;text-align:left"><button class="mrm-submit-button mintmrm-btn" type="submit" aria-label="Submit" style="background-color:#fadc4a;color:#020b97;border-radius:8px;padding:15px 20px;line-height:1;letter-spacing:0;border-style:none;font-size:15px;border-width:0;border-color:;width:100%">' . __( 'Stay In Touch', 'mailmint-pro' ) . '</button><div id="mint-google-recaptcha" style="padding-top:10px;"></div><div class="response"></div></div>
                <!-- /wp:mrmformfield/mrm-button-block --></div>
                <!-- /wp:column --></div>
                <!-- /wp:columns -->

                <!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":16}},"textColor":"cyan-bluish-gray"} -->
                <p class="has-text-align-center has-cyan-bluish-gray-color has-text-color" style="font-size:16px">' . __( 'We don’t spam! Read more in our', 'mailmint-pro' ) . '<a style="color:#323232cc;" href="#"> </a>' . __( '', 'mailmint-pro' ) . 'privacy policy</p>
                <!-- /wp:paragraph --></div>
                <!-- /wp:column --></div>
                <!-- /wp:columns -->';
			$form[15]['settings'] = '{"settings":{"confirmation_type":{"selected_confirmation_type":"same-page","same_page":{"message_to_show":"Form submitted successfully.","after_form_submission":"none"}},"form_layout":{"form_position":"popup","form_animation":"fade-in","close_button_color":"#000","close_background_color":"#fff"},"schedule":{"form_scheduling":false,"submission_start":{"date":"2023-08-31","time":"08:53:27"}},"restriction":{"max_entries":false,"max_number":0,"max_type":""},"extras":{"cookies_timer":7,"show_always":true,"allow_automation_multiple":true},"button_render":{"enable":false,"button_text":"Click Here"},"admin_notification":{"enable":false,"admin_email":"dev-email@flywheel.local"}}}';
		}if ( isset( $form[16] ) ) {
			$form[16]['content']  = '<!-- wp:columns {"verticalAlignment":"center","backgroundColor":"white"} -->
                <div class="wp-block-columns are-vertically-aligned-center has-white-background-color has-background"><!-- wp:column {"verticalAlignment":"center"} -->
                <div class="wp-block-column is-vertically-aligned-center"><!-- wp:image {"id":120,"width":433,"height":581,"sizeSlug":"full","linkDestination":"none"} -->
                <figure class="wp-block-image size-full is-resized"><img src="' . $image_path . '/deal-image.png" alt="Newsletter Subscription" class="wp-image-120" style="width:433px;height:581px" width="433" height="581"/></figure>
                <!-- /wp:image --></div>
                <!-- /wp:column -->

                <!-- wp:column {"verticalAlignment":"center"} -->
                <div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"textAlign":"center","level":1,"style":{"typography":{"fontSize":48,"fontStyle":"normal","fontWeight":"600"},"spacing":{"margin":{"top":"0px","bottom":"10px"}},"color":{"text":"#2d3149"}}} -->
                <h1 class="wp-block-heading has-text-align-center has-text-color" style="color:#2d3149;margin-top:0px;margin-bottom:10px;font-size:48px;font-style:normal;font-weight:600"><strong>' . __( 'Catch the Deal of the Week', 'mailmint-pro' ) . '!</strong></h1>
                <!-- /wp:heading -->

                <!-- wp:paragraph {"align":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"400","fontSize":16},"color":{"text":"#848484"},"spacing":{"margin":{"bottom":"25px","right":"30px","left":"30px"}}}} -->
                <p class="has-text-align-center has-text-color" style="color:#848484;margin-right:30px;margin-bottom:25px;margin-left:30px;font-size:16px;font-style:normal;font-weight:400">' . __( 'Subscribe today to instantly receive a 20% off on your next orders. Hurry, this offer won&apos;t last long', 'mailmint-pro' ) . '!</p>
                <!-- /wp:paragraph -->

                <!-- wp:mrmformfield/first-name-block {"firstNamePlaceholder":"Your Name","rowSpacing":20,"labelTypography":{},"inputTypography":{},"inputTextColor":"#000000","inputBorderRadius":6,"inputPaddingTop":15,"inputPaddingRight":18,"inputPaddingBottom":15,"inputPaddingLeft":18,"inputBorderColor":"#e9e9e9"} -->
                <div class="mrm-form-group mrm-input-group alignment-left first-name" style="margin-bottom:20px;width:% ;max-width:px "><label for="mrm-first-name" style="color:#363B4E;margin-bottom:7px"></label><div class="input-wrapper"><input type="text" name="first_name" id="mrm-first-name" placeholder="' . __( 'Your Name', 'mailmint-pro' ) . '" style="background-color:#ffffff;color:#000000;font-size:14px;border-radius:6px;padding-top:15px;padding-right:18px;padding-bottom:15px;padding-left:18px;border-style:solid;border-width:1px;border-color:#e9e9e9"/></div></div>
                <!-- /wp:mrmformfield/first-name-block -->

                <!-- wp:mrmformfield/email-field-block {"emailPlaceholder":"Your Email","rowSpacing":14,"labelTypography":{"openTypography":false},"inputTypography":{"openTypography":false},"inputTextColor":"#000000","inputBorderRadius":6,"inputPaddingTop":15,"inputPaddingRight":18,"inputPaddingBottom":15,"inputPaddingLeft":18,"inputBorderColor":"#e9e9e9"} -->
                <div class="mrm-form-group mrm-input-group alignment-left email" style="margin-bottom:14px ;width:100% ;max-width:px "><label for="mrm-email" style="color:#363B4E;margin-bottom:7px"></label><div class="input-wrapper"><input type="email" name="email" id="mrm-email" placeholder="' . __( 'Your Email', 'mailmint-pro' ) . '" required style="background-color:#ffffff;color:#000000;font-size:14px;border-radius:6px;padding-top:15px;padding-right:18px;padding-bottom:15px;padding-left:18px;border-style:solid;border-width:1px;border-color:#e9e9e9" pattern="[^@\s]+@[^@\s]+\.[^@\s]+"/></div></div>
                <!-- /wp:mrmformfield/email-field-block -->

                <!-- wp:mrmformfield/mrm-button-block {"buttonBgColor":"#e780a0","buttonBorderRadius":6,"buttonText":"Count Me In","buttonWidth":100,"typography":{"openTypography":false},"buttonFontSize":18,"paddingTopBottom":20} -->
                <div class="mrm-form-group submit" style="margin-bottom:12px;text-align:left"><button class="mrm-submit-button mintmrm-btn" type="submit" aria-label="Submit" style="background-color:#e780a0;color:;border-radius:6px;padding:20px 20px;line-height:1;letter-spacing:0;border-style:none;font-size:18px;border-width:0;border-color:;width:100%">' . __( 'Count Me In', 'mailmint-pro' ) . '</button><div id="mint-google-recaptcha" style="padding-top:10px;"></div><div class="response"></div></div>
                <!-- /wp:mrmformfield/mrm-button-block -->

                <!-- wp:paragraph {"align":"center","style":{"typography":{"fontStyle":"normal","fontWeight":"400","fontSize":15},"color":{"text":"#9398a5"}}} -->
                <p class="has-text-align-center has-text-color" style="color:#9398a5;font-size:15px;font-style:normal;font-weight:400">' . __( 'We don’t spam! Read more in our', 'mailmint-pro' ) . ' <a href="#" style="color:#848484;">' . __( 'privacy policy', 'mailmint-pro' ) . '</a></p>
                <!-- /wp:paragraph --></div>
                <!-- /wp:column --></div>
                <!-- /wp:columns -->';
			$form[16]['settings'] = '{"settings":{"confirmation_type":{"selected_confirmation_type":"same-page","same_page":{"message_to_show":"Form submitted successfully.","after_form_submission":"none"}},"form_layout":{"form_position":"popup","form_animation":"fade-in","close_button_color":"#000","close_background_color":"#fff"},"schedule":{"form_scheduling":false,"submission_start":{"date":"2023-08-28","time":"09:48:46"}},"restriction":{"max_entries":false,"max_number":0,"max_type":""},"extras":{"cookies_timer":7,"show_always":true,"allow_automation_multiple":true},"button_render":{"enable":false,"button_text":"Click Here"},"admin_notification":{"enable":false,"admin_email":"dev-email@flywheel.local"}}}';
		}if ( isset( $form[19] ) ) {
			$form[19]['content']  = '<!-- wp:columns {"style":{"color":{"background":"#5d7e75"}}} -->
                <div class="wp-block-columns has-background" style="background-color:#5d7e75"><!-- wp:column -->
                <div class="wp-block-column"><!-- wp:heading {"style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"typography":{"fontSize":24}},"textColor":"white"} -->
                <h2 class="wp-block-heading has-white-color has-text-color has-link-color" style="font-size:24px">Are you seeking personalized assistance in identifying the right solution?</h2>
                <!-- /wp:heading -->
                
                <!-- wp:heading {"level":1,"style":{"color":{"text":"#ffe247"}}} -->
                <h1 class="wp-block-heading has-text-color" style="color:#ffe247">' . __( 'Let Us Help Out', 'mailmint-pro' ) . '</h1>
                <!-- /wp:heading -->
                
                <!-- wp:paragraph {"textColor":"white"} -->
                <p class="has-white-color has-text-color">' . __( 'Contact our expert team', 'mailmint-pro' ) . '!</p>
                <!-- /wp:paragraph --></div>
                <!-- /wp:column -->
                
                <!-- wp:column -->
                <div class="wp-block-column"><!-- wp:image {"id":167,"sizeSlug":"full","linkDestination":"none"} -->
                <figure class="wp-block-image size-full"><img src="' . $image_path . '/seeking-image.jpg" alt="Tech Newsletter" class="wp-image-167"/></figure>
                <!-- /wp:image --></div>
                <!-- /wp:column --></div>
                <!-- /wp:columns -->
                
                <!-- wp:columns {"verticalAlignment":null,"style":{"color":{"background":"#6a8c83"}}} -->
                <div class="wp-block-columns has-background" style="background-color:#6a8c83"><!-- wp:column {"verticalAlignment":"center"} -->
                <div class="wp-block-column is-vertically-aligned-center"><!-- wp:mrmformfield/first-name-block {"labelSpacing":0,"inputTextColor":"#ffffff","inputBgColor":"#6a8c83","inputBorderColor":"#86a49c"} -->
                <div class="mrm-form-group mrm-input-group alignment-left first-name" style="margin-bottom:12px;width:% ;max-width:px "><label for="mrm-first-name" style="color:#363B4E;margin-bottom:0px"></label><div class="input-wrapper"><input type="text" name="first_name" id="mrm-first-name" placeholder="' . __( 'First Name', 'mailmint-pro' ) . '" style="background-color:#6a8c83;color:#ffffff;font-size:14px;border-radius:5px;padding-top:11px;padding-right:14px;padding-bottom:11px;padding-left:14px;border-style:solid;border-width:1px;border-color:#86a49c"/></div></div>
                <!-- /wp:mrmformfield/first-name-block --></div>
                <!-- /wp:column -->
                
                <!-- wp:column {"verticalAlignment":"center"} -->
                <div class="wp-block-column is-vertically-aligned-center"><!-- wp:mrmformfield/email-field-block {"labelSpacing":0,"inputTextColor":"#ffffff","inputBgColor":"#6a8c83","inputBorderColor":"#86a49c"} -->
                <div class="mrm-form-group mrm-input-group alignment-left email" style="margin-bottom:12px ;width:100% ;max-width:px "><label for="mrm-email" style="color:#363B4E;margin-bottom:0px"></label><div class="input-wrapper"><input type="email" name="email" id="mrm-email" placeholder="' . __( 'Email', 'mailmint-pro' ) . '" required style="background-color:#6a8c83;color:#ffffff;font-size:14px;border-radius:5px;padding-top:11px;padding-right:14px;padding-bottom:11px;padding-left:14px;border-style:solid;border-width:1px;border-color:#86a49c" pattern="[^@\s]+@[^@\s]+\.[^@\s]+"/></div></div>
                <!-- /wp:mrmformfield/email-field-block --></div>
                <!-- /wp:column -->
                
                <!-- wp:column -->
                <div class="wp-block-column"><!-- wp:mrmformfield/mrm-button-block {"buttonTextColor":"#517269","buttonBgColor":"#ffe247","buttonText":"Subscribe","buttonWidth":100} -->
                <div class="mrm-form-group submit" style="margin-bottom:12px;text-align:left"><button class="mrm-submit-button mintmrm-btn" type="submit" aria-label="Submit" style="background-color:#ffe247;color:#517269;border-radius:5px;padding:15px 20px;line-height:1;letter-spacing:0;border-style:none;font-size:15px;border-width:0;border-color:;width:100%">' . __( 'Subscribe', 'mailmint-pro' ) . '</button><div id="mint-google-recaptcha" style="padding-top:10px"></div><div class="response"></div></div>
                <!-- /wp:mrmformfield/mrm-button-block --></div>
                <!-- /wp:column --></div>
                <!-- /wp:columns -->';
			$form[19]['settings'] = '{"settings":{"confirmation_type":{"selected_confirmation_type":"same-page","same_page":{"message_to_show":"Form submitted successfully.","after_form_submission":"none"}},"form_layout":{"form_position":"fixed-on-bottom","form_animation":"slide-in-up","close_button_color":"#ffffff","close_background_color":"#5d7e75"},"schedule":{"form_scheduling":false,"submission_start":{"date":"2023-08-31","time":"06:12:07"}},"restriction":{"max_entries":false,"max_number":0,"max_type":""},"extras":{"cookies_timer":7,"show_always":true,"allow_automation_multiple":true},"button_render":{"enable":false,"button_text":"Click Here"},"admin_notification":{"enable":false,"admin_email":"dev-email@flywheel.local"}}}';
		}if ( isset( $form[24] ) ) {
			$form[24]['content']  = '<!-- wp:columns {"style":{"color":{"background":"#2d2d4f"},"border":{"radius":"16px"}}} -->
                <div class="wp-block-columns has-background" style="border-radius:16px;background-color:#2d2d4f"><!-- wp:column {"verticalAlignment":"top","width":""} -->
                <div class="wp-block-column is-vertically-aligned-top"><!-- wp:columns -->
                <div class="wp-block-columns"><!-- wp:column -->
                <div class="wp-block-column"><!-- wp:heading {"textAlign":"center","style":{"color":{"text":"#ccd8ff"},"elements":{"link":{"color":{"text":"#ccd8ff"}}},"typography":{"fontWeight":700,"fontSize":40}}} -->
                <h2 class="wp-block-heading has-text-align-center has-text-color has-link-color" style="color:#ccd8ff;font-size:40px;font-weight:700">Unlock Your <br> Business Potential</h2>
                <!-- /wp:heading -->

                <!-- wp:paragraph {"align":"center","style":{"color":{"text":"#f7eddf"},"elements":{"link":{"color":{"text":"#f7eddf"}}},"typography":{"fontSize":14}}} -->
                <p class="has-text-align-center has-text-color has-link-color" style="color:#f7eddf;font-size:14px">Subscribe to our business growth newsletter for strategic advice, success stories, and networking opportunities.</p>
                <!-- /wp:paragraph -->

                <!-- wp:image {"id":1450,"sizeSlug":"large","linkDestination":"none","align":"center"} -->
                <figure class="wp-block-image aligncenter size-large"><img src="' . $image_path . '/newsletter-subscription-5-hero.jpg" alt="Affiliate Registration" class="wp-image-1450"/></figure>
                <!-- /wp:image -->

                <!-- wp:mrmformfield/first-name-block {"firstNamePlaceholder":"Your Name","rowSpacing":8,"inputTextColor":"#000000","inputPaddingTop":15,"inputPaddingRight":20,"inputPaddingBottom":12,"inputPaddingLeft":20} -->
                <div class="mrm-form-group mrm-input-group alignment-left first-name" style="margin-bottom:8px;width:% ;max-width:px "><label for="mrm-first-name" style="color:#363B4E;margin-bottom:7px"></label><div class="input-wrapper"><input type="text" name="first_name" id="mrm-first-name" placeholder="Your Name" style="background-color:#ffffff;color:#000000;font-size:14px;border-radius:5px;padding-top:15px;padding-right:20px;padding-bottom:12px;padding-left:20px;border-style:solid;border-width:1px;border-color:#DFE1E8"/></div></div>
                <!-- /wp:mrmformfield/first-name-block -->

                <!-- wp:mrmformfield/email-field-block {"emailPlaceholder":"Your Email","rowSpacing":8,"inputTextColor":"#000000","inputBorderRadius":8,"inputPaddingTop":15,"inputPaddingRight":20,"inputPaddingBottom":15,"inputPaddingLeft":20,"inputBorderColor":"#e9e9e9"} -->
                <div class="mrm-form-group mrm-input-group alignment-left email" style="margin-bottom:8px ;width:100% ;max-width:px "><label for="mrm-email" style="color:#363B4E;margin-bottom:7px"></label><div class="input-wrapper"><input type="email" name="email" id="mrm-email" placeholder="Your Email" required style="background-color:#ffffff;color:#000000;font-size:14px;border-radius:8px;padding-top:15px;padding-right:20px;padding-bottom:15px;padding-left:20px;border-style:solid;border-width:1px;border-color:#e9e9e9" pattern="[^@\s]+@[^@\s]+\.[^@\s]+"/></div></div>
                <!-- /wp:mrmformfield/email-field-block -->

                <!-- wp:mrmformfield/mrm-button-block {"rowSpacing":8,"buttonTextColor":"#FFFFFF","buttonBgColor":"#f77f2e","buttonBorderRadius":8,"buttonText":"Register","buttonWidth":100} -->
                <div class="mrm-form-group submit" style="margin-bottom:8px;text-align:left"><button class="mrm-submit-button mintmrm-btn" type="submit" aria-label="Submit" style="background-color:#f77f2e;color:#FFFFFF;border-radius:8px;padding:15px 20px;line-height:1;letter-spacing:0;border-style:none;font-size:15px;border-width:0;border-color:;width:100%">Register</button><div id="mint-google-recaptcha" style="padding-top:10px"></div><div class="response"></div></div>
                <!-- /wp:mrmformfield/mrm-button-block --></div>
                <!-- /wp:column --></div>
                <!-- /wp:columns --></div>
                <!-- /wp:column --></div>
                <!-- /wp:columns -->';
		}
		return $form;
	}
}
