<?php
/**
 * Automation WPFunnels connector class for MRM Autoamtion connector
 *
 * Class ConnectorWpfunnels
 *
 * @package MintMail\App\Internal\Automation\Connector
 */

namespace MintMail\App\Internal\Automation\Connector;

use MintMail\App\Internal\Automation\Automation_Connector;
use MintMail\App\Internal\Automation\Connector\trigger\WpfunnelsTriggers;
use Mint\Mrm\Internal\Traits\Singleton;
use MintMailPro\Mint_Pro_Helper;

/**
 * WPFunnels Connector
 *
 * Class ConnectorWpfunnels
 *
 * @package MintMail\App\Internal\Automation\Connector
 */
class ConnectorWpfunnels extends Automation_Connector {

	use Singleton;

	/**
	 * MM triggers
	 *
	 * @var $triggers.
	 */
	public $triggers;

	/**
	 * Initialization
	 */
	public function __construct() {
		if ( $this->maybe_connected() ) {
			if ( Mint_Pro_Helper::is_wpf_free_pro_active() ) {
				if ( version_compare( WPFNL_VERSION, '2.7.0', '>=' ) && version_compare( WPFNL_PRO_VERSION, '1.8.0', '>=' ) ) {
					WpfunnelsTriggers::get_instance()->init();
				}
			}
		}
	}

	/**
	 * Get connector name
	 *
	 * @return String
	 * @since  1.0.0
	 */
	public function get_name() {
		return __( 'WPFunnels', 'mailmint-pro' );
	}


	/**
	 * Check the connector is connected or not
	 *
	 * @return Bool
	 * @since  1.0.0
	 */
	public function maybe_connected() {
		return true;
	}


	/**
	 * Get all triggers
	 */
	public function get_triggers() {
		$this->triggers = $this->get_supported_wpf_triggers();
		return $this->triggers;
	}


	/**
	 * All supported triggers
	 */
	public function get_supported_wpf_triggers() {
		$wpf_triggers = array(
			array(
				'key'   => 'wpf_cta_trigger',
				'label' => 'Funnel CTA trigger',
			),
			array(
				'key'   => 'wpf_order_placed',
				'label' => 'Funnel order place',
			),
			array(
				'key'   => 'wpf_orderbump_accept',
				'label' => 'Funnel order bump accept',
			),
			array(
				'key'   => 'wpf_upsell_accepted',
				'label' => 'WPF upsell accept',
			),
			array(
				'key'   => 'wpf_downsell_accepted',
				'label' => 'WPF downsell accept',
			),
			array(
				'key'   => 'wpf_optin_submit',
				'label' => 'Funnel opt-in submit',
			),
		);
		return $wpf_triggers;
	}

}
