<?php
/**
 * Automation Woocommerce connector class for MRM Autoamtion connector
 *
 * Class ConnectorWoocommerce
 *
 * @package MintMail\App\Internal\Automation\Connector
 */

namespace MintMail\App\Internal\Automation\Connector;

use MintMail\App\Internal\Automation\Automation_Connector;
use MintMail\App\Internal\Automation\Connector\trigger\WoocommerceTriggers;
use Mint\Mrm\Internal\Traits\Singleton;
use MintMail\App\Internal\Automation\Connector\trigger\CustomerWinBackTriggers;
use MintMail\App\Internal\Automation\Connector\trigger\MembershipTriggers;
use MintMail\App\Internal\Automation\Connector\trigger\SubscriptionTriggers;
use MintMail\App\Internal\Automation\Connector\trigger\WishlistTriggers;

/**
 * Woocommerce Connector
 *
 * Class ConnectorWoocommerce
 *
 * @package MintMail\App\Internal\Automation\Connector
 */
class ConnectorWoocommerce extends Automation_Connector {

	use Singleton;

	/**
	 * MM triggers
	 *
	 * @var $triggers.
	 */
	public $triggers;

	/**
	 * Initialization
	 */
	public function __construct() {
		if ( $this->maybe_connected() ) {
			WoocommerceTriggers::get_instance()->init();
			CustomerWinBackTriggers::get_instance()->init();
			SubscriptionTriggers::get_instance()->init();
			MembershipTriggers::get_instance()->init();
			WishlistTriggers::get_instance()->init();
		}
	}

	/**
	 * Get connector name
	 *
	 * @return String
	 * @since  1.0.0
	 */
	public function get_name() {
		return __( 'Woocommerce', 'mailmint-pro' );
	}


	/**
	 * Check the connector is connected or not
	 *
	 * @return Bool
	 * @since  1.0.0
	 */
	public function maybe_connected() {
		return true;
	}


	/**
	 * Get all triggers
	 */
	public function get_triggers() {
		$this->triggers = $this->get_supported_wc_triggers();
		return $this->triggers;
	}


	/**
	 * All supported triggers
	 */
	public function get_supported_wc_triggers() {
		$wc_triggers = array(
			array(
				'key'   => 'order_created',
				'label' => 'Order created',
			),
			array(
				'key'   => 'wc_order_status_changed',
				'label' => 'Order status changed',
			),
			array(
				'key'   => 'wc_order_failed',
				'label' => 'Order failed',
			),
			array(
				'key'   => 'wc_order_note_added',
				'label' => 'Order note added',
			),
			array(
				'key'   => 'wc_order_refunded',
				'label' => 'Order refunded',
			),

		);
		return $wc_triggers;
	}

}
