<?php
/**
 * WPForms triggers
 *
 * @package MintMail\App\Internal\Automation\Connector\trigger;
 * @since 1.17
 */

namespace MintMail\App\Internal\Automation\Connector\Trigger;

use Mint\MRM\Admin\API\Controllers\MessageController;
use Mint\MRM\DataBase\Models\ContactModel;
use Mint\MRM\DataStores\ContactData;
use MintMail\App\Internal\Automation\HelperFunctions;
use Mint\Mrm\Internal\Traits\Singleton;
/**
 * Edd triggers
 *
 * @package MintMail\App\Internal\Automation\Connector
 */
class WPFormsFormTriggers {

	use Singleton;

	/**
	 * Connector name
	 *
	 * @var $connector_name
	 */
	
	public $connector_name = 'WPFormsForm';

	/**
	 * Initialization of WPForms hooks
	 */
	public function init() {
		add_action( 'wpforms_process_complete', array( $this, 'mint_wpforms_submission_inserted' ), 20, 4 );
	}


	/**
	 * Validate trigger settings
	 *
	 * @param array $step_data Get Step data.
	 * @param array $data Get All data.
	 * @return bool
	 * @since 1.17.0
	 */
	public function validate_settings( $step_data, $data ) {
		if ( isset( $data['trigger_name'] ) && ( ( 'wpforms_submission_inserted' === $data['trigger_name'] ) ) ) {
			if ( isset( $step_data['automation_id'], $step_data['automation_id'] ) ) {
				$step_data = HelperFunctions::get_step_data( $step_data['automation_id'], $step_data['step_id'] );
			}

			if (isset($step_data['settings']['wpforms_settings']['form_id']) && 'any' !== $step_data['settings']['wpforms_settings']['form_id']) {
				if (isset($data['data']['form_id'])) {	
					// Check if the form_id is an array or not.				
					$form_id          = $step_data['settings']['wpforms_settings']['form_id'];
					$settings_form_id = is_array($form_id) ? $form_id['value'] : $form_id;
					$is_validate = ($data['data']['form_id'] == $settings_form_id); //phpcs:ignore

					if ($is_validate) {
						$form_data = isset($data['data']) ? $data['data'] : array();
						$status    = isset($step_data['settings']['wpforms_settings']['status']) ? $step_data['settings']['wpforms_settings']['status'] : 'pending';
						$email     = isset($data['data']['user_email']) ? $data['data']['user_email'] : '';
						if (empty($email)) {
							return false;
						}
						$user_data = array(
							'meta_fields' => array(),
							'status'      => $status,
							'source'      => 'Automation'
						);
						// Populate the user_data dynamically.
						foreach ($form_data as $key => $value) {
							switch ($key) {
								case 'first_name':
								case 'last_name':
								case 'last_activity':
									$user_data[$key] = $value;
									break;
								case 'status':
								case 'source':
								case 'form_id':
								case 'user_email':
									// Skip these keys since they are already set or will be set separately.
									break;
								default:
									$user_data['meta_fields'][$key] = $value;
									break;
							}
						}

						$contact       = new ContactData($email, $user_data);
						$exist_email   = ContactModel::is_contact_exist($email);
						if (!$exist_email) {
							$contact_id = ContactModel::insert($contact);
							if (isset($user_data['status']) && 'pending' === $user_data['status']) {
								MessageController::get_instance()->send_double_opt_in($contact_id);
							}
						}
						return true;
					}
				}
			} else {
				return false;
			}
		}
		return false;
	}

	/**
	 * Mint trigger for  WPForms submission inserted event.
	 *
	 * @param int    $entry_id The ID of the submitted form entry.
	 * @param array  $form_data The data submitted with the form.
	 * @param object $form The WPForms Forms form object.
	 *
	 * @return void
	 * @since 1.17.
	 */
	public function mint_wpforms_submission_inserted( $fields, $entry, $form_data, $entry_id ) {
		$user_data = array();
        if (isset($form_data['id'])) {
			foreach ($fields as $key => $field) {
				if (isset($field['type']) && $field['type'] === 'email') {
					$user_data['email'] = !empty($field['value']) ? $field['value'] : '';
				}
			}
		}

		if (isset($user_data['email']) && ! empty($user_data['email'])) {
			$data = array(
				'connector_name' => $this->connector_name,
				'trigger_name'   => 'wpforms_submission_inserted',
				'data'           => array(
					'user_email' => $user_data['email'],
					'form_id'    => $form_data['id'],
					'form_data'  => $fields,
				),
			);
			do_action(MINT_TRIGGER_AUTOMATION, $data);
		}
	}
}

