<?php
/**
 * Automation WPFOMRS connector class for WPFOMRS connector
 *
 * Class WPFOMRS
 *
 * @package MintMail\App\Internal\Automation\Connector
 * @Since 1.17
 */

namespace MintMail\App\Internal\Automation\Connector;

use MintMail\App\Internal\Automation\Automation_Connector;
use MintMail\App\Internal\Automation\Connector\Trigger\WPFormsFormTriggers;
use Mint\Mrm\Internal\Traits\Singleton;

/**
 * WPFOMRS Connector
 *
 * Class WPFOMRS
 *
 * @package MintMail\App\Internal\Automation\Connector
 */
class ConnectorWPFormsForm extends Automation_Connector {

	use Singleton;

	/**
	 * MM triggers
	 *
	 * @var $triggers.
	 */
	public $triggers;

	/**
	 * Initialization
	 */
	public function __construct() {
		if ( $this->maybe_connected() ) {
			WPFormsFormTriggers::get_instance()->init();
		}
	}

	/**
	 * Get connector name
	 *
	 * @return String
	 * @since  1.17.0
	 */
	public function get_name() {
		return __( 'WPForms', 'mailmint-pro' );
	}


	/**
	 * Check the connector is connected or not
	 *
	 * @return Bool
	 * @since   1.17.0
	 */
	public function maybe_connected() {
		return true;
	}


	/**
	 * Retrieves the supported WPF triggers and caches them to avoid multiple database calls.
	 *
	 * @return array An array of supported WPF triggers.
	 * 	 
	 * 
	 * * @since   1.17.0
	 */
	public function get_triggers() {
		$this->triggers = $this->get_supported_wpformsform_triggers();
		return $this->triggers;
	}


	/**
	 * Get supported triggers for WPF integration.
	 *
	 * @return array The array of supported triggers for WPF integration.
	* @since   1.17.0
	 */
	public function get_supported_wpformsform_triggers() {
		$triggers = array(
			array(
				'key'   => 'wpforms_submission_inserted',
				'label' => 'WPForms - After submission',
			),
		);
		return $triggers;
	}

}
