<?php
/**
 * Automation WPFunnels connector class for MRM Autoamtion connector
 *
 * Class ConnectorTutor
 *
 * @package MintMail\App\Internal\Automation\Connector
 */

namespace MintMail\App\Internal\Automation\Connector;

use MintMail\App\Internal\Automation\Automation_Connector;
use MintMail\App\Internal\Automation\Connector\trigger\TutorTriggers;
use Mint\Mrm\Internal\Traits\Singleton;

/**
 * Edd Connector
 *
 * Class ConnectorTutor
 *
 * @package MintMail\App\Internal\Automation\Connector
 */
class ConnectorTutor extends Automation_Connector {

	use Singleton;

	/**
	 * MM triggers
	 *
	 * @var $triggers.
	 */
	public $triggers;

	/**
	 * Initialization
	 */
	public function __construct() {
		if ( $this->maybe_connected() ) {
			TutorTriggers::get_instance()->init();
		}
	}

	/**
	 * Get connector name
	 *
	 * @return String
	 * @since  1.0.0
	 */
	public function get_name() {
		return __( 'Tutor', 'mailmint-pro' );
	}


	/**
	 * Check the connector is connected or not
	 *
	 * @return Bool
	 * @since  1.0.0
	 */
	public function maybe_connected() {
		return true;
	}


	/**
	 * Get all triggers
	 */
	public function get_triggers() {
		$this->triggers = $this->get_supported_wpf_triggers();
		return $this->triggers;
	}


	/**
	 * All supported triggers
	 */
	public function get_supported_wpf_triggers() {
		$tutor_triggers = array(
			array(
				'key'   => 'tutor_after_student_signup',
				'label' => 'Tutor after student signup',
			),
			array(
				'key'   => 'tutor_enrollment/after/cancel',
				'label' => 'Tutor enrollment cancel',
			),
			array(
				'key'   => 'tutor_enrollment/after/delete',
				'label' => 'Tutor enrollment delete',
			),
		);
		return $tutor_triggers;
	}

}
