<?php
/**
 * Automation MemberPress connector class for Mail Mint automation connector
 *
 * Class ConnectorMemberPress
 *
 * @package MintMail\App\Internal\Automation\Connector
 */

namespace MintMail\App\Internal\Automation\Connector;

use MintMail\App\Internal\Automation\Automation_Connector;
use Mint\Mrm\Internal\Traits\Singleton;
use MintMail\App\Internal\Automation\Connector\Trigger\MemberPressTriggers;

/**
 * MemberPress Connector
 *
 * Class ConnectorMemberPress
 *
 * @package MintMail\App\Internal\Automation\Connector
 */
class ConnectorMemberPress extends Automation_Connector {

	use Singleton;

	/**
	 * Property to store triggers
	 *
	 * @var mixed $triggers Property to store triggers.
	 * @since 1.8.0
	 */
	public $triggers;

	/**
	 * Class constructor.
	 * Initializes MemberPress triggers if the connection is established.
	 *
	 * @since 1.8.0
	 */
	public function __construct() {
		if ( $this->maybe_connected() ) {
			MemberPressTriggers::get_instance()->init();
		}
	}

	/**
	 * Get the name for MemberPress.
	 *
	 * @return string The translated name for MemberPress.
	 * @since 1.8.0
	 */
	public function get_name() {
		return __( 'MemberPress', 'mailmint-pro' );
	}

	/**
	 * Check if the connection is established (placeholder always returns true).
	 *
	 * @return bool Always returns true for demonstration purposes.
	 * @since 1.8.0
	 */
	public function maybe_connected() {
		return true;
	}

	/**
	 * Retrieve and set the supported triggers.
	 *
	 * @return array The array of supported triggers.
	 * @since 1.8.0
	 */
	public function get_triggers() {
		$this->triggers = $this->get_supported_triggers();
		return $this->triggers;
	}

	/**
	 * Get an array of supported triggers.
	 *
	 * @return array An array containing supported triggers with 'key' and 'label' values.
	 * @since 1.8.0
	 */
	public function get_supported_triggers() {
		return array(
			array(
				'key'   => 'mepr-account-is-active',
				'label' => __( 'Added to a Membership Level', 'mailmint-pro' ),
			),
		);
	}

}
