<?php
/**
 * Mail Mint
 *
 * @author [WPFunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2024-05-15 11:03:17
 * @modify date 2024-05-15 11:03:17
 * @package MintMail\App\Internal\Automation\Connector
 */

namespace MintMail\App\Internal\Automation\Connector;

use MintMail\App\Internal\Automation\Automation_Connector;
use Mint\Mrm\Internal\Traits\Singleton;
use MintMail\App\Internal\Automation\Connector\trigger\AnniversaryTriggers;
use MintMail\App\Internal\Automation\Connector\trigger\LinkClickTriggers;
use MintMail\App\Internal\Automation\Connector\trigger\SegmentTriggers;
use MintMail\App\Internal\Automation\Connector\trigger\WebhookTriggers;

/**
 * Class ConnectorMailMint
 *
 * Handles the connection to the MailMint service.
 *
 * @since 1.12.0
 */
class ConnectorMailMint extends Automation_Connector {

	use Singleton;

	/**
	 * Triggers
	 *
	 * @var array Holds the triggers supported by the MailMint service.
	 * @since 1.12.0
	 */
	public $triggers;

	/**
	 * ConnectorMailMint constructor.
	 *
	 * @since 1.12.0
	 */
	public function __construct() {
		if ( $this->maybe_connected() ) {
			AnniversaryTriggers::get_instance()->init();
			WebhookTriggers::get_instance()->init();
			SegmentTriggers::get_instance()->init();
			LinkClickTriggers::get_instance()->init();
		}
	}

	/**
	 * Get the name of the connector.
	 *
	 * @since 1.12.0
	 *
	 * @return string The name of the connector.
	 */
	public function get_name() {
		return __( 'MailMint', 'mrm' );
	}

	/**
	 * Get the description of the connector.
	 *
	 * @since 1.12.0
	 *
	 * @return string The description of the connector.
	 */
	public function maybe_connected() {
		return true;
	}

	/**
	 * Get the description of the connector.
	 *
	 * @since 1.12.0
	 *
	 * @return string The description of the connector.
	 */
	public function get_triggers() {
		$this->triggers = $this->get_supported_mm_triggers();
		return $this->triggers;
	}

	/**
	 * Get the supported triggers for the MailMint service.
	 *
	 * @since 1.12.0
	 *
	 * @return array The supported triggers.
	 */
	public function get_supported_mm_triggers() {
		return array(
			array(
				'key'   => 'mailmint_process_contact_anniversary_daily',
				'label' => 'Anniversary',
			),
			array(
				'key'   => 'mailmint_process_contact_anniversary_daily_once',
				'label' => 'Anniversary',
			),
			array(
				'key'   => 'mint_after_incoming_webhook',
				'label' => 'Webhook',
			),
			array(
				'key'   => 'mint_after_contact_creation',
				'label' => 'Segment',
			),array(
				'key'   => 'mint_when_contact_click_a_link',
				'label' => 'ContactClick',
			),
		);
	}

}
