<?php
/**
 * Mail Mint
 *
 * @author [WPFunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2024-05-15 11:03:17
 * @modify date 2024-05-15 11:03:17
 * @package MintMail\App\Internal\Automation\Connector
 */

namespace MintMail\App\Internal\Automation\Connector;

use MintMail\App\Internal\Automation\Automation_Connector;
use Mint\Mrm\Internal\Traits\Singleton;
use MintMail\App\Internal\Automation\Connector\trigger\LifterLMSTriggers;

/**
 * Class ConnectorLifterLMS
 *
 * Handles the connection to the LifterLMS service.
 *
 * @since 1.12.0
 */
class ConnectorLifterLMS extends Automation_Connector {

	use Singleton;

	/**
	 * Triggers
	 *
	 * @var array Holds the triggers supported by the LifterLMS service.
	 * @since 1.12.0
	 */
	public $triggers;

	/**
	 * ConnectorLifterLMS constructor.
	 *
	 * @since 1.12.0
	 */
	public function __construct() {
		if ( $this->maybe_connected() ) {
			LifterLMSTriggers::get_instance()->init();
		}
	}

	/**
	 * Get the name of the connector.
	 *
	 * @since 1.12.0
	 *
	 * @return string The name of the connector.
	 */
	public function get_name() {
		return __( 'LifterLMS', 'mrm' );
	}

	/**
	 * Get the description of the connector.
	 *
	 * @since 1.12.0
	 *
	 * @return string The description of the connector.
	 */
	public function maybe_connected() {
		return true;
	}

	/**
	 * Get the description of the connector.
	 *
	 * @since 1.12.0
	 *
	 * @return string The description of the connector.
	 */
	public function get_triggers() {
		$this->triggers = $this->get_supported_mm_triggers();
		return $this->triggers;
	}

	/**
	 * Get the supported triggers for the LifterLMS service.
	 *
	 * @since 1.12.0
	 *
	 * @return array The supported triggers.
	 */
	public function get_supported_mm_triggers() {
		return array(
			array(
				'key'   => 'lifter_add_to_course',
				'label' => 'Enrolls in a Course',
			),
		);
	}

}
