<?php
/**
 * Automation LearnDash connector class for Mail Mint automation connector
 *
 * Class ConnectorLearnDash
 *
 * @package MintMail\App\Internal\Automation\Connector
 */

namespace MintMail\App\Internal\Automation\Connector;

use MintMail\App\Internal\Automation\Automation_Connector;
use Mint\Mrm\Internal\Traits\Singleton;
use MintMail\App\Internal\Automation\Connector\Trigger\LearnDashTriggers;

/**
 * LearnDash Connector
 *
 * Class ConnectorLearnDash
 *
 * @package MintMail\App\Internal\Automation\Connector
 */
class ConnectorLearnDash extends Automation_Connector {

	use Singleton;

	/**
	 * Property to store triggers
	 *
	 * @var mixed $triggers Property to store triggers.
	 * @since 1.6.1
	 */
	public $triggers;

	/**
	 * Class constructor.
	 * Initializes LearnDash triggers if the connection is established.
	 *
	 * @since 1.6.1
	 */
	public function __construct() {
		if ( $this->maybe_connected() ) {
			LearnDashTriggers::get_instance()->init();
		}
	}

	/**
	 * Get the name for LearnDash.
	 *
	 * @return string The translated name for LearnDash.
	 * @since 1.6.1
	 */
	public function get_name() {
		return __( 'LearnDash', 'mailmint-pro' );
	}

	/**
	 * Check if the connection is established (placeholder always returns true).
	 *
	 * @return bool Always returns true for demonstration purposes.
	 * @since 1.6.1
	 */
	public function maybe_connected() {
		return true;
	}

	/**
	 * Retrieve and set the supported triggers.
	 *
	 * @return array The array of supported triggers.
	 * @since 1.6.1
	 */
	public function get_triggers() {
		$this->triggers = $this->get_supported_triggers();
		return $this->triggers;
	}

	/**
	 * Get an array of supported triggers.
	 *
	 * @return array An array containing supported triggers with 'key' and 'label' values.
	 * @since 1.6.1
	 */
	public function get_supported_triggers() {
		return array(
			array(
				'key'   => 'learndash_update_course_access',
				'label' => __( 'Enrolls in a course', 'mailmint-pro' ),
			),
		);
	}

}
