<?php
/**
 * Edd triggers
 *
 * @package MintMail\App\Internal\Automation\Connector\trigger;
 */

namespace MintMail\App\Internal\Automation\Connector\trigger;

use Mint\MRM\Admin\API\Controllers\MessageController;
use Mint\MRM\DataBase\Models\ContactModel;
use Mint\MRM\DataStores\ContactData;
use MintMail\App\Internal\Automation\HelperFunctions;
use Mint\Mrm\Internal\Traits\Singleton;
/**
 * Edd triggers
 *
 * @package MintMail\App\Internal\Automation\Connector
 */
class JetformTriggers {

	use Singleton;



	/**
	 * Connector name
	 *
	 * @var $connector_name
	 */
	public $connector_name = 'Jetform';

	/**
	 * Initialization of Jetform hooks
	 */
	public function init() {
		// //phpcs:ignore ; add_action( 'jet-form-builder/form-handler/before-send', array( $this, 'mint_jetform_before_submission' ), 10, 1 ); //phpcs:ignore
		add_action( 'jet-form-builder/form-handler/after-send', array( $this, 'mint_jetform_after_submission' ), 10, 2 );
	}


	/**
	 * Validate trigger settings
	 *
	 * @param array $step_data Get Step data.
	 * @param array $data Get All data.
	 * @return bool
	 */
	public function validate_settings( $step_data, $data ) {
		if ( isset( $data['trigger_name'] ) && ( ( 'jetform_after_submit' === $data['trigger_name'] ) || 'jetform_before_submit' === $data['trigger_name'] ) ) {
			if ( isset( $step_data['automation_id'], $step_data['automation_id'] ) ) {
				$step_data = HelperFunctions::get_step_data( $step_data['automation_id'], $step_data['step_id'] );
			}
			if ( isset( $step_data['settings']['jetform_settings']['form_id'] ) && 'any' !== $step_data['settings']['jetform_settings']['form_id'] ) {
				if ( isset( $data['data']['form_id'] ) ) {
					$form_id          = $step_data['settings']['jetform_settings']['form_id'];
					$settings_form_id = is_array($form_id) ? $form_id['value'] : $form_id;
					$is_validate = ($data['data']['form_id'] == $settings_form_id); //phpcs:ignore
					if ($is_validate) {
						$form_data = isset($data['data']) ? $data['data'] : array();
						$status    = isset($step_data['settings']['jetform_settings']['status']) ? $step_data['settings']['jetform_settings']['status'] : 'pending';
						$email     = isset($data['data']['user_email']) ? $data['data']['user_email'] : '';
						if (empty($email)) {
							return false;
						}
						$user_data = array(
							'meta_fields' => array(),
							'status'      => $status,
							'source'      => 'Automation'
						);
						// Populate the user_data dynamically.
						foreach ($form_data as $key => $value) {
							switch ($key) {
								case 'first_name':
								case 'last_name':
								case 'last_activity':
									$user_data[$key] = $value;
									break;
								case 'status':
								case 'source':
								case 'form_id':
								case 'user_email':
									// Skip these keys since they are already set or will be set separately.
									break;
								default:
									$user_data['meta_fields'][$key] = $value;
									break;
							}
						}

						$contact       = new ContactData($email, $user_data);
						$exist_email   = ContactModel::is_contact_exist($email);
						if (!$exist_email) {
							$contact_id = ContactModel::insert($contact);
							if (isset($user_data['status']) && 'pending' === $user_data['status']) {
								MessageController::get_instance()->send_double_opt_in($contact_id);
							}
						}
						return true;
					}
				}
			} else {
				return false;
			}
		}
		return false;
	}


	/**
	 * After jetform submission
	 *
	 * @param object $form Entry.
	 *
	 * @return void
	 * @since  1.0.0
	 */
	public function mint_jetform_before_submission( $form ) {
		$user_data = array();
		if ( !empty( $form->form_id ) ) {
			if ( isset( $form->form_id, $form->is_success ) && $form->is_success ) {
				$fields    = $form->request_handler->_fields;
				$user_data = array();
				$data      = array();
				foreach ( $fields as $field ) {
					if ( isset( $field['attrs'] ) ) {
						if ( isset( $field['attrs']['field_type'] ) ) {
							if ( 'email' === $field['attrs']['field_type'] ) {
								if ( isset( $field['attrs']['name'] ) ) {
									$data['name'] = $field['attrs']['name'];
								}
							}
						}
					}
				}

				$request_data = $form->action_handler->request_data;
				if ( isset( $data['name'] ) && isset( $request_data[ $data['name'] ] ) ) {
					$user_data['email'] = $request_data[ $data['name'] ];
				}
			}
		}
		if ( $user_data && isset( $user_data['email'] ) ) {
			$data = array(
				'connector_name' => $this->connector_name,
				'trigger_name'   => 'gform_after_submission',
				'data'           => array(
					'user_email' => $user_data['email'],
					'first_name' => isset( $user_data['first_name'] ) ? $user_data['first_name'] : '',
					'last_name'  => isset( $user_data['last_name'] ) ? $user_data['last_name'] : '',
					'form_id'    => isset( $form['id'] ) ? $form['id'] : '',
				),
			);
			do_action( MINT_TRIGGER_AUTOMATION, $data );
		}
	}


	/**
	 * After jetform send email
	 *
	 * @param object   $form_handler Entry.
	 * @param boolean $is_success Success.
	 * @return void
	 */
	public function mint_jetform_after_submission( $form_handler, $is_success ) {
		if ( !empty( $form_handler->form_id ) && $is_success ) {
			if ( isset( $form_handler->form_id, $form_handler->is_success ) && $form_handler->is_success ) {
				$context    = $form_handler->action_handler->context;
				$record_id  = isset( $context['save_record']['id'] ) ? $context['save_record']['id'] : '';

				global $wpdb;
				$table = $wpdb->prefix . 'jet_fb_records_fields';
				// Query the data.
				$fields = $wpdb->get_results(
					$wpdb->prepare(
						"SELECT * FROM {$table} WHERE record_id = %d",
						$record_id
					),
					ARRAY_A
				);

				// Transform the array
				$form_data = [];
				foreach ($fields as $field) {
					$form_data[$field['field_name']] = $field['field_value'];
				}

				$data = array(
					'connector_name' => $this->connector_name,
					'trigger_name'   => 'jetform_after_submit',
					'data'           => array(
						'form_id'    => isset( $form_handler->form_id ) ? $form_handler->form_id : '',
						'form_data'  => $form_data,
					),
				);
				do_action( MINT_TRIGGER_AUTOMATION, $data );
			}
		}
	}




}

