<?php
/**
 * Automation WPFunnels connector class for MRM Autoamtion connector
 *
 * Class ConnectorGform
 *
 * @package MintMail\App\Internal\Automation\Connector
 */

namespace MintMail\App\Internal\Automation\Connector;

use MintMail\App\Internal\Automation\Automation_Connector;
use MintMail\App\Internal\Automation\Connector\trigger\GformTriggers;
use Mint\Mrm\Internal\Traits\Singleton;

/**
 * Gform Connector
 *
 * Class ConnectorGform
 *
 * @package MintMail\App\Internal\Automation\Connector
 */
class ConnectorGform extends Automation_Connector {

	use Singleton;

	/**
	 * MM triggers
	 *
	 * @var $triggers.
	 */
	public $triggers;

	/**
	 * Initialization
	 */
	public function __construct() {
		if ( $this->maybe_connected() ) {
			GformTriggers::get_instance()->init();
		}
	}

	/**
	 * Get connector name
	 *
	 * @return String
	 * @since  1.0.0
	 */
	public function get_name() {
		return __( 'Gform', 'mailmint-pro' );
	}


	/**
	 * Check the connector is connected or not
	 *
	 * @return Bool
	 * @since  1.0.0
	 */
	public function maybe_connected() {
		return true;
	}


	/**
	 * Get all triggers
	 */
	public function get_triggers() {
		$this->triggers = $this->get_supported_wpf_triggers();
		return $this->triggers;
	}


	/**
	 * All supported triggers
	 */
	public function get_supported_wpf_triggers() {
		$gform_triggers = array(
			array(
				'key'   => 'gform_after_submission',
				'label' => 'Gform - After submission',
			),
			array(
				'key'   => 'gform_after_email',
				'label' => 'Gform - After send an email',
			),
			array(
				'key'   => 'gform_send_email_failed',
				'label' => 'Gform - Fail to send an email',
			),
		);
		return $gform_triggers;
	}

}
