<?php
/**
 * Edd triggers
 *
 * @package MintMail\App\Internal\Automation\Connector\trigger;
 */

namespace MintMail\App\Internal\Automation\Connector\Trigger;

use Mint\MRM\Admin\API\Controllers\MessageController;
use Mint\MRM\DataBase\Models\ContactModel;
use Mint\MRM\DataStores\ContactData;
use MintMail\App\Internal\Automation\HelperFunctions;
use Mint\Mrm\Internal\Traits\Singleton;
/**
 * Edd triggers
 *
 * @package MintMail\App\Internal\Automation\Connector
 */
class FluentFormTriggers {

	use Singleton;

	/**
	 * Connector name
	 *
	 * @var $connector_name
	 */
	public $connector_name = 'FluentForm';

	/**
	 * Initialization of Fluent Forms hooks
	 */
	public function init() {
		add_action( 'fluentform_submission_inserted', array( $this, 'mint_fluentform_submission_inserted' ), 20, 3 );
	}


	/**
	 * Validate trigger settings
	 *
	 * @param array $step_data Get Step data.
	 * @param array $data Get All data.
	 * @return bool
	 * @since 1.2.7
	 */
	public function validate_settings( $step_data, $data ) {
		if ( isset( $data['trigger_name'] ) && ( ( 'fluentform_submission_inserted' === $data['trigger_name'] ) ) ) {
			if ( isset( $step_data['automation_id'], $step_data['automation_id'] ) ) {
				$step_data = HelperFunctions::get_step_data( $step_data['automation_id'], $step_data['step_id'] );
			}

			if (isset($step_data['settings']['fluentform_settings']['form_id']) && 'any' !== $step_data['settings']['fluentform_settings']['form_id']) {
				if (isset($data['data']['form_id'])) {

					$form_id          = $step_data['settings']['fluentform_settings']['form_id'];
					$settings_form_id = is_array($form_id) ? $form_id['value'] : $form_id;

					$is_validate = ($data['data']['form_id'] == $settings_form_id); 
					if ($is_validate) {
						$form_data = isset($data['data']) ? $data['data'] : array();
						$status    = isset($step_data['settings']['fluentform_settings']['status']) ? $step_data['settings']['fluentform_settings']['status'] : 'pending';
						$email     = isset($data['data']['user_email']) ? $data['data']['user_email'] : '';
						if (empty($email)) {
							return false;
						}
						$user_data = array(
							'meta_fields' => array(),
							'status'      => $status,
							'source'      => 'Automation'
						);
						// Populate the user_data dynamically.
						foreach ($form_data as $key => $value) {
							switch ($key) {
								case 'first_name':
								case 'last_name':
								case 'last_activity':
									$user_data[$key] = $value;
									break;
								case 'status':
								case 'source':
								case 'form_id':
								case 'user_email':
									// Skip these keys since they are already set or will be set separately.
									break;
								default:
									$user_data['meta_fields'][$key] = $value;
									break;
							}
						}

						$contact       = new ContactData($email, $user_data);
						$exist_email   = ContactModel::is_contact_exist($email);
						if (!$exist_email) {
							$contact_id = ContactModel::insert($contact);
							if (isset($user_data['status']) && 'pending' === $user_data['status']) {
								MessageController::get_instance()->send_double_opt_in($contact_id);
							}
						}
						return true;
					}
				}
			} else {
				return false;
			}
		}
		return false;
	}

	/**
	 * Mint trigger for Fluent Forms submission inserted event.
	 *
	 * @param int    $entry_id The ID of the submitted form entry.
	 * @param array  $form_data The data submitted with the form.
	 * @param object $form The Fluent Forms form object.
	 *
	 * @return void
	 * @since 1.2.7
	 */
	public function mint_fluentform_submission_inserted( $entry_id, $form_data, $form ) {
		$user_data = array();
		if (!empty($form->id)) {
			if (is_array($form_data)) {
				$user_data          = array();
				$data               = array();
				$user_data['email'] = isset($form_data['email']) ? $form_data['email'] : '';

				if (isset($form_data['names'])) {
					$user_data['first_name'] = $form_data['names']['first_name'];
					$user_data['last_name']  = $form_data['names']['last_name'];
				}
			}
		}
		if ($user_data && isset($user_data['email'])) {
			$data = array(
				'connector_name' => $this->connector_name,
				'trigger_name'   => 'fluentform_submission_inserted',
				'data'           => array(
					'user_email' => $user_data['email'],
					'first_name' => isset($user_data['first_name']) ? $user_data['first_name'] : '',
					'last_name'  => isset($user_data['last_name']) ? $user_data['last_name'] : '',
					'form_id'    => isset($form->id) ? $form->id : '',
					'form_data'  => $form_data,
				),
			);
			do_action(MINT_TRIGGER_AUTOMATION, $data);
		}
	}
}

