<?php
/**
 * Automation WPFunnels connector class for MRM Autoamtion connector
 *
 * Class ConnectorGform
 *
 * @package MintMail\App\Internal\Automation\Connector
 */

namespace MintMail\App\Internal\Automation\Connector;

use MintMail\App\Internal\Automation\Automation_Connector;
use MintMail\App\Internal\Automation\Connector\Trigger\FluentFormTriggers;
use Mint\Mrm\Internal\Traits\Singleton;

/**
 * Gform Connector
 *
 * Class ConnectorGform
 *
 * @package MintMail\App\Internal\Automation\Connector
 */
class ConnectorFluentForm extends Automation_Connector {

	use Singleton;

	/**
	 * MM triggers
	 *
	 * @var $triggers.
	 */
	public $triggers;

	/**
	 * Initialization
	 */
	public function __construct() {
		if ( $this->maybe_connected() ) {
			FluentFormTriggers::get_instance()->init();
		}
	}

	/**
	 * Get connector name
	 *
	 * @return String
	 * @since  1.2.7
	 */
	public function get_name() {
		return __( 'Fluent Forms', 'mailmint-pro' );
	}


	/**
	 * Check the connector is connected or not
	 *
	 * @return Bool
	 * @since  1.2.7
	 */
	public function maybe_connected() {
		return true;
	}


	/**
	 * Retrieves the supported WPF triggers and caches them to avoid multiple database calls.
	 *
	 * @return array An array of supported WPF triggers.
	 * @since 1.2.7
	 */
	public function get_triggers() {
		$this->triggers = $this->get_supported_fluentform_triggers();
		return $this->triggers;
	}


	/**
	 * Get supported triggers for WPF integration.
	 *
	 * @return array The array of supported triggers for WPF integration.
	 * @since 1.2.7
	 */
	public function get_supported_fluentform_triggers() {
		$triggers = array(
			array(
				'key'   => 'fluentform_submission_inserted',
				'label' => 'Fluent Forms - After submission',
			),
		);
		return $triggers;
	}

}
