<?php
/**
 * Automation WPFunnels connector class for MRM Autoamtion connector
 *
 * Class ConnectorGform
 *
 * @package MintMail\App\Internal\Automation\Connector
 */

namespace MintMail\App\Internal\Automation\Connector;

use MintMail\App\Internal\Automation\Automation_Connector;
use MintMail\App\Internal\Automation\Connector\Trigger\FluentBookingTriggers;
use Mint\Mrm\Internal\Traits\Singleton;

/**
 * FluentBooking Connector
 *
 * Class ConnectorFluentBooking
 *
 * @package MintMail\App\Internal\Automation\Connector
 */
class ConnectorFluentBooking extends Automation_Connector {

	use Singleton;

	/**
	 * MM triggers
	 *
	 * @var $triggers.
	 */
	public $triggers;

	/**
	 * Initialization
	 * @since  1.18.2
	 */
	 
	public function __construct() {
		if ( $this->maybe_connected() ) {
			FluentBookingTriggers::get_instance()->init();
		}
	}

	/**
	 * Get connector name
	 *
	 * @return String
	 * @since  1.18.2
	 */
	public function get_name() {
		return __( 'Fluent Booking', 'mailmint-pro' );
	}


	/**
	 * Check the connector is connected or not
	 *
	 * @return Bool
	 * @since  @since  1.18.2
	 */
	public function maybe_connected() {
		return true;
	}


	/**
	 * Retrieves the supported WPF triggers and caches them to avoid multiple database calls.
	 *
	 * @return array An array of supported Fluent Booking triggers.
	 * @since @since  1.18.2
	 */
	public function get_triggers() {
		$this->triggers = $this->get_supported_fluentform_triggers();
		return $this->triggers;
	}


	/**
	 * Get supported triggers for Fluent Booking integration.
	 *
	 * @return array The array of supported triggers for Fluent Booking integration.
	 * @since 1.18.2
	 */
	public function get_supported_fluentform_triggers() {
		$triggers = array(
			array(
				'key'   => 'fluentbooking_new_booking',
				'label' => 'Fluent Booking - New Booking',
			),
		);
		return $triggers;
	}

}
