<?php
/**
 * Automation WPFunnels connector class for MRM Autoamtion connector
 *
 * Class ConnectorWpfunnels
 *
 * @package MintMail\App\Internal\Automation\Connector
 */

namespace MintMail\App\Internal\Automation\Connector;

use MintMail\App\Internal\Automation\Automation_Connector;
use MintMail\App\Internal\Automation\Connector\trigger\EddTriggers;
use Mint\Mrm\Internal\Traits\Singleton;

/**
 * Edd Connector
 *
 * Class ConnectorEdd
 *
 * @package MintMail\App\Internal\Automation\Connector
 */
class ConnectorEdd extends Automation_Connector {

	use Singleton;

	/**
	 * MM triggers
	 *
	 * @var $triggers.
	 */
	public $triggers;

	/**
	 * Initialization
	 */
	public function __construct() {
		if ( $this->maybe_connected() ) {
			EddTriggers::get_instance()->init();
		}
	}

	/**
	 * Get connector name
	 *
	 * @return String
	 * @since  1.0.0
	 */
	public function get_name() {
		return __( 'EDD', 'mailmint-pro' );
	}


	/**
	 * Check the connector is connected or not
	 *
	 * @return Bool
	 * @since  1.0.0
	 */
	public function maybe_connected() {
		return true;
	}


	/**
	 * Get all triggers
	 */
	public function get_triggers() {
		$this->triggers = $this->get_supported_wpf_triggers();
		return $this->triggers;
	}


	/**
	 * All supported triggers
	 */
	public function get_supported_wpf_triggers() {
		$edd_triggers = array(
			array(
				'key'   => 'edd_complete_purchase',
				'label' => 'EDD complete purchase',
			),
			array(
				'key'   => 'edd_insert_user',
				'label' => 'EDD insert user',
			),
			array(
				'key'   => 'edd_recurring_update_subscription',
				'label' => 'EDD update subcription',
			),
			array(
				'key'   => 'edd_update_payment_status',
				'label' => 'EDD update payment status',
			),
		);
		return $edd_triggers;
	}

}
