<?php
/**
 * Automation WPFunnels connector class for MRM Autoamtion connector
 *
 * Class ConnectorGform
 *
 * @package MintMail\App\Internal\Automation\Connector
 */

namespace MintMail\App\Internal\Automation\Connector;

use MintMail\App\Internal\Automation\Automation_Connector;
use MintMail\App\Internal\Automation\Connector\Trigger\ContactFormTriggers;
use Mint\Mrm\Internal\Traits\Singleton;

/**
 * Gform Connector
 *
 * Class ConnectorGform
 *
 * @package MintMail\App\Internal\Automation\Connector
 */
class ConnectorContactForm extends Automation_Connector {

	use Singleton;

	/**
	 * MM triggers
	 *
	 * @var $triggers.
	 */
	public $triggers;

	/**
	 * Initialization
	 */
	public function __construct() {
		if ( $this->maybe_connected() ) {
			ContactFormTriggers::get_instance()->init();
		}
	}

	/**
	 * Get connector name
	 *
	 * @return String
	 * @since  1.2.7
	 */
	public function get_name() {
		return __( 'Contact Form 7', 'mailmint-pro' );
	}


	/**
	 * Check the connector is connected or not
	 *
	 * @return Bool
	 * @since  1.2.7
	 */
	public function maybe_connected() {
		return true;
	}


	/**
	 * Retrieves the supported WPF triggers and caches them to avoid multiple database calls.
	 *
	 * @return array An array of supported WPF triggers.
	 * @since 1.2.7
	 */
	public function get_triggers() {
		$this->triggers = $this->get_supported_contact_form_triggers();
		return $this->triggers;
	}


	/**
	 * Get supported triggers for WPF integration.
	 *
	 * @return array The array of supported triggers for WPF integration.
	 * @since 1.2.7
	 */
	public function get_supported_contact_form_triggers() {
		$triggers = array(
			array(
				'key'   => 'wpcf7_submit',
				'label' => __( 'Contact Form 7 - After submission', 'mailmint-pro' ),
			),
		);
		return $triggers;
	}

}
