<?php
/**
 * Bricks Form - After Submission Trigger
 * Description: This file is used to run trigger after Bricks form submission.
 *
 * @package MintMail\App\Internal\Automation\Connector
 */

namespace MintMail\App\Internal\Automation\Connector;

use MintMail\App\Internal\Automation\Automation_Connector;
use Mint\Mrm\Internal\Traits\Singleton;
use MintMail\App\Internal\Automation\Connector\Trigger\BricksFormTriggers;

/**
 * Class ConnectorBricksForm
 *
 * This class is responsible for integrating Bricks Form with Mail Mint's automation system.
 * It initializes the triggers for Bricks Form and provides necessary methods for connection and trigger retrieval.
 *
 * @since 1.14.0
 */
class ConnectorBricksForm extends Automation_Connector {

	use Singleton;

	/**
     * @var array $triggers The triggers supported by Bricks Form.
	 * 
	 * @since 1.14.0
     */
	public $triggers;

	/**
     * ConnectorBricksForm constructor.
     *
     * Initializes the Bricks Form triggers if the form is connected.
	 * @since 1.14.0
     */
	public function __construct() {
		if ( $this->maybe_connected() ) {
			BricksFormTriggers::get_instance()->init();
		}
	}

	/**
     * Get the name of the connector.
     *
     * @return string The name of the connector.
	 * @since 1.14.0
     */
	public function get_name() {
		return __( 'Bricks', 'mailmint-pro' );
	}

	/**
     * Check if Bricks Form is connected.
     *
     * @return bool True if the form is connected, false otherwise.
	 * @since 1.14.0
     */
	public function maybe_connected() {
		return true;
	}

	/**
     * Get the triggers supported by Bricks Form.
     *
     * @return array The list of supported triggers.
	 * @since 1.14.0
     */
	public function get_triggers() {
		$this->triggers = $this->get_supported_contact_form_triggers();
		return $this->triggers;
	}

	/**
     * Define the triggers supported by Bricks Form.
     *
     * @return array The list of supported triggers with their keys and labels.
	 * @since 1.14.0
     */
	public function get_supported_contact_form_triggers() {
		$triggers = array(
			array(
				'key'   => 'bricks_form_submit',
				'label' => __( 'Bricks Form - After submission', 'mailmint-pro' ),
			),
		);
		return $triggers;
	}
}
