<?php
/**
 * Automation Recipe
 *
 * @package  MailMintPro\Mint\Internal\Automation
 */

namespace MailMintPro\Mint\Internal\Automation;

use MailMintPro\Mint\Internal\AbandonedCart\Helper\Common;
use MailMintPro\Mint\Internal\Traits\Singleton;

/**
 * Automation Recipe
 *
 * @package MintMail\App\Internal\Automation\AutomationRecipe
 */
class AutomationRecipe {

	use Singleton;

	/**
	 * Hook Automation pro.
	 *
	 * @return void
	 */
	public function init() {
		add_filter( 'mintmail_automation_wc_recipe', array( $this, 'mintmail_automation_woocommerce_recipe_add' ), 10, 1 );
		add_filter( 'mintmail_automation_edd_recipe', array( $this, 'mintmail_automation_edd_recipe_add' ), 10, 1 );
		add_filter( 'mintmail_automation_abandoned_cart_recipe', array( $this, 'mintmail_automation_abandoned_cart_recipe' ), 10, 1 );

		add_filter( 'mintmail_automation_mailmint_pro_recipe', array( $this, 'mintmail_automation_mailmint_pro_recipe' ), 10, 1 );
	}

	/**
	 * Add automation recipe for Woocommerce.
	 *
	 * @param string $recipe Get Automation recipe.
	 * @return array
	 */
	public function mintmail_automation_woocommerce_recipe_add( $recipe ) {
		if ( isset( $recipe[0] ) ) {
			$recipe[0]['automation_data'] = '{"id":"92","name":"First Order Engagement (Woo)","author":"1","trigger_name":"wc_first_order","status":"draft","created_at":"2023-02-23 03:40:29","updated_at":"2023-02-23 03:40:29","steps":[{"id":"250","automation_id":"92","step_id":"043qi","key":"wc_first_order","type":"trigger","settings":[],"next_step_id":"j03oc","created_at":"2023-02-23 03:40:29","updated_at":"2023-02-23 03:40:29","enterance":0,"completed":0,"exited":0},{"id":"251","automation_id":"92","step_id":"j03oc","key":"addTag","type":"action","settings":{"tag_settings":{"tags":[]}},"next_step_id":"4w91pl","created_at":"2023-02-23 03:40:29","updated_at":"2023-02-23 03:40:29","enterance":0,"completed":0,"exited":0},{"id":"252","automation_id":"92","step_id":"4w91pl","key":"addList","type":"action","settings":{"list_settings":{"lists":[]}},"next_step_id":"6ouu1","created_at":"2023-02-23 03:40:29","updated_at":"2023-02-23 03:40:29","enterance":0,"completed":0,"exited":0},{"id":"253","automation_id":"92","step_id":"6ouu1","key":"delay","type":"action","settings":{"delay_settings":{"delay":1,"unit":"minutes"}},"next_step_id":"ghtxoi","created_at":"2023-02-23 03:40:29","updated_at":"2023-02-23 03:40:29","enterance":0,"completed":0,"exited":0},{"id":"254","automation_id":"92","step_id":"ghtxoi","key":"sequence","type":"action","settings":{"sequence_settings":{"id":"","title":""}},"next_step_id":"a:0:{}","created_at":"2023-02-23 03:40:29","updated_at":"2023-02-23 03:40:29","enterance":0,"completed":0,"exited":0}]}';
		}
		if ( isset( $recipe[1] ) ) {
			$recipe[1]['automation_data'] = '{"id":"93","name":"New Order Follow-up Emails (Woo)","author":"1","trigger_name":"wc_order_created","status":"draft","created_at":"2023-02-23 03:41:20","updated_at":"2023-02-23 03:41:20","steps":[{"id":"255","automation_id":"93","step_id":"5wdh2","key":"wc_order_created","type":"trigger","settings":{"product_settings":{"products":[]}},"next_step_id":"euotrh","created_at":"2023-02-23 03:41:20","updated_at":"2023-02-23 03:41:20","enterance":0,"completed":0,"exited":0},{"id":"256","automation_id":"93","step_id":"euotrh","key":"addList","type":"action","settings":{"list_settings":{"lists":[]}},"next_step_id":"l0uwf","created_at":"2023-02-23 03:41:20","updated_at":"2023-02-23 03:41:20","enterance":0,"completed":0,"exited":0},{"id":"257","automation_id":"93","step_id":"l0uwf","key":"delay","type":"action","settings":{"delay_settings":{"delay":1,"unit":"minutes"}},"next_step_id":"pq1hn","created_at":"2023-02-23 03:41:20","updated_at":"2023-02-23 03:41:20","enterance":0,"completed":0,"exited":0},{"id":"258","automation_id":"93","step_id":"pq1hn","key":"sequence","type":"action","settings":{"sequence_settings":{"id":"","title":""}},"next_step_id":"a:0:{}","created_at":"2023-02-23 03:41:20","updated_at":"2023-02-23 03:41:20","enterance":0,"completed":0,"exited":0}]}';
		}
		if ( isset( $recipe[2] ) ) {
			$recipe[2]['automation_data'] = '{"id":"94","name":"Completed Order Follow-up (Woo)","author":"1","trigger_name":"wc_order_completed","status":"draft","created_at":"2023-02-23 03:42:25","updated_at":"2023-02-23 03:42:25","steps":[{"id":"259","automation_id":"94","step_id":"qwf4yi","key":"wc_order_completed","type":"trigger","settings":{"product_settings":{"products":[]}},"next_step_id":"bea1n","created_at":"2023-02-23 03:42:25","updated_at":"2023-02-23 03:42:25","enterance":0,"completed":0,"exited":0},{"id":"260","automation_id":"94","step_id":"bea1n","key":"delay","type":"action","settings":{"delay_settings":{"delay":1,"unit":"minutes"}},"next_step_id":"o5cizf","created_at":"2023-02-23 03:42:25","updated_at":"2023-02-23 03:42:25","enterance":0,"completed":0,"exited":0},{"id":"261","automation_id":"94","step_id":"o5cizf","key":"sendMail","type":"action","settings":{"message_data":{"subject":"Welcome email from mint","sender_email":"dev-email@flywheel.local","sender_name":"mail-mint","reply_name":"mail-mint","reply_email":"dev-email@flywheel.local","email_preview_text":"","body":"","json_body":""}},"next_step_id":"a:0:{}","created_at":"2023-02-23 03:42:25","updated_at":"2023-02-23 03:42:25","enterance":0,"completed":0,"exited":0}]}';
		}
		if ( isset( $recipe[3] ) ) {
			$recipe[3]['automation_data'] = '{"id":"96","name":"Recover Failed Orders (Woo)","author":"1","trigger_name":"wc_order_failed","status":"draft","created_at":"2023-02-23 03:44:35","updated_at":"2023-02-23 03:44:35","steps":[{"id":"266","automation_id":"96","step_id":"t1p19","key":"wc_order_failed","type":"trigger","settings":[],"next_step_id":"rrpzh","created_at":"2023-02-23 03:44:35","updated_at":"2023-02-23 03:44:35","enterance":0,"completed":0,"exited":0},{"id":"267","automation_id":"96","step_id":"rrpzh","key":"addList","type":"action","settings":{"list_settings":{"lists":[]}},"next_step_id":"i7j43","created_at":"2023-02-23 03:44:35","updated_at":"2023-02-23 03:44:35","enterance":0,"completed":0,"exited":0},{"id":"268","automation_id":"96","step_id":"i7j43","key":"delay","type":"action","settings":{"delay_settings":{"delay":1,"unit":"minutes"}},"next_step_id":"s2iuc","created_at":"2023-02-23 03:44:35","updated_at":"2023-02-23 03:44:35","enterance":0,"completed":0,"exited":0},{"id":"269","automation_id":"96","step_id":"s2iuc","key":"sequence","type":"action","settings":{"sequence_settings":{"id":"","title":""}},"next_step_id":"a:0:{}","created_at":"2023-02-23 03:44:35","updated_at":"2023-02-23 03:44:35","enterance":0,"completed":0,"exited":0}]}';
		}
		return $recipe;
	}
	/**
	 * Add automation recipe for EDD.
	 *
	 * @param string $recipe Get Automation recipe.
	 * @return array
	 */
	public function mintmail_automation_edd_recipe_add( $recipe ) {
		if ( isset( $recipe[0] ) ) {
			$recipe[0]['automation_data'] = '{"id":"97","name":"Completed Order Follow-up (EDD)","author":"1","trigger_name":"edd_complete_purchase","status":"draft","created_at":"2023-02-23 03:52:41","updated_at":"2023-02-23 03:52:41","steps":[{"id":"270","automation_id":"97","step_id":"sbjh2","key":"edd_complete_purchase","type":"trigger","settings":{"product_settings":{"products":[]}},"next_step_id":"jpysr","created_at":"2023-02-23 03:52:41","updated_at":"2023-02-23 03:52:41","enterance":0,"completed":0,"exited":0},{"id":"271","automation_id":"97","step_id":"jpysr","key":"addList","type":"action","settings":{"list_settings":{"lists":[]}},"next_step_id":"kg0mk","created_at":"2023-02-23 03:52:41","updated_at":"2023-02-23 03:52:41","enterance":0,"completed":0,"exited":0},{"id":"272","automation_id":"97","step_id":"kg0mk","key":"sendMail","type":"action","settings":{"message_data":{"subject":"Welcome email from mint","sender_email":"dev-email@flywheel.local","sender_name":"mail-mint","reply_name":"mail-mint","reply_email":"dev-email@flywheel.local","email_preview_text":"","body":"","json_body":""}},"next_step_id":"10bqz","created_at":"2023-02-23 03:52:41","updated_at":"2023-02-23 03:52:41","enterance":0,"completed":0,"exited":0},{"id":"273","automation_id":"97","step_id":"10bqz","key":"sequence","type":"action","settings":{"sequence_settings":{"id":"","title":""}},"next_step_id":"a:0:{}","created_at":"2023-02-23 03:52:41","updated_at":"2023-02-23 03:52:41","enterance":0,"completed":0,"exited":0}]}';
		}
		if ( isset( $recipe[1] ) ) {
			$recipe[1]['automation_data'] = '{"id":"133","name":"New Customer Onboarding Emails (EDD)","author":"1","trigger_name":"edd_update_payment_status","status":"draft","created_at":"2023-02-27 02:53:27","updated_at":"2023-02-27 02:53:48","steps":[{"id":"401","automation_id":"133","step_id":"7yex4g","key":"edd_update_payment_status","type":"trigger","settings":{"status_settings":{"status":""}},"next_step_id":"5adf1","created_at":"2023-02-27 02:53:44","updated_at":"2023-02-27 02:53:48","enterance":0,"completed":0,"exited":0},{"id":"398","automation_id":"133","step_id":"5adf1","key":"addList","type":"action","settings":{"list_settings":{"lists":[]}},"next_step_id":"84dfa","created_at":"2023-02-27 02:53:27","updated_at":"2023-02-27 02:53:48","enterance":0,"completed":0,"exited":0},{"id":"399","automation_id":"133","step_id":"84dfa","key":"delay","type":"action","settings":{"delay_settings":{"delay":1,"unit":"minutes"}},"next_step_id":"e5c9b","created_at":"2023-02-27 02:53:27","updated_at":"2023-02-27 02:53:48","enterance":0,"completed":0,"exited":0},{"id":"400","automation_id":"133","step_id":"e5c9b","key":"sequence","type":"action","settings":{"sequence_settings":{"id":"","title":""}},"next_step_id":"a:0:{}","created_at":"2023-02-27 02:53:27","updated_at":"2023-02-27 02:53:48","enterance":0,"completed":0,"exited":0}]}';
		}

		return $recipe;
	}

	/**
	 * Add automation recipe for Abandoned Cart.
	 *
	 * @param string $recipe Get Automation recipe.
	 * @return array
	 */
	public function mintmail_automation_abandoned_cart_recipe( $recipe ) {
		$abandoned_cart_setting = Common::get_abandoned_cart_settings();
		$is_abandoned_enable    = !empty( $abandoned_cart_setting['enable'] ) ? $abandoned_cart_setting['enable'] : false;
		if ( !$is_abandoned_enable ) {
			return array();
		}
		if ( isset( $recipe[0] ) ) {
			$recipe[0]['automation_data'] = '{"id":"121","name":"Abandoned Cart Recovery Emails","author":"1","trigger_name":"wc_abandoned_cart","status":"draft","created_at":"2023-10-09 11:51:14","updated_at":"2023-10-09 12:00:31","steps":[{"id":"297","automation_id":"121","step_id":"a3f94","key":"wc_abandoned_cart","type":"trigger","settings":{"product_settings":{"products":[]}},"next_step_id":"ff41f","created_at":null,"updated_at":null,"automation_step_id":null,"meta_key":null,"meta_value":null,"enterance":0,"completed":0,"exited":0},{"id":"298","automation_id":"121","step_id":"ff41f","key":"delay","type":"action","settings":{"delay_settings":{"delay":"1","unit":"hours"}},"next_step_id":"94322","created_at":null,"updated_at":null,"automation_step_id":null,"meta_key":null,"meta_value":null,"enterance":0,"completed":0,"exited":0},{"id":"299","automation_id":"121","step_id":"94322","key":"sendMail","type":"action","settings":{"message_data":{"subject":"Hey {{contact.first_name}}, We have saved your cart","sender_email":"dev-email@wpengine.local","sender_name":"Custom MM","reply_name":"Custom MM","reply_email":"dev-email@wpengine.local","email_preview_text":"Complete Your Order and Enjoy Exclusive Savings!","body":"<!doctype html>\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:o=\"urn:schemas-microsoft-com:office:office\">\n\n<head>\n  <title></title>\n  <!--[if !mso]><!-->\n  <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">\n  <!--<![endif]-->\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">\n  <style type=\"text/css\">\n    #outlook a {\n      padding: 0;\n    }\n\n    body {\n      margin: 0;\n      padding: 0;\n      -webkit-text-size-adjust: 100%;\n      -ms-text-size-adjust: 100%;\n    }\n\n    table,\n    td {\n      border-collapse: collapse;\n      mso-table-lspace: 0pt;\n      mso-table-rspace: 0pt;\n    }\n\n    img {\n      border: 0;\n      height: auto;\n      line-height: 100%;\n      outline: none;\n      text-decoration: none;\n      -ms-interpolation-mode: bicubic;\n    }\n\n    p {\n      display: block;\n      margin: 13px 0;\n    }\n  </style>\n  <!--[if mso]>\n    <noscript>\n    <xml>\n    <o:OfficeDocumentSettings>\n      <o:AllowPNG/>\n      <o:PixelsPerInch>96</o:PixelsPerInch>\n    </o:OfficeDocumentSettings>\n    </xml>\n    </noscript>\n    <![endif]-->\n  <!--[if lte mso 11]>\n    <style type=\"text/css\">\n      .mj-outlook-group-fix { width:100% !important; }\n    </style>\n    <![endif]-->\n  <style type=\"text/css\">\n    @media only screen and (min-width:480px) {\n      .mj-column-per-100 {\n        width: 100% !important;\n        max-width: 100%;\n      }\n    }\n  </style>\n  <style media=\"screen and (min-width:480px)\">\n    .moz-text-html .mj-column-per-100 {\n      width: 100% !important;\n      max-width: 100%;\n    }\n  </style>\n  <style type=\"text/css\">\n  </style>\n  <style type=\"text/css\">\n  </style>\n</head>\n\n<body style=\"word-spacing:normal;background-color:#ececec;\">\n  <div class=\"mjml-body\" style=\"background-color:#ececec;\">\n    <!--[if mso | IE]><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"\" role=\"presentation\" style=\"width:600px;\" width=\"600\" bgcolor=\"#ffffff\" ><tr><td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\"><![endif]-->\n    <div style=\"background:#ffffff;background-color:#ffffff;margin:0px auto;max-width:600px;\">\n      <table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"background:#ffffff;background-color:#ffffff;width:100%;\">\n        <tbody>\n          <tr>\n            <td style=\"border:none;direction:ltr;font-size:0px;padding:0px 0px 20px 0px;text-align:center;\">\n              <!--[if mso | IE]><table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"\" width=\"600px\" ><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"\" role=\"presentation\" style=\"width:600px;\" width=\"600\" ><tr><td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\"><![endif]-->\n              <div style=\"margin:0px auto;max-width:600px;\">\n                <table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"width:100%;\">\n                  <tbody>\n                    <tr>\n                      <td style=\"direction:ltr;font-size:0px;padding:0px;text-align:left;\">\n                        <!--[if mso | IE]><table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"\" style=\"vertical-align:top;width:600px;\" ><![endif]-->\n                        <div class=\"mj-column-per-100 mj-outlook-group-fix\" style=\"font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;\">\n                          <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"vertical-align:top;\" width=\"100%\">\n                            <tbody>\n                              <tr>\n                                <td align=\"left\" style=\"font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;\">\n                                  <div style=\"font-family:Arial;font-size:14px;font-weight:400;letter-spacing:normal;line-height:1.7;text-align:left;color:#000000;\">Hi {{contact.firstName}}, <div><br></div>\n                                    <div>Looks like you left something behind! </div>\n                                    <div><br></div>\n                                    <div>We noticed you haven’t completed your purchase. </div>\n                                    <div><br></div>\n                                    <div>{{cart.items}} </div>\n                                    <div><br></div>\n                                    <div>Not to worry, there is still time to finish your checkout!</div>\n                                    <div><br></div>\n                                    <div>Click the following button to complete your purchase and have your items on their way to you.<br></div>\n                                  </div>\n                                </td>\n                              </tr>\n                            </tbody>\n                          </table>\n                        </div>\n                        <!--[if mso | IE]></td></tr></table><![endif]-->\n                      </td>\n                    </tr>\n                  </tbody>\n                </table>\n              </div>\n              <!--[if mso | IE]></td></tr></table></td></tr><tr><td class=\"\" width=\"600px\" ><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"\" role=\"presentation\" style=\"width:600px;\" width=\"600\" ><tr><td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\"><![endif]-->\n              <div style=\"margin:0px auto;max-width:600px;\">\n                <table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"width:100%;\">\n                  <tbody>\n                    <tr>\n                      <td style=\"direction:ltr;font-size:0px;padding:0px;text-align:left;\">\n                        <!--[if mso | IE]><table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"\" style=\"vertical-align:top;width:600px;\" ><![endif]-->\n                        <div class=\"mj-column-per-100 mj-outlook-group-fix\" style=\"font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;\">\n                          <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"vertical-align:top;\" width=\"100%\">\n                            <tbody>\n                              <tr>\n                                <td align=\"center\" vertical-align=\"middle\" style=\"font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;\">\n                                  <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"border-collapse:separate;line-height:100%;\">\n                                    <tbody>\n                                      <tr>\n                                        <td align=\"center\" bgcolor=\"#573bff\" role=\"presentation\" style=\"border:none;border-radius:3px;cursor:auto;font-style:normal;mso-padding-alt:10px 25px 10px 25px;text-align:center;background:#573bff;\" valign=\"middle\">\n                                          <a href=\"{{cart.recovery_url}}\" style=\"display:inline-block;background:#573bff;color:#ffffff;font-family:Arial;font-size:13px;font-style:normal;font-weight:bold;line-height:1.2;letter-spacing:normal;margin:0;text-decoration:none;text-transform:none;padding:10px 25px 10px 25px;mso-padding-alt:0px;border-radius:3px;\" target=\"_blank\"> Recover My Cart </a>\n                                        </td>\n                                      </tr>\n                                    </tbody>\n                                  </table>\n                                </td>\n                              </tr>\n                            </tbody>\n                          </table>\n                        </div>\n                        <!--[if mso | IE]></td></tr></table><![endif]-->\n                      </td>\n                    </tr>\n                  </tbody>\n                </table>\n              </div>\n              <!--[if mso | IE]></td></tr></table></td></tr><tr><td class=\"\" width=\"600px\" ><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"\" role=\"presentation\" style=\"width:600px;\" width=\"600\" ><tr><td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\"><![endif]-->\n              <div style=\"margin:0px auto;max-width:600px;\">\n                <table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"width:100%;\">\n                  <tbody>\n                    <tr>\n                      <td style=\"direction:ltr;font-size:0px;padding:0px;text-align:left;\">\n                        <!--[if mso | IE]><table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"\" style=\"vertical-align:top;width:600px;\" ><![endif]-->\n                        <div class=\"mj-column-per-100 mj-outlook-group-fix\" style=\"font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;\">\n                          <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"vertical-align:top;\" width=\"100%\">\n                            <tbody>\n                              <tr>\n                                <td align=\"left\" style=\"font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;\">\n                                  <div style=\"font-family:Arial;font-size:14px;font-weight:400;letter-spacing:normal;line-height:1.7;text-align:left;color:#000000;\">Thanks,<div>{{business.name}}</div>\n                                  </div>\n                                </td>\n                              </tr>\n                            </tbody>\n                          </table>\n                        </div>\n                        <!--[if mso | IE]></td></tr></table><![endif]-->\n                      </td>\n                    </tr>\n                  </tbody>\n                </table>\n              </div>\n              <!--[if mso | IE]></td></tr></table></td></tr></table><![endif]-->\n            </td>\n          </tr>\n        </tbody>\n      </table>\n    </div>\n    <!--[if mso | IE]></td></tr></table><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"\" role=\"presentation\" style=\"width:600px;\" width=\"600\" bgcolor=\"#ffffff\" ><tr><td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\"><![endif]-->\n    <div style=\"background:#ffffff;background-color:#ffffff;margin:0px auto;max-width:600px;\">\n      <table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"background:#ffffff;background-color:#ffffff;width:100%;\">\n        <tbody>\n          <tr>\n            <td style=\"border:none;direction:ltr;font-size:0px;padding:20px 0px 20px 0px;text-align:center;\">\n              <!--[if mso | IE]><table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"\" width=\"600px\" ><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"\" role=\"presentation\" style=\"width:600px;\" width=\"600\" ><tr><td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\"><![endif]-->\n              <div style=\"margin:0px auto;max-width:600px;\">\n                <table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"width:100%;\">\n                  <tbody>\n                    <tr>\n                      <td style=\"direction:ltr;font-size:0px;padding:0px;text-align:center;\">\n                        <!--[if mso | IE]><table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"\" style=\"vertical-align:top;width:600px;\" ><![endif]-->\n                        <div class=\"mj-column-per-100 mj-outlook-group-fix\" style=\"font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;\">\n                          <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" width=\"100%\">\n                            <tbody>\n                              <tr>\n                                <td style=\"border:none;vertical-align:top;padding:0px;\">\n                                  <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"\" width=\"100%\">\n                                    <tbody>\n                                      <tr>\n                                        <td align=\"center\" class=\"node-contenteditable-type-text node-contenteditable-idx-content.children.[1].data.value.addressTitle\" style=\"font-size:0px;padding:5px 15px;word-break:break-word;\">\n                                          <div style=\"font-family:Arial;font-size:15px;font-style:normal;font-weight:bold;letter-spacing:0px;line-height:1;text-align:center;text-decoration:none;color:#222222;\">\n                                            <div style=\"text-align: center\">Where to find us</div>\n                                            <div><br></div>\n                                            <div style=\"text-align: center;\">{{business.logo_url}}</div>\n                                            <div><br></div>\n                                            <div style=\"text-align: center;\"><span style=\"font-size: 12px;\">{{business.name}}</span></div>\n                                            <div><br></div>\n                                            <div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">{{business.address}}</span></div>\n                                            <div><br></div>\n                                            <div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">{{business.phone}}</span></div>\n                                            <div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div>\n                                            <div style=\"text-align: center;\">Email Preferences<span style=\"font-size: 10px; font-weight: 400;\"><br></span></div>\n                                            <div style=\"text-align: center;\"><br></div>\n                                            <div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">You are receiving this email because you signed up for our newsletter to receive helpful tips, product launches, and exclusive offers</span><br></div>\n                                            <div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div>\n                                            <div style=\"text-align: center;\"><a href=\"{{link.unsubscribe}}\" target=\"_blank\" tabindex=\"-1\" style=\"--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff)); font-size: 10px; font-weight: 400; color: inherit; text-decoration: none;\">Unsubscribe</a><span style=\"font-size: 10px; font-weight: 400;\"> | </span><a href=\"{{link.preference}}\" target=\"_blank\" tabindex=\"-1\" style=\"--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff)); font-size: 10px; font-weight: 400; color: inherit; text-decoration: none;\">Preference</a><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div>\n                                          </div>\n                                        </td>\n                                      </tr>\n                                    </tbody>\n                                  </table>\n                                </td>\n                              </tr>\n                            </tbody>\n                          </table>\n                        </div>\n                        <!--[if mso | IE]></td></tr></table><![endif]-->\n                      </td>\n                    </tr>\n                  </tbody>\n                </table>\n              </div>\n              <!--[if mso | IE]></td></tr></table></td></tr></table><![endif]-->\n            </td>\n          </tr>\n        </tbody>\n      </table>\n    </div>\n    <!--[if mso | IE]></td></tr></table><![endif]-->\n  </div>\n</body>\n\n</html>","json_body":{"subject":"Welcome to MINT CRM email","subTitle":"Nice to meet you!","content":{"type":"page","data":{"value":{"breakpoint":"480px","headAttributes":"","font-size":"14px","line-height":"1.7","headStyles":[],"fonts":[],"responsive":true,"font-family":"lucida Grande,Verdana,Microsoft YaHei","text-color":"#000000"}},"attributes":{"background-color":"#ececec","width":"600px","css-class":"mjml-body"},"children":[{"type":"advanced_wrapper","data":{"value":[]},"attributes":{"background-color":"#ffffff","padding":"0px 0px 20px 0px","border":"none","direction":"ltr","text-align":"center"},"children":[{"type":"advanced_text","data":{"value":{"content":"Hi {{contact.firstName}},&nbsp;<div><br></div><div>Looks like you left something behind!&nbsp;</div><div><br></div><div>We noticed you haven’t completed your purchase.&nbsp;</div><div><br></div><div>{{cart.items}}&nbsp;</div><div><br></div><div>Not to worry, there is still time to finish your checkout!</div><div><br></div><div>Click the following button to complete your purchase and have your items on their way to you.<br></div>"}},"attributes":{"padding":"10px 25px 10px 25px","align":"left","font-family":"Arial","font-size":"14px","font-weight":"400","line-height":"1.7","letter-spacing":"normal","color":"#000000"},"children":[]},{"type":"advanced_button","data":{"value":{"content":"Recover My Cart"}},"attributes":{"align":"center","font-family":"Arial","background-color":"#573bff","color":"#ffffff","font-weight":"bold","font-style":"normal","border-radius":"3px","padding":"10px 25px 10px 25px","inner-padding":"10px 25px 10px 25px","font-size":"13px","line-height":"1.2","target":"_blank","vertical-align":"middle","border":"none","text-align":"center","letter-spacing":"normal","href":"{{cart.recovery_url}}"},"children":[]},{"type":"advanced_text","data":{"value":{"content":"Thanks,<div>{{business.name}}</div>"}},"attributes":{"padding":"10px 25px 10px 25px","align":"left","font-family":"Arial","font-size":"14px","font-weight":"400","line-height":"1.7","letter-spacing":"normal","color":"#000000"},"children":[]}]},{"type":"footer_block","data":{"value":{"addressTitle":"<div style=\"text-align: center\">Where to find us</div><div><br></div><div style=\"text-align: center;\">{{business.logo_url}}</div><div><br></div><div style=\"text-align: center;\"><span style=\"font-size: 12px;\">{{business.name}}</span></div><div><br></div><div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">{{business.address}}</span></div><div><br></div><div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">{{business.phone}}</span></div><div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div><div style=\"text-align: center;\">Email Preferences<span style=\"font-size: 10px; font-weight: 400;\"><br></span></div><div style=\"text-align: center;\"><br></div><div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">You are receiving this email because you signed up for our newsletter to receive helpful tips, product launches, and exclusive offers</span><br></div><div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div><div style=\"text-align: center;\"><a href=\"{{link.unsubscribe}}\" target=\"_blank\" tabindex=\"-1\" style=\"--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff)); font-size: 10px; font-weight: 400; color: inherit; text-decoration: none;\">Unsubscribe</a><span style=\"font-size: 10px; font-weight: 400;\">&nbsp;|&nbsp;</span><a href=\"{{link.preference}}\" target=\"_blank\" tabindex=\"-1\" style=\"--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff)); font-size: 10px; font-weight: 400; color: inherit; text-decoration: none;\">Preference</a><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div>","preferenceTitle":"Email preferences","businessBasicSettings":{"business_name":"Mail Mint","phone":"","business_address":[],"logo_url":"http://rex-crm.com/wp-content/uploads/2023/10/rbl-bank-ltd-vector-logo-2022.png"},"businessImageUrl":"http://rex-crm.com/wp-content/uploads/2023/10/rbl-bank-ltd-vector-logo-2022.png","businessName":"Mail Mint","phone":"","businessSocialSettings":{"socialMedia":[]},"unsubscribe":"<a href=\"{{link.unsubscribe}}\">Unsubscribe</a> | <a href=\"{{link.preference}}\">Preference</a>","preference":"<a href=\"{{link.preference}}\">Update my preference</a>","content":"You are receiving this email because you signed up for our newsletter to receive helpful tips, product launches, and exclusive offers"}},"attributes":{"background-color":"#ffffff","title-color":"#222222","content-color":"#222222","name-color":"#222222","font-size":"15px","name-size":"12px","content-size":"10px","font-family":"Arial","name-family":"Arial","content-family":"Arial","text-decoration":"none","name-decoration":"none","content-decoration":"none","font-weight":"bold","name-weight":"bold","content-weight":"normal","align":"center","line-height":"1","name-height":"1","content-height":"1","font-style":"normal","name-style":"normal","content-style":"normal","letter-spacing":"0px","name-spacing":"0px","content-spacing":"0px","padding":"20px 0px 20px 0px"},"children":[{"type":"advanced_text","children":[],"data":{"value":{"content":"custom block title"}},"attributes":[]}]}]}}}},"next_step_id":"e4688","created_at":null,"updated_at":null,"automation_step_id":null,"meta_key":null,"meta_value":null,"enterance":0,"completed":0,"exited":0},{"id":"300","automation_id":"121","step_id":"e4688","key":"delay","type":"action","settings":{"delay_settings":{"delay":"12","unit":"hours"}},"next_step_id":"f4394","created_at":null,"updated_at":null,"automation_step_id":null,"meta_key":null,"meta_value":null,"enterance":0,"completed":0,"exited":0},{"id":"301","automation_id":"121","step_id":"f4394","key":"sendMail","type":"action","settings":{"message_data":{"subject":"Your Cart Misses You, {{contact.first_name}}! Complete Your Purchase","sender_email":"dev-email@wpengine.local","sender_name":"Custom MM","reply_name":"Custom MM","reply_email":"dev-email@wpengine.local","email_preview_text":"Still Interested? Your Items Are Waiting!","body":"<!doctype html>\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:o=\"urn:schemas-microsoft-com:office:office\">\n\n<head>\n  <title></title>\n  <!--[if !mso]><!-->\n  <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">\n  <!--<![endif]-->\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">\n  <style type=\"text/css\">\n    #outlook a {\n      padding: 0;\n    }\n\n    body {\n      margin: 0;\n      padding: 0;\n      -webkit-text-size-adjust: 100%;\n      -ms-text-size-adjust: 100%;\n    }\n\n    table,\n    td {\n      border-collapse: collapse;\n      mso-table-lspace: 0pt;\n      mso-table-rspace: 0pt;\n    }\n\n    img {\n      border: 0;\n      height: auto;\n      line-height: 100%;\n      outline: none;\n      text-decoration: none;\n      -ms-interpolation-mode: bicubic;\n    }\n\n    p {\n      display: block;\n      margin: 13px 0;\n    }\n  </style>\n  <!--[if mso]>\n    <noscript>\n    <xml>\n    <o:OfficeDocumentSettings>\n      <o:AllowPNG/>\n      <o:PixelsPerInch>96</o:PixelsPerInch>\n    </o:OfficeDocumentSettings>\n    </xml>\n    </noscript>\n    <![endif]-->\n  <!--[if lte mso 11]>\n    <style type=\"text/css\">\n      .mj-outlook-group-fix { width:100% !important; }\n    </style>\n    <![endif]-->\n  <style type=\"text/css\">\n    @media only screen and (min-width:480px) {\n      .mj-column-per-100 {\n        width: 100% !important;\n        max-width: 100%;\n      }\n    }\n  </style>\n  <style media=\"screen and (min-width:480px)\">\n    .moz-text-html .mj-column-per-100 {\n      width: 100% !important;\n      max-width: 100%;\n    }\n  </style>\n  <style type=\"text/css\">\n  </style>\n  <style type=\"text/css\">\n  </style>\n</head>\n\n<body style=\"word-spacing:normal;background-color:#ececec;\">\n  <div class=\"mjml-body\" style=\"background-color:#ececec;\">\n    <!--[if mso | IE]><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"\" role=\"presentation\" style=\"width:600px;\" width=\"600\" bgcolor=\"#ffffff\" ><tr><td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\"><![endif]-->\n    <div style=\"background:#ffffff;background-color:#ffffff;margin:0px auto;max-width:600px;\">\n      <table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"background:#ffffff;background-color:#ffffff;width:100%;\">\n        <tbody>\n          <tr>\n            <td style=\"border:none;direction:ltr;font-size:0px;padding:0px 0px 20px 0px;text-align:center;\">\n              <!--[if mso | IE]><table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"\" width=\"600px\" ><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"\" role=\"presentation\" style=\"width:600px;\" width=\"600\" ><tr><td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\"><![endif]-->\n              <div style=\"margin:0px auto;max-width:600px;\">\n                <table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"width:100%;\">\n                  <tbody>\n                    <tr>\n                      <td style=\"direction:ltr;font-size:0px;padding:0px;text-align:left;\">\n                        <!--[if mso | IE]><table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"\" style=\"vertical-align:top;width:600px;\" ><![endif]-->\n                        <div class=\"mj-column-per-100 mj-outlook-group-fix\" style=\"font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;\">\n                          <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"vertical-align:top;\" width=\"100%\">\n                            <tbody>\n                              <tr>\n                                <td align=\"left\" style=\"font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;\">\n                                  <div style=\"font-family:Arial;font-size:14px;font-weight:400;letter-spacing:normal;line-height:1.7;text-align:left;color:#000000;\">Hello {{contact.firstName}}, <div><br></div>\n                                    <div>We wanted to remind you that your cart is still holding onto the items you selected.</div>\n                                    <div><br></div>\n                                    <div>If you&#x27;re still interested, now&#x27;s the time to make them yours! </div>\n                                    <div><br></div>\n                                    <div>{{cart.items}} </div>\n                                    <div><br></div>\n                                    <div> Click below to finalize your purchase and enjoy your selected products. </div>\n                                  </div>\n                                </td>\n                              </tr>\n                            </tbody>\n                          </table>\n                        </div>\n                        <!--[if mso | IE]></td></tr></table><![endif]-->\n                      </td>\n                    </tr>\n                  </tbody>\n                </table>\n              </div>\n              <!--[if mso | IE]></td></tr></table></td></tr><tr><td class=\"\" width=\"600px\" ><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"\" role=\"presentation\" style=\"width:600px;\" width=\"600\" ><tr><td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\"><![endif]-->\n              <div style=\"margin:0px auto;max-width:600px;\">\n                <table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"width:100%;\">\n                  <tbody>\n                    <tr>\n                      <td style=\"direction:ltr;font-size:0px;padding:0px;text-align:left;\">\n                        <!--[if mso | IE]><table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"\" style=\"vertical-align:top;width:600px;\" ><![endif]-->\n                        <div class=\"mj-column-per-100 mj-outlook-group-fix\" style=\"font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;\">\n                          <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"vertical-align:top;\" width=\"100%\">\n                            <tbody>\n                              <tr>\n                                <td align=\"center\" vertical-align=\"middle\" style=\"font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;\">\n                                  <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"border-collapse:separate;line-height:100%;\">\n                                    <tbody>\n                                      <tr>\n                                        <td align=\"center\" bgcolor=\"#573bff\" role=\"presentation\" style=\"border:none;border-radius:3px;cursor:auto;font-style:normal;mso-padding-alt:10px 25px 10px 25px;text-align:center;background:#573bff;\" valign=\"middle\">\n                                          <a href=\"{{cart.recovery_url}}\" style=\"display:inline-block;background:#573bff;color:#ffffff;font-family:Arial;font-size:13px;font-style:normal;font-weight:normal;line-height:1.2;letter-spacing:normal;margin:0;text-decoration:none;text-transform:none;padding:10px 25px 10px 25px;mso-padding-alt:0px;border-radius:3px;\" target=\"_blank\"> Complete My Purchase </a>\n                                        </td>\n                                      </tr>\n                                    </tbody>\n                                  </table>\n                                </td>\n                              </tr>\n                            </tbody>\n                          </table>\n                        </div>\n                        <!--[if mso | IE]></td></tr></table><![endif]-->\n                      </td>\n                    </tr>\n                  </tbody>\n                </table>\n              </div>\n              <!--[if mso | IE]></td></tr></table></td></tr><tr><td class=\"\" width=\"600px\" ><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"\" role=\"presentation\" style=\"width:600px;\" width=\"600\" ><tr><td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\"><![endif]-->\n              <div style=\"margin:0px auto;max-width:600px;\">\n                <table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"width:100%;\">\n                  <tbody>\n                    <tr>\n                      <td style=\"direction:ltr;font-size:0px;padding:0px;text-align:left;\">\n                        <!--[if mso | IE]><table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"\" style=\"vertical-align:top;width:600px;\" ><![endif]-->\n                        <div class=\"mj-column-per-100 mj-outlook-group-fix\" style=\"font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;\">\n                          <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"vertical-align:top;\" width=\"100%\">\n                            <tbody>\n                              <tr>\n                                <td align=\"left\" style=\"font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;\">\n                                  <div style=\"font-family:Arial;font-size:14px;font-weight:400;letter-spacing:normal;line-height:1.7;text-align:left;color:#000000;\">Thanks,<div>{{business.name}}</div></div>\n    \n                </td>\n              </tr>\n            \n        </tbody>\n      </table>\n    \n      </div>\n    \n          <!--[if mso | IE]></td></tr></table><![endif]-->\n              </td>\n            </tr>\n          </tbody>\n        </table>\n        \n      </div>\n    \n      \n      <!--[if mso | IE]></td></tr></table></td></tr></table><![endif]-->\n              </td>\n            </tr>\n          </tbody>\n        </table>\n        \n      </div>\n    \n      \n      <!--[if mso | IE]></td></tr></table><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"\" role=\"presentation\" style=\"width:600px;\" width=\"600\" bgcolor=\"#ffffff\" ><tr><td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\"><![endif]-->\n    \n      \n      <div  style=\"background:#ffffff;background-color:#ffffff;margin:0px auto;max-width:600px;\">\n        \n        <table\n           align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"background:#ffffff;background-color:#ffffff;width:100%;\"\n        >\n          <tbody>\n            <tr>\n              <td\n                 style=\"border:none;direction:ltr;font-size:0px;padding:20px 0px 20px 0px;text-align:center;\"\n              >\n                <!--[if mso | IE]><table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"\" width=\"600px\" ><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"\" role=\"presentation\" style=\"width:600px;\" width=\"600\" ><tr><td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\"><![endif]-->\n    \n      \n      <div  style=\"margin:0px auto;max-width:600px;\">\n        \n        <table\n           align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"width:100%;\"\n        >\n          <tbody>\n            <tr>\n              <td\n                 style=\"direction:ltr;font-size:0px;padding:0px;text-align:center;\"\n              >\n                <!--[if mso | IE]><table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"\" style=\"vertical-align:top;width:600px;\" ><![endif]-->\n            \n      <div\n         class=\"mj-column-per-100 mj-outlook-group-fix\" style=\"font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;\"\n      >\n        \n      <table\n         border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" width=\"100%\"\n      >\n        <tbody>\n          <tr>\n            <td  style=\"border:none;vertical-align:top;padding:0px;\">\n              \n      <table\n         border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"\" width=\"100%\"\n      >\n        <tbody>\n          \n              <tr>\n                <td\n                   align=\"center\" class=\"node-contenteditable-type-text node-contenteditable-idx-content.children.[1].data.value.addressTitle\" style=\"font-size:0px;padding:5px 15px;word-break:break-word;\"\n                >\n                  \n      <div\n         style=\"font-family:Arial;font-size:15px;font-style:normal;font-weight:bold;letter-spacing:0px;line-height:1;text-align:center;text-decoration:none;color:#222222;\"\n      ><div style=\"text-align: center\">Where to find us</div><div><br></div><div style=\"text-align: center;\">{{business.logo_url}}</div>\n                                    <div><br></div>\n                                    <div style=\"text-align: center;\"><span style=\"font-size: 12px;\">{{business.name}}</span></div>\n                                    <div><br></div>\n                                    <div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">{{business.address}}</span></div>\n                                    <div><br></div>\n                                    <div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">{{business.phone}}</span></div>\n                                    <div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div>\n                                    <div style=\"text-align: center;\">Email Preferences<span style=\"font-size: 10px; font-weight: 400;\"><br></span></div>\n                                    <div style=\"text-align: center;\"><br></div>\n                                    <div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">You are receiving this email because you signed up for our newsletter to receive helpful tips, product launches, and exclusive offers</span><br></div>\n                                    <div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div>\n                                    <div style=\"text-align: center;\"><a href=\"{{link.unsubscribe}}\" target=\"_blank\" tabindex=\"-1\" style=\"--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff)); font-size: 10px; font-weight: 400; color: inherit; text-decoration: none;\">Unsubscribe</a><span style=\"font-size: 10px; font-weight: 400;\"> | </span><a href=\"{{link.preference}}\" target=\"_blank\" tabindex=\"-1\" style=\"--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff)); font-size: 10px; font-weight: 400; color: inherit; text-decoration: none;\">Preference</a><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div>\n                                  </div>\n                                </td>\n                              </tr>\n                            </tbody>\n                          </table>\n                      </td>\n                    </tr>\n                  </tbody>\n                </table>\n              </div>\n              <!--[if mso | IE]></td></tr></table><![endif]-->\n            </td>\n          </tr>\n        </tbody>\n      </table>\n    </div>\n    <!--[if mso | IE]></td></tr></table></td></tr></table><![endif]-->\n    </td>\n    </tr>\n    </tbody>\n    </table>\n  </div>\n  <!--[if mso | IE]></td></tr></table><![endif]-->\n  </div>\n</body>\n\n</html>","json_body":{"subject":"Welcome to MINT CRM email","subTitle":"Nice to meet you!","content":{"type":"page","data":{"value":{"breakpoint":"480px","headAttributes":"","font-size":"14px","line-height":"1.7","headStyles":[],"fonts":[],"responsive":true,"font-family":"lucida Grande,Verdana,Microsoft YaHei","text-color":"#000000"}},"attributes":{"background-color":"#ececec","width":"600px","css-class":"mjml-body"},"children":[{"type":"advanced_wrapper","data":{"value":[]},"attributes":{"background-color":"#ffffff","padding":"0px 0px 20px 0px","border":"none","direction":"ltr","text-align":"center"},"children":[{"type":"advanced_text","data":{"value":{"content":"Hello {{contact.firstName}},&nbsp;<div><br></div><div>We wanted to remind you that your cart is still holding onto the items you selected.</div><div><br></div><div>If you\'re still interested, now\'s the time to make them yours!&nbsp;</div><div><br></div><div>{{cart.items}}&nbsp;</div><div><br></div><div>&nbsp;Click below to finalize your purchase and enjoy your selected products.\n</div>"}},"attributes":{"padding":"10px 25px 10px 25px","align":"left","font-family":"Arial","font-size":"14px","font-weight":"400","line-height":"1.7","letter-spacing":"normal","color":"#000000"},"children":[]},{"type":"advanced_button","data":{"value":{"content":"Complete My Purchase"}},"attributes":{"align":"center","font-family":"Arial","background-color":"#573bff","color":"#ffffff","font-weight":"normal","font-style":"normal","border-radius":"3px","padding":"10px 25px 10px 25px","inner-padding":"10px 25px 10px 25px","font-size":"13px","line-height":"1.2","target":"_blank","vertical-align":"middle","border":"none","text-align":"center","letter-spacing":"normal","href":"{{cart.recovery_url}}"},"children":[]},{"type":"advanced_text","data":{"value":{"content":"Thanks,<div>{{business.name}}</div>"}},"attributes":{"padding":"10px 25px 10px 25px","align":"left","font-family":"Arial","font-size":"14px","font-weight":"400","line-height":"1.7","letter-spacing":"normal","color":"#000000"},"children":[]}]},{"type":"footer_block","data":{"value":{"addressTitle":"<div style=\"text-align: center\">Where to find us</div><div><br></div><div style=\"text-align: center;\">{{business.logo_url}}</div><div><br></div><div style=\"text-align: center;\"><span style=\"font-size: 12px;\">{{business.name}}</span></div><div><br></div><div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">{{business.address}}</span></div><div><br></div><div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">{{business.phone}}</span></div><div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div><div style=\"text-align: center;\">Email Preferences<span style=\"font-size: 10px; font-weight: 400;\"><br></span></div><div style=\"text-align: center;\"><br></div><div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">You are receiving this email because you signed up for our newsletter to receive helpful tips, product launches, and exclusive offers</span><br></div><div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div><div style=\"text-align: center;\"><a href=\"{{link.unsubscribe}}\" target=\"_blank\" tabindex=\"-1\" style=\"--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff)); font-size: 10px; font-weight: 400; color: inherit; text-decoration: none;\">Unsubscribe</a><span style=\"font-size: 10px; font-weight: 400;\">&nbsp;|&nbsp;</span><a href=\"{{link.preference}}\" target=\"_blank\" tabindex=\"-1\" style=\"--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff)); font-size: 10px; font-weight: 400; color: inherit; text-decoration: none;\">Preference</a><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div>","preferenceTitle":"Email preferences","businessBasicSettings":{"business_name":"Mail Mint","phone":"","business_address":[],"logo_url":"http://rex-crm.com/wp-content/uploads/2023/10/rbl-bank-ltd-vector-logo-2022.png"},"businessImageUrl":"http://rex-crm.com/wp-content/uploads/2023/10/rbl-bank-ltd-vector-logo-2022.png","businessName":"Mail Mint","phone":"","businessSocialSettings":{"socialMedia":[]},"unsubscribe":"<a href=\"{{link.unsubscribe}}\">Unsubscribe</a> | <a href=\"{{link.preference}}\">Preference</a>","preference":"<a href=\"{{link.preference}}\">Update my preference</a>","content":"You are receiving this email because you signed up for our newsletter to receive helpful tips, product launches, and exclusive offers"}},"attributes":{"background-color":"#ffffff","title-color":"#222222","content-color":"#222222","name-color":"#222222","font-size":"15px","name-size":"12px","content-size":"10px","font-family":"Arial","name-family":"Arial","content-family":"Arial","text-decoration":"none","name-decoration":"none","content-decoration":"none","font-weight":"bold","name-weight":"bold","content-weight":"normal","align":"center","line-height":"1","name-height":"1","content-height":"1","font-style":"normal","name-style":"normal","content-style":"normal","letter-spacing":"0px","name-spacing":"0px","content-spacing":"0px","padding":"20px 0px 20px 0px"},"children":[{"type":"advanced_text","children":[],"data":{"value":{"content":"custom block title"}},"attributes":[]}]}]}}}},"next_step_id":"df68c","created_at":null,"updated_at":null,"automation_step_id":null,"meta_key":null,"meta_value":null,"enterance":0,"completed":0,"exited":0},{"id":"302","automation_id":"121","step_id":"df68c","key":"delay","type":"action","settings":{"delay_settings":{"delay":"24","unit":"hours"}},"next_step_id":"612c5","created_at":null,"updated_at":null,"automation_step_id":null,"meta_key":null,"meta_value":null,"enterance":0,"completed":0,"exited":0},{"id":"303","automation_id":"121","step_id":"612c5","key":"sendMail","type":"action","settings":{"message_data":{"subject":"Last Chance: Your Cart Expires Soon!","sender_email":"dev-email@wpengine.local","sender_name":"Custom MM","reply_name":"Custom MM","reply_email":"dev-email@wpengine.local","email_preview_text":"Hurry, Your Cart Items Won\'t Be Reserved Forever","body":"<!doctype html>\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:o=\"urn:schemas-microsoft-com:office:office\">\n\n<head>\n  <title></title>\n  <!--[if !mso]><!-->\n  <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">\n  <!--<![endif]-->\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">\n  <style type=\"text/css\">\n    #outlook a {\n      padding: 0;\n    }\n\n    body {\n      margin: 0;\n      padding: 0;\n      -webkit-text-size-adjust: 100%;\n      -ms-text-size-adjust: 100%;\n    }\n\n    table,\n    td {\n      border-collapse: collapse;\n      mso-table-lspace: 0pt;\n      mso-table-rspace: 0pt;\n    }\n\n    img {\n      border: 0;\n      height: auto;\n      line-height: 100%;\n      outline: none;\n      text-decoration: none;\n      -ms-interpolation-mode: bicubic;\n    }\n\n    p {\n      display: block;\n      margin: 13px 0;\n    }\n  </style>\n  <!--[if mso]>\n    <noscript>\n    <xml>\n    <o:OfficeDocumentSettings>\n      <o:AllowPNG/>\n      <o:PixelsPerInch>96</o:PixelsPerInch>\n    </o:OfficeDocumentSettings>\n    </xml>\n    </noscript>\n    <![endif]-->\n  <!--[if lte mso 11]>\n    <style type=\"text/css\">\n      .mj-outlook-group-fix { width:100% !important; }\n    </style>\n    <![endif]-->\n  <style type=\"text/css\">\n    @media only screen and (min-width:480px) {\n      .mj-column-per-100 {\n        width: 100% !important;\n        max-width: 100%;\n      }\n    }\n  </style>\n  <style media=\"screen and (min-width:480px)\">\n    .moz-text-html .mj-column-per-100 {\n      width: 100% !important;\n      max-width: 100%;\n    }\n  </style>\n  <style type=\"text/css\">\n  </style>\n  <style type=\"text/css\">\n  </style>\n</head>\n\n<body style=\"word-spacing:normal;background-color:#ececec;\">\n  <div class=\"mjml-body\" style=\"background-color:#ececec;\">\n    <!--[if mso | IE]><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"\" role=\"presentation\" style=\"width:600px;\" width=\"600\" bgcolor=\"#ffffff\" ><tr><td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\"><![endif]-->\n    <div style=\"background:#ffffff;background-color:#ffffff;margin:0px auto;max-width:600px;\">\n      <table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"background:#ffffff;background-color:#ffffff;width:100%;\">\n        <tbody>\n          <tr>\n            <td style=\"border:none;direction:ltr;font-size:0px;padding:0px 0px 20px 0px;text-align:center;\">\n              <!--[if mso | IE]><table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"\" width=\"600px\" ><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"\" role=\"presentation\" style=\"width:600px;\" width=\"600\" ><tr><td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\"><![endif]-->\n              <div style=\"margin:0px auto;max-width:600px;\">\n                <table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"width:100%;\">\n                  <tbody>\n                    <tr>\n                      <td style=\"direction:ltr;font-size:0px;padding:0px;text-align:left;\">\n                        <!--[if mso | IE]><table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"\" style=\"vertical-align:top;width:600px;\" ><![endif]-->\n                        <div class=\"mj-column-per-100 mj-outlook-group-fix\" style=\"font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;\">\n                          <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"vertical-align:top;\" width=\"100%\">\n                            <tbody>\n                              <tr>\n                                <td align=\"left\" style=\"font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;\">\n                                  <div style=\"font-family:Arial;font-size:14px;font-weight:400;letter-spacing:normal;line-height:1.7;text-align:left;color:#000000;\">Dear {{contact.firstName}},<div><br></div>\n                                    <div>This is your final reminder about the items in your cart. They won&#x27;t stay reserved for much longer!</div>\n                                    <div><br></div>\n                                    <div>If you&#x27;re ready to make these items yours, act now.</div>\n                                    <div><br></div>\n                                    <div>{{cart.items}} </div>\n                                    <div><br></div>\n                                    <div>Complete your order by clicking the link below before your cart expires. Thanks for considering us!</div>\n                                  </div>\n                                </td>\n                              </tr>\n                            </tbody>\n                          </table>\n                        </div>\n                        <!--[if mso | IE]></td></tr></table><![endif]-->\n                      </td>\n                    </tr>\n                  </tbody>\n                </table>\n              </div>\n              <!--[if mso | IE]></td></tr></table></td></tr><tr><td class=\"\" width=\"600px\" ><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"\" role=\"presentation\" style=\"width:600px;\" width=\"600\" ><tr><td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\"><![endif]-->\n              <div style=\"margin:0px auto;max-width:600px;\">\n                <table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"width:100%;\">\n                  <tbody>\n                    <tr>\n                      <td style=\"direction:ltr;font-size:0px;padding:0px;text-align:left;\">\n                        <!--[if mso | IE]><table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"\" style=\"vertical-align:top;width:600px;\" ><![endif]-->\n                        <div class=\"mj-column-per-100 mj-outlook-group-fix\" style=\"font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;\">\n                          <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"vertical-align:top;\" width=\"100%\">\n                            <tbody>\n                              <tr>\n                                <td align=\"center\" vertical-align=\"middle\" style=\"font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;\">\n                                  <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"border-collapse:separate;line-height:100%;\">\n                                    <tbody>\n                                      <tr>\n                                        <td align=\"center\" bgcolor=\"#573bff\" role=\"presentation\" style=\"border:none;border-radius:3px;cursor:auto;font-style:normal;mso-padding-alt:10px 25px 10px 25px;text-align:center;background:#573bff;\" valign=\"middle\">\n                                          <a href=\"{{cart.recovery_url}}\" style=\"display:inline-block;background:#573bff;color:#ffffff;font-family:Arial;font-size:13px;font-style:normal;font-weight:normal;line-height:1.2;letter-spacing:normal;margin:0;text-decoration:none;text-transform:none;padding:10px 25px 10px 25px;mso-padding-alt:0px;border-radius:3px;\" target=\"_blank\"> Finalize My Order </a>\n                                        </td>\n                                      </tr>\n                                    </tbody>\n                                  </table>\n                                </td>\n                              </tr>\n                            </tbody>\n                          </table>\n                        </div>\n                        <!--[if mso | IE]></td></tr></table><![endif]-->\n                      </td>\n                    </tr>\n                  </tbody>\n                </table>\n              </div>\n              <!--[if mso | IE]></td></tr></table></td></tr><tr><td class=\"\" width=\"600px\" ><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"\" role=\"presentation\" style=\"width:600px;\" width=\"600\" ><tr><td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\"><![endif]-->\n              <div style=\"margin:0px auto;max-width:600px;\">\n                <table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"width:100%;\">\n                  <tbody>\n                    <tr>\n                      <td style=\"direction:ltr;font-size:0px;padding:0px;text-align:left;\">\n                        <!--[if mso | IE]><table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"\" style=\"vertical-align:top;width:600px;\" ><![endif]-->\n                        <div class=\"mj-column-per-100 mj-outlook-group-fix\" style=\"font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;\">\n                          <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"vertical-align:top;\" width=\"100%\">\n                            <tbody>\n                              <tr>\n                                <td align=\"left\" style=\"font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;\">\n                                  <div style=\"font-family:Arial;font-size:14px;font-weight:400;letter-spacing:normal;line-height:1.7;text-align:left;color:#000000;\">Best regards, <div>{{business.name}}</div>\n                                  </div>\n                                </td>\n                              </tr>\n                            </tbody>\n                          </table>\n                        </div>\n                        <!--[if mso | IE]></td></tr></table><![endif]-->\n                      </td>\n                    </tr>\n                  </tbody>\n                </table>\n              </div>\n              <!--[if mso | IE]></td></tr></table></td></tr></table><![endif]-->\n            </td>\n          </tr>\n        </tbody>\n      </table>\n    </div>\n    <!--[if mso | IE]></td></tr></table><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"\" role=\"presentation\" style=\"width:600px;\" width=\"600\" bgcolor=\"#ffffff\" ><tr><td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\"><![endif]-->\n    <div style=\"background:#ffffff;background-color:#ffffff;margin:0px auto;max-width:600px;\">\n      <table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"background:#ffffff;background-color:#ffffff;width:100%;\">\n        <tbody>\n          <tr>\n            <td style=\"border:none;direction:ltr;font-size:0px;padding:20px 0px 20px 0px;text-align:center;\">\n              <!--[if mso | IE]><table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"\" width=\"600px\" ><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"\" role=\"presentation\" style=\"width:600px;\" width=\"600\" ><tr><td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\"><![endif]-->\n              <div style=\"margin:0px auto;max-width:600px;\">\n                <table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"width:100%;\">\n                  <tbody>\n                    <tr>\n                      <td style=\"direction:ltr;font-size:0px;padding:0px;text-align:center;\">\n                        <!--[if mso | IE]><table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"\" style=\"vertical-align:top;width:600px;\" ><![endif]-->\n                        <div class=\"mj-column-per-100 mj-outlook-group-fix\" style=\"font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;\">\n                          <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" width=\"100%\">\n                            <tbody>\n                              <tr>\n                                <td style=\"border:none;vertical-align:top;padding:0px;\">\n                                  <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"\" width=\"100%\">\n                                    <tbody>\n                                      <tr>\n                                        <td align=\"center\" class=\"node-contenteditable-type-text node-contenteditable-idx-content.children.[1].data.value.addressTitle\" style=\"font-size:0px;padding:5px 15px;word-break:break-word;\">\n                                          <div style=\"font-family:Arial;font-size:15px;font-style:normal;font-weight:bold;letter-spacing:0px;line-height:1;text-align:center;text-decoration:none;color:#222222;\">\n                                            <div style=\"text-align: center\">Where to find us</div>\n                                            <div><br></div>\n                                            <div style=\"text-align: center;\">{{business.logo_url}}</div>\n                                            <div><br></div>\n                                            <div style=\"text-align: center;\"><span style=\"font-size: 12px;\">{{business.name}}</span></div>\n                                            <div><br></div>\n                                            <div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">{{business.address}}</span></div>\n                                            <div><br></div>\n                                            <div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">{{business.phone}}</span></div>\n                                            <div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div>\n                                            <div style=\"text-align: center;\">Email Preferences<span style=\"font-size: 10px; font-weight: 400;\"><br></span></div>\n                                            <div style=\"text-align: center;\"><br></div>\n                                            <div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">You are receiving this email because you signed up for our newsletter to receive helpful tips, product launches, and exclusive offers</span><br></div>\n                                            <div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div>\n                                            <div style=\"text-align: center;\"><a href=\"{{link.unsubscribe}}\" target=\"_blank\" tabindex=\"-1\" style=\"--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff)); font-size: 10px; font-weight: 400; color: inherit; text-decoration: none;\">Unsubscribe</a><span style=\"font-size: 10px; font-weight: 400;\"> | </span><a href=\"{{link.preference}}\" target=\"_blank\" tabindex=\"-1\" style=\"--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff)); font-size: 10px; font-weight: 400; color: inherit; text-decoration: none;\">Preference</a><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div>\n                                          </div>\n                                        </td>\n                                      </tr>\n                                    </tbody>\n                                  </table>\n                                </td>\n                              </tr>\n                            </tbody>\n                          </table>\n                        </div>\n                        <!--[if mso | IE]></td></tr></table><![endif]-->\n                      </td>\n                    </tr>\n                  </tbody>\n                </table>\n              </div>\n              <!--[if mso | IE]></td></tr></table></td></tr></table><![endif]-->\n            </td>\n          </tr>\n        </tbody>\n      </table>\n    </div>\n    <!--[if mso | IE]></td></tr></table><![endif]-->\n  </div>\n</body>\n\n</html>","json_body":{"subject":"Welcome to MINT CRM email","subTitle":"Nice to meet you!","content":{"type":"page","data":{"value":{"breakpoint":"480px","headAttributes":"","font-size":"14px","line-height":"1.7","headStyles":[],"fonts":[],"responsive":true,"font-family":"lucida Grande,Verdana,Microsoft YaHei","text-color":"#000000"}},"attributes":{"background-color":"#ececec","width":"600px","css-class":"mjml-body"},"children":[{"type":"advanced_wrapper","data":{"value":[]},"attributes":{"background-color":"#ffffff","padding":"0px 0px 20px 0px","border":"none","direction":"ltr","text-align":"center"},"children":[{"type":"advanced_text","data":{"value":{"content":"Dear {{contact.firstName}},<div><br></div><div>This is your final reminder about the items in your cart. They won\'t stay reserved for much longer!</div><div><br></div><div>If you\'re ready to make these items yours, act now.</div><div><br></div><div>{{cart.items}}&nbsp;</div><div><br></div><div>Complete your order by clicking the link below before your cart expires. Thanks for considering us!</div>"}},"attributes":{"padding":"10px 25px 10px 25px","align":"left","font-family":"Arial","font-size":"14px","font-weight":"400","line-height":"1.7","letter-spacing":"normal","color":"#000000"},"children":[]},{"type":"advanced_button","data":{"value":{"content":"Finalize My Order"}},"attributes":{"align":"center","font-family":"Arial","background-color":"#573bff","color":"#ffffff","font-weight":"normal","font-style":"normal","border-radius":"3px","padding":"10px 25px 10px 25px","inner-padding":"10px 25px 10px 25px","font-size":"13px","line-height":"1.2","target":"_blank","vertical-align":"middle","border":"none","text-align":"center","letter-spacing":"normal","href":"{{cart.recovery_url}}"},"children":[]},{"type":"advanced_text","data":{"value":{"content":"Best regards,&nbsp;<div>{{business.name}}</div>"}},"attributes":{"padding":"10px 25px 10px 25px","align":"left","font-family":"Arial","font-size":"14px","font-weight":"400","line-height":"1.7","letter-spacing":"normal","color":"#000000"},"children":[]}]},{"type":"footer_block","data":{"value":{"addressTitle":"<div style=\"text-align: center\">Where to find us</div><div><br></div><div style=\"text-align: center;\">{{business.logo_url}}</div><div><br></div><div style=\"text-align: center;\"><span style=\"font-size: 12px;\">{{business.name}}</span></div><div><br></div><div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">{{business.address}}</span></div><div><br></div><div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">{{business.phone}}</span></div><div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div><div style=\"text-align: center;\">Email Preferences<span style=\"font-size: 10px; font-weight: 400;\"><br></span></div><div style=\"text-align: center;\"><br></div><div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">You are receiving this email because you signed up for our newsletter to receive helpful tips, product launches, and exclusive offers</span><br></div><div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div><div style=\"text-align: center;\"><a href=\"{{link.unsubscribe}}\" target=\"_blank\" tabindex=\"-1\" style=\"--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff)); font-size: 10px; font-weight: 400; color: inherit; text-decoration: none;\">Unsubscribe</a><span style=\"font-size: 10px; font-weight: 400;\">&nbsp;|&nbsp;</span><a href=\"{{link.preference}}\" target=\"_blank\" tabindex=\"-1\" style=\"--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff)); font-size: 10px; font-weight: 400; color: inherit; text-decoration: none;\">Preference</a><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div>","preferenceTitle":"Email preferences","businessBasicSettings":{"business_name":"Mail Mint","phone":"","business_address":[],"logo_url":"http://rex-crm.com/wp-content/uploads/2023/10/rbl-bank-ltd-vector-logo-2022.png"},"businessImageUrl":"http://rex-crm.com/wp-content/uploads/2023/10/rbl-bank-ltd-vector-logo-2022.png","businessName":"Mail Mint","phone":"","businessSocialSettings":{"socialMedia":[]},"unsubscribe":"<a href=\"{{link.unsubscribe}}\">Unsubscribe</a> | <a href=\"{{link.preference}}\">Preference</a>","preference":"<a href=\"{{link.preference}}\">Update my preference</a>","content":"You are receiving this email because you signed up for our newsletter to receive helpful tips, product launches, and exclusive offers"}},"attributes":{"background-color":"#ffffff","title-color":"#222222","content-color":"#222222","name-color":"#222222","font-size":"15px","name-size":"12px","content-size":"10px","font-family":"Arial","name-family":"Arial","content-family":"Arial","text-decoration":"none","name-decoration":"none","content-decoration":"none","font-weight":"bold","name-weight":"bold","content-weight":"normal","align":"center","line-height":"1","name-height":"1","content-height":"1","font-style":"normal","name-style":"normal","content-style":"normal","letter-spacing":"0px","name-spacing":"0px","content-spacing":"0px","padding":"20px 0px 20px 0px"},"children":[{"type":"advanced_text","children":[],"data":{"value":{"content":"custom block title"}},"attributes":[]}]}]}}}},"next_step_id":"a:0:{}","created_at":null,"updated_at":null,"automation_step_id":null,"meta_key":null,"meta_value":null,"enterance":0,"completed":0,"exited":0}]}';
		}
		if ( isset( $recipe[1] ) ) {
			$recipe[1]['automation_data'] = '{"id":"124","name":"Successful Cart Recovery","author":"1","trigger_name":"wc_abandoned_cart_recovered","status":"draft","created_at":"2023-10-09 12:46:19","updated_at":"2023-10-09 12:47:07","steps":[{"id":"314","automation_id":"124","step_id":"2630c","key":"wc_abandoned_cart_recovered","type":"trigger","settings":[],"next_step_id":"b403a","created_at":null,"updated_at":null,"automation_step_id":null,"meta_key":null,"meta_value":null,"enterance":0,"completed":0,"exited":0},{"id":"315","automation_id":"124","step_id":"b403a","key":"delay","type":"action","settings":{"delay_settings":{"delay":"30","unit":"minutes"}},"next_step_id":"c00f2","created_at":null,"updated_at":null,"automation_step_id":null,"meta_key":null,"meta_value":null,"enterance":0,"completed":0,"exited":0},{"id":"316","automation_id":"124","step_id":"c00f2","key":"sendMail","type":"action","settings":{"message_data":{"subject":"Thank You for Completing Your Purchase, {{contact.first_name}}!","sender_email":"dev-email@wpengine.local","sender_name":"Custom MM","reply_name":"Custom MM","reply_email":"dev-email@wpengine.local","email_preview_text":"Your Order is Confirmed - Thanks for Choosing Us!","body":"<!doctype html>\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:o=\"urn:schemas-microsoft-com:office:office\">\n\n<head>\n  <title></title>\n  <!--[if !mso]><!-->\n  <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">\n  <!--<![endif]-->\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">\n  <style type=\"text/css\">\n    #outlook a {\n      padding: 0;\n    }\n\n    body {\n      margin: 0;\n      padding: 0;\n      -webkit-text-size-adjust: 100%;\n      -ms-text-size-adjust: 100%;\n    }\n\n    table,\n    td {\n      border-collapse: collapse;\n      mso-table-lspace: 0pt;\n      mso-table-rspace: 0pt;\n    }\n\n    img {\n      border: 0;\n      height: auto;\n      line-height: 100%;\n      outline: none;\n      text-decoration: none;\n      -ms-interpolation-mode: bicubic;\n    }\n\n    p {\n      display: block;\n      margin: 13px 0;\n    }\n  </style>\n  <!--[if mso]>\n    <noscript>\n    <xml>\n    <o:OfficeDocumentSettings>\n      <o:AllowPNG/>\n      <o:PixelsPerInch>96</o:PixelsPerInch>\n    </o:OfficeDocumentSettings>\n    </xml>\n    </noscript>\n    <![endif]-->\n  <!--[if lte mso 11]>\n    <style type=\"text/css\">\n      .mj-outlook-group-fix { width:100% !important; }\n    </style>\n    <![endif]-->\n  <style type=\"text/css\">\n    @media only screen and (min-width:480px) {\n      .mj-column-per-100 {\n        width: 100% !important;\n        max-width: 100%;\n      }\n    }\n  </style>\n  <style media=\"screen and (min-width:480px)\">\n    .moz-text-html .mj-column-per-100 {\n      width: 100% !important;\n      max-width: 100%;\n    }\n  </style>\n  <style type=\"text/css\">\n  </style>\n  <style type=\"text/css\">\n  </style>\n</head>\n\n<body style=\"word-spacing:normal;background-color:#ececec;\">\n  <div class=\"mjml-body\" style=\"background-color:#ececec;\">\n    <!--[if mso | IE]><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"\" role=\"presentation\" style=\"width:600px;\" width=\"600\" bgcolor=\"#ffffff\" ><tr><td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\"><![endif]-->\n    <div style=\"background:#ffffff;background-color:#ffffff;margin:0px auto;max-width:600px;\">\n      <table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"background:#ffffff;background-color:#ffffff;width:100%;\">\n        <tbody>\n          <tr>\n            <td style=\"border:none;direction:ltr;font-size:0px;padding:0px 0px 20px 0px;text-align:center;\">\n              <!--[if mso | IE]><table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"\" width=\"600px\" ><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"\" role=\"presentation\" style=\"width:600px;\" width=\"600\" ><tr><td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\"><![endif]-->\n              <div style=\"margin:0px auto;max-width:600px;\">\n                <table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"width:100%;\">\n                  <tbody>\n                    <tr>\n                      <td style=\"direction:ltr;font-size:0px;padding:0px;text-align:left;\">\n                        <!--[if mso | IE]><table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"\" style=\"vertical-align:top;width:600px;\" ><![endif]-->\n                        <div class=\"mj-column-per-100 mj-outlook-group-fix\" style=\"font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;\">\n                          <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"vertical-align:top;\" width=\"100%\">\n                            <tbody>\n                              <tr>\n                                <td align=\"left\" style=\"font-size:0px;padding:10px 25px 10px 25px;word-break:break-word;\">\n                                  <div style=\"font-family:Arial;font-size:14px;font-weight:400;letter-spacing:normal;line-height:1.7;text-align:left;color:#000000;\">Dear {{contact.firstName}},<div><br></div>\n                                    <div>Thank you for choosing [Your Brand]!</div>\n                                    <div><br></div>\n                                    <div>Your order is confirmed, and we&#x27;re excited to have you as a valued customer. </div>\n                                    <div><br></div>\n                                    <div>We appreciate your trust in us and look forward to delivering an exceptional experience. </div>\n                                    <div> If you have any questions or need assistance, feel free to reply to this email or reach out to our customer support team at [Customer Support Email/Phone].</div>\n                                    <div><br></div>\n                                    <div>Thanks again for your support! </div>\n                                    <div><span style=\"word-spacing: normal;\"><br></span></div>\n                                    <div><span style=\"word-spacing: normal;\">Best regards,</span></div>\n                                    <div>{{business.name}}</div>\n                                  </div>\n                                </td>\n                              </tr>\n                            </tbody>\n                          </table>\n                        </div>\n                        <!--[if mso | IE]></td></tr></table><![endif]-->\n                      </td>\n                    </tr>\n                  </tbody>\n                </table>\n              </div>\n              <!--[if mso | IE]></td></tr></table></td></tr></table><![endif]-->\n            </td>\n          </tr>\n        </tbody>\n      </table>\n    </div>\n    <!--[if mso | IE]></td></tr></table><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"\" role=\"presentation\" style=\"width:600px;\" width=\"600\" bgcolor=\"#ffffff\" ><tr><td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\"><![endif]-->\n    <div style=\"background:#ffffff;background-color:#ffffff;margin:0px auto;max-width:600px;\">\n      <table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"background:#ffffff;background-color:#ffffff;width:100%;\">\n        <tbody>\n          <tr>\n            <td style=\"border:none;direction:ltr;font-size:0px;padding:20px 0px 20px 0px;text-align:center;\">\n              <!--[if mso | IE]><table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"\" width=\"600px\" ><table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"\" role=\"presentation\" style=\"width:600px;\" width=\"600\" ><tr><td style=\"line-height:0px;font-size:0px;mso-line-height-rule:exactly;\"><![endif]-->\n              <div style=\"margin:0px auto;max-width:600px;\">\n                <table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"width:100%;\">\n                  <tbody>\n                    <tr>\n                      <td style=\"direction:ltr;font-size:0px;padding:0px;text-align:center;\">\n                        <!--[if mso | IE]><table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"\" style=\"vertical-align:top;width:600px;\" ><![endif]-->\n                        <div class=\"mj-column-per-100 mj-outlook-group-fix\" style=\"font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;\">\n                          <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" width=\"100%\">\n                            <tbody>\n                              <tr>\n                                <td style=\"border:none;vertical-align:top;padding:0px;\">\n                                  <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" style=\"\" width=\"100%\">\n                                    <tbody>\n                                      <tr>\n                                        <td align=\"center\" class=\"node-contenteditable-type-text node-contenteditable-idx-content.children.[1].data.value.addressTitle\" style=\"font-size:0px;padding:5px 15px;word-break:break-word;\">\n                                          <div style=\"font-family:Arial;font-size:15px;font-style:normal;font-weight:bold;letter-spacing:0px;line-height:1;text-align:center;text-decoration:none;color:#222222;\">\n                                            <div style=\"text-align: center\">Where to find us</div>\n                                            <div><br></div>\n                                            <div style=\"text-align: center;\">{{business.logo_url}}</div>\n                                            <div><br></div>\n                                            <div style=\"text-align: center;\"><span style=\"font-size: 12px;\">{{business.name}}</span></div>\n                                            <div><br></div>\n                                            <div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">{{business.address}}</span></div>\n                                            <div><br></div>\n                                            <div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">{{business.phone}}</span></div>\n                                            <div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div>\n                                            <div style=\"text-align: center;\">Email Preferences<span style=\"font-size: 10px; font-weight: 400;\"><br></span></div>\n                                            <div style=\"text-align: center;\"><br></div>\n                                            <div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">You are receiving this email because you signed up for our newsletter to receive helpful tips, product launches, and exclusive offers</span><br></div>\n                                            <div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div>\n                                            <div style=\"text-align: center;\"><a href=\"{{link.unsubscribe}}\" target=\"_blank\" tabindex=\"-1\" style=\"--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff)); font-size: 10px; font-weight: 400; color: inherit; text-decoration: none;\">Unsubscribe</a><span style=\"font-size: 10px; font-weight: 400;\"> | </span><a href=\"{{link.preference}}\" target=\"_blank\" tabindex=\"-1\" style=\"--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff)); font-size: 10px; font-weight: 400; color: inherit; text-decoration: none;\">Preference</a><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div>\n                                          </div>\n                                        </td>\n                                      </tr>\n                                    </tbody>\n                                  </table>\n                                </td>\n                              </tr>\n                            </tbody>\n                          </table>\n                        </div>\n                        <!--[if mso | IE]></td></tr></table><![endif]-->\n                      </td>\n                    </tr>\n                  </tbody>\n                </table>\n              </div>\n              <!--[if mso | IE]></td></tr></table></td></tr></table><![endif]-->\n            </td>\n          </tr>\n        </tbody>\n      </table>\n    </div>\n    <!--[if mso | IE]></td></tr></table><![endif]-->\n  </div>\n</body>\n\n</html>","json_body":{"subject":"Welcome to MINT CRM email","subTitle":"Nice to meet you!","content":{"type":"page","data":{"value":{"breakpoint":"480px","headAttributes":"","font-size":"14px","line-height":"1.7","headStyles":[],"fonts":[],"responsive":true,"font-family":"lucida Grande,Verdana,Microsoft YaHei","text-color":"#000000"}},"attributes":{"background-color":"#ececec","width":"600px","css-class":"mjml-body"},"children":[{"type":"advanced_wrapper","data":{"value":[]},"attributes":{"background-color":"#ffffff","padding":"0px 0px 20px 0px","border":"none","direction":"ltr","text-align":"center"},"children":[{"type":"advanced_text","data":{"value":{"content":"Dear {{contact.firstName}},<div><br></div><div>Thank you for choosing [Your Brand]!</div><div><br></div><div>Your order is confirmed, and we\'re excited to have you as a valued customer.&nbsp;</div><div><br></div><div>We appreciate your trust in us and look forward to delivering an exceptional experience.&nbsp;</div><div>&nbsp;If you have any questions or need assistance, feel free to reply to this email or reach out to our customer support team at [Customer Support Email/Phone].</div><div><br></div><div>Thanks again for your support!&nbsp;</div><div><span style=\"word-spacing: normal;\"><br></span></div><div><span style=\"word-spacing: normal;\">Best regards,</span></div><div>{{business.name}}</div>"}},"attributes":{"padding":"10px 25px 10px 25px","align":"left","font-family":"Arial","font-size":"14px","font-weight":"400","line-height":"1.7","letter-spacing":"normal","color":"#000000"},"children":[]}]},{"type":"footer_block","data":{"value":{"addressTitle":"<div style=\"text-align: center\">Where to find us</div><div><br></div><div style=\"text-align: center;\">{{business.logo_url}}</div><div><br></div><div style=\"text-align: center;\"><span style=\"font-size: 12px;\">{{business.name}}</span></div><div><br></div><div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">{{business.address}}</span></div><div><br></div><div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">{{business.phone}}</span></div><div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div><div style=\"text-align: center;\">Email Preferences<span style=\"font-size: 10px; font-weight: 400;\"><br></span></div><div style=\"text-align: center;\"><br></div><div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\">You are receiving this email because you signed up for our newsletter to receive helpful tips, product launches, and exclusive offers</span><br></div><div style=\"text-align: center;\"><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div><div style=\"text-align: center;\"><a href=\"{{link.unsubscribe}}\" target=\"_blank\" tabindex=\"-1\" style=\"--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff)); font-size: 10px; font-weight: 400; color: inherit; text-decoration: none;\">Unsubscribe</a><span style=\"font-size: 10px; font-weight: 400;\">&nbsp;|&nbsp;</span><a href=\"{{link.preference}}\" target=\"_blank\" tabindex=\"-1\" style=\"--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff)); font-size: 10px; font-weight: 400; color: inherit; text-decoration: none;\">Preference</a><span style=\"font-size: 10px; font-weight: 400;\"><br></span></div>","preferenceTitle":"Email preferences","businessBasicSettings":{"business_name":"Mail Mint","phone":"","business_address":{"address_line_1":"304 E Prune Ave","address_line_2":"Lompoc","city":"California(CA)","state":"","postal":"93436","country":"American Samoa"},"logo_url":"http://rex-crm.com/wp-content/uploads/2023/10/rbl-bank-ltd-vector-logo-2022.png"},"businessImageUrl":"http://rex-crm.com/wp-content/uploads/2023/10/rbl-bank-ltd-vector-logo-2022.png","businessName":"Mail Mint","address":"304 E Prune Ave","phone":"","businessSocialSettings":{"socialMedia":[]},"unsubscribe":"<a href=\"{{link.unsubscribe}}\">Unsubscribe</a> | <a href=\"{{link.preference}}\">Preference</a>","preference":"<a href=\"{{link.preference}}\">Update my preference</a>","content":"You are receiving this email because you signed up for our newsletter to receive helpful tips, product launches, and exclusive offers"}},"attributes":{"background-color":"#ffffff","title-color":"#222222","content-color":"#222222","name-color":"#222222","font-size":"15px","name-size":"12px","content-size":"10px","font-family":"Arial","name-family":"Arial","content-family":"Arial","text-decoration":"none","name-decoration":"none","content-decoration":"none","font-weight":"bold","name-weight":"bold","content-weight":"normal","align":"center","line-height":"1","name-height":"1","content-height":"1","font-style":"normal","name-style":"normal","content-style":"normal","letter-spacing":"0px","name-spacing":"0px","content-spacing":"0px","padding":"20px 0px 20px 0px"},"children":[{"type":"advanced_text","children":[],"data":{"value":{"content":"custom block title"}},"attributes":[]}]}]}}}},"next_step_id":"a:0:{}","created_at":null,"updated_at":null,"automation_step_id":null,"meta_key":null,"meta_value":null,"enterance":0,"completed":0,"exited":0}]}';
		}
		return $recipe;
	}

	public function mintmail_automation_mailmint_pro_recipe( $recipe ) {
		if ( isset( $recipe[0] ) ) {
			$recipe[0]['automation_data'] = '{"id":"13","name":"Automate Birthday Wishes","author":"1","trigger_name":"mint_anniversary_reminder","status":"draft","created_at":"2024-08-22 14:56:56","updated_at":"2024-08-22 15:49:34","steps":[{"id":"387","automation_id":"92","step_id":"phrt8l","key":"mint_anniversary_reminder","type":"trigger","settings":{"anniversary":{"attribute":{"param":"date_of_birth","name":"Date of Birth","condition_label":"is today","condition_value":"is_today","value":"","action_type":"none"},"time_to_check":"2024-08-22T00:00:00","lists":[],"tags":[],"segments":[]}},"next_step_id":"t9fzm","created_at":null,"updated_at":null,"automation_step_id":null,"meta_key":null,"meta_value":null,"enterance":0,"completed":0,"exited":0},{"id":"388","automation_id":"92","step_id":"t9fzm","key":"delay","type":"action","settings":{"delay_settings":{"delay":1,"unit":"minutes"}},"next_step_id":"ttq6v","created_at":null,"updated_at":null,"automation_step_id":null,"meta_key":null,"meta_value":null,"enterance":0,"completed":0,"exited":0},{"id":"389","automation_id":"92","step_id":"ttq6v","key":"sendMail","type":"action","settings":{"message_data":{"subject":"Happy Birthday! A Special Treat Just for You 🎉","sender_email":"","sender_name":"","reply_name":"","reply_email":"","email_preview_text":"Celebrate your special day with a little something from us—enjoy your exclusive birthday offer inside!","body":"","json_body":""}},"next_step_id":"z02ktf","created_at":null,"updated_at":null,"automation_step_id":null,"meta_key":null,"meta_value":null,"enterance":0,"completed":0,"exited":0}]}';
		}

		return $recipe;
	}

}
