<?php
/**
 * Automation Hook action class for MRM Autoamtion
 *
 * Class Webhook
 *
 * @package MailMintPro\Mint\Internal
 */

namespace MailMintPro\Mint\Internal;

use MailMintPro\App\Utilities\Helper\MintWC;
use MailMintPro\Mint\Internal\Admin\Segmentation\FilterSegmentContacts;
use MailMintPro\Mint\Internal\Traits\Singleton;
use MintMail\App\Internal\Automation\HelperFunctions;
use MintMailPro\Mint_Pro_Helper;
/**
 * Automation Hook action class for MRM Autoamtion
 *
 * Class Webhook
 *
 * @package MailMintPro\Mint\Internal\AutomationHooks
 */
class AutomationHooks {

	use Singleton;

	/**
	 * MainMint filter hook.
	 *
	 * @return void
	 */
	public function init() {
		add_filter( 'mint_supported_automation_actions', array( $this, 'mint_pro_automation_actions' ), 10, 1 );
		add_filter( 'mrm_automation_connectors', array( $this, 'mint_pro_automation_connectors' ), 10, 1 );
		add_filter( 'mint_process_post_published', array( $this, 'mint_retrieve_contacts_post_publish_trigger' ), 10, 4 );

	}

	/**
	 * Add new action.
	 *
	 * @param array $actions Get action for automaiton.
	 * @return mixed
	 */
	public function mint_pro_automation_actions( $actions ) {
		$actions['createUser']            = 'Create user';
		$actions['createUserMeta']        = 'Create user meta';
		$actions['updateStatus']          = 'Update status';
		$actions['removeTag']             = 'Remove tag';
		$actions['addList']               = 'Add list';
		$actions['removeList']            = 'Remove list';
		$actions['condition']             = 'Condition';
		$actions['createCoupon']          = 'Create coupon';
		$actions['sequence']              = 'Email sequence';
		$actions['webHookOutgoing']       = 'Web Hook';
		$actions['specificTimeDelay']     = 'Specific Time Delay';
		$actions['stopAutomation']        = 'Stop Automation';
		$actions['deleteCoupon']          = 'Delete Coupon';
		$actions['twilioSendMessage']     = 'Send Message';
		$actions['pabblyConnectSendData'] = 'Pabbly Connect';
		$actions['changeOrderStatus']     = 'Change Order Status';
		$actions['addOrderNote']          = 'Add Order Note';
		$actions['updateWPUserMeta']      = 'Update WP User Meta';
		$actions['createWordPressUser']   = 'Create WordPress User';
		$actions['changeUserRole']        = 'Change user Role';
		$actions['addNoteAndActivity']    = 'Add Note & Activity';
		$actions['changeContactStatus']   = 'Change Contact Status';
		$actions['sendMailNotification']  = 'Send Mail Notification';
		$actions['updateContactFields']   = 'Update Contact Fields';

		return $actions;
	}

	/**
	 * Add new connector.
	 *
	 * @param array $connectors Get Connector.
	 * @return mixed
	 */
	public function mint_pro_automation_connectors( $connectors ) {
		if ( HelperFunctions::is_wc_active() ) {
			$connectors['woocommerce'] = array(
				'class_name' => 'ConnectorWoocommerce',
			);
		}

		if ( HelperFunctions::is_wpf_active() ) {
			$connectors['wpfunnels'] = array(
				'class_name' => 'ConnectorWpfunnels',
			);
		}

		if ( Mint_Pro_Helper::is_edd_active() ) {
			$connectors['edd'] = array(
				'class_name' => 'ConnectorEdd',
			);
		}

		if ( Mint_Pro_Helper::is_gform_active() ) {
			$connectors['gform'] = array(
				'class_name' => 'ConnectorGform',
			);
		}

		if ( Mint_Pro_Helper::is_tutor_active() ) {
			$connectors['tutor'] = array(
				'class_name' => 'ConnectorTutor',
			);
		}

		if ( Mint_Pro_Helper::is_jetform_active() ) {
			$connectors['jetform'] = array(
				'class_name' => 'ConnectorJetform',
			);
		}

		if ( Mint_Pro_Helper::is_fluentform_active() ) {
			$connectors['fluentforms'] = array(
				'class_name' => 'ConnectorFluentForm',
			);
		}

		if ( Mint_Pro_Helper::is_contact_form_7_active() ) {
			$connectors['contactform'] = array(
				'class_name' => 'ConnectorContactForm',
			);
		}

		if ( Mint_Pro_Helper::is_learndash_lms_active() ) {
			$connectors['learndash'] = array(
				'class_name' => 'ConnectorLearnDash',
			);
		}

		if ( Mint_Pro_Helper::is_memberpress_active() ) {
			$connectors['memberpress'] = array(
				'class_name' => 'ConnectorMemberPress',
			);
		}

		if ( Mint_Pro_Helper::is_lifter_lms_active() ) {
			$connectors['lifterlms'] = array(
				'class_name' => 'ConnectorLifterLMS',
			);
		}

		$connectors['mailmint'] = array(
			'class_name' => 'ConnectorMailMint',
		);

		if ( Mint_Pro_Helper::is_bricks_active() ) {
			$connectors['bricksform'] = array(
				'class_name' => 'ConnectorBricksForm',
			);
		}

		if ( Mint_Pro_Helper::is_wp_form_active() ) {
			$connectors['wpformsform'] = array(
				'class_name' => 'ConnectorWPFormsForm',
			);
		}
		if ( Mint_Pro_Helper::is_fluent_booking_active() ) {
			$connectors['FluentBooking'] = array(
				'class_name' => 'ConnectorFluentBooking',
			);
		}

		return $connectors;
	}

	/**
	 * Retrieve contacts for post publish trigger.
	 *
	 * @param array $settings Settings for the trigger.
	 * @param array $contacts Contacts.
	 * @param int $offset Offset.
	 * @param int $per_batch Per batch.
	 * @return array Contacts.
	 *
	 * @since 1.13.0
	 */
	public function mint_retrieve_contacts_post_publish_trigger( $settings, $contacts, $offset, $per_batch ) {
		if ( !empty( $settings[ 'segments' ] ) ) {
			$segment_ids = array_column( $settings[ 'segments' ], 'id' );
			if ( class_exists( 'MailMintPro\Mint\Internal\Admin\Segmentation\FilterSegmentContacts' ) ) {
				foreach ( $segment_ids as $segment_id ) {
					$segment_data = FilterSegmentContacts::get_segment( $segment_id, 'id, email, status', $offset, $per_batch );

					// Process only if there are contacts in the batch.
					if ( !empty( $segment_data['contacts']['data'] ) ) {
						$filtered_contacts = array_filter(
							$segment_data['contacts']['data'],
							function ( $contact ) {
								return 'subscribed' === $contact['status'];
							}
						);

						$contacts = array_merge( $contacts, $filtered_contacts );
					}
				}
			}
		}

		$lists    = isset( $settings['lists'] ) ? $settings['lists'] : array();
		$tags     = isset( $settings['tags'] ) ? $settings['tags'] : array();
		$groups   = array_merge( $lists, $tags );
		$contacts = MintWC::retrieve_contacts_by_group( $groups, $offset, $per_batch, $contacts );
		return $contacts;
	}
}
