<?php
/**
 * Automation action class for MRM Autoamtion
 *
 * Class UpdateStatus
 *
 * @package MintMail\App\Internal\Automation\Action
 */

namespace MintMail\App\Internal\Automation\Action;

use Mint\Mrm\Internal\Traits\Singleton;
use MintMail\App\Internal\Automation\Action\AbstractAutomationAction;
use MintMail\App\Internal\Automation\HelperFunctions;
use MintMail\App\Internal\Automation\ActionScheduler;
use Mint\MRM\DataBase\Models\ContactModel;

/**
 * UpdateStatus action
 *
 * Class UpdateStatus
 *
 * @package MintMail\App\Internal\Automation\Action
 */
class UpdateStatus extends AbstractAutomationAction {

	use Singleton;
	/**
	 * Action scheduler.
	 *
	 * @var $action_scheduler
	 */
	private $action_scheduler;
	/**
	 * Initialization
	 */
	public function __construct() {
		$this->action_scheduler = new ActionScheduler();
	}


	/**
	 * Get action name
	 *
	 * @return String
	 * @since  1.0.0
	 */
	public function get_name() {
		return __( 'Update status', 'mailmint-pro' );
	}


	/**
	 * Process.
	 *
	 * @param array $data Get All data.
	 */
	public function process( $data ) {
		if ( $data ) {
			$email = isset( $data['data']['user_email'] ) ? $data['data']['user_email'] : '';
			if ( $email ) {
				$exist_email = ContactModel::is_contact_exist( $email );
				if ( !$exist_email ) {
					$step_data  = HelperFunctions::get_step_data( $data['automation_id'], $data['step_id'] );
					$status     = !empty( $step_data['settings']['status'] ) ? $step_data['settings']['status'] : 'pending';
					$conatct_id = ContactModel::get_id_by_email( $email );
					ContactModel::update_subscription_status( $conatct_id, $status );
				}
			}

			$next_step = HelperFunctions::get_next_step( $data['automation_id'], $data['step_id'] );
			HelperFunctions::update_job( $data['automation_id'], isset( $next_step['step_id'] ) ? $next_step['step_id'] : null, isset( $next_step['step_id'] ) ? 'processing' : 'completed' );
			if ( $next_step ) {
				$next_step['data']       = $data['data'];
				$next_step['identifier'] = $data['identifier'];
				do_action(MINT_PROCESS_AUTOMATION, $next_step);
			}
		}
	}


}
