<?php
/**
 * Automation action class for MRM Autoamtion
 *
 * Class Webhook
 *
 * @package MintMail\App\Internal\Automation\Action
 */

namespace MintMail\App\Internal\Automation\Action;

use Mint\Mrm\Internal\Traits\Singleton;
use MintMail\App\Internal\Automation\ActionScheduler;
use MintMail\App\Internal\Automation\HelperFunctions;

/**
 * Stop Automation  action
 *
 * Class Webhook
 *
 * @package MintMail\App\Internal\Automation\Action
 */
class StopAutomation extends AbstractAutomationAction {

	use Singleton;
	/**
	 * Action scheduler.
	 *
	 * @var $action_scheduler
	 */
	private $action_scheduler;
	/**
	 * Initialization
	 */
	public function __construct() {
		$this->action_scheduler = new ActionScheduler();
	}


	/**
	 * Get action name
	 *
	 * @return String
	 * @since  1.0.0
	 */
	public function get_name() {
		return __( 'Stop Automation', 'mailmint-pro' );
	}

	/**
	 * Process.
	 *
	 * @param array $data Get All data.
	 * @since 1.4.1
	 */
	public function process( $data ) {
		if ( ! is_array( $data ) ) {
			return;
		}
		HelperFunctions::update_job( $data['automation_id'],null,'completed' );
		$this->update_log( $data, 'completed' );
	}


	/**
	 * Update the log for the current step with the given status.
	 *
	 * @param array  $data The data related to the current step.
	 * @param string $status The status to set for the current step.
	 *
	 * @return void
	 * @since 1.2.7
	 */
	private function update_log( $data, $status ) {
		$payload = array(
			'automation_id' => !empty( $data['automation_id'] ) ? $data['automation_id'] : 0,
			'step_id'       => !empty( $data['step_id'] ) ? $data['step_id'] : '',
			'identifier'    => !empty( $data['identifier'] ) ? $data['identifier'] : '',
			'status'        => $status,
			'email'         => !empty( $data['data']['user_email'] ) ? $data['data']['user_email'] : '',
		);

		HelperFunctions::update_log( $payload );
	}

}
