<?php
/**
 * Automation action class for MRM Autoamtion
 *
 * Class RemoveTag
 *
 * @package MintMail\App\Internal\Automation\Action
 */

namespace MintMail\App\Internal\Automation\Action;

use Mint\Mrm\Internal\Traits\Singleton;
use MintMail\App\Internal\Automation\Action\AbstractAutomationAction;
use MintMail\App\Internal\Automation\HelperFunctions;
use MintMail\App\Internal\Automation\ActionScheduler;
use Mint\MRM\DataBase\Models\ContactModel;
use Mint\MRM\DataBase\Models\ContactGroupPivotModel;


/**
 * RemoveTag action
 *
 * Class RemoveTag
 *
 * @package MintMail\App\Internal\Automation\Action
 */
class RemoveTag extends AbstractAutomationAction {

	use Singleton;
	/**
	 * Action scheduler.
	 *
	 * @var $action_scheduler
	 */
	private $action_scheduler;
	/**
	 * Initialization
	 */
	public function __construct() {
		$this->action_scheduler = new ActionScheduler();
	}


	/**
	 * Get action name
	 *
	 * @return String
	 * @since  1.0.0
	 */
	public function get_name() {
		return __( 'Remove tag', 'mailmint-pro' );
	}

	/**
	 * Process.
	 *
	 * @param array $data Get All data.
	 */
	public function process( $data ) {
		if ( $data ) {
			$log_payload = array(
				'automation_id' => $data['automation_id'],
				'step_id'       => $data['step_id'],
				'status'        => 'hold',
				'identifier'    => $data['identifier'],
				'email'         => !empty( $data['data']['user_email'] ) ? $data['data']['user_email'] : '',
			);
			HelperFunctions::update_log( $log_payload );
			$step_id = $data['step_id'];
			$email   = isset( $data['data']['user_email'] ) ? $data['data']['user_email'] : '';
			if ( $email ) {
				$contact_id = ContactModel::get_id_by_email( $email );
				if ( $contact_id ) {
					$step_data = HelperFunctions::get_step_data( $data['automation_id'], $data['step_id'] );
					if ( isset( $step_data['settings']['tag_settings']['tags'] ) ) {
						$_items = $this->get_items( $step_data['settings']['tag_settings']['tags'] );
						ContactGroupPivotModel::delete_groups_to_contact( $contact_id, $_items );
						$payload = array(
							'automation_id' => $data['automation_id'],
							'step_id'       => $step_id,
							'status'        => 'completed',
							'identifier'    => $data['identifier'],
							'email'         => !empty( $data['data']['user_email'] ) ? $data['data']['user_email'] : '',
						);
						HelperFunctions::update_log( $payload );
					} else {
						$payload = array(
							'automation_id' => $data['automation_id'],
							'step_id'       => $step_id,
							'status'        => 'fail',
							'identifier'    => $data['identifier'],
							'email'         => !empty( $data['data']['user_email'] ) ? $data['data']['user_email'] : '',
						);
						HelperFunctions::update_log( $payload );
					}
				}
			}
			$next_step = HelperFunctions::get_next_step( $data['automation_id'], $data['step_id'] );
			HelperFunctions::update_job( $data['automation_id'], isset( $next_step['step_id'] ) ? $next_step['step_id'] : null, isset( $next_step['step_id'] ) ? 'processing' : 'completed' );
			if ( $next_step ) {
				$next_step['data']       = $data['data'];
				$next_step['identifier'] = $data['identifier'];
				do_action(MINT_PROCESS_AUTOMATION, $next_step);
			}
		}
	}

	/**
	 * Get tags for assign contact.
	 *
	 * @param array $settings settings.
	 */
	public function get_items( $settings ) {
		if ( is_array( $settings ) ) {
			$formatted_items = array();
			foreach ( $settings as $item ) {
				$formatted_items[] = $item['id'];
			}
			return $formatted_items;
		}
	}
}
