<?php
/**
 * HasStatus class for checking the total order count of a user.
 *
 * @author [WPFunnels Team]
 * @email [support@rextheme.com]
 * @create date 2023-05-15 11:03:17
 * @modify date 2023-05-15 11:03:17
 * @package MintMail\App\Internal\Automation\Condition
 */

namespace MintMail\App\Internal\Automation\Condition;

/**
 * HasStatus class for checking the total order count of a user.
 *
 * @since 1.17.2
 */
class HasStatus {

    /**
     * Check if the total order count is equal to the given value.
     *
     * @param int $value The value to compare against.
     * @param array $automation_data The automation data containing the user's email.
     * 
     * @return bool True if the total order count is equal to the value, false otherwise.
     * @since 1.17.2
     */
    public function equal($value, $automation_data): bool {
        $user_membership_id = $automation_data['data']['user_membership_id'] ?? '';

        if (empty($user_membership_id)) {
            return false;
        }

        // Handle special cases for $value
        if ($value == 'any' || empty($value)) {
            return true;
        }

        $membership = wc_memberships_get_user_membership($user_membership_id);
        $status     = $membership->get_status();

        return $status == $value;
    }

    /**
     * Check if the total order count is not equal to the given value.
     *
     * @param int $value The value to compare against.
     * @param array $automation_data The automation data containing the user's email.
     * 
     * @return bool True if the total order count is not equal to the value, false otherwise.
     * @since 1.17.2
     */
    public function does_not_equal($value, $automation_data): bool {
        return !$this->equal($value, $automation_data);
    }
}