<?php

/**
 * IsACustomer class for checking if a contact is a customer or not.
 *
 * Provides various conditions to evaluate if a contact is a customer or not.
 *
 * @author [WPFunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2024-12-04 09:03:17
 * @modify date 2024-12-10 09:03:17
 * @package MintMail\App\Internal\Automation\Condition
 */

namespace MintMail\App\Internal\Automation\Condition;

/**
 * Class IsACustomer
 *
 * Provides various conditions to evaluate if a contact is a customer or not.
 * Includes methods to check if a contact is a customer or not.
 * 
 * @since 1.17.1
 */
class IsACustomer{

    /**
     * Checks if the contact is a customer.
     *
     * @param string $value           The value to compare with (e.g., 'yes' or 'no').
     * @param array  $automation_data The automation data, including the user's email.
     *
     * @access public
     *
     * @return bool True if the contact is a customer, false otherwise.
     * @since 1.17.0
     */
    public function equal($value, $automation_data): bool {
        $user_email = isset( $automation_data['data']['user_email'] ) ? $automation_data['data']['user_email'] : '';

        if ( empty( $user_email ) ) {
            return false;
        }

        // Check if a user exists with the given email
        $user = get_user_by('email', $user_email);
        if (!$user) {
            return $value === 'no';
        }

        // Check if the user has the 'customer' role
        $is_customer = in_array('customer', $user->roles);

        if ($value === 'yes') {
            // Return true if the user has the 'customer' role
            return $is_customer;
        } elseif ($value === 'no') {
            // Return true if the user does not have the 'customer' role
            return !$is_customer;
        }

        // Default return false if value is not 'yes' or 'no'
        return false;  
    }
}