<?php
/**
 * Automation action class for MRM Autoamtion
 *
 * Class Delay
 *
 * @package MintMail\App\Internal\Automation\Condition
 */

namespace MintMail\App\Internal\Automation\Condition;

use Mint\Mrm\Internal\Traits\Singleton;
use MintMail\App\Internal\Automation\HelperFunctions;
use MintMail\App\Internal\Automation\ActionScheduler;

/**
 * Delay
 *
 * Class Delay
 *
 * @package MintMail\App\Internal\Automation\Action
 */
class UserRole {

	use Singleton;
	/**
	 * Action scheduler.
	 *
	 * @var $action_scheduler
	 */
	private $action_scheduler;
	/**
	 * Initialization
	 */
	public function __construct() {
		$this->action_scheduler = new ActionScheduler();
	}


	/**
	 * Get action name
	 *
	 * @return String
	 * @since  1.0.0
	 */
	public function get_name() {
		return __( 'User Role', 'mailmint-pro' );
	}

	/**
	 * Process.
	 *
	 * @param array $condition Get All condition.
	 * @param array $data Get All data.
	 */
	public function match( $condition, $data ) {
		if ( $condition && $data ) {
			if ( isset( $data['data']['user_id'] ) ) {
				$user_meta  = get_userdata( $data['data']['user_id'] );
				$user_roles = isset( $user_meta->roles ) ? $user_meta->roles : array();
				if ( in_array( $condition['value'], $user_roles ) ) { //phpcs:ignore
					return true;
				}
			}
		}
		return false;
	}

}
