<?php
/**
 * WpUserRoleSegment class for checking contact status
 *
 * @author [MRM Team]
 * @email [support@rextheme.com]
 * @create date 2023-05-15 11:03:17
 * @modify date 2023-05-15 11:03:17
 * @package /app
 */

namespace MintMail\App\Internal\Automation\Condition;

/**
 * WpUserRoleSegment class for checking contact status
 */
class WpUserRoleSegment {

	/**
	 * Checks if any segment ID from the given segments array matches any group ID in the automation data.
	 *
	 * @param array $segments The array of segments to check for matching group IDs.
	 * @param array $automation_data The automation data containing the relevant information.
	 *
	 * @return bool Returns true if a segment ID matches a group ID, false otherwise.
	 * @since 1.2.7
	 */
	public function includes( array $segments, array $automation_data ): bool {
		$user_email = isset($automation_data['data']['user_email']) ? $automation_data['data']['user_email'] : '';

		if (empty($user_email)) {
			return false;
		}

		$user = get_user_by('email', $user_email);
		if (!$user) {
			return false;
		}
		$user_roles = $user->roles;

		$roles = array_values(array_column($segments, 'title'));
		$roles = array_map('strtolower', $roles);
		// Check if the status is in the segments
		return count(array_intersect($user_roles, $roles)) > 0;
	}

	/**
	 * Checks if none of the segment IDs from the given segments array are present in the group IDs of the automation data.
	 *
	 * @param array $segments           The value to check if it does not exist within the first name.
	 * @param array $automation_data The automation data containing the first name.
	 *
	 * @return bool                   True if the value does not exist within the first name, false otherwise.
	 * @since 1.2.7
	 */
	public function does_not_includes( array $segments, array $automation_data ): bool {
		return !$this->includes($segments, $automation_data);
	}

}
