<?php
/**
 * StatusSegment class for checking contact status
 *
 * @author [MRM Team]
 * @email [support@rextheme.com]
 * @create date 2023-05-15 11:03:17
 * @modify date 2023-05-15 11:03:17
 * @package /app
 */

namespace MintMail\App\Internal\Automation\Condition;

use Mint\MRM\DataBase\Models\ContactModel;
use MintMailPro\Mint_Pro_Helper;

/**
 * StatusSegment class for checking contact status
 */
class StatusSegment {

	/**
	 * Checks if any segment ID from the given segments array matches any group ID in the automation data.
	 *
	 * @param array $segments The array of segments to check for matching group IDs.
	 * @param array $automation_data The automation data containing the relevant information.
	 *
	 * @return bool Returns true if a segment ID matches a group ID, false otherwise.
	 * @since 1.2.7
	 */
	public function includes( array $segments, array $automation_data ): bool {
		$user_email = isset($automation_data['data']['user_email']) ? $automation_data['data']['user_email'] : '';

		if (empty($user_email)) {
			return false;
		}

		$contact  = ContactModel::get_contact_by_email($user_email);
		$status   = isset($contact['status']) ? $contact['status'] : '';
		$statuses = array_values(array_column($segments, 'title'));
		// Check if the status is in the segments
		return in_array(strtolower($status), array_map('strtolower', $statuses));
	}

	/**
	 * Checks if none of the segment IDs from the given segments array are present in the group IDs of the automation data.
	 *
	 * @param array $segments           The value to check if it does not exist within the first name.
	 * @param array $automation_data The automation data containing the first name.
	 *
	 * @return bool                   True if the value does not exist within the first name, false otherwise.
	 * @since 1.2.7
	 */
	public function does_not_includes( array $segments, array $automation_data ): bool {
		return !$this->includes($segments, $automation_data);
	}

}
