<?php
/**
 * Country class for checking contact Country
 *
 * @author [MRM Team]
 * @email [support@rextheme.com]
 * @create date 2023-05-15 11:03:17
 * @modify date 2023-05-15 11:03:17
 * @package /app
 */

namespace MintMail\App\Internal\Automation\Condition;

use MintMailPro\Mint_Pro_Helper;
use Mint\MRM\DataBase\Models\ContactModel;


/**
 * Country class for checking contact Country
 */
class CountrySegment {

	/**
	 * Checks if a given value is included in the Country
	 *
	 * @param array $countries The array of countries to check for matching country.
	 * @param array  $automation_data The automation data containing the Country
	 *
	 * @return bool True if the value is included in the Country, false otherwise.
	 * @since 1.2.7
	 */
	public function includes(array $countries, array $automation_data): bool {
		$user_email = isset($automation_data['data']['user_email']) ? $automation_data['data']['user_email'] : '';

		if (empty($user_email)) {
			return false;
		}

		$country = ContactModel::get_contact_meta_value_by_key($user_email, 'country');

		if (empty($country)) {
			return false;
		}

		$countries = array_values(array_column($countries, 'title'));
		$found     = in_array(strtolower($country), array_map('strtolower', $countries));

		// If there is at least one common ID, return true.
		if ($found) {
			return true;
		}

		return false;
	}

	/**
	 * Checks if the specified value does not exist within the given automation data's first name.
	 *
	 * @param array  $countries       The value to check if it does not exist within the Country.
	 * @param array  $automation_data The automation data containing the first name.
	 *
	 * @return bool                   True if the value does not exist within the Country, false otherwise.
	 * @since 1.2.7
	 */
	public function does_not_includes( array $countries, array $automation_data ): bool {
		return !$this->includes( $countries, $automation_data );
	}

	/**
	 * Checks if the Country is empty.
	 *
	 * @param array $countries The array of countries to check for matching country.
	 * @param array $automation_data The automation data containing the Country.
	 *
	 * @return bool True if the Country is empty, false otherwise.
	 * @since 1.2.7
	 */
	public function is_empty( array $countries, array $automation_data): bool{
		$user_email = isset($automation_data['data']['user_email']) ? $automation_data['data']['user_email'] : '';

		if (empty($user_email)) {
			return true;
		}

		$country = ContactModel::get_contact_meta_value_by_key($user_email, 'country');
		return empty($country);
	}

	/**
	 * Checks if the Country is not empty.
	 *
	 * @param array $countries The array of countries to check for matching country.
	 * @param array $automation_data The automation data containing the Country.
	 *
	 * @return bool True if the Country is not empty, false otherwise.
	 * @since 1.2.7
	 */
	public function is_not_empty( array $countries, array $automation_data): bool{
		return !$this->is_empty($countries, $automation_data);
	}
}
