<?php

/**
 * CourseCompleted class checking if a contact is enrolled in a specific course or not.
 *
 * @author [WPFunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2023-05-15 11:03:17
 * @modify date 2023-05-15 11:03:17
 * @package MintMail\App\Internal\Automation\Condition
 */

namespace MintMail\App\Internal\Automation\Condition;

/**
 * CourseCompleted class checking if a contact is enrolled in a specific course or not.
 * 
 * @since 1.17.2
 */
class CourseCompleted {

	/**
	 * Checks if any course ID from the given courses array matches any course ID in the automation data.
	 *
	 * @param array $courses The array of courses to check for matching course IDs.
	 * @param array $automation_data The automation data containing the relevant information.
	 *
	 * @return bool Returns true if a course ID matches a course ID, false otherwise.
	 * @since 1.17.2
	 */
	public function included_in( array $value, array $automation_data ): bool {
		$user_email = isset( $automation_data['data']['user_email'] ) ? $automation_data['data']['user_email'] : '';
		$course_id  = isset( $automation_data['data']['course_id'] ) ? $automation_data['data']['course_id'] : '';

		if ( empty( $user_email ) ) {
			return false;
		}

		$course_ids = array_values( array_column( $value, 'value' ) );
		if ( empty( $course_ids ) ) {
			return false;
		}

		if (in_array($course_id, $course_ids)) {
			return true;
		}

		return false;
	}

	/**
	 * Checks if any course ID from the given courses array does not match any course ID in the automation data.
	 *
	 * @param array $courses The array of courses to check for matching course IDs.
	 * @param array $automation_data The automation data containing the relevant information.
	 *
	 * @return bool Returns true if a course ID does not match a course ID, false otherwise.
	 * @since 1.17.2
	 */
	public function not_included_in( array $value, array $automation_data ): bool {
		return !$this->included_in($value, $automation_data);
	}
}
