<?php

/**
 * EddIsACustomer class for checking if a contact is a customer or not.
 *
 * Provides various conditions to evaluate if a contact is a customer or not.
 *
 * @author [WPFunnels Team]
 * @email [support@getwpfunnels.com]
 * @create date 2024-12-04 09:03:17
 * @modify date 2024-12-10 09:03:17
 * @package MintMail\App\Internal\Automation\Condition
 */

namespace MintMail\App\Internal\Automation\Condition;

/**
 * Class EddIsACustomer
 *
 * Provides various conditions to evaluate if a contact is a customer or not.
 * Includes methods to check if a contact is a customer or not.
 * 
 * @since 1.17.1
 */
class EddIsACustomer{

    /**
     * Checks if the contact is a customer.
     *
     * @param string $value           The value to compare with (e.g., 'yes' or 'no').
     * @param array  $automation_data The automation data, including the user's email.
     *
     * @access public
     *
     * @return bool True if the contact is a customer, false otherwise.
     * @since 1.17.0
     */
    public function yes($value, $automation_data): bool {
        $user_email = isset( $automation_data['data']['user_email'] ) ? $automation_data['data']['user_email'] : '';

        if ( empty( $user_email ) ) {
            return false;
        }

        $customer = edd_get_customer_by( 'email', $user_email );

        // Check if the customer exists
        if ( ! $customer ) {
            return false;
        }

        return true; 
    }

    /**
     * Checks if the contact is not a customer.
     *
     * @param string $value           The value to compare with (e.g., 'yes' or 'no').
     * @param array  $automation_data The automation data, including the user's email.
     *
     * @access public
     *
     * @return bool True if the contact is not a customer, false otherwise.
     * @since 1.17.0
     */
    public function no($value, $automation_data): bool {
        $user_email = isset( $automation_data['data']['user_email'] ) ? $automation_data['data']['user_email'] : '';

        if ( empty( $user_email ) ) {
            return false;
        }

        $customer = edd_get_customer_by( 'email', $user_email );

        // Check if the customer exists
        if ( ! $customer ) {
            return true;
        }

        return false;
    }
}