<?php
/**
 * Automation action class for MRM Autoamtion
 *
 * Class ChangeUserRole
 *
 * @package MintMail\App\Internal\Automation\Action
 */

namespace MintMail\App\Internal\Automation\Action;

use Mint\Mrm\Internal\Traits\Singleton;
use MintMail\App\Internal\Automation\Action\AbstractAutomationAction;
use MintMail\App\Internal\Automation\HelperFunctions;
use MintMail\App\Internal\Automation\ActionScheduler;
use Mint\MRM\DataBase\Models\ContactModel;

/**
 * UpdateStatus action
 *
 * Class UpdateStatus
 *
 * @package MintMail\App\Internal\Automation\Action
 */
class ChangeUserRole extends AbstractAutomationAction {

	use Singleton;
	/**
	 * Action scheduler.
	 *
	 * @var $action_scheduler
	 */
	private $action_scheduler;
	/**
	 * Initialization
	 */
	public function __construct() {
		$this->action_scheduler = new ActionScheduler();
	}


	/**
	 * Get action name
	 *
	 * @return String
	 * @since  1.18.0
	 */
	public function get_name() {
		return __( 'Change User Role', 'mailmint-pro' );
	}


	/**
	 * Process.
	 *
	 * @param array $data Get All data.
	 * @since  1.18.0
	 * 
	 */
	public function process( $data ) {
		// Check if essential data is provided.
		if (! isset($data['automation_id']) || ! isset($data['step_id'])) {
			return;
		}

		// Extract necessary data from the input.
		$user_email    = isset($data['data']['user_email']) ? $data['data']['user_email'] : '';
		$automation_id = isset($data['automation_id']) ? $data['automation_id'] : '';
		$step_id       = isset($data['step_id']) ? $data['step_id'] : '';
		$identifier    = isset($data['identifier']) ? $data['identifier'] : '';

		// Log that the step is in a 'hold' status.
		$log_payload = array(
			'automation_id' => $automation_id,
			'step_id'       => $step_id,
			'status'        => 'hold',
			'identifier'    => $identifier,
			'email'         => $user_email,
		);
		HelperFunctions::update_log($log_payload);

		$user = get_user_by( 'email', $user_email );
		if ( ! $user ) {
			// If there's a next step, enqueue it for processing.
			$next_step = HelperFunctions::get_next_step($automation_id, $step_id);
			HelperFunctions::update_job($automation_id, isset($next_step['step_id']) ? $next_step['step_id'] : null, isset($next_step['step_id']) ? 'processing' : 'completed');
			if ($next_step) {
				$next_step['data']       = $data['data'];
				$next_step['identifier'] = $data['identifier'];
				do_action(MINT_PROCESS_AUTOMATION, $next_step);
			}
		}

		// Retrieve settings data for the current step.
		$step_data = HelperFunctions::get_step_data($automation_id, $step_id);

		// Check if coupon settings are available.
		if (! isset($step_data['settings']['change_role_settings']) || empty($step_data['settings']['change_role_settings'])) {
			return;
		}
	
		$settings = $step_data['settings']['change_role_settings'];
		$replace  = isset( $settings['replace_user_role'] ) ? (bool) $settings['replace_user_role'] : true;
		$new_role = isset( $settings['role'] ) ? $settings['role'] : get_option('default_role');

		if ($new_role == 'administrator') {
			// If there's a next step, enqueue it for processing.
			$next_step = HelperFunctions::get_next_step($automation_id, $step_id);
			HelperFunctions::update_job($automation_id, isset($next_step['step_id']) ? $next_step['step_id'] : null, isset($next_step['step_id']) ? 'processing' : 'completed');
			if ($next_step) {
				$next_step['data']       = $data['data'];
				$next_step['identifier'] = $data['identifier'];
				do_action(MINT_PROCESS_AUTOMATION, $next_step);
			}
		}
	
		if ($replace ) {
			$user->set_role( $new_role );
		} else {
			$user->add_role( $new_role );
		}

		// Log that the step is completed.
		$log_payload = array(
			'automation_id' => $automation_id,
			'step_id'       => $step_id,
			'status'        => 'completed',
			'identifier'    => $identifier,
			'email'         => $user_email,
		);
		HelperFunctions::update_log($log_payload);

		// If there's a next step, enqueue it for processing.
		$next_step = HelperFunctions::get_next_step($automation_id, $step_id);
		HelperFunctions::update_job($automation_id, isset($next_step['step_id']) ? $next_step['step_id'] : null, isset($next_step['step_id']) ? 'processing' : 'completed');
		if ($next_step) {
			$next_step['data']       = $data['data'];
			$next_step['identifier'] = $data['identifier'];
			do_action(MINT_PROCESS_AUTOMATION, $next_step);
		}
	}
	


}
