<?php
/**
 * Automation action class for MRM Autoamtion
 *
 * Class AddContactNote
 *
 * @package MintMail\App\Internal\Automation\Action
 */

namespace MintMail\App\Internal\Automation\Action;

use Mint\Mrm\Internal\Traits\Singleton;
use MintMail\App\Internal\Automation\Action\AbstractAutomationAction;
use MintMail\App\Internal\Automation\HelperFunctions;
use MintMail\App\Internal\Automation\ActionScheduler;
use Mint\MRM\DataStores\ContactData;
use Mint\MRM\DataBase\Models\ContactModel;
use Mint\MRM\Admin\API\Controllers\ListController;
use Mint\MRM\DataBase\Models\NoteModel;
use Mint\MRM\DataStores\NoteData;
use Mint\MRM\Internal\Parser\Parser;

/**
 * AddContactNote action
 *
 * Class AddContactNote
 *
 * @package MintMail\App\Internal\Automation\Action
 */
class AddNoteAndActivity extends AbstractAutomationAction {

	use Singleton;
	/**
	 * Action scheduler.
	 *
	 * @var $action_scheduler
	 */
	private $action_scheduler;
	/**
	 * Initialization
	 */
	public function __construct() {
		$this->action_scheduler = new ActionScheduler();
	}


	/**
	 * Get action name
	 *
	 * @return String
	 * @since  1.18.0
	 */
	public function get_name() {
		return __( 'Add Note and Activity', 'mailmint-pro' );
	}

	/**
	 * Process Contact note data.
	 *
	 * @param array $data Get All data.
	 */
	public function process( $data ) {
		if ( $data ) {
			$email = $data['data']['user_email'] ?? '';
			$contact = ContactModel::get_contact_data_by_email($email);
			$step_data = HelperFunctions::get_step_data( $data['automation_id'], $data['step_id']);
			$note_settings = $step_data['settings']['note_and_activity_settings'] ?? [];
			$note_title = Parser::parse($note_settings['note_title'] ?? '', $contact);
			$note_description = Parser::parse(sanitize_text_field($note_settings['note_description'] ?? ''), $contact);
			$note = [
				'title'       => $note_title,
				'description' => $note_description,
				'type'        => $note_settings['note_type'] ?? '',
				'is_public'   => 1,
				'status'      => 1,
				'created_by'  => get_current_user_id(),
			];
			NoteModel::insert( $note, $contact['id'] );
			$next_step = HelperFunctions::get_next_step( $data['automation_id'], $data['step_id'] );
			$log_payload = array(
				'automation_id' =>$data['automation_id'],
				'step_id'       => $data['step_id'],
				'status'        => 'completed',
				'identifier'    => $data['identifier'],
				'email'         => $email,
			);
			HelperFunctions::update_log( $log_payload );
			HelperFunctions::update_job( $data['automation_id'], isset( $next_step['step_id'] ) ? $next_step['step_id'] : null, isset( $next_step['step_id'] ) ? 'processing' : 'completed' );
			if ( $next_step ) {
					$next_step['data'] = $data['data'];
					$next_step['identifier'] = $data['identifier'];
					do_action(MINT_PROCESS_AUTOMATION, $next_step);
				}
			}
		}
	}



