<?php

$license     = get_option( 'mail_mint_license_key' );
$status      = get_option( 'mail_mint_pro_license_status' );
$status_data = get_option( 'mail_mint_pro_licence_data' );
if ( $license ) {
	$license = \MintMailPro\Mint_Pro_Helper::encrypt_key( $license );
}

?>



<div class="mintmrm">
	<div class="mintmrm-license-page">
		<div class="mintmrm-license-wrapper">
			<div class="mintmrm-license-filed">
				<div class="field-area">
					<div class="field-header">
						<div class="single-field product-title"><?php echo __( 'Plugin / Addons', 'mailmint-pro' ); ?></div>
						<div class="single-field input-field"><?php echo __( 'License Input', 'mailmint-pro' ); ?></div>
						<div class="single-field btn-area"></div>
					</div>

					<form name="mintmrm-license" id="mintmrm-license" action="options.php" method="post">
						<div class="input-field-area">
							<div class="single-field product-title">
								<span class="addon-icon">
									<?php require plugin_dir_path( __FILE__ ) . 'icon/mailmint-logo.php'; ?>
								</span>
								<!-- <div class="icon-info">
									<h3><?php // echo __('Mail Mint', 'mailmint-pro'); ?></h3>
								</div> -->
							</div>

							<div class="single-field input-field">
								<input id="mail_mint_license_key" name="mail_mint_license_key" type="password" placeholder="Enter your license code" value="<?php esc_attr_e( $license ); ?>"/>

								<span class="license-status">
									<?php

									if ( 'active' === $status ) {
										$start_date = isset( $status_data['start_date'] ) ? $status_data['start_date'] : '';
										$end_date   = isset( $status_data['end_date'] ) ? $status_data['end_date'] : '';
										if ( $end_date ) {
											echo sprintf( '%s %s', __( 'Your license key will be expired on ', 'wpfnl' ), $end_date );
										}
									}
									?>
								</span>
							</div>

							<div class="single-field btn-area">
								<?php if ( $status !== false && $status == 'active' ) { ?>
									<?php wp_nonce_field( 'mail_mint_pro_licensing_nonce', 'mail_mint_pro_licensing_nonce' ); ?>
									<input type="submit" class="mintmrm-btn" name="mail_mint_pro_license_deactivate" value="<?php _e( 'Deactivate License', 'mailmint-pro' ); ?>" required/>
									<?php
								} else {
									wp_nonce_field( 'mail_mint_pro_licensing_nonce', 'mail_mint_pro_licensing_nonce' );
									?>
									<input type="submit" class="mintmrm-btn" name="mail_mint_pro_license_activate" value="<?php _e( 'Activate License', 'mailmint-pro' ); ?>"/>
								<?php } ?>
							</div>
						</div>
					</form>

				</div>
			</div>

			<div class="promo-text-area">
				<div class="manage-license-area">
					<span class="icon">
						<?php require plugin_dir_path( __FILE__ ) . 'icon/license-manage-icon.php'; ?>
					</span>

					<div class="col-info">
						<h4 class="title"><?php echo __( 'Manage License', 'mailmint-pro' ); ?> </h4>
						<p><?php echo __( 'Manage your license and subscriptions in your personalized user account.', 'mailmint-pro' ); ?></p>
						<a href="https://useraccount.getwpfunnels.com/orders/" class="mintmrm-btn manage-license" target="_blank"><?php echo __( 'Manage license', 'mailmint-pro' ); ?></a>
					</div>
				</div>

			</div>
			<!-- /promo-text-area -->
		</div>

		<div class="cl-doc-row">
			<div class="single-col">
				<span class="icon">
					<?php require plugin_dir_path( __FILE__ ) . 'icon/doc-icon2.php'; ?>
				</span>

				<div class="col-info">
					<h4 class="title"><?php echo __( 'Documentation', 'mailmint-pro' ); ?> </h4>
					<p><?php echo __( 'Get detailed guide and documentation on Mail Mint and create highly converting sales funnels easily.', 'mailmint-pro' ); ?></p>
					<a href="https://getwpfunnels.com/docs/mail-mint/" class="mintmrm-btn" target="_blank"><?php echo __( 'Documentation', 'mailmint-pro' ); ?></a>
				</div>
			</div>

			<div class="single-col">
				<span class="icon">
					<?php require plugin_dir_path( __FILE__ ) . 'icon/support-icon.php'; ?>
				</span>

				<div class="col-info">
					<h4 class="title"><?php echo __( 'Support', 'mailmint-pro' ); ?></h4>
					<p><?php echo __( 'Can’t find solution with our documentation? Just post a ticket. Our professional team is here to solve your problems.', 'mailmint-pro' ); ?></p>
					<a href="https://wordpress.org/support/plugin/mail-mint/" target="_blank" class="mintmrm-btn"><?php echo __( 'Post A Ticket', 'mailmint-pro' ); ?></a>
				</div>
			</div>

			<div class="single-col">
				<span class="icon">
					<?php require plugin_dir_path( __FILE__ ) . 'icon/heart-icon.php'; ?>
				</span>

				<div class="col-info">
					<h4 class="title"> <?php echo __( 'Show Your Love', 'mailmint-pro' ); ?> </h4>
					<p><?php echo __( 'We love to have you in Mail Mint family. Take your 2 minutes to review  and spread the love to encourage us to keep it going.', 'mailmint-pro' ); ?></p>
					<a href="https://wordpress.org/support/plugin/mail-mint/reviews/?filter=5" class="mintmrm-btn"  target="_blank"><?php echo __( 'Leave a Review', 'mailmint-pro' ); ?></a>
				</div>
			</div>
		</div>
	</div>
</div>
