<?php
/**
 * Mail Mint - Pro
 *
 * @author [MRM Team]
 * @email [support@rextheme.com]
 * @package /app/Internal/Admin/EmailTemplates/
 */

namespace MailMintPro\Mint\Internal\Admin\EmailTemplates;

use MailMintPro\Mint\Internal\AbandonedCart\Helper\Common;
use MailMintPro\Mint\Internal\Traits\Singleton;
use MintMail\App\Internal\Automation\HelperFunctions;
use MRM\Common\MrmCommon;

/**
 * This class is responsible for managing pro email templates
 *
 * @package /app/Internal/Admin/Segmentation/
 * @since 1.0.0
 */
class DefaultEmailTemplates {

	use Singleton;

	/**
	 * Initialize the class functionalities
	 *
	 * @return void
	 *
	 * @since 1.0.0
	 */
	public function init() {
		add_filter( 'mail_mint_email_templates', array( $this, 'add_pro_template_json_data' ) );
	}

	/**
	 * Add pro templates json data
	 *
	 * @param array $templates Templates data.
	 *
	 * @return array
	 *
	 * @since 1.0.0
	 */
	public function add_pro_template_json_data( $templates ) {
		$image_path = plugins_url( 'images', __FILE__ ) . '/';
		$pinterest  = 'pinterest.png';
		$instagram  = 'instagram.png';
		$facebook   = 'facebook.png';
		$twitter    = 'twitter.png';
    $address    = MrmCommon::get_business_full_address() ? MrmCommon::get_business_full_address() : '{{business.address}}';
    $busi_name  = MrmCommon::get_business_name() ? MrmCommon::get_business_name() : '{{business.name}}';

		if ( !empty( $templates[ 1 ] ) && empty( $templates[ 1 ][ 'json_content' ] ) ) {
			$templates[ 1 ][ 'json_content' ] = array(
				'subject'  => 'Welcome to MINT CRM email',
				'subTitle' => 'Nice to meet you!',
				'content'  => array(
					'type'       => 'page',
					'data'       => array(
						'value' => array(
							'breakpoint'     => '480px',
							'headAttributes' => '',
							'font-size'      => '14px',
							'line-height'    => '1.7',
							'headStyles'     => array(),
							'fonts'          => array(),
							'responsive'     => true,
							'font-family'    => 'lucida Grande,Verdana,Microsoft YaHei',
							'text-color'     => '#000000',
						),
					),
					'attributes' => array(
						'background-color' => '#ececec',
						'width'            => '600px',
						'css-class'        => 'mjml-body',
					),
					'children'   => array(
						0 => array(
							'type'       => 'advanced_wrapper',
							'data'       => array(
								'value' => array(),
							),
							'attributes' => array(
								'background-color' => '#F4F5FB',
								'padding'          => '24px 24px 40px 24px',
								'border'           => 'none',
								'direction'        => 'ltr',
								'text-align'       => 'center',
							),
							'children'   => array(
								0 => array(
									'type'       => 'advanced_image',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'align'   => 'center',
										'height'  => 'auto',
										'padding' => '0px 0px 20px 0px',
										'src'     => $image_path . 'your-logo.png',
										'width'   => '100%',
										'href'    => '#',
									),
									'children'   => array(),
								),
								1 => array(
									'type'       => 'advanced_hero',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'background-color' => '#C6E5FC',
										'background-position' => 'center center',
										'mode'             => 'fluid-height',
										'padding'          => '48px 20px 20px 20px',
										'vertical-align'   => 'top',
										'background-url'   => '',
									),
									'children'   => array(
										0 => array(
											'type'       => 'text',
											'data'       => array(
												'value' => array(
													'content' => 'Get unlimited forms for $40/Month',
												),
											),
											'attributes' => array(
												'padding' => '0px 0px 10px 0px',
												'align'   => 'center',
												'color'   => '#0E1D3F',
												'font-size' => '36px',
												'line-height' => '1.2',
												'font-weight' => '700',
												'font-family' => 'Lato',
											),
											'children'   => array(),
										),
										1 => array(
											'type'       => 'text',
											'data'       => array(
												'value' => array(
													'content' => 'Make This Holiday Season The Best One Yet!',
												),
											),
											'attributes' => array(
												'align'   => 'center',
												'background-color' => '#414141',
												'color'   => '#0E1D3F',
												'font-weight' => '500',
												'border-radius' => '3px',
												'padding' => '0px 0px 0px 0px',
												'inner-padding' => '10px 25px 10px 25px',
												'line-height' => '1.6',
												'target'  => '_blank',
												'vertical-align' => 'middle',
												'border'  => 'none',
												'text-align' => 'center',
												'href'    => '#',
												'font-size' => '16px',
												'font-family' => 'Lato',
											),
											'children'   => array(),
										),
										2 => array(
											'type'       => 'advanced_button',
											'data'       => array(
												'value' => array(
													'content' => 'Get Mail Mint',
												),
											),
											'attributes' => array(
												'align'   => 'center',
												'font-family' => 'Lato',
												'background-color' => 'rgba(87, 59, 255, 1)',
												'color'   => '#ffffff',
												'font-weight' => 'normal',
												'font-style' => 'normal',
												'border-radius' => '100px',
												'padding' => '38px 0px 0px 0px',
												'inner-padding' => '17px 30px 17px 30px',
												'font-size' => '16px',
												'line-height' => '1.2',
												'target'  => '_blank',
												'vertical-align' => 'middle',
												'border'  => 'none',
												'text-align' => 'center',
												'letter-spacing' => 'normal',
												'href'    => '#',
											),
											'children'   => array(),
										),
										3 => array(
											'type'       => 'advanced_image',
											'data'       => array(
												'value' => array(),
											),
											'attributes' => array(
												'align'   => 'center',
												'height'  => 'auto',
												'padding' => '35px 0px 0px 0px',
												'src'     => $image_path . 'unlimited-one.png',
											),
											'children'   => array(),
										),
									),
								),
								2 => array(
									'type'       => 'advanced_spacer',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'height'  => '24px',
										'padding' => '   ',
									),
									'children'   => array(),
								),
								3 => array(
									'type'       => 'advanced_section',
									'data'       => array(
										'value' => array(
											'noWrap' => false,
										),
									),
									'attributes' => array(
										'background-color' => '#ffffff',
										'padding'          => '40px 30px 60px 30px',
										'background-repeat' => 'repeat',
										'background-size'  => 'auto',
										'background-position' => 'top center',
										'border'           => 'none',
										'direction'        => 'ltr',
										'text-align'       => 'center',
									),
									'children'   => array(
										0 => array(
											'type'       => 'advanced_column',
											'attributes' => array(
												'width'   => array(
													0 => '25%',
													1 => '25%',
													2 => '25%',
													3 => '25%',
												),
												'padding' => '0px 0px 0px 0px',
											),
											'data'       => array(
												'value' => array(),
											),
											'children'   => array(
												0 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => 'Did you know your customers want to learn more about what you’re selling?',
														),
													),
													'attributes' => array(
														'padding' => '0px 0px 10px 0px',
														'align' => 'center',
														'font-family' => 'Lato',
														'font-size' => '30px',
														'font-weight' => '600',
														'line-height' => '1.2',
														'letter-spacing' => 'normal',
														'color' => '#000000',
													),
													'children' => array(),
												),
												1 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => '<div>Exciting news! In the coming weeks, Task Manager is introducing new ways to personalize your work experience.&nbsp;</div><div>Task management remains the ultimate tool for planning your day, streamlining office work, sorting your to-do list, and celebrating your achievements.&nbsp;</div><div><br></div><div>Stay tuned for these updates and enhance your productivity like never before!<br></div>',
														),
													),
													'attributes' => array(
														'padding' => '10px 0px 0px 0px',
														'align' => 'center',
														'font-family' => 'Lato',
														'font-size' => '16px',
														'font-weight' => '400',
														'line-height' => '1.6',
														'letter-spacing' => 'normal',
														'color' => 'rgba(135, 135, 146, 1)',
													),
													'children' => array(),
												),
												2 => array(
													'type' => 'advanced_image',
													'data' => array(
														'value' => array(),
													),
													'attributes' => array(
														'align' => 'center',
														'height' => 'auto',
														'padding' => '50px 0px 0px 0px',
														'src' => $image_path . 'selling-one.png',
													),
													'children' => array(),
												),
												3 => array(
													'type' => 'advanced_button',
													'data' => array(
														'value' => array(
															'content' => 'Get Unlimited',
														),
													),
													'attributes' => array(
														'align' => 'center',
														'font-family' => 'Lato',
														'background-color' => 'rgba(87, 59, 255, 1)',
														'color' => '#ffffff',
														'font-weight' => 'normal',
														'font-style' => 'normal',
														'border-radius' => '100px',
														'padding' => '38px 0px 0px 0px',
														'inner-padding' => '17px 30px 17px 30px',
														'font-size' => '16px',
														'line-height' => '1.2',
														'target' => '_blank',
														'vertical-align' => 'middle',
														'border' => 'none',
														'text-align' => 'center',
														'letter-spacing' => 'normal',
														'href' => '#',
													),
													'children' => array(),
												),
											),
										),
									),
								),
								4 => array(
									'type'       => 'advanced_social',
									'data'       => array(
										'value' => array(
											'elements' => array(
												0 => array(
													'href' => '#',
													'target' => '_blank',
													'src'  => $image_path . $pinterest,
													'content' => '',
												),
												1 => array(
													'href' => '#',
													'target' => '_blank',
													'src'  => $image_path . $facebook,
													'content' => '',
												),
												2 => array(
													'href' => '',
													'target' => '_blank',
													'src'  => $image_path . $instagram,
													'content' => '',
												),
												3 => array(
													'href' => '',
													'target' => '_blank',
													'src'  => $image_path . $twitter,
													'content' => '',
												),
											),
										),
									),
									'attributes' => array(
										'align'         => 'center',
										'color'         => '#333333',
										'mode'          => 'horizontal',
										'font-size'     => '13px',
										'font-weight'   => 'normal',
										'border-radius' => '3px',
										'padding'       => '36px 25px 36px 25px',
										'inner-padding' => '4px 5px 4px 5px',
										'line-height'   => '22px',
										'text-padding'  => '4px 4px 4px 0px',
										'icon-padding'  => '0px',
										'icon-size'     => '40px',
									),
									'children'   => array(),
								),
								5 => array(
									'type'       => 'advanced_divider',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'align'        => 'center',
										'border-width' => '1px',
										'border-style' => 'solid',
										'border-color' => '#E2E3EC',
										'padding'      => '0px 0px 0px 0px',
									),
									'children'   => array(),
								),
								6 => array(
									'type'       => 'advanced_text',
									'data'       => array(
										'value' => array(
											'content' => 'No longer want to be Mail Mint friends?<br>&nbsp;<a href="{{link.preference}}" target="_blank" style="color: inherit; text-decoration: underline;" tabindex="-1">Email Preference</a>&nbsp; |&nbsp;&nbsp;<a href="{{link.unsubscribe}}" target="_blank" style="color: inherit; text-decoration: underline;" tabindex="-1">Unsubscribe</a><b><br></b>',
										),
									),
									'attributes' => array(
										'padding'     => '36px 25px 12px 25px',
										'align'       => 'center',
										'color'       => 'rgba(135, 135, 146, 1)',
										'line-height' => '1.47',
										'font-size'   => '15px',
										'font-family' => 'Lato',
										'font-weight' => '400',
									),
									'children'   => array(),
								),
								7 => array(
									'type'       => 'advanced_text',
									'data'       => array(
										'value' => array(
											'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
										),
									),
									'attributes' => array(
										'padding'        => '10px 35px 10px 35px',
										'align'          => 'center',
										'font-family'    => 'Lato',
										'font-size'      => '14px',
										'font-weight'    => '400',
										'line-height'    => '1.7',
										'letter-spacing' => 'normal',
										'color'          => 'rgba(135, 135, 146, 1)',
									),
									'children'   => array(),
								),
							),
						),
					),
				),
			);
		}
		if ( !empty( $templates[ 3 ] ) && empty( $templates[ 3 ][ 'json_content' ] ) ) {
			$templates[ 3 ][ 'json_content' ] = array (
        'subject' => 'Welcome to Mail Mint email marketing and automation',
        'subTitle' => 'Nice to meet you!',
        'content' => 
        array (
          'type' => 'page',
          'data' => 
          array (
            'value' => 
            array (
              'breakpoint' => '480px',
              'headAttributes' => '',
              'font-size' => '14px',
              'font-weight' => '400',
              'line-height' => '1.7',
              'headStyles' => 
              array (
              ),
              'fonts' => 
              array (
              ),
              'responsive' => true,
              'font-family' => 'Arial',
              'text-color' => '#000000',
            ),
          ),
          'attributes' => 
          array (
            'background-color' => '#efeeea',
            'width' => '600px',
          ),
          'children' => 
          array (
            0 => 
            array (
              'type' => 'advanced_image',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'height' => 'auto',
                'padding' => '24px 0px 0px 0px',
                'src' => $image_path . 'logo-with-color.png',
                'container-background-color' => '#F4F5FB',
                'width' => '100%',
              ),
              'children' => 
              array (
              ),
            ),
            1 => 
            array (
              'type' => 'advanced_wrapper',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#F4F5FB',
                'padding' => '24px 24px 24px 24px',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_hero',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'background-position' => 'center center',
                    'mode' => 'fixed-height',
                    'padding' => '30px 0px 0px 0px',
                    'vertical-align' => 'top',
                    'background-url' => $image_path . 'comming-soon-bg.png',
                    'height' => '550px',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;">Coming Soon!<br></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 0px 10px 0px',
                        'align' => 'center',
                        'font-family' => 'Arial',
                        'font-size' => '34px',
                        'line-height' => '36px',
                        'color' => '#573BFF',
                        'font-weight' => '600',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'More options to organize your Tasks ',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 25px 10px 25px',
                        'align' => 'center',
                        'font-family' => 'Arial',
                        'font-size' => '16px',
                        'line-height' => '28px',
                        'font-weight' => '500',
                        'color' => '#878792',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_spacer',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'height' => '24px',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'We\'ve got some fantastic news for you! In the next few weeks, Task Manager will be rolling out additional customization options to enhance your work experience.<div><br></div><div>Now, you\'ll have the flexibility to organize your tasks just the way you like.&nbsp;</div><div><br></div><div>With task management at your fingertips, you can effortlessly plan your day, optimize your office work, arrange your to-do\'s, and marvel at all the remarkable progress you\'ve made.&nbsp;</div><div><br></div><div>Keep an eye out for these exciting updates and take your productivity to new heights!</div>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '30px 40px 30px 40px',
                    'align' => 'left',
                    'font-family' => 'Arial',
                    'font-size' => '16px',
                    'line-height' => '28px',
                    'color' => '#878792',
                    'container-background-color' => '#FFFFFF',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                3 => 
                array (
                  'type' => 'advanced_button',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'See More Tips For tasks',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'font-family' => 'Arial',
                    'background-color' => '#573BFF',
                    'color' => '#ffffff',
                    'font-weight' => '600',
                    'font-style' => 'normal',
                    'border-radius' => '30px',
                    'padding' => '10px 0px 30px 0px',
                    'inner-padding' => '17px 30px 17px 30px',
                    'font-size' => '15px',
                    'line-height' => '1',
                    'target' => '_blank',
                    'vertical-align' => 'middle',
                    'border' => 'none',
                    'text-align' => 'center',
                    'letter-spacing' => 'normal',
                    'href' => '#',
                    'container-background-color' => '#FFFFFF',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
            2 => 
            array (
              'type' => 'advanced_social',
              'data' => 
              array (
                'value' => 
                array (
                  'elements' => 
                  array (
                    0 => 
                    array (
                      'href' => '#',
                      'target' => '_blank',
                      'src' => $image_path . 'pinterest.png',
                      'content' => '',
                    ),
                    1 => 
                    array (
                      'href' => '#',
                      'target' => '_blank',
                      'src' => $image_path . 'facebook.png',
                      'content' => '',
                    ),
                    2 => 
                    array (
                      'href' => '#',
                      'target' => '_blank',
                      'src' => $image_path . 'instagram.png',
                      'content' => '',
                    ),
                    3 => 
                    array (
                      'href' => '#',
                      'target' => '_blank',
                      'src' => $image_path . 'twitter.png',
                      'content' => '',
                    ),
                  ),
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'color' => '#333333',
                'mode' => 'horizontal',
                'font-size' => '13px',
                'font-weight' => 'normal',
                'font-style' => 'normal',
                'font-family' => 'Arial',
                'border-radius' => '3px',
                'padding' => '0px 20px 0px 0px',
                'inner-padding' => '0px 20px 0px 0px',
                'line-height' => '1.6',
                'text-padding' => '4px 4px 4px 0px',
                'icon-padding' => '0px',
                'icon-size' => '40px',
                'container-background-color' => '#F4F5FB',
              ),
              'children' => 
              array (
              ),
            ),
            3 => 
            array (
              'type' => 'advanced_divider',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'border-width' => '1px',
                'border-style' => 'solid',
                'border-color' => '#E2E3EC',
                'padding' => '30px 24px 30px 24px',
                'container-background-color' => '#F4F5FB',
              ),
              'children' => 
              array (
              ),
            ),
            4 => 
            array (
              'type' => 'advanced_text',
              'data' => 
              array (
                'value' => 
                array (
                  'content' => 'No longer want to be Mail Mint friends?',
                ),
              ),
              'attributes' => 
              array (
                'padding' => '0px 0px 0px 0px',
                'align' => 'center',
                'container-background-color' => '#F4F5FB',
                'font-family' => 'Arial',
                'font-size' => '15px',
                'line-height' => '22px',
                'color' => '#878792',
              ),
              'children' => 
              array (
              ),
            ),
            5 => 
            array (
              'type' => 'advanced_text',
              'data' => 
              array (
                'value' => 
                array (
                  'content' => '<font color="#878792"><a href="[object Object]" tabindex="-1"><font color="#878792">Email Preference</font></a> .&nbsp;<a href="[object Object]" tabindex="-1"><font color="#878792">Unsubscribe</font></a></font>',
                ),
              ),
              'attributes' => 
              array (
                'padding' => '10px 25px 10px 25px',
                'align' => 'center',
                'container-background-color' => '#F4F5FB',
                'font-family' => 'Arial',
                'font-size' => '15px',
                'line-height' => '22px',
                'color' => '#878792',
              ),
              'children' => 
              array (
              ),
            ),
            6 => 
            array (
              'type' => 'advanced_text',
              'data' => 
              array (
                'value' => 
                array (
                  'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
                ),
              ),
              'attributes' => 
              array (
                'padding' => '10px 5px 20px 5px',
                'align' => 'center',
                'container-background-color' => '#F4F5FB',
                'font-family' => 'Arial',
                'font-size' => '15px',
                'line-height' => '22px',
                'color' => '#878792',
              ),
              'children' => 
              array (
              ),
            ),
          ),
        ),
      );
		}
		if ( !empty( $templates[ 4 ] ) && empty( $templates[ 4 ][ 'json_content' ] ) ) {
			$templates[ 4 ][ 'json_content' ] = array(
				'subject'  => 'Welcome to MINT CRM email',
				'subTitle' => 'Nice to meet you!',
				'content'  => array(
					'type'       => 'page',
					'data'       => array(
						'value' => array(
							'breakpoint'     => '480px',
							'headAttributes' => '',
							'font-size'      => '14px',
							'line-height'    => '1.7',
							'headStyles'     => array(),
							'fonts'          => array(),
							'responsive'     => true,
							'font-family'    => 'lucida Grande,Verdana,Microsoft YaHei',
							'text-color'     => '#000000',
						),
					),
					'attributes' => array(
						'background-color' => '#ececec',
						'width'            => '600px',
						'css-class'        => 'mjml-body',
					),
					'children'   => array(
						0 => array(
							'type'       => 'advanced_wrapper',
							'data'       => array(
								'value' => array(),
							),
							'attributes' => array(
								'background-color' => '#F4F5FB',
								'padding'          => '24px 24px 40px 24px',
								'border'           => 'none',
								'direction'        => 'ltr',
								'text-align'       => 'center',
							),
							'children'   => array(
								0 => array(
									'type'       => 'advanced_image',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'align'   => 'center',
										'height'  => 'auto',
										'padding' => '0px 0px 20px 0px',
										'src'     => $image_path . 'your-logo.png',
										'width'   => '100%',
										'href'    => '#',
									),
									'children'   => array(),
								),
								1 => array(
									'type'       => 'advanced_hero',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'background-color' => '#fff',
										'background-position' => 'center center',
										'mode'             => 'fluid-height',
										'padding'          => '40px 20px 45px 20px',
										'vertical-align'   => 'top',
										'background-url'   => $image_path . 'better-one.png',
										'height'           => '',
										'background-width' => '100%',
										'background-height' => '100%',
									),
									'children'   => array(
										0 => array(
											'type'       => 'text',
											'data'       => array(
												'value' => array(
													'content' => 'Welcome to Boom<br>',
												),
											),
											'attributes' => array(
												'padding' => '0px 0px 10px 0px',
												'align'   => 'center',
												'color'   => 'rgba(43, 45, 56, 1)',
												'font-size' => '34px',
												'line-height' => '1.2',
												'font-weight' => '600',
												'font-family' => 'Lato',
											),
											'children'   => array(),
										),
										1 => array(
											'type'       => 'text',
											'data'       => array(
												'value' => array(
													'content' => "Congratulations on your recent purchase of\nCosmetic House's face bright beauty products!&nbsp;<div><br><div>By choosing these products, you are not only\nenhancing your beauty but also effectively safeguarding your skin.</div></div>",
												),
											),
											'attributes' => array(
												'align'   => 'center',
												'background-color' => '#414141',
												'color'   => 'rgba(43, 45, 56, 1)',
												'font-weight' => '400',
												'border-radius' => '3px',
												'padding' => '0px 0px 0px 0px',
												'inner-padding' => '10px 25px 10px 25px',
												'line-height' => '1.6',
												'target'  => '_blank',
												'vertical-align' => 'middle',
												'border'  => 'none',
												'text-align' => 'center',
												'href'    => '#',
												'font-size' => '16px',
												'font-family' => 'Lato',
											),
											'children'   => array(),
										),
									),
								),
								2 => array(
									'type'       => 'advanced_spacer',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'height'  => '26px',
										'padding' => '   ',
									),
									'children'   => array(),
								),
								3 => array(
									'type'       => 'advanced_section',
									'data'       => array(
										'value' => array(
											'noWrap' => false,
										),
									),
									'attributes' => array(
										'background-color' => 'rgba(121, 110, 110, 1)',
										'padding'          => '40px 30px 40px 30px',
										'background-repeat' => 'repeat',
										'background-size'  => 'auto',
										'background-position' => 'top center',
										'border'           => 'none',
										'direction'        => 'ltr',
										'text-align'       => 'center',
									),
									'children'   => array(
										0 => array(
											'type'       => 'advanced_column',
											'data'       => array(
												'value' => array(),
											),
											'attributes' => array(
												'background-color' => '#ffffff',
												'padding' => '0px 0px 0px 0px',
												'border'  => 'none',
												'vertical-align' => 'top',
											),
											'children'   => array(
												0 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => 'Did you know. . .',
														),
													),
													'attributes' => array(
														'padding' => '0px 25px 30px 25px',
														'align' => 'center',
														'font-family' => 'Lato',
														'font-size' => '28px',
														'font-weight' => '700',
														'line-height' => '1',
														'letter-spacing' => 'normal',
														'color' => '#fff',
														'container-background-color' => 'rgba(121, 110, 110, 1)',
													),
													'children' => array(),
												),
												1 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => '<div>Experience the difference in your skin with our formulas enriched with high levels of active skincare ingredients.<br></div>',
														),
													),
													'attributes' => array(
														'padding' => '17px 20px 17px 25px',
														'align' => 'left',
														'font-family' => 'Lato',
														'font-size' => '16px',
														'font-weight' => '400',
														'line-height' => '1.7',
														'letter-spacing' => 'normal',
														'color' => 'rgba(255, 255, 255, 0.8)',
														'container-background-color' => 'rgba(131, 120, 120, 1)',
													),
													'children' => array(),
												),
												2 => array(
													'type' => 'advanced_spacer',
													'data' => array(
														'value' => array(),
													),
													'attributes' => array(
														'height' => '16px',
														'padding' => '   ',
														'container-background-color' => 'rgba(121, 110, 110, 1)',
													),
													'children' => array(),
												),
												3 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => 'We carry the Leaping Bunny certificate which means none of our products are tested on our furry friends.',
														),
													),
													'attributes' => array(
														'padding' => '17px 20px 17px 25px',
														'align' => 'left',
														'font-family' => 'Lato',
														'font-size' => '16px',
														'font-weight' => '400',
														'line-height' => '1.7',
														'letter-spacing' => 'normal',
														'color' => 'rgba(255, 255, 255, 0.8)',
														'container-background-color' => 'rgba(131, 120, 120, 1)',
													),
													'children' => array(),
												),
												4 => array(
													'type' => 'advanced_spacer',
													'data' => array(
														'value' => array(),
													),
													'attributes' => array(
														'height' => '16px',
														'padding' => '   ',
														'container-background-color' => 'rgba(121, 110, 110, 1)',
													),
													'children' => array(),
												),
												5 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => '<div>Our sustainable packaging uses recycled aluminum and glass components.<br></div>',
														),
													),
													'attributes' => array(
														'padding' => '17px 20px 17px 25px',
														'align' => 'left',
														'font-family' => 'Lato',
														'font-size' => '16px',
														'font-weight' => '400',
														'line-height' => '1.7',
														'letter-spacing' => 'normal',
														'color' => 'rgba(255, 255, 255, 0.8)',
														'container-background-color' => 'rgba(131, 120, 120, 1)',
													),
													'children' => array(),
												),
												6 => array(
													'type' => 'advanced_button',
													'data' => array(
														'value' => array(
															'content' => 'Read More',
														),
													),
													'attributes' => array(
														'align' => 'center',
														'font-family' => 'Lato',
														'background-color' => 'rgba(212, 185, 136, 1)',
														'color' => '#ffffff',
														'font-weight' => '600',
														'font-style' => 'normal',
														'border-radius' => '100px',
														'padding' => '30px 0px 0px 0px',
														'inner-padding' => '17px 30px 17px 30px',
														'font-size' => '15px',
														'line-height' => '1.2',
														'target' => '_blank',
														'vertical-align' => 'middle',
														'border' => 'none',
														'text-align' => 'center',
														'letter-spacing' => 'normal',
														'href' => '#',
														'container-background-color' => 'rgba(121, 110, 110, 1)',
													),
													'children' => array(),
												),
											),
										),
									),
								),
								4 => array(
									'type'       => 'advanced_divider',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'align'        => 'center',
										'border-width' => '1px',
										'border-style' => 'solid',
										'border-color' => 'EBEBEB',
										'padding'      => '0px 40px 0px 40px',
										'container-background-color' => '#fff',
									),
									'children'   => array(),
								),
								5 => array(
									'type'       => 'advanced_social',
									'data'       => array(
										'value' => array(
											'elements' => array(
												0 => array(
													'href' => '#',
													'target' => '_blank',
													'src'  => $image_path . $pinterest,
													'content' => '',
												),
												1 => array(
													'href' => '#',
													'target' => '_blank',
													'src'  => $image_path . $facebook,
													'content' => '',
												),
												2 => array(
													'href' => '',
													'target' => '_blank',
													'src'  => $image_path . $instagram,
													'content' => '',
												),
												3 => array(
													'href' => '',
													'target' => '_blank',
													'src'  => $image_path . $twitter,
													'content' => '',
												),
											),
										),
									),
									'attributes' => array(
										'align'         => 'center',
										'color'         => '#333333',
										'mode'          => 'horizontal',
										'font-size'     => '13px',
										'font-weight'   => 'normal',
										'border-radius' => '3px',
										'padding'       => '36px 25px 36px 25px',
										'inner-padding' => '4px 5px 4px 5px',
										'line-height'   => '22px',
										'text-padding'  => '4px 4px 4px 0px',
										'icon-padding'  => '0px',
										'icon-size'     => '40px',
									),
									'children'   => array(),
								),
								6 => array(
									'type'       => 'advanced_divider',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'align'        => 'center',
										'border-width' => '1px',
										'border-style' => 'solid',
										'border-color' => '#E2E3EC',
										'padding'      => '0px 0px 0px 0px',
									),
									'children'   => array(),
								),
								7 => array(
									'type'       => 'advanced_text',
									'data'       => array(
										'value' => array(
											'content' => 'No longer want to be Mail Mint friends?<br>&nbsp;<a href="{{link.preference}}" target="_blank" style="color: inherit; text-decoration: underline;" tabindex="-1">Email Preference</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href="{{link.unsubscribe}}" target="_blank" style="color: inherit; text-decoration: underline;" tabindex="-1">Unsubscribe</a><b><br></b>',
										),
									),
									'attributes' => array(
										'padding'     => '36px 25px 12px 25px',
										'align'       => 'center',
										'color'       => 'rgba(135, 135, 146, 1)',
										'line-height' => '1.47',
										'font-size'   => '15px',
										'font-family' => 'Lato',
										'font-weight' => '400',
									),
									'children'   => array(),
								),
								8 => array(
									'type'       => 'advanced_text',
									'data'       => array(
										'value' => array(
											'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
										),
									),
									'attributes' => array(
										'padding'        => '10px 35px 10px 35px',
										'align'          => 'center',
										'font-family'    => 'Lato',
										'font-size'      => '14px',
										'font-weight'    => '400',
										'line-height'    => '1.7',
										'letter-spacing' => 'normal',
										'color'          => 'rgba(135, 135, 146, 1)',
									),
									'children'   => array(),
								),
							),
						),
					),
				),
			);
		}
		if ( !empty( $templates[ 8 ] ) && empty( $templates[ 8 ][ 'json_content' ] ) ) {
			$templates[ 8 ][ 'json_content' ] = array(
				'subject'  => 'Welcome to MINT CRM email',
				'subTitle' => 'Nice to meet you!',
				'content'  => array(
					'type'       => 'page',
					'data'       => array(
						'value' => array(
							'breakpoint'     => '480px',
							'headAttributes' => '',
							'font-size'      => '14px',
							'line-height'    => '1.7',
							'headStyles'     => array(),
							'fonts'          => array(),
							'responsive'     => true,
							'font-family'    => 'lucida Grande,Verdana,Microsoft YaHei',
							'text-color'     => '#000000',
						),
					),
					'attributes' => array(
						'background-color' => '#ececec',
						'width'            => '600px',
						'css-class'        => 'mjml-body',
					),
					'children'   => array(
						0 => array(
							'type'       => 'advanced_wrapper',
							'data'       => array(
								'value' => array(),
							),
							'attributes' => array(
								'background-color' => '#F5F6FB',
								'padding'          => '26px 24px 38px 24px',
								'border'           => 'none',
								'direction'        => 'ltr',
								'text-align'       => 'center',
							),
							'children'   => array(
								0  => array(
									'type'       => 'advanced_image',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'align'   => 'center',
										'height'  => 'auto',
										'padding' => '0px 0px 26px 0px',
										'src'     => $image_path . 'your-logo.png',
										'width'   => '100%',
										'href'    => '#',
									),
									'children'   => array(),
								),
								1  => array(
									'type'       => 'advanced_divider',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'align'        => 'center',
										'border-width' => '1px',
										'border-style' => 'solid',
										'border-color' => '#E5E7F2',
										'padding'      => '0px 0px 0px 0px',
									),
									'children'   => array(),
								),
								2  => array(
									'type'       => 'advanced_hero',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'background-color' => '#fff',
										'background-position' => 'center center',
										'mode'             => 'fluid-height',
										'padding'          => '65px 20px 65px 20px',
										'vertical-align'   => 'top',
										'background-url'   => $image_path . 'fitness-hero-bg.png',
									),
									'children'   => array(
										0 => array(
											'type'       => 'text',
											'data'       => array(
												'value' => array(
													'content' => 'Get In Shape &amp; Be Fit With Just $200',
												),
											),
											'attributes' => array(
												'padding' => '0px 0px 24px 0px',
												'align'   => 'center',
												'color'   => '#FFFFFF',
												'font-size' => '46px',
												'line-height' => '1.22',
												'font-weight' => '700',
												'font-family' => 'Arial',
											),
											'children'   => array(),
										),
										1 => array(
											'type'       => 'advanced_button',
											'data'       => array(
												'value' => array(
													'content' => 'SHOP WITH GYM HERO',
												),
											),
											'attributes' => array(
												'align'   => 'center',
												'font-family' => 'Arial',
												'background-color' => '#E3B152',
												'color'   => '#ffffff',
												'font-weight' => '600',
												'font-style' => 'normal',
												'border-radius' => '100px',
												'padding' => '0px 0px 0px 0px',
												'inner-padding' => '17px 30px 17px 30px',
												'font-size' => '15px',
												'line-height' => '1.2',
												'target'  => '_blank',
												'vertical-align' => 'middle',
												'border'  => 'none',
												'text-align' => 'center',
												'letter-spacing' => '1px',
												'href'    => '#',
											),
											'children'   => array(),
										),
									),
								),
								3  => array(
									'type'       => 'advanced_spacer',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'height'  => '24px',
										'padding' => '   ',
									),
									'children'   => array(),
								),
								4  => array(
									'type'       => 'advanced_image',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'align'   => 'center',
										'height'  => 'auto',
										'padding' => '0px 0px 0px 0px',
										'src'     => $image_path . 'fitness-hero-image.png',
									),
									'children'   => array(),
								),
								5  => array(
									'type'       => 'advanced_section',
									'data'       => array(
										'value' => array(
											'noWrap' => false,
										),
									),
									'attributes' => array(
										'background-color' => '#ffffff',
										'padding'          => '30px 20px 40px 20px',
										'background-repeat' => 'repeat',
										'background-size'  => 'auto',
										'background-position' => 'top center',
										'border'           => 'none',
										'direction'        => 'ltr',
										'text-align'       => 'center',
									),
									'children'   => array(
										0 => array(
											'type'       => 'advanced_column',
											'attributes' => array(
												'width'   => array(
													0 => '25%',
													1 => '25%',
													2 => '25%',
													3 => '25%',
												),
												'padding' => '0px 0px 0px 0px',
											),
											'data'       => array(
												'value' => array(),
											),
											'children'   => array(
												0 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => 'Fitness Made Easy',
														),
													),
													'attributes' => array(
														'padding' => '0px 0px 16px 0px',
														'align' => 'center',
														'font-family' => 'Arial',
														'font-size' => '34px',
														'font-weight' => '600',
														'line-height' => '1.22',
														'letter-spacing' => 'normal',
														'color' => '#2B2D38',
													),
													'children' => array(),
												),
												1 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => 'Experience a simplified fitness journey with Gym Hero. We provide personalized 1 on 1 training for a more hands-on approach. We also have 24-hour fitness classes designed for active aging and improved health and strength.',
														),
													),
													'attributes' => array(
														'padding' => '0px 0px 30px 0px',
														'align' => 'center',
														'font-family' => 'Arial',
														'font-size' => '16px',
														'font-weight' => '400',
														'line-height' => '1.62',
														'letter-spacing' => 'normal',
														'color' => '#878792',
													),
													'children' => array(),
												),
												2 => array(
													'type' => 'advanced_button',
													'data' => array(
														'value' => array(
															'content' => 'VISIT OUR STORE',
														),
													),
													'attributes' => array(
														'align' => 'center',
														'font-family' => 'Arial',
														'background-color' => '#E3B152',
														'color' => '#ffffff',
														'font-weight' => '600',
														'font-style' => 'normal',
														'border-radius' => '100px',
														'padding' => '0px 0px 0px 0px',
														'inner-padding' => '17px 30px 17px 30px',
														'font-size' => '15px',
														'line-height' => '1.2',
														'target' => '_blank',
														'vertical-align' => 'middle',
														'border' => 'none',
														'text-align' => 'center',
														'letter-spacing' => 'normal',
														'href' => '#',
													),
													'children' => array(),
												),
											),
										),
									),
								),
								6  => array(
									'type'       => 'advanced_section',
									'data'       => array(
										'value' => array(
											'noWrap' => false,
										),
									),
									'attributes' => array(
										'background-color' => '#ffffff',
										'padding'          => '24px 40px 24px 24px',
										'background-repeat' => 'repeat',
										'background-size'  => 'auto',
										'background-position' => 'top center',
										'border'           => '',
										'direction'        => 'ltr',
										'text-align'       => 'center',
									),
									'children'   => array(
										0 => array(
											'type'       => 'advanced_column',
											'attributes' => array(
												'width'   => '30%',
												'padding' => '0px 0px 0px 0px',
												'vertical-align' => 'middle',
											),
											'data'       => array(
												'value' => array(),
											),
											'children'   => array(
												0 => array(
													'type' => 'advanced_image',
													'data' => array(
														'value' => array(),
													),
													'attributes' => array(
														'align' => 'center',
														'height' => 'auto',
														'padding' => '0px 0px 0px 0px',
														'src' => $image_path . 'plan-for-senior-image.png',
														'width' => '164px',
													),
													'children' => array(),
												),
											),
										),
										1 => array(
											'type'       => 'advanced_column',
											'attributes' => array(
												'width'   => '70%',
												'padding' => '0px 0px 0px 0px',
												'vertical-align' => 'middle',
											),
											'data'       => array(
												'value' => array(),
											),
											'children'   => array(
												0 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => 'Exercise Plans For Senior ',
														),
													),
													'attributes' => array(
														'padding' => '20px 0px 14px 20px',
														'align' => 'left',
														'font-family' => 'Arial',
														'font-size' => '22px',
														'font-weight' => '600',
														'line-height' => '1.22',
														'letter-spacing' => 'normal',
														'color' => '#0E1D3F',
													),
													'children' => array(),
												),
												1 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => 'Boost your fitness with our specialized exercise plans for senior citizens. Our exercise programs are designed to promote fitness among seniors.',
														),
													),
													'attributes' => array(
														'padding' => '0px 0px 20px 20px',
														'align' => 'left',
														'font-family' => 'Arial',
														'font-size' => '16px',
														'font-weight' => '400',
														'line-height' => '1.62',
														'letter-spacing' => 'normal',
														'color' => '#878792',
													),
													'children' => array(),
												),
											),
										),
									),
								),
								7  => array(
									'type'       => 'advanced_section',
									'data'       => array(
										'value' => array(
											'noWrap' => false,
										),
									),
									'attributes' => array(
										'background-color' => '#ffffff',
										'padding'          => '24px 40px 24px 24px',
										'background-repeat' => 'repeat',
										'background-size'  => 'auto',
										'background-position' => 'top center',
										'border'           => '',
										'direction'        => 'ltr',
										'text-align'       => 'center',
									),
									'children'   => array(
										0 => array(
											'type'       => 'advanced_column',
											'attributes' => array(
												'width'   => '30%',
												'padding' => '0px 0px 0px 0px',
												'vertical-align' => 'middle',
											),
											'data'       => array(
												'value' => array(),
											),
											'children'   => array(
												0 => array(
													'type' => 'advanced_image',
													'data' => array(
														'value' => array(),
													),
													'attributes' => array(
														'align' => 'center',
														'height' => 'auto',
														'padding' => '0px 0px 0px 0px',
														'src' => $image_path . 'special-package.png',
														'width' => '164px',
													),
													'children' => array(),
												),
											),
										),
										1 => array(
											'type'       => 'advanced_column',
											'attributes' => array(
												'width'   => '70%',
												'padding' => '0px 0px 0px 0px',
												'vertical-align' => 'middle',
											),
											'data'       => array(
												'value' => array(),
											),
											'children'   => array(
												0 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => 'Special Membership Offer',
														),
													),
													'attributes' => array(
														'padding' => '20px 0px 14px 20px',
														'align' => 'left',
														'font-family' => 'Arial',
														'font-size' => '22px',
														'font-weight' => '600',
														'line-height' => '1.22',
														'letter-spacing' => 'normal',
														'color' => '#0E1D3F',
													),
													'children' => array(),
												),
												1 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => 'Experience more with Gym Hero! As a member, you\'ll receive more than just world-class training. Enjoy a 10% discount on all services exclusively for Gym Hero members.',
														),
													),
													'attributes' => array(
														'padding' => '0px 0px 20px 20px',
														'align' => 'left',
														'font-family' => 'Arial',
														'font-size' => '16px',
														'font-weight' => '400',
														'line-height' => '1.62',
														'letter-spacing' => 'normal',
														'color' => '#878792',
													),
													'children' => array(),
												),
											),
										),
									),
								),
								8  => array(
									'type'       => 'advanced_section',
									'data'       => array(
										'value' => array(
											'noWrap' => false,
										),
									),
									'attributes' => array(
										'background-color' => '#ffffff',
										'padding'          => '0px 0px 40px 0px',
										'background-repeat' => 'repeat',
										'background-size'  => 'auto',
										'background-position' => 'top center',
										'border'           => 'none',
										'direction'        => 'ltr',
										'text-align'       => 'center',
									),
									'children'   => array(
										0 => array(
											'type'       => 'advanced_column',
											'attributes' => array(
												'width'   => array(
													0 => '25%',
													1 => '25%',
													2 => '25%',
													3 => '25%',
												),
												'padding' => '0px 0px 0px 0px',
											),
											'data'       => array(
												'value' => array(),
											),
											'children'   => array(
												0 => array(
													'type' => 'advanced_button',
													'data' => array(
														'value' => array(
															'content' => 'SHOP WITH GYM HERO',
														),
													),
													'attributes' => array(
														'align' => 'center',
														'font-family' => 'Arial',
														'background-color' => '#E3B152',
														'color' => '#ffffff',
														'font-weight' => '600',
														'font-style' => 'normal',
														'border-radius' => '100px',
														'padding' => '0px 0px 0px 0px',
														'inner-padding' => '17px 30px 17px 30px',
														'font-size' => '15px',
														'line-height' => '1.2',
														'target' => '_blank',
														'vertical-align' => 'middle',
														'border' => 'none',
														'text-align' => 'center',
														'letter-spacing' => 'normal',
														'href' => '#',
													),
													'children' => array(),
												),
											),
										),
									),
								),
								9  => array(
									'type'       => 'advanced_spacer',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'height'  => '24px',
										'padding' => '   ',
									),
									'children'   => array(),
								),
								10 => array(
									'type'       => 'advanced_section',
									'data'       => array(
										'value' => array(
											'noWrap' => false,
										),
									),
									'attributes' => array(
										'background-color' => '#2B2D38',
										'padding'          => '0px 0px 0px 0px',
										'background-repeat' => 'no-repeat',
										'background-size'  => 'auto',
										'background-position' => 'top center',
										'border'           => 'none',
										'direction'        => 'ltr',
										'text-align'       => 'center',
									),
									'children'   => array(
										0 => array(
											'type'       => 'advanced_column',
											'attributes' => array(
												'width'   => '100%',
												'padding' => '50px 20px 54px 20px',
												'vertical-align' => 'middle',
											),
											'data'       => array(
												'value' => array(),
											),
											'children'   => array(
												0 => array(
													'type' => 'advanced_image',
													'data' => array(
														'value' => array(),
													),
													'attributes' => array(
														'align' => 'center',
														'height' => 'auto',
														'padding' => '0px 0px 0px 0px',
														'src' => $image_path . 'customer-service.png',
														'width' => '30px',
													),
													'children' => array(),
												),
												1 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => 'Any Questions<br>',
														),
													),
													'attributes' => array(
														'padding' => '20px 25px 0px 25px',
														'align' => 'center',
														'font-family' => 'Arial',
														'font-size' => '22px',
														'font-weight' => '600',
														'line-height' => '1.5',
														'letter-spacing' => 'normal',
														'color' => '#FFFFFFCC',
														'container-background-color' => '',
													),
													'children' => array(),
												),
												2 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => 'We’re here for you. Contact Number - (780) 349 - 1599<br>',
														),
													),
													'attributes' => array(
														'padding' => '8px 25px 25px 25px',
														'align' => 'center',
														'font-family' => 'Arial',
														'font-size' => '16px',
														'font-weight' => '400',
														'line-height' => '1.5',
														'letter-spacing' => 'normal',
														'color' => '#FFFFFFCC',
														'container-background-color' => '',
													),
													'children' => array(),
												),
												3 => array(
													'type' => 'advanced_button',
													'data' => array(
														'value' => array(
															'content' => 'CONTACT US',
														),
													),
													'attributes' => array(
														'align' => 'center',
														'font-family' => 'Arial',
														'background-color' => '#2B2D38',
														'color' => '#ffffff',
														'font-weight' => '600',
														'font-style' => 'normal',
														'border-radius' => '100px',
														'padding' => '0px 0px 0px 0px',
														'inner-padding' => '17px 30px 17px 30px',
														'font-size' => '15px',
														'line-height' => '1.2',
														'target' => '_blank',
														'vertical-align' => 'middle',
														'border' => '1px solid #ffffff',
														'text-align' => 'center',
														'letter-spacing' => 'normal',
														'href' => '#',
													),
													'children' => array(),
												),
											),
										),
									),
								),
								11 => array(
									'type'       => 'advanced_divider',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'align'        => 'center',
										'border-width' => '1px',
										'border-style' => 'solid',
										'border-color' => 'EBEBEB',
										'padding'      => '0px 40px 0px 40px',
										'container-background-color' => '#fff',
									),
									'children'   => array(),
								),
								12 => array(
									'type'       => 'advanced_social',
									'data'       => array(
										'value' => array(
											'elements' => array(
												0 => array(
													'href' => '#',
													'target' => '_blank',
													'src'  => $image_path . $pinterest,
													'content' => '',
												),
												1 => array(
													'href' => '#',
													'target' => '_blank',
													'src'  => $image_path . $facebook,
													'content' => '',
												),
												2 => array(
													'href' => '',
													'target' => '_blank',
													'src'  => $image_path . $instagram,
													'content' => '',
												),
												3 => array(
													'href' => '',
													'target' => '_blank',
													'src'  => $image_path . $twitter,
													'content' => '',
												),
											),
										),
									),
									'attributes' => array(
										'align'         => 'center',
										'color'         => '#333333',
										'mode'          => 'horizontal',
										'font-size'     => '13px',
										'font-weight'   => 'normal',
										'border-radius' => '3px',
										'padding'       => '36px 25px 36px 25px',
										'inner-padding' => '4px 5px 4px 5px',
										'line-height'   => '22px',
										'text-padding'  => '4px 4px 4px 0px',
										'icon-padding'  => '0px',
										'icon-size'     => '40px',
									),
									'children'   => array(),
								),
								13 => array(
									'type'       => 'advanced_divider',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'align'        => 'center',
										'border-width' => '1px',
										'border-style' => 'solid',
										'border-color' => '#E2E3EC',
										'padding'      => '0px 0px 0px 0px',
									),
									'children'   => array(),
								),
								14 => array(
									'type'       => 'advanced_text',
									'data'       => array(
										'value' => array(
											'content' => 'No longer want to be Mail Mint friends?<br>&nbsp;<a href="{{link.preference}}" target="_blank" style="color: inherit; text-decoration: underline;" tabindex="-1">Email Preference</a>&nbsp; |&nbsp;&nbsp;<a href="{{link.unsubscribe}}" target="_blank" style="color: inherit; text-decoration: underline;" tabindex="-1">Unsubscribe</a><b><br></b>',
										),
									),
									'attributes' => array(
										'padding'     => '30px 0px 24px 0px',
										'align'       => 'center',
										'color'       => 'rgba(135, 135, 146, 1)',
										'line-height' => '1.6',
										'font-size'   => '15px',
										'font-family' => 'Arial',
										'font-weight' => '400',
									),
									'children'   => array(),
								),
								15 => array(
									'type'       => 'advanced_text',
									'data'       => array(
										'value' => array(
											'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
										),
									),
									'attributes' => array(
										'padding'        => '0px 35px 0px 35px',
										'align'          => 'center',
										'font-family'    => 'Arial',
										'font-size'      => '14px',
										'font-weight'    => '400',
										'line-height'    => '1.7',
										'letter-spacing' => 'normal',
										'color'          => 'rgba(135, 135, 146, 1)',
									),
									'children'   => array(),
								),
							),
						),
					),
				),
			);
		}
		if ( !empty( $templates[ 10 ] ) && empty( $templates[ 10 ][ 'json_content' ] ) ) {
			$templates[ 10 ]['json_content'] = array(
				'subject'  => 'Welcome to MINT CRM email',
				'subTitle' => 'Nice to meet you!',
				'content'  => array(
					'type'       => 'page',
					'data'       => array(
						'value' => array(
							'breakpoint'     => '480px',
							'headAttributes' => '',
							'font-size'      => '14px',
							'line-height'    => '1.7',
							'headStyles'     => array(),
							'fonts'          => array(),
							'responsive'     => true,
							'font-family'    => 'lucida Grande,Verdana,Microsoft YaHei',
							'text-color'     => '#000000',
						),
					),
					'attributes' => array(
						'background-color' => '#ececec',
						'width'            => '600px',
						'css-class'        => 'mjml-body',
					),
					'children'   => array(
						0 => array(
							'type'       => 'advanced_wrapper',
							'data'       => array(
								'value' => array(),
							),
							'attributes' => array(
								'background-color' => '#F5F6FB',
								'padding'          => '24px 24px 40px 24px',
								'border'           => 'none',
								'direction'        => 'ltr',
								'text-align'       => 'center',
							),
							'children'   => array(
								0  => array(
									'type'       => 'advanced_image',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'align'   => 'center',
										'height'  => 'auto',
										'padding' => '0px 0px 20px 0px',
										'src'     => $image_path . 'left-logo.png',
										'width'   => '100%',
										'href'    => '#',
									),
									'children'   => array(),
								),
								1  => array(
									'type'       => 'advanced_section',
									'data'       => array(
										'value' => array(
											'noWrap' => false,
										),
									),
									'attributes' => array(
										'background-color' => '#ffffff',
										'padding'          => '150px 20px 50px 20px',
										'background-repeat' => 'no-repeat',
										'background-size'  => 'cover',
										'background-position' => 'top center',
										'border'           => 'none',
										'direction'        => 'ltr',
										'text-align'       => 'center',
										'background-url'   => $image_path . 'purchasing-hero-bg.png',
									),
									'children'   => array(
										0 => array(
											'type'       => 'advanced_column',
											'attributes' => array(
												'width'   => '60%',
												'padding' => '0px 0px 0px 0px',
												'vertical-align' => 'bottom',
											),
											'data'       => array(
												'value' => array(),
											),
											'children'   => array(
												0 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => 'THANKS FOR PURCHASING FROM US!',
														),
													),
													'attributes' => array(
														'padding' => '0px 0px 0px 0px',
														'align' => 'left',
														'font-family' => 'Arial',
														'font-size' => '36px',
														'font-weight' => '500',
														'line-height' => '1.26',
														'letter-spacing' => 'normal',
														'color' => '#000000',
													),
													'children' => array(),
												),
											),
										),
										1 => array(
											'type'       => 'advanced_column',
											'attributes' => array(
												'width'   => '40%',
												'padding' => '0px 0px 0px 0px',
											),
											'data'       => array(
												'value' => array(),
											),
											'children'   => array(),
										),
									),
								),
								2  => array(
									'type'       => 'advanced_spacer',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'height'  => '24px',
										'padding' => '   ',
									),
									'children'   => array(),
								),
								3  => array(
									'type'       => 'advanced_hero',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'background-color' => '#fff',
										'background-position' => 'center center',
										'mode'             => 'fluid-height',
										'padding'          => '40px 30px 30px 30px',
										'vertical-align'   => 'top',
										'background-url'   => '',
									),
									'children'   => array(
										0 => array(
											'type'       => 'text',
											'data'       => array(
												'value' => array(
													'content' => 'Hi Jhon Doe,',
												),
											),
											'attributes' => array(
												'padding' => '0px 0px 8px 0px',
												'align'   => 'center',
												'color'   => '#2B2D38',
												'font-size' => '20px',
												'line-height' => '1.2',
												'font-weight' => '500',
												'font-family' => 'Arial',
											),
											'children'   => array(),
										),
										1 => array(
											'type'       => 'text',
											'data'       => array(
												'value' => array(
													'content' => 'We are currently preparing your order for shipment and will inform you as soon as it has been dispatched.',
												),
											),
											'attributes' => array(
												'align'   => 'center',
												'background-color' => '#414141',
												'color'   => '#878792',
												'font-weight' => '400',
												'border-radius' => '3px',
												'padding' => '0px 0px 0px 0px',
												'inner-padding' => '10px 25px 10px 25px',
												'line-height' => '1.75',
												'target'  => '_blank',
												'vertical-align' => 'middle',
												'border'  => 'none',
												'text-align' => 'center',
												'href'    => '#',
												'font-size' => '16px',
												'font-family' => 'Arial',
											),
											'children'   => array(),
										),
									),
								),
								4  => array(
									'type'       => 'advanced_section',
									'data'       => array(
										'value' => array(
											'noWrap' => false,
										),
									),
									'attributes' => array(
										'background-color' => '#ffffff',
										'padding'          => '0px 0px 30px 0px',
										'background-repeat' => 'repeat',
										'background-size'  => 'auto',
										'background-position' => 'top center',
										'border'           => 'none',
										'direction'        => 'ltr',
										'text-align'       => 'center',
									),
									'children'   => array(
										0 => array(
											'type'       => 'advanced_column',
											'attributes' => array(
												'width'   => '50%',
												'padding' => '0px 0px 0px 0px',
											),
											'data'       => array(
												'value' => array(),
											),
											'children'   => array(
												0 => array(
													'type' => 'advanced_button',
													'data' => array(
														'value' => array(
															'content' => 'VIEW ORDER',
														),
													),
													'attributes' => array(
														'align' => 'center',
														'font-family' => 'Arial',
														'background-color' => '#2B2D38',
														'color' => '#ffffff',
														'font-weight' => '600',
														'font-style' => 'normal',
														'border-radius' => '100px',
														'padding' => '0px 25px 10px 25px',
														'inner-padding' => '17px 25px 17px 25px',
														'font-size' => '15px',
														'line-height' => '1.2',
														'target' => '_blank',
														'vertical-align' => 'middle',
														'border' => 'none',
														'text-align' => 'center',
														'letter-spacing' => '1px',
														'href' => '#',
													),
													'children' => array(),
												),
											),
										),
										1 => array(
											'type'       => 'advanced_column',
											'attributes' => array(
												'width' => '50%',
											),
											'data'       => array(
												'value' => array(),
											),
											'children'   => array(
												0 => array(
													'type' => 'advanced_button',
													'data' => array(
														'value' => array(
															'content' => 'VISIT STORE',
														),
													),
													'attributes' => array(
														'align' => 'center',
														'font-family' => 'Arial',
														'background-color' => '#FFFFFF',
														'color' => '#2B2D38',
														'font-weight' => '600',
														'font-style' => 'normal',
														'border-radius' => '100px',
														'padding' => '0px 25px 10px 25px',
														'inner-padding' => '17px 25px 17px 25px',
														'font-size' => '15px',
														'line-height' => '1.2',
														'target' => '_blank',
														'vertical-align' => 'middle',
														'border' => '1px solid #E7E7E7',
														'text-align' => 'center',
														'letter-spacing' => '1px',
														'href' => '#',
													),
													'children' => array(),
												),
											),
										),
									),
								),
								5  => array(
									'type'       => 'advanced_spacer',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'height'  => '24px',
										'padding' => '   ',
									),
									'children'   => array(),
								),
								6  => array(
									'type'       => 'advanced_hero',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'background-color' => '#fff',
										'background-position' => 'center center',
										'mode'             => 'fluid-height',
										'padding'          => '40px 30px 30px 30px',
										'vertical-align'   => 'top',
										'background-url'   => '',
									),
									'children'   => array(
										0 => array(
											'type'       => 'text',
											'data'       => array(
												'value' => array(
													'content' => 'Oder summary',
												),
											),
											'attributes' => array(
												'align'   => 'center',
												'background-color' => '#414141',
												'color'   => 'rgba(44, 42, 42, 0.3)',
												'font-weight' => '500',
												'border-radius' => '3px',
												'padding' => '0px 0px 8px 0px',
												'inner-padding' => '10px 25px 10px 25px',
												'line-height' => '1.75',
												'target'  => '_blank',
												'vertical-align' => 'middle',
												'border'  => 'none',
												'text-align' => 'center',
												'href'    => '#',
												'font-size' => '15px',
												'font-family' => 'Arial',
											),
											'children'   => array(),
										),
										1 => array(
											'type'       => 'text',
											'data'       => array(
												'value' => array(
													'content' => 'SHIPS IMMEDIATELY',
												),
											),
											'attributes' => array(
												'padding' => '0px 0px 30px 0px',
												'align'   => 'center',
												'color'   => '#2B2D38',
												'font-size' => '28px',
												'line-height' => '1.2',
												'font-weight' => '500',
												'font-family' => 'Arial',
											),
											'children'   => array(),
										),
										2 => array(
											'type'       => 'text',
											'data'       => array(
												'value' => array(
													'content' => 'Get ready to make some space in your closet because all the items listed below are currently in stock and ready to ship!&nbsp;<div><br></div><div>Thank you again for choosing us for your needs. We look forward to serving you again soon. Keep an eye out for your shipping notification.</div>',
												),
											),
											'attributes' => array(
												'align'   => 'left',
												'background-color' => '#414141',
												'color'   => '#878792',
												'font-weight' => '400',
												'border-radius' => '3px',
												'padding' => '0px 0px 0px 0px',
												'inner-padding' => '10px 25px 10px 25px',
												'line-height' => '1.75',
												'target'  => '_blank',
												'vertical-align' => 'middle',
												'border'  => 'none',
												'text-align' => 'center',
												'href'    => '#',
												'font-size' => '16px',
												'font-family' => 'Arial',
											),
											'children'   => array(),
										),
										3 => array(
											'type'       => 'advanced_image',
											'data'       => array(
												'value' => array(),
											),
											'attributes' => array(
												'align'   => 'center',
												'height'  => 'auto',
												'padding' => '0px 0px 0px 0px',
												'src'     => $image_path . 'wedding-ring-box-isolated-white-background.png',
												'width'   => '',
											),
											'children'   => array(),
										),
										4 => array(
											'type'       => 'advanced_text',
											'data'       => array(
												'value' => array(
													'content' => 'Wedding ring',
												),
											),
											'attributes' => array(
												'padding' => '0px 25px 20px 25px',
												'align'   => 'center',
												'font-family' => 'Arial',
												'font-size' => '20px',
												'font-weight' => '500',
												'line-height' => '1.4',
												'letter-spacing' => 'normal',
												'color'   => '#2B2D38',
											),
											'children'   => array(),
										),
										5 => array(
											'type'       => 'advanced_text',
											'data'       => array(
												'value' => array(
													'content' => '$60.00',
												),
											),
											'attributes' => array(
												'padding' => '0px 25px 30px 25px',
												'align'   => 'center',
												'font-family' => 'Arial',
												'font-size' => '36px',
												'font-weight' => '500',
												'line-height' => '1.4',
												'letter-spacing' => 'normal',
												'color'   => '#2B2D38',
											),
											'children'   => array(),
										),
										6 => array(
											'type'       => 'advanced_divider',
											'data'       => array(
												'value' => array(),
											),
											'attributes' => array(
												'align'   => 'center',
												'border-width' => '1px',
												'border-style' => 'solid',
												'border-color' => '#E2E3EC',
												'padding' => '0px 0px 0px 0px',
											),
											'children'   => array(),
										),
									),
								),
								7  => array(
									'type'       => 'advanced_section',
									'data'       => array(
										'value' => array(
											'noWrap' => false,
										),
									),
									'attributes' => array(
										'background-color' => '#ffffff',
										'padding'          => '0px 0px 20px 0px',
										'background-repeat' => 'repeat',
										'background-size'  => 'auto',
										'background-position' => 'top center',
										'border'           => 'none',
										'direction'        => 'ltr',
										'text-align'       => 'center',
									),
									'children'   => array(
										0 => array(
											'type'       => 'advanced_column',
											'attributes' => array(
												'width'   => array(
													0 => '25%',
													1 => '25%',
													2 => '25%',
													3 => '25%',
												),
												'padding' => '0px 0px 0px 0px',
											),
											'data'       => array(
												'value' => array(),
											),
											'children'   => array(
												0 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => 'Have questions or need help? Drop us a note at&nbsp;<span data-metadata="<!--(figmeta)eyJmaWxlS2V5IjoiMUVBQ0g5ZVE2SWFOdlhKeEYyRERaeiIsInBhc3RlSUQiOjI0NzY2NTA2NCwiZGF0YVR5cGUiOiJzY2VuZSJ9Cg==(/figmeta)-->"></span><span data-buffer="<!--(figma)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(/figma)-->"></span><span style="color: rgb(2, 2, 0); white-space: pre-wrap;">diamond</span><a href="#" target="_blank" style="text-decoration: none;" tabindex="-1"><font style=""><font color="#000000">@gmail.co</font><font color="#020200">m</font></font></a>&nbsp;We’re glad you’re here!',
														),
													),
													'attributes' => array(
														'padding' => '0px 20px 10px 20px',
														'align' => 'center',
														'font-family' => 'Arial',
														'font-size' => '16px',
														'font-weight' => '400',
														'line-height' => '1.62',
														'letter-spacing' => 'normal',
														'color' => '#878792',
													),
													'children' => array(),
												),
											),
										),
									),
								),
								8  => array(
									'type'       => 'advanced_social',
									'data'       => array(
										'value' => array(
											'elements' => array(
												0 => array(
													'href' => '',
													'target' => '_blank',
													'src'  => $image_path . $pinterest,
													'content' => '',
												),
												1 => array(
													'href' => '',
													'target' => '_blank',
													'src'  => $image_path . $facebook,
													'content' => '',
												),
												2 => array(
													'href' => '',
													'target' => '_blank',
													'src'  => $image_path . $instagram,
													'content' => '',
												),
												3 => array(
													'href' => '',
													'target' => '_blank',
													'src'  => $image_path . $twitter,
													'content' => '',
												),
											),
										),
									),
									'attributes' => array(
										'align'         => 'center',
										'color'         => '#333333',
										'mode'          => 'horizontal',
										'font-size'     => '13px',
										'font-weight'   => 'normal',
										'border-radius' => '3px',
										'padding'       => '36px 25px 36px 25px',
										'inner-padding' => '4px 5px 4px 5px',
										'line-height'   => '22px',
										'text-padding'  => '4px 4px 4px 0px',
										'icon-padding'  => '0px',
										'icon-size'     => '40px',
									),
									'children'   => array(),
								),
								9  => array(
									'type'       => 'advanced_divider',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'align'        => 'center',
										'border-width' => '1px',
										'border-style' => 'solid',
										'border-color' => '#E2E3EC',
										'padding'      => '0px 0px 0px 0px',
									),
									'children'   => array(),
								),
								10 => array(
									'type'       => 'advanced_text',
									'data'       => array(
										'value' => array(
											'content' => 'No longer want to be Mail Mint friends?<br>&nbsp;<a href="{{link.preference}}" target="_blank" style="color: inherit; text-decoration: underline;" tabindex="-1">Email Preference</a>&nbsp; |&nbsp;&nbsp;<a href="{{link.unsubscribe}}" target="_blank" style="color: inherit; text-decoration: underline;" tabindex="-1">Unsubscribe</a><b><br></b>',
										),
									),
									'attributes' => array(
										'padding'     => '30px 0px 24px 0px',
										'align'       => 'center',
										'color'       => 'rgba(135, 135, 146, 1)',
										'line-height' => '1.6',
										'font-size'   => '15px',
										'font-family' => 'Arial',
										'font-weight' => '400',
									),
									'children'   => array(),
								),
								11 => array(
									'type'       => 'advanced_text',
									'data'       => array(
										'value' => array(
											'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
										),
									),
									'attributes' => array(
										'padding'        => '0px 0px 0px 0px',
										'align'          => 'center',
										'font-family'    => 'Arial',
										'font-size'      => '14px',
										'font-weight'    => '400',
										'line-height'    => '1.7',
										'letter-spacing' => 'normal',
										'color'          => 'rgba(135, 135, 146, 1)',
									),
									'children'   => array(),
								),
							),
						),
					),
				),
			);
		}
		if ( !empty( $templates[ 11 ] ) && empty( $templates[ 11 ][ 'json_content' ] ) ) {
			$templates[ 11 ]['json_content'] = array(
				'subject'  => 'Welcome to MINT CRM email',
				'subTitle' => 'Nice to meet you!',
				'content'  => array(
					'type'       => 'page',
					'data'       => array(
						'value' => array(
							'breakpoint'     => '480px',
							'headAttributes' => '',
							'font-size'      => '14px',
							'line-height'    => '1.7',
							'headStyles'     => array(),
							'fonts'          => array(),
							'responsive'     => true,
							'font-family'    => 'lucida Grande,Verdana,Microsoft YaHei',
							'text-color'     => '#000000',
						),
					),
					'attributes' => array(
						'background-color' => '#ececec',
						'width'            => '600px',
						'css-class'        => 'mjml-body',
					),
					'children'   => array(
						0 => array(
							'type'       => 'advanced_wrapper',
							'data'       => array(
								'value' => array(),
							),
							'attributes' => array(
								'background-color' => '#F5F6FB',
								'padding'          => '26px 24px 38px 24px',
								'border'           => 'none',
								'direction'        => 'ltr',
								'text-align'       => 'center',
							),
							'children'   => array(
								0  => array(
									'type'       => 'advanced_image',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'align'   => 'center',
										'height'  => 'auto',
										'padding' => '0px 0px 26px 0px',
										'src'     => $image_path . 'left-logo.png',
										'width'   => '100%',
										'href'    => '#',
									),
									'children'   => array(),
								),
								1  => array(
									'type'       => 'advanced_divider',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'align'        => 'center',
										'border-width' => '1px',
										'border-style' => 'solid',
										'border-color' => '#E5E7F2',
										'padding'      => '0px 0px 0px 0px',
									),
									'children'   => array(),
								),
								2  => array(
									'type'       => 'advanced_text',
									'data'       => array(
										'value' => array(
											'content' => 'Free shipping on orders over $70',
										),
									),
									'attributes' => array(
										'padding'        => '14px 25px 14px 25px',
										'align'          => 'center',
										'font-family'    => 'Arial',
										'font-size'      => '16px',
										'font-weight'    => '600',
										'line-height'    => '1.7',
										'letter-spacing' => 'normal',
										'color'          => '#000000',
									),
									'children'   => array(),
								),
								3  => array(
									'type'       => 'advanced_hero',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'background-color' => '#fff',
										'background-position' => 'center center',
										'mode'             => 'fluid-height',
										'padding'          => '70px 20px 70px 20px',
										'vertical-align'   => 'top',
										'background-url'   => $image_path . 'savor-hero-bg.png',
									),
									'children'   => array(
										0 => array(
											'type'       => 'text',
											'data'       => array(
												'value' => array(
													'content' => 'Savor the goodness in every healthy sip!',
												),
											),
											'attributes' => array(
												'padding' => '0px 0px 30px 0px',
												'align'   => 'center',
												'color'   => '#FFFFFF',
												'font-size' => '40px',
												'line-height' => '1.22',
												'font-weight' => '700',
												'font-family' => 'Arial',
											),
											'children'   => array(),
										),
										1 => array(
											'type'       => 'advanced_button',
											'data'       => array(
												'value' => array(
													'content' => 'SHOP NOW',
												),
											),
											'attributes' => array(
												'align'   => 'center',
												'font-family' => 'Arial',
												'background-color' => '#03D77C',
												'color'   => '#ffffff',
												'font-weight' => '600',
												'font-style' => 'normal',
												'border-radius' => '100px',
												'padding' => '0px 25px 0px 25px',
												'inner-padding' => '17px 30px 17px 30px',
												'font-size' => '15px',
												'line-height' => '1.2',
												'target'  => '_blank',
												'vertical-align' => 'middle',
												'border'  => 'none',
												'text-align' => 'center',
												'letter-spacing' => 'normal',
												'href'    => '#',
											),
											'children'   => array(),
										),
									),
								),
								4  => array(
									'type'       => 'advanced_spacer',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'height'  => '24px',
										'padding' => '   ',
									),
									'children'   => array(),
								),
								5  => array(
									'type'       => 'advanced_image',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'align'   => 'center',
										'height'  => 'auto',
										'padding' => '0px 0px 0px 0px',
										'src'     => $image_path . 'savor-hero-image.png',
									),
									'children'   => array(),
								),
								6  => array(
									'type'       => 'advanced_section',
									'data'       => array(
										'value' => array(
											'noWrap' => false,
										),
									),
									'attributes' => array(
										'background-color' => '#ffffff',
										'padding'          => '30px 20px 40px 20px',
										'background-repeat' => 'repeat',
										'background-size'  => 'auto',
										'background-position' => 'top center',
										'border'           => 'none',
										'direction'        => 'ltr',
										'text-align'       => 'center',
									),
									'children'   => array(
										0 => array(
											'type'       => 'advanced_column',
											'attributes' => array(
												'width'   => array(
													0 => '25%',
													1 => '25%',
													2 => '25%',
													3 => '25%',
												),
												'padding' => '0px 0px 0px 0px',
											),
											'data'       => array(
												'value' => array(),
											),
											'children'   => array(
												0 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => 'Get An Exclusive Experience!',
														),
													),
													'attributes' => array(
														'padding' => '0px 0px 16px 0px',
														'align' => 'center',
														'font-family' => 'Arial',
														'font-size' => '24px',
														'font-weight' => '600',
														'line-height' => '1.4',
														'letter-spacing' => 'normal',
														'color' => '#2B2D38',
													),
													'children' => array(),
												),
												1 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => 'While we can\'t assist you with healthy juices, we have something even better - a recipe that guarantees an out-of-body experience!',
														),
													),
													'attributes' => array(
														'padding' => '0px 0px 30px 0px',
														'align' => 'center',
														'font-family' => 'Arial',
														'font-size' => '16px',
														'font-weight' => '400',
														'line-height' => '1.62',
														'letter-spacing' => 'normal',
														'color' => '#878792',
													),
													'children' => array(),
												),
												2 => array(
													'type' => 'advanced_button',
													'data' => array(
														'value' => array(
															'content' => 'VISIT US TO DISCOVER THE FRESHEST JUICES',
														),
													),
													'attributes' => array(
														'align' => 'center',
														'font-family' => 'Arial',
														'background-color' => '#03D77C',
														'color' => '#ffffff',
														'font-weight' => '600',
														'font-style' => 'normal',
														'border-radius' => '100px',
														'padding' => '0px 0px 0px 0px',
														'inner-padding' => '17px 40px 17px 40px',
														'font-size' => '15px',
														'line-height' => '1.4',
														'target' => '_blank',
														'vertical-align' => 'middle',
														'border' => 'none',
														'text-align' => 'center',
														'letter-spacing' => 'normal',
														'href' => '#',
													),
													'children' => array(),
												),
											),
										),
									),
								),
								7  => array(
									'type'       => 'advanced_spacer',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'height'  => '24px',
										'padding' => '   ',
									),
									'children'   => array(),
								),
								8  => array(
									'type'       => 'advanced_section',
									'data'       => array(
										'value' => array(
											'noWrap' => false,
										),
									),
									'attributes' => array(
										'background-color' => '#ffffff',
										'padding'          => '24px 40px 24px 24px',
										'background-repeat' => 'repeat',
										'background-size'  => 'auto',
										'background-position' => 'top center',
										'border'           => '',
										'direction'        => 'ltr',
										'text-align'       => 'center',
									),
									'children'   => array(
										0 => array(
											'type'       => 'advanced_column',
											'attributes' => array(
												'width'   => '50%',
												'padding' => '0px 0px 0px 0px',
												'vertical-align' => 'middle',
											),
											'data'       => array(
												'value' => array(),
											),
											'children'   => array(
												0 => array(
													'type' => 'advanced_image',
													'data' => array(
														'value' => array(),
													),
													'attributes' => array(
														'align' => 'left',
														'height' => 'auto',
														'padding' => '0px 0px 0px 0px',
														'src' => $image_path . 'stawberry-juice.png',
													),
													'children' => array(),
												),
											),
										),
										1 => array(
											'type'       => 'advanced_column',
											'attributes' => array(
												'width'   => '50%',
												'padding' => '0px 0px 0px 0px',
												'vertical-align' => 'middle',
											),
											'data'       => array(
												'value' => array(),
											),
											'children'   => array(
												0 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => 'Strawberry fruit juice',
														),
													),
													'attributes' => array(
														'padding' => '20px 0px 10px 20px',
														'align' => 'left',
														'font-family' => 'Arial',
														'font-size' => '22px',
														'font-weight' => '500',
														'line-height' => '1.2',
														'letter-spacing' => 'normal',
														'color' => '#0E1D3F',
													),
													'children' => array(),
												),
												1 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => '$40.33',
														),
													),
													'attributes' => array(
														'padding' => '0px 0px 20px 20px',
														'align' => 'left',
														'font-family' => 'Arial',
														'font-size' => '16px',
														'font-weight' => '400',
														'line-height' => '1',
														'letter-spacing' => 'normal',
														'color' => '#878792',
													),
													'children' => array(),
												),
												2 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => '<a href="#" target="_blank" style="color: inherit; text-decoration: none;" tabindex="-1">SHOP NOW</a>',
														),
													),
													'attributes' => array(
														'padding' => '0px 0px 20px 20px',
														'align' => 'left',
														'font-family' => 'Arial',
														'font-size' => '15px',
														'font-weight' => '600',
														'line-height' => '1',
														'letter-spacing' => 'normal',
														'color' => '#03D77C',
													),
													'children' => array(),
												),
											),
										),
									),
								),
								9  => array(
									'type'       => 'advanced_spacer',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'height'  => '24px',
										'padding' => '   ',
									),
									'children'   => array(),
								),
								10 => array(
									'type'       => 'advanced_section',
									'data'       => array(
										'value' => array(
											'noWrap' => false,
										),
									),
									'attributes' => array(
										'background-color' => '#ffffff',
										'padding'          => '24px 40px 24px 24px',
										'background-repeat' => 'repeat',
										'background-size'  => 'auto',
										'background-position' => 'top center',
										'border'           => '',
										'direction'        => 'ltr',
										'text-align'       => 'center',
									),
									'children'   => array(
										0 => array(
											'type'       => 'advanced_column',
											'attributes' => array(
												'width'   => '50%',
												'padding' => '0px 0px 0px 0px',
												'vertical-align' => 'middle',
											),
											'data'       => array(
												'value' => array(),
											),
											'children'   => array(
												0 => array(
													'type' => 'advanced_image',
													'data' => array(
														'value' => array(),
													),
													'attributes' => array(
														'align' => 'left',
														'height' => 'auto',
														'padding' => '0px 0px 0px 0px',
														'src' => $image_path . 'banana-juice.png',
													),
													'children' => array(),
												),
											),
										),
										1 => array(
											'type'       => 'advanced_column',
											'attributes' => array(
												'width'   => '50%',
												'padding' => '0px 0px 0px 0px',
												'vertical-align' => 'middle',
											),
											'data'       => array(
												'value' => array(),
											),
											'children'   => array(
												0 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => 'Banana fruit juice',
														),
													),
													'attributes' => array(
														'padding' => '20px 0px 10px 20px',
														'align' => 'left',
														'font-family' => 'Arial',
														'font-size' => '22px',
														'font-weight' => '500',
														'line-height' => '1.2',
														'letter-spacing' => 'normal',
														'color' => '#0E1D3F',
													),
													'children' => array(),
												),
												1 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => '$40.33',
														),
													),
													'attributes' => array(
														'padding' => '0px 0px 20px 20px',
														'align' => 'left',
														'font-family' => 'Arial',
														'font-size' => '16px',
														'font-weight' => '400',
														'line-height' => '1',
														'letter-spacing' => 'normal',
														'color' => '#878792',
													),
													'children' => array(),
												),
												2 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => '<a href="#" target="_blank" style="color: inherit; text-decoration: none;">SHOP NOW</a>',
														),
													),
													'attributes' => array(
														'padding' => '0px 0px 20px 20px',
														'align' => 'left',
														'font-family' => 'Arial',
														'font-size' => '15px',
														'font-weight' => '600',
														'line-height' => '1',
														'letter-spacing' => 'normal',
														'color' => '#03D77C',
													),
													'children' => array(),
												),
											),
										),
									),
								),
								11 => array(
									'type'       => 'advanced_spacer',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'height'  => '24px',
										'padding' => '   ',
									),
									'children'   => array(),
								),
								12 => array(
									'type'       => 'advanced_section',
									'data'       => array(
										'value' => array(
											'noWrap' => false,
										),
									),
									'attributes' => array(
										'background-color' => '#03D77C',
										'padding'          => '30px 0px 30px 0px',
										'background-repeat' => 'repeat',
										'background-size'  => 'auto',
										'background-position' => 'top center',
										'border'           => 'none',
										'direction'        => 'ltr',
										'text-align'       => 'center',
									),
									'children'   => array(
										0 => array(
											'type'       => 'advanced_column',
											'attributes' => array(
												'width'   => '50%',
												'padding' => '10px 20px 10px 20px',
												'vertical-align' => 'middle',
											),
											'data'       => array(
												'value' => array(),
											),
											'children'   => array(
												0 => array(
													'type' => 'advanced_image',
													'data' => array(
														'value' => array(),
													),
													'attributes' => array(
														'align' => 'center',
														'height' => 'auto',
														'padding' => '0px 0px 0px 0px',
														'src' => $image_path . 'service-icon.png',
														'width' => '32px',
													),
													'children' => array(),
												),
												1 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => 'Express Shipping Available',
														),
													),
													'attributes' => array(
														'padding' => '8px 25px 0px 25px',
														'align' => 'center',
														'font-family' => 'Arial',
														'font-size' => '16px',
														'font-weight' => '400',
														'line-height' => '1.5',
														'letter-spacing' => 'normal',
														'color' => '#FFFFFFCC',
														'container-background-color' => '',
													),
													'children' => array(),
												),
											),
										),
										1 => array(
											'type'       => 'advanced_column',
											'attributes' => array(
												'width'   => '50%',
												'padding' => '10px 20px 10px 20px',
												'vertical-align' => 'middle',
											),
											'data'       => array(
												'value' => array(),
											),
											'children'   => array(
												0 => array(
													'type' => 'advanced_image',
													'data' => array(
														'value' => array(),
													),
													'attributes' => array(
														'align' => 'center',
														'height' => 'auto',
														'padding' => '0px 0px 0px 0px',
														'src' => $image_path . 'gift-icon.png',
														'width' => '34px',
													),
													'children' => array(),
												),
												1 => array(
													'type' => 'advanced_text',
													'data' => array(
														'value' => array(
															'content' => 'Questions? <u>Contact</u> us or visit our <u>FAQ page</u>',
														),
													),
													'attributes' => array(
														'padding' => '11px 25px 0px 25px',
														'align' => 'center',
														'font-family' => 'Arial',
														'font-size' => '16px',
														'font-weight' => '400',
														'line-height' => '1.5',
														'letter-spacing' => 'normal',
														'color' => '#FFFFFFCC',
														'container-background-color' => '',
													),
													'children' => array(),
												),
											),
										),
									),
								),
								13 => array(
									'type'       => 'advanced_divider',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'align'        => 'center',
										'border-width' => '1px',
										'border-style' => 'solid',
										'border-color' => 'EBEBEB',
										'padding'      => '0px 40px 0px 40px',
										'container-background-color' => '#fff',
									),
									'children'   => array(),
								),
								14 => array(
									'type'       => 'advanced_social',
									'data'       => array(
										'value' => array(
											'elements' => array(
												0 => array(
													'href' => '#',
													'target' => '_blank',
													'src'  => $image_path . $pinterest,
													'content' => '',
												),
												1 => array(
													'href' => '#',
													'target' => '_blank',
													'src'  => $image_path . $facebook,
													'content' => '',
												),
												2 => array(
													'href' => '',
													'target' => '_blank',
													'src'  => $image_path . $instagram,
													'content' => '',
												),
												3 => array(
													'href' => '',
													'target' => '_blank',
													'src'  => $image_path . $twitter,
													'content' => '',
												),
											),
										),
									),
									'attributes' => array(
										'align'         => 'center',
										'color'         => '#333333',
										'mode'          => 'horizontal',
										'font-size'     => '13px',
										'font-weight'   => 'normal',
										'border-radius' => '3px',
										'padding'       => '36px 25px 36px 25px',
										'inner-padding' => '4px 5px 4px 5px',
										'line-height'   => '22px',
										'text-padding'  => '4px 4px 4px 0px',
										'icon-padding'  => '0px',
										'icon-size'     => '40px',
									),
									'children'   => array(),
								),
								15 => array(
									'type'       => 'advanced_divider',
									'data'       => array(
										'value' => array(),
									),
									'attributes' => array(
										'align'        => 'center',
										'border-width' => '1px',
										'border-style' => 'solid',
										'border-color' => '#E2E3EC',
										'padding'      => '0px 0px 0px 0px',
									),
									'children'   => array(),
								),
								16 => array(
									'type'       => 'advanced_text',
									'data'       => array(
										'value' => array(
											'content' => 'No longer want to be Mail Mint friends?<br>&nbsp;<a href="{{link.preference}}" target="_blank" style="color: inherit; text-decoration: underline;" tabindex="-1">Email Preference</a>&nbsp; |&nbsp;&nbsp;<a href="{{link.unsubscribe}}" target="_blank" style="color: inherit; text-decoration: underline;" tabindex="-1">Unsubscribe</a><b><br></b>',
										),
									),
									'attributes' => array(
										'padding'     => '30px 0px 24px 0px',
										'align'       => 'center',
										'color'       => 'rgba(135, 135, 146, 1)',
										'line-height' => '1.60',
										'font-size'   => '15px',
										'font-family' => 'Arial',
										'font-weight' => '400',
									),
									'children'   => array(),
								),
								17 => array(
									'type'       => 'advanced_text',
									'data'       => array(
										'value' => array(
											'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
										),
									),
									'attributes' => array(
										'padding'        => '0px 35px 0px 35px',
										'align'          => 'center',
										'font-family'    => 'Arial',
										'font-size'      => '14px',
										'font-weight'    => '400',
										'line-height'    => '1.7',
										'letter-spacing' => 'normal',
										'color'          => 'rgba(135, 135, 146, 1)',
									),
									'children'   => array(),
								),
							),
						),
					),
				),
			);
		}
    if ( !empty( $templates[ 21 ] ) && empty( $templates[ 21 ][ 'json_content' ] ) ){
        $templates[ 21 ]['json_content'] = array (
            'subject' => 'Welcome to Mail Mint email marketing and automation',
            'subTitle' => 'Nice to meet you!',
            'content' => 
            array (
              'type' => 'page',
              'data' => 
              array (
                'value' => 
                array (
                  'breakpoint' => '480px',
                  'headAttributes' => '',
                  'font-size' => '14px',
                  'font-weight' => '400',
                  'line-height' => '1.7',
                  'headStyles' => 
                  array (
                  ),
                  'fonts' => 
                  array (
                  ),
                  'responsive' => true,
                  'font-family' => 'Arial',
                  'text-color' => '#000000',
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#efeeea',
                'width' => '600px',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_wrapper',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#F3F3F3',
                    'padding' => '24px 24px 24px 24px',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '0px 0px 24px 0px',
                        'src'   => $image_path . 'your-logo.png',
                        'width' => '100%',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_hero',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'background-color' => '#ffffff',
                        'background-position' => 'center center',
                        'mode' => 'fluid-height',
                        'padding' => '50px 10px 50px 10px',
                        'vertical-align' => 'top',
                        'background-url' => $image_path . 'event-invitation/hero-bg.png',
                        'border-radius' => '20px',
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Unlock Learning Impact: Join Our Webinar on Effective Tech Stacks',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 25px 10px 25px',
                            'align' => 'center',
                            'color' => '#FFFFFF',
                            'font-size' => '40px',
                            'line-height' => '1.5',
                            'font-weight' => '700',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Wednesday, April 26,2023  .  16:00 - 8:30 PDT',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'background-color' => '#414141',
                            'color' => '#E4E4E4',
                            'font-weight' => '500',
                            'border-radius' => '3px',
                            'padding' => '30px 25px 50px 25px',
                            'inner-padding' => '10px 25px 10px 25px',
                            'line-height' => '1.5',
                            'target' => '_blank',
                            'vertical-align' => 'middle',
                            'border' => 'none',
                            'text-align' => 'center',
                            'href' => '#',
                            'font-size' => '18px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        2 => 
                        array (
                          'type' => 'button',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Register Now',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'background-color' => '#573BFF',
                            'color' => '#ffffff',
                            'font-size' => '16px',
                            'font-weight' => 'normal',
                            'border-radius' => '30px',
                            'padding' => '10px 25px 10px 25px',
                            'inner-padding' => '17px 40px 17px 40px',
                            'line-height' => '1',
                            'target' => '_blank',
                            'vertical-align' => 'middle',
                            'border' => 'none',
                            'text-align' => 'center',
                            'href' => '#',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_spacer',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'height' => '40px',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    3 => 
                    array (
                      'type' => 'advanced_hero',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'background-color' => '',
                        'background-position' => 'center center',
                        'mode' => 'fluid-height',
                        'padding' => '30px 40px 30px 40px',
                        'vertical-align' => 'top',
                        'background-url' => '',
                        'border-radius' => '20px',
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Dear John Doe,',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '0px 0px 20px 0px',
                            'align' => 'left',
                            'font-size' => '16px',
                            'line-height' => '1.7',
                            'color' => '#0B1B1B',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Hope this message finds you well! We\'re thrilled to invite you to our upcoming webinar, "Maximizing Learning Impact With an Effective Tech Stack."&nbsp;<div><br></div><div>&nbsp;In this session, we\'ll explore how the right technology stack can elevate the impact of your learning initiatives. From enhancing engagement to tracking progress, we\'ve got the insights to revolutionize your approach.</div>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '0px 0px 30px 0px',
                            'align' => 'left',
                            'font-size' => '16px',
                            'line-height' => '1.7',
                            'color' => '#0B1B1B',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        2 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Key Highlights:<br>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '0px 0px 20px 0px',
                            'align' => 'left',
                            'font-size' => '20px',
                            'line-height' => '1.7',
                            'color' => '#353535',
                            'font-weight' => '700',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        3 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => '<ul><li><b>Live Interaction:</b> Engage in real-time discussions, ask questions, and connect with fellow participants.</li><li><b>Screen Sharing:</b> Visualize concepts with dynamic presentations, live demonstrations, and interactive content.<br></li><li><b>Q&amp;A Sessions: </b>Pose questions directly to our expert panel and gain valuable insights.<br></li></ul>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '0px 0px 20px 0px',
                            'align' => 'left',
                            'font-size' => '16px',
                            'line-height' => '1.8',
                            'color' => '#0B1B1B',
                            'font-weight' => '400',
                            'text-decoration' => '',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        4 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Don\'t miss out on this opportunity to revolutionize your learning approach with cutting-edge technology. <a href="#" target="_blank" style="" tabindex="-1"><font color="#0064ff">Register now</font></a>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '0px 0px 20px 0px',
                            'align' => 'left',
                            'font-size' => '16px',
                            'line-height' => '1.7',
                            'color' => '#0B1B1B',
                            'text-decoration' => '',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    4 => 
                    array (
                      'type' => 'advanced_spacer',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'height' => '40px',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    5 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Meet Our Speakers',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 25px 0px 25px',
                        'align' => 'center',
                        'font-size' => '28px',
                        'line-height' => '0.85',
                        'color' => '#353535',
                        'font-weight' => '700',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    6 => 
                    array (
                      'type' => 'advanced_section',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'noWrap' => false,
                        ),
                      ),
                      'attributes' => 
                      array (
                        'background-color' => '',
                        'padding' => '20px 0px 0px 0px',
                        'background-repeat' => 'repeat',
                        'background-size' => 'auto',
                        'background-position' => 'top center',
                        'border' => 'none',
                        'direction' => 'ltr',
                        'text-align' => 'center',
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'group',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'vertical-align' => 'top',
                            'direction' => 'ltr',
                          ),
                          'children' => 
                          array (
                            0 => 
                            array (
                              'type' => 'advanced_column',
                              'attributes' => 
                              array (
                                'width' => '33.33%',
                                'padding' => '0px 0px 0px 0px',
                              ),
                              'data' => 
                              array (
                                'value' => 
                                array (
                                ),
                              ),
                              'children' => 
                              array (
                                0 => 
                                array (
                                  'type' => 'advanced_image',
                                  'data' => 
                                  array (
                                    'value' => 
                                    array (
                                    ),
                                  ),
                                  'attributes' => 
                                  array (
                                    'align' => 'center',
                                    'height' => 'auto',
                                    'padding' => '0px 15px 0px 15px',
                                    'src' => $image_path . 'event-invitation/client-1.png',
                                  ),
                                  'children' => 
                                  array (
                                  ),
                                ),
                                1 => 
                                array (
                                  'type' => 'advanced_text',
                                  'data' => 
                                  array (
                                    'value' => 
                                    array (
                                      'content' => 'Alexandra Webster',
                                    ),
                                  ),
                                  'attributes' => 
                                  array (
                                    'padding' => '10px 0px 0px 25px',
                                    'align' => 'left',
                                    'font-size' => '16px',
                                    'line-height' => '1',
                                    'font-weight' => '700',
                                    'color' => '#353535',
                                  ),
                                  'children' => 
                                  array (
                                  ),
                                ),
                                2 => 
                                array (
                                  'type' => 'advanced_text',
                                  'data' => 
                                  array (
                                    'value' => 
                                    array (
                                      'content' => 'Senior Learning Consultant',
                                    ),
                                  ),
                                  'attributes' => 
                                  array (
                                    'padding' => '8px 0px 10px 25px',
                                    'align' => 'center',
                                    'font-size' => '15px',
                                    'line-height' => '1.3',
                                    'font-weight' => '400',
                                    'color' => '#353535',
                                  ),
                                  'children' => 
                                  array (
                                  ),
                                ),
                              ),
                            ),
                            1 => 
                            array (
                              'type' => 'advanced_column',
                              'attributes' => 
                              array (
                                'width' => '33.33%',
                              ),
                              'data' => 
                              array (
                                'value' => 
                                array (
                                ),
                              ),
                              'children' => 
                              array (
                                0 => 
                                array (
                                  'type' => 'advanced_image',
                                  'data' => 
                                  array (
                                    'value' => 
                                    array (
                                    ),
                                  ),
                                  'attributes' => 
                                  array (
                                    'align' => 'center',
                                    'height' => 'auto',
                                    'padding' => '0px 15px 0px 15px',
                                    'src' => $image_path . 'event-invitation/client-2.png',
                                  ),
                                  'children' => 
                                  array (
                                  ),
                                ),
                                1 => 
                                array (
                                  'type' => 'advanced_text',
                                  'data' => 
                                  array (
                                    'value' => 
                                    array (
                                      'content' => 'Alexandra Webster',
                                    ),
                                  ),
                                  'attributes' => 
                                  array (
                                    'padding' => '10px 0px 0px 25px',
                                    'align' => 'left',
                                    'font-size' => '16px',
                                    'line-height' => '1',
                                    'font-weight' => '700',
                                    'color' => '#353535',
                                  ),
                                  'children' => 
                                  array (
                                  ),
                                ),
                                2 => 
                                array (
                                  'type' => 'advanced_text',
                                  'data' => 
                                  array (
                                    'value' => 
                                    array (
                                      'content' => 'Senior Learning Consultant',
                                    ),
                                  ),
                                  'attributes' => 
                                  array (
                                    'padding' => '8px 0px 10px 25px',
                                    'align' => 'center',
                                    'font-size' => '15px',
                                    'line-height' => '1.3',
                                    'font-weight' => '400',
                                    'color' => '#353535',
                                  ),
                                  'children' => 
                                  array (
                                  ),
                                ),
                              ),
                            ),
                            2 => 
                            array (
                              'type' => 'advanced_column',
                              'attributes' => 
                              array (
                                'width' => '33.33%',
                              ),
                              'data' => 
                              array (
                                'value' => 
                                array (
                                ),
                              ),
                              'children' => 
                              array (
                                0 => 
                                array (
                                  'type' => 'advanced_image',
                                  'data' => 
                                  array (
                                    'value' => 
                                    array (
                                    ),
                                  ),
                                  'attributes' => 
                                  array (
                                    'align' => 'center',
                                    'height' => 'auto',
                                    'padding' => '0px 15px 0px 15px',
                                    'src' => $image_path . 'event-invitation/client-3.png',
                                  ),
                                  'children' => 
                                  array (
                                  ),
                                ),
                                1 => 
                                array (
                                  'type' => 'advanced_text',
                                  'data' => 
                                  array (
                                    'value' => 
                                    array (
                                      'content' => 'Alexandra Webster',
                                    ),
                                  ),
                                  'attributes' => 
                                  array (
                                    'padding' => '10px 0px 0px 25px',
                                    'align' => 'left',
                                    'font-size' => '16px',
                                    'line-height' => '1',
                                    'font-weight' => '700',
                                    'color' => '#353535',
                                  ),
                                  'children' => 
                                  array (
                                  ),
                                ),
                                2 => 
                                array (
                                  'type' => 'advanced_text',
                                  'data' => 
                                  array (
                                    'value' => 
                                    array (
                                      'content' => 'Senior Learning Consultant',
                                    ),
                                  ),
                                  'attributes' => 
                                  array (
                                    'padding' => '8px 0px 10px 25px',
                                    'align' => 'center',
                                    'font-size' => '15px',
                                    'line-height' => '1.3',
                                    'font-weight' => '400',
                                    'color' => '#353535',
                                  ),
                                  'children' => 
                                  array (
                                  ),
                                ),
                              ),
                            ),
                          ),
                        ),
                      ),
                    ),
                    7 => 
                    array (
                      'type' => 'advanced_spacer',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'height' => '40px',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    8 => 
                    array (
                      'type' => 'advanced_hero',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'background-color' => '#ffffff',
                        'background-position' => 'center center',
                        'mode' => 'fluid-height',
                        'padding' => '50px 10px 50px 10px',
                        'vertical-align' => 'top',
                        'background-url' => $image_path . 'event-invitation/event-bg.png',
                        'border-radius' => '20px',
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Event Details',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 25px 10px 25px',
                            'align' => 'center',
                            'color' => '#FFFFFF',
                            'font-size' => '40px',
                            'line-height' => '1.5',
                            'font-weight' => '700',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Maximizing Learning Impact With an Effective Tech Stack.',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '0px 35px 0px 35px',
                            'align' => 'center',
                            'font-size' => '24px',
                            'line-height' => '1.5',
                            'font-weight' => '500',
                            'color' => '#FFFFFF',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        2 => 
                        array (
                          'type' => 'text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Wednesday, April 26,2023  .  16:00 - 8:30 PDT',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'background-color' => '#414141',
                            'color' => '#E4E4E4',
                            'font-weight' => '500',
                            'border-radius' => '3px',
                            'padding' => '16px 25px 40px 25px',
                            'inner-padding' => '10px 25px 10px 25px',
                            'line-height' => '1.5',
                            'target' => '_blank',
                            'vertical-align' => 'middle',
                            'border' => 'none',
                            'text-align' => 'center',
                            'href' => '#',
                            'font-size' => '18px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        3 => 
                        array (
                          'type' => 'button',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Register Now',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'background-color' => '#FFFFFF',
                            'color' => '#0064FF',
                            'font-size' => '16px',
                            'font-weight' => 'normal',
                            'border-radius' => '30px',
                            'padding' => '0px 25px 10px 25px',
                            'inner-padding' => '17px 40px 17px 40px',
                            'line-height' => '1',
                            'target' => '_blank',
                            'vertical-align' => 'middle',
                            'border' => 'none',
                            'text-align' => 'center',
                            'href' => '#',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    9 => 
                    array (
                      'type' => 'advanced_spacer',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'height' => '30px',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    10 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Need Help? Ask at <font color="#0064ff"><a href="#" target="_blank" style="color: inherit; text-decoration: underline;" tabindex="-1">Customer Support</a></font>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 25px 10px 25px',
                        'align' => 'center',
                        'font-size' => '16px',
                        'line-height' => '1',
                        'font-weight' => '700',
                        'color' => '#333232',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    11 => 
                    array (
                      'type' => 'advanced_divider',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'border-width' => '1px',
                        'border-style' => 'solid',
                        'border-color' => '#E4E4E4',
                        'padding' => '10px 0px 10px 0px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    12 => 
                    array (
                      'type' => 'advanced_social',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'elements' => 
                          array (
                            0 => 
                            array (
                              'href' => '#',
                              'target' => '_blank',
                              'src' => $image_path . 'event-invitation/pinterest.png',
                              'content' => '',
                            ),
                            1 => 
                            array (
                              'href' => '#',
                              'target' => '_blank',
                              'src' => $image_path . 'event-invitation/facebook.png',
                              'content' => '',
                            ),
                            2 => 
                            array (
                              'href' => '#',
                              'target' => '_blank',
                              'src' => $image_path . 'event-invitation/instagram.png',
                              'content' => '',
                            ),
                            3 => 
                            array (
                              'href' => '#',
                              'target' => '_blank',
                              'src' => $image_path . 'event-invitation/twitter.png',
                              'content' => '',
                            ),
                          ),
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'color' => '#333333',
                        'mode' => 'horizontal',
                        'font-size' => '13px',
                        'font-weight' => 'normal',
                        'font-style' => 'normal',
                        'font-family' => 'Arial',
                        'border-radius' => '3px',
                        'padding' => '10px 0px 10px 0px',
                        'inner-padding' => '4px 20px 4px 0px',
                        'line-height' => '1.6',
                        'text-padding' => '4px 4px 4px 0px',
                        'icon-padding' => '0px',
                        'icon-size' => '40px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    13 => 
                    array (
                      'type' => 'advanced_divider',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'border-width' => '1px',
                        'border-style' => 'solid',
                        'border-color' => '#E4E4E4',
                        'padding' => '10px 0px 10px 0px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    14 => 
                    array (
                      'type' => 'advanced_spacer',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'height' => '40px',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    15 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'No longer want to be Mail Mint friends?',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 25px 8px 25px',
                        'align' => 'center',
                        'font-size' => '15px',
                        'line-height' => '1.4',
                        'color' => '#666666',
                        'font-weight' => '500',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    16 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<a href="{{link.preference}}" target="_blank" style="color: inherit; text-decoration: underline;">Email Preference</a>&nbsp;.&nbsp;<a href="{{link.unsubscribe}}" target="_blank" style="color: inherit; text-decoration: underline;">Unsubscribe</a>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 25px 8px 25px',
                        'align' => 'center',
                        'font-size' => '15px',
                        'line-height' => '1.4',
                        'color' => '#666666',
                        'font-weight' => '500',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    17 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '24px 0px 8px 0px',
                        'align' => 'center',
                        'font-size' => '14px',
                        'line-height' => '1.5',
                        'color' => '#666666',
                        'font-weight' => '400',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
              ),
            ),
        );
    }
    if ( !empty( $templates[ 22 ] ) && empty( $templates[ 22 ][ 'json_content' ] ) ){
        $templates[ 22 ]['json_content'] = array (
          'subTitle' => 'Nice to meet you!',
          'content' => 
          array (
            'type' => 'page',
            'data' => 
            array (
              'value' => 
              array (
                'breakpoint' => '480px',
                'headAttributes' => '',
                'font-size' => '14px',
                'font-weight' => '400',
                'line-height' => '1.7',
                'headStyles' => 
                array (
                ),
                'fonts' => 
                array (
                ),
                'responsive' => true,
                'font-family' => 'Arial',
                'text-color' => '#000000',
              ),
            ),
            'attributes' => 
            array (
              'background-color' => '#efeeea',
              'width' => '600px',
            ),
            'children' => 
            array (
              0 => 
              array (
                'type' => 'advanced_image',
                'data' => 
                array (
                  'value' => 
                  array (
                  ),
                ),
                'attributes' => 
                array (
                  'align' => 'center',
                  'height' => 'auto',
                  'padding' => '17px 0px 18px 0px',
                  'src' => $image_path . 'your-logo.png',
                  'container-background-color' => '#fff',
                  'width' => '100%',
                ),
                'children' => 
                array (
                ),
              ),
              1 => 
              array (
                'type' => 'advanced_wrapper',
                'data' => 
                array (
                  'value' => 
                  array (
                  ),
                ),
                'attributes' => 
                array (
                  'background-color' => '#E9E5EF',
                  'padding' => '0px 24px 0px 24px',
                  'border' => 'none',
                  'direction' => 'ltr',
                  'text-align' => 'center',
                ),
                'children' => 
                array (
                  0 => 
                  array (
                    'type' => 'advanced_text',
                    'data' => 
                    array (
                      'value' => 
                      array (
                        'content' => '🎄 Season\'s Greetings 🎄&nbsp;<div>Exclusive Holiday Offer Inside! 🎁</div>',
                      ),
                    ),
                    'attributes' => 
                    array (
                      'padding' => '30px 0px 0px 0px',
                      'align' => 'center',
                      'font-size' => '30px',
                      'font-weight' => '800',
                      'color' => '#1F1F2D',
                      'font-family' => 'Arial',
                      'line-height' => '1.26',
                    ),
                    'children' => 
                    array (
                    ),
                  ),
                  1 => 
                  array (
                    'type' => 'advanced_section',
                    'data' => 
                    array (
                      'value' => 
                      array (
                        'noWrap' => false,
                      ),
                    ),
                    'attributes' => 
                    array (
                      'background-color' => '',
                      'padding' => '20px 0px 20px 0px',
                      'background-repeat' => 'repeat',
                      'background-size' => 'auto',
                      'background-position' => 'top center',
                      'border' => 'none',
                      'direction' => 'ltr',
                      'text-align' => 'center',
                    ),
                    'children' => 
                    array (
                      0 => 
                      array (
                        'type' => 'advanced_column',
                        'attributes' => 
                        array (
                          'width' => 
                          array (
                            0 => '25%',
                            1 => '25%',
                            2 => '25%',
                            3 => '25%',
                          ),
                          'padding' => '0px 0px 0px 0px',
                        ),
                        'data' => 
                        array (
                          'value' => 
                          array (
                          ),
                        ),
                        'children' => 
                        array (
                          0 => 
                          array (
                            'type' => 'advanced_image',
                            'data' => 
                            array (
                              'value' => 
                              array (
                              ),
                            ),
                            'attributes' => 
                            array (
                              'align' => 'center',
                              'height' => 'auto',
                              'padding' => '0px 0px 0px 0px',
                              'src' => $image_path . 'christmas-exclusive-offer/hero-img.png',
                              'alt' => 'Christmas image',
                            ),
                            'children' => 
                            array (
                            ),
                          ),
                        ),
                      ),
                    ),
                  ),
                  2 => 
                  array (
                    'type' => 'advanced_hero',
                    'data' => 
                    array (
                      'value' => 
                      array (
                      ),
                    ),
                    'attributes' => 
                    array (
                      'background-color' => '#A62625',
                      'background-position' => 'center center',
                      'mode' => 'fluid-height',
                      'padding' => '0px 0px 0px 0px',
                      'vertical-align' => 'top',
                      'background-url' => '',
                      'border-radius' => '20px',
                    ),
                    'children' => 
                    array (
                      0 => 
                      array (
                        'type' => 'text',
                        'data' => 
                        array (
                          'value' => 
                          array (
                            'content' => 'Hello John Doe,',
                          ),
                        ),
                        'attributes' => 
                        array (
                          'padding' => '40px 66px 0px 40px',
                          'align' => 'left',
                          'color' => '#FFFFFF',
                          'font-size' => '18px',
                          'line-height' => '1',
                          'font-style' => 'normal',
                          'font-weight' => '400',
                          'font-family' => 'Arial',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                      1 => 
                      array (
                        'type' => 'text',
                        'data' => 
                        array (
                          'value' => 
                          array (
                            'content' => 'As the holiday season is upon us, we wanted to take a moment to express our deepest gratitude for your continued support throughout the year. It\'s been a pleasure serving you, and we\'re truly thankful for the trust you\'ve placed in us.',
                          ),
                        ),
                        'attributes' => 
                        array (
                          'align' => 'left',
                          'background-color' => '#414141',
                          'color' => '#FFFFFFD9',
                          'font-weight' => '400',
                          'border-radius' => '3px',
                          'padding' => '15px 66px 0px 40px',
                          'inner-padding' => '10px 25px 10px 25px',
                          'line-height' => '1.75',
                          'target' => '_blank',
                          'vertical-align' => 'middle',
                          'border' => 'none',
                          'text-align' => 'center',
                          'href' => '#',
                          'font-size' => '16px',
                          'font-family' => 'Arial',
                          'font-style' => 'normal',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                      2 => 
                      array (
                        'type' => 'advanced_divider',
                        'data' => 
                        array (
                          'value' => 
                          array (
                          ),
                        ),
                        'attributes' => 
                        array (
                          'align' => 'center',
                          'border-width' => '1px',
                          'border-style' => 'solid',
                          'border-color' => '#C35150',
                          'padding' => '40px 40px 0px 40px',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                      3 => 
                      array (
                        'type' => 'advanced_text',
                        'data' => 
                        array (
                          'value' => 
                          array (
                            'content' => '🎉 Wishing You a Joyous Holiday Season! 🎄',
                          ),
                        ),
                        'attributes' => 
                        array (
                          'padding' => '40px 0px 0px 0px',
                          'align' => 'center',
                          'color' => '#fff',
                          'font-weight' => '700',
                          'font-size' => '18px',
                          'line-height' => '1.33',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                      4 => 
                      array (
                        'type' => 'advanced_text',
                        'data' => 
                        array (
                          'value' => 
                          array (
                            'content' => 'May this festive season be filled with warmth, joy, and cherished moments with your loved ones. We hope you find time to relax, reflect, and embrace the spirit of the holidays.',
                          ),
                        ),
                        'attributes' => 
                        array (
                          'padding' => '15px 59px 0px 40px',
                          'align' => 'left',
                          'color' => '#FFFFFFD9',
                          'font-size' => '16px',
                          'line-height' => '1.75',
                          'font-weight' => '400',
                          'font-style' => 'normal',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                      5 => 
                      array (
                        'type' => 'advanced_button',
                        'data' => 
                        array (
                          'value' => 
                          array (
                            'content' => 'Shop Now',
                          ),
                        ),
                        'attributes' => 
                        array (
                          'align' => 'center',
                          'font-family' => 'Arial',
                          'background-color' => '#fff',
                          'color' => '#A62625',
                          'font-weight' => '500',
                          'font-style' => 'normal',
                          'border-radius' => '100px',
                          'padding' => '40px 0px 40px 0px',
                          'inner-padding' => '18px 40px 18px 40px',
                          'font-size' => '18px',
                          'line-height' => '0.83',
                          'target' => '_blank',
                          'vertical-align' => 'middle',
                          'border' => 'none',
                          'text-align' => 'center',
                          'letter-spacing' => 'normal',
                          'href' => '#',
                          'width' => '',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                    ),
                  ),
                  3 => 
                  array (
                    'type' => 'advanced_spacer',
                    'data' => 
                    array (
                      'value' => 
                      array (
                      ),
                    ),
                    'attributes' => 
                    array (
                      'height' => '24px',
                      'padding' => '0px 0px 0px 0px',
                    ),
                    'children' => 
                    array (
                    ),
                  ),
                  4 => 
                  array (
                    'type' => 'advanced_hero',
                    'data' => 
                    array (
                      'value' => 
                      array (
                      ),
                    ),
                    'attributes' => 
                    array (
                      'background-color' => '#ffffff',
                      'background-position' => 'center center',
                      'mode' => 'fluid-height',
                      'padding' => '0px 0px 0px 0px',
                      'vertical-align' => 'top',
                      'background-url' => '',
                    ),
                    'children' => 
                    array (
                      0 => 
                      array (
                        'type' => 'text',
                        'data' => 
                        array (
                          'value' => 
                          array (
                            'content' => '🌟 Our Gift to You:&nbsp;<div>Exclusive Holiday Offer! 🎁</div>',
                          ),
                        ),
                        'attributes' => 
                        array (
                          'padding' => '40px 0px 10px 0px',
                          'align' => 'center',
                          'color' => '#1F1F2D',
                          'font-size' => '26px',
                          'line-height' => '1.30',
                          'letter-spacing' => '1.30',
                          'font-weight' => '800',
                          'font-family' => 'Arial',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                      1 => 
                      array (
                        'type' => 'advanced_image',
                        'data' => 
                        array (
                          'value' => 
                          array (
                          ),
                        ),
                        'attributes' => 
                        array (
                          'align' => 'center',
                          'height' => 'auto',
                          'padding' => '40px 0px 0px 0px',
                          'src' => $image_path . 'christmas-exclusive-offer/discount.png',
                          'width' => '200px',
                          'alt' => 'discount',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                      2 => 
                      array (
                        'type' => 'advanced_button',
                        'data' => 
                        array (
                          'value' => 
                          array (
                            'content' => 'Shop Now',
                          ),
                        ),
                        'attributes' => 
                        array (
                          'align' => 'center',
                          'font-family' => 'Arial',
                          'background-color' => '#A62625',
                          'color' => '#ffffff',
                          'font-weight' => 'normal',
                          'font-style' => 'normal',
                          'border-radius' => '100px',
                          'padding' => '58px 0px 0px 0px',
                          'inner-padding' => '18px 40px 18px 40px',
                          'font-size' => '18px',
                          'line-height' => '0.83',
                          'target' => '_blank',
                          'vertical-align' => 'middle',
                          'border' => 'none',
                          'text-align' => 'center',
                          'letter-spacing' => 'normal',
                          'href' => '#',
                          'width' => '',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                      3 => 
                      array (
                        'type' => 'advanced_text',
                        'data' => 
                        array (
                          'value' => 
                          array (
                            'content' => 'Sale Ends At January 5th, Friday 8 PM',
                          ),
                        ),
                        'attributes' => 
                        array (
                          'padding' => '18px 0px 0px 0px',
                          'align' => 'center',
                          'color' => '#1F1F2D',
                          'font-size' => '16px',
                          'font-family' => 'Arial',
                          'line-height' => '1.62',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                      4 => 
                      array (
                        'type' => 'advanced_image',
                        'data' => 
                        array (
                          'value' => 
                          array (
                          ),
                        ),
                        'attributes' => 
                        array (
                          'align' => 'center',
                          'height' => 'auto',
                          'padding' => '26px 0px 12px 0px',
                          'src' => $image_path . 'christmas-exclusive-offer/gift.png',
                          'width' => 'auto',
                          'alt' => 'crismas-gift',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                    ),
                  ),
                  5 => 
                  array (
                    'type' => 'advanced_social',
                    'data' => 
                    array (
                      'value' => 
                      array (
                        'elements' => 
                        array (
                          0 => 
                          array (
                            'href' => '#',
                            'target' => '_blank',
                            'src' => $image_path . 'christmas-exclusive-offer/pinterest.png',
                            'content' => '',
                          ),
                          1 => 
                          array (
                            'href' => '#',
                            'target' => '_blank',
                            'src' => $image_path . 'christmas-exclusive-offer/facebook.png',
                            'content' => '',
                          ),
                          2 => 
                          array (
                            'href' => '#',
                            'target' => '_blank',
                            'src' => $image_path . 'christmas-exclusive-offer/instagram.png',
                            'content' => '',
                          ),
                          3 => 
                          array (
                            'href' => '#',
                            'target' => '_blank',
                            'src' => $image_path . 'christmas-exclusive-offer/twiter.png',
                            'content' => '',
                          ),
                        ),
                      ),
                    ),
                    'attributes' => 
                    array (
                      'align' => 'center',
                      'color' => '',
                      'mode' => 'horizontal',
                      'font-size' => '',
                      'font-weight' => 'normal',
                      'font-style' => 'normal',
                      'font-family' => 'Arial',
                      'border-radius' => '',
                      'padding' => '30px 0px 0px 0px',
                      'inner-padding' => '0px 0px 0px 20px',
                      'line-height' => '',
                      'text-padding' => '4px 4px 4px 0px',
                      'icon-padding' => '0px',
                      'icon-size' => '40px',
                    ),
                    'children' => 
                    array (
                    ),
                  ),
                  6 => 
                  array (
                    'type' => 'advanced_divider',
                    'data' => 
                    array (
                      'value' => 
                      array (
                      ),
                    ),
                    'attributes' => 
                    array (
                      'align' => 'center',
                      'border-width' => '1px',
                      'border-style' => 'solid',
                      'border-color' => '#D3CFD8',
                      'padding' => '30px 24px 0px 24px',
                    ),
                    'children' => 
                    array (
                    ),
                  ),
                  7 => 
                  array (
                    'type' => 'advanced_text',
                    'data' => 
                    array (
                      'value' => 
                      array (
                        'content' => 'No longer want to be Mail Mint friends?',
                      ),
                    ),
                    'attributes' => 
                    array (
                      'padding' => '30px 0px 0px 0px',
                      'align' => 'center',
                      'color' => '#908A99',
                      'font-size' => '15px',
                      'font-family' => 'Arial',
                      'line-height' => '1',
                      'font-weight' => '400',
                    ),
                    'children' => 
                    array (
                    ),
                  ),
                  8 => 
                  array (
                    'type' => 'advanced_text',
                    'data' => 
                    array (
                      'value' => 
                      array (
                        'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
                      ),
                    ),
                    'attributes' => 
                    array (
                      'padding' => '12px 0px 0px 0px',
                      'align' => 'center',
                      'color' => '#908A99',
                      'line-height' => '1.42',
                      'font-size' => '14px',
                      'font-family' => 'Arial',
                    ),
                    'children' => 
                    array (
                    ),
                  ),
                  9 => 
                  array (
                    'type' => 'advanced_text',
                    'data' => 
                    array (
                      'value' => 
                      array (
                        'content' => '<a href="#" target="_blank" style="color: inherit; text-decoration: underline;">Update Preference&nbsp;</a> .&nbsp;&nbsp;<a href="#" target="_blank" style="color: inherit; text-decoration: underline;">Unsubscribe</a>',
                      ),
                    ),
                    'attributes' => 
                    array (
                      'padding' => '12px 0px 30px 0px',
                      'align' => 'center',
                      'color' => '#0064FF',
                    ),
                    'children' => 
                    array (
                    ),
                  ),
                ),
              ),
            ),
          ),
        );
    }
    if ( !empty( $templates[ 23 ] ) && empty( $templates[ 23 ][ 'json_content' ] ) ){
        $templates[ 23 ]['json_content'] = array (
            'content' => 
            array (
              'type' => 'page',
              'data' => 
              array (
                'value' => 
                array (
                  'breakpoint' => '480px',
                  'headAttributes' => '',
                  'font-size' => '14px',
                  'font-weight' => '400',
                  'line-height' => '1.7',
                  'headStyles' => 
                  array (
                  ),
                  'fonts' => 
                  array (
                  ),
                  'responsive' => true,
                  'font-family' => 'Arial',
                  'text-color' => '#000000',
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#efeeea',
                'width' => '600px',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_image',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'height' => 'auto',
                    'padding' => '24px 0px 30px 0px',
                    'src' => $image_path . 'your-logo.png',
                    'width' => '100%',
                    'container-background-color' => '#6A9C89',
                    'alt' => 'logo',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_wrapper',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#6A9C89',
                    'padding' => '0px 24px 0px 24px',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_hero',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'background-color' => '#C1D8C3',
                        'background-position' => 'center center',
                        'mode' => 'fluid-height',
                        'padding' => '00px 0px 0px 0px',
                        'vertical-align' => 'top',
                        'background-url' => '',
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Shipping Update - <font color="#cd5c08">Order #89023</font>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '40px 56px 0px 40px',
                            'align' => 'center',
                            'color' => '#3D4A45',
                            'font-size' => '30px',
                            'line-height' => '1.33',
                            'font-weight' => '800',
                            'font-style' => 'normal',
                            'font-family' => 'Arial',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Dear John Doe,',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'left',
                            'background-color' => '#414141',
                            'color' => '#3D4A45',
                            'font-weight' => '400',
                            'border-radius' => '3px',
                            'padding' => '24px 0px 0px 40px',
                            'inner-padding' => '10px 25px 10px 25px',
                            'line-height' => '0.88',
                            'target' => '_blank',
                            'vertical-align' => 'middle',
                            'border' => 'none',
                            'text-align' => 'center',
                            'href' => '#',
                            'font-size' => '18px',
                            'letter-spacing' => '',
                            'font-family' => 'Arial',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        2 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Great news! We wanted to let you know that the shipping status for your order #89023 has been updated',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '20px 20px 40px 40px',
                            'align' => 'left',
                            'font-size' => '18px',
                            'line-height' => '1.55',
                            'font-weight' => '400',
                            'color' => '#3D4A45',
                            'font-family' => 'Arial',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_hero',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'background-color' => '#F5E8B7',
                        'background-position' => 'center center',
                        'mode' => 'fluid-height',
                        'padding' => '0px 0px 0px 0px',
                        'vertical-align' => 'top',
                        'background-url' => '',
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'LATEST&nbsp; SHIPPING&nbsp; INFORMATION:',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '40px 0px 0px 40px',
                            'align' => 'left',
                            'color' => '#7A766A',
                            'font-size' => '15px',
                            'line-height' => '1.06',
                            'font-family' => 'Arial',
                            'font-weight' => '600',
                            'font-style' => 'normal',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Tracking Number:<font color="#cd5c08"> <b>0000050981883489517034</b></font>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'left',
                            'background-color' => '#414141',
                            'color' => '#3D4A45',
                            'font-weight' => '400',
                            'border-radius' => '3px',
                            'padding' => '24px 20px 0px 40px',
                            'inner-padding' => '10px 25px 10px 25px',
                            'line-height' => '1',
                            'target' => '_blank',
                            'vertical-align' => 'middle',
                            'border' => 'none',
                            'text-align' => 'center',
                            'href' => '#',
                            'font-size' => '18px',
                            'font-style' => 'normal',
                            'font-family' => 'Arial',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        2 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Estimated Delivery Date: <b>04/20/2023</b>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '16px 20px 0px 40px',
                            'align' => 'left',
                            'font-size' => '18px',
                            'line-height' => '1',
                            'font-weight' => '400',
                            'font-family' => 'Arial',
                            'color' => '#3D4A45',
                            'font-style' => 'normal',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        3 => 
                        array (
                          'type' => 'advanced_button',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Track Package',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'font-family' => 'Arial',
                            'background-color' => '#CD5C08',
                            'color' => '#ffffff',
                            'font-weight' => '600',
                            'font-style' => 'normal',
                            'border-radius' => '0px',
                            'padding' => '40px 0px 00px 0px',
                            'inner-padding' => '25px 37px 25px 38px',
                            'font-size' => '18px',
                            'line-height' => '0.83',
                            'target' => '_blank',
                            'vertical-align' => 'middle',
                            'border' => 'none',
                            'text-align' => 'center',
                            'letter-spacing' => 'normal',
                            'href' => '#',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        4 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Keep an eye on your package\'s journey by clicking the button below',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '16px 50px 40px 50px',
                            'align' => 'left',
                            'color' => '#7A766A',
                            'font-size' => '15px',
                            'line-height' => '1',
                            'font-family' => 'Arial',
                            'font-weight' => '400',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_section',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'noWrap' => false,
                        ),
                      ),
                      'attributes' => 
                      array (
                        'background-color' => '#C1D8C3',
                        'padding' => '24px 24px 0px 24px',
                        'background-repeat' => 'repeat',
                        'background-size' => 'auto',
                        'background-position' => 'top center',
                        'border' => 'none',
                        'direction' => 'ltr',
                        'text-align' => 'center',
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_column',
                          'attributes' => 
                          array (
                            'width' => 
                            array (
                              0 => '25%',
                              1 => '25%',
                              2 => '25%',
                              3 => '25%',
                            ),
                            'padding' => '0px 0px 0px 0px',
                            'background-color' => '#fff',
                          ),
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'children' => 
                          array (
                            0 => 
                            array (
                              'type' => 'advanced_text',
                              'data' => 
                              array (
                                'value' => 
                                array (
                                  'content' => 'Got a question?',
                                ),
                              ),
                              'attributes' => 
                              array (
                                'padding' => '30px 0px 0px 0px',
                                'align' => 'center',
                                'font-size' => '30px',
                                'color' => '#CD5C08',
                                'font-weight' => '800',
                                'line-height' => '1',
                              ),
                              'children' => 
                              array (
                              ),
                            ),
                            1 => 
                            array (
                              'type' => 'advanced_text',
                              'data' => 
                              array (
                                'value' => 
                                array (
                                  'content' => 'We’re here to help you',
                                ),
                              ),
                              'attributes' => 
                              array (
                                'padding' => '16px 0px 00px 0px',
                                'align' => 'center',
                                'font-size' => '30px',
                                'color' => '#3D4A45',
                                'line-height' => '1',
                                'font-family' => 'Arial',
                                'font-weight' => '500',
                              ),
                              'children' => 
                              array (
                              ),
                            ),
                          ),
                        ),
                      ),
                    ),
                    3 => 
                    array (
                      'type' => 'advanced_section',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'noWrap' => false,
                        ),
                      ),
                      'attributes' => 
                      array (
                        'background-color' => '#C1D8C3',
                        'padding' => '0px 24px 24px 24px',
                        'background-repeat' => 'repeat',
                        'background-size' => 'auto',
                        'background-position' => 'top center',
                        'border' => 'none',
                        'direction' => 'ltr',
                        'text-align' => 'center',
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_column',
                          'attributes' => 
                          array (
                            'width' => '50%',
                            'padding' => '0px 0px 0px 0px',
                            'background-color' => '#fff',
                          ),
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'children' => 
                          array (
                            0 => 
                            array (
                              'type' => 'advanced_image',
                              'data' => 
                              array (
                                'value' => 
                                array (
                                ),
                              ),
                              'attributes' => 
                              array (
                                'align' => 'center',
                                'height' => 'auto',
                                'padding' => '53px 0px 0px 0px',
                                'src' => $image_path . 'shipping-update/message.png',
                                'width' => '45px',
                                'alt' => 'message',
                              ),
                              'children' => 
                              array (
                              ),
                            ),
                            1 => 
                            array (
                              'type' => 'advanced_text',
                              'data' => 
                              array (
                                'value' => 
                                array (
                                  'content' => 'support@gmail.com',
                                ),
                              ),
                              'attributes' => 
                              array (
                                'padding' => '21px 0px 42px 0px',
                                'align' => 'center',
                                'font-size' => '18px',
                                'font-family' => 'Arial',
                                'color' => '#3D4A45',
                                'font-weight' => '400',
                                'font-style' => 'normal',
                                'line-height' => '0.88',
                              ),
                              'children' => 
                              array (
                              ),
                            ),
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_column',
                          'attributes' => 
                          array (
                            'width' => '50%',
                            'padding' => '0px 0px 0px 0px',
                            'background-color' => '#fff',
                            'background-url' => '',
                          ),
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'children' => 
                          array (
                            0 => 
                            array (
                              'type' => 'advanced_image',
                              'data' => 
                              array (
                                'value' => 
                                array (
                                ),
                              ),
                              'attributes' => 
                              array (
                                'align' => 'center',
                                'height' => 'auto',
                                'padding' => '53px 0px 0px 0px',
                                'src' => $image_path . 'shipping-update/phone.png',
                                'width' => '40px',
                                'alt' => 'telephone',
                              ),
                              'children' => 
                              array (
                              ),
                            ),
                            1 => 
                            array (
                              'type' => 'advanced_text',
                              'data' => 
                              array (
                                'value' => 
                                array (
                                  'content' => '2.999.000.6743',
                                ),
                              ),
                              'attributes' => 
                              array (
                                'padding' => '22px 0px 45px 0px',
                                'align' => 'center',
                                'font-size' => '18px',
                                'line-height' => '0.88',
                                'color' => '#3D4A45',
                                'font-family' => 'Arial',
                                'font-weight' => '400',
                              ),
                              'children' => 
                              array (
                              ),
                            ),
                          ),
                        ),
                      ),
                    ),
                    4 => 
                    array (
                      'type' => 'advanced_social',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'elements' => 
                          array (
                            0 => 
                            array (
                              'href' => '#',
                              'target' => '_blank',
                              'src' => $image_path . 'shipping-update/pinterest.png',
                              'content' => '',
                            ),
                            1 => 
                            array (
                              'href' => '#',
                              'target' => '_blank',
                              'src' => $image_path . 'shipping-update/facebook.png',
                              'content' => '',
                            ),
                            2 => 
                            array (
                              'href' => '#',
                              'target' => '_blank',
                              'src' => $image_path . 'shipping-update/instagram.png',
                              'content' => '',
                            ),
                            3 => 
                            array (
                              'href' => '#',
                              'target' => '_blank',
                              'src' => $image_path . 'shipping-update/twiter.png',
                              'content' => '',
                            ),
                          ),
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'color' => '#333333',
                        'mode' => 'horizontal',
                        'font-size' => '13px',
                        'font-weight' => 'normal',
                        'font-style' => 'normal',
                        'font-family' => 'Arial',
                        'border-radius' => '3px',
                        'padding' => '30px 0px 0px 0px',
                        'inner-padding' => '0px 0px 0px 20px',
                        'line-height' => '1.6',
                        'text-padding' => '4px 4px 4px 0px',
                        'icon-padding' => '0px',
                        'icon-size' => '40px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    5 => 
                    array (
                      'type' => 'advanced_divider',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'border-width' => '1px',
                        'border-style' => 'solid',
                        'border-color' => '#8EAD91',
                        'padding' => '30px 24px 0px 24px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    6 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'No longer want to be Mail Mint friends?',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '40px 0px 0px 0px',
                        'align' => 'center',
                        'color' => '#D7E2D8',
                        'line-height' => '1.46',
                        'font-size' => '15px',
                        'font-weight' => '400',
                        'font-family' => 'Arial',
                        'font-style' => 'normal',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    7 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<a href="{{link.preference}}" target="_blank" style="color: inherit; text-decoration: underline;">Email Preference&nbsp;</a> .&nbsp;&nbsp;<a href="{{link.unsubscribe}}" target="_blank" style="color: inherit; text-decoration: underline;">Unsubscribe</a>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '8px 0px 0px 0px',
                        'align' => 'center',
                        'color' => '#D7E2D8',
                        'font-size' => '15px',
                        'line-height' => '1.46',
                        'font-weight' => '400',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    8 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '24px 0px 31px 0px',
                        'align' => 'center',
                        'font-size' => '14px',
                        'font-weight' => '400',
                        'line-height' => '1.57',
                        'font-style' => 'normal',
                        'color' => '#D7E2D8',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
              ),
            ),
            'subTitle' => 'Nice to meet you!',
        );
    }
    if ( !empty( $templates[ 24 ] ) && empty( $templates[ 24 ][ 'json_content' ] ) ){
        $templates[ 24 ]['json_content'] = array (
            'subject' => 'Welcome to Mail Mint email marketing and automation',
            'subTitle' => 'Nice to meet you!',
            'content' => 
            array (
              'type' => 'page',
              'data' => 
              array (
                'value' => 
                array (
                  'breakpoint' => '480px',
                  'headAttributes' => '',
                  'font-size' => '14px',
                  'font-weight' => '400',
                  'line-height' => '1.7',
                  'headStyles' => 
                  array (
                  ),
                  'fonts' => 
                  array (
                  ),
                  'responsive' => true,
                  'font-family' => 'Arial',
                  'text-color' => '#000000',
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#efeeea',
                'width' => '600px',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_image',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'height' => 'auto',
                    'padding' => '24px 0px 24px 0px',
                    'src' => $image_path . 'your-logo.png',
                    'width' => '100%',
                    'container-background-color' => '#E7E7E7',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_wrapper',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#E7E7E7',
                    'padding' => '0px 24px 24px 24px',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_hero',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'background-color' => '',
                        'background-position' => 'center center',
                        'mode' => 'fluid-height',
                        'padding' => '80px 0px 0px 0px',
                        'vertical-align' => 'top',
                        'background-url' => $image_path . 'welcome-to-gym/hero-bg.png',
                        'background-height' => '',
                        'background-width' => '',
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'WELCOME TO<div>THE FIT GYM</div><div>FAMILY</div>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '0px 25px 0px 25px',
                            'align' => 'center',
                            'color' => '#FFFFFF',
                            'font-size' => '56px',
                            'line-height' => '1.7',
                            'font-weight' => '800',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'We\'re thrilled to have you join us on your fitness journey. 🏋️‍♂️🌟 At Fit Gym, we\'re passionate about helping you achieve your fitness goals and living a healthier, happier life.&nbsp;<div>Whether you\'re a seasoned fitness enthusiast or just starting out, we\'re here to support you every step of the way.</div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '30px 40px 30px 40px',
                        'align' => 'left',
                        'container-background-color' => '#2F6A87',
                        'color' => '#FFFFFF',
                        'font-size' => '18px',
                        'line-height' => '1.6',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_spacer',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'height' => '24px',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    3 => 
                    array (
                      'type' => 'advanced_hero',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'background-color' => '#9A5131',
                        'background-position' => 'center center',
                        'mode' => 'fluid-height',
                        'padding' => '20px 20px 40px 20px',
                        'vertical-align' => 'top',
                        'background-url' => '',
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => 'auto',
                            'padding' => '0px 0px 0px 0px',
                            'src' => $image_path . 'welcome-to-gym/about-img.png',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'A little about us',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '30px 25px 16px 0px',
                            'align' => 'left',
                            'color' => '#FFFFFF',
                            'font-size' => '30px',
                            'line-height' => '0.8',
                            'font-weight' => '700',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        2 => 
                        array (
                          'type' => 'text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Welcome to Fit Gym—where fitness meets joy! We\'re your go-to for vibrant well-being. 
          Let\'s crush goals, embrace vitality, and make every workout count. Ready for a healthier, happier you? Let\'s do this!',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'left',
                            'background-color' => '#414141',
                            'color' => '#FFFFFF',
                            'font-weight' => 'normal',
                            'border-radius' => '3px',
                            'padding' => '0px 0px 0px 0px',
                            'inner-padding' => '10px 25px 10px 25px',
                            'line-height' => '1.6',
                            'target' => '_blank',
                            'vertical-align' => 'middle',
                            'border' => 'none',
                            'text-align' => 'center',
                            'href' => '#',
                            'font-size' => '18px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    4 => 
                    array (
                      'type' => 'advanced_spacer',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'height' => '24px',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    5 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '👉 Here are some quick links to get you started:',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '22px 35px 22px 35px',
                        'align' => 'center',
                        'font-size' => '20px',
                        'line-height' => '1.8',
                        'font-weight' => '600',
                        'container-background-color' => '#0D2B38',
                        'color' => '#FFFFFF',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    6 => 
                    array (
                      'type' => 'advanced_spacer',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'height' => '24px',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    7 => 
                    array (
                      'type' => 'advanced_section',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'noWrap' => false,
                        ),
                      ),
                      'attributes' => 
                      array (
                        'background-color' => '',
                        'padding' => '20px 0px 50px 0px',
                        'background-repeat' => 'repeat',
                        'background-size' => 'auto',
                        'background-position' => 'top center',
                        'border' => 'none',
                        'direction' => 'ltr',
                        'text-align' => 'center',
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_column',
                          'attributes' => 
                          array (
                            'width' => '40%',
                            'padding' => '0px 0px 0px 0px',
                          ),
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'children' => 
                          array (
                            0 => 
                            array (
                              'type' => 'advanced_image',
                              'data' => 
                              array (
                                'value' => 
                                array (
                                ),
                              ),
                              'attributes' => 
                              array (
                                'align' => 'center',
                                'height' => 'auto',
                                'padding' => '0px 0px 0px 0px',
                                'src' => $image_path . 'welcome-to-gym/overview-1.png',
                              ),
                              'children' => 
                              array (
                              ),
                            ),
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_column',
                          'attributes' => 
                          array (
                            'width' => '60%',
                            'padding' => '0px 0px 0px 0px',
                          ),
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'children' => 
                          array (
                            0 => 
                            array (
                              'type' => 'advanced_text',
                              'data' => 
                              array (
                                'value' => 
                                array (
                                  'content' => 'Today\'s Top Stories: Handpicked Just for You',
                                ),
                              ),
                              'attributes' => 
                              array (
                                'padding' => '30px 0px 0px 25px',
                                'align' => 'left',
                                'font-size' => '18px',
                                'line-height' => '1.4',
                                'font-weight' => '700',
                                'color' => '#0D2B38',
                              ),
                              'children' => 
                              array (
                              ),
                            ),
                            1 => 
                            array (
                              'type' => 'advanced_text',
                              'data' => 
                              array (
                                'value' => 
                                array (
                                  'content' => 'Fueling Your Wellness Journey: Running, Yoga, and the Path to Weight Loss',
                                ),
                              ),
                              'attributes' => 
                              array (
                                'padding' => '16px 0px 20px 25px',
                                'align' => 'left',
                                'font-size' => '16px',
                                'line-height' => '1.5',
                                'font-weight' => 'normal',
                                'color' => '#60696D',
                                'container-background-color' => '',
                              ),
                              'children' => 
                              array (
                              ),
                            ),
                            2 => 
                            array (
                              'type' => 'advanced_text',
                              'data' => 
                              array (
                                'value' => 
                                array (
                                  'content' => '<a href="#" target="_blank" style="color: inherit; text-decoration: underline;">Work Out Now</a>',
                                ),
                              ),
                              'attributes' => 
                              array (
                                'padding' => '0px 0px 20px 25px',
                                'align' => 'left',
                                'font-size' => '16px',
                                'line-height' => '1',
                                'font-weight' => '700',
                                'color' => '#EA6C36',
                                'container-background-color' => '',
                              ),
                              'children' => 
                              array (
                              ),
                            ),
                          ),
                        ),
                      ),
                    ),
                    8 => 
                    array (
                      'type' => 'advanced_section',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'noWrap' => false,
                        ),
                      ),
                      'attributes' => 
                      array (
                        'background-color' => '',
                        'padding' => '0px 0px 50px 0px',
                        'background-repeat' => 'repeat',
                        'background-size' => 'auto',
                        'background-position' => 'top center',
                        'border' => 'none',
                        'direction' => 'ltr',
                        'text-align' => 'center',
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_column',
                          'attributes' => 
                          array (
                            'width' => '60%',
                            'padding' => '0px 0px 0px 0px',
                          ),
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'children' => 
                          array (
                            0 => 
                            array (
                              'type' => 'advanced_text',
                              'data' => 
                              array (
                                'value' => 
                                array (
                                  'content' => 'Unlock Your Special Offers Now!',
                                ),
                              ),
                              'attributes' => 
                              array (
                                'padding' => '30px 0px 0px 0px',
                                'align' => 'left',
                                'font-size' => '18px',
                                'line-height' => '1.4',
                                'font-weight' => '700',
                                'color' => '#0D2B38',
                              ),
                              'children' => 
                              array (
                              ),
                            ),
                            1 => 
                            array (
                              'type' => 'advanced_text',
                              'data' => 
                              array (
                                'value' => 
                                array (
                                  'content' => 'Discover Sales, Giveaways &amp; More – Exclusively for You! Get $5 Off a One-<div>Month Fit Gym Subscription with&nbsp;<div>Code: FITNOW.</div></div>',
                                ),
                              ),
                              'attributes' => 
                              array (
                                'padding' => '16px 0px 20px 0px',
                                'align' => 'left',
                                'font-size' => '16px',
                                'line-height' => '1.5',
                                'font-weight' => 'normal',
                                'color' => '#60696D',
                                'container-background-color' => '',
                              ),
                              'children' => 
                              array (
                              ),
                            ),
                            2 => 
                            array (
                              'type' => 'advanced_text',
                              'data' => 
                              array (
                                'value' => 
                                array (
                                  'content' => '<a href="#" target="_blank" style="color: inherit; text-decoration: underline;">Learn More</a><br>',
                                ),
                              ),
                              'attributes' => 
                              array (
                                'padding' => '0px 0px 20px 0px',
                                'align' => 'left',
                                'font-size' => '16px',
                                'line-height' => '1',
                                'font-weight' => '700',
                                'color' => '#EA6C36',
                                'container-background-color' => '',
                              ),
                              'children' => 
                              array (
                              ),
                            ),
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_column',
                          'attributes' => 
                          array (
                            'width' => '40%',
                            'padding' => '0px 0px 0px 0px',
                          ),
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'children' => 
                          array (
                            0 => 
                            array (
                              'type' => 'advanced_image',
                              'data' => 
                              array (
                                'value' => 
                                array (
                                ),
                              ),
                              'attributes' => 
                              array (
                                'align' => 'center',
                                'height' => 'auto',
                                'padding' => '0px 0px 0px 0px',
                                'src' => $image_path . 'welcome-to-gym/overview-2.png',
                              ),
                              'children' => 
                              array (
                              ),
                            ),
                          ),
                        ),
                      ),
                    ),
                    9 => 
                    array (
                      'type' => 'advanced_section',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'noWrap' => false,
                        ),
                      ),
                      'attributes' => 
                      array (
                        'background-color' => '',
                        'padding' => '0px 0px 40px 0px',
                        'background-repeat' => 'repeat',
                        'background-size' => 'auto',
                        'background-position' => 'top center',
                        'border' => 'none',
                        'direction' => 'ltr',
                        'text-align' => 'center',
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_column',
                          'attributes' => 
                          array (
                            'width' => '40%',
                            'padding' => '0px 0px 0px 0px',
                          ),
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'children' => 
                          array (
                            0 => 
                            array (
                              'type' => 'advanced_image',
                              'data' => 
                              array (
                                'value' => 
                                array (
                                ),
                              ),
                              'attributes' => 
                              array (
                                'align' => 'center',
                                'height' => 'auto',
                                'padding' => '0px 0px 0px 0px',
                                'src' => $image_path . 'welcome-to-gym/overview-3.png',
                              ),
                              'children' => 
                              array (
                              ),
                            ),
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_column',
                          'attributes' => 
                          array (
                            'width' => '60%',
                            'padding' => '0px 0px 0px 0px',
                          ),
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'children' => 
                          array (
                            0 => 
                            array (
                              'type' => 'advanced_text',
                              'data' => 
                              array (
                                'value' => 
                                array (
                                  'content' => 'Free Fit Gym Events: Your VIP Invite!',
                                ),
                              ),
                              'attributes' => 
                              array (
                                'padding' => '30px 0px 0px 25px',
                                'align' => 'left',
                                'font-size' => '18px',
                                'line-height' => '1.4',
                                'font-weight' => '700',
                                'color' => '#0D2B38',
                              ),
                              'children' => 
                              array (
                              ),
                            ),
                            1 => 
                            array (
                              'type' => 'advanced_text',
                              'data' => 
                              array (
                                'value' => 
                                array (
                                  'content' => 'Unlock Exclusive Access to Fitness Excitement – Your Complimentary Invitation Awaits!',
                                ),
                              ),
                              'attributes' => 
                              array (
                                'padding' => '16px 0px 20px 25px',
                                'align' => 'left',
                                'font-size' => '16px',
                                'line-height' => '1.5',
                                'font-weight' => 'normal',
                                'color' => '#60696D',
                                'container-background-color' => '',
                              ),
                              'children' => 
                              array (
                              ),
                            ),
                            2 => 
                            array (
                              'type' => 'advanced_text',
                              'data' => 
                              array (
                                'value' => 
                                array (
                                  'content' => '<a href="#" target="_blank" style="color: inherit; text-decoration: underline;">Learn More</a><br>',
                                ),
                              ),
                              'attributes' => 
                              array (
                                'padding' => '0px 0px 20px 25px',
                                'align' => 'left',
                                'font-size' => '16px',
                                'line-height' => '1',
                                'font-weight' => '700',
                                'color' => '#EA6C36',
                                'container-background-color' => '',
                              ),
                              'children' => 
                              array (
                              ),
                            ),
                          ),
                        ),
                      ),
                    ),
                    10 => 
                    array (
                      'type' => 'advanced_hero',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'background-color' => '#ffffff',
                        'background-position' => 'center center',
                        'mode' => 'fluid-height',
                        'padding' => '40px 0px 40px 0px',
                        'vertical-align' => 'top',
                        'background-url' => $image_path . 'welcome-to-gym/qa-bg.png',
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => '30px',
                            'padding' => '0px 0px 0px 0px',
                            'src' => $image_path . 'welcome-to-gym/conversation.png',
                            'width' => '30px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Any Questions',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '20px 25px 8px 25px',
                            'align' => 'center',
                            'color' => '#FFFFFF',
                            'font-size' => '24px',
                            'line-height' => '0.9',
                            'font-weight' => '700',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        2 => 
                        array (
                          'type' => 'text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'We’re here for you. Contact Number - (780) 349 - 1599',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'background-color' => '#414141',
                            'color' => '#FFFFFF',
                            'font-weight' => 'normal',
                            'border-radius' => '3px',
                            'padding' => '0px 25px 30px 25px',
                            'inner-padding' => '10px 25px 10px 25px',
                            'line-height' => '1.7',
                            'target' => '_blank',
                            'vertical-align' => 'middle',
                            'border' => 'none',
                            'text-align' => 'center',
                            'href' => '#',
                            'font-size' => '16px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        3 => 
                        array (
                          'type' => 'button',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Contact Us',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'background-color' => 'none',
                            'color' => '#EA6C36',
                            'font-size' => '13px',
                            'font-weight' => 'normal',
                            'border-radius' => '100px',
                            'padding' => '0px 25px 10px 25px',
                            'inner-padding' => '16px 32px 16px 32px',
                            'line-height' => '120%',
                            'target' => '_blank',
                            'vertical-align' => 'middle',
                            'border' => '1px solid #EA6C36',
                            'text-align' => 'center',
                            'href' => '#',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    11 => 
                    array (
                      'type' => 'advanced_spacer',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'height' => '30px',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    12 => 
                    array (
                      'type' => 'advanced_social',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'elements' => 
                          array (
                            0 => 
                            array (
                              'href' => '#',
                              'target' => '_blank',
                              'src' => $image_path . 'welcome-to-gym/pinterest.png',
                              'content' => '',
                            ),
                            1 => 
                            array (
                              'href' => '#',
                              'target' => '_blank',
                              'src' => $image_path . 'welcome-to-gym/facebook.png',
                              'content' => '',
                            ),
                            2 => 
                            array (
                              'href' => '#',
                              'target' => '_blank',
                              'src' => $image_path . 'welcome-to-gym/instagram.png',
                              'content' => '',
                            ),
                            3 => 
                            array (
                              'href' => '#',
                              'target' => '_blank',
                              'src' => $image_path . 'welcome-to-gym/twiter.png',
                              'content' => '',
                            ),
                          ),
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'color' => '#333333',
                        'mode' => 'horizontal',
                        'font-size' => '13px',
                        'font-weight' => 'normal',
                        'font-style' => 'normal',
                        'font-family' => 'Arial',
                        'border-radius' => '3px',
                        'padding' => '0px 0px 0px 0px',
                        'inner-padding' => '4px 20px 4px 0px',
                        'line-height' => '1.6',
                        'text-padding' => '4px 4px 4px 0px',
                        'icon-padding' => '0px',
                        'icon-size' => '40px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    13 => 
                    array (
                      'type' => 'advanced_divider',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'border-width' => '1px',
                        'border-style' => 'solid',
                        'border-color' => '#D0D0D0',
                        'padding' => '30px 0px 0px 0px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    14 => 
                    array (
                      'type' => 'advanced_spacer',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'height' => '30px',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    15 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'No longer want to be Mail Mint friends?',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 25px 8px 25px',
                        'align' => 'center',
                        'font-size' => '15px',
                        'line-height' => '1.4',
                        'color' => '#737C80',
                        'font-weight' => '500',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    16 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<a href="{{link.preference}}" target="_blank" style="color: inherit; text-decoration: underline;">Email Preference</a>&nbsp;.&nbsp;<a href="{{link.unsubscribe}}" target="_blank" style="color: inherit; text-decoration: underline;">Unsubscribe</a>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 25px 8px 25px',
                        'align' => 'center',
                        'font-size' => '15px',
                        'line-height' => '1.4',
                        'color' => '#737C80',
                        'font-weight' => '500',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    17 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '24px 0px 8px 0px',
                        'align' => 'center',
                        'font-size' => '14px',
                        'line-height' => '1.5',
                        'color' => '#737C80',
                        'font-weight' => '400',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                2 => 
                array (
                  'attributes' => 
                  array (
                    'padding' => '0px 0px 0px 0px',
                  ),
                ),
              ),
            ),
        );
    }
    if ( !empty( $templates[ 25 ] ) && empty( $templates[ 25 ][ 'json_content' ] ) ){
        $templates[ 25 ]['json_content'] = array (
            'subject' => 'Welcome to Mail Mint email marketing and automation',
            'subTitle' => 'Nice to meet you!',
            'content' => 
            array (
              'type' => 'page',
              'data' => 
              array (
                'value' => 
                array (
                  'breakpoint' => '480px',
                  'headAttributes' => '',
                  'font-size' => '14px',
                  'font-weight' => '400',
                  'line-height' => '1.7',
                  'headStyles' => 
                  array (
                  ),
                  'fonts' => 
                  array (
                  ),
                  'responsive' => true,
                  'font-family' => 'Arial',
                  'text-color' => '#000000',
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#efeeea',
                'width' => '600px',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_image',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'height' => 'auto',
                    'padding' => '0px 0px 24px 0px',
                    'src' => $image_path . 'your-logo.png',
                    'width' => '100%',
                    'container-background-color' => '#F3F3F3',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_hero',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '',
                    'background-position' => 'center center',
                    'mode' => 'fluid-height',
                    'padding' => '90px 0px 90px 0px',
                    'vertical-align' => 'top',
                    'background-url' => $image_path . 'extend-sale/hero-bg.png',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Cyber Monday',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 10px 0px 0px',
                        'align' => 'center',
                        'color' => '#D297C7',
                        'font-size' => '60px',
                        'line-height' => '1.6',
                        'container-background-color' => '',
                        'font-weight' => '900',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Extended Sale
          ',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 10px 0px 0px',
                        'align' => 'center',
                        'color' => '#7EFCDA',
                        'font-size' => '60px',
                        'line-height' => '1.6',
                        'container-background-color' => '',
                        'font-weight' => '900',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_wrapper',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#000000',
                    'padding' => '0px 24px 24px 24px',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_hero',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'background-color' => '',
                        'background-position' => 'center center',
                        'mode' => 'fluid-height',
                        'padding' => '52px 10px 56px 10px',
                        'vertical-align' => 'top',
                        'background-url' => $image_path . 'extend-sale/sale-bg.png',
                        'border-radius' => '0',
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_button',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => '48 hours only',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'font-family' => 'Arial',
                            'background-color' => '#7EFCDA',
                            'color' => '#000000',
                            'font-weight' => '800',
                            'font-style' => 'normal',
                            'border-radius' => '0px',
                            'padding' => '00px 25px 0px 25px',
                            'inner-padding' => '9px 16px 9px 16px',
                            'font-size' => '20px',
                            'line-height' => '0.9',
                            'target' => '_blank',
                            'vertical-align' => 'middle',
                            'border' => 'none',
                            'text-align' => 'center',
                            'letter-spacing' => 'normal',
                            'href' => '#',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Our Biggest Sales Of The Year!',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '20px 25px 0px 25px',
                            'align' => 'center',
                            'color' => '#000000',
                            'font-size' => '30px',
                            'line-height' => '1',
                            'font-weight' => '900',
                            'inner-padding' => '0px 0px 0px 0px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        2 => 
                        array (
                          'type' => 'text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Save',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '38px 25px 8px 25px',
                            'align' => 'center',
                            'color' => '#000000',
                            'font-size' => '26px',
                            'line-height' => '0.9',
                            'font-weight' => '800',
                            'inner-padding' => '0px 0px 0px 0px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        3 => 
                        array (
                          'type' => 'text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => '50% Off',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '0px 0px 0px 0px',
                            'align' => 'center',
                            'color' => '#FFFFFF',
                            'font-size' => '100px',
                            'line-height' => '1',
                            'font-weight' => '900',
                            'inner-padding' => '0px 0px 0px 0px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_spacer',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'height' => '24px',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_hero',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'background-color' => '#181818',
                        'background-position' => 'center center',
                        'mode' => 'fluid-height',
                        'padding' => '40px 10px 30px 10px',
                        'vertical-align' => 'top',
                        'background-url' => '',
                        'border-radius' => '0',
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Hey there,',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '0px 25px 20px 25px',
                            'align' => 'center',
                            'color' => '#FFFFFF',
                            'font-size' => '26px',
                            'line-height' => '0.9',
                            'font-weight' => '700',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'If you missed out on our Black Friday sale, you’ve got
          a few more hour today to get 50% off all plugins',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '0px 35px 40px 35px',
                            'align' => 'center',
                            'font-size' => '16px',
                            'line-height' => '1.6',
                            'font-weight' => '400',
                            'color' => '#C7C7C7',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        2 => 
                        array (
                          'type' => 'text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Use code: cyber2023',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'background-color' => '#414141',
                            'color' => '#D297C7',
                            'font-weight' => '700',
                            'border-radius' => '3px',
                            'padding' => '0px 25px 40px 25px',
                            'inner-padding' => '10px 25px 10px 25px',
                            'line-height' => '1',
                            'target' => '_blank',
                            'vertical-align' => 'middle',
                            'border' => 'none',
                            'text-align' => 'center',
                            'href' => '#',
                            'font-size' => '20px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        3 => 
                        array (
                          'type' => 'button',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Claim your discount',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'background-color' => '#7EFCDA',
                            'color' => '#161616',
                            'font-size' => '15px',
                            'font-weight' => '600',
                            'border-radius' => '30px',
                            'padding' => '0px 25px 0px 25px',
                            'inner-padding' => '17px 40px 17px 40px',
                            'line-height' => '1',
                            'target' => '_blank',
                            'vertical-align' => 'middle',
                            'border' => 'none',
                            'text-align' => 'center',
                            'href' => '#',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        4 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Hurry! this offer ends&nbsp;<div>Friday, December 10th, 2024 - 9:30 PM. PST</div>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '40px 35px 0px 35px',
                            'align' => 'center',
                            'font-size' => '16px',
                            'line-height' => '1.6',
                            'font-weight' => '400',
                            'color' => '#C7C7C7',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    3 => 
                    array (
                      'type' => 'advanced_spacer',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'height' => '30px',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    4 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Need Help? Ask at&nbsp;<font color="#7efcda"><a href="#" target="_blank" style="color: inherit; text-decoration: underline;">Customer Support</a></font>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 25px 10px 25px',
                        'align' => 'center',
                        'font-size' => '16px',
                        'line-height' => '1',
                        'font-weight' => '700',
                        'color' => '#D2D2D2',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    5 => 
                    array (
                      'type' => 'advanced_divider',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'border-width' => '1px',
                        'border-style' => 'solid',
                        'border-color' => '#E4E4E4',
                        'padding' => '10px 0px 10px 0px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    6 => 
                    array (
                      'type' => 'advanced_social',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'elements' => 
                          array (
                            0 => 
                            array (
                              'href' => '#',
                              'target' => '_blank',
                              'src' => $image_path . 'extend-sale/pinterest.png',
                              'content' => '',
                            ),
                            1 => 
                            array (
                              'href' => '#',
                              'target' => '_blank',
                              'src' => $image_path . 'extend-sale/facebook.png',
                              'content' => '',
                            ),
                            2 => 
                            array (
                              'href' => '#',
                              'target' => '_blank',
                              'src' => $image_path . 'extend-sale/instagram.png',
                              'content' => '',
                            ),
                            3 => 
                            array (
                              'href' => '#',
                              'target' => '_blank',
                              'src' => $image_path . 'extend-sale/twiter.png',
                              'content' => '',
                            ),
                          ),
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'color' => '#333333',
                        'mode' => 'horizontal',
                        'font-size' => '13px',
                        'font-weight' => 'normal',
                        'font-style' => 'normal',
                        'font-family' => 'Arial',
                        'border-radius' => '3px',
                        'padding' => '10px 0px 10px 0px',
                        'inner-padding' => '4px 20px 4px 0px',
                        'line-height' => '1.6',
                        'text-padding' => '4px 4px 4px 0px',
                        'icon-padding' => '0px',
                        'icon-size' => '40px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    7 => 
                    array (
                      'type' => 'advanced_divider',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'border-width' => '1px',
                        'border-style' => 'solid',
                        'border-color' => '#E4E4E4',
                        'padding' => '10px 0px 10px 0px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    8 => 
                    array (
                      'type' => 'advanced_spacer',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'height' => '40px',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    9 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'No longer want to be Mail Mint friends?',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 25px 8px 25px',
                        'align' => 'center',
                        'font-size' => '15px',
                        'line-height' => '1.4',
                        'color' => '#A4A4A4',
                        'font-weight' => '500',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    10 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<a href="{{link.preference}}" target="_blank" style="color: inherit; text-decoration: underline;">Email Preference</a>&nbsp;.&nbsp;<a href="{{link.unsubscribe}}" target="_blank" style="color: inherit; text-decoration: underline;">Unsubscribe</a>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 25px 8px 25px',
                        'align' => 'center',
                        'font-size' => '15px',
                        'line-height' => '1.4',
                        'color' => '#A4A4A4',
                        'font-weight' => '500',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    11 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '24px 0px 8px 0px',
                        'align' => 'center',
                        'font-size' => '14px',
                        'line-height' => '1.5',
                        'color' => '#A4A4A4',
                        'font-weight' => '400',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
              ),
            ),
        );
    }
    if ( !empty( $templates[ 26 ] ) && empty( $templates[ 26 ][ 'json_content' ] ) ){
        $templates[ 26 ]['json_content'] = array (
          'subTitle' => 'Nice to meet you!',
          'content' => 
          array (
            'type' => 'page',
            'data' => 
            array (
              'value' => 
              array (
                'breakpoint' => '480px',
                'headAttributes' => '',
                'font-size' => '14px',
                'font-weight' => '400',
                'line-height' => '1.7',
                'headStyles' => 
                array (
                ),
                'fonts' => 
                array (
                ),
                'responsive' => true,
                'font-family' => 'Arial',
                'text-color' => '#000000',
              ),
            ),
            'attributes' => 
            array (
              'background-color' => '#efeeea',
              'width' => '600px',
            ),
            'children' => 
            array (
              0 => 
              array (
                'type' => 'advanced_image',
                'data' => 
                array (
                  'value' => 
                  array (
                  ),
                ),
                'attributes' => 
                array (
                  'align' => 'center',
                  'height' => 'auto',
                  'padding' => '16px 0px 16px 0px',
                  'src' => $image_path . 'your-logo.png',
                  'width' => '100%',
                  'container-background-color' => '#fff',
                ),
                'children' => 
                array (
                ),
              ),
              1 => 
              array (
                'type' => 'advanced_wrapper',
                'data' => 
                array (
                  'value' => 
                  array (
                  ),
                ),
                'attributes' => 
                array (
                  'background-color' => '#DEECF1',
                  'padding' => '24px 24px 0px 24px',
                  'border' => 'none',
                  'direction' => 'ltr',
                  'text-align' => 'center',
                ),
                'children' => 
                array (
                  0 => 
                  array (
                    'type' => 'advanced_hero',
                    'data' => 
                    array (
                      'value' => 
                      array (
                      ),
                    ),
                    'attributes' => 
                    array (
                      'background-color' => '#ffffff',
                      'background-position' => 'center center',
                      'mode' => 'fluid-height',
                      'padding' => '0px 0px 40px 0px',
                      'vertical-align' => 'top',
                      'background-url' => '',
                    ),
                    'children' => 
                    array (
                      0 => 
                      array (
                        'type' => 'advanced_image',
                        'data' => 
                        array (
                          'value' => 
                          array (
                          ),
                        ),
                        'attributes' => 
                        array (
                          'align' => 'center',
                          'height' => 'auto',
                          'padding' => '0px 0px 0px 0px',
                          'src' => $image_path . 'anniversary-greetings/hero-image.png',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                      1 => 
                      array (
                        'type' => 'text',
                        'data' => 
                        array (
                          'value' => 
                          array (
                            'content' => 'Celebrating 10 Years of Success!',
                          ),
                        ),
                        'attributes' => 
                        array (
                          'padding' => '10px 5px 10px 5px',
                          'align' => 'center',
                          'color' => '#1F1F2D',
                          'font-size' => '36px',
                          'line-height' => '1.2',
                          'font-weight' => '800',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                      2 => 
                      array (
                        'type' => 'text',
                        'data' => 
                        array (
                          'value' => 
                          array (
                            'content' => 'Today marks a special day in the history of&nbsp;<div>Mail Mint – our 10th anniversary! 🎉</div>',
                          ),
                        ),
                        'attributes' => 
                        array (
                          'align' => 'center',
                          'background-color' => '#414141',
                          'color' => '#737373',
                          'font-weight' => 'normal',
                          'border-radius' => '3px',
                          'padding' => '10px 5px 10px 5px',
                          'inner-padding' => '10px 25px 10px 25px',
                          'line-height' => '1.5',
                          'target' => '_blank',
                          'vertical-align' => 'middle',
                          'border' => 'none',
                          'text-align' => 'center',
                          'href' => '#',
                          'font-size' => '18px',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                    ),
                  ),
                  1 => 
                  array (
                    'type' => 'advanced_spacer',
                    'data' => 
                    array (
                      'value' => 
                      array (
                      ),
                    ),
                    'attributes' => 
                    array (
                      'height' => '24px',
                      'padding' => '0px 0px 0px 0px',
                    ),
                    'children' => 
                    array (
                    ),
                  ),
                  2 => 
                  array (
                    'type' => 'advanced_hero',
                    'data' => 
                    array (
                      'value' => 
                      array (
                      ),
                    ),
                    'attributes' => 
                    array (
                      'background-color' => '#27AAE2',
                      'background-position' => 'center center',
                      'mode' => 'fluid-height',
                      'padding' => '20px 20px 20px 20px',
                      'vertical-align' => 'top',
                      'background-url' => '',
                    ),
                    'children' => 
                    array (
                      0 => 
                      array (
                        'type' => 'advanced_image',
                        'data' => 
                        array (
                          'value' => 
                          array (
                          ),
                        ),
                        'attributes' => 
                        array (
                          'align' => 'center',
                          'height' => 'auto',
                          'padding' => '0px 0px 0px 0px',
                          'src' => $image_path . 'anniversary-greetings/milestone.png',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                      1 => 
                      array (
                        'type' => 'text',
                        'data' => 
                        array (
                          'value' => 
                          array (
                            'content' => 'Milestone Details',
                          ),
                        ),
                        'attributes' => 
                        array (
                          'padding' => '20px 0px 10px 0px',
                          'align' => 'left',
                          'color' => '#FFFFFF',
                          'font-size' => '26px',
                          'line-height' => '0.9',
                          'font-weight' => '700',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                      2 => 
                      array (
                        'type' => 'text',
                        'data' => 
                        array (
                          'value' => 
                          array (
                            'content' => '10 years ago, we began this incredible journey, and today, we celebrate the collective achievements that define us.',
                          ),
                        ),
                        'attributes' => 
                        array (
                          'align' => 'left',
                          'background-color' => '#414141',
                          'color' => 'rgba(255, 255, 255, 0.80)',
                          'font-weight' => 'normal',
                          'border-radius' => '3px',
                          'padding' => '10px 5px 10px 0px',
                          'inner-padding' => '10px 25px 10px 25px',
                          'line-height' => '1.6',
                          'target' => '_blank',
                          'vertical-align' => 'middle',
                          'border' => 'none',
                          'text-align' => 'center',
                          'href' => '#',
                          'font-size' => '18px',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                      3 => 
                      array (
                        'type' => 'advanced_divider',
                        'data' => 
                        array (
                          'value' => 
                          array (
                          ),
                        ),
                        'attributes' => 
                        array (
                          'align' => 'center',
                          'border-width' => '1px',
                          'border-style' => 'solid',
                          'border-color' => '#4FBAE7',
                          'padding' => '20px 0px 10px 0px',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                      4 => 
                      array (
                        'type' => 'advanced_text',
                        'data' => 
                        array (
                          'value' => 
                          array (
                            'content' => 'Journey Highlights',
                          ),
                        ),
                        'attributes' => 
                        array (
                          'padding' => '10px 5px 10px 0px',
                          'align' => 'left',
                          'font-size' => '26px',
                          'line-height' => '0.9',
                          'font-weight' => '700',
                          'color' => '#FFFFFF',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                      5 => 
                      array (
                        'type' => 'advanced_text',
                        'data' => 
                        array (
                          'value' => 
                          array (
                            'content' => '10 years ago, we began this incredible journey, and today, we celebrate the collective achievements that define us.',
                          ),
                        ),
                        'attributes' => 
                        array (
                          'padding' => '10px 5px 10px 0px',
                          'align' => 'left',
                          'font-size' => '18px',
                          'line-height' => '1.6',
                          'font-weight' => '400',
                          'color' => 'rgba(255, 255, 255, 0.80)',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                      6 => 
                      array (
                        'type' => 'advanced_text',
                        'data' => 
                        array (
                          'value' => 
                          array (
                            'content' => '<ul><li>Product Launches</li><li>Customer Acquisition and Retention<br></li><li>Financial Growth<br></li><li>Innovative Features or Updates<br></li><li>Employee Growth and Satisfaction<br></li></ul>',
                          ),
                        ),
                        'attributes' => 
                        array (
                          'padding' => '0px 5px 0px 0px',
                          'align' => 'left',
                          'font-size' => '18px',
                          'line-height' => '2',
                          'color' => '#FFFFFF',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                    ),
                  ),
                  3 => 
                  array (
                    'type' => 'advanced_spacer',
                    'data' => 
                    array (
                      'value' => 
                      array (
                      ),
                    ),
                    'attributes' => 
                    array (
                      'height' => '24px',
                      'padding' => '0px 0px 0px 0px',
                    ),
                    'children' => 
                    array (
                    ),
                  ),
                  4 => 
                  array (
                    'type' => 'advanced_hero',
                    'data' => 
                    array (
                      'value' => 
                      array (
                      ),
                    ),
                    'attributes' => 
                    array (
                      'background-color' => '#6557F5',
                      'background-position' => 'center center',
                      'mode' => 'fluid-height',
                      'padding' => '40px 24px 40px 24px',
                      'vertical-align' => 'top',
                      'background-url' => '',
                    ),
                    'children' => 
                    array (
                      0 => 
                      array (
                        'type' => 'advanced_text',
                        'data' => 
                        array (
                          'value' => 
                          array (
                            'content' => 'Its a big week for us',
                          ),
                        ),
                        'attributes' => 
                        array (
                          'padding' => '10px 25px 10px 25px',
                          'align' => 'center',
                          'font-size' => '15px',
                          'line-height' => '1.2',
                          'color' => '#FFFFFF',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                      1 => 
                      array (
                        'type' => 'text',
                        'data' => 
                        array (
                          'value' => 
                          array (
                            'content' => 'Special Discount',
                          ),
                        ),
                        'attributes' => 
                        array (
                          'padding' => '0px 25px 10px 25px',
                          'align' => 'center',
                          'color' => '#FFFFFF',
                          'font-size' => '24px',
                          'line-height' => '0.9',
                          'font-weight' => '700',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                      2 => 
                      array (
                        'type' => 'button',
                        'data' => 
                        array (
                          'value' => 
                          array (
                            'content' => '50% Off',
                          ),
                        ),
                        'attributes' => 
                        array (
                          'align' => 'center',
                          'background-color' => '#FFFFFF',
                          'color' => '#6557F5',
                          'font-size' => '20px',
                          'font-weight' => '800',
                          'border-radius' => '6px',
                          'padding' => '20px 0px 0px 0px',
                          'inner-padding' => '7px 20px 7px 20px',
                          'line-height' => '1',
                          'target' => '_blank',
                          'vertical-align' => 'middle',
                          'border' => 'none',
                          'text-align' => 'center',
                          'href' => '#',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                      3 => 
                      array (
                        'type' => 'advanced_image',
                        'data' => 
                        array (
                          'value' => 
                          array (
                          ),
                        ),
                        'attributes' => 
                        array (
                          'align' => 'center',
                          'height' => 'auto',
                          'padding' => '0px 0px 0px 0px',
                          'src' => $image_path . 'anniversary-greetings/discount.png',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                      4 => 
                      array (
                        'type' => 'advanced_button',
                        'data' => 
                        array (
                          'value' => 
                          array (
                            'content' => 'Get Started Now',
                          ),
                        ),
                        'attributes' => 
                        array (
                          'align' => 'center',
                          'font-family' => 'Arial',
                          'background-color' => '#FFFFFF',
                          'color' => '#6557F5',
                          'font-weight' => '800',
                          'font-style' => 'normal',
                          'border-radius' => '100px',
                          'padding' => '10px 0px 10px 0px',
                          'inner-padding' => '17px 31px 17px 31px',
                          'font-size' => '18px',
                          'line-height' => '0.8',
                          'target' => '_blank',
                          'vertical-align' => 'middle',
                          'border' => 'none',
                          'text-align' => 'center',
                          'letter-spacing' => 'normal',
                          'href' => '#',
                        ),
                        'children' => 
                        array (
                        ),
                      ),
                    ),
                  ),
                  5 => 
                  array (
                    'type' => 'advanced_social',
                    'data' => 
                    array (
                      'value' => 
                      array (
                        'elements' => 
                        array (
                          0 => 
                          array (
                            'href' => '#',
                            'target' => '_blank',
                            'src' => $image_path . 'anniversary-greetings/pinterest.png',
                            'content' => '',
                          ),
                          1 => 
                          array (
                            'href' => '#',
                            'target' => '_blank',
                            'src' => $image_path . 'anniversary-greetings/facebook.png',
                            'content' => '',
                          ),
                          2 => 
                          array (
                            'href' => '#',
                            'target' => '_blank',
                            'src' => $image_path . 'anniversary-greetings/instagram.png',
                            'content' => '',
                          ),
                          3 => 
                          array (
                            'href' => '#',
                            'target' => '_blank',
                            'src' => $image_path . 'anniversary-greetings/twiter.png',
                            'content' => '',
                          ),
                        ),
                      ),
                    ),
                    'attributes' => 
                    array (
                      'align' => 'center',
                      'color' => '#333333',
                      'mode' => 'horizontal',
                      'font-size' => '13px',
                      'font-weight' => 'normal',
                      'font-style' => 'normal',
                      'font-family' => 'Arial',
                      'border-radius' => '',
                      'padding' => '30px 0px 10px 0px',
                      'inner-padding' => '0px 0px 0px 20px',
                      'line-height' => '1.6',
                      'text-padding' => '0px 0px 0px 0px',
                      'icon-padding' => '0px',
                      'icon-size' => '40px',
                    ),
                    'children' => 
                    array (
                    ),
                  ),
                  6 => 
                  array (
                    'type' => 'advanced_divider',
                    'data' => 
                    array (
                      'value' => 
                      array (
                      ),
                    ),
                    'attributes' => 
                    array (
                      'align' => 'center',
                      'border-width' => '1px',
                      'border-style' => 'solid',
                      'border-color' => '#C6D8DF',
                      'padding' => '30px 24px 0px 24px',
                    ),
                    'children' => 
                    array (
                    ),
                  ),
                  7 => 
                  array (
                    'type' => 'advanced_text',
                    'data' => 
                    array (
                      'value' => 
                      array (
                        'content' => 'No longer want to be Mail Mint friends?',
                      ),
                    ),
                    'attributes' => 
                    array (
                      'padding' => '30px 0px 0px 0px',
                      'align' => 'center',
                      'color' => '#76919A',
                      'font-size' => '15px',
                      'line-height' => '1',
                      'font-weight' => '400',
                    ),
                    'children' => 
                    array (
                    ),
                  ),
                  8 => 
                  array (
                    'type' => 'advanced_text',
                    'data' => 
                    array (
                      'value' => 
                      array (
                       'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
                      ),
                    ),
                    'attributes' => 
                    array (
                      'padding' => '10px 0px 0px 0px',
                      'align' => 'center',
                      'color' => '#76919A',
                      'font-size' => '14px',
                      'font-family' => 'Arial',
                      'line-height' => '1.42',
                    ),
                    'children' => 
                    array (
                    ),
                  ),
                  9 => 
                  array (
                    'type' => 'advanced_text',
                    'data' => 
                    array (
                      'value' => 
                      array (
                        'content' => '<a href="#" target="_blank" style="color: inherit; text-decoration: underline;" tabindex="-1">Update Preference </a>&nbsp;.&nbsp;&nbsp;<a href="#" target="_blank" style="color: inherit; text-decoration: underline;" tabindex="-1">Unsubscribe</a>',
                      ),
                    ),
                    'attributes' => 
                    array (
                      'padding' => '12px 0px 32px 0px',
                      'align' => 'center',
                      'color' => '#76919A',
                      'font-size' => '13px',
                      'line-height' => '1.69',
                      'font-weight' => '400',
                    ),
                    'children' => 
                    array (
                    ),
                  ),
                ),
              ),
            ),
          ),
        );
    }
    if ( !empty( $templates[ 28 ] ) && empty( $templates[ 28 ][ 'json_content' ] ) ){
      $templates[ 28 ]['json_content'] = array (
        'subject' => 'Welcome to Mail Mint email marketing and automation',
        'subTitle' => 'Nice to meet you!',
        'content' => 
        array (
          'type' => 'page',
          'data' => 
          array (
            'value' => 
            array (
              'breakpoint' => '480px',
              'headAttributes' => '',
              'font-size' => '14px',
              'font-weight' => '400',
              'line-height' => '1.7',
              'headStyles' => 
              array (
              ),
              'fonts' => 
              array (
              ),
              'responsive' => true,
              'font-family' => 'Arial',
              'text-color' => '#000000',
            ),
          ),
          'attributes' => 
          array (
            'background-color' => '#efeeea',
            'width' => '600px',
          ),
          'children' => 
          array (
            0 => 
            array (
              'type' => 'advanced_image',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'height' => 'auto',
                'padding' => '22px 0px 0px 0px',
                'src' => $image_path . 'your-logo.png',
                'width' => '100%',
                'container-background-color' => '#EFEAE6',
              ),
              'children' => 
              array (
              ),
            ),
            1 => 
            array (
              'type' => 'advanced_wrapper',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#EFEAE6',
                'padding' => '0px 24px 24px 24px',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_spacer',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'height' => '22px',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_hero',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'background-position' => 'center center',
                    'mode' => 'fluid-height',
                    'padding' => '0px 0px 40px 0px',
                    'vertical-align' => 'top',
                    'background-url' => '',
                    'border-radius' => '0px',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '0px 0px 0px 0px',
                        'src' => $image_path . 'abandon-cart/hero-bg.jpg',
                        'border-radius' => '',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Your Cart Misses You!',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '30px 5px 20px 5px',
                        'align' => 'center',
                        'font-size' => '30px',
                        'line-height' => '0.8',
                        'font-weight' => '800',
                        'color' => '#2B2D38',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'We noticed you left some items in your cart. 😕 Complete your purchase now and enjoy your selected items!',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 20px 0 20px',
                        'align' => 'center',
                        'font-size' => '18px',
                        'line-height' => '1.5',
                        'color' => '#737373',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    3 => 
                    array (
                      'type' => 'button',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Complete your order',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'background-color' => '#FF5A74',
                        'color' => '#ffffff',
                        'font-size' => '18px',
                        'font-weight' => '700',
                        'border-radius' => '30px',
                        'padding' => '10px 0px 10px 0px',
                        'inner-padding' => '17px 40px 17px 40px',
                        'line-height' => '0.8',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'href' => '#',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    4 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Congratulations, you qualified for free delivery!',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '20px 5px 0px 5px',
                        'align' => 'center',
                        'font-size' => '14px',
                        'line-height' => '1',
                        'color' => '#737373',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_spacer',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'height' => '40px',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                3 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'Here\'s a reminder of what&nbsp;<div>you left behind</div>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '0px 5px 5px 5px',
                    'align' => 'center',
                    'font-size' => '26px',
                    'line-height' => '1.3',
                    'font-weight' => '800',
                    'color' => '#2B2D38',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                4 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => false,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '',
                    'padding' => '40px 0px 20px 0px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '50%',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => 'auto',
                            'padding' => '0px 0px 0px 0px',
                            'src' => $image_path . 'abandon-cart/cart-1.png',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '50%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Shimmering Oil Body Cream',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '40px 0px 10px 25px',
                            'align' => 'left',
                            'color' => '#2B2D38',
                            'font-size' => '18px',
                            'line-height' => '1',
                            'font-weight' => '700',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Qty: 1<div>$45.00<br></div>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 0px 10px 25px',
                            'align' => 'left',
                            'color' => '#4F4949',
                            'font-size' => '16px',
                            'line-height' => '',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                5 => 
                array (
                  'type' => 'advanced_divider',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'border-width' => '1px',
                    'border-style' => 'solid',
                    'border-color' => '#D6CDC6',
                    'padding' => '10px 0px 10px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                6 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => false,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '',
                    'padding' => '20px 0px 20px 0px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '50%',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => 'auto',
                            'padding' => '0px 0px 0px 0px',
                            'src' => $image_path . 'abandon-cart/cart-2.png',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '50%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Gloss Bomb Lip Luminizer',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '40px 0px 10px 25px',
                            'align' => 'left',
                            'color' => '#2B2D38',
                            'font-size' => '18px',
                            'line-height' => '1',
                            'font-weight' => '700',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Qty: 3<div>$80.00<br></div>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 0px 10px 25px',
                            'align' => 'left',
                            'color' => '#4F4949',
                            'font-size' => '16px',
                            'line-height' => '',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                7 => 
                array (
                  'type' => 'advanced_button',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'Complete your order',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'font-family' => 'Arial',
                    'background-color' => '#FF5A74',
                    'color' => '#ffffff',
                    'font-weight' => '700',
                    'font-style' => 'normal',
                    'border-radius' => '100px',
                    'padding' => '20px 0px 0px 0px',
                    'inner-padding' => '17px 40px 17px 40px',
                    'font-size' => '18px',
                    'line-height' => '0.8',
                    'target' => '_blank',
                    'vertical-align' => 'middle',
                    'border' => 'none',
                    'text-align' => 'center',
                    'letter-spacing' => 'normal',
                    'href' => '#',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                8 => 
                array (
                  'type' => 'advanced_spacer',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'height' => '40px',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                9 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'Similar Product',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '40px 5px 30px 5px',
                    'align' => 'center',
                    'font-size' => '26px',
                    'line-height' => '0.9',
                    'font-weight' => '800',
                    'color' => '#2B2D38',
                    'container-background-color' => '#FFFFFF',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                10 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => false,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'padding' => '0px 30px 20px 30px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '50%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => 'auto',
                            'padding' => '0px 13px 0px 13px',
                            'src' => $image_path . 'abandon-cart/product-1.png',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Variety of shadows',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 25px 10px 25px',
                            'align' => 'left',
                            'font-size' => '18px',
                            'line-height' => '1',
                            'font-weight' => '700',
                            'color' => '#2B2D38',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '50%',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => 'auto',
                            'padding' => '0px 13px 0px 13px',
                            'src' => $image_path . 'abandon-cart/product-2.png',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Panorama Mascara',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 25px 10px 25px',
                            'align' => 'left',
                            'font-size' => '18px',
                            'line-height' => '1',
                            'font-weight' => '700',
                            'color' => '#2B2D38',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                11 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => false,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'padding' => '0px 30px 20px 30px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '50%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => 'auto',
                            'padding' => '0px 13px 0px 13px',
                            'src' => $image_path . 'abandon-cart/product-3.png',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Hydrating Skin Tint',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 25px 10px 25px',
                            'align' => 'left',
                            'font-size' => '18px',
                            'line-height' => '1',
                            'font-weight' => '700',
                            'color' => '#2B2D38',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '50%',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => 'auto',
                            'padding' => '0px 13px 0px 13px',
                            'src' => $image_path . 'abandon-cart/product-4.png',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Longwear Foundation',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 25px 10px 25px',
                            'align' => 'left',
                            'font-size' => '18px',
                            'line-height' => '1',
                            'font-weight' => '700',
                            'color' => '#2B2D38',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                12 => 
                array (
                  'type' => 'advanced_spacer',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'height' => '24px',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                13 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => false,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'padding' => '27px 20px 27px 20px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '33.33%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => 'auto',
                            'padding' => '0px 0px 0px 0px',
                            'src' => $image_path . 'abandon-cart/payment.png',
                            'width' => '38px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Secure&nbsp;<div>Payments</div>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 0px 10px 0px',
                            'align' => 'center',
                            'font-size' => '16px',
                            'line-height' => '1.25',
                            'font-weight' => '700',
                            'color' => '#222222',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '33.33%',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => 'auto',
                            'padding' => '0px 0px 0px 0px',
                            'src' => $image_path . 'abandon-cart/return.png',
                            'width' => '38px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Easy&nbsp;<div>Returns<br></div>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 0px 10px 0px',
                            'align' => 'center',
                            'font-size' => '16px',
                            'line-height' => '1.25',
                            'font-weight' => '700',
                            'color' => '#222222',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '33.33%',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => 'auto',
                            'padding' => '0px 0px 0px 0px',
                            'src' => $image_path . 'abandon-cart/shipping.png',
                            'width' => '38px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Free&nbsp;<div>shipping<br></div>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 0px 10px 0px',
                            'align' => 'center',
                            'font-size' => '16px',
                            'line-height' => '1.25',
                            'font-weight' => '700',
                            'color' => '#222222',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                14 => 
                array (
                  'type' => 'advanced_spacer',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'height' => '24px',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                15 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => false,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '',
                    'padding' => '20px 0px 0px 0px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '40%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Visit <font color="#ff5a74"><a href="#" target="_blank" style="color: inherit; text-decoration: underline;">Bellory.com</a></font>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '0px 0px 0px 0px',
                            'align' => 'left',
                            'font-size' => '16px',
                            'line-height' => '1',
                            'font-weight' => '700',
                            'color' => '#2B2D38',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '60%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Got a question? <font color="#ff5a74"><a href="#" target="_blank" style="color: inherit; text-decoration: underline;">Visit Customer Support</a></font><br>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '0px 0px 0px 0px',
                            'align' => 'right',
                            'font-size' => '16px',
                            'line-height' => '1',
                            'font-weight' => '700',
                            'color' => '#2B2D38',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                16 => 
                array (
                  'type' => 'advanced_spacer',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'height' => '10px',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                17 => 
                array (
                  'type' => 'advanced_divider',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'border-width' => '1px',
                    'border-style' => 'solid',
                    'border-color' => '#DACFC6',
                    'padding' => '10px 0px 10px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                18 => 
                array (
                  'type' => 'advanced_social',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'elements' => 
                      array (
                        0 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'abandon-cart/pinterest.png',
                          'content' => '',
                        ),
                        1 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'abandon-cart/facebook.png',
                          'content' => '',
                        ),
                        2 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'abandon-cart/instagram.png',
                          'content' => '',
                        ),
                        3 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'abandon-cart/twiter.png',
                          'content' => '',
                        ),
                      ),
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'color' => '#333333',
                    'mode' => 'horizontal',
                    'font-size' => '13px',
                    'font-weight' => 'normal',
                    'font-style' => 'normal',
                    'font-family' => 'Arial',
                    'border-radius' => '3px',
                    'padding' => '10px 0px 10px 0px',
                    'inner-padding' => '4px 20px 4px 0px',
                    'line-height' => '1.6',
                    'text-padding' => '4px 4px 4px 0px',
                    'icon-padding' => '0px',
                    'icon-size' => '40px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                19 => 
                array (
                  'type' => 'advanced_divider',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'border-width' => '1px',
                    'border-style' => 'solid',
                    'border-color' => '#DACFC6',
                    'padding' => '10px 0px 10px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                20 => 
                array (
                  'type' => 'advanced_spacer',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'height' => '40px',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                21 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'No longer want to be Mail Mint friends?',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '0px 25px 8px 25px',
                    'align' => 'center',
                    'font-size' => '15px',
                    'line-height' => '1.4',
                    'color' => '#737373',
                    'font-weight' => '500',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                22 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<a href="{{link.preference}}" target="_blank" style="color: inherit; text-decoration: underline;">Email Preference</a>&nbsp;.&nbsp;<a href="{{link.unsubscribe}}" target="_blank" style="color: inherit; text-decoration: underline;">Unsubscribe</a>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '0px 25px 8px 25px',
                    'align' => 'center',
                    'font-size' => '15px',
                    'line-height' => '1.4',
                    'color' => '#737373',
                    'font-weight' => '500',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                23 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '24px 0px 8px 0px',
                    'align' => 'center',
                    'font-size' => '14px',
                    'line-height' => '1.5',
                    'color' => '#737373',
                    'font-weight' => '400',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
          ),
        ),
      );
    }
    if ( !empty( $templates[ 30 ] ) && empty( $templates[ 30 ][ 'json_content' ] ) ){
      $templates[ 30 ]['json_content'] = array (
        'subject' => 'Welcome to Mail Mint email marketing and automation',
        'subTitle' => 'Nice to meet you!',
        'content' => 
        array (
          'type' => 'page',
          'data' => 
          array (
            'value' => 
            array (
              'breakpoint' => '480px',
              'headAttributes' => '',
              'font-size' => '14px',
              'font-weight' => '400',
              'line-height' => '1.7',
              'headStyles' => 
              array (
              ),
              'fonts' => 
              array (
              ),
              'responsive' => true,
              'font-family' => 'Arial',
              'text-color' => '#000000',
            ),
          ),
          'attributes' => 
          array (
            'background-color' => '#efeeea',
            'width' => '600px',
          ),
          'children' => 
          array (
            0 => 
            array (
              'type' => 'advanced_wrapper',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#E9E9F5',
                'padding' => '40px 24px 0px 24px',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_image',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'height' => 'auto',
                    'padding' => '0px 0px 24px 0px',
                    'src' => $image_path . 'your-logo.png',
                    'width' => '100%',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_hero',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'background-position' => 'center center',
                    'mode' => 'fluid-height',
                    'padding' => '40px 0px 0px 0px',
                    'vertical-align' => 'top',
                    'background-url' => '',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '🌟 Introducing&nbsp;<div>Referral Rewards! 🏆</div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 25px 10px 25px',
                        'align' => 'center',
                        'color' => '#171330',
                        'font-size' => '34px',
                        'line-height' => '1.29',
                        'font-weight' => '700',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '40px 50px 40px 50px',
                        'src' => $image_path . 'refferel/hero-img.png',
                        'width' => '',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Share your special referral link with friends and family and give them a generous 10% off their first purchase.&nbsp;<div><br></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'left',
                        'background-color' => '#414141',
                        'color' => '#1D183B99',
                        'font-weight' => 'normal',
                        'border-radius' => '3px',
                        'padding' => '10px 30px 10px 30px',
                        'inner-padding' => '10px 25px 10px 25px',
                        'line-height' => '1.5',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'href' => '#',
                        'font-size' => '18px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
              ),
            ),
            1 => 
            array (
              'type' => 'advanced_wrapper',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#573BFF',
                'padding' => '0px 24px 40px 24px',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_hero',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'background-position' => 'center center',
                    'mode' => 'fluid-height',
                    'padding' => '0px 0px 40px 0px',
                    'vertical-align' => 'top',
                    'background-url' => '',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Plus, earn exciting rewards for every successful referral.Your network benefits, and so do you - it\'s a win-win!',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 30px 0px 30px',
                        'align' => 'left',
                        'color' => '#1D183B99',
                        'font-size' => '18px',
                        'line-height' => '1.5',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'button',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Invite Now',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'background-color' => '#573BFF',
                        'color' => '#ffffff',
                        'font-size' => '16px',
                        'font-weight' => '600',
                        'border-radius' => '12px',
                        'padding' => '40px 0px 0px 0px',
                        'inner-padding' => '17px 35px 17px 35px',
                        'line-height' => '0.9',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'href' => '#',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'Here\'s how it works',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '40px 0px 40px 0px',
                    'align' => 'center',
                    'color' => '#FFFFFF',
                    'font-size' => '30px',
                    'line-height' => '1',
                    'font-weight' => '800',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => false,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '',
                    'padding' => '20px 0px 0px 0px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '48%',
                        'padding' => '10px 0px 0px 0px',
                        'background-color' => '#FFFFFF',
                        'border-radius' => '16px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => '40px',
                            'padding' => '30px 0px 0px 0px',
                            'src' => $image_path . 'refferel/invite.png',
                            'width' => '51px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_divider',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'border-width' => '1px',
                            'border-style' => 'solid',
                            'border-color' => '#D9D9D9',
                            'padding' => '30px 0px 10px 0px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        2 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => '<font color="#573bff">1.</font> Invite your friends using your unique personal link.',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 5px 16px 5px',
                            'align' => 'center',
                            'font-size' => '16px',
                            'line-height' => '1.5',
                            'font-weight' => '700',
                            'color' => '#3D4A45',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '4%',
                        'padding' => '20px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '48%',
                        'padding' => '10px 0px 0px 0px',
                        'border-radius' => '16px',
                        'background-color' => '#FFFFFF',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => '40px',
                            'padding' => '30px 0px 0px 0px',
                            'src' => $image_path . 'refferel/unlock.png',
                            'width' => '45px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_divider',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'border-width' => '1px',
                            'border-style' => 'solid',
                            'border-color' => '#D9D9D9',
                            'padding' => '30px 0px 10px 0px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        2 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => '<font color="#573bff">2.</font> IUnlock rewards with each friend\'s sign-up',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 5px 16px 5px',
                            'align' => 'center',
                            'font-size' => '16px',
                            'line-height' => '1.5',
                            'font-weight' => '700',
                            'color' => '#3D4A45',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                3 => 
                array (
                  'type' => 'advanced_spacer',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'height' => '4px',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                4 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => false,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '',
                    'padding' => '20px 0px 0px 0px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '48%',
                        'padding' => '10px 0px 0px 0px',
                        'background-color' => '#FFFFFF',
                        'border-radius' => '16px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => '40px',
                            'padding' => '30px 0px 0px 0px',
                            'src' => $image_path . 'refferel/reffer.png',
                            'width' => '40px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_divider',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'border-width' => '1px',
                            'border-style' => 'solid',
                            'border-color' => '#D9D9D9',
                            'padding' => '30px 0px 10px 0px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        2 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => '<font color="#573bff">3.</font>&nbsp;Refer by Sept 5th,&nbsp;<div>last chance!</div>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 5px 16px 5px',
                            'align' => 'center',
                            'font-size' => '16px',
                            'line-height' => '1.5',
                            'font-weight' => '700',
                            'color' => '#3D4A45',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '4%',
                        'padding' => '20px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '48%',
                        'padding' => '10px 0px 0px 0px',
                        'border-radius' => '16px',
                        'background-color' => '#FFFFFF',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => '40px',
                            'padding' => '30px 0px 0px 0px',
                            'src' => $image_path . 'refferel/gift.png',
                            'width' => '40px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_divider',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'border-width' => '1px',
                            'border-style' => 'solid',
                            'border-color' => '#D9D9D9',
                            'padding' => '30px 0px 10px 0px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        2 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => '<font color="#573bff">4.</font>&nbsp;Refer by Sept 5th,&nbsp;<div>last chance!</div>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 5px 16px 5px',
                            'align' => 'center',
                            'font-size' => '16px',
                            'line-height' => '1.5',
                            'font-weight' => '700',
                            'color' => '#3D4A45',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                5 => 
                array (
                  'attributes' => 
                  array (
                    'padding' => '0px 0px 0px 0px',
                  ),
                ),
                6 => 
                array (
                  'type' => 'advanced_spacer',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'height' => '40px',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                7 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'Copy and share your unique link',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '0px 0px 0px 0px',
                    'align' => 'center',
                    'color' => '#FFFFFF',
                    'font-size' => '18px',
                    'line-height' => '1',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                8 => 
                array (
                  'type' => 'advanced_button',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'https://www.example.com/demu',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'font-family' => 'Arial',
                    'background-color' => '#644AFF',
                    'color' => '#ffffff',
                    'font-weight' => '500',
                    'font-style' => 'normal',
                    'border-radius' => '16px',
                    'padding' => '20px 0px 0px 0px',
                    'inner-padding' => '15px 25px 15px 25px',
                    'font-size' => '18px',
                    'line-height' => '1',
                    'target' => '_blank',
                    'vertical-align' => 'middle',
                    'border' => '1px solid #FFF',
                    'text-align' => 'center',
                    'letter-spacing' => 'normal',
                    'href' => '#',
                    'width' => '100%',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
            2 => 
            array (
              'type' => 'advanced_wrapper',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#E9E9F5',
                'padding' => '40px 22px 40px 22px',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '🌈 Unlock Rewards',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '0px 0px 0px 0px',
                    'align' => 'center',
                    'font-size' => '30px',
                    'line-height' => '1',
                    'font-weight' => '800',
                    'color' => '#171330',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_spacer',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'height' => '35px',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => false,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'padding' => '24px 20px 24px 0px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                    'border-radius' => '16px',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '30%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => '1 Friends',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 25px 10px 25px',
                            'align' => 'left',
                            'font-size' => '18px',
                            'line-height' => '1',
                            'color' => '#1D183B99',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '70%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => '✅&nbsp; Your reward $30',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 5px 10px 0px',
                            'align' => 'right',
                            'font-size' => '18px',
                            'line-height' => '1',
                            'font-weight' => '600',
                            'color' => '#171330',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                3 => 
                array (
                  'type' => 'advanced_spacer',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'height' => '20px',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                4 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => false,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'padding' => '24px 20px 24px 0px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                    'border-radius' => '16px',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '30%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => '5 Friends',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 25px 10px 25px',
                            'align' => 'left',
                            'font-size' => '18px',
                            'line-height' => '1',
                            'color' => '#1D183B99',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '70%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => '✅&nbsp; Your reward $60',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 5px 10px 0px',
                            'align' => 'right',
                            'font-size' => '18px',
                            'line-height' => '1',
                            'font-weight' => '600',
                            'color' => '#171330',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                5 => 
                array (
                  'type' => 'advanced_spacer',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'height' => '20px',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                6 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => false,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'padding' => '24px 20px 24px 0px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                    'border-radius' => '16px',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '30%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => '10 Friends',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 25px 10px 25px',
                            'align' => 'left',
                            'font-size' => '18px',
                            'line-height' => '1',
                            'color' => '#1D183B99',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '70%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => '✅&nbsp; Your reward $100 +&nbsp;<font color="#573bff">Bonus</font>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 5px 10px 0px',
                            'align' => 'right',
                            'font-size' => '18px',
                            'line-height' => '1',
                            'font-weight' => '600',
                            'color' => '#171330',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                7 => 
                array (
                  'type' => 'advanced_button',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'Invite Now',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'font-family' => 'Arial',
                    'background-color' => '#573BFF',
                    'color' => '#ffffff',
                    'font-weight' => '600',
                    'font-style' => 'normal',
                    'border-radius' => '12px',
                    'padding' => '30px 0px 40px 0px',
                    'inner-padding' => '17px 33px 17px 33px',
                    'font-size' => '16px',
                    'line-height' => '0.9',
                    'target' => '_blank',
                    'vertical-align' => 'middle',
                    'border' => 'none',
                    'text-align' => 'center',
                    'letter-spacing' => 'normal',
                    'href' => '#',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                8 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => false,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'padding' => '0px 0px 40px 0px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                    'border-radius' => '20px',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '100%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Got a question?',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '40px 0px 16px 0px',
                            'align' => 'center',
                            'color' => '#573BFF',
                            'font-size' => '30px',
                            'line-height' => '1',
                            'font-weight' => '800',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'We’re here to help you',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '0px 0px 30px 0px',
                            'align' => 'center',
                            'font-size' => '30px',
                            'line-height' => '1',
                            'font-weight' => '500',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '50%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => '36px',
                            'padding' => '0px 0px 0px 0px',
                            'src' => $image_path . 'refferel/message.png',
                            'width' => '36px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'support@gmail.com',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 25px 10px 25px',
                            'align' => 'center',
                            'font-size' => '18px',
                            'line-height' => '0.8',
                            'font-weight' => '500',
                            'text-decoration' => 'underline',
                            'color' => '#171330',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '50%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => '36px',
                            'padding' => '0px 0px 0px 0px',
                            'src' => $image_path . 'refferel/phone.png',
                            'width' => '36px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => '2.999.000.6743',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 25px 10px 25px',
                            'align' => 'center',
                            'font-size' => '18px',
                            'line-height' => '0.8',
                            'font-weight' => '500',
                            'text-decoration' => 'underline',
                            'color' => '#171330',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
              ),
            ),
            3 => 
            array (
              'type' => 'advanced_wrapper',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#ffffff',
                'padding' => '30px 0px 30px 0px',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_social',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'elements' => 
                      array (
                        0 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'refferel/pinterest.png',
                          'content' => '',
                        ),
                        1 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'refferel/facebook.png',
                          'content' => '',
                        ),
                        2 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'refferel/instagram.png',
                          'content' => '',
                        ),
                        3 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'refferel/twiter.png',
                          'content' => '',
                        ),
                      ),
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'color' => '#333333',
                    'mode' => 'horizontal',
                    'font-size' => '13px',
                    'font-weight' => 'normal',
                    'font-style' => 'normal',
                    'font-family' => 'Arial',
                    'border-radius' => '3px',
                    'padding' => '0px 0px 0px 0px',
                    'inner-padding' => '0px 20px 0px 0px',
                    'line-height' => '1.6',
                    'text-padding' => '4px 4px 4px 0px',
                    'icon-padding' => '0px',
                    'icon-size' => '40px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_divider',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'border-width' => '1px',
                    'border-style' => 'solid',
                    'border-color' => '#E9E9F2',
                    'padding' => '30px 0px 40px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'No longer want to be Mail Mint friends?',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '0px 0px 8px 0px',
                    'align' => 'center',
                    'font-size' => '15px',
                    'line-height' => '1.4',
                    'color' => '#8787A1',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                3 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<a href="{{link.preference}}" target="_blank" style="color: inherit; text-decoration: underline;">Email Preference</a> .&nbsp;<a href="{{link.unsubscribe}}" target="_blank" style="color: inherit; text-decoration: underline;">Unsubscribe</a>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '0px 0px 8px 0px',
                    'align' => 'center',
                    'font-size' => '15px',
                    'line-height' => '1.4',
                    'color' => '#8787A1',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                4 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '40px 0px 8px 0px',
                    'align' => 'center',
                    'font-size' => '15px',
                    'line-height' => '1.4',
                    'color' => '#8787A1',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
          ),
        ),
      );
    }
    if ( !empty( $templates[ 31 ] ) && empty( $templates[ 31 ][ 'json_content' ] ) ){
      $templates[ 31 ]['json_content'] = array (
        'subject' => 'Welcome to Mail Mint email marketing and automation',
        'subTitle' => 'Nice to meet you!',
        'content' => 
        array (
          'type' => 'page',
          'data' => 
          array (
            'value' => 
            array (
              'breakpoint' => '480px',
              'headAttributes' => '',
              'font-size' => '14px',
              'font-weight' => '400',
              'line-height' => '1.7',
              'headStyles' => 
              array (
              ),
              'fonts' => 
              array (
              ),
              'responsive' => true,
              'font-family' => 'Arial',
              'text-color' => '#000000',
            ),
          ),
          'attributes' => 
          array (
            'background-color' => '#efeeea',
            'width' => '600px',
          ),
          'children' => 
          array (
            0 => 
            array (
              'type' => 'advanced_image',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'height' => '56px',
                'padding' => '20px 0px 20px 0px',
                'src' => $image_path . 'your-logo.png',
                'container-background-color' => '#FFF',
                'width' => '142px',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'attributes' => 
                  array (
                    'padding' => '0px 0px 0px 0px',
                  ),
                ),
              ),
            ),
            1 => 
            array (
              'type' => 'advanced_wrapper',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#42445D',
                'padding' => '24px 24px 40px 24px',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_hero',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#E5DCED',
                    'background-position' => 'center center',
                    'mode' => 'fluid-height',
                    'padding' => '0px 0px 0px 0px',
                    'vertical-align' => 'top',
                    'background-url' => '',
                    'width' => '',
                    'height' => '',
                    'background-width' => '552px',
                    'background-height' => '807px',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Oops, We Messed Up.',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '20px 10px 0px 10px',
                        'align' => 'center',
                        'color' => '#42445D',
                        'font-size' => '32px',
                        'line-height' => '1.23',
                        'font-weight' => '800',
                        'height' => '41px',
                        'font-family' => 'Arial',
                        'font-style' => 'normal',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => '313px',
                        'padding' => '30px 0px 0px 0px',
                        'src' => $image_path . 'apology-email-template/hero-img.png',
                        'width' => '552px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Dear John Doe,',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '40px 25px 40px 40px',
                        'align' => 'left',
                        'font-size' => '16px',
                        'font-weight' => '400',
                        'color' => '#42445D',
                        'font-family' => 'Arial',
                        'line-height' => '0',
                        'font-style' => 'normal',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    3 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'We were thrilled about the launch of our new website, but unfortunately, a mix-up occurred, and we mistakenly sent you the wrong email.<div>Our sincere apologies for any confusion caused. We appreciate your understanding as we strive to deliver the correct information promptly.</div><div></div><div>Thanks for your patience,&nbsp;</span><br></div><div>John Young,&nbsp;</div><div>Creative Team CEO!</div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 55px 40px 40px',
                        'align' => 'left',
                        'color' => '#42445D',
                        'font-weight' => '400',
                        'line-height' => '1.56',
                        'font-style' => 'normal',
                        'font-size' => '16px',
                        'font-family' => 'Arial',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_social',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'elements' => 
                      array (
                        0 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'apology-email-template/pinterest.png',
                          'content' => '',
                        ),
                        1 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'apology-email-template/facebook.png',
                          'content' => '',
                        ),
                        2 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'apology-email-template/instagram.png',
                          'content' => '',
                        ),
                        3 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'apology-email-template/twiter.png',
                          'content' => '',
                        ),
                      ),
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'color' => '#FFF',
                    'mode' => 'horizontal',
                    'font-size' => '13px',
                    'font-weight' => 'normal',
                    'font-style' => 'normal',
                    'font-family' => 'Arial',
                    'border-radius' => '3px',
                    'padding' => '40px 0px 20px 1px',
                    'inner-padding' => '4px 4px 4px 20px',
                    'line-height' => '1.7',
                    'text-padding' => '4px 4px 4px 0px',
                    'icon-padding' => '0px',
                    'icon-size' => '40px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_spacer',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'height' => '1px',
                    'padding' => '0px 24px 0px 24px',
                    'container-background-color' => '#5B5D78',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                3 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'No longer want to be Mail Mint friends?',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '30px 25px 10px 25px',
                    'align' => 'center',
                    'font-style' => 'normal',
                    'color' => 'rgba(255, 255, 255, 0.70)',
                    'font-size' => '15px',
                    'line-height' => '1.46',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                4 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<a href="{{link.preference}}">Email Preference</a>&nbsp; .&nbsp;&nbsp;<a href="{{link.unsubscribe}}">Unsubscribe</a>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '1px 25px 10px 25px',
                    'align' => 'center',
                    'font-style' => 'normal',
                    'color' => 'rgba(255, 255, 255, 0.70)',
                    'font-size' => '15px',
                    'font-weight' => '500',
                    'line-height' => '1.46',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                5 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => 'px 114px 30px 115px',
                    'align' => 'center',
                    'font-style' => 'normal',
                    'font-weight' => '400',
                    'font-size' => '14px',
                    'line-height' => '1.57',
                    'color' => 'rgba(255, 255, 255, 0.70)',
                    'font-family' => 'Arial',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
            2 => 
            array (
              'attributes' => 
              array (
                'padding' => '0px 0px 0px 0px',
              ),
            ),
            3 => 
            array (
              'attributes' => 
              array (
                'padding' => '0px 0px 0px 0px',
              ),
            ),
          ),
        ),
      );
    }
    if ( !empty( $templates[ 33 ] ) && empty( $templates[ 33 ][ 'json_content' ] ) ){
      $templates[ 33 ]['json_content'] = array (
        'content' => 
        array (
          'type' => 'page',
          'data' => 
          array (
            'value' => 
            array (
              'breakpoint' => '480px',
              'headAttributes' => '',
              'font-size' => '14px',
              'font-weight' => '400',
              'line-height' => '1.7',
              'headStyles' => 
              array (
              ),
              'fonts' => 
              array (
              ),
              'responsive' => true,
              'font-family' => 'Arial',
              'text-color' => '#000000',
            ),
          ),
          'attributes' => 
          array (
            'background-color' => '#efeeea',
            'width' => '600px',
          ),
          'children' => 
          array (
            0 => 
            array (
              'type' => 'advanced_image',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'height' => 'auto',
                'padding' => '16px 0px 16px 0px',
                'src' => $image_path . 'your-logo.png',
                'width' => '100%',
                'container-background-color' => '#fff',
              ),
              'children' => 
              array (
              ),
            ),
            1 => 
            array (
              'type' => 'advanced_wrapper',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#F3F3F3',
                'padding' => '24px 24px 0px 24px',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_hero',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'background-position' => 'center center',
                    'mode' => 'fluid-height',
                    'padding' => '0px 0px 0px 0px',
                    'vertical-align' => 'top',
                    'background-url' => '',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Explore Mail Mint\'s Yearly Highlights✨',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '40px 0px 0px 0px',
                        'align' => 'center',
                        'color' => '#0064FF',
                        'font-size' => '36px',
                        'line-height' => '1.27',
                        'font-family' => 'Arial',
                        'font-weight' => '800',
                        'font-style' => 'normal',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'At Mail Mint, we believe in transparency and sharing our journey with our valued community. Today, we\'re thrilled to give you an exclusive backstage pass to the heart of our operations.',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'left',
                        'background-color' => '#414141',
                        'color' => '#6C6C6C',
                        'font-weight' => '400',
                        'border-radius' => '3px',
                        'padding' => '14px 55px 0px 40px',
                        'inner-padding' => '10px 25px 10px 25px',
                        'line-height' => '1.56',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'href' => '#',
                        'font-size' => '16px',
                        'font-style' => 'normal',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '34px 0px 0px 0px',
                        'src' => $image_path . 'behind-the-scenes-peek/hero-img.png',
                        'width' => '',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    3 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<ul><li><span style="word-spacing: normal;">Make it easy for everyone to compose emails!</span></li><li style="--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff));">How we brainstormed a new marketing campaign.</li><li style="--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff));">The process behind recent website upgrades.</li><li style="--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff));">A peek at our lively office environment.</li></ul>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '12px 0px 0px 40px',
                        'align' => 'left',
                        'font-size' => '16px',
                        'color' => '#6C6C6C',
                        'line-height' => '1.75',
                        'font-weight' => '400',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    4 => 
                    array (
                      'type' => 'advanced_button',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Learn More',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'font-family' => 'Arial',
                        'background-color' => '#0064FF',
                        'color' => '#ffffff',
                        'font-weight' => 'normal',
                        'font-style' => 'normal',
                        'border-radius' => '12px',
                        'padding' => '30px 0px 0px 0px',
                        'inner-padding' => '17px 40px 17px 40px',
                        'font-size' => '16px',
                        'line-height' => '0.93',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'letter-spacing' => 'normal',
                        'href' => '#',
                        'width' => '',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    5 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '50px 0px 0px 0px',
                        'src' => $image_path . 'behind-the-scenes-peek/sign-up.png',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    6 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Enhance work efficiency  🛠️',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '30px 0px 0px 0px',
                        'align' => 'center',
                        'font-size' => '30px',
                        'line-height' => '1',
                        'font-weight' => '800',
                        'color' => '#242856',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    7 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Join Mail Mint, a global community empowering agencies, consultants, and marketing experts! Embrace your entrepreneurial spirit with ease.',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '12px 20px 0px 20px',
                        'align' => 'left',
                        'font-size' => '16px',
                        'line-height' => '1.56',
                        'color' => '#6C6C6C',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    8 => 
                    array (
                      'type' => 'advanced_button',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Sign Up Now',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'font-family' => 'Arial',
                        'background-color' => '#0064FF',
                        'color' => '#ffffff',
                        'font-weight' => 'normal',
                        'font-style' => 'normal',
                        'border-radius' => '12px',
                        'padding' => '30px 25px 40px 25px',
                        'inner-padding' => '17px 40px 17px 40px',
                        'font-size' => '16px',
                        'line-height' => '0.93',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'letter-spacing' => 'normal',
                        'href' => '#',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_social',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'elements' => 
                      array (
                        0 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'behind-the-scenes-peek/pinterest.png',
                          'content' => '',
                        ),
                        1 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'behind-the-scenes-peek/facebook.png',
                          'content' => '',
                        ),
                        2 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'behind-the-scenes-peek/instagram.png',
                          'content' => '',
                        ),
                        3 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'behind-the-scenes-peek/twiter.png',
                          'content' => '',
                        ),
                      ),
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'color' => '#333333',
                    'mode' => 'horizontal',
                    'font-size' => '13px',
                    'font-weight' => 'normal',
                    'font-style' => 'normal',
                    'font-family' => 'Arial',
                    'border-radius' => '',
                    'padding' => '30px 0px 10px 0px',
                    'inner-padding' => '0px 0px 0px 20px',
                    'line-height' => '1.6',
                    'text-padding' => '0px 0px 0px 0px',
                    'icon-padding' => '0px',
                    'icon-size' => '40px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_divider',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'border-width' => '1px',
                    'border-style' => 'solid',
                    'border-color' => '#D3CFD8',
                    'padding' => '30px 24px 0px 24px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                3 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'No longer want to be Mail Mint friends?',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '30px 0px 0px 0px',
                    'align' => 'center',
                    'color' => '#908A99',
                    'font-size' => '15px',
                    'line-height' => '1',
                    'font-weight' => '400',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                4 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '10px 0px 0px 0px',
                    'align' => 'center',
                    'color' => '#908A99',
                    'font-size' => '14px',
                    'font-family' => 'Arial',
                    'line-height' => '1.42',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                5 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<a href="#" target="_blank" style="color: inherit; text-decoration: underline;" tabindex="-1">Update Preference </a>&nbsp;.&nbsp;&nbsp;<a href="#" target="_blank" style="color: inherit; text-decoration: underline;" tabindex="-1">Unsubscribe</a>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '12px 0px 32px 0px',
                    'align' => 'center',
                    'color' => '#0064FF',
                    'font-size' => '13px',
                    'line-height' => '1.69',
                    'font-weight' => '400',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
          ),
        ),
        'subTitle' => 'Nice to meet you!',
      );
    }
    if ( !empty( $templates[ 35 ] ) && empty( $templates[ 35 ][ 'json_content' ] ) ){
      $templates[ 35 ]['json_content'] = array (
        'content' => 
        array (
          'type' => 'page',
          'data' => 
          array (
            'value' => 
            array (
              'breakpoint' => '480px',
              'headAttributes' => '',
              'font-size' => '14px',
              'font-weight' => '400',
              'line-height' => '1.7',
              'headStyles' => 
              array (
              ),
              'fonts' => 
              array (
              ),
              'responsive' => true,
              'font-family' => 'Arial',
              'text-color' => '#000000',
            ),
          ),
          'attributes' => 
          array (
            'background-color' => '#efeeea',
            'width' => '600px',
          ),
          'children' => 
          array (
            0 => 
            array (
              'type' => 'advanced_image',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'height' => 'auto',
                'padding' => '20px 0px 20px 0px',
                'src' => $image_path . 'your-logo.png',
                'width' => '100%',
                'container-background-color' => '#fff',
              ),
              'children' => 
              array (
              ),
            ),
            1 => 
            array (
              'type' => 'advanced_wrapper',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#1C1C1C',
                'padding' => '0px 24px 40px 24px',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'Newest Product Drop Alert!',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '40px 0px 0px 0px',
                    'align' => 'center',
                    'color' => '#FFFFFF',
                    'font-family' => 'Arial',
                    'font-size' => '32px',
                    'font-weight' => '800',
                    'line-height' => '1',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'Experience a different reality with our newest&nbsp;<div>cutting-edge VR headset.</div>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '8px 0px 0px 0px',
                    'align' => 'center',
                    'color' => '#ffff',
                    'line-height' => '1.56',
                    'font-size' => '16px',
                    'font-weight' => '400',
                    'font-family' => 'Arial',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_button',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'Get The Product Now',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'font-family' => 'Arial',
                    'background-color' => '#03D77C',
                    'color' => '#060502',
                    'font-weight' => '600',
                    'font-style' => 'normal',
                    'border-radius' => '100px',
                    'padding' => '30px 0px 0px 0px',
                    'inner-padding' => '18px 28px 18px 26px',
                    'font-size' => '16px',
                    'line-height' => '0.93',
                    'target' => '_blank',
                    'vertical-align' => 'middle',
                    'border' => 'none',
                    'text-align' => 'center',
                    'letter-spacing' => 'normal',
                    'href' => '#',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                3 => 
                array (
                  'type' => 'advanced_image',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'height' => 'auto',
                    'padding' => '50px 0px 18px 0px',
                    'src' => $image_path . 'product-launch/hero-img.png',
                    'width' => '',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                4 => 
                array (
                  'type' => 'advanced_hero',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#292929',
                    'background-position' => 'center center',
                    'mode' => 'fluid-height',
                    'padding' => '0px 20px 0px 20px',
                    'vertical-align' => 'top',
                    'background-url' => '',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '🌟 Key Features and Benefits&nbsp;',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '40px 0px 10px 0px',
                        'align' => 'center',
                        'color' => '#fff',
                        'font-size' => '24px',
                        'line-height' => '1.56',
                        'font-weight' => '800',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '✅&nbsp; State-of-the-art virtual reality technology<br>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'left',
                        'background-color' => '#414141',
                        'color' => '#fff',
                        'font-weight' => '500',
                        'border-radius' => '3px',
                        'padding' => '40px 0px 10px 0px',
                        'inner-padding' => '10px 25px 10px 25px',
                        'line-height' => '1.2',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'href' => '#',
                        'font-size' => '18px',
                        'font-family' => 'Arial',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '✅&nbsp; No wires. More fun.<br>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'left',
                        'background-color' => '#414141',
                        'color' => '#fff',
                        'font-weight' => '500',
                        'border-radius' => '3px',
                        'padding' => '24px 0px 10px 0px',
                        'inner-padding' => '10px 25px 10px 25px',
                        'line-height' => '1.2',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'href' => '#',
                        'font-size' => '18px',
                        'font-family' => 'Arial',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    3 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '✅&nbsp; Virtual hangouts will become easier<br>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'left',
                        'background-color' => '#414141',
                        'color' => '#fff',
                        'font-weight' => '500',
                        'border-radius' => '3px',
                        'padding' => '24px 0px 10px 0px',
                        'inner-padding' => '10px 25px 10px 25px',
                        'line-height' => '1.2',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'href' => '#',
                        'font-size' => '18px',
                        'font-family' => 'Arial',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    4 => 
                    array (
                      'type' => 'advanced_button',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Get The Product Now',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'font-family' => 'Arial',
                        'background-color' => '#03D77C',
                        'color' => '#060502',
                        'font-weight' => '600',
                        'font-style' => 'normal',
                        'border-radius' => '100px',
                        'padding' => '40px 0px 40px 0px',
                        'inner-padding' => '18px 28px 18px 26px',
                        'font-size' => '16px',
                        'line-height' => '0.93',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'letter-spacing' => 'normal',
                        'href' => '#',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                5 => 
                array (
                  'type' => 'advanced_image',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'height' => 'auto',
                    'padding' => '0px 0px 0px 0px',
                    'src' => $image_path . 'product-launch/footer-img.png',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
            2 => 
            array (
              'type' => 'advanced_wrapper',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#ffffff',
                'padding' => '0px 0px 0px 0px',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_social',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'elements' => 
                      array (
                        0 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'product-launch/pinterest.png',
                          'content' => '',
                        ),
                        1 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'product-launch/facebook.png',
                          'content' => '',
                        ),
                        2 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'product-launch/instagram.png',
                          'content' => '',
                        ),
                        3 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'product-launch/twiter.png',
                          'content' => '',
                        ),
                      ),
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'color' => '#000',
                    'mode' => 'horizontal',
                    'font-size' => '0px',
                    'font-weight' => 'normal',
                    'font-style' => 'normal',
                    'font-family' => 'Arial',
                    'border-radius' => '0px',
                    'padding' => '30px 0px 0px 0px',
                    'inner-padding' => '0px 0px 0px 20px',
                    'line-height' => '1.6',
                    'text-padding' => '0px 0px 0px 0px',
                    'icon-padding' => '0px',
                    'icon-size' => '40px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_divider',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'border-width' => '1px',
                    'border-style' => 'solid',
                    'border-color' => '#EDECE9',
                    'padding' => '30px 24px 0px 24px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'No longer want to be Mail Mint friends?',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '40px 0px 0px 0px',
                    'align' => 'center',
                    'color' => '#8F8F8F',
                    'font-family' => 'Arial',
                    'font-size' => '15px',
                    'line-height' => '1.46',
                    'font-weight' => '400',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                3 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<a href="{{link.preference}}" target="_blank" style="color: inherit; text-decoration: underline;">Email Preference</a>&nbsp; .&nbsp;&nbsp;<a href="{{link.unsubscribe}}" target="_blank" style="color: inherit; text-decoration: underline;">Unsubscribe</a>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '8px 0px 0px 0px',
                    'align' => 'center',
                    'font-size' => '15px',
                    'font-family' => 'Arial',
                    'line-height' => '1.46',
                    'color' => '#8F8F8F',
                    'font-weight' => '400',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                4 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '10px 0px 30px 0px',
                    'align' => 'center',
                    'color' => '#8F8F8F',
                    'font-size' => '14px',
                    'font-family' => 'Arial',
                    'line-height' => '1.57',
                    'font-weight' => '400',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
          ),
        ),
        'subTitle' => 'Nice to meet you!',
      );
    }
    if ( !empty( $templates[ 36 ] ) && empty( $templates[ 36 ][ 'json_content' ] ) ){
      $templates[ 36 ]['json_content'] = array (
        'content' => 
        array (
          'type' => 'page',
          'data' => 
          array (
            'value' => 
            array (
              'breakpoint' => '480px',
              'headAttributes' => '',
              'font-size' => '14px',
              'font-weight' => '400',
              'line-height' => '1.7',
              'headStyles' => 
              array (
              ),
              'fonts' => 
              array (
              ),
              'responsive' => true,
              'font-family' => 'Arial',
              'text-color' => '#000000',
            ),
          ),
          'attributes' => 
          array (
            'background-color' => '#efeeea',
            'width' => '600px',
          ),
          'children' => 
          array (
            0 => 
            array (
              'type' => 'advanced_image',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'height' => 'auto',
                'padding' => '16px 0px 16px 0px',
                'src' => $image_path . 'your-logo.png',
                'width' => '142px',
                'container-background-color' => '#fff',
              ),
              'children' => 
              array (
              ),
            ),
            1 => 
            array (
              'type' => 'advanced_wrapper',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#498273',
                'padding' => '25px 24px 24px 24px',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_hero',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'background-position' => 'center center',
                    'mode' => 'fluid-height',
                    'padding' => '0px 0px 0px 0px',
                    'vertical-align' => 'top',
                    'background-url' => '',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '0px 0px 0px 0px',
                        'src' => $image_path . 'customer-success-story/hero-img.png',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Your stories are the heart&nbsp;<div><span style="word-spacing: normal;">of&nbsp;</span><span style="word-spacing: normal;">our inspiration.</span></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '35px 0px 0px 0px',
                        'align' => 'center',
                        'color' => '#42445D',
                        'font-size' => '34px',
                        'line-height' => '1.23',
                        'font-weight' => '800',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Over the years, our customers have sent us countless notes that have brought smiles, laughter, and even tears. These messages are living proof that our work is making a genuine, positive impact on people\'s lives, and that\'s what keeps us motivated.',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'background-color' => '#414141',
                        'color' => '#42445D',
                        'font-weight' => '400',
                        'border-radius' => '3px',
                        'padding' => '15px 20px 0px 20px',
                        'inner-padding' => '10px 25px 10px 25px',
                        'line-height' => '1.56',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'href' => '#',
                        'font-size' => '16px',
                        'font-family' => 'Arial',
                        'letter-spacing' => '1.56',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    3 => 
                    array (
                      'type' => 'advanced_divider',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'border-width' => '1px',
                        'border-style' => 'solid',
                        'border-color' => '#D9D9D9',
                        'padding' => '41px 0px 0px 0px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    4 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '40px 0px 0px 0px',
                        'src' => $image_path . 'customer-success-story/star.png',
                        'width' => '173px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    5 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '890 Five - Star Reviews',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '12px 10px 0px 10px',
                        'align' => 'center',
                        'font-weight' => '800',
                        'font-size' => '24px',
                        'line-height' => '1.56',
                        'font-family' => 'Arial',
                        'color' => '#42445D',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    6 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'SOME HIGHLIGHTS',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '12px 0px 0px 0px',
                        'align' => 'center',
                        'font-family' => 'Arial',
                        'font-size' => '14px',
                        'line-height' => '1',
                        'color' => '#498273',
                        'letter-spacing' => '0.56px',
                        'font-weight' => '700',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    7 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Unbelievable results with Mail Mint! Streamlined, user-friendly, and a true productivity booster. Couldn\'t be happier!',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '24px 20px 0px 20px',
                        'align' => 'center',
                        'font-size' => '16px',
                        'color' => '#42445D',
                        'line-height' => '1.56',
                        'font-weight' => '400',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    8 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'James H',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '8px 0px 0px 0px',
                        'align' => 'center',
                        'font-weight' => '700',
                        'color' => '#42445D',
                        'font-size' => '16px',
                        'font-family' => 'Arial',
                        'line-height' => '1',
                        'font-style' => 'normal',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    9 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Exceptional experience using Mail Mint. It\'s like having a personal assistant, making every task effortless. Highly impressed!',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '40px 20px 0px 20px',
                        'align' => 'center',
                        'font-family' => 'Arial',
                        'font-size' => '16px',
                        'line-height' => '1.56',
                        'font-weight' => '400',
                        'color' => '#42445D',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    10 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Emma W',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '8px 0px 0px 0px',
                        'align' => 'center',
                        'font-weight' => '700',
                        'color' => '#42445D',
                        'font-size' => '16px',
                        'font-family' => 'Arial',
                        'line-height' => '1',
                        'font-style' => 'normal',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    11 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Absolutely love Mail Mint! Simple, powerful, and a game-changer in my daily routine. A must-have for anyone seeking efficiency',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '40px 20px 0px 20px',
                        'align' => 'center',
                        'font-family' => 'Arial',
                        'font-size' => '16px',
                        'line-height' => '1.56',
                        'font-weight' => '400',
                        'color' => '#42445D',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    12 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Alex K',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '8px 0px 40px 0px',
                        'align' => 'center',
                        'font-weight' => '700',
                        'color' => '#42445D',
                        'font-size' => '16px',
                        'font-family' => 'Arial',
                        'line-height' => '1',
                        'font-style' => 'normal',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_hero',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#FFD57F',
                    'background-position' => 'center center',
                    'mode' => 'fluid-height',
                    'padding' => '0px 0px 0px 0px',
                    'vertical-align' => 'top',
                    'background-url' => '',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Have you experienced the transformative impact of our product?',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '40px 10px 0px 10px',
                        'align' => 'center',
                        'color' => '#000000',
                        'font-size' => '24px',
                        'line-height' => '1.33',
                        'font-weight' => '700',
                        'font-family' => 'Arial',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'button',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Explore Mail Mint',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'background-color' => '#498273',
                        'color' => '#ffffff',
                        'font-size' => '16px',
                        'font-weight' => '600',
                        'border-radius' => '100px',
                        'padding' => '30px 0px 40px 0px',
                        'inner-padding' => '17px 28px 17px 28px',
                        'line-height' => '0.93',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'href' => '#',
                        'width' => '',
                        'font-family' => 'Arial',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_hero',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'background-position' => 'center center',
                    'mode' => 'fluid-height',
                    'padding' => '0px 0px 0px 0px',
                    'vertical-align' => 'top',
                    'background-url' => '',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Provide Perspective',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '40px 0px 0px 0px',
                        'align' => 'center',
                        'color' => '#42445D',
                        'font-size' => '24px',
                        'line-height' => '1.25',
                        'font-family' => 'Arial',
                        'font-weight' => '700',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Share your narrative and inspire others by submitting your story. Locate the submission link at the bottom of our product pages.',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'background-color' => '#414141',
                        'color' => '#000000',
                        'font-weight' => '400',
                        'border-radius' => '3px',
                        'padding' => '10px 40px 10px 40px',
                        'inner-padding' => '10px 25px 10px 25px',
                        'line-height' => '1.56',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'href' => '#',
                        'font-size' => '16px',
                        'font-family' => 'Arial',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'button',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Submit a review',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'background-color' => '#498273',
                        'color' => '#ffffff',
                        'font-size' => '16px',
                        'font-weight' => '600',
                        'border-radius' => '100px',
                        'padding' => '10px 0px 40px 0px',
                        'inner-padding' => '17px 28px 17px 28px',
                        'line-height' => '0.93',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'href' => '#',
                        'font-family' => 'Arial',
                        'width' => '',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                3 => 
                array (
                  'type' => 'advanced_hero',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#F5F5F5',
                    'background-position' => 'center center',
                    'mode' => 'fluid-height',
                    'padding' => '0px 0px 0px 0px',
                    'vertical-align' => 'top',
                    'background-url' => '',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_social',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'elements' => 
                          array (
                            0 => 
                            array (
                              'href' => '#',
                              'target' => '_blank',
                              'src' => $image_path . 'customer-success-story/pinterest.png',
                              'content' => '',
                            ),
                            1 => 
                            array (
                              'href' => '#',
                              'target' => '_blank',
                              'src' => $image_path . 'customer-success-story/facebook.png',
                              'content' => '',
                            ),
                            2 => 
                            array (
                              'href' => '#',
                              'target' => '_blank',
                              'src' => $image_path . 'customer-success-story/instagram.png',
                              'content' => '',
                            ),
                            3 => 
                            array (
                              'href' => '#',
                              'target' => '_blank',
                              'src' => $image_path . 'customer-success-story/twiter.png',
                              'content' => '',
                            ),
                          ),
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'color' => '#333333',
                        'mode' => 'horizontal',
                        'font-size' => '13px',
                        'font-weight' => 'normal',
                        'font-style' => 'normal',
                        'font-family' => 'Arial',
                        'border-radius' => '',
                        'padding' => '30px 0px 0px 0px',
                        'inner-padding' => '0px 0px 0px 20px',
                        'line-height' => '1.6',
                        'text-padding' => '4px 4px 4px 0px',
                        'icon-padding' => '0px',
                        'icon-size' => '40px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_divider',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'border-width' => '1px',
                        'border-style' => 'solid',
                        'border-color' => '#D4DFDD',
                        'padding' => '30px 0px 0px 0px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'No longer want to be Mail Mint friends?',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '30px 0px 0px 0px',
                        'align' => 'center',
                        'font-family' => 'Arial',
                        'font-size' => '15px',
                        'line-height' => '1',
                        'color' => '#879391',
                        'font-weight' => '400',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    3 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '12px 25px 0px 25px',
                        'align' => 'center',
                        'font-size' => '15px',
                        'font-family' => 'Arial',
                        'color' => '#879391',
                        'line-height' => '1.42',
                        'font-style' => 'normal',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    4 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<a href="#" target="_blank" style="color: inherit; text-decoration: underline;" tabindex="-1">Update Preference&nbsp;</a> .&nbsp;&nbsp;<a href="#" target="_blank" style="color: inherit; text-decoration: underline;">Unsubscribe</a>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '12px 0px 30px 0px',
                        'align' => 'center',
                        'color' => '#0064FF',
                        'font-family' => 'Arial',
                        'font-size' => '13px',
                        'line-height' => '1.69',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
              ),
            ),
          ),
        ),
        'subTitle' => 'Nice to meet you!',
      );
    }
    if ( !empty( $templates[ 37 ] ) && empty( $templates[ 37 ][ 'json_content' ] ) ){
      $templates[ 37 ]['json_content'] = array (
        'subject' => 'Welcome to Mail Mint email marketing and automation',
        'subTitle' => 'Nice to meet you!',
        'content' => 
        array (
          'type' => 'page',
          'data' => 
          array (
            'value' => 
            array (
              'breakpoint' => '480px',
              'headAttributes' => '',
              'font-size' => '14px',
              'font-weight' => '400',
              'line-height' => '1.7',
              'headStyles' => 
              array (
              ),
              'fonts' => 
              array (
              ),
              'responsive' => true,
              'font-family' => 'Arial',
              'text-color' => '#000000',
            ),
          ),
          'attributes' => 
          array (
            'background-color' => '#efeeea',
            'width' => '600px',
          ),
          'children' => 
          array (
            0 => 
            array (
              'type' => 'advanced_image',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'height' => 'auto',
                'padding' => '20px 0px 20px 0px',
                'src' => $image_path . 'your-logo.png',
                'width' => '142px',
                'container-background-color' => '#fff',
              ),
              'children' => 
              array (
              ),
            ),
            1 => 
            array (
              'type' => 'advanced_wrapper',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#1F1D19',
                'padding' => '0px 0px 0px 0px',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_hero',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#1F1D19',
                    'background-position' => 'center center',
                    'mode' => 'fluid-height',
                    'padding' => '0px 0px 20px 0px',
                    'vertical-align' => 'top',
                    'background-url' => '',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Start pursuing your&nbsp;<span style="word-spacing: normal;">creative goals for the&nbsp;</span><span style="word-spacing: normal;">next year ahead.</span>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '40px 20px 0px 20px',
                        'align' => 'center',
                        'color' => '#fff',
                        'font-size' => '32px',
                        'line-height' => '1.17',
                        'font-family' => 'Arial',
                        'font-weight' => '700',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'What skills or knowledge do you aim to acquire this year?&nbsp;<div>We\'re here to assist you in reaching your goals.</div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'background-color' => '#414141',
                        'color' => '#A1A1A1',
                        'font-weight' => 'normal',
                        'border-radius' => '3px',
                        'padding' => '16px 0px 0px 0px',
                        'inner-padding' => '10px 25px 10px 25px',
                        'line-height' => '1.56',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'href' => '#',
                        'font-size' => '16px',
                        'font-style' => 'normal',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'button',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Get Your Order Here!',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'background-color' => '#F5CA31',
                        'color' => '#060502',
                        'font-size' => '16px',
                        'font-weight' => '600',
                        'border-radius' => '30px',
                        'padding' => '30px 0px 0px 0px',
                        'inner-padding' => '17px 31px 17px 31px',
                        'line-height' => '0.93',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'href' => '#',
                        'font-family' => 'Arial',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    3 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '60px 30px 0px 30px',
                        'src' => $image_path . 'educational-content/hero-img.png',
                        'alt' => 'banner-image',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
              ),
            ),
            2 => 
            array (
              'type' => 'advanced_wrapper',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#EEEDEA',
                'padding' => '40px 23px 20px 25px',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => false,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'padding' => '0px 0px 0px 0px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => 
                        array (
                          0 => '25%',
                          1 => '25%',
                          2 => '25%',
                          3 => '25%',
                        ),
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Need Ideas?',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '40px 0px 0px 0px',
                            'align' => 'center',
                            'color' => '#FFA219',
                            'font-weight' => '700',
                            'font-family' => 'Arial',
                            'font-size' => '14px',
                            'font-style' => 'normal',
                            'line-height' => '1',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Explore the trendiest courses of the year and start shopping now',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 20px 0px 20px',
                            'align' => 'center',
                            'font-family' => 'Arial',
                            'font-size' => '24px',
                            'line-height' => '1.25',
                            'font-weight' => '700',
                            'font-style' => 'normal',
                            'color' => '#0B0F12',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => false,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'padding' => '0px 0px 20px 0px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '50%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => 'auto',
                            'padding' => '40px 24px 0px 24px',
                            'src' => $image_path . 'educational-content/marketing.png',
                            'alt' => 'card-image',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Digital Marketing&nbsp;<div>Mastery</div>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '12px 25px 0px 24px',
                            'align' => 'left',
                            'font-size' => '16px',
                            'font-family' => 'Arial',
                            'font-weight' => '700',
                            'line-height' => '1.31',
                            'color' => '#2B2D38',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        2 => 
                        array (
                          'type' => 'advanced_button',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Explore Now',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'left',
                            'font-family' => 'Arial',
                            'background-color' => '#1F1D19',
                            'color' => '#ffffff',
                            'font-weight' => 'normal',
                            'font-style' => 'normal',
                            'border-radius' => '100px',
                            'padding' => '14px 0px 0px 24px',
                            'inner-padding' => '9px 20px 9px 20px',
                            'font-size' => '13px',
                            'line-height' => '1.2',
                            'target' => '_blank',
                            'vertical-align' => 'middle',
                            'border' => 'none',
                            'text-align' => 'center',
                            'letter-spacing' => 'normal',
                            'href' => '#',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '50%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => 'auto',
                            'padding' => '40px 24px 0px 24px',
                            'src' => $image_path . 'educational-content/design.png',
                            'alt' => 'card-img-2',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Graphic Design Fundamentals<br>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '12px 25px 0px 24px',
                            'align' => 'left',
                            'font-size' => '16px',
                            'font-family' => 'Arial',
                            'font-weight' => '700',
                            'line-height' => '1.31',
                            'color' => '#2B2D38',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        2 => 
                        array (
                          'type' => 'advanced_button',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Explore Now',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'left',
                            'font-family' => 'Arial',
                            'background-color' => '#1F1D19',
                            'color' => '#ffffff',
                            'font-weight' => 'normal',
                            'font-style' => 'normal',
                            'border-radius' => '100px',
                            'padding' => '14px 0px 0px 24px',
                            'inner-padding' => '9px 20px 9px 20px',
                            'font-size' => '13px',
                            'line-height' => '1.2',
                            'target' => '_blank',
                            'vertical-align' => 'middle',
                            'border' => 'none',
                            'text-align' => 'center',
                            'letter-spacing' => 'normal',
                            'href' => '#',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => false,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'padding' => '0px 0px 40px 0px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '50%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => 'auto',
                            'padding' => '40px 24px 0px 24px',
                            'src' => $image_path . 'educational-content/coding.png',
                            'alt' => 'card-img-3',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Machine Learning&nbsp;<div>Basics<br></div>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '12px 25px 0px 24px',
                            'align' => 'left',
                            'font-size' => '16px',
                            'font-family' => 'Arial',
                            'font-weight' => '700',
                            'line-height' => '1.31',
                            'color' => '#2B2D38',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        2 => 
                        array (
                          'type' => 'advanced_button',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Explore Now',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'left',
                            'font-family' => 'Arial',
                            'background-color' => '#1F1D19',
                            'color' => '#ffffff',
                            'font-weight' => 'normal',
                            'font-style' => 'normal',
                            'border-radius' => '100px',
                            'padding' => '14px 0px 0px 24px',
                            'inner-padding' => '9px 20px 9px 20px',
                            'font-size' => '13px',
                            'line-height' => '1.2',
                            'target' => '_blank',
                            'vertical-align' => 'middle',
                            'border' => 'none',
                            'text-align' => 'center',
                            'letter-spacing' => 'normal',
                            'href' => '#',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '50%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => 'auto',
                            'padding' => '40px 24px 0px 24px',
                            'src' => $image_path . 'educational-content/photography.png',
                            'alt' => 'card-img-4',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Photography&nbsp;<div>Masterclass<br></div>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '12px 25px 0px 24px',
                            'align' => 'left',
                            'font-size' => '16px',
                            'font-family' => 'Arial',
                            'font-weight' => '700',
                            'line-height' => '1.31',
                            'color' => '#2B2D38',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        2 => 
                        array (
                          'type' => 'advanced_button',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Explore Now',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'left',
                            'font-family' => 'Arial',
                            'background-color' => '#1F1D19',
                            'color' => '#ffffff',
                            'font-weight' => 'normal',
                            'font-style' => 'normal',
                            'border-radius' => '100px',
                            'padding' => '14px 0px 0px 24px',
                            'inner-padding' => '9px 20px 9px 20px',
                            'font-size' => '13px',
                            'line-height' => '1.2',
                            'target' => '_blank',
                            'vertical-align' => 'middle',
                            'border' => 'none',
                            'text-align' => 'center',
                            'letter-spacing' => 'normal',
                            'href' => '#',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                3 => 
                array (
                  'type' => 'advanced_spacer',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'height' => '20px',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                4 => 
                array (
                  'type' => 'advanced_image',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'height' => 'auto',
                    'padding' => '0px 0px 0px 0px',
                    'src' => $image_path . 'educational-content/footer-img.png',
                    'alt' => 'banner-img-2',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                5 => 
                array (
                  'type' => 'advanced_hero',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#1F1D19',
                    'background-position' => 'center center',
                    'mode' => 'fluid-height',
                    'padding' => '0px 0px 0px 0px',
                    'vertical-align' => 'top',
                    'background-url' => '',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Join now and start learning today!',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '25px 0px 0px 0px',
                        'align' => 'center',
                        'color' => '#FFFFFF',
                        'font-size' => '24px',
                        'line-height' => '1.25',
                        'font-weight' => '700',
                        'font-family' => 'Arial',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'button',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Explore Courses',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'background-color' => '#F5CA31',
                        'color' => '#060502',
                        'font-size' => '16px',
                        'font-weight' => '700',
                        'border-radius' => '30px',
                        'padding' => '10px 25px 46px 25px',
                        'inner-padding' => '17px 31px 17px 31px',
                        'line-height' => '0.93',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'href' => '#',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
              ),
            ),
            3 => 
            array (
              'type' => 'advanced_wrapper',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#ffffff',
                'padding' => '0px 0px 0px 0px',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_social',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'elements' => 
                      array (
                        0 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'educational-content/pinterest.png',
                          'content' => '',
                        ),
                        1 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'educational-content/facebook.png',
                          'content' => '',
                        ),
                        2 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'educational-content/instagram.png',
                          'content' => '',
                        ),
                        3 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . 'educational-content/twiter.png',
                          'content' => '',
                        ),
                      ),
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'color' => '#333333',
                    'mode' => 'horizontal',
                    'font-size' => '13px',
                    'font-weight' => 'normal',
                    'font-style' => 'normal',
                    'font-family' => 'Arial',
                    'border-radius' => '3px',
                    'padding' => '30px 0px 0px 0px',
                    'inner-padding' => '0px 0px 0px 20px',
                    'line-height' => '1.6',
                    'text-padding' => '4px 4px 4px 0px',
                    'icon-padding' => '0px',
                    'icon-size' => '40px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_divider',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'border-width' => '1px',
                    'border-style' => 'solid',
                    'border-color' => '#EDECE9',
                    'padding' => '30px 24px 0px 24px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'No longer want to be Mail Mint friends?',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '40px 25px 0px 25px',
                    'align' => 'center',
                    'font-family' => 'Arial',
                    'font-size' => '15px',
                    'line-height' => '1.46',
                    'color' => '#8F8F8F',
                    'font-weight' => '400',
                    'font-style' => 'normal',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                3 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<a href="{{link.preference}}" target="_blank" style="color: inherit; text-decoration: underline;">Email Preference</a>&nbsp; .&nbsp;&nbsp;<a href="{{link.unsubscribe}}" target="_blank" style="color: inherit; text-decoration: underline;">Unsubscribe</a>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '8px 0px 0px 0px',
                    'align' => 'center',
                    'color' => '#8F8F8F',
                    'font-family' => 'Arial',
                    'font-size' => '15px',
                    'line-height' => '1.46',
                    'font-weight' => '400',
                    'font-style' => 'normal',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                4 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '24px 20px 30px 20px',
                    'align' => 'center',
                    'color' => '#8F8F8F',
                    'font-size' => '15px',
                    'font-family' => 'Arial',
                    'line-height' => '1.57',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
          ),
        ),
      );
    }
    if ( !empty( $templates[ 39 ] ) && empty( $templates[ 39 ][ 'json_content' ] ) ){
      $templates[ 39 ]['json_content'] = array (
        'content' => 
        array (
          'type' => 'page',
          'data' => 
          array (
            'value' => 
            array (
              'breakpoint' => '480px',
              'headAttributes' => '',
              'font-size' => '14px',
              'font-weight' => '400',
              'line-height' => '1.7',
              'headStyles' => 
              array (
              ),
              'fonts' => 
              array (
              ),
              'responsive' => true,
              'font-family' => 'Arial',
              'text-color' => '#000000',
            ),
          ),
          'attributes' => 
          array (
            'background-color' => '#efeeea',
            'width' => '600px',
          ),
          'children' => 
          array (
            0 => 
            array (
              'type' => 'advanced_wrapper',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#E8E1D8',
                'padding' => '20px 24px 20px 24px',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_image',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'height' => 'auto',
                    'padding' => '0px 0px 20px 0px',
                    'src' => $image_path . 'your-logo.png',
                    'width' => '100%',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => true,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#e8e1d8',
                    'padding' => '0px 0px 0px 0px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => '',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                    'border-radius' => '',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'background-color' => '#ffffff',
                        'padding' => '0px 0px 0px 0px',
                        'border' => 'none',
                        'vertical-align' => 'top',
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => '<font color="#f75c42">Heartfelt Thanks</font> for Your Recent Experience!',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '38px 0px 0px 40px',
                            'align' => 'left',
                            'container-background-color' => '#FBF5ED',
                            'font-size' => '30px',
                            'font-weight' => '700',
                            'color' => '#222222',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Dear John Doe,<div><br></div><div>We wanted to take a moment to express our sincere gratitude for choosing Mail Mint. Thank you for your recent purchase/attendance at our event; your support means the world to us.<br></div><div><span style="white-space-collapse: preserve;">Your satisfaction is our top priority, and we hope your experience was nothing short of fantastic.</span><br></div><div><span style="white-space-collapse: preserve;"><br></span></div><div><span style="white-space-collapse: preserve;">To add even more joy to your journey with us, here are some additional product recommendations we think you\'ll love 😊</span><br></div>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '25px 10px 38px 40px',
                            'align' => 'left',
                            'container-background-color' => '#FBF5ED',
                            'color' => '#0B1B1B',
                            'font-size' => '16px',
                            'line-height' => '1.5',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_hero',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'background-position' => 'center center',
                    'mode' => 'fluid-height',
                    'padding' => '38px 40px 23px 40px',
                    'vertical-align' => 'top',
                    'background-url' => '',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<font color="#f75c42">Related</font> Product',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 0px 0px 0px',
                        'align' => 'left',
                        'color' => '#353535',
                        'font-size' => '24px',
                        'font-weight' => '700',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                3 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => true,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'padding' => '0px 40px 30px 40px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '50%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => 'auto',
                            'padding' => '0px 12px 0px 0px',
                            'src' => $image_path . 'seasonal-greetings/product-1.png',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Bags',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 25px 10px 25px',
                            'align' => 'center',
                            'font-size' => '22px',
                            'font-weight' => '700',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '50%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => 'auto',
                            'padding' => '0px 0px 0px 12px',
                            'src' => $image_path . 'seasonal-greetings/product-2.png',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Pouches',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 25px 10px 25px',
                            'align' => 'center',
                            'font-size' => '22px',
                            'font-weight' => '700',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                4 => 
                array (
                  'type' => 'advanced_button',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'View the full Range',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'font-family' => 'Arial',
                    'background-color' => '#414141',
                    'color' => '#ffffff',
                    'font-weight' => '600',
                    'font-style' => 'normal',
                    'border-radius' => '30px',
                    'padding' => '0px 0px 38px 00px',
                    'inner-padding' => '17px 30px 17px 30px',
                    'font-size' => '15px',
                    'line-height' => '1.2',
                    'target' => '_blank',
                    'vertical-align' => 'middle',
                    'border' => 'none',
                    'text-align' => 'center',
                    'letter-spacing' => 'normal',
                    'href' => '#',
                    'container-background-color' => '#FFFFFF',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                5 => 
                array (
                  'type' => 'advanced_spacer',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'height' => '24px',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                6 => 
                array (
                  'type' => 'advanced_hero',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#222222',
                    'background-position' => 'center center',
                    'mode' => 'fluid-height',
                    'padding' => '40px 40px 40px 40px',
                    'vertical-align' => 'top',
                    'background-url' => '',
                    'border-radius' => '20px',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'We love&nbsp;<font color="#f75c42">feedback!</font>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 0px 10px 0px',
                        'align' => 'left',
                        'color' => '#FFFFFF',
                        'font-size' => '24px',
                        'font-weight' => '700',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Additionally, we value your feedback, and it would mean a lot to us if you could take a moment to share your thoughts. Your insights are essential in helping us improve and continue to meet your expectations.<div><br></div><div>Please click on the link below to provide your feedback:<br></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 0px 10px 0px',
                        'align' => 'left',
                        'color' => '#FFFFFF',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_button',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Feedback Survey',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'font-family' => 'Arial',
                        'background-color' => '#F75C42',
                        'color' => '#ffffff',
                        'font-weight' => '600',
                        'font-style' => 'normal',
                        'border-radius' => '30px',
                        'padding' => '20px 0px 10px 0px',
                        'inner-padding' => '17px 34px 17px 34px',
                        'font-size' => '15px',
                        'line-height' => '1.2',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'letter-spacing' => 'normal',
                        'href' => '#',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                7 => 
                array (
                  'type' => 'advanced_spacer',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'height' => '24px',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                8 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => true,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'padding' => '20px 0px 20px 0px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                    'border-radius' => '20px',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '33.33%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => '36px',
                            'padding' => '0px 0px 0px 0px',
                            'src' => $image_path . 'seasonal-greetings/question.png',
                            'width' => '36px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => '<a href="#" target="_blank" style="color: inherit; text-decoration: underline;">Helps</a>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 25px 10px 25px',
                            'align' => 'center',
                            'font-size' => '16px',
                            'font-weight' => '700',
                            'color' => '#222222',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '33.33%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => '36px',
                            'padding' => '0px 0px 0px 0px',
                            'src' => $image_path . 'seasonal-greetings/message.png',
                            'width' => '36px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => '<a href="#" target="_blank" style="color: inherit; text-decoration: underline;">Contact</a>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 25px 10px 25px',
                            'align' => 'center',
                            'font-size' => '16px',
                            'font-weight' => '700',
                            'color' => '#222222',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '33.33%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => '36px',
                            'padding' => '0px 0px 0px 0px',
                            'src' => $image_path . 'seasonal-greetings/phone.png',
                            'width' => '36px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => '<a href="#" target="_blank" style="color: inherit; text-decoration: underline;">2.999.000.6743</a>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 25px 10px 25px',
                            'align' => 'center',
                            'font-size' => '16px',
                            'font-weight' => '700',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                9 => 
                array (
                  'type' => 'advanced_social',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'elements' => 
                      array (
                        0 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . $pinterest,
                          'content' => '',
                        ),
                        1 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . $facebook,
                          'content' => '',
                        ),
                        2 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . $instagram,
                          'content' => '',
                        ),
                        3 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . $twitter,
                          'content' => '',
                        ),
                      ),
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'color' => '#333333',
                    'mode' => 'horizontal',
                    'font-size' => '13px',
                    'font-weight' => 'normal',
                    'font-style' => 'normal',
                    'font-family' => 'Arial',
                    'border-radius' => '3px',
                    'padding' => '30px 0px 30px 0px',
                    'inner-padding' => '0px 20px 0px 0px',
                    'line-height' => '1.6',
                    'text-padding' => '4px 4px 4px 0px',
                    'icon-padding' => '0px',
                    'icon-size' => '40px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                10 => 
                array (
                  'type' => 'advanced_divider',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'border-width' => '1px',
                    'border-style' => 'solid',
                    'border-color' => '#D2C9BE',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                11 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'No longer want to be Mail Mint friends?',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '40px 25px 8px 25px',
                    'align' => 'center',
                    'font-size' => '15px',
                    'color' => '#666666',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                12 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<a href="{{link.preference}}" target="_blank" style="color: inherit; text-decoration: underline;">Email Preference</a>&nbsp;.&nbsp;<a href="{{link.unsubscribe}}" target="_blank" style="color: inherit; text-decoration: underline;">Unsubscribe</a>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '0px 25px 24px 25px',
                    'align' => 'center',
                    'color' => '#666666',
                    'font-size' => '15px',
                    'font-weight' => '500',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                13 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '10px 0px 10px 0px',
                    'align' => 'center',
                    'font-size' => '14px',
                    'color' => '#666666',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
          ),
        ),
        'subTitle' => 'Nice to meet you!',
      );
    }
    if ( !empty( $templates[ 42 ] ) && empty( $templates[ 42 ][ 'json_content' ] ) ){
      $templates[ 42 ]['json_content'] = array (
        'subject' => 'Welcome to Mail Mint email marketing and automation',
        'subTitle' => 'Nice to meet you!',
        'content' => 
        array (
          'type' => 'page',
          'data' => 
          array (
            'value' => 
            array (
              'breakpoint' => '480px',
              'headAttributes' => '',
              'font-size' => '14px',
              'font-weight' => '400',
              'line-height' => '1.7',
              'headStyles' => 
              array (
              ),
              'fonts' => 
              array (
              ),
              'responsive' => true,
              'font-family' => 'Arial',
              'text-color' => '#000000',
            ),
          ),
          'attributes' => 
          array (
            'background-color' => '#efeeea',
            'width' => '600px',
          ),
          'children' => 
          array (
            0 => 
            array (
              'type' => 'advanced_image',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'height' => 'auto',
                'padding' => '20px 0px 20px 0px',
                'src' => $image_path . 'your-logo.png',
                'width' => '100%',
                'container-background-color' => '#FFFFFF',
                'alt' => 'Logo',
              ),
              'children' => 
              array (
              ),
            ),
            1 => 
            array (
              'type' => 'advanced_hero',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#ffffff',
                'background-position' => 'center center',
                'mode' => 'fluid-height',
                'padding' => '50px 10px 50px 10px',
                'vertical-align' => 'top',
                'background-url' => $image_path . 'hero-bg-harmony.png',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => "A Lot Has Changed Since You've Been Gone",
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '0px 0px 0px 0px',
                    'align' => 'center',
                    'color' => '#FFFFFF',
                    'font-size' => '50px',
                    'line-height' => '58px',
                    'font-weight' => '900',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
            2 => 
            array (
              'type' => 'advanced_wrapper',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#000000',
                'padding' => '24px 24px 24px 24px',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_hero',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#181818',
                    'background-position' => 'center center',
                    'mode' => 'fluid-height',
                    'padding' => '0px 0px 0px 0px',
                    'vertical-align' => 'top',
                    'background-url' => '',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Hey there,',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '50px 0px 20px 0px',
                        'align' => 'center',
                        'color' => '#FFFFFF',
                        'font-size' => '26px',
                        'line-height' => '24px',
                        'font-weight' => '700',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<font color="#8e7fec">Save 20%</font> on your next order when you check out our new brands, new services and our new look and feel to our website',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'background-color' => '#414141',
                        'color' => '#E4E3E3',
                        'font-weight' => 'normal',
                        'border-radius' => '3px',
                        'padding' => '0px 10px 40px 10px',
                        'inner-padding' => '10px 25px 10px 25px',
                        'line-height' => '26px',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'href' => '#',
                        'font-size' => '16px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Use code: <font color="#8e7fec">45678903</font>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'background-color' => '#414141',
                        'color' => '#9D9DB7',
                        'font-weight' => 'normal',
                        'border-radius' => '3px',
                        'padding' => '0px 10px 40px 10px',
                        'inner-padding' => '10px 25px 10px 25px',
                        'line-height' => '20px',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'href' => '#',
                        'font-size' => '20px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    3 => 
                    array (
                      'type' => 'button',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Try Something new',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'background-color' => '#8E7FEC',
                        'color' => '#161616',
                        'font-size' => '15px',
                        'font-weight' => '600',
                        'border-radius' => '30px',
                        'padding' => '0px 0px 0px 0px',
                        'inner-padding' => '17px 30px 17px 30px',
                        'line-height' => '1',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'href' => '#',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    4 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Hurry! this offer ends&nbsp;<div>Friday, December 10th, 2024 - 9:30 PM. PST</div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '28px 10px 22px 10px',
                        'align' => 'center',
                        'font-size' => '16px',
                        'line-height' => '26px',
                        'color' => '#E4E3E3',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    5 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '0px 0px 40px 0px',
                        'src' => $image_path . 'furnichar.png',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                1 => 
                array (
                  'attributes' => 
                  array (
                    'padding' => '0px 0px 0px 0px',
                  ),
                ),
              ),
            ),
            3 => 
            array (
              'type' => 'advanced_text',
              'data' => 
              array (
                'value' => 
                array (
                  'content' => 'Need Help? Ask <font color="#8e7fec"><b><a href="#" target="_blank" style="color: inherit; text-decoration: underline;">Customer Support</a></b></font>',
                ),
              ),
              'attributes' => 
              array (
                'padding' => '30px 24px 0px 24px',
                'align' => 'center',
                'font-size' => '16px',
                'line-height' => '16px',
                'color' => '#D2D2D2',
                'container-background-color' => '#000000',
              ),
              'children' => 
              array (
              ),
            ),
            4 => 
            array (
              'type' => 'advanced_divider',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'border-width' => '1px',
                'border-style' => 'solid',
                'border-color' => '#292929',
                'padding' => '25px 24px 10px 24px',
                'container-background-color' => '#000000',
              ),
              'children' => 
              array (
              ),
            ),
            5 => 
            array (
              'type' => 'advanced_social',
              'data' => 
              array (
                'value' => 
                array (
                  'elements' => 
                  array (
                    0 => 
                    array (
                      'href' => '#',
                      'target' => '_blank',
                      'src' => $image_path . 'pinterest-1.png',
                      'content' => '',
                    ),
                    1 => 
                    array (
                      'href' => '#',
                      'target' => '_blank',
                      'src' => $image_path . 'facebook-1.png',
                      'content' => '',
                    ),
                    2 => 
                    array (
                      'href' => '#',
                      'target' => '_blank',
                      'src' => $image_path . 'instagram-1.png',
                      'content' => '',
                    ),
                    3 => 
                    array (
                      'href' => '#',
                      'target' => '_blank',
                      'src' => $image_path . 'twitter-1.png',
                      'content' => '',
                    ),
                  ),
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'color' => '#333333',
                'mode' => 'horizontal',
                'font-size' => '13px',
                'font-weight' => 'normal',
                'font-style' => 'normal',
                'font-family' => 'Arial',
                'border-radius' => '3px',
                'padding' => '30px 0px 30px 0px',
                'inner-padding' => '0px 20px 0px 0px',
                'line-height' => '1.6',
                'text-padding' => '4px 4px 4px 0px',
                'icon-padding' => '0px',
                'icon-size' => '40px',
                'container-background-color' => '#000000',
              ),
              'children' => 
              array (
              ),
            ),
            6 => 
            array (
              'type' => 'advanced_divider',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'border-width' => '1px',
                'border-style' => 'solid',
                'border-color' => '#292929',
                'padding' => '0px 24px 40px 24px',
                'container-background-color' => '#000000',
              ),
              'children' => 
              array (
              ),
            ),
            7 => 
            array (
              'type' => 'advanced_text',
              'data' => 
              array (
                'value' => 
                array (
                  'content' => 'No longer want to be Mail Mint friends?',
                ),
              ),
              'attributes' => 
              array (
                'padding' => '0px 10px 8px 10px',
                'align' => 'center',
                'font-size' => '15px',
                'line-height' => '22px',
                'color' => '#A4A4A4',
                'container-background-color' => '#000000',
              ),
              'children' => 
              array (
              ),
            ),
            8 => 
            array (
              'type' => 'advanced_text',
              'data' => 
              array (
                'value' => 
                array (
                  'content' => '<a href="{{link.preference}}" target="_blank" style="color: inherit; text-decoration: underline;">Email Preference</a>&nbsp;.&nbsp;<a href="{{link.unsubscribe}}" target="_blank" style="color: inherit; text-decoration: underline;">Unsubscribe</a>',
                ),
              ),
              'attributes' => 
              array (
                'padding' => '0px 10px 24px 10px',
                'align' => 'center',
                'font-size' => '15px',
                'line-height' => '22px',
                'color' => '#A4A4A4',
                'container-background-color' => '#000000',
              ),
              'children' => 
              array (
              ),
            ),
            9 => 
            array (
              'type' => 'advanced_text',
              'data' => 
              array (
                'value' => 
                array (
                  'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
                ),
              ),
              'attributes' => 
              array (
                'padding' => '0px 10px 30px 10px',
                'align' => 'center',
                'font-size' => '15px',
                'line-height' => '22px',
                'color' => '#A4A4A4',
                'container-background-color' => '#000000',
              ),
              'children' => 
              array (
              ),
            ),
          ),
        ),
      );
    }
    if ( !empty( $templates[ 40 ] ) && empty( $templates[ 40 ][ 'json_content' ] ) ){
      $templates[ 40 ]['json_content'] = array (
        'content' => 
        array (
          'type' => 'page',
          'data' => 
          array (
            'value' => 
            array (
              'breakpoint' => '480px',
              'headAttributes' => '',
              'font-size' => '14px',
              'font-weight' => '400',
              'line-height' => '1.7',
              'headStyles' => 
              array (
              ),
              'fonts' => 
              array (
              ),
              'responsive' => true,
              'font-family' => 'Arial',
              'text-color' => '#000000',
            ),
          ),
          'attributes' => 
          array (
            'background-color' => '#efeeea',
            'width' => '600px',
          ),
          'children' => 
          array (
            0 => 
            array (
              'type' => 'advanced_image',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'height' => 'auto',
                'padding' => '20px 0px 20px 0px',
                'src' => $image_path . 'your-logo.png',
                'width' => '100%',
                'container-background-color' => '#fff',
                'alt' => 'Logo',
              ),
              'children' => 
              array (
              ),
            ),
            1 => 
            array (
              'type' => 'advanced_wrapper',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#0F0740',
                'padding' => '0px 0px 0px 0px',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_hero',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#261B5C',
                    'background-position' => 'center center',
                    'mode' => 'fluid-height',
                    'padding' => '0px 0px 0px 0px',
                    'vertical-align' => 'top',
                    'background-url' => '',
                    'border-radius' => '10px',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '🌟 Your Personalized Product Picks&nbsp;<div>Just For You! 🌟</div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '40px 0px 0px 0px',
                        'align' => 'center',
                        'color' => '#ffff',
                        'font-size' => '30px',
                        'line-height' => '1.2',
                        'font-family' => 'Arial',
                        'font-weight' => '700',
                        'font-style' => 'normal',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Boost your sales with personalized product recommendation emails for your most engaged customers. Here\'s a collection of eight examples to spark your inspiration!&nbsp;<br>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'background-color' => '#414141',
                        'color' => '#FFFFFFCC',
                        'font-weight' => 'normal',
                        'border-radius' => '3px',
                        'padding' => '16px 20px 40px 20px',
                        'inner-padding' => '10px 25px 10px 25px',
                        'line-height' => '1.55',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'href' => '#',
                        'font-size' => '18px',
                        'font-style' => 'normal',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
              ),
            ),
            2 => 
            array (
              'type' => 'advanced_wrapper',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#ffffff',
                'padding' => '0px 0px 0px 0px',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => false,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'padding' => '44px 0px 0px 24px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '33%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => 'auto',
                            'padding' => '10px 0px 10px 0px',
                            'src' => $image_path . 'recommendation/fitnes.png',
                            'border-radius' => '10px',
                            'width' => '',
                            'alt' => 'Complete Guide',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '67%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'SmartTech Fitness Tracker',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 0px 0px 26px',
                            'align' => 'left',
                            'color' => '#0B0F12',
                            'font-weight' => '700',
                            'font-size' => '18px',
                            'line-height' => '1.44',
                            'font-style' => 'normal',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Unleash your potential with our SmartTech Fitness Tracker - the perfect blend of style and health monitoring for an active lifestyle.&nbsp;<br>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '14px 0px 0px 26px',
                            'align' => 'left',
                            'line-height' => '1.56',
                            'font-size' => '16px',
                            'font-weight' => '400',
                            'font-style' => 'normal',
                            'color' => '#737373',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        2 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => '$45.00',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '0px 0px 10px 25px',
                            'align' => 'left',
                            'font-size' => '16px',
                            'font-weight' => '700',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        3 => 
                        array (
                          'type' => 'advanced_button',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Read More',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'left',
                            'font-family' => 'Arial',
                            'background-color' => '#573BFF',
                            'color' => '#ffffff',
                            'font-weight' => 'normal',
                            'font-style' => 'normal',
                            'border-radius' => '100px',
                            'padding' => '0px 25px 10px 26px',
                            'inner-padding' => '10px 25px 10px 25px',
                            'font-size' => '13px',
                            'line-height' => '1.15',
                            'target' => '_blank',
                            'vertical-align' => 'middle',
                            'border' => 'none',
                            'text-align' => 'center',
                            'letter-spacing' => 'normal',
                            'href' => '#',
                            'width' => '',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => false,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'padding' => '44px 24px 0px 0px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '67%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Smart Water Bottles<br>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 0px 0px 40px',
                            'align' => 'left',
                            'font-size' => '18px',
                            'font-weight' => '700',
                            'line-height' => '1.44',
                            'color' => '#0B0F12',
                            'font-style' => 'normal',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'The HidrateZ Smart Water Bottle, one of the first of its kind, links up with an app to remind you to drink enough water every day.<br>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '14px 26px 10px 40px',
                            'align' => 'left',
                            'color' => '#737373',
                            'font-size' => '16px',
                            'line-height' => '1.56',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        2 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => '$75.00',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '0px 0px 10px 40px',
                            'align' => 'left',
                            'color' => '#0B0F12',
                            'font-weight' => '700',
                            'font-size' => '16px',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        3 => 
                        array (
                          'type' => 'advanced_button',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Read More',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'left',
                            'font-family' => 'Arial',
                            'background-color' => '#573BFF',
                            'color' => '#ffffff',
                            'font-weight' => 'normal',
                            'font-style' => 'normal',
                            'border-radius' => '100px',
                            'padding' => '10px 0px 10px 30px',
                            'inner-padding' => '10px 25px 10px 25px',
                            'font-size' => '13px',
                            'line-height' => '1.15',
                            'target' => '_blank',
                            'vertical-align' => 'middle',
                            'border' => 'none',
                            'text-align' => 'center',
                            'letter-spacing' => 'normal',
                            'href' => '#',
                            'width' => '',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '33%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => 'auto',
                            'padding' => '10px 0px 10px 0px',
                            'src' => $image_path . 'recommendation/smart.png',
                            'border-radius' => '10px',
                            'width' => '',
                            'alt' => 'Product Update',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => false,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'padding' => '44px 0px 0px 24px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '33%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'center',
                            'height' => 'auto',
                            'padding' => '10px 0px 10px 0px',
                            'src' => $image_path . 'recommendation/clozy-sleep.png',
                            'border-radius' => '10px',
                            'width' => '',
                            'alt' => 'Email Marketing',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '67%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'CozyCloud Memory Foam Pillow',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 57px 0px 26px',
                            'align' => 'left',
                            'color' => '#0B0F12',
                            'font-weight' => '700',
                            'font-size' => '18px',
                            'line-height' => '1.44',
                            'font-style' => 'normal',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Enhance your sleep sanctuary with our CozyCloud Memory Foam Pillow, meticulously designed for optimal support and peaceful sleep.<br>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '14px 57px 0px 26px',
                            'align' => 'left',
                            'line-height' => '1.56',
                            'font-size' => '16px',
                            'font-weight' => '400',
                            'font-style' => 'normal',
                            'color' => '#737373',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        2 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => '$45.00',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '0px 25px 10px 25px',
                            'align' => 'left',
                            'font-size' => '16px',
                            'font-weight' => '700',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        3 => 
                        array (
                          'type' => 'advanced_button',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Read More',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'left',
                            'font-family' => 'Arial',
                            'background-color' => '#573BFF',
                            'color' => '#ffffff',
                            'font-weight' => 'normal',
                            'font-style' => 'normal',
                            'border-radius' => '100px',
                            'padding' => '0px 25px 20px 26px',
                            'inner-padding' => '10px 25px 10px 25px',
                            'font-size' => '13px',
                            'line-height' => '1.15',
                            'target' => '_blank',
                            'vertical-align' => 'middle',
                            'border' => 'none',
                            'text-align' => 'center',
                            'letter-spacing' => 'normal',
                            'href' => '#',
                            'width' => '',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                )
              ),
            ),
            3 => 
            array (
              'attributes' => 
              array (
                'padding' => '0px 0px 0px 0px',
              ),
            ),
            4 => 
            array (
              'type' => 'advanced_wrapper',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#0F0740',
                'padding' => '0px 0px 0px 0px',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_social',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'elements' => 
                      array (
                        0 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . $pinterest,
                          'content' => '',
                        ),
                        1 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . $facebook,
                          'content' => '',
                        ),
                        2 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . $instagram,
                          'content' => '',
                        ),
                        3 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . $twitter,
                          'content' => '',
                        ),
                      ),
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'color' => '#333333',
                    'mode' => 'horizontal',
                    'font-size' => '13px',
                    'font-weight' => 'normal',
                    'font-style' => 'normal',
                    'font-family' => 'Arial',
                    'border-radius' => '3px',
                    'padding' => '30px 0px 0 0px',
                    'inner-padding' => '0px 0px 0px 20px',
                    'line-height' => '1.6',
                    'text-padding' => '0px 0px 0px 0px',
                    'icon-padding' => '0px',
                    'icon-size' => '40px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_divider',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'border-width' => '2px',
                    'border-style' => 'solid',
                    'border-color' => '#2D2368',
                    'padding' => '30px 24px 40px 24px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'No longer want to be Mail Mint friends?',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '0px 0px 0px 0px',
                    'align' => 'center',
                    'color' => '#928AC1',
                    'font-size' => '15px',
                    'line-height' => '1.46',
                    'font-weight' => '400',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                3 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<a href="{{link.preference}}">Email Preference</a>&nbsp; .&nbsp; <a href="{{link.unsubscribe}}">Unsubscribe</a>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '8px 0px 0px 0px',
                    'align' => 'center',
                    'color' => '#928AC1',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                4 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '24px 0px 40px 0px',
                    'align' => 'center',
                    'color' => '#928AC1',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
          ),
        ),
        'subTitle' => 'Nice to meet you!',
      );
    }
    if ( !empty( $templates[ 38 ] ) && empty( $templates[ 38 ][ 'json_content' ] ) ){
      $templates[ 38 ]['json_content'] = array (
        'subject' => 'Welcome to Mail Mint email marketing and automation',
        'subTitle' => 'Nice to meet you!',
        'content' => 
        array (
          'type' => 'page',
          'data' => 
          array (
            'value' => 
            array (
              'breakpoint' => '480px',
              'headAttributes' => '',
              'font-size' => '14px',
              'font-weight' => '400',
              'line-height' => '1.7',
              'headStyles' => 
              array (
              ),
              'fonts' => 
              array (
              ),
              'responsive' => true,
              'font-family' => 'Arial',
              'text-color' => '#000000',
            ),
          ),
          'attributes' => 
          array (
            'background-color' => '#efeeea',
            'width' => '600px',
          ),
          'children' => 
          array (
            0 => 
            array (
              'type' => 'advanced_image',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'height' => 'auto',
                'padding' => '20px 0px 20px 0px',
                'src' => $image_path . 'your-logo.png',
                'width' => '142px',
                'container-background-color' => '#fff',
                'alt' => 'logo',
              ),
              'children' => 
              array (
              ),
            ),
            1 => 
            array (
              'type' => 'advanced_wrapper',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#0E1D3F',
                'padding' => '0px 24px 0px 24px',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'Email Camp Alert!',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '40px 0px 0px 20px',
                    'align' => 'left',
                    'color' => '#F5CA31',
                    'font-style' => 'normal',
                    'font-size' => '36px',
                    'line-height' => '1.11',
                    'font-weight' => '800',
                    'font-family' => 'Arial',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'We\'re gearing up for something special and we want you to be part of it! 🚀
      Introducing our exclusive Email Camp – a unique opportunity to elevate your email marketing game.&nbsp;<div>We also arranged a special contest for the email marketers and we\'re going to give the winners something special during the camp!&nbsp;</div><div>Whether you\'re a seasoned pro or just starting out, this camp is designed to enhance your skills, boost engagement, and take your campaigns to the next<span style="word-spacing: normal;">&nbsp;level.</span></div><div><span style="word-spacing: normal;">Ready to embark on this journey with us? Secure your spot now and let\'s make your emails stand out!</span></div>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '16px 20px 0px 20px',
                    'align' => 'left',
                    'color' => '#E4E4E4',
                    'font-size' => '16px',
                    'line-height' => '1.56',
                    'font-style' => 'normal',
                    'font-weight' => '400',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_button',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'Register For The Camp',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'font-family' => 'Arial',
                    'background-color' => '#F5CA31',
                    'color' => '#0E1D3F',
                    'font-weight' => '600',
                    'font-style' => 'normal',
                    'border-radius' => '100px',
                    'padding' => '40px 0px 40px 0px',
                    'inner-padding' => '18px 30px 18px 30px',
                    'font-size' => '16px',
                    'line-height' => '0.93',
                    'target' => '_blank',
                    'vertical-align' => 'middle',
                    'border' => 'none',
                    'text-align' => 'center',
                    'letter-spacing' => 'normal',
                    'href' => '#',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                3 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => false,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'padding' => '0px 0px 20px 0px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                    'border-radius' => '10px',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '33%',
                        'padding' => '0px 0px 0px 0px',
                        'background-url' => $image_path . 'campaign-alert/footer-bg.png',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'left',
                            'height' => 'auto',
                            'padding' => '26px 0px 0px 15px',
                            'src' => $image_path . 'campaign-alert/1.png',
                            'width' => '',
                            'border-radius' => '10px',
                            'alt' => 'metting',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '67%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Why is the training spread&nbsp;<span style="word-spacing: normal;">over two days?</span>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '26px 5px 0px 20px',
                            'align' => 'left',
                            'font-size' => '20px',
                            'font-weight' => '700',
                            'line-height' => '1.20',
                            'font-family' => 'Arial',
                            'color' => '#0B0F12',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'The agenda is designed to focus on specific aspects — October 4 for email marketing and quiz session and October 5 for email development. You can choose to register for one day or opt for both.',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 10px 10px 20px',
                            'align' => 'left',
                            'color' => '#8F8F8F',
                            'font-family' => 'Arial',
                            'font-size' => '16px',
                            'line-height' => '1.56',
                            'font-weight' => '400',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                4 => 
                array (
                  'type' => 'advanced_spacer',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'height' => '20px',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                5 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => false,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'padding' => '0px 0px 20px 0px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                    'border-radius' => '10px',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '33%',
                        'padding' => '0px 0px 0px 0px',
                        'background-url' => '',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'left',
                            'height' => 'auto',
                            'padding' => '26px 0px 0px 15px',
                            'src' => $image_path . 'campaign-alert/2.png',
                            'width' => '',
                            'border-radius' => '10px',
                            'alt' => 'meeting',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '67%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'How Can I Join the Competition?<br>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '26px 5px 0px 20px',
                            'align' => 'left',
                            'font-size' => '20px',
                            'font-weight' => '700',
                            'line-height' => '1.20',
                            'font-family' => 'Arial',
                            'color' => '#0B0F12',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'The Competition will take place during the camp. You can register and participate right away for the special prize.',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 10px 10px 20px',
                            'align' => 'left',
                            'color' => '#8F8F8F',
                            'font-family' => 'Arial',
                            'font-size' => '16px',
                            'line-height' => '1.56',
                            'font-weight' => '400',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                6 => 
                array (
                  'type' => 'advanced_spacer',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'height' => '20px',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                7 => 
                array (
                  'type' => 'advanced_section',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'noWrap' => false,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'padding' => '0px 0px 20px 0px',
                    'background-repeat' => 'repeat',
                    'background-size' => 'auto',
                    'background-position' => 'top center',
                    'border' => 'none',
                    'direction' => 'ltr',
                    'text-align' => 'center',
                    'border-radius' => '10px',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '33%',
                        'padding' => '0px 0px 0px 0px',
                        'background-url' => '',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_image',
                          'data' => 
                          array (
                            'value' => 
                            array (
                            ),
                          ),
                          'attributes' => 
                          array (
                            'align' => 'left',
                            'height' => 'auto',
                            'padding' => '26px 0px 0px 15px',
                            'src' => $image_path . 'campaign-alert/3.png',
                            'width' => '',
                            'border-radius' => '10px',
                            'alt' => 'cyber',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_column',
                      'attributes' => 
                      array (
                        'width' => '67%',
                        'padding' => '0px 0px 0px 0px',
                      ),
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'children' => 
                      array (
                        0 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'What are the benefits of registering?<br>',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '26px 5px 0px 20px',
                            'align' => 'left',
                            'font-size' => '20px',
                            'font-weight' => '700',
                            'line-height' => '1.20',
                            'font-family' => 'Arial',
                            'color' => '#0B0F12',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                        1 => 
                        array (
                          'type' => 'advanced_text',
                          'data' => 
                          array (
                            'value' => 
                            array (
                              'content' => 'Register for exclusive access to both days, on-demandcontent, exciting prizes and an enriching experience.',
                            ),
                          ),
                          'attributes' => 
                          array (
                            'padding' => '10px 10px 10px 20px',
                            'align' => 'left',
                            'color' => '#8F8F8F',
                            'font-family' => 'Arial',
                            'font-size' => '16px',
                            'line-height' => '1.56',
                            'font-weight' => '400',
                          ),
                          'children' => 
                          array (
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                8 => 
                array (
                  'type' => 'advanced_button',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'Register Now',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'font-family' => 'Arial',
                    'background-color' => '#F5CA31',
                    'color' => '#0E1D3F',
                    'font-weight' => '600',
                    'font-style' => 'normal',
                    'border-radius' => '100px',
                    'padding' => '40px 0px 40px 0px',
                    'inner-padding' => '18px 41px 18px 42px',
                    'font-size' => '16px',
                    'line-height' => '0.93',
                    'target' => '_blank',
                    'vertical-align' => 'middle',
                    'border' => 'none',
                    'text-align' => 'center',
                    'letter-spacing' => 'normal',
                    'href' => '#',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
            2 => 
            array (
              'type' => 'advanced_wrapper',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#061435',
                'padding' => '40px 24px 40px 24px',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_hero',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'background-color' => '#ffffff',
                    'background-position' => 'center center',
                    'mode' => 'fluid-height',
                    'padding' => '0px 0px 0px 0px',
                    'vertical-align' => 'top',
                    'background-url' => $image_path . 'campaign-alert/footer-bg.png',
                    'border-radius' => '20px',
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Want To Give Us Feedback?',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '40px 0px 0px 0px',
                        'align' => 'center',
                        'color' => '#fff',
                        'font-size' => '30px',
                        'line-height' => '1',
                        'font-family' => 'Arial',
                        'font-weight' => '800',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'button',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => 'Contact Us',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'background-color' => '#FFFFFF',
                        'color' => '#0E1D3F',
                        'font-size' => '16px',
                        'font-weight' => '600',
                        'border-radius' => '30px',
                        'padding' => '20px 0px 40px 0px',
                        'inner-padding' => '18px 40px 18px 40px',
                        'line-height' => '0.93',
                        'target' => '_blank',
                        'vertical-align' => 'middle',
                        'border' => 'none',
                        'text-align' => 'center',
                        'href' => '#',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
              ),
            ),
            3 => 
            array (
              'type' => 'advanced_wrapper',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#ffffff',
                'padding' => '0px 0px 0px 0px',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_social',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'elements' => 
                      array (
                        0 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . $pinterest,
                          'content' => '',
                        ),
                        1 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . $facebook,
                          'content' => '',
                        ),
                        2 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . $instagram,
                          'content' => '',
                        ),
                        3 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . $twitter,
                          'content' => '',
                        ),
                      ),
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'color' => '#333333',
                    'mode' => 'horizontal',
                    'font-size' => '13px',
                    'font-weight' => 'normal',
                    'font-style' => 'normal',
                    'font-family' => 'Arial',
                    'border-radius' => '3px',
                    'padding' => '30px 0px 0px 0px',
                    'inner-padding' => '0px 0px 0px 20px',
                    'line-height' => '1.6',
                    'text-padding' => '4px 4px 4px 0px',
                    'icon-padding' => '0px',
                    'icon-size' => '40px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_divider',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'border-width' => '1px',
                    'border-style' => 'solid',
                    'border-color' => '#DADFEA',
                    'padding' => '40px 24px 0px 24px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'No longer want to be Mail Mint friends?',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '40px 0px 0px 0px',
                    'align' => 'center',
                    'color' => '#5C6A89',
                    'font-size' => '15px',
                    'font-family' => 'Arial',
                    'line-height' => '1.46',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                3 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<a href="{{link.preference}}" target="_blank" style="color: inherit; text-decoration: underline;">Email Preference</a> .&nbsp;<a href="{{link.unsubscribe}}" target="_blank" style="color: inherit; text-decoration: underline;">Unsubscribe</a>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '8px 0px 0px 0px',
                    'align' => 'center',
                    'font-size' => '15px',
                    'font-family' => 'Arial',
                    'color' => '#5C6A89',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                4 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '© '.date("Y") . ', ' . $busi_name .', '. $address,
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '24px 0px 30px 0px',
                    'align' => 'center',
                    'color' => '#5C6A89',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
          ),
        ),
      );
    }
    if ( !empty( $templates[ 45 ] ) && empty( $templates[ 45 ][ 'json_content' ] ) ){
      $templates[ 45 ]['json_content'] = array (
        'subject' => 'Welcome to Mail Mint email marketing and automation',
        'subTitle' => 'Nice to meet you!',
        'content' => 
        array (
          'type' => 'page',
          'data' => 
          array (
            'value' => 
            array (
              'breakpoint' => '480px',
              'headAttributes' => '',
              'font-size' => '14px',
              'font-weight' => '400',
              'line-height' => '1.7',
              'headStyles' => 
              array (
              ),
              'fonts' => 
              array (
              ),
              'responsive' => true,
              'font-family' => 'Arial',
              'text-color' => '#000000',
            ),
          ),
          'attributes' => 
          array (
            'background-color' => '#efeeea',
            'width' => '600px',
          ),
          'children' => 
          array (
            0 => 
            array (
              'type' => 'advanced_image',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'height' => 'auto',
                'padding' => '0px 0px 0px 0px',
                 'src' => $image_path . 'abandoned-cart-4/hero.png',
                'width' => '',
              ),
              'children' => 
              array (
              ),
            ),
            1 => 
            array (
              'type' => 'advanced_image',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'height' => 'auto',
                'padding' => '0px 0px 0px 0px',
                'src' => $image_path . 'abandoned-cart-4/free-shipping.jpeg',
              ),
              'children' => 
              array (
              ),
            ),
            2 => 
            array (
              'type' => 'advanced_image',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'height' => 'auto',
                'padding' => '0px 0px 0px 0px',
                'src' => $image_path . 'hero.jpeg',
              ),
              'children' => 
              array (
              ),
            ),
            3 => 
            array (
              'type' => 'advanced_text',
              'data' => 
              array (
                'value' => 
                array (
                  'content' => '<div style="text-align: center;"><h4 style="--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff)); letter-spacing: 0px; font-family: freight-big-pro, Georgia, serif; font-size: 22px; font-weight: normal; line-height: 1.1; margin: 0px 0px 12px;"><span style="--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff)); font-size: 18px;">&nbsp;</span><span style="--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff)); color: rgb(255, 255, 255);"><span style="--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff)); font-size: 18px;">&nbsp;</span></span>Hi Jhon Due, we saw you left some items in your cart.</h4><h4 style="letter-spacing: 0px; font-family: freight-big-pro, Georgia, serif; font-size: 22px; font-weight: normal; line-height: 1.1; margin: 0px 0px 12px;">Luckily, we’ve held onto them for you.&nbsp;</h4><div><h4 style="letter-spacing: 0px; font-family: freight-big-pro, Georgia, serif; font-size: 22px; font-weight: normal; line-height: 1.1; margin: 0px 0px 12px;">Make sure you snag them&nbsp;before they’re gone!</h4></div></div>',
                ),
              ),
              'attributes' => 
              array (
                'padding' => '10px 5px 10px 5px',
                'align' => 'left',
                'container-background-color' => '#fab9bf',
                'font-size' => '16px',
                'line-height' => '1',
                'font-weight' => '400',
              ),
              'children' => 
              array (
              ),
            ),
            4 => 
            array (
              'type' => 'advanced_button',
              'data' => 
              array (
                'value' => 
                array (
                  'content' => 'COMPLETE CHECKOUT',
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'font-family' => 'Arial',
                'background-color' => '#000000',
                'color' => '#ffffff',
                'font-weight' => 'normal',
                'font-style' => 'normal',
                'border-radius' => '3px',
                'padding' => '10px 5px 20px 5px',
                'inner-padding' => '10px 25px 10px 25px',
                'font-size' => '16px',
                'line-height' => '1.2',
                'target' => '_blank',
                'vertical-align' => 'middle',
                'border' => 'none',
                'text-align' => 'center',
                'letter-spacing' => 'normal',
                'href' => '',
                'container-background-color' => '#fab9bf',
              ),
              'children' => 
              array (
              ),
            ),
            5 => 
            array (
              'type' => 'advanced_section',
              'data' => 
              array (
                'value' => 
                array (
                  'noWrap' => false,
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#ffffff',
                'padding' => '20px 0px 20px 0px',
                'background-repeat' => 'repeat',
                'background-size' => 'auto',
                'background-position' => 'top center',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => 
                    array (
                      0 => '25%',
                      1 => '25%',
                      2 => '25%',
                      3 => '25%',
                    ),
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_divider',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'border-width' => '1px',
                        'border-style' => 'solid',
                        'border-color' => '#C9CCCF',
                        'padding' => '10px 0px 10px 0px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
              ),
            ),
            6 => 
            array (
              'type' => 'cart_block',
              'data' => 
              array (
                'value' => 
                array (
                  'title' => 'It looks like you forgot something',
                  'buttonText' => 'Check out',
                  'quantity' => 3,
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#ffffff',
                'button-text-color' => '#ffffff',
                'button-color' => '#414141',
                'product-name-color' => '#414141',
                'product-price-color' => '#414141',
                'title-color' => '#222222',
                'pd-width' => '5px',
                'pd-height' => '5px',
                'hcolor' => '#000000',
                'pncolor' => '#000000',
                'prcolor' => '#000000',
                'bcolor' => '#4A90E2',
                'btcolor' => '#ffffff',
                'p-font-family' => 'Arial',
                'd-font-family' => 'Arial',
                'h-font-size' => '20px',
                'h-font-family' => 'Arial',
                'h-font-weight' => '800',
                'p-font-size' => '12px',
                'p-font-weight' => '300',
                'p-line-height' => '1',
                'd-font-size' => '10px',
                'd-font-weight' => '300',
                'd-line-height' => '1.5',
                'pr-font-family' => 'Arial',
                'pr-font-size' => '12px',
                'pr-font-weight' => '300',
                'pr-line-height' => '1',
                'layoutType' => 'cart_table',
                'image-width' => '150px',
                'image-height' => '150px',
                'inner-padding' => '0px 0px 0px 0px',
                'btn-font-size' => '13px',
                'btn-font-weight' => '300',
                'btn-font-family' => 'Arial',
                'btn-line-height' => '1.2',
                'table-image-height' => '60px',
                'table-image-width' => '60px',
                'outer-padding' => '0px 0px 0px 0px',
                'td-padding' => '12px 12px 12px 12px',
                'td-image-padding' => '0px 0px 0px 0px',
                'table-price-font-size' => '13px',
                'table-price-weight' => '300',
                'table-price-family' => 'Arial',
                'table-price-height' => '1',
                'pr-quantity' => '#000000',
                'table-header-color' => '#000000',
                'table-footer-color' => '#000000',
                'table-header-size' => '13px',
                'table-header-weight' => 'bold',
                'table-header-family' => 'Arial',
                'table-header-height' => '2',
                'table-footer-size' => '13px',
                'table-footer-weight' => 'bold',
                'table-footer-family' => 'Arial',
                'table-footer-height' => '2',
                'pr-quantity-font-size' => '12px',
                'pr-quantity-font-weight' => '300',
                'pr-quantity-font-family' => 'Arial',
                'pr-quantity-line-height' => '1.2',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'text',
                  'children' => 
                  array (
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'custom block title',
                    ),
                  ),
                  'attributes' => 
                  array (
                  ),
                ),
              ),
              'index' => 'content.children.[6]',
            ),
            7 => 
            array (
              'type' => 'advanced_divider',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'border-width' => '1px',
                'border-style' => 'solid',
                'border-color' => '#C9CCCF',
                'padding' => '10px 0px 10px 0px',
                'container-background-color' => '#FFFFFF',
              ),
              'children' => 
              array (
              ),
            ),
            8 => 
            array (
              'type' => 'advanced_button',
              'data' => 
              array (
                'value' => 
                array (
                  'content' => 'COMPLETE CHECKOUT',
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'font-family' => 'Arial',
                'background-color' => '#000000',
                'color' => '#ffffff',
                'font-weight' => 'normal',
                'font-style' => 'normal',
                'border-radius' => '3px',
                'padding' => '10px 5px 20px 5px',
                'inner-padding' => '10px 25px 10px 25px',
                'font-size' => '16px',
                'line-height' => '1.2',
                'target' => '_blank',
                'vertical-align' => 'middle',
                'border' => 'none',
                'text-align' => 'center',
                'letter-spacing' => 'normal',
                'href' => '',
                'container-background-color' => '#FFFFFF',
              ),
              'children' => 
              array (
              ),
            ),
            9 => 
            array (
              'type' => 'advanced_section',
              'data' => 
              array (
                'value' => 
                array (
                  'noWrap' => false,
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#f4f3f3',
                'padding' => '20px 0px 20px 0px',
                'background-repeat' => 'repeat',
                'background-size' => 'auto',
                'background-position' => 'top center',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => 
                    array (
                      0 => '25%',
                      1 => '25%',
                      2 => '25%',
                      3 => '25%',
                    ),
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><span style="word-spacing: normal;">Split your purchase into 4 interest-free payments.</span></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 0px 0px 0px',
                        'align' => 'left',
                        'font-size' => '16px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><span style="word-spacing: normal;">Klarna.</span></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 25px 10px 25px',
                        'align' => 'left',
                        'font-weight' => '800',
                        'font-size' => '22px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
              ),
            ),
            10 => 
            array (
              'type' => 'advanced_section',
              'data' => 
              array (
                'value' => 
                array (
                  'noWrap' => false,
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#000000',
                'padding' => '20px 0px 20px 0px',
                'background-repeat' => 'repeat',
                'background-size' => 'auto',
                'background-position' => 'top center',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '33.33%',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '0px 0px 0px 10px',
                        'src' => $image_path . 'abandoned-cart-4/see-service.png',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><font color="#ffffff" style="--hover-color: rgb(var(--primary-4, #1890ff)); --selected-color: rgb(var(--primary-6, #1890ff));"><a href="#" target="_blank" style="color: inherit; text-decoration: underline;">See Our Services</a></font><br></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 25px 10px 25px',
                        'align' => 'left',
                        'font-size' => '14px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '33.33%',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '0px 0px 0px 10px',
                        'src' => $image_path . 'abandoned-cart-4/appointment.png',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><font color="#ffffff"><a href="#" target="_blank" style="color: inherit; text-decoration: underline;">Book an Appointment</a></font></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 25px 10px 25px',
                        'align' => 'left',
                        'font-size' => '14px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '33.33%',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '0px 0px 0px 10px',
                        'src' => $image_path . 'abandoned-cart-4/gift-card.png',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><u style="color: rgb(255, 255, 255); word-spacing: normal;"><a href="#" target="_blank" style="color: inherit; text-decoration: underline;">Give a Gift Card</a></u></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 25px 10px 25px',
                        'align' => 'left',
                        'font-size' => '14px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
              ),
            ),
            11 => 
            array (
              'type' => 'advanced_footer',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#000000',
                'background-position' => 'center center',
                'mode' => 'fluid-height',
                'padding' => '10px 0px 10px 0px',
                'vertical-align' => 'top',
                'background-url' => '',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_social',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'elements' => 
                      array (
                        0 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAMAAAC7IEhfAAAAclBMVEUAAAA7WZg7Wpg6WZg8WJdAU586Wpg6Wpc7WZg8WZk6WZg7WZg6WZg7WZY5WJc6Wpc7WJg7WZk7W5Y6WpU7WZj////m6vKdrMvO1eW2wdhUbaWEl7+El75sgrKpt9KRosV4jbhTbqXy9fiQocVsgrFHY58FMJF5AAAAFHRSTlMAv++AIBCfQJBQ39+wcHBg0M9wMJn76TsAAAEYSURBVDjLjdTZbsMgEEDRYcziPU2LCa3rNOny/79YnESaDAaZ+2gdgQEB8JR51SLUV42CfEagpcQhw5rWRnUpKoWliMrNcGjTVdxVNlu94yhNrrFRH6G/7ewSmVr8tPZOX8wD8vWeAopgp27uwNx1IhhN3jJ4TkFU25X4Fbl5npd4N3sO3QrPNgoDtAl4snEGTBkc+aH8ej+tOe/9F4Oa/+LnRHHYgcjBC4OYh4tlcXhx7oa+nXPXGJatGkGXwSPUZVBAUwYrUKVHCKIEdgAwlkAdoMICKOmu5iHd2HYPorxDswcHeDTmIX9Uno/Hu9DPs3tREEmKu7LnTKvMe8vDATbJKjGchFRyYKNizRjvbeiPGEzb1wZY/0BgYWSlhMOpAAAAAElFTkSuQmCC',
                          'content' => '',
                        ),
                        1 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => 'data:image/png;base64,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',
                          'content' => '',
                        ),
                        2 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAABMsAAATLCAMAAACzs8CQAAABlVBMVEUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD///9UVFSrq6sCAgL9/f0JCQkGBgb7+/uJiYkODg7y8vL5+fn39/cTExPu7u4fHx8oKCj29vZFRUUxMTEjIyO3t7fY2Nji4uLV1dUsLCzw8PDc3Ny+vr5gYGAZGRk1NTXf39/s7Oyurq5AQECysrLq6upxcXFkZGSPj49KSkrS0tLKyspbW1vPz8+enp6Tk5M5OTnl5eXCwsKFhYV+fn5sbGyampoWFhaCgoLFxcVoaGiioqJOTk49PT0bGxu7u7vn5+elpaV1dXVXV1dRUVGMjIyoqKh7e3t4eHjMzMyXl5fp6enHx8fk5ORoEpRHAAAAOHRSTlMA/ATuVvIL2gjr5szfiCAVXqr41qO7KsWA+mWS0Q93G5kmPDISTkS1by6xwDb0hGqeSnw6dIxAj5vsKaMAAFUNSURBVHja7N1Zb9pQEIZhGwwm3uJjbEzsxhg7XiAltCGo56L//3e1SJVaqVXbsHp5nysk7o+YmW8GBTjRo7PalYUWbZNXO06FCJ5N07QOjOF3I3kwOnw0rIPv3z4HQqSx/ZpsI60odyvnUQGAK3tc7j6729f9JxGY1lCV56AOLTMQ6f51637eLXnaAFzIxMmKaB6LcDqSl+cZ08CPE7fIFwoAnGrgZG4Sr01DlbeiGuY6ftMyZ6AAwPvcf9TqvQgNVTaHaoRiXxcf7xUA+Ien3LWFOZJN5llBHJWOAgC/F5NlZAtzI9vjwQrSRJtRegI4mKy0F6E/yLZ6mIoXbcWLBvTXYKbNxbRJLbHjqVZlR9lYAdArS81e6914xX6l6mtbWyoAum8wc+OwTW2xY6pOv84mCoCOGmdRHHqyH9SpX5dPCoBOGWdvQv8q+0bVxRtNNKAjFloctndMeZZfaNFMAdBij1lS3UlIOQrtgoUBoI1WW1+X+MVX3d+uFADtkddiKPEnoyDJCNYCzTfIk4p37O82wbwkswE01zhLgr5kLk7lhXbByUegeQbZS6+nlcd4COfUm0CTOBH9saPrzSRXANzevZZaEqcwRMQpbuCWBpltdm9D/CasmHEAcBtOTaP/rDbVlmO1wJXlc1Pi/Ky4ZBoAXMm4SA2JSxkKl7AGcHFOVBG9uDQ1TNhGBy4o+8KK5bXo+0wBcAFZTGV5XXd+QfMMOKtJyUN2E0O/IKoBnMmk8En1386mcjlNC5xsXPjN/hfxPvAqRpvAKcbamjhsM3hrjWITOE6W8ousSTzBKAB4t5xmfwMNU4IawDvM5uTImsqKuREE/JdFHUo02XTODjrwD2P3uX9/yds+6jM5DeAvcrr9reGJUgHwB4uEJlm76NSawO/ZfsGB2PZRA5fUGfDTzL6TaCdiGsAPT/UHiTb7ULPhBOTpRqLtPLFTgB6baETJusKMSGmgr5Y2p3y6ZJSuFKB3BlpAKLZzzIixJvplMWdw2U13Npkz9EdZkSXrLrViIQC9MHGJYHTdN/bubSeNKAoA6BEFq4CgXASx2FauMTZpTex58P+/q2n60rRp5DIwZ2bW+oid7Pv5Sh+AsutILivhdPIQoLwe+/70VsXYyBmlNR9EqqTZdVOb8vm4akWq5nI0C1AmVxObStVU/2FGg/IYKpNV2Lg/DFAGX5YG/KvtbakNQPHNbY8T4+08QIHVur0Iv9xralJYDa1L/tCyDUAhzUz485eL7w7QUjSNqdtk/KveNnBGkcxGIhmiGUUnkiGaUXwiGe+pTzoB0tYRyRDNKLzOqB5hE8+iGcmatS2Qs7n6VxMapMgUBts6nXrbRGpqd5cRtnUhmpGWs/MIu2jdBUjFohlhV72zACl4eYqwj9vXAHkbXkfY1+AxQJ6u+m7GkoWTvoea5KcxuomQjZu2cTNy0jWGQZYuVk7PkoPFfYQYtTQptOEyQvYG6wDH8/DpJMJvmgAUVWPqGgaH89z244T/UfKnSC6VzTi8td+9HN6TshmHNZsolHEMJ32nGjmgrpeXHMvpKsBhPEovOabmS4DsdcxhcGRvEk0yV1u5gM3x1UfWmsjUohchDz23zchOx2Uf8nMt0UT3kjLQ0SQTnwcR8nU7DLCfD84tkoDxxI4me3n1K440tL4F2L3mHyEVegCo+VMKegDsZGhjidToAbC12lTNn/SM2/YA2Mq6GSFF974Cs7nadBz5yd69LaUVBFEAHaLIxXCJiCECETARvKQqlC/zwP9/V6qSsmIMWj4yPWt9xZw+u3dzmBq9dgKPMso3e0jwnnSsRxmHzdOMd3jQiMHha60SvKXdU7hICRoLS028YWVliVJ4mvGqDxOPMsqxm5qasdfFLENJRrJm7LER9Kc0XyYJ/tW/z1Cez8sEzwybGUrUvEzwZHCXoVTrqwS/bbsZytX5niCl+SJD2c4FZ0mPHzOUrmXdvHobi+RE0JDOqNtgnSGGsV8AFbsx9CeOjqtztbJ+SSy7qWMAVeq7s0Q0p7YAKiTpT0DNYaIuJy6SE5OoWV2udS4SVUsRUEWG6n2I62yTqEP7Z4bIfGfWYak+luhGF4nw/L+kAs3jRGztaYYaLORmQ7uSj6UWp/1EWNujDLWwnxmX/UuqsuslIhqMM9RlPEiEc60/lvp09c2Gc/wjQ33OLJsH08tQJ+GMSL4ZlVGve0OzMG6NyqhZ6zYRglEZlbPRFMPXXYa6SZoFML/LwHqeKNpylIGcW2qAirZV8AN/HN0kinVpAROeNHRnF0tXGfwlNluqk3UGnhv7A1Cgvqk/vDRT0Ficx24GXuqsEkU5dgET/qc4ozQTWX/Yxw5AUdrnGXjNp3aiCL/Yu5udNmIwCqAOCyA/SlBDKYK0KRIRhUCJVFS8yPs/V7e0KkOYeMY2Ouch7mLmu9czjy1Bky9WgKowPYpAk8lVoHj3wwg0G/4KFG5lrAze9rAKFE0DE3YyeAwU7DwCu3GbUa6D7xHY1UbVvFDK5PAOqualmo0j8B5jh2YFclYGDs0+AGdl0MLwPlCU34b9oY0HzwAUZWXiB9r55CHggpy4kIW2BheBQjyKMmhv+xQowrcItKcCUIjnCOznMpDdJgL7OtVnyuz4LgL7uzGcndXh5wiksFbOzOhaBRNSGV8HMpktIpDKQtN8N6IMyjZfBjKYzSOQ0pEwy2Bp4weEWf3MlUEHJtNAr6aTCKRmnbFvV6MIdGF0FniNKIN6CLP+nIky6M7wNtCLW9P+8IIwq5Qog78Jsyr5VgadG/pm9i9RBjXyA+A/3JVBfUaOZl8SZVArDYAuLUUZvEKYVcQyBjRTNK+CKIMmwqwSphehZ3NLsx34atsf+rbwBoAog49gfBhI6ngdgf6tvZuZ1MFNBHK486J5SpsI5HEaSOY5ArlcBhL5GYF8zgNJ/IhATk+BBE62EchpexHY22oQgbz+sHdnO01GURSAd6GDJGWwtFQREklVQgIiksi+4P2fS2O4wKilwwXnnP/7HmMPa/X6wZZ+TBJ4be+/BFu5HiTw+m7ugy1c6CmBMuwpNN/C4SiBMoyFZmxs6J8cyuHPfFM7swTKcek10xMmtOBb4HMJGuCbaQOnCZTmNljTnXN/KE/vc7CW65sEyuNmdj0HbmShTG5m3chCE0ZuZlf2Zp5AqebqTFY1TaBcbwOHZdCA78EK+nJkoWyPR8GL7oUvQukmLjNcY0AL9g6CpYZnCZTv+DxY5jKBGggAWupDAnV4CLT6QgNkZsjGgBbIzPifE/1xUJNdb+b/dH6cQE1GlplWmNCCWfCX/QRq8zXwhQn1e+wHf7iSiQ01GlwFz3wSJAt1GouZNfeHFpj/P/OQQK32gydHCdTL/P/JwtwfajZZBL8cjhOomfn/b7ME6mb+r3UJmvAuOk/ODzSgdxcdp6oEmrDb8TKTnXkCLZh3O///YwJt6HT+fz+BVnS4zPxCKDa0Y3ASHTUUig0tORtGN00TaMk0Ouk2gbacRgctJgm0pYtf5kNJstCeUfdGZoZl/GTvPnuijIIojt+1RNTYjYXYjcZCFGvO4K6LIKAIIiIWLICiIlYU7CWW+Ll9ByuxIAPuzLnz+wpPyPLsnvu/gVF9ykzkF0PglNnKLJZlIZBauD1lJI5hhkBraU4HM43dVVJuYDOOYFOxQcXHjdgZ3WVyyNoTOSFsBhBM+iQag3ChmE3LbMUSGNP0Tcg0n0Ew6KNonIcTi7emPBgM/I8Lm+cI9gyIxhdr7zO/k03+/zAMui9s3iFYc65RFEZa4cfRlIG6jTCofEHItJxFsKWzTRR6XD3QQl2it9nobZgPSkLmHoIprRdE4fQ5uJLBWaZ6GDUobEYRDCkOicYLOLMtkdsFs7qFTONVBDuui8YpuLMgUbM3x5h08bSQuVRGsGJQNE7An8UrErN9MGxU2AwjGDEgGkN+1hgV9iVitTBtSMiUnH1fzEu3xrjWBJeIixnLjdcxOtuFzMhJBAPO9uSzxphAXczYD+P6hc0YQvUp1xg34NX6RGoLzOsVNg0I1Va+Jwqly/CLdP6/1+Tg/2fP2oRMn6eDL6Ru5jsTXL03EarZBAcuC5ubCNU1nN0ao8KamsTnGFy4Lmw8v6Iw6M+7d0LYZdxRgAuRMguz6naWa4xJhR2JjJ/rMCNlFmZRR7Mo9BF8Di1ie8s0Vvj/kzFh049QJa0jma4xKhxLVOqcvGECkTILs6d8RxRKd8GgcCQRqVkDR25EyizMjtei8RgcqH7LXAZXhoWN642SX19F4xNYHEg0djpYyVYqRsosQO+zaDwEjcLORGKei5XsJMaUWZfLaIxvDSXVE2PKAmxiucn8ANzhS5k5uSWWSEd77muMCocTBQ/nMKeIlFnQevVNFFrIvhTgeMuctxQORcosqJS7Y41RaSnDW6bJq33/hjFldh/h/+kVjc+gsyW5t241fIqUWZi5sfjYmWK1/8bsejh1pUfI9Lk/p+zGY9HoBaP9ybmDcGtA2ETK7L/QrjG6Sa8CrE2urZgPvyJlFmbkQYsovLkCTvN935e5Co7xpcx6WP9MTHl1SxTaydYYFdYmx3bDNb6UGdG5GLNOdolC6QN47U5u1bgJMP5SpMzCDPTGA/o111lGZ3mMqSJlFv7dmGg8BbUNyal1Hg8vVYqUWfhXo6JxHtw2rks+uZ2WTWBMmbEE/mx6H2uMP3A7MqsFgWKXkGnsQJgrL1tEYeQZ6K1MDrmelk3qiJRZmK7ONlFovgh+iz2OzNaCwyNhEymzOdJ0SRQax5GD+uSO82nZBMaUGcVNZfYUn4vGE2SheDw546+L/RuMKbPvkTKbC2/jv+XpWOOtZHYUPN4JG8amTNWdijXG9OxJrpB88f+DvfvgbSIIogC89F5EEQjRRBFCFNGZAV/sxLEDDimAgVBiIKHH9BIImOIQfjeQKFFIMXeeW3tu932/IZHndt+8HedilZnLizJNcp0lHnl0IZOwHXNXDv4nDGc5umqrXSUW+Ikqs5h1trNAb548stskyEnHfmXucXTZC2TVe1SZKYI0RgQLDpvkSORzJbX0c3RjZNdjVJmpke9lgcwA+WWVSYwEl8nOo62kb1soVUSVmRKpMZZ4S75JTPp/3wpyznuOLtNHVvVlUCqvw22WaCXvrNhhkmE3OWiEoyumyaoyspkq3GeJ2+ShsyYR9i4gB9VVZTZKdj1AlZkC91ii6tg9WTgLDpokOEROqqfKLBggq7oKqDJrus4MC9z0NB2TiPKf9eSoJxxdqY2seoEqs2a7eJUFrno7HC826i1dSY5K9SjMcXWjyqyZpGmMdn/X/Ffr7/7fSs661K4vx9VWQpVZM6UfIY1RpxNGuV1HyF1l5+L/3pQz2NLPEmXy2BLta5nHyGVVju4N2fWYBYIPBAJPWOI8eU35WuZBJ/MYU7pyHN13sipdZIGbzr+WYdNdlnjj+Re+8lzGZnLbZ4Un7E8zqDJrjgGkMUQOGMX2k+uGFJ6wl1Fl1hRXsizQ0UXeO2702kiuq6vK7AnZ9YAnKYzAOSv/C2kMEdV12e71Y8x2j12L/6PKrC7pQRYIHhIQbTNKuRuTna6bo/vUQla9YAn8W9WjHysXUor7MtaQD9pKCrsQulFl1mCjLPGNYNxRo5LTMdlpKgprXPO3UGXWUD9YYohgwoa1RiO33iupYURh/L+CKrNGqgQsUMR1y5RNRqG93iT/0r0K4//vWKCAfEAklwoscOsCwQSlgVnXY7LT3Ak4uh9kVfomC1QJwrvxkwVyfQSTVAZm95BHRjm6dtXxf9yrhYU0RszOGG22kEdSPQrj/62oMmuMjzxF33pu8mwxyri/vfSPvozCgp0qqswa4SVj/zVG+jaZtpNfyhxd0EkWSeP/XwnCeM6Iv8Rru1HF2ZL/eVU5umctZNVdVJlZdy5ggR5ULM2irPp/4TLyTVfOtfg/qsxCeJpDGiN2yzStmPuwVD7TD4Wrj/kOFnhJ8B/DJRYoII0xF1Ur5su9WCqfaUjh6mOFJQYIamrpYYEAVXHzWLnUaLGTfDScVRj/H0GVmUXXWOIzwTxOGSV2LCIvvVX4Bz1tv0rheV7CvWN8wtuxaJ/RwY+unzl0c3S5K2TV0wyqzCx5zRLdBPNR0/2zzpOun5nqbNq5nCKrvqLKzI4vAQtcxi1xLUt0DGanyVsVje/rDrLAR4K5SNMYn/AjUYuSwWzdEvLXN+fi/6gym9uFWyxQwLprTUpeMff2tOyvdK9r8f8C4pxzaSmyQPCeoCYVg9k+n8cyos5A4XXhNRYYI5gl9Qa9vVapODHzeiz7Y1ThdWG+A6U08RpBGsMyBYOZ52MZUaqo8LqwgiqzWJWRxrBNwWDm+1hG1JdR+BDPN56kMDWSONdZ4hHSGOFsNZFgLItfq3Px/1aCaT60s8CzVwQhND38f5SABjXG/wNUmcWkq4MFslcIQoo+mGETM2YXcwo/5O6jyiwebUUWyKB7JLxFO0x4GMus+K6xk3oQN29xSI0hjdEwJ0x4GMvsGOLogjtk1cUcqsxicJvxiEKDNHUw20owbjirMP7/GVVmcl9Zop/gN3t3wtNEEIZxfETE25h4nxhvxfuI7yvdWm1t1SpoLXgrWlDwQkRFkACC8Lk1AqZCS7vzdmanu8/vEwAJC23/84wv51RAmlYTzBpkDSNkVgemzKS6WGIScYtPq5tUMI4SzGtjDaNk1KcMz3Hwi6sL2QQLPML/tr6dVoFoWEcwS/PYUMZw/t/DAhl0UTfvs8D9mwR+rWtQ1cOdmGaMctjy/8hPmaVFwXEqS+DfRhWETQRFxlnDCzJImv8PUqTFuhk/Pet2qwAcIih2ZUYn/79JRj31MGWm6xlLvCfQclbZt43gP1kvbPl/pKfMelmilUBPi7JuP8EC/S6e4y5gykzLC5boRo2h7byy7QjBArF82PL/VGSnzF6hxgjKcWXZMfzhWUhzymwmTkb9xJSZf7kkC2TuEGiLbVV2bSZY7Cpr+EJmdWDKzK/0DAuknhIInFFWNe8gKKHgYGH/KYMpM3+uFFjA6ySQ2LFB2bSLoJRcysHCvhNTZn5Ia4wBApmLyqKDJwlKmnCxsB9ngSmKml6WGCcQWrFH2bOXoIx3Di72ifJ/L2pTZj94novH0iLhgqoEp8otGEo6mP9nPdY3HKcokdUYedQYNbBOWdNIUNYga3hNZvViyqxKt5Ms8Djax75qplEtBceXbGlzsH2IFTBlVpUHv1BjOKBFWXKAYAnpjIPtQy6FKbOKxDVGD0FtnFBloZO1qIc13I2TUROYMqvCd8bxVSdsVmWhk7Wp1cX8/x3GuCqaYok3BLWyo1nZsJ5gafFh1nCZjBq6z/qSkXhPewI1hjO2KwtW4falirKeg+9KdbLAZwq/yx4LtEcrXTFt9Spl3k6CivpdfFeqlQV+UtjdvoUawyE7lXm7CSqK5R3M/+MzPMfBnDdwQ89Z4PpDgprarYw7TFCFvoSDz4ushymzcuLtLOBFKMGz5bAqB3uydo2FLv8P920cHSzxg6DWjivDNiwjqErBwedF7B6mzEr7ghrDNcs2qBIQZAQgl3LweZFLYcqslAGWaCMw4JQyqmENQZU+uPi8mMCUWQmjHgvcC+8zPlBrGtQiWMgIxrSLL1feYcpskb7rLDD8gMCIRmVSC0HVbiTDlv+/DWUPekNUY9xCjWFKizJoa7g/l6+1j1rRZZqM6mSBEQqfeJ4FvK8EpmxVi+DKkoC0hS7/D2FH1cESLwiMuaSMaVpO4Ec64+AoxbVhTJkVGWGJfgJzljepBXAUMzA9rOHWHTIq62HK7J/3qDEctlGZspbAp1YX8/8pFuiiMOlk1BgO26YMOUHg17VhF/P/dkyZzfqWYoG3oXvB7ZwDyowzBL5lvbDl/yGaMruTYYFkjsCwfcqIPbisXMcbF/P/D5gy++NangUSqDHMO7lHmXCUQEMs7+LnY9OYMqPYNM9zcG0O/jqtimGEMVh9CRfz/yTrK1AojLPESwIL1qpiuBUzYGMu5v9dkZ8yG0ONUQ+OqXlo/h1QcPGX5Qnr8/qo7nWxxCRO81lhpP1vwPVL2nKpsOX/9T9llk2Iaow0gQ1FFzJh7ccJH0KX//dSfRPWGCH59KMuNKpa20Kgr5s1TJJZ/azPy1I9S99lgUR9f/N15oiqsWbs/AtoTpkNkFGx9qhOmcW6eZ6Dr/7hP8uaVW2dI5D4yBoSD8mo26mITpk9YYmrBDbtVbW1kkCkzcW32Ad4joMF3G/27v23xSiO4/jJWM017iFCkBBxF7fvF9XqqqO2sUuHWVet2oxtyFr3u/F3S7BEhNDzPefp95x+Xn+BXyzP0/N+PsejKkucJ0jUCuPUXgKZQl9s+f94qGd5qDECc9IYfFauyRjbqJFXV3o7b8pMVmPczhEkbLdxKNVNIHWeLUwWyKuFjpsyG+5lgRHUGMnrTmFQVpfcS435f7nDpsxkNUZ+giB563GVnDI1jQ8/ucWOmjLLTHHHPYmGb4txZh1+7nRiWuPDT5MFXlNgyrxEYfAHf+Q0MdtF4EJmNLb8P7QpsweoMYJ0Cstl2thNmc2RR7/k/xqvWXGrwtxRb9TRWG0c2UrgSDW6/D+kKbMaaoxQbTVurCVwZYgtjCrO/7O3KBT9vSzQF+ChbTy2GTfWELhhO2X2mfyq8w8a/9A6U3iIGiNYK4wTJwncmYsu/w9kyixzjwXS9wna6TDGsfWps4XJHHm1EP+U2QteovD8Bf7lLMax9RkosoUy+VWOfcrsM0u8J2ivVcaBEwROVTQW56L8v0HqfWSJRwTttt/IbSZwazC6/F/9lNm5NAtcD+HBM3bHMZGhkN2U2RfyazriKbP+IguMo8ZQoLsH9y8pNKbx5+cLo/yDxp/zZJ4vssDlcAq6qC03UgcJnDuvsUq9lY10QCIzhBojAhuMUGojgXO5RY1V6mykU2YllvhIoMLGlJFZT+BBk2PL//V+eN1giWkCJZbjFVOlabaQrpFXA0W2VyGd5liiRKDFBiOSOkLgQ+aGxvx/Pr4pM1mNMRTKx6adoLsHp5gqzaQ1nhcOxjZlNnOZBV7eJNBjn5HYQOBJlW2MkVe5ybgWpJ9PskARNYYqoly2B6GsP0MazwubUU2ZXbzOAum3BJos6zL29hF4M5zXeF7YYHvXtd1xU2KO8DSjc53AdeVKPWUbH8irzGg8U2YNlnhMoMxuY61rGYFHdbaQ7SevZrKxTJnN8hKNlyxD61Z2GVv7CXwaKGp8k7sUyZTZG9QY0TljbO0m8Kqi8k2uHsWU2TNZjfGEQJ8dxtYqAr9K0eX/WqbMBvpYoNhPoNAqY+kMgWdP+jS+yc2HP2WWG2WBbJNApZPGzlkC38bYxh3yazD0KbMLX1hinkCn08bOCgLv7mjM/wvj/J3Gf9t/ecUSVQKlNhkrewj8yy1qzP/fsr2R9n/EeAk1Rqz2GBunCBLQVDkX1gh5yuwuS0yhxlDsgLFxiCAJDY1zp5nb4X788yzPAg9RY2i2xVjYuZ3AP9sps7zi/L+dU2bSGqN3mECx7SlMlyk2kY4t/5+i9incYIFsjUC15bjjV7MHKk/bPgU5ZSasMRYIdLMZMVtJkJALQxo/5F7K/zV+AP93d1jiHYFyK03L9hIkZjivMf+vBDhlVuWfVDbI4MBh06q1BMl5qvK/3mBwvamsxvikbUsS/uCoadUmggTV2cZ98qrQF9iU2bUsC9zOEei32rRoHUGSBooaE3tJ/v/1IiXt6ggLjOi8FA9+t8605gBBoioqE/tXId34Lasx8hMEQThmWrOFIFkltvGavMrcCGfKLDOFGqMjHDQt6dlIkKybI1aJ/TB5JMv/x3OUpDJLzBIE4kgXlv6/sXenPU0FURjHB4loonHftyga9wXRmHO012JbQAuVRcEFRKVoUERBQWQXVD63MfJCEwq3c5jeM8Pz+wS84aa9/c8zynWzjY4UOTXny5TZIEvcIfBGLYoM7XpUxg9FP6bMXrLEAGoMj5RXZRwjqLjMT43xQyHvw5RZP2qMjeOgKcPOKoLKG1d5j9tLtjdEldGZZYHmAoFHqs5gI0O9MZX5f5f6KbOmJdQYG0k5Wxl1BElIt4eW/1dkyixdZIFIwwUFUI6TJr7tBInojTS+lppVPmUmqzGGCTyz3cR2gCAhgypfS82rflT8YIl5Au/swAEm/VIdoeX/zqfMFpg9+HUC1tM1E9c5gqS05lTm/5HaKbPZiAUeo8bw0W4T06bNBIkZVZn/v9Y6ZdaaZ4Hn9wk8VL0Jk7I+GFC57lxka1EvOfPkJws0PiXw0mUTz1WCBBXy2h4YfzxoZGtLaXJCXGO8IfBTvYnnIEGSplVuH05rnDL7xhLfCTx1ycRSg0t+E9bFNqboP0r+qr9myYlPzBqfsODcnq3Y+/GC3ZQZz5BTI4L8vy9DDgyjxtiwak0chwgS9optNDvO/98omzK7HbFA210Cf9WbOC4RJK2HbXSRW/OqpszeNaLG2Lj2Yx7bE5k+jasU6XZFU2YTfSyQR43htyubUJd5YlzlKsXy0XcNHxrvtrFANEPgtziFWT2BAlPB5f8faT118TKN51fBvRO4Tc4Xlt/n7pFbRSVTZmOoMTa4cziM6Y3eSGP+35lja4u0bkZZ4iGB96rNmi4T6DCoMv9f0DBlNhOxQEeawH+nzVpuEuiQamMbY+RWV/JTZrIaY/IJQQDOY7vMH6250PL/9Zkyu/+cBfKtBCG4aNZSTaDFB7bRPEJOdbO9OZK7+5gFonGCIFSbNVwg0GORbXwjl0T5f/SVpFKfmdWUIZCgA2Z11wj0KDRq/H+V5P/P0iQ0xRKfCEJxxKxuH4Ei08mXXCtoiZJLu+6hxoC/6szqthBoMqTyUsrBxKbMulniLWqMgOw1qzqTItBkIqsx/08VE5oy+5pjgfcjBOFInTGruU6gyyvBO3ZXZPl/D1krNLNAtpMgJGdxbYlfHgresbvzne29IUsZUY3R0E8QlHocLPdLpk9l/j9U+Smz1C/UGPCPcyhlPTPLVm6TUxOPKj5l1sPLVF4gChW2Ri17gECfqeDy/49kYY5Z2YUDkLBTprRdBPqk21Xm/3fYWr5AZXvFEov4gT5Au0xpJwkU6o00viDKTFZyyqylgQXamwjCc9SUdoxAox/B5f/DVJ4Hj1jg0QOCAG0zJdVUEWiUagst/y9zyqypnQVyLQQhOlxjSrlFoNPTBrbxgZxKdVRoyiw1wBJfCMJUa0o5QaDUh+Dy/zmK7wUv0/hEh+TcNKXsJtBqMbT8v4zn7CBL3CEI1W6MZHio0Kjy9rShCkyZvWSJAdQY4dpiSjiOV/+KLejM/7POdxH7G1jgWYYgWFU1ZmW1BIoNsY3nTeSQLGHtpxg6s6gxoJQbZmXnCRSbyIaW/8eZMmtaYoFcL0HIrpmV1RFo9kVlkZCZdDllli6yQNRNELQ6VP9+eig4/OhOS+RsykxaY4wS/Gbv3n9bjuIwjh9CIu4zcRmJIMRdRMTzoe26tbaZ6lzqTl3nNpSOjBjKzN8ts3X7Nu3Qc3aac3lef0F/apqe93lO2BYp/1dtBzlt4LaT+f+UrSkz0xrjGyhw25erVvaCHPfFyZ8nczesLPyb91lMVEHBO6ha6QG57puT+X8hb+N+EWsM+reNqpUdINf1XnIy/38t2oaHsJhCTgzcHgKFb4dqZSvIeRfSTj7XPS3aprGIGz9ZY9C/HFatHAW5byq4/L+GFoxrjFFQDFZy699bqVJo+X++gFY+ionXoDjsVs1WgHygOWVWhF13RNvlFJpNyRwnr9STM1aoZutAXugLLv/vQ5OamBgDxWKbanYI5IfHoeX/zc3ImbQYGMmAYtHF8TKPnT8nOn7ArsrSTZkVhllj0P/pVk1WcbzMG9+Dy/8rSJooi4FzN0HxWLaKN5h8NiY6sjdhVSG/NFNmmRExkJ4ExWQLnyz32UTOyfz/nWj7lMG8a2LiOygqzQeZx0D+GJfQ8v87qHvPGoPasI3HmH4rWlilNjeUE22TmPVOTFwDRaaLx5h+GxgUHeUBWDUu2gbfYsZkWgxc7gVFppvHmJ6bFCfz/3uGU2YvzomBTzdAsWmaYzwI8ss30fIAVvX/NJoyGyqLgWHWGDHawtuYnuv9JTpyQ7Dqg8mUWaYkBtJfQBFawWNM32leGpqGXRXRVq2KifugGG1TjbpAvqk4OYeTGhFTbgYn5KguHmN6L1UKLv//w81TDXJVt2qwnO/JeUhzyqzkbv7PGoPatl012A3yUJ9omYJdT6TjXr4FxWq9SjoB8tHj4PJ/PbkroGjtV0nHQT66khcd5X5YNS6dlf0AilePSjoN8lJNtNyDXfeko96AInaKN8uDMBZc/t++h6CYHVJJ3SA/TeRCy/9ZY1B7dqqkTSBPjYuWKux6Jp3yNAWK2lGVsB7kraJoqcGiv4e8rDFoSe1SC/aDvKU5ZZYtwKJ6yGtd7jwodnvUgh6Qv0bFyfz/lXRA9gIoej18szwUZ0XLc9jUbv7v5Gvs5IVjXMkIReaX6Eg/glUXh8W2PhA1LGXsBPnsQtrJ/P+NWHYHRMAateAoyGsVN78LimLVD9YYNGOlmrcB5DfdAuI6rOovi0W3+kE0Y4OqOwLy3ItsdPn/VdYYNGcvHy4JyFc38//3Ykv+Lohm7VN1B0Dee+xk/t9bkiTWGGTDcVV3CuS9K3kn8/8XWbHiFYjq1jEvC0pNtIykYFWf2HAWRPM2q7qtoACMxZP/V1ljUMJWVbcaFICJXCz5P2sMarBWzVm+DBQCzc7+ZQZJrnysxQ1eBFHCMq6XhaYYRf7PGoMaLSyY7QGFYWDQyfx/4LYsofQoiBqdVLM2ggIxqpnQ/2bvTntkiMIwDL+JDrEGQSzBSCyxjt1z0Noypi2xDWNnMBhiT2xjmeGL302nE6Kn+8upOsnpt+7rV1TVues5N5TU91CiVwI61KxtneDFEff5/7SATvutbY3gxcnJEOWnkmrcCiV5IWCGNVyO6U/klNlQn+T/l44JmGGbtc0X/HjjOf+/fUbATPNJZR06ei3Py7+fhuJO3xTQxTxrI5V1JfJ1rn5eSV04R42BVFaxKuvSVJ75/1j4J8sDCvSxjdayQvBl3Gf+PyGghw3WclDwJXLKLDxRUsPNUMSogF4OspDt0yuH+f+VhoBeaixkO/U4z/z/S4h2nxoD6m3QWhYK3pw5FaJ8VVKNyyGEPE8m0N92WctuwZ3XkQHXiBIqlP9/EdDTgLVsEfy5GKJcOaqkpkK0wwJ62cYvTG4NN/PM/8dDrNvDAnpoL/4vEBx6EqLU7yqps6dDrM8CelhgLUsFj47k+ZH9a4j2QEB3O+2PtYJLJyfzzP9HQ6xTdBnoZbaZbRB8ehTifFNK7S95efZv6F+LzGyf4NREnvn/k/BHlv0b+tcOM9skONW4lucO9XSIdfqsgG72cAuTa7Fp6pgSKpT/PxXQTY3fMX17mOfjz8d6iPVSQBeDZrZX8Gs8z/z/YYh1nJlsdLPOzA4IfsVOmU0prfj8/xrbP+hiIb+We/fKXf7/TMAMA2a2RPDscYjyK9v8v35eQKclZrZc8OzCuTw3dkaZMkOJljOT4d9Ynvn/2yZTZijPfGYyKuBiiNLMN/9nygyd5pjZLMG34WaeFx9NM2WG0szl1vIquB685f8XBfxnFZM/lXAkz/z/bp0pM5Rlti0S3Ds56S3/Z8oMHdbbVsG/DyHOCaU1zpQZSrKC+bJqmMgz/x8ZYsoM5dhhm4UKaFzOM///yZQZynGQKcaKeF4PUd4rrVGmzFCKPVYTKuGhu/z/nYC/arZaqIYrIUrzrZK6zpQZyrDYBoVqGBnK84rdaabMUIJB2y9UxLsQ57WSalxmygzF7beVQlU8zvPE8HydKTMUttcWClVx4VyeJ4bPmDJDYbtsjVAZY3nm/0db+X+eyQj6xiEbEKojsuaqf1RSI0NMmaGgAVsmVEdszXWroaR+MGWGgpbZNqFCYmuuCaX1IsS6J0DSEq4uqZg7eb7LfboaYl0XIG2x7cJv9u62pckojuP4ERPRGZQadOMDn1SUmVRSv0MbymYhy3mTmoHTZiwUnIipREkQunrdISP10dyOXHC6/t/PK/DRYW6/8z2W5Otpm/+TMsOpEZ5hsubQxzn/f03KDFeRcUOCLQdxzv9P27dxvkuA/0LGDQi2TMynbf5PygzSEGeZPeVcnPP/E1JmCDfgugVrNnyYmhKVXSBlhmADPFtuUHYhbfN/Umbo5iyz6P1UnPP/HR9qLivY1ud6BXv2Ujf/3xBs4ywzqhrp/L9Aygxhel2PYFCpGOdV7gopM4TpdZ2CRZ9SN/8nZWZbD2eZVcs+zL4Slf9OygwhOl2XYFJoyqxYUqLe5UiZIUCX6xds+hDpyP6ElBkCjLo7glGrcY7ss3OkzNC+ftchGJWvxzn/n5nygRZXBKs6HHtpuw592ub/24JVWT6XWXbgw+wqWb9JmaFdHXxfZtnEfJzzh28FUmZoUz+/Y5pWzsU5f6iQMkObRtmX2bblw8wqWaukzNCeLnb/tmUX0jb/n5wRLOrkLDNuZipt839SZjb10Mmwbs+HOVaydkmZoR299MvMq8b5xVT4/D9XFuzhLEOpGGdjP3z+/4eUmUF99P5xFOn8f8/7SFPeiBBnGaTl1M3/fwrWdPM+JrSy6MN8VqKmCz7Qel4wZoB3yxE+s19/q0TtkzJDazjL0LAa6fx/jZQZWjTkhgTk132YihKVr5MyQ2syLiMgOGVWmNZF0fxd3i8LpmTciADpR6Tz/01SZmjJiLsl4Aopsx0lKrtEygyteOgeC5BUzqVt/k/KzJSbblCAFJ4yW5pQomrex/mREVEZdMMCpCtc5j5RsqqkzHC5YXdPgKTw/+Zy0c7/SZkZ8spdF9BQi/TG0D4pM1zqqbstQA3Hkd4YmiVlhss8d+MC1FB6E+eNoXzdR9olQjTG3ZiAf45SN/8nZWbFmLsr4My2D/NVydokZYbmbrhrAs4Evxj+S4nKLpEyQ1PX3H0B5yqRbrk+TpIyQzPP3AMBF6xFuuWq+VBfBANeuhcCzoWnzLaUrCopMzTxxD0ScNGhj3P+XyqSMsNf9u6yx4kojOL4wYNTgrt7sCDnIZ3twtIt7u6wQLDgQRYP8rnJULqlgg295c695/cJ+rKZ+c95fm4GJlGkwaCnT9nvW1b3KcFbiNEUaZB5yuw83TqkKTP5qdHAMIo0uJD4mf/3nzNP12/lv5sNYCxFGn0MLv/XlFnoxgI69istioc9zf+faspM2hsD6BCTtDrT62f+XzqhKTNpayag4yXSxj1P///c7rWM3lJCNh1AgSLNSn2WzdEindppGSXPKAErABr8lzaemoWW/2vKLGiLAGylSJNHZhZc/v+AEq6JADZTpNHrxLK700On7mvKTFotADQsK81ul+2b0PJ/TZkFbA6AKRT50Z6hvD60/P88JVQjAWyiyA96hhouX0d23mjKTJqtADRgJg2Kj60utPxfU2bBWgdgMUXqBq0DPtCp0llNmUmjSQDmU2TIPeuE3d7m/5oyC9RoAJhKke9OWRNP8/+3ltG+PZQAjUJqAkWqnu22DrlKtwY0ZSY/GANoKEPqDlasU5L9dCnN//2c8pD/YiZSKymS2tVSY3ic/1/WlJnUrUFqI0VIFj9bkzDz/6OaMgvPIqTWU4TkeWvL1zC1v6IpM6mZhdQqirR5NRhs/q8ps/BsQGokRXjFOu4u3RrUlJl8NxKpbRTZ32ud94pOlY5oykyqliA1gxK9vcfNgfIxOpU9/79GCcpipCZTYtd/xBqFnv9ryiww8/HNbErcitetSfD5v6bMgjIbVeMocbtoriQX6NTesqfFiHTVOEAfMQl5y5rkKP9/ZRlVHlKCMR5Vaygxe2Kt8pP/n7SMXlCCUUDVXErErvWaU6/pVPb8/wklFNtRtYASr2N91ipP+f8NTZnJFkDhf+z6v1g7ecr/31lGnymBGAkAul4StdKAuXeZTpWOaMosdutQNYkSq4vWBeW9dOpZ4ulZAumWhagaPowSp1/WGPnJ/6/6+sOkO2YDimXj9tdxlq+LYQOW0U5KACagZiYlRr+pMWLI/zVlFoS1qClQInSgz7rmi6/5v6bMQjANNVsp8Tn9ybpokG6d1JRZxCYCgFayY/VnNUZu8v+HFU2ZxWsDoFg2Xi+suyq+5v8veyg5txw1Symx+WjddpJuvfP163dxbjUAaFk2Tu/tz0SR/7+m5NsyDBlFicqOxP5YbvL/C4mmzOI0AnXzKDE5U7Z/0GcZ3aRT2fP/Q5Q8Gw8oMIvT80v2D/adeedrZT+gKbMoFVA3kRKPnsP2D5I3LH3xNP8/tltTZl/Zu9OeJqIojONH4xoTA2LcE7fEJe5R4zm2Q5u2IFIWqRVXjAuKBQqiIKIEQfR7qxW14IDlnpl4597n9wGA8KJp5v7nuT46T38cYPDHHfUT/GJgaf6/gCkzHzVRDa4u982k1Kgy+XExNMnxuiOGFhgS6xh9hwUz70yIRg/XpMuW9g/G+X+hxJBUh6nOLgY/zAai0JfhnypZS/uHfkyZeecc1Wth8EKlTRRmXvMvc7Ze5Zay9ZAV4nKIanBFplc6dDVGF/+i6B/GOFattzBl5plmqneNwQOtZVEIprhOqWBp/l8MMGXml6tU7wKDB3Q1xhgvM29r/v9KDC0yJNEBqneJwX0fROMprzAihkY5Vuk+MRNgyiyRThAhyvDLqLLGWGk6b+mTqVIBU2Y+2Un1Nu5ncFy/aLzM8F/GbB3ZnxdDnxgSZxcRogyvvCuIwnBoFtYjhoY4XiOWprwQg1qSgaUMf3TfEIV8icO0G//Q6xyr6duWprwQvWZa7jyDy3JlUcg+43AvxNLPjH5bU16I3D6qwfUlfkh/lTD6ea+UrZ8ZKUyZ+WITLXeawWGfRGOOV5WbsTT/N/7D8pgyS5g9tNy2DQzOmhONh7yGYuBa/v+GIUn2b6QVtjK46olofE7zWsZtzf8XMWXmhRb6Dm+X+6GYFYX7OV5Tuuxa/t92kyE5molwkOkJXY1x+yb/QyXrWv6PKbMk2UcrNTE4qf2WKBSK/E9ztub/VUu/MUKUNhHhINML6UFljdGA567l/0GFISn2EOEg0wsPRWOUG1Eq2Jr/5y39xghRqR1j4iDTB09FI8WNqYqhB+0cqyeYMnNdCxEOMn2gqzEG09ygQdfy/6DIkAjNtAR3lztNXWM0qiNv6StDxvn/MKbMkqF2jIk3Ml1XyovCjW5u3JgY6uzmGCny/w8MSbCJ/naUwS3KGuMRr0ePc/k/pswSYSeF2MzgksxLUQj6eR00U2YTHKt0r6WzRBCFzRRmL4NLBkSjyuv0Qgxl73GsugqWnktABM5QmIMMDnklBjTD9ynn8v8nDLa7RmEOMLjjo2iM8HpppszGOV5fMWXmrCYKc5zBGc+yolDOGf1OcS3/x5SZ9U7TEtwr56iuvCg86GAjQ87l/x8ZrLZrI4U6xOCG9mFRaLvHZjJlMdTD8RrAlJmbdlC4iwxOyDwXheAFm6pkLX3MnpuxtH4DnSMU7hSDE96LxjybeyqWPmYvBpgyc9EFCneMwQWLojHEGs/F0GeO1zimzFx0lsJtwYSZCxaUNYaCZsqsyrFK91pav4HChi1UgwkzJ10PRKG3lXWqzuX/rxhs1UKraWZIuq5OZY2hNSiGyhmO1QSmzJyzm1ZzhSHhpr+IQuc9VuvutDX/H8SUmWuuEOHhv6MyfaIQzHIExsTUM45VRx5TZo65TISH/466IwpRVe49YuhxjmP11tJ3rMDQ/m20qh0MSTaprjH0NFNmAxyvAUvfsQIzO2h1RxgSrCo//P/3iPrF1vz/y3//30CEDtJvuLzcKbOBKPRlODIpW/P/KUs/ZMFIEy3B5r9bKm2iMHOXo5ObsTX/H7L0QxZMHKU1bGdIqOnHotDZxVGaElvz/zKmzJyxndZykiGZWntFIfjG3r03txCFcRx/1H3cxqVuw7jf636Z5yGxEUlKNCSptCiqhCpFO9qiVQblddPoEIZkd4/NPuf4fV7B/pmc/Z7fjvO/Nag1/7+RwpSZK/ZRIxsZ7FQRE8/5H/OKWvP/YUyZueIENXKcwUqTMktRcT+UlJA+cbSqmDJzxF5qZGuCwULDSmqMOgMSUlJr/o8pM10SW6kGUxku6RETjzyOQsm1/D91g0GRtdTYOgbrTGTFwJMRjkQ5ozX/v6r0KA8COUaNHWWwTaFTDFwsc0RGJawejlR6BlNmDthMjR1gsEz6uhhI3efIVF3L/zFlpsl6amI+g1USn3XVGHUKeVFapg5iysx6S6mZgwxWmRQT7zhK/QYfg4qQQf4/xqDEapqDbVlHXJBZWk/ZKxJSqosjdSOFKTPL7admOhgsck9MfExwtEY6JaRrET/aMKbMLLeLmmlbyGCNiYwYKOY4aj0iSt8ZVpX+lAV/5lNz7Qy2MKsxui9z9M5pzf8LeUyZ2WwfNXeCwRK5ohjItCQwSM9ozf+fKw1GwJdT9AM+xmS9RFVMvOSWGJew+jhaV5UGI+BHBzXXdpjBCn1So/2m9JjW/D93S8LpZ4jbwjby4RCDDQbExDluFa/oWv6PKbP4tdMc7DHaz6zGqCa4ZYaSWvP/MUyZ2eoE+XGGQb8rKTFwM80tNKA1//fC5v+jDPHaSX4sWcOg3eVu9TXGT4mShJTp4kgNpTBlZqU1S8iXDQzKGdYYt7m1yhmt+f8Fpc8FjR0iwoGZE7xHYiDZw6026lz+jymzWNWOy1CYOeCO1Fh02FMVpZNhhbzO54KGOqgGVzJt91hMvOcYFPKidDKsX+lzQQPzaQ42zOzWL7O0dg5/0e9c/o8ps/isJr/2M+h136Iao05FwnrIkcrdwpSZbTaTXzsY1CpfFAO3LnEsTKbMuns5UtOYMrPNSvJtOYNSuS9W1Rh1etT+LZ7ElJldFpN/xxh08h6IgeRDjlGfhPWBI+UVdV5+h7/YTv4tYNDptZh4xnFKz7iW/3f3MsRgAfm3ah6DRp/ExCDHa1zCKiU4Uu+U/vuFP5m3mwJYxqDQBzHxlOM2JmENcLQeYMrMHhsoiBUM+kwnxcC1+ONOr+ha/o8psxgcoSD2MqjTlbezxqhzO+la/o8ps9bbSUEswVC2Or0zYiCrY6XmsXP5P6bMWm1hGwWyj0EXr2RvjfFToqQ2/+/U+YV1+N1BCuYogy61GkNroeVfV8a1/B9TZi22mYJZyaDKC6trjDqjat/DTip9xwq/SGyjgLYwKPJMTFRYkaqENcWR8oo637HCL5bRN6gyrHU2KQZKHisSfsosW+YIhc//v8Rfu/xHNlJQJxnUGMqKgTfKbtpMOZf/K/oL774OCmwpgxKv7oqBvI4ao07FufwfU2Yts5SCW8egw/lrYiA5zdr0dktIydscqcvZkCFymqE1jtEcbGVYqCI1Dt0YvCda8/8pTJkpt4eC27qJQYMxMfGCNepTm/9XMGWm2ppFFEI7gwKjYuIqq5S+K2G95UjlOnWWvPBdO4VxiiF+bx2qMeqMi9b8/6HSkhdq9lMN0n/7TGTFwJMR1mpSbf7/3qGDSfespFAWM8Ss0CkGLpZZLa+o9W2GV8SUmVpbKJzTDF/ZuxOeKIIgDMPlooioibfGEzXedzxSpTuK7Aq6gOuJioLrGXRX8YIVEBEQf7dkozghMcau7pnqnnp+Agkwx9vfpKvjDjG0j6BgjyIimX80RiOdMpNqNZjZgypV+Q/E8RZFGxKb/z/x8tMwmXAUDLWiStM4zRPbyHPly2TqK7r1TKfMZGoFU22oUnQ5xBojpqcYWv6vU2aObYMYXf33Rh9xvPTg16pGRDKXKaYDvRb23R4wldPz5ekZLQZaY8Q8J1Pj6NZdmReMGdcK5k6iSgW7xvCjD+gtSc3/33XJvGDMtjYwdwpVGtg1hi9LpxNkqkto/q9TZg7tB3O5JlRpyM8Rx0f0RZVMfUa3psiMvImlYDTl4DcdMfPGQ+K4jN6oF0LL/wd1ysyVk8CxD1UKGrGm2FkcqyokNf9/FOmUmSynYBH9frl4FeKY8aDGiBkQm/8P6ZSZKMtagGUtqqR1txPDA8/ucToGxd5LP5O5SpRVGyBGl7J9cO02Mdz2o8aIGSFT0Sg6dasYwOdIw7EUeJrXoUpU5w1iKHoYa44Hl/8LP9Xvp2PNwHQYVZLyzzNSYyzgTJl9QrfuynwtkUlrAfQm0ysDxFFDHz2KQsv/dcrMvn3A1bIMVXKGiOMC+mmWTHW9Q6f6dMpMiKYWaNBc1hOPieODXzXGH/my2Pz/gk6ZydAGv+iZTC88zVSNEXO/Xep67sUbOmUmwjngy+m6bFJuFYihqxf9VROb/3dHMrdvM6YVbNiGKhGdP7JWY8TMEJHM5+xDMuO3jDkLNpxGlYRLz4gheoFe670i9eVt/iYZeSD1O8te2gtWrEKVgAFqyOqLs+ng8n+dMrNnOdhxHJV7s8Qxhd6rEpHMK6BvOmWWti1gxyZUzk0QRxX9Vy8QCR1zreqUWcp2gyXbUTk2GRFDOYiV+QoZO49O1W/rlFmqVoItO1G51VMghv6rGITr5j+BTnSqj8x4/kJGjINgy64lqFy6950YrtzHMHT2h5b/65SZFUt2gTVHUDmT9RojZpKk5v8dYzpllp6NYM8aVA59Jo5pDMdUcPm/TplZsAbsadaxDIeGaZ7Yd3iJunRDbP4/S0ZKPp8sE6KpGRbTD5iL9Lte0puYed2R2Py/TEZmUDG1gU17UDlyPiKGm6EdlJkNLv/3/kRG6o6CVetROdFTIobBQGqMP/Jlsfn/G50yS8VyaNDETLj6IDGUQqkxYu63i310WNUpszScgQZNzGS7WCaGKMgDfzW5+X9Bp8yS1ojLLDuAyr67xDGBQZoRm/9XZD7JC9thWES/xyTRJ+IYxjAxpsyuo1sXZD7JC9o+sC23ApVl72me2N/b9EyL/T5ox5j+20nYihzE6VS2SF+0xviLKhHJTFNN+7enqMycBfv2orLq1RViGAv51HLjIbvMNHVYp8ySdQhidMVMpKv9xFAKO1r6SMbeo0Pm/dtDVCZWggsHUdlz8Q4xRCMYtutkqt1xc9dT1CmzBJ0AF3YcQ2VL/gMRiV24SV9nf2j5v06ZmVi2AxboAXOZxonjCQZvUm6rMidzLjJIbbBAn/7LVNMa41+miEjm94/qBb2YTspecGQlKiv6iONlwDXGAs6U2aDM/L8U3BCAc5vBla2obBgtEsPrd5gJ3ZHYC9cBMjKH6v+sAVdamlDx9XYRQ+EWZsQwGaugQ+b5/zdUP9m7E54moigMw1dQo8Y9rom4JGrcosa4nKMtDhRapFIXquKCooCAIMRdXAAV/N2ioBLoMnNP78zpzPf8giYKuXTe+41/Kwdl0f4r01pkAS85BXmqyLYyHeSQ9ZmxLd5VYM1dMO7swhKTWGoONYZPPV7c8v9b+AEKIHXIrICXyynykBdgCqu6Fp6ncpnaNv9vIfBtp1kJyz96TPECvNTfj/645f+YMgtgtXGpYQOBRB9LfE/anyjX2tlW0XG58krnrYQY2dBgnNpEIJD3WOB+8sYWZvTm/wM6P1Z8nDZubcbuv8C1bhbovkbJM8rzVG6GdWRUfqzYWLXZlIbdfwWyN1mgLU8J9OfCkM7NsDc6P1ZcnDCuHSWwlBpgZrXzz1q90fukpBdTZg5dNOVgkjFyvSwxRglV0Jv/z2LKzJl9phxcyozcMEtcoaTK5tTm/+/YSi4hN2pFthr31iHLsNLHEgNJqzGWGGS1+f8QpswcWb/OhOA0QXDPUGNYm9ab/xfx3acbe0wYDuwlCOp2hgVyXZRkV3+qzf97PEyZubB9iwnFDoKAsj9ZoO0RJVs+rTb/H8OUmQtnTQXYyo7Q1X4WSN+lpJtgaz/IrQFMmTlw3IRkN0Egvcys9o2P9UAwZZbWmf9jyqySk6YKrGVEZJglpgmox4tb/o8pswqOmNBsJPDvM0uMEsxr0Zv/FzBlVmMbTXjOE/gkrTGKia4xluhna3fJqdZZTJnV1jETnqY1BD5dz7DAAzy8X3S7LW75P6bMyljTZEJ0icCfe7Ms0D5CsGiGrb0mt4Z0PmKtVxdMNehlQyeuMXALeYlRnqeygEgVVT5irVPbD5jq0MuG7iMzq/0RrDOCKTPPcQEx4rGNyWaCFQ6acO3CvqwfP1hiiGCpcbZ2I0VOjWHKrFZW7TIhO0FQ1QxqjJoqsLVhcmuArXwhWGabCdspgmoup1ngBv4AWS6bU5v/d3Viyqw2Thl/cJEpRNc7UWPU2CCrzf/HMWVWEztN+I4QVPThMQt09hCsdIXn6fxuqoAps1o4anzD8H9Imm+wQBpfpJTUPKk2/88+UBny1pl9JgpbCSq4wxKfCUrKp9Xm/18xZSa32kShATfMK3iLGsONCb35v+W/+TeCvzY2mEgcIyjnJUsUCMpYbOxV/ta4WmQb7Ul8H30ZZ0w01q4nKO1LmgVu4dJxeYuNvcoBxBEPU2Yi69eZiJwjKGmknQUm7xFUMKU3/2/Be5xF9puoNDUSlNCBGsOp/rjl/5gyW9C41kRmD8Fy4hrjHUEloimzdJ6c6urElJm9c8Y/HMzck9YYTwiqecnWXjSTU08wZWatsckEhXeYO/WJJSYIqpuLW/6PKTMKfCzDwcy1MdQY7nVk2NogOZV9oPK8WAeCHstwMHPsLks8x/cm/oyzte575NRXvDrQhsWxDAczp963scALLMD4VdCb/3/ClJmNxsMmIBzMXOrKsUDmNoFP2Zze/P8mpsws7DFRO4zXy/3XWmQBDzVGAIMct/w/2VNm0R/LjNlEsCg1xxLjBAFc4d9UXhqaYit9lGDRH8twMFtimiWmCIJonWRrT8mtfpWjRJqtUXAsw8HsnynUGKF6xnHL/19TYp02GmzBweyPPpb4jq2EwIZil/8ndspMx7EMjzIX5D1RjZElCCpVjFv+n9gps3NGhybsmElrjO6k/h+WGfH05v+/2LsPniajKIzjFxwommiMI3GvuPfKeaQvraVYxVWrrQMcFUQxohgRFVdU9HM7SoKTmHt93557zvl9CJGX/31OGT4GSaWF6xwTR0i9kxUEKJ0h4+OtuPxf55TZDsfFgk5SLjeEJrsrlq1BvmfhJ+EjGSF9Ohc4NlaTcv0IcYKMp2qJ7a2rfMWmzP7RasdHewep1kCILjLeRuGtt0qpGimwnL7lp6PdMTKXNLuNEENWY4QYkpb/J+o+ns51rCwivcJqjGtFMgFO9UjL/7VNmS1yvBwktao9VmO00iN4SwYoVad74WOSVNnmmNlNSgXWGANkAp3nm/+/gpfjpMhux81m0ik/jABJnUyo6SyV5X+BavBxXdMrkMOOne2k0g2EeEImXB3fsFxzHSvblNnsdjl+draRQvetxmCgC97KKef/d23KbFZtOx1Dy0mfWwD4Ds+rUXzJN/9/Z1NmszngONqwl7S5YzUGD3f4HlfOV+zn3N8t2+BYUrf9c7YHAa5r+dGbhXv4huXOzkDC8YUVExyWsf9kvrIn5icfWI3BRf4y3/y/wfKfWBY65zumdD0xzw8iQHKXzH80kvC9tDAIH8Mk31LH1lpS5AVCjJL5rxri8n/5U2ZrHV+aXjJ9RJNd3GfiIrx97qZUvYePwlUSjt3rpR+tIC3eA+AbAmhULUnL/y8LnzLb7jhbqSWYPZ4gwAVlSwjZGBWX/8ueMmtb6VjbSCqc7bMag58hafm/7CmzNY43Hccyn08hQK/47yAtMn1hl+ULyHcsdzxaad4Sx9whki9/0WoMlm6Jy/8FT5mtd9xpCGZraLLb1NycF5f/i50yW8zo9tLfLCXpxhHiHpnUTE+ZsWxT79uU2Qx2I/86F2ZHEaJGJkV1xqf9BuHjPIm0wsVAeJcRVmNcFJ4MtVwXvCUTlKpqyabMmrjOlv1uDQk20osAL6+QSVVxSlr+L3LK7KiLw9aFJNbzmwjQZzVG6p7B3zilq2ZTZk2d61wk5O5ldF9AgOQNmdTd45v/X7lkU2Zfsd7HUHP5twbwTZjMd/kKvJXHKFV1lrlI5la5eGwR+vl/HCEek8nCSMI3/+9imYtkrG2Pi8gBkughptkf11lrwN8jSlV3xW4P0kYXkyVzSJ46QgxbjZGV3AV466t2p+o1fBTOkhxz2D/E/NkOEmeiFwEejJHJSrUEYSRNme13cWkXN5d9rowAPVUy2XkCaeRMma1td5E5liNRipcRoPCMTJaGIIyYKbPcZhcdWWfMc58Avl+Uza/O9UEYKVNmPA+Va6r/JxGiQSZjtyDNOEmwMLIP//Lq/xNWY8SmBmlETJlFVPzLHP+5jRDDwj4dxmGsDGEkTJntdnHatIxkmChZjRGfOqS5QbFbtslFah+JEFhjSHtMF41+SFOnyB1ysVrQQQKcrCBA4Q6Z1ihOQZjYp8w6Itj4lxyZBdYYT8m0yjNIE/eUWe6Yi5iAyKwfYLwhb2YzDmmino2KMS2bsST6yKyBEP1kWihfgTAxT5nFmZbJicxuI8QHAb9jR20ggTART5lFmpZJiczOFBDgWpFMa92HNNFOmcWals1YGXNkdvoSAlyK+PeBL+zde0uUQRTH8bPeNS+llFdSUzTDQkvhTO6qVBaItaiJIGlRdCNNAumiSUXh6y7oDytd2RjwOec3v89rWHiY2TPfgyK/GMDMOt1/43e07NBFdStuGuPOI6XM4aXMij4vLibEvwq3i0xmXnAawz+8lJnLUoGndSWljXSqT+shxqaSCUyZGdB6QSB0qEuvQowpJRuYMjPA7+MlhFPm47gBbZ+XGpCYMsucvy420inzKacxYDBllrHcgMDwF8xYuh0i3LuvZMfqcgCz5utb2SE46trUl7sHnMYA8iSgcZUya3OcxzhqNKeezDwLEQrPlWxhyixDuVGBMqmerIcYW0rG4KXMllfViybB4uqU+T3E+KJkDl7K7I064TnAeLxLfk6Z39L4jaWFKbOM5G4InCZ1Yr8QIjz09Q9TMpgyy8g1wVPXoy4szIcIa86L7LiYMssA0pSsv/rP6o8QYc5pkCUFTJlloHVEIE2ofTOLnMYAlS8GMLMLat1lAeWgMfsxxPiqZNcCU2anC6ElW0pvpRq3HWK8VLJsM6AxnjKrbBZYZ9W2rRBjRck2vJSZ7ddy7reVnOScWnazECIUZ5Rsw0uZHVhOmV0RZC0NatfrOU5jgNsLaAzfazQMCrRxu7eVHzZChHlOY3iAlzLbV6Py4wKuT42aLoYIBbM/KTqEmDLbsPrQpFvQ1dSqTSshxp6SC0yZnZLaGoE3YDOYvRNibCs5wZTZqegEi5Y5Wv77LsR4oOTFrY0AxmTKDHbg/2/Das7nQoiwyGkMR/BSZgYHG4clDfYGM97PhQifLH4XqaTdgOatGtPQIokYMtZlzG9PxVhS8mR6dwrMjrFJp9yQJMNX/Z+IyofZXyylol2JCNMZyP5iKc3VSkSIkOsYx6lSIkJUJYkZUyLC0yepqfG0MJOIypHG26V/DbhYZUJEZcNdVnKyLiUiLF2SJF6ZEWEZkzR52f5LRGXpSfCy7Ld+TpkR4ajul2RxyowIRj65ybI/dSsRYZiUlPFhJhGI9qSeYR7VW69E5F99ryTOWsuMiP5bWs2yUjqUiLy7LiTnlYh8SyXwf7KWRiUizxoHhX4ZuapE5Fd1ki/Kf7J3dztNRFEUgHdAWgTSYqFWI6SaQtTGiFxIzoXv/1zeaQh/Ax1mzp5+30Psi3PWXvs+byo7vQA0tu0hWbdMYCi26VZJxvO/QCPz4L+LcQEyGp8HKjMgu733wS2X3v8hH+/+d/0sQDYfgjvWBchlHbgyB+l597/fl90C5LG7xaXY+n9gMPT8OJkJQ3AV6P+H9La7399nJgyEyrLHjdz/hQxOfGE+YXJQgNodTIInrDQzQu1mPwLNjJCdLUyXmWAIXF1q6LQA9ToNmtlfFKBWi/2goamaWajVeBpIZkB2by2UP8tKZzbUaG8VPMu1zgyoz8frQGcGZPfnOBAzg/QEyxQAwQB8DhQAQXpfd4IXGcnMQj0OR4HMLGQnIyszCwMgI7uZ7+7MQQ1kZDd1MytA32Y3wYYuLQBAv8T923FsmEGfxP3bclWAPn0LbDNBejaXWvO7AH35FLTmVwH6oN2/Ze8K0Ie1JcxW7cwL0L25QyUtGx0WoGsL++StOzfMoGtnF0HrpmcFeIRRlsT0pABd0fLzj2EGmY2XwStZ6maEBxhlqSyPCtCFo0nwiiaGGfxl72530giiMAAPUVBosRYMtrbSGvmoSKL90WZ+cP/X1bSJjUGF5XNnlue5iJPdM+e8Zx9aStmO3UjNht1rScSep5hBfpq9wDzFDHKjlO3HXTMCu9O8C+xFz5cZ/KeUZcxvJuxMyw/mYkYzIAfvvWAuophBHozI7tuZdSaISlkFWDSHf+xg5k6eGWxZVykrQjGDtHXllZVkIDYbtuedUlaUYgbpurwOlKbh1Bxsx72LS6U6dQQYtmHiDmbZHiOwqQvXycv3KwKb+RJIQD8Cm2gHkvBQi8C6Zj8CiTj/HIH11M4DyRh2IrCOzjCQkN/1CKyuPgokZeoIAKyueRtIjEAzWJEQ2TQNLiNQnG3yVDXGEShuYgUzVd8jUNSjvaV09WcRKGL2KZAwU7NQSO0qkLSRQTNYrv4zkLhbN81hmZaxsgwYNIMlToyVZeGDQTNY5H4QyMLpRQTe8lEcdj76Es3gNWYxcnMsBAhe05FWlpmp50x4qTUNZOabO8Aw7+tZIDuNSQSeGztNnqd2BJ64HJexK9uZ8KT2EMjW6CgCfx0J9s/aTTcCMZ70AlnzAgC6/tVgB4CDN2sHKmCoacZhqx8HKkHTjIOmVVYd15pmHK6xhJ8qaTtq8oe9e9tJK4jCADwgFRARCiKlEBW0dhP0wjQxc+H7P1cTr5qeFA+wZ+b7nmLvtf71D2UyKstN6y5Cee6MyrKzPo5QmmO9/hkaTCKUxagsU5JmFKWhQTZbDwoaKUfXAWbGLjzRRCmmF4GMNYUzKMLjvBnIm4smCuBqqQTLRYS8jV0tFaFzGSFnp4eBMgwdAZCvURUoxlU7Qp7G60BBOvMIOfJ/WZyWfSb5sb8s0YncLLnpeZa8SM0v7jPJiXxsuW7cZ5KP7n2gWIPvEfIwGQRKVs0ipG+m36d4t6JmpK+tP5ZwOFedQeKEynhybwVAyo6+BXgy8H4m6fps6I8rAJL36WuAX5xsIqRnKunP76pRhLSMzgP84awXISUL9T440CR5jXknwN+tBGdJRftHgH/q9H2akYLGXDyW/1t7pon6G98GeEbz3Lk59dbom5TxEmsLTeps4ZCcF3+ayZpRV7O+9lhkzUieTBnbaVbeA6Z+BP3Z3tKFJnWzWQbY3rAboT4OVGLwSteXKmepi8dTPWW83mocoQ7aNwHEM0jcTDqWN1tOIuzX5izA27XsANgfM3/sAMiBmT/v6UF7BvuxWAUQNiNxB5XjS97b9VxNI7vV8HvJh7iaRtidnsJFPsrwKMJudKsAP9m7t+U0wTAKwx8KJCpYTARRBDQGYzNp082k8x/0/q+rM+1BOplsiFH8N+9zEd8orLU4mjJmdBZd8IpSgCeIzsI0hGPRAT9SwDFFvgAd6O36CjiWIKd7iVeQz4ARvBU5DHRpPVHA4aXM+aNrW2pNOLTL7wK0RNoMuhqyh4ETCatAAYfxJSZRhtOpp7wEwCF432oBTinjJQA+Lt0IcGp3fEgTHzP7JYAOtiMF7GtJyh/68M8UsI+zRACN9BJamtgnhsFuLHTTWxA3w/sMKpqX0FH5lbgZ2gvyUAA9XecsaKCdIL4WQF9cM3DJYIey4pqBSwYbhFwzcMlgBa4ZXhJQIYdRuGZ4Tj/nksE05Y+BAv43qEhhwETnCc0mPIp2XDIYq6F1jn+WCW0lGO3qRgGzRgDTbdiedZx381MAG4yLCwVXzaeZALaoH6iduyl4YMcfdgkXvNR0T1QR8YeFmlTBJTOfV5ew1OcVD85cMZ/cCWCvTxXrsy4YxDwmg+16yVLBbssF29dwwvaWxJm9vFu+dgl31BWfbbLTMB4L4JQm/a1gmRGlS7hoHbMKZJP+ioA/XHXuEzmzxWjBog+clhW0m8x3Md0I4LrynpEzs43uGb4G/sp4cmas/oqfZMCjXjOZK5jGS6lcAk/VOwoBZrnMyZIBz9oUfInOFMF0KwBeEiYp/Sb9eWlC4xJ4Q72bKeiM/5ZAS+OKEVpdRfFaALSWxQyd6WdYXAn+tHdvzWkCUQDHvWyMBpayLhdZOiuFoNaYi9FO/P6frLXThz60kxhFQP+/V97PnBtngQPlKVtnTdIPShYwgE8ZCsVR7WZ4VCXdfuAIwzLgh826Pc59fhwHThDOMorN+vQDQSADTiVPGQXUYUSPDCCctR2BDKjI5ofe4Ty03HQAVMYzc0abVevGloVYoHKDMqParM5I+ZxWBM4lsjHPOFVASxb7gTObmiWbZ6d0szTTDoA6FDbkHO0pdB05Y2YJ1GkwS3kD/ThuJu47AOrnGcVB2s+5CS0v9AJNsnl9YFnjMOOH11UHQOP0CjsnP/uYx1jOOHwBNFixoN58t66cEMeANoiM4rLGf/tjOQNLoEUi86JZp/1bV78Y+vxAGw1yOydB+1NWluxdAK02FWl8zRPOrg5Ix4ALMcy36vb6HhHuarXN6fIDF6YX+deToSU6WOTctgYuVi/y5YX30G7ibEE2BlyFb+JJ6curOROtnoTXAXBVel5pA+cyis6uO5d+QTIGXK9eJCZKt/dyUPJVTUTE+iuA3+5zI5XTpuOOYzfMbElFCeAf7gthA6fZP3SOtZJmRhAD8K4vRbmQQew2aTyQuHEgn8vvrO8DONh0I7bp0rlLdnVJ7pxluhUbTvEDOIGhl5dmkqpYn6MAHd858yC1flkQwgBUZOCt1uLZykyFzu0oOU32Nbp1QpVJa8R65bGvD+DsBtNoNVsL32xf5VsWqDB0HEe7e/293V5/z93Tv76GoQqyN2m3xhfr2SqaErxwrJ9wIwQM0v9prgAAAABJRU5ErkJggg==',
                          'content' => '',
                        ),
                      ),
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'color' => '#333333',
                    'mode' => 'horizontal',
                    'font-size' => '13px',
                    'font-weight' => 'normal',
                    'font-style' => 'normal',
                    'font-family' => 'Arial',
                    'border-radius' => '3px',
                    'padding' => '15px 0px 15px 0px',
                    'inner-padding' => '0px 20px 0px 0px',
                    'line-height' => '1.6',
                    'text-padding' => '4px 4px 4px 0px',
                    'icon-padding' => '0px',
                    'icon-size' => '25px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_divider',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'border-width' => '1px',
                    'border-style' => 'solid',
                    'border-color' => '#D3CFD8',
                    'padding' => '0px 24px 15px 24px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<font color="#ffffff">© 2024&nbsp;{{business.name}} {{business.address}}</font>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '12px 0px 12px 0px',
                    'align' => 'center',
                    'font-size' => '14px',
                    'line-height' => '20px',
                    'color' => '#908A99',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                3 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<a href="{{link.preference}}" target="_blank" style="text-decoration: underline;"><font color="#0064ff">Update Preference</font></a> . <a href="{{link.unsubscribe}}" target="_blank" style="text-decoration: underline;"><font color="#0064ff">Unsubscribe</font></a>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '10px 25px 10px 25px',
                    'align' => 'center',
                    'font-size' => '10px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
          ),
        ),
      );
    }
    if ( !empty( $templates[ 48 ] ) && empty( $templates[ 48 ][ 'json_content' ] ) ){
      $templates[ 48 ]['json_content'] = array (
        'subject' => 'Welcome to Mail Mint email marketing and automation',
        'subTitle' => 'Nice to meet you!',
        'content' => 
        array (
          'type' => 'page',
          'data' => 
          array (
            'value' => 
            array (
              'breakpoint' => '480px',
              'headAttributes' => '',
              'font-size' => '14px',
              'font-weight' => '400',
              'line-height' => '1.7',
              'headStyles' => 
              array (
              ),
              'fonts' => 
              array (
              ),
              'responsive' => true,
              'font-family' => 'Arial',
              'text-color' => '#000000',
            ),
          ),
          'attributes' => 
          array (
            'background-color' => '#efeeea',
            'width' => '600px',
          ),
          'children' => 
          array (
            0 => 
            array (
              'type' => 'advanced_image',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'height' => 'auto',
                'padding' => '17px 0px 17px 0px',
                'src' => 'data:image/png;base64,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',
                'width' => '100%',
                'container-background-color' => '#F1F1F1',
              ),
              'children' => 
              array (
              ),
            ),
            1 => 
            array (
              'type' => 'advanced_image',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'height' => 'auto',
                'padding' => '0px 0px 0px 0px',
                'src' => $image_path . 'podcast-welcome/hero.jpeg',
              ),
              'children' => 
              array (
              ),
            ),
            2 => 
            array (
              'type' => 'advanced_text',
              'data' => 
              array (
                'value' => 
                array (
                  'content' => '<div style="text-align: center;"><span style="word-spacing: normal;"><font color="#ffffff">Welcome to Creator’s Corner</font></span></div>',
                ),
              ),
              'attributes' => 
              array (
                'padding' => '12px 25px 10px 25px',
                'align' => 'left',
                'font-size' => '30px',
                'font-weight' => '600',
                'container-background-color' => '#000000',
              ),
              'children' => 
              array (
              ),
            ),
            3 => 
            array (
              'type' => 'advanced_text',
              'data' => 
              array (
                'value' => 
                array (
                  'content' => '<div style="text-align: center;"><span style="color: rgb(255, 255, 255); word-spacing: normal;">The podcast that is dedicated to empowering creators, indie hackers, and side hustlers like you! We\'re thrilled to have you on board for this exciting journey of inspiration, knowledge, and growth.</span></div>',
                ),
              ),
              'attributes' => 
              array (
                'padding' => '0px 25px 10px 25px',
                'align' => 'left',
                'container-background-color' => '#000000',
                'font-size' => '16px',
              ),
              'children' => 
              array (
              ),
            ),
            4 => 
            array (
              'type' => 'advanced_button',
              'data' => 
              array (
                'value' => 
                array (
                  'content' => 'Listen Now',
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'font-family' => 'Arial',
                'background-color' => '#00FE61',
                'color' => '#000000',
                'font-weight' => 'normal',
                'font-style' => 'normal',
                'border-radius' => '3px',
                'padding' => '10px 25px 20px 25px',
                'inner-padding' => '10px 25px 10px 25px',
                'font-size' => '16px',
                'line-height' => '1.2',
                'target' => '_blank',
                'vertical-align' => 'middle',
                'border' => 'none',
                'text-align' => 'center',
                'letter-spacing' => 'normal',
                'href' => '#',
                'container-background-color' => '#000000',
              ),
              'children' => 
              array (
              ),
            ),
            5 => 
            array (
              'type' => 'advanced_divider',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'border-width' => '1px',
                'border-style' => 'solid',
                'border-color' => '#C9CCCF',
                'padding' => '10px 0px 10px 0px',
                'container-background-color' => '#000000',
              ),
              'children' => 
              array (
              ),
            ),
            6 => 
            array (
              'type' => 'advanced_text',
              'data' => 
              array (
                'value' => 
                array (
                  'content' => '<div style="text-align: center;"><span style="color: rgb(255, 255, 255); word-spacing: normal;"><b>Check out our best episodes</b></span></div>',
                ),
              ),
              'attributes' => 
              array (
                'padding' => '10px 25px 10px 25px',
                'align' => 'left',
                'container-background-color' => '#000000',
                'font-size' => '30px',
              ),
              'children' => 
              array (
              ),
            ),
            7 => 
            array (
              'type' => 'advanced_section',
              'data' => 
              array (
                'value' => 
                array (
                  'noWrap' => false,
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#000000',
                'padding' => '20px 10px 20px 10px',
                'background-repeat' => 'repeat',
                'background-size' => 'auto',
                'background-position' => 'top center',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '50%',
                    'padding' => '0px 10px 0px 10px',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '0px 0px 0px 0px',
                        'src' => $image_path . '/podcast-welcome/insta-model.webp',
                        'border-radius' => '5px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<font color="#ffffff"><b>#320: Instagram reels to $20Mn beauty lines</b></font>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 25px 10px 0px',
                        'align' => 'left',
                        'font-size' => '16px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<font color="#e0e0e0">Learn the secrets of a successful influencer who created her line of makeup products.</font>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 0px 10px 0px',
                        'align' => 'left',
                        'font-size' => '15px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    3 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<span data-slate-fragment="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" style="white-space: pre;"><font color="#00fe61"><a href="#" target="_blank" style="color: inherit; text-decoration: underline;"><b>Listen Now</b></a></font></span><br>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 25px 10px 0px',
                        'align' => 'left',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '50%',
                    'padding' => '0px 10px 0px 10px',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '0px 0px 0px 0px',
                        'src' => $image_path . '/podcast-welcome/game-dev.webp',
                        'border-radius' => '5px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<font color="#ffffff"><b>#128: Building a viral game that broke the internet</b></font><br>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 25px 10px 0px',
                        'align' => 'left',
                        'font-size' => '16px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<font color="#e0e0e0">Discover how Jack transformed his creative hobbies into a successful side hustle</font><br>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 0px 10px 0px',
                        'align' => 'left',
                        'font-size' => '15px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    3 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<span data-slate-fragment="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" style="white-space: pre;"><font color="#00fe61"><a href="#" target="_blank" style="color: inherit; text-decoration: underline;"><b>Listen Now</b></a></font></span><br>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 25px 10px 0px',
                        'align' => 'left',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
              ),
            ),
            8 => 
            array (
              'type' => 'advanced_section',
              'data' => 
              array (
                'value' => 
                array (
                  'noWrap' => false,
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#000000',
                'padding' => '20px 10px 20px 10px',
                'background-repeat' => 'repeat',
                'background-size' => 'auto',
                'background-position' => 'top center',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '50%',
                    'padding' => '0px 10px 0px 10px',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '0px 0px 0px 0px',
                        'src' => $image_path . '/podcast-welcome/freelancer.jpeg',
                        'border-radius' => '5px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<font color="#ffffff"><b>#23: Thriving as a Creative Freelancer</b></font><br>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 25px 10px 0px',
                        'align' => 'left',
                        'font-size' => '16px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<font color="#e0e0e0">Explore the world of freelance creativity and gain insights from an experienced freelancer</font><br>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 0px 10px 0px',
                        'align' => 'left',
                        'font-size' => '15px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    3 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<span data-slate-fragment="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" style="white-space: pre;"><font color="#00fe61"><a href="#" target="_blank" style="color: inherit; text-decoration: underline;"><b>Listen Now</b></a></font></span><br>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 25px 10px 0px',
                        'align' => 'left',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '50%',
                    'padding' => '0px 10px 0px 10px',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '0px 0px 0px 0px',
                        'src' => $image_path . '/podcast-welcome/store-owner.jpeg',
                        'border-radius' => '5px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<font color="#ffffff"><b>#215: Building an Online Store That Stands Out</b></font><br>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 25px 10px 0px',
                        'align' => 'left',
                        'font-size' => '16px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<font color="#e0e0e0">Discover the secrets to creating a thriving online store and standing out</font><br>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 0px 10px 0px',
                        'align' => 'left',
                        'font-size' => '15px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    3 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<span data-slate-fragment="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" style="white-space: pre;"><font color="#00fe61"><a href="#" target="_blank" style="color: inherit; text-decoration: underline;"><b>Listen Now</b></a></font></span><br>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 25px 10px 0px',
                        'align' => 'left',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
              ),
            ),
            9 => 
            array (
              'type' => 'advanced_divider',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'border-width' => '1px',
                'border-style' => 'solid',
                'border-color' => '#C9CCCF',
                'padding' => '10px 0px 10px 0px',
                'container-background-color' => '#000000',
              ),
              'children' => 
              array (
              ),
            ),
            10 => 
            array (
              'type' => 'advanced_text',
              'data' => 
              array (
                'value' => 
                array (
                  'content' => '<div style="text-align: center;"><span style="color: rgb(255, 255, 255); word-spacing: normal;"><b>Meet your host</b></span></div>',
                ),
              ),
              'attributes' => 
              array (
                'padding' => '10px 25px 10px 25px',
                'align' => 'left',
                'container-background-color' => '#000000',
                'font-size' => '30px',
              ),
              'children' => 
              array (
              ),
            ),
            11 => 
            array (
              'type' => 'advanced_section',
              'data' => 
              array (
                'value' => 
                array (
                  'noWrap' => false,
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#000000',
                'padding' => '0px 20px 20px 20px',
                'background-repeat' => 'repeat',
                'background-size' => 'auto',
                'background-position' => 'top center',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '50%',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '0px 0px 0px 0px',
                        'src' => $image_path . '/podcast-welcome/sophia.webp',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '50%',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<font color="#ffffff">Sophia Ramirez</font>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 5px 10px 25px',
                        'align' => 'left',
                        'font-size' => '28px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<font color="#e0e0e0">The charismatic and knowledgeable host of the podcast, is a seasoned entrepreneur with a genuine passion for helping others succeed in their creative pursuits and side hustles. With a warm and engaging personality, Sophia effortlessly connects with her listeners, making them feel like they\'re having a conversation with a trusted friend.</font>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 5px 0px 25px',
                        'align' => 'left',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
              ),
            ),
            12 => 
            array (
              'type' => 'advanced_divider',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'border-width' => '1px',
                'border-style' => 'solid',
                'border-color' => '#C9CCCF',
                'padding' => '10px 0px 0px 0px',
                'container-background-color' => '#000000',
              ),
              'children' => 
              array (
              ),
            ),
            13 => 
            array (
              'type' => 'advanced_footer',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#000000',
                'background-position' => 'center center',
                'mode' => 'fluid-height',
                'padding' => '0px 0px 0px 0px',
                'vertical-align' => 'top',
                'background-url' => '',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_social',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'elements' => 
                      array (
                        0 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAMAAAC7IEhfAAAAclBMVEUAAAA7WZg7Wpg6WZg8WJdAU586Wpg6Wpc7WZg8WZk6WZg7WZg6WZg7WZY5WJc6Wpc7WJg7WZk7W5Y6WpU7WZj////m6vKdrMvO1eW2wdhUbaWEl7+El75sgrKpt9KRosV4jbhTbqXy9fiQocVsgrFHY58FMJF5AAAAFHRSTlMAv++AIBCfQJBQ39+wcHBg0M9wMJn76TsAAAEYSURBVDjLjdTZbsMgEEDRYcziPU2LCa3rNOny/79YnESaDAaZ+2gdgQEB8JR51SLUV42CfEagpcQhw5rWRnUpKoWliMrNcGjTVdxVNlu94yhNrrFRH6G/7ewSmVr8tPZOX8wD8vWeAopgp27uwNx1IhhN3jJ4TkFU25X4Fbl5npd4N3sO3QrPNgoDtAl4snEGTBkc+aH8ej+tOe/9F4Oa/+LnRHHYgcjBC4OYh4tlcXhx7oa+nXPXGJatGkGXwSPUZVBAUwYrUKVHCKIEdgAwlkAdoMICKOmu5iHd2HYPorxDswcHeDTmIX9Uno/Hu9DPs3tREEmKu7LnTKvMe8vDATbJKjGchFRyYKNizRjvbeiPGEzb1wZY/0BgYWSlhMOpAAAAAElFTkSuQmCC',
                          'content' => '',
                        ),
                        1 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => 'data:image/png;base64,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',
                          'content' => '',
                        ),
                        2 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . $twitter,
                          'content' => '',
                        ),
                      ),
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'color' => '#333333',
                    'mode' => 'horizontal',
                    'font-size' => '13px',
                    'font-weight' => 'normal',
                    'font-style' => 'normal',
                    'font-family' => 'Arial',
                    'border-radius' => '3px',
                    'padding' => '15px 0px 15px 0px',
                    'inner-padding' => '0px 20px 0px 0px',
                    'line-height' => '1.6',
                    'text-padding' => '4px 4px 4px 0px',
                    'icon-padding' => '0px',
                    'icon-size' => '25px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_divider',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'border-width' => '1px',
                    'border-style' => 'solid',
                    'border-color' => '#D3CFD8',
                    'padding' => '0px 0px 15px 0px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<font color="#ffffff">{{business.name}}</font>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '10px 25px 10px 25px',
                    'align' => 'center',
                    'font-size' => '16px',
                    'line-height' => '15px',
                    'font-weight' => '500',
                    'font-family' => 'Arial',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                3 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<font color="#ffffff">© 2024&nbsp;{{business.name}} {{business.address}}</font>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '12px 0px 12px 0px',
                    'align' => 'center',
                    'font-size' => '14px',
                    'line-height' => '20px',
                    'color' => '#908A99',
                    'font-family' => 'Arial',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                4 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<a href="{{link.preference}}" target="_blank" style="text-decoration: underline;"><font color="#0064ff">Update Preference</font></a> . <a href="{{link.unsubscribe}}" target="_blank" style="text-decoration: underline;"><font color="#0064ff">Unsubscribe</font></a>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '10px 25px 20px 25px',
                    'align' => 'center',
                    'font-size' => '10px',
                    'font-family' => 'Arial',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
          ),
        ),
      );
    }
    if ( !empty( $templates[ 46 ] ) && empty( $templates[ 46 ][ 'json_content' ] ) ){
      $templates[ 46 ]['json_content'] = array (
        'subject' => 'Welcome to Mail Mint email marketing and automation',
        'subTitle' => 'Nice to meet you!',
        'content' => 
        array (
          'type' => 'page',
          'data' => 
          array (
            'value' => 
            array (
              'breakpoint' => '480px',
              'headAttributes' => '',
              'font-size' => '14px',
              'font-weight' => '400',
              'line-height' => '1.7',
              'headStyles' => 
              array (
              ),
              'fonts' => 
              array (
              ),
              'responsive' => true,
              'font-family' => 'Arial',
              'text-color' => '#000000',
            ),
          ),
          'attributes' => 
          array (
            'background-color' => '#efeeea',
            'width' => '600px',
          ),
          'children' => 
          array (
            0 => 
            array (
              'type' => 'advanced_image',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'height' => 'auto',
                'padding' => '17px 0px 17px 0px',
                'src' => 'data:image/png;base64,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',
                'width' => '100%',
                'container-background-color' => '#b6ceea',
              ),
              'children' => 
              array (
              ),
            ),
            1 => 
            array (
              'type' => 'advanced_text',
              'data' => 
              array (
                'value' => 
                array (
                  'content' => '<div style="text-align: center;"><span style="word-spacing: normal;"><font color="#333333">3 Ways to Create with BookWright</font></span></div>',
                ),
              ),
              'attributes' => 
              array (
                'padding' => '10px 25px 10px 25px',
                'align' => 'left',
                'container-background-color' => '#b6ceea',
                'font-size' => '40px',
                'line-height' => '1.5',
              ),
              'children' => 
              array (
              ),
            ),
            2 => 
            array (
              'type' => 'advanced_text',
              'data' => 
              array (
                'value' => 
                array (
                  'content' => '<div style="text-align: center;"><span style="word-spacing: normal;"><font color="#000333">Every creative project is different. Our free desktop publishing software gives you the right combination of built-in features and design flexibility so you can create your dream project. Discover the power of BookWright and try something new today.</font></span></div>',
                ),
              ),
              'attributes' => 
              array (
                'padding' => '10px 25px 10px 25px',
                'align' => 'left',
                'font-size' => '16px',
                'container-background-color' => '#b6ceea',
              ),
              'children' => 
              array (
              ),
            ),
            3 => 
            array (
              'type' => 'advanced_button',
              'data' => 
              array (
                'value' => 
                array (
                  'content' => 'DOWNLOAD BOOKWRIGHT',
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'font-family' => 'Arial',
                'background-color' => '#FFFFFF',
                'color' => '#000000',
                'font-weight' => 'normal',
                'font-style' => 'normal',
                'border-radius' => '3px',
                'padding' => '20px 5px 30px 5px',
                'inner-padding' => '10px 25px 10px 25px',
                'font-size' => '16px',
                'line-height' => '1.2',
                'target' => '_blank',
                'vertical-align' => 'middle',
                'border' => 'none',
                'text-align' => 'center',
                'letter-spacing' => 'normal',
                'href' => '#',
                'container-background-color' => '#b6ceea',
              ),
              'children' => 
              array (
              ),
            ),
            4 => 
            array (
              'type' => 'advanced_image',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'height' => 'auto',
                'padding' => '0px 0px 0px 0px',
                'src' => $image_path . 'download-emails-1/hero.jpg',
                'width' => '',
              ),
              'children' => 
              array (
              ),
            ),
            5 => 
            array (
              'type' => 'advanced_section',
              'data' => 
              array (
                'value' => 
                array (
                  'noWrap' => false,
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#ffffff',
                'padding' => '10px 0px 10px 0px',
                'background-repeat' => 'repeat',
                'background-size' => 'auto',
                'background-position' => 'top center',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '30%',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><span style="color: rgb(182, 206, 234); word-spacing: normal;">01</span></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 25px 10px 25px',
                        'align' => 'left',
                        'font-size' => '80px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '50%',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<font color="#0365d0"><b>MAKE A NOTEBOOK</b></font>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 5px 10px 5px',
                        'align' => 'left',
                        'font-size' => '16px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<font color="#585858">Simply choose your size, page count, and style, and you’ve got a custom-made notebook or journal ready to go.</font><br>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 5px 0px 5px',
                        'align' => 'left',
                        'font-size' => '16px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
              ),
            ),
            6 => 
            array (
              'type' => 'advanced_section',
              'data' => 
              array (
                'value' => 
                array (
                  'noWrap' => false,
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#ffffff',
                'padding' => '10px 0px 10px 0px',
                'background-repeat' => 'repeat',
                'background-size' => 'auto',
                'background-position' => 'top center',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '30%',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><span style="color: rgb(182, 206, 234); word-spacing: normal;">02</span></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 25px 10px 25px',
                        'align' => 'left',
                        'font-size' => '80px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '50%',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<font color="#0365d0"><b>USE A FREE TEMPLATE</b></font><br>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 5px 10px 5px',
                        'align' => 'left',
                        'font-size' => '16px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<font color="#585858">This feature is perfect for cookbooks. Lay out your content quickly and easily using a professionally designed template.</font><br>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 5px 0px 5px',
                        'align' => 'left',
                        'font-size' => '16px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
              ),
            ),
            7 => 
            array (
              'type' => 'advanced_section',
              'data' => 
              array (
                'value' => 
                array (
                  'noWrap' => false,
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#ffffff',
                'padding' => '10px 0px 10px 0px',
                'background-repeat' => 'repeat',
                'background-size' => 'auto',
                'background-position' => 'top center',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '30%',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><span style="color: rgb(182, 206, 234); word-spacing: normal;">03</span></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 25px 10px 25px',
                        'align' => 'left',
                        'font-size' => '80px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '50%',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<font color="#0365d0"><b>CREATE WALL ART</b></font><br>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 5px 10px 5px',
                        'align' => 'left',
                        'font-size' => '16px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<font color="#585858">Choose a favorite photo, then transform that image into a beautiful, high-quality print that fits your style.</font><br>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 5px 0px 5px',
                        'align' => 'left',
                        'font-size' => '16px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
              ),
            ),
            8 => 
            array (
              'type' => 'advanced_button',
              'data' => 
              array (
                'value' => 
                array (
                  'content' => 'DOWNLOAD BOOKWRIGHT',
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'font-family' => 'Arial',
                'background-color' => '#000000',
                'color' => '#ffffff',
                'font-weight' => 'normal',
                'font-style' => 'normal',
                'border-radius' => '3px',
                'padding' => '10px 5px 30px 5px',
                'inner-padding' => '10px 25px 10px 25px',
                'font-size' => '16px',
                'line-height' => '1.2',
                'target' => '_blank',
                'vertical-align' => 'middle',
                'border' => 'none',
                'text-align' => 'center',
                'letter-spacing' => 'normal',
                'href' => '#',
                'container-background-color' => '#FFFFFF',
              ),
              'children' => 
              array (
              ),
            ),
            9 => 
            array (
              'type' => 'advanced_section',
              'data' => 
              array (
                'value' => 
                array (
                  'noWrap' => false,
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#efeeea',
                'padding' => '0px 0px 0px 0px',
                'background-repeat' => 'repeat',
                'background-size' => 'auto',
                'background-position' => 'top center',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '50%',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '0px 0px 0px 0px',
                        'src' => $image_path . 'download-emails-1/book.jpg',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '50%',
                    'padding' => '0px 0px 0px 0px',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><b style="word-spacing: normal;"><font color="#000333">DAD’S GIFT RUNNING LATE?</font></b></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '25px 25px 10px 25px',
                        'align' => 'left',
                        'font-size' => '16px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><span style="word-spacing: normal;">Dad will love his gift no matter when it arrives. Making a photo book? Save the day with an ebook until he can unwrap the real thing.</span></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 25px 10px 25px',
                        'align' => 'left',
                        'font-size' => '16px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><span style="word-spacing: normal;"><a href="#" target="_blank" style="color: inherit; text-decoration: underline;">MAKE YOUR GIFT</a></span></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 25px 10px 25px',
                        'align' => 'left',
                        'font-size' => '18px',
                        'font-weight' => '500',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
              ),
            ),
            10 => 
            array (
              'type' => 'advanced_footer',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#000000',
                'background-position' => 'center center',
                'mode' => 'fluid-height',
                'padding' => '0px 0px 0px 0px',
                'vertical-align' => 'top',
                'background-url' => '',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_social',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'elements' => 
                      array (
                        0 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAMAAAC7IEhfAAAAclBMVEUAAAA7WZg7Wpg6WZg8WJdAU586Wpg6Wpc7WZg8WZk6WZg7WZg6WZg7WZY5WJc6Wpc7WJg7WZk7W5Y6WpU7WZj////m6vKdrMvO1eW2wdhUbaWEl7+El75sgrKpt9KRosV4jbhTbqXy9fiQocVsgrFHY58FMJF5AAAAFHRSTlMAv++AIBCfQJBQ39+wcHBg0M9wMJn76TsAAAEYSURBVDjLjdTZbsMgEEDRYcziPU2LCa3rNOny/79YnESaDAaZ+2gdgQEB8JR51SLUV42CfEagpcQhw5rWRnUpKoWliMrNcGjTVdxVNlu94yhNrrFRH6G/7ewSmVr8tPZOX8wD8vWeAopgp27uwNx1IhhN3jJ4TkFU25X4Fbl5npd4N3sO3QrPNgoDtAl4snEGTBkc+aH8ej+tOe/9F4Oa/+LnRHHYgcjBC4OYh4tlcXhx7oa+nXPXGJatGkGXwSPUZVBAUwYrUKVHCKIEdgAwlkAdoMICKOmu5iHd2HYPorxDswcHeDTmIX9Uno/Hu9DPs3tREEmKu7LnTKvMe8vDATbJKjGchFRyYKNizRjvbeiPGEzb1wZY/0BgYWSlhMOpAAAAAElFTkSuQmCC',
                          'content' => '',
                        ),
                        1 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => 'data:image/png;base64,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',
                          'content' => '',
                        ),
                        2 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => 'data:image/png;base64,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',
                          'content' => '',
                        ),
                      ),
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'color' => '#333333',
                    'mode' => 'horizontal',
                    'font-size' => '13px',
                    'font-weight' => 'normal',
                    'font-style' => 'normal',
                    'font-family' => 'Arial',
                    'border-radius' => '3px',
                    'padding' => '15px 0px 15px 0px',
                    'inner-padding' => '0px 20px 0px 0px',
                    'line-height' => '1.6',
                    'text-padding' => '4px 4px 4px 0px',
                    'icon-padding' => '0px',
                    'icon-size' => '25px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_divider',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'border-width' => '1px',
                    'border-style' => 'solid',
                    'border-color' => '#D3CFD8',
                    'padding' => '0px 24px 15px 24px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<font color="#ffffff">{{business.name}}</font><br>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '10px 25px 10px 25px',
                    'align' => 'center',
                    'font-size' => '16px',
                    'line-height' => '15px',
                    'font-weight' => '500',
                    'font-family' => 'Arial',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                3 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<font color="#ffffff">© 2024&nbsp;{{business.name}} {{business.address}}</font>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '12px 0px 12px 0px',
                    'align' => 'center',
                    'font-size' => '14px',
                    'line-height' => '20px',
                    'color' => '#908A99',
                    'font-family' => 'Arial',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                4 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<a href="{{link.preference}}" target="_blank" style="text-decoration: underline;"><font color="#0064ff">Update Preference</font></a> . <a href="{{link.unsubscribe}}" target="_blank" style="text-decoration: underline;"><font color="#0064ff">Unsubscribe</font></a>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '10px 25px 20px 25px',
                    'align' => 'center',
                    'font-size' => '10px',
                    'font-family' => 'Arial',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
          ),
        ),
      );
    }
    if ( !empty( $templates[ 49 ] ) && empty( $templates[ 49 ][ 'json_content' ] ) ){
      $templates[ 49 ]['json_content'] = array (
        'subject' => 'Welcome to Mail Mint email marketing and automation',
        'subTitle' => 'Nice to meet you!',
        'content' => 
        array (
          'type' => 'page',
          'data' => 
          array (
            'value' => 
            array (
              'breakpoint' => '480px',
              'headAttributes' => '',
              'font-size' => '14px',
              'font-weight' => '400',
              'line-height' => '1.7',
              'headStyles' => 
              array (
              ),
              'fonts' => 
              array (
              ),
              'responsive' => true,
              'font-family' => 'Arial',
              'text-color' => '#000000',
            ),
          ),
          'attributes' => 
          array (
            'background-color' => '#efeeea',
            'width' => '600px',
          ),
          'children' => 
          array (
            0 => 
            array (
              'type' => 'advanced_image',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'height' => 'auto',
                'padding' => '17px 0px 17px 0px',
                'src' => 'data:image/png;base64,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',
                'width' => '100%',
                'container-background-color' => '#FFFDED',
              ),
              'children' => 
              array (
              ),
            ),
            1 => 
            array (
              'type' => 'advanced_hero',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#ffffff',
                'background-position' => 'center center',
                'mode' => 'fluid-height',
                'padding' => '40px 0px 40px 0px',
                'vertical-align' => 'top',
                'background-url' => $image_path . '/summer-collection/hero.webp',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<font color="#ffffff">SA</font><div><font color="#ffffff">LE</font></div>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '0px 0px 0px 0px',
                    'align' => 'center',
                    'color' => '#000000',
                    'font-size' => '150px',
                    'line-height' => '0.9',
                    'font-weight' => '800',
                    'font-family' => 'Arial',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<font color="#ffffff"><i>15% off on everything</i></font>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'background-color' => '#414141',
                    'color' => '#2B2D38',
                    'font-weight' => 'normal',
                    'border-radius' => '3px',
                    'padding' => '14px 0px 30px 14px',
                    'inner-padding' => '10px 25px 10px 25px',
                    'line-height' => '30px',
                    'target' => '_blank',
                    'vertical-align' => 'middle',
                    'border' => 'none',
                    'text-align' => 'center',
                    'href' => '#',
                    'font-size' => '32px',
                    'font-family' => 'Arial',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                2 => 
                array (
                  'type' => 'button',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'Start Shopping',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'background-color' => '#273616',
                    'color' => '#ffffff',
                    'font-size' => '16px',
                    'font-weight' => 'normal',
                    'border-radius' => '5px',
                    'padding' => '0px 0px 0px 0px',
                    'inner-padding' => '16px 30px 16px 30px',
                    'line-height' => '120%',
                    'target' => '_blank',
                    'vertical-align' => 'middle',
                    'border' => 'none',
                    'text-align' => 'center',
                    'href' => '#',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
            2 => 
            array (
              'type' => 'advanced_text',
              'data' => 
              array (
                'value' => 
                array (
                  'content' => '<div style="text-align: center;"><span style="word-spacing: normal;"><font color="#273616">✦ Summer Sale Collection ✦</font></span></div>',
                ),
              ),
              'attributes' => 
              array (
                'padding' => '20px 25px 0px 25px',
                'align' => 'left',
                'font-size' => '24px',
                'container-background-color' => '#FFFDED',
                'line-height' => '1',
              ),
              'children' => 
              array (
              ),
            ),
            3 => 
            array (
              'type' => 'advanced_section',
              'data' => 
              array (
                'value' => 
                array (
                  'noWrap' => false,
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#FFFDED',
                'padding' => '20px 10px 20px 10px',
                'background-repeat' => 'repeat',
                'background-size' => 'auto',
                'background-position' => 'top center',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '50%',
                    'padding' => '0px 10px 0px 10px',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '0px 0px 0px 0px',
                        "src" => $image_path . '/summer-collection/blue-summer-dress.png',
                      ),
                      'children' => array(),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><span style="color: rgb(39, 54, 22); word-spacing: normal;">Blue Summer Dress</span></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 0px 0px 0px',
                        'align' => 'left',
                        'font-size' => '18px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><span style="word-spacing: normal;"><b>$49.99 </b><strike>$</strike></span><span style="white-space: pre; text-align: left; word-spacing: normal;"><strike>79.99</strike></span></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 0px 10px 0px',
                        'align' => 'left',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '50%',
                    'padding' => '0px 10px 0px 10px',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '0px 0px 0px 0px',
                        "src" => $image_path . '/summer-collection/orange-sunscreen.webp',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><font color="#273616">Orange Sunscreen</font><br></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 0px 0px 0px',
                        'align' => 'left',
                        'font-size' => '18px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><span style="word-spacing: normal;"><b>$89.99 </b><strike>$9</strike></span><span style="white-space: pre; text-align: left; word-spacing: normal;"><strike>9.99</strike></span></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 0px 10px 0px',
                        'align' => 'left',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '50%',
                    'padding' => '0px 10px 0px 10px',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '0px 0px 0px 0px',
                        "src" => $image_path . '/summer-collection/straw-sun-hat.png',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><font color="#273616">Straw Sun Hat</font><br></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 0px 0px 0px',
                        'align' => 'left',
                        'font-size' => '18px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><span style="word-spacing: normal;"><b>$29.99 </b><strike>$3</strike></span><span style="white-space: pre; text-align: left; word-spacing: normal;"><strike>9.99</strike></span></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 0px 10px 0px',
                        'align' => 'left',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                3 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '50%',
                    'padding' => '0px 10px 0px 10px',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '0px 0px 0px 0px',
                        "src" => $image_path . '/summer-collection/sunglasses.png',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><font color="#273616">Sunglasses</font><br></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 0px 0px 0px',
                        'align' => 'left',
                        'font-size' => '18px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><span style="word-spacing: normal;"><b>$15.99 </b><strike>$2</strike></span><span style="white-space: pre; text-align: left; word-spacing: normal;"><strike>9.99</strike></span></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 0px 10px 0px',
                        'align' => 'left',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
              ),
            ),
            4 => 
            array (
              'type' => 'advanced_divider',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'border-width' => '1px',
                'border-style' => 'solid',
                'border-color' => '#C9CCCF',
                'padding' => '10px 0px 10px 0px',
                'container-background-color' => '#FFFDED',
              ),
              'children' => 
              array (
              ),
            ),
            5 => 
            array (
              'type' => 'advanced_hero',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#FFFDED',
                'background-position' => 'center center',
                'mode' => 'fluid-height',
                'padding' => '20px 20px 20px 20px',
                'vertical-align' => 'top',
                'background-url' => '',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_image',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'height' => 'auto',
                    'padding' => '0px 0px 0px 10px',
                    "src" => $image_path . '/summer-collection/embrace-cloths.webp',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'Embrace Effortless Bohemian Style',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '10px 25px 0px 25px',
                    'align' => 'center',
                    'color' => '#000000',
                    'font-size' => '24px',
                    'line-height' => '45px',
                    'font-weight' => '600',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                2 => 
                array (
                  'type' => 'text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<font color="#5f6c37">Discover the enchanting allure of our latest Boho Girl collection, where vibrant patterns and flowing silhouettes intertwine to create a sense of whimsical freedom.</font>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'background-color' => '#414141',
                    'color' => '#000000',
                    'font-weight' => 'normal',
                    'border-radius' => '3px',
                    'padding' => '0px 5px 10px 5px',
                    'inner-padding' => '10px 25px 10px 25px',
                    'line-height' => '1.5',
                    'target' => '_blank',
                    'vertical-align' => 'middle',
                    'border' => 'none',
                    'text-align' => 'center',
                    'href' => '#',
                    'font-size' => '16px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                3 => 
                array (
                  'type' => 'button',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'Find Your Style',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'background-color' => '#273616',
                    'color' => '#ffffff',
                    'font-size' => '16px',
                    'font-weight' => 'normal',
                    'border-radius' => '3px',
                    'padding' => '10px 25px 10px 25px',
                    'inner-padding' => '10px 25px 10px 25px',
                    'line-height' => '120%',
                    'target' => '_blank',
                    'vertical-align' => 'middle',
                    'border' => 'none',
                    'text-align' => 'center',
                    'href' => '#',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
            6 => 
            array (
              'type' => 'advanced_footer',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#FFFDED',
                'background-position' => 'center center',
                'mode' => 'fluid-height',
                'padding' => '0px 0px 0px 0px',
                'vertical-align' => 'top',
                'background-url' => '',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_social',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'elements' => 
                      array (
                        0 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAMAAAC7IEhfAAAAclBMVEUAAAA7WZg7Wpg6WZg8WJdAU586Wpg6Wpc7WZg8WZk6WZg7WZg6WZg7WZY5WJc6Wpc7WJg7WZk7W5Y6WpU7WZj////m6vKdrMvO1eW2wdhUbaWEl7+El75sgrKpt9KRosV4jbhTbqXy9fiQocVsgrFHY58FMJF5AAAAFHRSTlMAv++AIBCfQJBQ39+wcHBg0M9wMJn76TsAAAEYSURBVDjLjdTZbsMgEEDRYcziPU2LCa3rNOny/79YnESaDAaZ+2gdgQEB8JR51SLUV42CfEagpcQhw5rWRnUpKoWliMrNcGjTVdxVNlu94yhNrrFRH6G/7ewSmVr8tPZOX8wD8vWeAopgp27uwNx1IhhN3jJ4TkFU25X4Fbl5npd4N3sO3QrPNgoDtAl4snEGTBkc+aH8ej+tOe/9F4Oa/+LnRHHYgcjBC4OYh4tlcXhx7oa+nXPXGJatGkGXwSPUZVBAUwYrUKVHCKIEdgAwlkAdoMICKOmu5iHd2HYPorxDswcHeDTmIX9Uno/Hu9DPs3tREEmKu7LnTKvMe8vDATbJKjGchFRyYKNizRjvbeiPGEzb1wZY/0BgYWSlhMOpAAAAAElFTkSuQmCC',
                          'content' => '',
                        ),
                        1 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => 'data:image/png;base64,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',
                          'content' => '',
                        ),
                        2 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . $twitter,
                          'content' => '',
                        ),
                      ),
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'color' => '#333333',
                    'mode' => 'horizontal',
                    'font-size' => '13px',
                    'font-weight' => 'normal',
                    'font-style' => 'normal',
                    'font-family' => 'Arial',
                    'border-radius' => '3px',
                    'padding' => '15px 0px 15px 0px',
                    'inner-padding' => '0px 20px 0px 0px',
                    'line-height' => '1.6',
                    'text-padding' => '4px 4px 4px 0px',
                    'icon-padding' => '0px',
                    'icon-size' => '25px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_divider',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'border-width' => '1px',
                    'border-style' => 'solid',
                    'border-color' => '#D3CFD8',
                    'padding' => '0px 24px 15px 24px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<font color="#5f6c37">{{business.name}}</font><br>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '12px 0px 0px 0px',
                    'align' => 'center',
                    'font-size' => '14px',
                    'line-height' => '20px',
                    'color' => '#908A99',
                    'font-family' => 'Arial',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                3 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<font color="#5f6c37">© 2024 {{business.name}} {{business.address}}</font>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '12px 0px 12px 0px',
                    'align' => 'center',
                    'font-size' => '14px',
                    'line-height' => '20px',
                    'color' => '#908A99',
                    'font-family' => 'Arial',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                4 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<a href="{{link.preference}}" target="_blank" style="text-decoration: underline;"><font color="#0064ff">Update Preference</font></a> . <a href="{{link.unsubscribe}}" target="_blank" style="text-decoration: underline;"><font color="#0064ff">Unsubscribe</font></a>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '10px 25px 20px 25px',
                    'align' => 'center',
                    'font-size' => '10px',
                    'font-family' => 'Arial',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
          ),
        ),
      );
    }
    if ( !empty( $templates[ 50 ] ) && empty( $templates[ 50 ][ 'json_content' ] ) ){
      $templates[ 50 ]['json_content'] = array (
        'content' => 
        array (
          'type' => 'page',
          'data' => 
          array (
            'value' => 
            array (
              'breakpoint' => '480px',
              'headAttributes' => '',
              'font-size' => '14px',
              'font-weight' => '400',
              'line-height' => '1.7',
              'headStyles' => 
              array (
              ),
              'fonts' => 
              array (
              ),
              'responsive' => true,
              'font-family' => 'Arial',
              'text-color' => '#000000',
            ),
          ),
          'attributes' => 
          array (
            'background-color' => '#efeeea',
            'width' => '600px',
          ),
          'children' => 
          array (
            0 => 
            array (
              'type' => 'advanced_image',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'height' => 'auto',
                'padding' => '17px 0px 17px 0px',
                'src' => 'data:image/png;base64,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',
                'width' => '100%',
                'container-background-color' => '#FFFDED',
              ),
              'children' => 
              array (
              ),
            ),
            1 => 
            array (
              'type' => 'advanced_hero',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#FFFDED',
                'background-position' => 'center center',
                'mode' => 'fluid-height',
                'padding' => '30px 0px 30px 0px',
                'vertical-align' => 'top',
                'background-url' => '',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<div><font color="#5f6c37">GREETINGS FROM</font></div>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'background-color' => '#414141',
                    'color' => '#000000',
                    'font-weight' => 'normal',
                    'border-radius' => '3px',
                    'padding' => '0px 5px 0px 5px',
                    'inner-padding' => '10px 25px 10px 25px',
                    'line-height' => '1.5',
                    'target' => '_blank',
                    'vertical-align' => 'middle',
                    'border' => 'none',
                    'text-align' => 'center',
                    'href' => '#',
                    'font-size' => '14px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<h1 style="box-sizing: border-box; border-width: 0px; border-style: solid; border-color: rgb(207, 212, 217); -webkit-font-smoothing: antialiased; font-family: Charter, Georgia, Times, &quot;Times New Roman&quot;, serif; line-height: 1; margin-top: 0px; margin-bottom: 16px; font-size: 64px; letter-spacing: 0px; margin-right: 0px !important; margin-left: 0px !important; padding: 0px !important;"><font color="#5f6c37">Serene</font></h1>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'background-color' => '#414141',
                    'color' => '#000000',
                    'font-weight' => 'normal',
                    'border-radius' => '3px',
                    'padding' => '10px 5px 0px 5px',
                    'inner-padding' => '10px 25px 10px 25px',
                    'line-height' => '1.5',
                    'target' => '_blank',
                    'vertical-align' => 'middle',
                    'border' => 'none',
                    'text-align' => 'center',
                    'href' => '#',
                    'font-size' => '64px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<div style="text-align: center;"><span style="word-spacing: normal;"><font color="#5f6c37">Welcome to our vibrant community of free spirits and fashion enthusiasts! We are thrilled to have you join us on this exciting boho journey. Get ready to immerse yourself in a world of bohemian fashion inspiration, exclusive offers, and more!</font></span></div>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '10px 25px 10px 25px',
                    'align' => 'left',
                    'font-size' => '18px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                3 => 
                array (
                  'type' => 'button',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'Find Your Style',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'background-color' => '#273616',
                    'color' => '#ffffff',
                    'font-size' => '20px',
                    'font-weight' => 'normal',
                    'border-radius' => '0px',
                    'padding' => '10px 25px 10px 25px',
                    'inner-padding' => '10px 25px 10px 25px',
                    'line-height' => '120%',
                    'target' => '_blank',
                    'vertical-align' => 'middle',
                    'border' => 'none',
                    'text-align' => 'center',
                    'href' => '#',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                4 => 
                array (
                  'type' => 'advanced_image',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'height' => 'auto',
                    'padding' => '20px 80px 0px 80px',
                    'src' => $image_path . '/summer-collection/fashion-model.png',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
            2 => 
            array (
              'type' => 'advanced_text',
              'data' => 
              array (
                'value' => 
                array (
                  'content' => '<div style="text-align: center;"><h1 style="box-sizing: border-box; border-width: 0px; border-style: solid; border-color: rgb(207, 212, 217); -webkit-font-smoothing: antialiased; font-family: Charter, Georgia, Times, &quot;Times New Roman&quot;, serif; line-height: 1; color: rgb(39, 54, 22); margin: 0px; font-size: 24px; letter-spacing: 0px;"><span style="box-sizing: border-box; border-width: 0px; border-style: solid; border-color: rgb(207, 212, 217); -webkit-font-smoothing: antialiased; font-size: 16px;">✦</span>&nbsp;Latest Collection&nbsp;<span style="box-sizing: border-box; border-width: 0px; border-style: solid; border-color: rgb(207, 212, 217); -webkit-font-smoothing: antialiased; font-size: 16px;">✦</span></h1></div>',
                ),
              ),
              'attributes' => 
              array (
                'padding' => '20px 25px 0px 25px',
                'align' => 'left',
                'font-size' => '24px',
                'container-background-color' => '#FFFDED',
                'line-height' => '1',
              ),
              'children' => 
              array (
              ),
            ),
            3 => 
            array (
              'type' => 'advanced_section',
              'data' => 
              array (
                'value' => 
                array (
                  'noWrap' => false,
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#FFFDED',
                'padding' => '20px 10px 20px 10px',
                'background-repeat' => 'repeat',
                'background-size' => 'auto',
                'background-position' => 'top center',
                'border' => 'none',
                'direction' => 'ltr',
                'text-align' => 'center',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '50%',
                    'padding' => '0px 10px 0px 10px',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '0px 0px 0px 0px',
                        "src" => $image_path . '/summer-collection/blue-summer-dress.png',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><span style="color: rgb(39, 54, 22); word-spacing: normal;">Blue Summer Dress</span></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 0px 0px 0px',
                        'align' => 'left',
                        'font-size' => '18px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><span style="word-spacing: normal;"><b>$49.99 </b><strike>$</strike></span><span style="white-space: pre; text-align: left; word-spacing: normal;"><strike>79.99</strike></span></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 0px 10px 0px',
                        'align' => 'left',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_column',
                  'attributes' => 
                  array (
                    'width' => '50%',
                    'padding' => '0px 10px 0px 10px',
                  ),
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'children' => 
                  array (
                    0 => 
                    array (
                      'type' => 'advanced_image',
                      'data' => 
                      array (
                        'value' => 
                        array (
                        ),
                      ),
                      'attributes' => 
                      array (
                        'align' => 'center',
                        'height' => 'auto',
                        'padding' => '0px 0px 0px 0px',
                        "src" => $image_path . '/summer-collection/orange-sunscreen.webp',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    1 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><font color="#273616">Orange Sunscreen</font><br></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '10px 0px 0px 0px',
                        'align' => 'left',
                        'font-size' => '18px',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                    2 => 
                    array (
                      'type' => 'advanced_text',
                      'data' => 
                      array (
                        'value' => 
                        array (
                          'content' => '<div style="text-align: center;"><span style="word-spacing: normal;"><b>$89.99 </b><strike>$9</strike></span><span style="white-space: pre; text-align: left; word-spacing: normal;"><strike>9.99</strike></span></div>',
                        ),
                      ),
                      'attributes' => 
                      array (
                        'padding' => '0px 0px 10px 0px',
                        'align' => 'left',
                      ),
                      'children' => 
                      array (
                      ),
                    ),
                  ),
                ),
              ),
            ),
            4 => 
            array (
              'type' => 'advanced_divider',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'align' => 'center',
                'border-width' => '1px',
                'border-style' => 'solid',
                'border-color' => '#C9CCCF',
                'padding' => '10px 0px 10px 0px',
                'container-background-color' => '#FFFDED',
              ),
              'children' => 
              array (
              ),
            ),
            5 => 
            array (
              'type' => 'advanced_hero',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#FFFDED',
                'background-position' => 'center center',
                'mode' => 'fluid-height',
                'padding' => '20px 20px 20px 20px',
                'vertical-align' => 'top',
                'background-url' => '',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_image',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'height' => 'auto',
                    'padding' => '0px 0px 0px 10px',
                    "src" => $image_path . '/summer-collection/embrace-cloths.webp',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'Embrace Effortless Bohemian Style',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '10px 25px 0px 25px',
                    'align' => 'center',
                    'color' => '#000000',
                    'font-size' => '24px',
                    'line-height' => '45px',
                    'font-weight' => '600',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                2 => 
                array (
                  'type' => 'text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<font color="#5f6c37">Discover the enchanting allure of our latest Boho Girl collection, where vibrant patterns and flowing silhouettes intertwine to create a sense of whimsical freedom.</font>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'background-color' => '#414141',
                    'color' => '#000000',
                    'font-weight' => 'normal',
                    'border-radius' => '3px',
                    'padding' => '0px 5px 10px 5px',
                    'inner-padding' => '10px 25px 10px 25px',
                    'line-height' => '1.5',
                    'target' => '_blank',
                    'vertical-align' => 'middle',
                    'border' => 'none',
                    'text-align' => 'center',
                    'href' => '#',
                    'font-size' => '16px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                3 => 
                array (
                  'type' => 'button',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => 'Find Your Style',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'background-color' => '#273616',
                    'color' => '#ffffff',
                    'font-size' => '16px',
                    'font-weight' => 'normal',
                    'border-radius' => '3px',
                    'padding' => '10px 25px 10px 25px',
                    'inner-padding' => '10px 25px 10px 25px',
                    'line-height' => '120%',
                    'target' => '_blank',
                    'vertical-align' => 'middle',
                    'border' => 'none',
                    'text-align' => 'center',
                    'href' => '#',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
            6 => 
            array (
              'type' => 'advanced_footer',
              'data' => 
              array (
                'value' => 
                array (
                ),
              ),
              'attributes' => 
              array (
                'background-color' => '#FFFDED',
                'background-position' => 'center center',
                'mode' => 'fluid-height',
                'padding' => '0px 0px 0px 0px',
                'vertical-align' => 'top',
                'background-url' => '',
              ),
              'children' => 
              array (
                0 => 
                array (
                  'type' => 'advanced_social',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'elements' => 
                      array (
                        0 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAMAAAC7IEhfAAAAclBMVEUAAAA7WZg7Wpg6WZg8WJdAU586Wpg6Wpc7WZg8WZk6WZg7WZg6WZg7WZY5WJc6Wpc7WJg7WZk7W5Y6WpU7WZj////m6vKdrMvO1eW2wdhUbaWEl7+El75sgrKpt9KRosV4jbhTbqXy9fiQocVsgrFHY58FMJF5AAAAFHRSTlMAv++AIBCfQJBQ39+wcHBg0M9wMJn76TsAAAEYSURBVDjLjdTZbsMgEEDRYcziPU2LCa3rNOny/79YnESaDAaZ+2gdgQEB8JR51SLUV42CfEagpcQhw5rWRnUpKoWliMrNcGjTVdxVNlu94yhNrrFRH6G/7ewSmVr8tPZOX8wD8vWeAopgp27uwNx1IhhN3jJ4TkFU25X4Fbl5npd4N3sO3QrPNgoDtAl4snEGTBkc+aH8ej+tOe/9F4Oa/+LnRHHYgcjBC4OYh4tlcXhx7oa+nXPXGJatGkGXwSPUZVBAUwYrUKVHCKIEdgAwlkAdoMICKOmu5iHd2HYPorxDswcHeDTmIX9Uno/Hu9DPs3tREEmKu7LnTKvMe8vDATbJKjGchFRyYKNizRjvbeiPGEzb1wZY/0BgYWSlhMOpAAAAAElFTkSuQmCC',
                          'content' => '',
                        ),
                        1 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => 'data:image/png;base64,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',
                          'content' => '',
                        ),
                        2 => 
                        array (
                          'href' => '#',
                          'target' => '_blank',
                          'src' => $image_path . $twitter,
                          'content' => '',
                        ),
                      ),
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'color' => '#333333',
                    'mode' => 'horizontal',
                    'font-size' => '13px',
                    'font-weight' => 'normal',
                    'font-style' => 'normal',
                    'font-family' => 'Arial',
                    'border-radius' => '3px',
                    'padding' => '15px 0px 15px 0px',
                    'inner-padding' => '0px 20px 0px 0px',
                    'line-height' => '1.6',
                    'text-padding' => '4px 4px 4px 0px',
                    'icon-padding' => '0px',
                    'icon-size' => '25px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                1 => 
                array (
                  'type' => 'advanced_divider',
                  'data' => 
                  array (
                    'value' => 
                    array (
                    ),
                  ),
                  'attributes' => 
                  array (
                    'align' => 'center',
                    'border-width' => '1px',
                    'border-style' => 'solid',
                    'border-color' => '#D3CFD8',
                    'padding' => '0px 24px 15px 24px',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                2 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<font color="#5f6c37">{{business.name}}</font><br>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '12px 0px 0px 0px',
                    'align' => 'center',
                    'font-size' => '14px',
                    'line-height' => '20px',
                    'color' => '#908A99',
                    'font-family' => 'Arial',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                3 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<font color="#5f6c37">© 2024 {{business.name}} {{business.address}}</font>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '12px 0px 12px 0px',
                    'align' => 'center',
                    'font-size' => '14px',
                    'line-height' => '20px',
                    'color' => '#908A99',
                    'font-family' => 'Arial',
                  ),
                  'children' => 
                  array (
                  ),
                ),
                4 => 
                array (
                  'type' => 'advanced_text',
                  'data' => 
                  array (
                    'value' => 
                    array (
                      'content' => '<a href="{{link.preference}}" target="_blank" style="text-decoration: underline;"><font color="#0064ff">Update Preference</font></a> . <a href="{{link.unsubscribe}}" target="_blank" style="text-decoration: underline;"><font color="#0064ff">Unsubscribe</font></a>',
                    ),
                  ),
                  'attributes' => 
                  array (
                    'padding' => '10px 25px 20px 25px',
                    'align' => 'center',
                    'font-size' => '10px',
                    'font-family' => 'Arial',
                  ),
                  'children' => 
                  array (
                  ),
                ),
              ),
            ),
          ),
        ),
        'subTitle' => 'Nice to meet you!',
      );
    }
    
        
		if ( !empty( $templates[ 15 ] ) && empty( $templates[ 15 ][ 'json_content' ] ) ) {
			$templates[ 15 ]['json_content'] = [
                'subject' => 'Welcome to MINT CRM email',
                'subTitle' => 'Nice to meet you!',
                'content' => [
                    'type' => 'page',
                    'data' => [
                        'value' => [
                            'breakpoint' => '480px',
                            'headAttributes' => '',
                            'font-size' => '14px',
                            'line-height' => '1.7',
                            'headStyles' => [
                            ],
                            'fonts' => [
                            ],
                            'responsive' => true,
                            'font-family' => 'lucida Grande,Verdana,Microsoft YaHei',
                            'text-color' => '#000000',
                        ],
                    ],
                    'attributes' => [
                        'background-color' => '#ececec',
                        'width' => '600px',
                        'css-class' => 'mjml-body',
                    ],
                    'children' => [
                        0 => [
                            'type' => 'advanced_wrapper',
                            'data' => [
                                'value' => [
                                ],
                            ],
                            'attributes' => [
                                'background-color' => '#F5F6FB',
                                'padding' => '26px 24px 38px 24px',
                                'border' => 'none',
                                'direction' => 'ltr',
                                'text-align' => 'center',
                            ],
                            'children' => [
                                0 => [
                                    'type' => 'advanced_image',
                                    'data' => [
                                        'value' => [
                                        ],
                                    ],
                                    'attributes' => [
                                        'align' => 'center',
                                        'height' => 'auto',
                                        'padding' => '0px 0px 26px 0px',
                                        'src' => $image_path . 'your-logo.png',
                                        'width' => '100%',
                                        'href' => '#',
                                    ],
                                    'children' => [
                                    ],
                                ],
                                1 => [
                                    'type' => 'advanced_section',
                                    'data' => [
                                        'value' => [
                                            'noWrap' => false,
                                        ],
                                    ],
                                    'attributes' => [
                                        'background-color' => '#ffffff',
                                        'padding' => '40px 20px 40px 20px',
                                        'background-repeat' => 'repeat',
                                        'background-size' => 'auto',
                                        'background-position' => 'top center',
                                        'border' => 'none',
                                        'direction' => 'ltr',
                                        'text-align' => 'center',
                                    ],
                                    'children' => [
                                        0 => [
                                            'type' => 'advanced_column',
                                            'attributes' => [
                                                'width' => [
                                                    0 => '25%',
                                                    1 => '25%',
                                                    2 => '25%',
                                                    3 => '25%',
                                                ],
                                                'padding' => '0px 0px 0px 0px',
                                            ],
                                            'data' => [
                                                'value' => [
                                                ],
                                            ],
                                            'children' => [
                                                0 => [
                                                    'type' => 'advanced_text',
                                                    'data' => [
                                                        'value' => [
                                                            'content' => 'Live Events For This Week
',
                                                        ],
                                                    ],
                                                    'attributes' => [
                                                        'padding' => '0px 0px 16px 0px',
                                                        'align' => 'center',
                                                        'font-family' => 'Arial',
                                                        'font-size' => '40px',
                                                        'font-weight' => '600',
                                                        'line-height' => '1.22',
                                                        'letter-spacing' => 'normal',
                                                        'color' => '#2B2D38',
                                                    ],
                                                    'children' => [
                                                    ],
                                                ],
                                                1 => [
                                                    'type' => 'advanced_text',
                                                    'data' => [
                                                        'value' => [
                                                            'content' => 'Check out what we have in store for you!',
                                                        ],
                                                    ],
                                                    'attributes' => [
                                                        'padding' => '0px 0px 0px 0px',
                                                        'align' => 'center',
                                                        'font-family' => 'Arial',
                                                        'font-size' => '16px',
                                                        'font-weight' => '400',
                                                        'line-height' => '1.62',
                                                        'letter-spacing' => 'normal',
                                                        'color' => '#878792',
                                                    ],
                                                    'children' => [
                                                    ],
                                                ],
                                            ],
                                        ],
                                    ],
                                ],
                                2 => [
                                    'type' => 'advanced_image',
                                    'data' => [
                                        'value' => [
                                        ],
                                    ],
                                    'attributes' => [
                                        'align' => 'center',
                                        'height' => 'auto',
                                        'padding' => '0px 0px 0px 0px',
                                        'src' => $image_path. 'live-event-hero-image.png',
                                    ],
                                    'children' => [
                                    ],
                                ],
                                3 => [
                                    'type' => 'advanced_spacer',
                                    'data' => [
                                        'value' => [
                                        ],
                                    ],
                                    'attributes' => [
                                        'height' => '24px',
                                        'padding' => '   ',
                                    ],
                                    'children' => [
                                    ],
                                ],
                                4 => [
                                    'type' => 'advanced_section',
                                    'data' => [
                                        'value' => [
                                            'noWrap' => false,
                                        ],
                                    ],
                                    'attributes' => [
                                        'background-color' => '#D7D1E7',
                                        'padding' => '40px 20px 40px 20px',
                                        'background-repeat' => 'repeat',
                                        'background-size' => 'auto',
                                        'background-position' => 'top center',
                                        'border' => 'none',
                                        'direction' => 'ltr',
                                        'text-align' => 'center',
                                    ],
                                    'children' => [
                                        0 => [
                                            'type' => 'advanced_column',
                                            'attributes' => [
                                                'width' => [
                                                    0 => '25%',
                                                    1 => '25%',
                                                    2 => '25%',
                                                    3 => '25%',
                                                ],
                                                'padding' => '0px 0px 0px 0px',
                                            ],
                                            'data' => [
                                                'value' => [
                                                ],
                                            ],
                                            'children' => [
                                                0 => [
                                                    'type' => 'advanced_button',
                                                    'data' => [
                                                        'value' => [
                                                            'content' => 'Featured Event',
                                                        ],
                                                    ],
                                                    'attributes' => [
                                                        'align' => 'left',
                                                        'font-family' => 'Arial',
                                                        'background-color' => '#D7D1E7',
                                                        'color' => '#2B2D38',
                                                        'font-weight' => '600',
                                                        'font-style' => 'normal',
                                                        'border-radius' => '100px',
                                                        'padding' => '0px 0px 25px 0px',
                                                        'inner-padding' => '7px 13px 7px 13px',
                                                        'font-size' => '14px',
                                                        'line-height' => '1.2',
                                                        'target' => '_blank',
                                                        'vertical-align' => 'middle',
                                                        'border' => '1px solid #2B2D38',
                                                        'text-align' => 'center',
                                                        'letter-spacing' => 'normal',
                                                        'href' => '#',
                                                    ],
                                                    'children' => [
                                                    ],
                                                ],
                                                1 => [
                                                    'type' => 'advanced_text',
                                                    'data' => [
                                                        'value' => [
                                                            'content' => '10:00 AM (SYDNEY) .&nbsp;20 JAN 2024',
                                                        ],
                                                    ],
                                                    'attributes' => [
                                                        'padding' => '0px 0px 12px 0px',
                                                        'align' => 'left',
                                                        'font-family' => 'Arial',
                                                        'font-size' => '14px',
                                                        'font-weight' => '500',
                                                        'line-height' => '1.62',
                                                        'letter-spacing' => 'normal',
                                                        'color' => '#2B2D38',
                                                    ],
                                                    'children' => [
                                                    ],
                                                ],
                                                2 => [
                                                    'type' => 'advanced_text',
                                                    'data' => [
                                                        'value' => [
                                                            'content' => 'Becoming A Tech Leader',
                                                        ],
                                                    ],
                                                    'attributes' => [
                                                        'padding' => '0px 0px 25px 0px',
                                                        'align' => 'left',
                                                        'font-family' => 'Arial',
                                                        'font-size' => '30px',
                                                        'font-weight' => '600',
                                                        'line-height' => '1.22',
                                                        'letter-spacing' => 'normal',
                                                        'color' => '#2B2D38',
                                                    ],
                                                    'children' => [
                                                    ],
                                                ],
                                                3 => [
                                                    'type' => 'advanced_text',
                                                    'data' => [
                                                        'value' => [
                                                            'content' => 'Join the gathering of tech leaders, industry experts, and visionary CEOs who will come together for inspiration and to shape the future. Don\'t miss the opportunity to discover and be inspired by the visionaries who are leading the way.',
                                                        ],
                                                    ],
                                                    'attributes' => [
                                                        'padding' => '0px 0px 25px 0px',
                                                        'align' => 'left',
                                                        'font-family' => 'Arial',
                                                        'font-size' => '16px',
                                                        'font-weight' => '400',
                                                        'line-height' => '1.62',
                                                        'letter-spacing' => 'normal',
                                                        'color' => '#2B2D38',
                                                    ],
                                                    'children' => [
                                                    ],
                                                ],
                                                4 => [
                                                    'type' => 'advanced_button',
                                                    'data' => [
                                                        'value' => [
                                                            'content' => 'REGISTER NOW',
                                                        ],
                                                    ],
                                                    'attributes' => [
                                                        'align' => 'left',
                                                        'font-family' => 'Arial',
                                                        'background-color' => '#573BFF',
                                                        'color' => '#ffffff',
                                                        'font-weight' => '600',
                                                        'font-style' => 'normal',
                                                        'border-radius' => '100px',
                                                        'padding' => '0px 0px 0px 0px',
                                                        'inner-padding' => '17px 30px 17px 30px',
                                                        'font-size' => '15px',
                                                        'line-height' => '1.2',
                                                        'target' => '_blank',
                                                        'vertical-align' => 'middle',
                                                        'border' => 'none',
                                                        'text-align' => 'center',
                                                        'letter-spacing' => 'normal',
                                                        'href' => '#',
                                                    ],
                                                    'children' => [
                                                    ],
                                                ],
                                            ],
                                        ],
                                    ],
                                ],
                                5 => [
                                    'type' => 'advanced_divider',
                                    'data' => [
                                        'value' => [
                                        ],
                                    ],
                                    'attributes' => [
                                        'align' => 'center',
                                        'border-width' => '1px',
                                        'border-style' => 'solid',
                                        'border-color' => '#C1BCD1',
                                        'padding' => '0px 30px 0px 30px',
                                        'container-background-color' => '#D7D1E7',
                                    ],
                                    'children' => [
                                    ],
                                ],
                                6 => [
                                    'type' => 'advanced_section',
                                    'data' => [
                                        'value' => [
                                            'noWrap' => false,
                                        ],
                                    ],
                                    'attributes' => [
                                        'background-color' => '#D7D1E7',
                                        'padding' => '40px 20px 40px 20px',
                                        'background-repeat' => 'repeat',
                                        'background-size' => 'auto',
                                        'background-position' => 'top center',
                                        'border' => 'none',
                                        'direction' => 'ltr',
                                        'text-align' => 'center',
                                    ],
                                    'children' => [
                                        0 => [
                                            'type' => 'advanced_column',
                                            'attributes' => [
                                                'width' => [
                                                    0 => '25%',
                                                    1 => '25%',
                                                    2 => '25%',
                                                    3 => '25%',
                                                ],
                                                'padding' => '0px 0px 0px 0px',
                                            ],
                                            'data' => [
                                                'value' => [
                                                ],
                                            ],
                                            'children' => [
                                                0 => [
                                                    'type' => 'advanced_button',
                                                    'data' => [
                                                        'value' => [
                                                            'content' => 'Upcoming Event',
                                                        ],
                                                    ],
                                                    'attributes' => [
                                                        'align' => 'left',
                                                        'font-family' => 'Arial',
                                                        'background-color' => '#D7D1E7',
                                                        'color' => '#2B2D38',
                                                        'font-weight' => '600',
                                                        'font-style' => 'normal',
                                                        'border-radius' => '100px',
                                                        'padding' => '0px 0px 25px 0px',
                                                        'inner-padding' => '7px 13px 7px 13px',
                                                        'font-size' => '14px',
                                                        'line-height' => '1.2',
                                                        'target' => '_blank',
                                                        'vertical-align' => 'middle',
                                                        'border' => '1px solid #2B2D38',
                                                        'text-align' => 'center',
                                                        'letter-spacing' => 'normal',
                                                        'href' => '#',
                                                    ],
                                                    'children' => [
                                                    ],
                                                ],
                                                1 => [
                                                    'type' => 'advanced_text',
                                                    'data' => [
                                                        'value' => [
                                                            'content' => '10:00 AM (SYDNEY) .&nbsp;22 JAN 2024',
                                                        ],
                                                    ],
                                                    'attributes' => [
                                                        'padding' => '0px 0px 12px 0px',
                                                        'align' => 'left',
                                                        'font-family' => 'Arial',
                                                        'font-size' => '14px',
                                                        'font-weight' => '500',
                                                        'line-height' => '1.62',
                                                        'letter-spacing' => 'normal',
                                                        'color' => '#2B2D38',
                                                    ],
                                                    'children' => [
                                                    ],
                                                ],
                                                2 => [
                                                    'type' => 'advanced_text',
                                                    'data' => [
                                                        'value' => [
                                                            'content' => 'Talking About Business
',
                                                        ],
                                                    ],
                                                    'attributes' => [
                                                        'padding' => '0px 0px 25px 0px',
                                                        'align' => 'left',
                                                        'font-family' => 'Arial',
                                                        'font-size' => '30px',
                                                        'font-weight' => '600',
                                                        'line-height' => '1.22',
                                                        'letter-spacing' => 'normal',
                                                        'color' => '#2B2D38',
                                                    ],
                                                    'children' => [
                                                    ],
                                                ],
                                                3 => [
                                                    'type' => 'advanced_text',
                                                    'data' => [
                                                        'value' => [
                                                            'content' => 'Unleash your business potential at our exclusive event designed for ambitious entrepreneurs like you. Join industry business experts, gain valuable insights, and forge meaningful connections that will propel your business forward.
',
                                                        ],
                                                    ],
                                                    'attributes' => [
                                                        'padding' => '0px 0px 25px 0px',
                                                        'align' => 'left',
                                                        'font-family' => 'Arial',
                                                        'font-size' => '16px',
                                                        'font-weight' => '400',
                                                        'line-height' => '1.62',
                                                        'letter-spacing' => 'normal',
                                                        'color' => '#2B2D38',
                                                    ],
                                                    'children' => [
                                                    ],
                                                ],
                                                4 => [
                                                    'type' => 'advanced_button',
                                                    'data' => [
                                                        'value' => [
                                                            'content' => 'REGISTER FOR FREE',
                                                        ],
                                                    ],
                                                    'attributes' => [
                                                        'align' => 'left',
                                                        'font-family' => 'Arial',
                                                        'background-color' => '#573BFF',
                                                        'color' => '#ffffff',
                                                        'font-weight' => '600',
                                                        'font-style' => 'normal',
                                                        'border-radius' => '100px',
                                                        'padding' => '0px 0px 0px 0px',
                                                        'inner-padding' => '17px 30px 17px 30px',
                                                        'font-size' => '15px',
                                                        'line-height' => '1.2',
                                                        'target' => '_blank',
                                                        'vertical-align' => 'middle',
                                                        'border' => 'none',
                                                        'text-align' => 'center',
                                                        'letter-spacing' => 'normal',
                                                        'href' => '#',
                                                    ],
                                                    'children' => [
                                                    ],
                                                ],
                                            ],
                                        ],
                                    ],
                                ],
                                7 => [
                                    'type' => 'advanced_spacer',
                                    'data' => [
                                        'value' => [
                                        ],
                                    ],
                                    'attributes' => [
                                        'height' => '24px',
                                        'padding' => '   ',
                                    ],
                                    'children' => [
                                    ],
                                ],
                                8 => [
                                    'type' => 'advanced_section',
                                    'data' => [
                                        'value' => [
                                            'noWrap' => false,
                                        ],
                                    ],
                                    'attributes' => [
                                        'background-color' => '',
                                        'padding' => '0px 0px 0px 0px',
                                        'background-repeat' => 'no-repeat',
                                        'background-size' => 'auto',
                                        'background-position' => 'top center',
                                        'border' => 'none',
                                        'direction' => 'ltr',
                                        'text-align' => 'center',
                                    ],
                                    'children' => [
                                        0 => [
                                            'type' => 'advanced_column',
                                            'attributes' => [
                                                'width' => '100%',
                                                'padding' => '35px 20px 35px 20px',
                                                'vertical-align' => 'middle',
                                                'background-color' => '#232426',
                                            ],
                                            'data' => [
                                                'value' => [
                                                ],
                                            ],
                                            'children' => [
                                                0 => [
                                                    'type' => 'advanced_text',
                                                    'data' => [
                                                        'value' => [
                                                            'content' => 'Have an idea for a new event?&nbsp;<div><a href="" target="_blank" style="color: #ffffff;" tabindex="-1"><font color="#ffffff" style=""><b style="">We want to hear from you!</b></font></a></div>',
                                                        ],
                                                    ],
                                                    'attributes' => [
                                                        'padding' => '0px 25px 0px 25px',
                                                        'align' => 'center',
                                                        'font-family' => 'Arial',
                                                        'font-size' => '20px',
                                                        'font-weight' => '400',
                                                        'line-height' => '1.5',
                                                        'letter-spacing' => 'normal',
                                                        'color' => '#FFFFFFB3',
                                                        'container-background-color' => '',
      