<?php
/**
 * Class WooCommerceOrderStatusChanged
 *
 * Handles the WooCommerce "woocommerce_order_status_changed" hook.
 * This class is responsible for handling actions related to order status changes.
 *
 * @package MailMintPro\Mint\Internal\AbandonedCart
 * @since 1.5.0
 */

namespace MailMintPro\Mint\Internal\AbandonedCart\Hooks\WooCommerce;

/**
 * Class WooCommerceOrderStatusChanged
 *
 * Handles the WooCommerce "woocommerce_order_status_changed" hook.
 * This class is responsible for handling actions related to order status changes.
 */
class WooCommerceOrderStatusChanged {

	/**
	 * WooCommerceOrderStatusChanged constructor.
	 *
	 * Initializes the WooCommerceOrderStatusChanged class by setting up the action hook for "woocommerce_order_status_changed".
	 *
	 * @param string $key The key associated with the action hook.
	 *
	 * @since 1.5.0
	 */
	public function __construct( $key ) {
		add_action( $key, array( $this, 'handle_order_status_changed' ), 10, 4 );
	}

	/**
	 * Handles the action triggered by the "woocommerce_order_status_changed" hook.
	 *
	 * This method is called when the status of an order is changed.
	 * It receives the order ID, the previous status, the new status, and the order instance as parameters.
	 *
	 * @param int    $id                    The ID of the order.
	 * @param string $status_transition_from The previous status of the order.
	 * @param string $status_transition_to   The new status of the order.
	 * @param object $that                  The order instance.
	 *
	 * @since 1.5.0
	 */
	public function handle_order_status_changed( $id, $status_transition_from, $status_transition_to, $that ) {
		// Code logic to handle the action of order status change.
	}
}


