<?php
/**
 * Class AbandonedCart
 *
 * Represents the AbandonedCart class responsible for initializing and managing hooks related to abandoned carts.
 *
 * @package MailMintPro\Mint\Internal\AbandonedCart
 * @since 1.5.0
 */

namespace MailMintPro\Mint\Internal\AbandonedCart;

use MailMintPro\Mint\Internal\AbandonedCart\Scheduler\AbandonedCartRunScheduler;
use MRM\Common\MrmCommon;

/**
 * Class AbandonedCart
 *
 * Represents the AbandonedCart class responsible for initializing and managing hooks related to abandoned carts.
 */
class AbandonedCart {

	/**
	 * The hooks to be registered and their corresponding classes.
	 *
	 * @var array
	 * @since 1.5.0
	 */
	protected $wc_hooks = array(
		'woocommerce_add_to_cart'            => 'WooCommerceAddToCart',
		'woocommerce_cart_item_removed'      => 'WooCommerceCartItemRemoved',
		'woocommerce_cart_item_restored'     => 'WooCommerceCartItemRestored',
		'woocommerce_cart_item_set_quantity' => 'WooCommerceCartItemSetQuantity',
		'woocommerce_new_order'              => 'WooCommerceNewOrder',
		'woocommerce_order_status_changed'   => 'WooCommerceOrderStatusChanged',
		'mail_mint'                          => 'MailMint',
	);

	/**
	 * Constructor for the AbandonedCart class.
	 *
	 * Initializes the AbandonedCart class by iterating through the defined hooks and instantiating their corresponding classes if they exist.
	 * Each hook is associated with a specific class responsible for handling that hook's functionality.
	 *
	 * @since 1.5.0
	 */
	public function __construct() {
		if ( MrmCommon::is_wc_active() ) {
			foreach ( $this->wc_hooks as $key => $value ) {
				$class_name = 'MailMintPro\\Mint\\Internal\\AbandonedCart\\Hooks\\WooCommerce\\' . $value;
				if ( class_exists( $class_name ) ) {
					new $class_name( $key );
				}
			}
		}
		new AbandonedCartRunScheduler();
	}
}
