<?php
/**
 * Upgrade Class
 *
 * @package MailMintPro\Mint\DataBase;
 */

namespace MailMintPro\Mint\DataBase;

use MailMintPro\Mint\DataBase\Tables\WebHook;

/**
 * Upgrade Class
 *
 * @package MailMintPro\Mint\DataBase\ProUpgrade;
 */
class ProUpgrade {

	/**
	 * Check if this is a new installation for MRM plugin,
	 * or upgrade the existing one or do nothing if versions are up to date
	 *
	 * @since 1.0.0
	 */
	public function maybe_upgrade() {
		// Fresh install.
		$this->install();
	}


	/**
	 * Fresh install of MRM
	 *
	 * @since 1.0.0
	 */
	public function install() {
		// Installing schema.
		if ( $this->requires_install() ) {
			$this->flush_versions();

			$this->upgrade_schema();

			if ( defined( 'MAIL_MINT_PRO_DB_VERSION' ) ) {
				update_option( 'mail_mint_pro_db_version', MAIL_MINT_PRO_DB_VERSION, false );
			}
		}
	}

	/**
	 * Upgrades the database schema for Mail Mint Pro.
	 *
	 * @return void
	 * @since 1.0.0
	 */
	public function upgrade_schema() {
		require_once ABSPATH . '/wp-admin/includes/upgrade.php';
		global $wpdb;
		$schemas         = $this->get_db_schema();
		$charset_collate = $wpdb->get_charset_collate();

		foreach ( $schemas as $key => $schema ) {
			$table_class_name = 'MailMintPro\\Mint\\DataBase\\Tables\\' . $schema;
			$table            = new $table_class_name();
			$sql              = $table->get_sql() . $charset_collate;
			dbDelta( $sql );
		}
	}

	/**
	 * Retrieves the database schema used by the plugin.
	 *
	 * @return array An associative array of database tables, where the keys represent
	 * @since 1.4.1
	 */
	public function get_db_schema() {
		return Model::get_tables();
	}

	/**
	 * Return true if MRM needs to be install from scratch
	 *
	 * @return bool
	 * @since 1.0.0
	 */
	private function requires_install() {
		return is_null( get_option( 'mail_mint_pro_version', null ) );
	}


	/**
	 * Flushed cached version
	 *
	 * @since 1.0.0
	 */
	public function flush_versions() {
		wp_cache_delete( 'mail_mint_pro_db_version' );
		wp_cache_delete( 'mail_mint_pro_version' );
	}
}
