<?php
/**
 * [Manage contact schema]
 *
 * @desc Manage plugin's assets
 * @package /app/Database/Schemas
 * @since 1.0.0
 */

namespace MailMintPro\Mint\DataBase\Tables;

use Mint\MRM\Interfaces\Schema;

/**
 * [Manage contact schema]
 *
 * @desc Manage plugin's assets
 * @package /app/Database/Schemas
 * @since 1.0.0
 */
class WebHook implements Schema {

	/**
	 * Table name
	 *
	 * @var string
	 * @since 1.0.0
	 */
	public static $table_name = 'mint_webhooks';


	/**
	 * Get the schema of Contact table
	 *
	 * @return string
	 * @since 1.0.0
	 */
	public function get_sql() {
		global $wpdb;
		$table = $wpdb->prefix . self::$table_name;

		return "CREATE TABLE IF NOT EXISTS {$table} (
            `id` BIGINT UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT,
            `name` VARCHAR(192) NULL,
            `hash` VARCHAR(90) NULL,
            `settings` longtext,
            `topic` VARCHAR(90) NULL,            
            `failure_count` tinyint(1) NULL,
            `created_at` TIMESTAMP NULL,
            `updated_at` TIMESTAMP NULL,
             INDEX `hash_index` (`hash` ASC)
         ) ";
	}
}
