<?php
/**
 * Manage link trigger schema
 *
 * @desc Manage plugin's assets
 * @package /app/Database/Schemas
 * @since 1.15.0
 */

namespace MailMintPro\Mint\DataBase\Tables;

use Mint\MRM\Interfaces\Schema;

/**
 * Class LinkTrigger
 *
 * @desc Manage plugin's assets
 * @package /app/Database/Schemas
 * @since 1.15.0
 */
class LinkTrigger implements Schema {

	/**
	 * Link triggers table name.
	 *
	 * @var string
	 * @since 1.15.0
	 */
	public static $table_name = 'mint_link_triggers';

	/**
	 * Get the SQL statements for creating the necessary tables.
	 *
	 * @return string
	 * @since 1.15.0
	 */
	public function get_sql() {
		global $wpdb;
		$charset_collate = $wpdb->get_charset_collate();

		// Create link triggers table.
		$link_triggers_table = $wpdb->prefix . self::$table_name;
		$this->create_link_triggers_table( $link_triggers_table, $charset_collate );
	}

	/**
	 * Create link triggers table.
	 *
	 * @param string $table Table name
	 * @param string $charset_collate Charset collate
	 * @since 1.15.0
	 */
	private function create_link_triggers_table( $table, $charset_collate ) {
		$sql = $this->link_triggers_sql( $table, $charset_collate );
		dbDelta( $sql );
	}

	/**
	 * Get the SQL statements for creating the necessary tables.
	 *
	 * @param string $table Table name
	 * @param string $charset_collate Charset collate
	 * @return string
	 * @since 1.15.0
	 */
	public function link_triggers_sql( $table, $charset_collate ) {
		$sql = "CREATE TABLE IF NOT EXISTS {$table} (
            `id` BIGINT UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT,
            `title` VARCHAR(192) NOT NULL,
			`description` TEXT NULL,
            `hash` VARCHAR(90) NOT NULL,
            `status` TINYINT UNSIGNED DEFAULT 1,
            `total_clicked` BIGINT UNSIGNED DEFAULT 0,
            `data` LONGTEXT NULL,
            `created_by` BIGINT UNSIGNED DEFAULT 0,
            `created_at` TIMESTAMP NULL,
            `updated_at` TIMESTAMP NULL,
             INDEX `hash_index` (`hash` ASC)
        ) $charset_collate;";

		return $sql;
	}
}
